<?php
////////////////////////////////////////////////////////////////////////////////////////////////////
//            CLASS:  sigesp_release
//	         Access:  public
//     Programador:  Ing. Wilmer Briceï¿½
//     Description:  Clase que tiene comom funciï¿½ actualizar los nuevos campos y tablas de la base 
//                   de datos SIGESP.db
////////////////////////////////////////////////////////////////////////////////////////////////////
class sigesp_release 
{
	var $io_function;
	var $io_function_db;
	var $io_msg;
	var $io_include;
	var $io_connect;
	var $io_sql;
	
	function sigesp_release()
	{
		require_once("class_sql.php");  
		require_once("sigesp_include.php");
		require_once("class_funciones.php");
		require_once("class_mensajes.php");
		require_once("class_funciones_db.php");
		require_once("class_vistas_db.php");  
		require_once("sigesp_c_seguridad.php");
		$this->io_function=new class_funciones();	
		$this->io_msg=new class_mensajes();
		$this->io_include=new sigesp_include();
		$this->io_connect=$this->io_include->uf_conectar();
		//$this->io_connect->debug=true;
		$this->io_sql=new class_sql($this->io_connect);
		$this->io_function_db=new class_funciones_db($this->io_connect);
		$this->io_vistas_db=new class_vistas_db($this->io_connect);						
		$this->io_seguridad=new sigesp_c_seguridad();		
		$this->ls_codemp=$_SESSION["la_empresa"]["codemp"];		
	} //  end contructor

	function uf_destructor()
	{	
		unset($this->io_function);	
		unset($this->io_msg);				
		unset($this->io_include);				
		unset($this->io_connect);				
		unset($this->io_sql);	
		unset($this->io_seguridad);	
	} // end function uf_destructor

    function uf_check_update($aa_seguridad) // main()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_check_update
		//		   Access: public 
		//	  Description: chequea los updates
		//	   Creado Por: Ing. Wilmer Briceï¿½
		// Fecha Creaciï¿½: 06/07/2006 								Fecha ï¿½tima Modificaciï¿½ : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$this->io_sql->begin_transaction();	
		$ls_nro_release=""; 
		$lb_cambiado=false; 
		if ($_SESSION["ls_gestor"]=='MYSQLI') 
		{
			$_SESSION["ls_gestor"]= 'MYSQLT';
			$lb_cambiado=true;
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
		$lb_existe = $this->io_function_db->uf_select_column('sno_thclasificacionobrero','anovig');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_90 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_90();
			$ls_nro_release.=" - 2008_1_90";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_banco','codsudeban');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_91 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_91();
			$ls_nro_release.=" - 2008_1_91";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_beneficiario','nexben');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_92 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_92();
			$ls_nro_release.=" - 2008_1_92";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','tipopers');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_93 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_93();
			$ls_nro_release.=" - 2008_1_93";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','enviorec');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_94 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_94();
			$ls_nro_release.=" - 2008_1_94";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_beneficiario','cedaut');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_95 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_95();
			$ls_nro_release.=" - 2008_1_95";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','fecfevid');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_96 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_96();
			$ls_nro_release.=" - 2008_1_96";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estretiva');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_97 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_97();
			$ls_nro_release.=" - 2008_1_97";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_documento','tipodocanti');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_98 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_1_98();
			$ls_nro_release.=" - 2008_1_98";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_categoria_rango');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_1_99 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_1_99();
			$ls_nro_release.=" - 2008_1_99";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_rango','codcat');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_00 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_00();
			$ls_nro_release.=" - 2008_2_00";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_departamento','minorguniadm');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_01();
			$ls_nro_release.=" - 2008_2_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_movimiento_personal','minorguniadm');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_02();
			$ls_nro_release.=" - 2008_2_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_movimiento_personal','codunivi');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_03();
			$ls_nro_release.=" - 2008_2_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','fechentdesde');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_04();
			$ls_nro_release.=" - 2008_2_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','informa');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_05();
			$ls_nro_release.=" - 2008_2_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','informa');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_06();
			$ls_nro_release.=" - 2008_2_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','informa');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_07();
			$ls_nro_release.=" - 2008_2_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('srh_dt_ganadores_concurso','srh_dt_ganadores_concurso_pkey');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_2_08 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_08();
			$ls_nro_release.=" - 2008_2_08";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','divcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_09 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_09();
			$ls_nro_release.=" - 2008_2_09";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','quirepcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_10 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_10();
			$ls_nro_release.=" - 2008_2_10";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		$lb_existe = $this->io_function_db->uf_select_column('sno_salida','priquisal');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_11 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_11();
			$ls_nro_release.=" - 2008_2_11";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','fecleypen');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_12 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_12();
			$ls_nro_release.=" - 2008_2_12";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('srh_dt_cargo','srh_dt_cargo_codemp_fkey');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_2_13 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_13();
			$ls_nro_release.=" - 2008_2_13";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('srh_dt_cargo','FK_srh_dt_cargo_2');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_2_14 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_14();
			$ls_nro_release.=" - 2008_2_14";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_contratos','codcar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_15 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_15();
			$ls_nro_release.=" - 2008_2_15";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_contratos','codcar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_15_1 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_15_1();
			$ls_nro_release.=" - 2008_2_15_1";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_puntuacion_bono_merito','nompunt');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_16 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_16();
			$ls_nro_release.=" - 2008_2_16";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sss_permisos_internos_grupos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_17"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_17();
			$ls_nro_release.=" - 2008_2_17";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_derechos_grupos','codintper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_18"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_18();
			$ls_nro_release.=" - 2008_2_18";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_defcontrato');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_19 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_19();
			$ls_nro_release.=" - 2008_2_19";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_premiacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_20 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_20();
			$ls_nro_release.=" - 2008_2_20";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_llamada_atencion','causa');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_21 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_21();
			$ls_nro_release.=" - 2008_2_21";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_rd_amortizacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_22 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_22();
			$ls_nro_release.=" - 2008_2_22";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_dt_amortizacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_23 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_23();
			$ls_nro_release.=" - 2008_2_23";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','descasicar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_24 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_24();
			$ls_nro_release.=" - 2008_2_24";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_programacionreporte','numcarf');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_25 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_25();
			$ls_nro_release.=" - 2008_2_25";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_permiso','tothorper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_26 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_26();
			$ls_nro_release.=" - 2008_2_26";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','ubigeoact');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_27 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_27();
			$ls_nro_release.=" - 2008_2_27";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','clactacon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_28 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_28();
			$ls_nro_release.=" - 2008_2_28";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_clasificador_rd','sc_cuenta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_29 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_29();
			$ls_nro_release.=" - 2008_2_29";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('srh_premiacion','srh_premiacion_pkey');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_2_30 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_30();
			$ls_nro_release.=" - 2008_2_30";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estempcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_31 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_31();
			$ls_nro_release.=" - 2008_2_31";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_hmovimiento_personal');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_32 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_32();
			$ls_nro_release.=" - 2008_2_32";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_causales');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_33 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_33();
			$ls_nro_release.=" - 2008_2_33";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','codcausa');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_34 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_34();
			$ls_nro_release.=" - 2008_2_34";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_consolidacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_35 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_35();
			$ls_nro_release.=" - 2008_2_35";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_metodobanco','nroref');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_36 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_36();
			$ls_nro_release.=" - 2008_2_36";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scg_cuentas_consolida');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_37 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_37();
			$ls_nro_release.=" - 2008_2_37";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scg_saldos_consolida');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_38 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_38();
			$ls_nro_release.=" - 2008_2_38";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_contratos','apeper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_39 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_39();
			$ls_nro_release.=" - 2008_2_39";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep1','estint');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_40 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_40();
			$ls_nro_release.=" - 2008_2_40";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_bono_merito','codpun');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_41 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_41();
			$ls_nro_release.=" - 2008_2_41";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_puntosunitri');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_42 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_42();
			$ls_nro_release.=" - 2008_2_42";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_dt_puntosunitri');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_43 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_43();
			$ls_nro_release.=" - 2008_2_43";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','asifidper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_44 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_44();
			$ls_nro_release.=" - 2008_2_44";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','asifidper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_45 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_45();
			$ls_nro_release.=" - 2008_2_45";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','asifidper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_46 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_46();
			$ls_nro_release.=" - 2008_2_46";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_bono_merito','codtipper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_47 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_47();
			$ls_nro_release.=" - 2008_2_47";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','basdatcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_48 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_48();
			$ls_nro_release.=" - 2008_2_48";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','coddep');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_49 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_49();
			$ls_nro_release.=" - 2008_2_49";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalnomina','coddep');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_50 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_50();
			$ls_nro_release.=" - 2008_2_50";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalnomina','coddep');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_51 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_51();
			$ls_nro_release.=" - 2008_2_51";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_cuentas','scgctaint');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_52 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_52();
			$ls_nro_release.=" - 2008_2_52";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcamemp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_53 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_53();
			$ls_nro_release.=" - 2008_2_53";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_scg_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_54 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_54();
			$ls_nro_release.=" - 2008_2_54";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_proc_cons');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_55 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_55();
			$ls_nro_release.=" - 2008_2_55";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_dt_proc_cons');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_56 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_56();
			$ls_nro_release.=" - 2008_2_56";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_asignacioncargo','grado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_57 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_57();
			$ls_nro_release.=" - 2008_2_57";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hasignacioncargo','grado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_58 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_58();
			$ls_nro_release.=" - 2008_2_58";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thasignacioncargo','grado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_59 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_59();
			$ls_nro_release.=" - 2008_2_59";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scg_casa_presu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_60 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_60();
			$ls_nro_release.=" - 2008_2_60";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estparsindis');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_61 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_61();
			$ls_nro_release.=" - 2008_2_61";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','basdatcmp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_62 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_62();
			$ls_nro_release.=" - 2008_2_62";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_depreciacion_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_63 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_63();
			$ls_nro_release.=" - 2008_2_63";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_dt_scg_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_64 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_64();
			$ls_nro_release.=" - 2008_2_64";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_cmp_islr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_65 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_65();
			$ls_nro_release.=" - 2008_2_65";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_dt_cmp_islr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_66 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_66();
			$ls_nro_release.=" - 2008_2_66";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":				
				$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','prompun','double');
			
			 break;

			case "MYSQLI":				
				$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','prompun','double');
			
			 break;
				   
			case "POSTGRES":
				$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','prompun','double precision');
								
			break;  				  
		}	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_67 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_67();
			$ls_nro_release.=" - 2008_2_67";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		switch($_SESSION["ls_gestor"])
	    {
			case "MYSQLT":					
				$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','unitri','double');			
			 break;

			case "MYSQLI":					
				$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','unitri','double');			
			 break;
				   
			case "POSTGRES":
					$lb_existe=$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','unitri','double precision');								
			break;  				  
		}		
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_68 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_68();
			$ls_nro_release.=" - 2008_2_68";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_cmp_ret','basdatori');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_69 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_69();
			$ls_nro_release.=" - 2008_2_69";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/* $lb_existe =$this->io_function_db->uf_select_vista('cierre_contableaportes_contable');	
		 if (!$lb_existe)
		 {
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_70 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_70();
			$ls_nro_release.=" - 2008_2_70";   
		 }*/
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dt_cmp_islr','codded');		 
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_2_71 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_71();
			$ls_nro_release.=" - 2008_2_71";   
		}		
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','nombenalt');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_72 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_72();
			$ls_nro_release.=" - 2008_2_72";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_tiposolicitud','estayueco');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_73 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_73();
			$ls_nro_release.=" - 2008_2_73";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','esttrfcmp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_74 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_74();
			$ls_nro_release.=" - 2008_2_74";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','situacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_75 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_75();
			$ls_nro_release.=" - 2008_2_75";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','tipsepbie');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_76 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_76();
			$ls_nro_release.=" - 2008_2_76";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_sol_cotizacion','tipsolbie');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_77 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_77();
			$ls_nro_release.=" - 2008_2_77";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','tipbieordcom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_78 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_78();
			$ls_nro_release.=" - 2008_2_78";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estciespg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_79 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_79();
			$ls_nro_release.=" - 2008_2_79";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_ctrl_numero','estcompscg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_80 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_80();
			$ls_nro_release.=" - 2008_2_80";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','confinstr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_81 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_81();
			$ls_nro_release.=" - 2008_2_81";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scg_pc_reporte','saldo_real_ant');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_82 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_82();
			$ls_nro_release.=" - 2008_2_82";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estintcred');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_83 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_83();
			$ls_nro_release.=" - 2008_2_83";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spi','desmov','longtext');		
			 break;

			case "MYSQLI":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spi','desmov','longtext');		
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spi','desmov','text');
				   								
			break;  				  
	    }	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_84 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_84();
			$ls_nro_release.=" - 2008_2_84";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','coduniadm');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_85 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_85();
			$ls_nro_release.=" - 2008_2_85";   
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','fecsitu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_86 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_86();
			$ls_nro_release.=" - 2008_2_86";   
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','talcamper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_87 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_87();
			$ls_nro_release.=" - 2008_2_87";   
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estciescg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_88 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_88();
			$ls_nro_release.=" - 2008_2_88";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_plan_unico_re','status');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_89 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_89();
			$ls_nro_release.=" - 2008_2_89";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_scg_int','codestpro1');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_90 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_90();
			$ls_nro_release.=" - 2008_2_90";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_articulo','estact');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_91 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_91();
			$ls_nro_release.=" - 2008_2_91";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','anoservprecont');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_92 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_92();
			$ls_nro_release.=" - 2008_2_92";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalpension','tipjub');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_93 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_93();
			$ls_nro_release.=" - 2008_2_93";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalpension','tipjub');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_94 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_94();
			$ls_nro_release.=" - 2008_2_94";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalpension','tipjub');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_95 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_95();
			$ls_nro_release.=" - 2008_2_95";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','anoservprefijo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_96 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_96();
			$ls_nro_release.=" - 2008_2_96";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_tipoarticulo','tipart');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_97 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_97();
			$ls_nro_release.=" - 2008_2_97";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','estact');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_98 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_98();
			$ls_nro_release.=" - 2008_2_98";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spgop','desmov','longtext');		
			 break;

			case "MYSQLI":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spgop','desmov','longtext');		
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spgop','desmov','text');
				   								
			break;  				  
	    }	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_2_99 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_2_99();
			$ls_nro_release.=" - 2008_2_99";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_valuacion','estgenrd');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_00 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_00();
			$ls_nro_release.=" - 2008_3_00";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sob_documento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_01();
			$ls_nro_release.=" - 2008_3_01";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','ctaspgced');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_02();
			$ls_nro_release.=" - 2008_3_02";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano=$this->io_function_db->uf_tamano_type_columna('saf_conservacionbien','codconbie');
		if ($tamano=="1")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_03();
			$ls_nro_release.=" - 2008_3_03";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_scg_inter');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_04();
			$ls_nro_release.=" - 2008_3_04";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('scg_cuentas_consolida','fk_scg_cuentas_consolida_scg_cuentas');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_3_05 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_05();
			$ls_nro_release.=" - 2008_3_05";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('scg_saldos_consolida','pk_scg_saldos_consolida');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_3_06 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_06();
			$ls_nro_release.=" - 2008_3_06";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/*	$lb_existe = $this->io_function_db->uf_select_table('sps_anticipos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_07();
			$ls_nro_release.=" - 2008_3_07";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_antiguedad');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_08 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_08();
			$ls_nro_release.=" - 2008_3_08";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_articulos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_09 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_09();
			$ls_nro_release.=" - 2008_3_09";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_carta_anticipos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_10 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_10();
			$ls_nro_release.=" - 2008_3_10";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_causaretiro');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_11 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_11();
			$ls_nro_release.=" - 2008_3_11";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_configuracion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_12 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_12();
			$ls_nro_release.=" - 2008_3_12";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_deuda_anterior');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_13 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_13();
			$ls_nro_release.=" - 2008_3_13";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_dt_liquidacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_14 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_14();
			$ls_nro_release.=" - 2008_3_14";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_dt_scg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_15 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_15();
			$ls_nro_release.=" - 2008_3_15";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_dt_spg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_16 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_16();
			$ls_nro_release.=" - 2008_3_16";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_liquidacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_17 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_17();
			$ls_nro_release.=" - 2008_3_17";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_sueldos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_18 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_18();
			$ls_nro_release.=" - 2008_3_18";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sps_tasa_interes');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_19 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_19();
			$ls_nro_release.=" - 2008_3_19";   
		}*/
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano1=$this->io_function_db->uf_tamano_type_columna('scb_cheques','orden');
		if ($tamano1=="2")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_20 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_20();
			$ls_nro_release.=" - 2008_3_20";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_cheques','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_21 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_21();
			$ls_nro_release.=" - 2008_3_21";   
		}
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_persona_concurso');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_22 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_22();
			$ls_nro_release.=" - 2008_3_22";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_concursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_23 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_23();
			$ls_nro_release.=" - 2008_3_23";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $lb_existe = $this->io_function_db->uf_select_table('srh_estudiosconcursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_24 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_24();
			$ls_nro_release.=" - 2008_3_24";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_cursosconcursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_25 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_25();
			$ls_nro_release.=" - 2008_3_25";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_trabajosconcursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_26 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_26();
			$ls_nro_release.=" - 2008_3_26";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_familiaresconcursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_27 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_27();
			$ls_nro_release.=" - 2008_3_27";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_requisitosconcursante');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_28 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_28();
			$ls_nro_release.=" - 2008_3_28";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_requisitos_concurso');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_29 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_29();
			$ls_nro_release.=" - 2008_3_29";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_colocacion','ced_bene');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_30 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_30();
			$ls_nro_release.=" - 2008_3_30";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','estcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_31 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_31();
			$ls_nro_release.=" - 2008_3_31";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_solicitudcargos','numsol');	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_32 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_32();
			$ls_nro_release.=" - 2008_3_32";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estmodpartsoc');	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_33 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_33();
			$ls_nro_release.=" - 2008_3_33";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$tamano_sps=$this->io_function_db->uf_tamano_type_columna('sps_dt_spg','codestpro5');
		if ($tamano_sps=="2")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_34 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_34();
			$ls_nro_release.=" - 2008_3_34";   
		}*/
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_organigrama');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_35 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_35();
			$ls_nro_release.=" - 2008_3_35";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','codorg');	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_36 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_36();
			$ls_nro_release.=" - 2008_3_36";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_dt_colocacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_37 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_37();
			$ls_nro_release.=" - 2008_3_37";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_activo','tipinm');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_38 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_38();
			$ls_nro_release.=" - 2008_3_38";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_edificios');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_39 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_39();
			$ls_nro_release.=" - 2008_3_39";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_tipoestructura');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_40 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_40();
			$ls_nro_release.=" - 2008_3_40";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_componente');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_41 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_41();
			$ls_nro_release.=" - 2008_3_41";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_edificiotipest');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_42 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_42();
			$ls_nro_release.=" - 2008_3_42";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estmanant');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_43 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_43();
			$ls_nro_release.=" - 2008_3_43";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('scv_tarifas','fk_scv_tari_scv_regio_scv_regi');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_3_44 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_44();
			$ls_nro_release.=" - 2008_3_44";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spi_cuentas_estructuras');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_45 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_45();
			$ls_nro_release.=" - 2008_3_45";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estpreing');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_46 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_46();
			$ls_nro_release.=" - 2008_3_46";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_archivotxt','acumon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_47 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_47();
			$ls_nro_release.=" - 2008_3_47";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_cuentas_estructuras','previsto');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_48 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_48();
			$ls_nro_release.=" - 2008_3_48";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','concommun');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_49 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_49();
			$ls_nro_release.=" - 2008_3_49";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estant');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_50 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_50();
			$ls_nro_release.=" - 2008_3_50";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_movbco_anticipo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_51 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_51();
			$ls_nro_release.=" - 2008_3_51";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('scv_rutas','ak_key_2_scv_ruta');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_3_52 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_52();
			$ls_nro_release.=" - 2008_3_52";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_segmento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_53 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_53();
			$ls_nro_release.=" - 2008_3_53";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_familia');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_54 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_54();
			$ls_nro_release.=" - 2008_3_54";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_clase');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_55 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_55();
			$ls_nro_release.=" - 2008_3_55";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_producto');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_56 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_56();
			$ls_nro_release.=" - 2008_3_56";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_articulo','codprod');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_57 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_57();
			$ls_nro_release.=" - 2008_3_57";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano1=$this->io_function_db->uf_tamano_type_columna('sigesp_ctrl_numero','codusu');
		if ($tamano1=="10")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_58 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_58();
			$ls_nro_release.=" - 2008_3_58";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_spi','estcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_59 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_59();
			$ls_nro_release.=" - 2008_3_59";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano1=$this->io_function_db->uf_tamano_type_columna('saf_activo','codrot');
		if ($tamano1=="1")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_60 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_60();
			$ls_nro_release.=" - 2008_3_60";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_acta','nomresact');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_61 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_61();
			$ls_nro_release.=" - 2008_3_61";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_anticipo','sc_cuenta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_62 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_62();
			$ls_nro_release.=" - 2008_3_62";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_tipounidad','tipper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_63 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_63();
			$ls_nro_release.=" - 2008_3_63";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','retaposol');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_64 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_64();
			$ls_nro_release.=" - 2008_3_64";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','monamo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_65 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_65();
			$ls_nro_release.=" - 2008_3_65";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideicomiso','conpreant');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_66 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_66();
			$ls_nro_release.=" - 2008_3_66";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','diapervac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_67 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_67();
			$ls_nro_release.=" - 2008_3_67";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','confiva');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_68 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_68();
			$ls_nro_release.=" - 2008_3_68";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','pagpersal');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_69 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_69();
			$ls_nro_release.=" - 2008_3_69";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_dt_personal','codnom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_70 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_70();
			$ls_nro_release.=" - 2008_3_70";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spi','estcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_71 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_71();
			$ls_nro_release.=" - 2008_3_71";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_dt_cmp','estcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_72 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_72();
			$ls_nro_release.=" - 2008_3_72";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_dtmp_cmp','estcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_73 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_73();
			$ls_nro_release.=" - 2008_3_73";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_codigounicorac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_74 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_74();
			$ls_nro_release.=" - 2008_3_74";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hcodigounicorac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_75 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_75();
			$ls_nro_release.=" - 2008_3_75";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thcodigounicorac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_76 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_76();
			$ls_nro_release.=" - 2008_3_76";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano2=$this->io_function_db->uf_tamano_type_columna('sno_asignacioncargo','claasicar'); 
		if ($tamano2=="5")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_77 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_77();
			$ls_nro_release.=" - 2008_3_77";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_variacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_78 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_78();
			$ls_nro_release.=" - 2008_3_78";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scg_confvariacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_79 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_79();
			$ls_nro_release.=" - 2008_3_79";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_dt_fuentefinanciamiento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_80 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_80();
			$ls_nro_release.=" - 2008_3_80";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="oci8po") {
	   		$lb_existe = $this->io_function_db->uf_select_table('spg_cuenta_fuentefinan');			
		}
		else {
			$lb_existe = $this->io_function_db->uf_select_table('spg_cuenta_fuentefinanciamiento');
		}
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_81 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_81();
			$ls_nro_release.=" - 2008_3_81";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','codfuefin');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_82 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_82();
			$ls_nro_release.=" - 2008_3_82";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_dt_spg','codfuefin');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_83 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_83();
			$ls_nro_release.=" - 2008_3_83";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_casamientoconcepto');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_84 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_84();
			$ls_nro_release.=" - 2008_3_84";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','casconmov');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_85 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_85();
			$ls_nro_release.=" - 2008_3_85";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_tipomodificacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_86 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_86();
			$ls_nro_release.=" - 2008_3_86";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep3','estreradi');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_87 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_87();
			$ls_nro_release.=" - 2008_3_87";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_dc_cargos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_88 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_88();
			$ls_nro_release.=" - 2008_3_88";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_dt_odi','cododi');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_89 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_89();
			$ls_nro_release.=" - 2008_3_89";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_dt_revisiones_odi','cododi');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_90 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_90();
			$ls_nro_release.=" - 2008_3_90";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_evaluacion_odi','cododi');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_91 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_91();
			$ls_nro_release.=" - 2008_3_91";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','porcajahoper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_92 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_92();
			$ls_nro_release.=" - 2008_3_92";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiar','hijesp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_93 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_93();
			$ls_nro_release.=" - 2008_3_93";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','estrenfon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_94 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_94();
			$ls_nro_release.=" - 2008_3_94";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','codfuefin');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_95 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_95();
			$ls_nro_release.=" - 2008_3_95";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','persalnor');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_96 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_96();
			$ls_nro_release.=" - 2008_3_96";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','persalnor');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_97 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_97();
			$ls_nro_release.=" - 2008_3_97";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','persalnor');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_98 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_98();
			$ls_nro_release.=" - 2008_3_98";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','salnorper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_3_99 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_3_99();
			$ls_nro_release.=" - 2008_3_99";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalnomina','salnorper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_00 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_00();
			$ls_nro_release.=" - 2008_4_00";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalnomina','salnorper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_01();
			$ls_nro_release.=" - 2008_4_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_sol_dc','moncar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_02();
			$ls_nro_release.=" - 2008_4_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','imamon');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_03();
			$ls_nro_release.=" - 2008_4_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','tascamaux');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_04();
			$ls_nro_release.=" - 2008_4_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','tascam');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_05();
			$ls_nro_release.=" - 2008_4_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_dt_moneda');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_06();
			$ls_nro_release.=" - 2008_4_06";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_autsalida');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_07();
			$ls_nro_release.=" - 2008_4_07";   
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_entrega');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_08 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_08();
			$ls_nro_release.=" - 2008_4_08";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_dt_entrega');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_09 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_09();
			$ls_nro_release.=" - 2008_4_09";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_prestamo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_10"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_10();
			$ls_nro_release.=" - 2008_4_10";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dta','estactpre');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_11 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_11();
			$ls_nro_release.=" - 2008_4_11";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dta','codunipre');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_12 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_12();
			$ls_nro_release.=" - 2008_4_12";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_cuentas_estructuras','enero');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_13 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_13();
			$ls_nro_release.=" - 2008_4_13";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_cestaticket','mondesdia');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_14 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_14();
			$ls_nro_release.=" - 2008_4_14";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spg','codfuefin');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_15 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_15();
			$ls_nro_release.=" - 2008_4_15";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_table('sno_tfuentefinanciamiento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_16"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_16();
			$ls_nro_release.=" - 2008_4_16";   
		}*/
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_constante','esttopmod');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_17 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_17();
			$ls_nro_release.=" - 2008_4_17";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconstante','esttopmod');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_18 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_18();
			$ls_nro_release.=" - 2008_4_18";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconstante','esttopmod');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_19 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_19();
			$ls_nro_release.=" - 2008_4_19";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_constantepersonal','montopcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_20 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_20();
			$ls_nro_release.=" - 2008_4_20";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconstantepersonal','montopcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_21 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_21();
			$ls_nro_release.=" - 2008_4_21";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconstantepersonal','montopcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_22 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_22();
			$ls_nro_release.=" - 2008_4_22";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$valor=$this->uf_buscar_unidad();
		if ($valor==0)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_23 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_23();
			$ls_nro_release.=" - 2008_4_23";   
		}	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$valor1=$this->uf_buscar_sep_solicitud();
		if ($valor1==0)
		{
			$this->io_msg->message(utf8_encode(" Release Version 4_24 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_4_24();
			$ls_nro_release.=" - 2008_4_24";   
		}	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estmodprog');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_25 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_25();
			$ls_nro_release.=" - 2008_4_25";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CXP','RELEASE','4_26');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_26 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_26();
			$ls_nro_release.=" - 2008_4_26";   
		}
 	    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('saf_activo','fk_saf_activo__saf_item');
		if ($lb_existe)
	    {
			 $this->io_msg->message(utf8_encode(" Release Version 2008_4_27 "));	
			 $lb_valido=$this->uf_create_release_db_libre_V_2008_4_27();
			$ls_nro_release.=" - 2008_4_27";   
	    }
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp_md','codtipmodpre');
		if (!$lb_existe)
	    {
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_28 "));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_28();
			$ls_nro_release.=" - 2008_4_28";   
	    }
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','confi_ch');
		if (!$lb_existe)
	    {
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_29 "));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_29();
			$ls_nro_release.=" - 2008_4_29";   
	    }		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano1=$this->io_function_db->uf_tamano_type_columna('spg_ministerio_ua','denuac');
		if ($tamano1=="60")
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_30"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_30();
			$ls_nro_release.=" - 2008_4_30";   
	    }		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano2=$this->io_function_db->uf_tamano_type_columna('spg_unidadadministrativa','denuniadm');
		if ($tamano2=="100")
		{ 
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_31"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_31();
   		   $ls_nro_release.=" - 2008_4_31";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_correo');
		if (!$lb_existe)
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_32"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_32();
			$ls_nro_release.=" - 2008_4_32";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_correo','msjremitente');
		if (!$lb_existe)
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_33"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_33();
		   $ls_nro_release.=" - 2008_4_33";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valor1=$this->uf_buscar_spg_dt_fuentefinaciamiento();
        if ($lb_valor1==0)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_34"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_34();
			$ls_nro_release.=" - 2008_4_34";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valor=$this->uf_buscar_spg_cuenta_fuentefinanciamiento();
        if ($lb_valor==0)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_35"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_35();
			$ls_nro_release.=" - 2008_4_35";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('spg_dtmp_cmp','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_36"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_36();
			$ls_nro_release.=" - 2008_4_36";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('spg_dt_cmp','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_37"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_37();
			$ls_nro_release.=" - 2008_4_37";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=$this->uf_buscar_codigo();
		if ($lb_existe=="1")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_38"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_38();
			$ls_nro_release.=" - 2008_4_38";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=$this->uf_buscar_codigo_cons();
		if ($lb_existe=="1")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_39"));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_39();
			$ls_nro_release.=" - 2008_4_39";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_rd');
		if (!$lb_existe)
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_40"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_40();
			$ls_nro_release.=" - 2008_4_40";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('sno_rd','fk_sno_rd->scg_cuentas');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_41"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_41();
			$ls_nro_release.=" - 2008_4_41";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','recdocpagperche');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_42"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_42();
			$ls_nro_release.=" - 2008_4_42";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','recdocpagperche');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_43"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_43();
			$ls_nro_release.=" - 2008_4_43";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','recdocpagperche');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_44"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_44();
			$ls_nro_release.=" - 2008_4_44";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_encargaduria');
		if (!$lb_existe)
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_45"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_45();
			$ls_nro_release.=" - 2008_4_45";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('sno_encargaduria','fk_sno_encargaduria__sno_personalnomina');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_46"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_46();
			$ls_nro_release.=" - 2008_4_46";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','aplresenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_47"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_47();
			$ls_nro_release.=" - 2008_4_47";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','aplresenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_48"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_48();
			$ls_nro_release.=" - 2008_4_48";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','aplresenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_49"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_49();
			$ls_nro_release.=" - 2008_4_49";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_constante','conperenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_50"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_50();
			$ls_nro_release.=" - 2008_4_50";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconstante','conperenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_51"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_51();
			$ls_nro_release.=" - 2008_4_51";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconstante','conperenc');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_52"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_52();
			$ls_nro_release.=" - 2008_4_52";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','estencper');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_53"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_53();
			$ls_nro_release.=" - 2008_4_53";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalnomina','estencper');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_54"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_54();
			$ls_nro_release.=" - 2008_4_54";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalnomina','estencper');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_55"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_55();
			$ls_nro_release.=" - 2008_4_55";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hencargaduria');
		if (!$lb_existe)
		{
		   $this->io_msg->message(utf8_encode(" Release Version 2008_4_56"));	
		   $lb_valido=$this->uf_create_release_db_libre_V_2008_4_56();
			$ls_nro_release.=" - 2008_4_56";   
	    }
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thencargaduria');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_57"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_57();
			$ls_nro_release.=" - 2008_4_57";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','estapesolpag');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_58"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_58();
			$ls_nro_release.=" - 2008_4_58";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_59"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_59();
			$ls_nro_release.=" - 2008_4_59";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep3','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_60"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_60();
			$ls_nro_release.=" - 2008_4_60";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep5','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_61"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_61();
			$ls_nro_release.=" - 2008_4_61";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideicomiso','porintcap');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_62"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_62();
			$ls_nro_release.=" - 2008_4_62";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			$lb_valido=$this->uf_estructura_fuente_financiamiento();
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dt_servicio','codfuefin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_63"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_63();
			$ls_nro_release.=" - 2008_4_63";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spg','spg_codemp');
	    if($lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_64"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_64();
			$ls_nro_release.=" - 2008_4_64";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','estctaalt');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_65"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_65();
			$ls_nro_release.=" - 2008_4_65";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','estctaalt');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_66"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_66();
			$ls_nro_release.=" - 2008_4_66";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','estctaalt');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_67"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_67();
			$ls_nro_release.=" - 2008_4_67";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_tipofondo');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_68"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_68();
			$ls_nro_release.=" - 2008_4_68";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','numordpagmin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_69"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_69();
			$ls_nro_release.=" - 2008_4_69";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','numordpagmin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_70"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_70();
			$ls_nro_release.=" - 2008_4_70";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_regmodprogramado');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_71"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_71();
			$ls_nro_release.=" - 2008_4_71";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_servicios','codunimed');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2008_4_72"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_72();
			$ls_nro_release.=" - 2008_4_72";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sep_solicitud','consol');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sep_solicitud','consol',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="500")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2008_4_73 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2008_4_73();
			$ls_nro_release.=" - 2008_4_73";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 		    
			$lb_valido = $this->uf_create_release_insert_sigesp_procedencias();
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{  		  
			$lb_valido = $this->uf_cambiar_tipo_data();
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			$lb_valido=$this->insertar_activos();
		}
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			$lb_valido=$this->uf_saf_rotulacion();
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{
			$lb_valido=true;//$this->uf_update_plan_unico_re();
		}
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			$lb_valido=$this->uf_saf_producto();
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($lb_valido)
		{ 
			$lb_valido=$this->uf_cfg_moneda();
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($lb_valido)
		{
			$lb_valido=$this->uf_cfg_dt_moneda();
		}
		///////////////////////////////////////////////////////////////
		//Iniciado el 20/02/2009 a las 09:16am, por Ing. Néstor Falcon.
		///////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_constantepersonal','conperenc');
	    if($lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_01"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_01();
			$ls_nro_release.=" - 2009_2_01";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','codtipfon');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_02"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_02();
			$ls_nro_release.=" - 2009_2_02";   
		}		
		$lb_existe = $this->io_function_db->uf_select_table('scb_fondosavance');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_03"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_03();
			$ls_nro_release.=" - 2009_2_03";   
		}		
		$lb_existe = $this->io_function_db->uf_select_table('scb_dt_fondosavance');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_04"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_04();
			$ls_nro_release.=" - 2009_2_04";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('scb_ctabanco','ctaserext');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_05();
			$ls_nro_release.=" - 2009_2_05";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','numordpagmin');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_06();
			$ls_nro_release.=" - 2009_2_06";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','codtipfon');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_07"));
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_07();
			$ls_nro_release.=" - 2009_2_07";   
		}	
		if($lb_valido)
		{
		  $this->io_msg->message(utf8_encode(" Release Version 2009_2_08"));
		  $lb_valido=$this->uf_create_release_db_libre_V_2009_2_08();
			$ls_nro_release.=" - 2009_2_08";   
		}
        $lb_existe = $this->io_function_db->uf_select_constraint('sno_conceptopersonal','pk_sno_conceptopersonal');
	    if($lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_09"));
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_09();
			$ls_nro_release.=" - 2009_2_09";   
		}
		/* $lb_existe =$this->io_function_db->uf_select_vista('calculo_conceptospersonal');	
		 if (!$lb_existe)
		 {
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_35();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2009_2_10");
			}	   			
			$ls_nro_release.=" - 2009_2_10";   
		 }
		 $lb_existe =$this->io_function_db->uf_select_vista('calculo_personal');	
		 if (!$lb_existe)
		 {
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_36();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2009_2_11");
			}	   			
			$ls_nro_release.=" - 2009_2_11";   
		 }
		 $lb_existe =$this->io_function_db->uf_select_vista('calculo_personaltabulador');	
		 if (!$lb_existe)
		 {
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_37();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2009_2_12");
			}	   			
			$ls_nro_release.=" - 2009_2_12";   
		 }*/
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','codente');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_13"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_13();
			$ls_nro_release.=" - 2009_2_13";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','codente');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_14"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_14();
			$ls_nro_release.=" - 2009_2_14";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','codente');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_15"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_15();
			$ls_nro_release.=" - 2009_2_15";   
		}		
		$lb_existe = $this->io_function_db->uf_select_table('sno_entes');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_16"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_16();
			$ls_nro_release.=" - 2009_2_16";   
		}
		$lb_existe = $this->io_function_db->uf_select_index("sno_conceptopersonal","index_conceptopersonal_1");
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_17"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_17();
			$ls_nro_release.=" - 2009_2_17";   
		}
		$lb_existe = $this->io_function_db->uf_select_index("sno_conceptopersonal","index_conceptopersonal_2");
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_18"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_18();
			$ls_nro_release.=" - 2009_2_18";   
		}
        $lb_existe=$this->io_function_db->uf_select_type_columna('sep_solicitud','consol','varchar');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_19"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_19();
			$ls_nro_release.=" - 2009_2_19";   
		}
		$lb_existe=$this->io_function_db->uf_select_type_columna('soc_ordencompra','obscom','varchar');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_20"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_20();
			$ls_nro_release.=" - 2009_2_20";   
		}
		$lb_existe=$this->io_function_db->uf_select_type_columna('soc_ordencompra','obsordcom','varchar');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_21"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_21();
			$ls_nro_release.=" - 2009_2_21";   
		}
		$lb_existe=$this->io_function_db->uf_select_type_columna('cxp_rd','dencondoc','varchar');		
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_2_22"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_2_22();
			$ls_nro_release.=" - 2009_2_22";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiar','estbonjug');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_23"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_23();
			$ls_nro_release.=" - 2009_3_23";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','codtipfon');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_24"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_24();
			$ls_nro_release.=" - 2009_3_24";   
		}		
		$lb_existe = $this->io_function_db->uf_select_table('srh_gerencia');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_25"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_25();
			$ls_nro_release.=" - 2009_3_25";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','anoperobr');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_26"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_26();
			$ls_nro_release.=" - 2009_3_26";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','codger');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_27"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_27();
			$ls_nro_release.=" - 2009_3_27";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('srh_departamento','codger');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_28"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_28();
			$ls_nro_release.=" - 2009_3_28";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_beneficiario','numexpben');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_29"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_29();
			$ls_nro_release.=" - 2009_3_29";   
		}
	  /* switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":				
				$lb_existe=$this->io_function_db->uf_select_type_columna('sss_registro_eventos','fecevetra','timestamp');
			
			 break;
				   
			case "POSTGRES":
				$lb_existe=$this->io_function_db->uf_select_type_columna('sss_registro_eventos','fecevetra','DATETIME');
								
			break;  				  
		}	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_3_30 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_30();
			$ls_nro_release.=" - 2009_3_30";   
		}*/
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','carantper');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_31"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_31();
			$ls_nro_release.=" - 2009_3_31";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_personaldeduccion','coddettipded');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_32"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_32();
			$ls_nro_release.=" - 2009_3_32";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiardeduccion','coddettipded');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_33"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_33();
			$ls_nro_release.=" - 2009_3_33";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','abrmon');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_34"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_34();
			$ls_nro_release.=" - 2009_3_34";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estserext');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_35"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_35();
			$ls_nro_release.=" - 2009_3_35";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_primasdocentes');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_36"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_36();
			$ls_nro_release.=" - 2009_3_36";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_primadocentepersonal');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_37"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_37();
			$ls_nro_release.=" - 2009_3_37";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hprimasdocentes');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_38"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_38();
			$ls_nro_release.=" - 2009_3_38";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hprimadocentepersonal');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_39"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_39();
			$ls_nro_release.=" - 2009_3_39";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thprimasdocentes');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_40"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_40();
			$ls_nro_release.=" - 2009_3_40";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thprimadocentepersonal');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_41"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_41();
			$ls_nro_release.=" - 2009_3_41";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','3_42');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode("Release Version 2009_3_42 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_42();
			$ls_nro_release.=" - 2009_3_42";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dta_cargos','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_43 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_43();
			$ls_nro_release.=" - 2009_3_43";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dts_cargos','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_44 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_44();
			$ls_nro_release.=" - 2009_3_44";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SOC','RELEASE','3_45_1');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_45 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_45();
			$ls_nro_release.=" - 2009_3_45";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SOC','RELEASE','3_46_1');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_46 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_46();
			$ls_nro_release.=" - 2009_3_46";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('rpc_proveedor','tipperpro');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_47 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_47();
			$ls_nro_release.=" - 2009_3_47";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('rpc_deduxprov');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_48"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_48();
			$ls_nro_release.=" - 2009_3_48";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('rpc_deduxbene');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_49"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_49();
			$ls_nro_release.=" - 2009_3_49";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_dta_cargos','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_50 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_50();
			$ls_nro_release.=" - 2009_3_50";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_dts_cargos','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_51 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_51();
			$ls_nro_release.=" - 2009_3_51";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_dtc_cargos','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_3_52 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_3_52();
			$ls_nro_release.=" - 2009_3_52";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SCB','RELEASE','4_01');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_01();
			$ls_nro_release.=" - 2009_4_01";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    	$lb_existe = $this->uf_select_config('SCB','RELEASE','4_02');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_02();
			$ls_nro_release.=" - 2009_4_02";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','ctaresact');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_03 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_03();
			$ls_nro_release.=" - 2009_4_03";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','ctaresant');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_04 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_04();
			$ls_nro_release.=" - 2009_4_04";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estvaldisfin');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_05 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_05();
			$ls_nro_release.=" - 2009_4_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SEP','RELEASE','4_06');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_06 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_06();
			$ls_nro_release.=" - 2009_4_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SEP','RELEASE','4_07');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_07 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_07();
			$ls_nro_release.=" - 2009_4_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SEP','RELEASE','4_08');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_08 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_08();
			$ls_nro_release.=" - 2009_4_08";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','dedconproben');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_09 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_09();
			$ls_nro_release.=" - 2009_4_09";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scg_pc_reporte','eneroaux');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_10 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_10();
			$ls_nro_release.=" - 2009_4_10";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','4_11');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode("Release Version 2009_4_11 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_11();
			$ls_nro_release.=" - 2009_4_11";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','4_12');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode("Release Version 2009_4_12 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_12();
			$ls_nro_release.=" - 2009_4_12";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_consolidacion','codestpro2');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_13 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_13();
			$ls_nro_release.=" - 2009_4_13";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_consolidacion','codestpro3');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_14 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_14();
			$ls_nro_release.=" - 2009_4_14";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_consolidacion','codestpro4');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_15 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_15();
			$ls_nro_release.=" - 2009_4_15";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_consolidacion','codestpro5');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_16 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_16();
			$ls_nro_release.=" - 2009_4_16";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $lb_existe =$this->io_function_db->uf_select_type_columna('sigesp_consolidacion','estcla','varchar');					
			 break;
				   
			case "MYSQLI":
				   $lb_existe =$this->io_function_db->uf_select_type_columna('sigesp_consolidacion','estcla','varchar');					
			 break;
				   
			case "POSTGRES":
				 $lb_existe =$this->io_function_db->uf_select_type_columna('sigesp_consolidacion','estcla','character varying');   								
			break;  				  
		}
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_17 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_17();
			$ls_nro_release.=" - 2009_4_17";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_18');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_18 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_18();
			$ls_nro_release.=" - 2009_4_18";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_19');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_19 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_19();
			$ls_nro_release.=" - 2009_4_19";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_dtmp_mensual','codemp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_20 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_20();
			$ls_nro_release.=" - 2009_4_20";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_dtmp_mensual','codemp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_21 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_21();
			$ls_nro_release.=" - 2009_4_21";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiar','cedula');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_22 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_22();
			$ls_nro_release.=" - 2009_4_22";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estaprsep');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_23 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_23();
			$ls_nro_release.=" - 2009_4_23";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','sujpasesp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_24 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_24();
			$ls_nro_release.=" - 2009_4_24";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_conceptoretencion','codemp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_25 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_25();
			$ls_nro_release.=" - 2009_4_25";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','codconret');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_26 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_26();
			$ls_nro_release.=" - 2009_4_26";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','rifper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_27 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_27();
			$ls_nro_release.=" - 2009_4_27";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalisr','codconret');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_28 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_28();
			$ls_nro_release.=" - 2009_4_28";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','bloanu');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_29 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_29();
			$ls_nro_release.=" - 2009_4_29";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','calpagvac');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_30 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_30();
			$ls_nro_release.=" - 2009_4_30";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','codusu');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_31 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_31();
			$ls_nro_release.=" - 2009_4_31";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_variacioncontrato','estapr');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_32 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_32();
			$ls_nro_release.=" - 2009_4_32";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SAF','RELEASE','4_33');//$this->io_function_db->uf_select_constraint('saf_contable','pk_saf_contable');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_33 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_33();
			$ls_nro_release.=" - 2009_4_33";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estmovcob');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_34 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_34();
			$ls_nro_release.=" - 2009_4_34";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','racobrnom');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_35 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_35();
			$ls_nro_release.=" - 2009_4_35";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','racobrnom');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_36 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_36();
			$ls_nro_release.=" - 2009_4_36";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','racobrnom');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_37 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_37();
			$ls_nro_release.=" - 2009_4_37";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_acta','civinsact');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_38 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_38();
			$ls_nro_release.=" - 2009_4_38";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_valuacion','fechaconta');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_39 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_39();
			$ls_nro_release.=" - 2009_4_39";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_anticipo','fechaconta');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_40 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_40();
			$ls_nro_release.=" - 2009_4_40";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','tipcmp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode("Release Version 2009_7_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_7_01();
			$ls_nro_release.=" - 2009_7_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','numcmp');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_7_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_7_02();
			$ls_nro_release.=" - 2009_7_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','estmov');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_7_03"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_7_03();
			$ls_nro_release.=" - 2009_7_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','obsrecper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_41 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_41();
			$ls_nro_release.=" - 2009_4_41";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalnomina','obsrecper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_42 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_42();
			$ls_nro_release.=" - 2009_4_42";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalnomina','obsrecper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_43 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_43();
			$ls_nro_release.=" - 2009_4_43";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_covenin','codcoven');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_44 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_44();
			$ls_nro_release.=" - 2009_4_44";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estretmil');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_45 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_45();
			$ls_nro_release.=" - 2009_4_45";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','estretmil');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_46 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_46();
			$ls_nro_release.=" - 2009_4_46";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','numdocori');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_47 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_47();
			$ls_nro_release.=" - 2009_4_47";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_48');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_48 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_48();
			$ls_nro_release.=" - 2009_4_48";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','contintmovban');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_49 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_49();
			$ls_nro_release.=" - 2009_4_49";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','valinimovban');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_50 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_50();
			$ls_nro_release.=" - 2009_4_50";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_48');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_51 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_51();
			$ls_nro_release.=" - 2009_4_48";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_48');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_51 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_51();
			$ls_nro_release.=" - 2009_4_48";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_52');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_52 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_52();
			$ls_nro_release.=" - 2009_4_52";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_4_53');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_53 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_53();
			$ls_nro_release.=" - 2009_4_53";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_propietario','rifpro');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_54 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_54();
			$ls_nro_release.=" - 2009_4_54";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','numconint');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_55 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_55();
			$ls_nro_release.=" - 2009_4_55";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_jubilados');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_56"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_56();
			$ls_nro_release.=" - 2009_4_56";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','profueper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_57 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_57();
			$ls_nro_release.=" - 2009_4_57";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_guarderias');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_58"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_58();
			$ls_nro_release.=" - 2009_4_58";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','calpagvac');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_59 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_59();
			$ls_nro_release.=" - 2009_4_59";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thvacacpersonal','calpagvac');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_60 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_60();
			$ls_nro_release.=" - 2009_4_60";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_recepcion','estapr');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_61 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_61();
			$ls_nro_release.=" - 2009_4_61";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','codtipdoc');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_62 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_62();
			$ls_nro_release.=" - 2009_4_62";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','guarrepcon');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_63 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_63();
			$ls_nro_release.=" - 2009_4_63";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','guarrepcon');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_64 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_64();
			$ls_nro_release.=" - 2009_4_64";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','guarrepcon');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_65 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_65();
			$ls_nro_release.=" - 2009_4_65";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','profueper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_66 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_66();
			$ls_nro_release.=" - 2009_4_57";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thvacacpersonal','profueper');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_67 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_67();
			$ls_nro_release.=" - 2009_4_57";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_colocacion','sc_cuentacob');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_68 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_68();
			$ls_nro_release.=" - 2009_4_68";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_colocacion','codestpro1');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_4_69 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_4_69();
			if ($lb_valido)
			{
				$lb_valido=$this->uf_create_release_db_libre_V_2009_4_70();
			}
			$ls_nro_release.=" - 2009_4_69";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_cotizacion','diavalofe');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009 10 01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_10_01();
			$ls_nro_release.=" - 2009_10_01";   
		}		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('soc_analisicotizacion','estasitec');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009 10 02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_10_02();
			$ls_nro_release.=" - 2009_10_01";   
		}		*/
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2009_10_03');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2009_10_03 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_10_03();
			$ls_nro_release.=" - 2009_10_03";   
		}
        
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estintban');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_01();
			$ls_nro_release.=" - 2009_12_01";   
		}		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_sucursales');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_02();
			$ls_nro_release.=" - 2009_12_02";   
		}		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','codusureg');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2009 12 03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2009_12_03();
            $ls_nro_release.=" - 2009_12_03";   
        }        
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estapribs');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_04 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_04();
			$ls_nro_release.=" - 2009_12_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estxmlibs');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_05 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_05();
			$ls_nro_release.=" - 2009_12_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sob_cuentavaluacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_06 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_06();
			$ls_nro_release.=" - 2009_12_06";   
		}		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_variacioncontrato','fecapr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2009_12_07 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2009_12_07();
			$ls_nro_release.=" - 2009_12_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_cotizacion','estasitec');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2009_12_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2009_12_08();
            $ls_nro_release.=" - 2009_12_08";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','cueproacu');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_01();
            $ls_nro_release.=" - 2010_01_01";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scg_cuentas','cueproacu');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_02();
            $ls_nro_release.=" - 2010_01_02";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('soc_dt_bienes','fk_soc_dt_bienes__spg_cuenta_fuentefinancimiento');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_03 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_03();
			$ls_nro_release.=" - 2010_01_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('soc_dt_servicio','fk_soc_dt_servicio__spg_cuenta_fuentefinancimiento');
		if ($lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_04 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_04();
			$ls_nro_release.=" - 2010_01_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->uf_select_config('SNO','RELEASE','01_05_10');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_05 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_05();
			$ls_nro_release.=" - 2010_01_05";   
		}*/
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','01_06_10');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_06 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_06();
			$ls_nro_release.=" - 2010_01_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('sno_personalnomina','anovig');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_07 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_07();
			$ls_nro_release.=" - 2010_01_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hpersonalnomina','anovig');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_08 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_08();
			$ls_nro_release.=" - 2010_01_08";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thpersonalnomina','anovig');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_09 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_09();
			$ls_nro_release.=" - 2010_01_09";   
		}*/
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','01_10_10');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_10 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_10();
			$ls_nro_release.=" - 2010_01_10";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$tamano1=$this->io_function_db->uf_tamano_type_columna('sno_nomina','codorgcestic');
		if ($tamano1=="4")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_01_11 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_11();
			$ls_nro_release.=" - 2010_01_11";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','01_10_12');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_12 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_12();
			$ls_nro_release.=" - 2010_01_12";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->uf_select_config('SNO','RELEASE','01_10_13');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_01_13 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_01_13();
			$ls_nro_release.=" - 2010_01_13";   
		}*/
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_movimiento_personal','horact');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_13 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_13();
            $ls_nro_release.=" - 2010_01_13";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_hmovimiento_personal','horact');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_14 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_14();
            $ls_nro_release.=" - 2010_01_14";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','aplidiasadd');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_15 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_15();
            $ls_nro_release.=" - 2010_01_15";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','aplidiasadd');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_16 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_16();
            $ls_nro_release.=" - 2010_01_16";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','aplidiasadd');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_17 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_17();
            $ls_nro_release.=" - 2010_01_17";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_tabulador','tabmed');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_18 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_18();
            $ls_nro_release.=" - 2010_01_18";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_htabulador','tabmed');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_19 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_19();
            $ls_nro_release.=" - 2010_01_19";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thtabulador','tabmed');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_20 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_20();
            $ls_nro_release.=" - 2010_01_20";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_grado','aniodes');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_21 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_21();
            $ls_nro_release.=" - 2010_01_21";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hgrado','aniodes');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_22 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_22();
            $ls_nro_release.=" - 2010_01_22";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thgrado','aniodes');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_23 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_23();
            $ls_nro_release.=" - 2010_01_23";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','valclacon');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_24 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_24();
            $ls_nro_release.=" - 2010_01_24";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','valcomrd');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_25 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_25();
            $ls_nro_release.=" - 2010_01_25";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','ctaejeprecie');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_26 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_26();
            $ls_nro_release.=" - 2010_01_26";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $lb_existe = $this->io_function_db->uf_select_column('siv_articulo','estartgen');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_27 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_27();
            $ls_nro_release.=" - 2010_01_26";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estaprsoc');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_28 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_28();
            $ls_nro_release.=" - 2010_01_28";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','scforden_h');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_29 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_29();
            $ls_nro_release.=" - 2010_01_29";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_componente','nomabr');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_30 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_30();
            $ls_nro_release.=" - 2010_01_30 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_rango','nomabr');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_01_31 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_01_31();
            $ls_nro_release.=" - 2010_01_31 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_tipo_pensionado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_04_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_04_01();
			$ls_nro_release.=" - 2010_04_01";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','codper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_04_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_04_02();
            $ls_nro_release.=" - 2010_04_02 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','codperi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_04_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_04_03();
            $ls_nro_release.=" - 2010_04_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','tipnip');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_04_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_04_04();
            $ls_nro_release.=" - 2010_04_04 ";   
        }  		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_constraint('sss_registro_eventos','unk_sss_registro_eventos');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_04_05 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_04_05();
			$ls_nro_release.=" - 2010_04_05";   
		}*/
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','tranoreglib');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_04_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_04_06();
            $ls_nro_release.=" - 2010_04_06 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_autsalida','ced_bene');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_05_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_05_01();
            $ls_nro_release.=" - 2010_05_01 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2010_05_02');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_05_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_05_02();
			$ls_nro_release.=" - 2010_05_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cargos','tipo_iva');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_05_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_05_03();
            $ls_nro_release.=" - 2010_05_03 ";   
        }                 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','repcajchi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_05_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_05_04();
            $ls_nro_release.=" - 2010_05_04 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','repcajchi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_05_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_05_05();
            $ls_nro_release.=" - 2010_05_05 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2010_06_01');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_06_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_06_01();
			$ls_nro_release.=" - 2010_06_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','gerantper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_02();
            $ls_nro_release.=" - 2010_06_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','messervpreper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_03();
            $ls_nro_release.=" - 2010_06_03 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_asignacioncargo','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_04();
            $ls_nro_release.=" - 2010_06_04 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hasignacioncargo','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_05();
            $ls_nro_release.=" - 2010_06_05 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thasignacioncargo','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_06();
            $ls_nro_release.=" - 2010_06_06 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_07();
            $ls_nro_release.=" - 2010_06_07 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_08();
            $ls_nro_release.=" - 2010_06_08 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_09();
            $ls_nro_release.=" - 2010_06_09 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_proyecto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_10();
            $ls_nro_release.=" - 2010_06_10 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hproyecto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_11 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_11();
            $ls_nro_release.=" - 2010_06_11 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thproyecto','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_12 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_12();
            $ls_nro_release.=" - 2010_06_12 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_unidadadmin','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_13 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_13();
            $ls_nro_release.=" - 2010_06_13 ";   
        } 
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hunidadadmin','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_14 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_14();
            $ls_nro_release.=" - 2010_06_14 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thunidadadmin','codestpro1');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_15 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_15();
            $ls_nro_release.=" - 2010_06_15 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('sps_liquidacion','diaabofid');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_16 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_16();
            $ls_nro_release.=" - 2010_06_16 ";   
        } */ 		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_tipo_aspecto');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_06_17 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_06_17();
			$ls_nro_release.=" - 2010_06_17";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_evaluacion_contratado_obrero');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_06_18 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_06_18();
			$ls_nro_release.=" - 2010_06_18";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('srh_dt_evaluacion_contratado_obrero');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_06_19 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_06_19();
			$ls_nro_release.=" - 2010_06_19";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('srh_evaluacion_contratado_obrero','codcon');
        if ($lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_06_20 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_06_20();
            $ls_nro_release.=" - 2010_06_20 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','codusu');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_01();
            $ls_nro_release.=" - 2010_07_01 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2010_07_02');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2010_07_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2010_07_02();
			$ls_nro_release.=" - 2010_07_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','estcondoc');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_03();
            $ls_nro_release.=" - 2010_07_03 ";   
        }
		/////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2010_07_04');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_04();
            $ls_nro_release.=" - 2010_07_04 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','repcajchi');
        if ($lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_05();
            $ls_nro_release.=" - 2010_07_05 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','repcajchi');
        if ($lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_06();
            $ls_nro_release.=" - 2010_07_06 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_valuacion','numrecdoc');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_07_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_07_07();
            $ls_nro_release.=" - 2010_07_06 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','fecenvfir');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_01();
            $ls_nro_release.=" - 2010_08_01 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_analisicotizacion','recanacot');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_02();
            $ls_nro_release.=" - 2010_08_02 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		$lb_existe = $this->io_function_db->uf_select_column('scg_pc_reporte','saldo_real_ant_enero');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_03();
            $ls_nro_release.=" - 2010_08_03 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','repcajchi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_04();
            $ls_nro_release.=" - 2010_08_04";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dc_spi','codemp');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_05();
            $ls_nro_release.=" - 2010_08_05";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('sps_articulos','estpro');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_08_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_08_06();
            $ls_nro_release.=" - 2010_08_06";   
        } */ 		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_dt_articulos','canartorg');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_09_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_09_01();
            $ls_nro_release.=" - 2010_09_01";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_table('sps_articuloscuentas');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_09_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_09_02();
			$ls_nro_release.=" - 2010_09_02";   
		}*/
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('sps_dt_liquidacion','id_art');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_09_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_09_03();
            $ls_nro_release.=" - 2010_09_03";   
        }  		*/
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_obra','monimp');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_09_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_09_04();
            $ls_nro_release.=" - 2010_09_04";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_scg','codper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_01();
            $ls_nro_release.=" - 2010_10_01";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estafenc');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_02();
            $ls_nro_release.=" - 2010_10_02";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_fideiintereses');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_10_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_10_03();
			$ls_nro_release.=" - 2010_10_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dc_spg','procede_doc');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_04();
            $ls_nro_release.=" - 2010_10_04";   
        }  		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_fideiperiodointereses');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_10_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_10_05();
			$ls_nro_release.=" - 2010_10_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideicomiso','scg_cuentafid');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_10_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_10_06();
			$ls_nro_release.=" - 2010_10_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_periodo','fidintconper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_07();
            $ls_nro_release.=" - 2010_10_07 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hperiodo','fidintconper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_08();
            $ls_nro_release.=" - 2010_10_08 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thperiodo','fidintconper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_09();
            $ls_nro_release.=" - 2010_10_09 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideiperiodointereses','monantacu');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_10();
            $ls_nro_release.=" - 2010_10_10 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_permisos_internos','enabled');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_10_11 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_10_11();
            $ls_nro_release.=" - 2010_10_11 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','nomliq');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_11_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_11_01();
            $ls_nro_release.=" - 2010_11_01 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','nomliq');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_11_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_11_02();
            $ls_nro_release.=" - 2010_11_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','nomliq');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_11_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_11_03();
            $ls_nro_release.=" - 2010_11_03 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_sueldoshistoricos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_11_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_11_04();
			$ls_nro_release.=" - 2010_11_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_deudaanterior');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_11_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_11_05();
			$ls_nro_release.=" - 2010_11_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_sueldoshistoricos','codded');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_11_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_11_06();
            $ls_nro_release.=" - 2010_11_06 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_anticipoprestaciones');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2010_11_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2010_11_07();
			$ls_nro_release.=" - 2010_11_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dta','fecincmod');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_12_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_12_01();
            $ls_nro_release.=" - 2010_12_01 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','blocon');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_12_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_12_02();
            $ls_nro_release.=" - 2010_12_02 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','capiva');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2010_12_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2010_12_03();
            $ls_nro_release.=" - 2010_12_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('rpc_proveedor','ageviapro');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_01();
            $ls_nro_release.=" - 2011_01_01 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_catsudeban');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_02();
			$ls_nro_release.=" - 2011_01_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_activo','codcat');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_03();
            $ls_nro_release.=" - 2011_01_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cargos','spi_cuenta');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_04();
            $ls_nro_release.=" - 2011_01_04 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_diaferiado','tipfer');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_05();
            $ls_nro_release.=" - 2011_01_05 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideicomiso','calintfid');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_06();
            $ls_nro_release.=" - 2011_01_06 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','codproalt');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_07();
            $ls_nro_release.=" - 2011_01_07 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_horario');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_08 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_08();
			$ls_nro_release.=" - 2011_01_08";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hhorario');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_09 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_09();
			$ls_nro_release.=" - 2011_01_09";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thhorario');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_10 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_10();
			$ls_nro_release.=" - 2011_01_10";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hojatiempo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_11 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_11();
			$ls_nro_release.=" - 2011_01_11";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_hhojatiempo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_12 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_12();
			$ls_nro_release.=" - 2011_01_12";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_thhojatiempo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_01_13 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_01_13();
			$ls_nro_release.=" - 2011_01_13";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','hojtienom');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_14 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_14();
            $ls_nro_release.=" - 2011_01_14 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','hojtienom');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_15 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_15();
            $ls_nro_release.=" - 2011_01_15 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','hojtienom');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_16 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_16();
            $ls_nro_release.=" - 2011_01_16 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep1','estcencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_01_17 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_01_17();
            $ls_nro_release.=" - 2011_01_17 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estciesem');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_02_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_02_01();
            $ls_nro_release.=" - 2011_02_01 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','cestiksuel');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_02_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_02_02();
            $ls_nro_release.=" - 2011_02_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','cestiksuel');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_02_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_02_03();
            $ls_nro_release.=" - 2011_02_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','cestiksuel');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_02_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_02_04();
            $ls_nro_release.=" - 2011_02_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_spg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_02_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_02_05();
			$ls_nro_release.=" - 2011_02_05";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estceniva');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_02_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_02_06();
            $ls_nro_release.=" - 2011_02_06 ";   
        }  		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('scb_cmp_ret','dirsujret');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scb_cmp_ret','dirsujret',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="200")
		{
            $this->io_msg->message(utf8_encode(" Release Version 2011_03_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_03_01();
            $ls_nro_release.=" - 2011_03_01 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estspgdecimal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_03_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_03_02();
            $ls_nro_release.=" - 2011_03_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('scb_cmp_ret','nomsujret');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scb_cmp_ret','nomsujret',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="80")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_03_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_03_03();
            $ls_nro_release.=" - 2011_03_03 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','nivapro');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_03_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_03_04();
            $ls_nro_release.=" - 2011_03_04 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_nivel');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_04_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_04_01();
			$ls_nro_release.=" - 2011_04_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_asig_nivel');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_04_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_04_02();
			$ls_nro_release.=" - 2011_04_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_dt_unidadadministrativa','central');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_04_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_03();
            $ls_nro_release.=" - 2011_04_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp_md','esttrares');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_04_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_04();
            $ls_nro_release.=" - 2011_04_04 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sob_obra','codobr');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sob_obra','codobr',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="6")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_04_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_05();
            $ls_nro_release.=" - 2011_04_05 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sss_niv_usuarios');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_04_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_04_06();
			$ls_nro_release.=" - 2011_04_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sob_partidaobra','codobr');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sob_partidaobra','codobr',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="6")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_04_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_07();
            $ls_nro_release.=" - 2011_04_07 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sob_acta','codcon');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sob_acta','codcon',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		
		if ($tamano=="12")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_04_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_08();
            $ls_nro_release.=" - 2011_04_08 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','envcorsup');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_04_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_09();
            $ls_nro_release.=" - 2011_04_09 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_niv_usuarios','codasiniv');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_04_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_04_10();
            $ls_nro_release.=" - 2011_04_10 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_valuacion','poramo');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_05_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_01();
            $ls_nro_release.=" - 2011_05_01 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcomobr');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_05_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_02();
            $ls_nro_release.=" - 2011_05_02 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SAF','RELEASE','2011_05_17');
        if (!$lb_existe) 
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_05_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_03();
            $ls_nro_release.=" - 2011_05_03 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_articulo','lote');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_05_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_04();
            $ls_nro_release.=" - 2011_05_04 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sob_variacionpartida','codasi');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sob_variacionpartida','codasi',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="6")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_05_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_05();
            $ls_nro_release.=" - 2011_05_05 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('scv_solicitudviatico','obssolvia');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scv_solicitudviatico','obssolvia',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_05_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_05_06();
            $ls_nro_release.=" - 2011_05_06 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sob_foto','codobr');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sob_foto','codobr',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="6")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_06_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_06_01();
            $ls_nro_release.=" - 2011_06_01 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','repcajchi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_06_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_06_02();
            $ls_nro_release.=" - 2011_06_02 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_tipopersonal','tipperobr');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_06_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_06_03();
            $ls_nro_release.=" - 2011_06_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','conanusep');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_01();
            $ls_nro_release.=" - 2011_07_01 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','conanusoc');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_02();
            $ls_nro_release.=" - 2011_07_02 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','conanurd');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_03();
            $ls_nro_release.=" - 2011_07_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','conanusol');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_04();
            $ls_nro_release.=" - 2011_07_04 ";   
        }

		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','estint');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_05();
            $ls_nro_release.=" - 2011_07_05 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estbenalt');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_06();
            $ls_nro_release.=" - 2011_07_06 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','numrefcarord');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_07();
            $ls_nro_release.=" - 2011_07_07 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','nombenaltcre');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_07_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_08();
            $ls_nro_release.=" - 2011_07_07 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('soc_clausulas','dencla');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('soc_clausulas','dencla',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2011_07_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_07_09();
            $ls_nro_release.=" - 2011_07_09 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_ubicacionfisica','tietras');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_01();
            $ls_nro_release.=" - 2011_08_01 ";   
        }  		
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','02_08_11');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2011_08_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2011_08_02();
			$ls_nro_release.=" - 2011_08_02";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('spg_cuentas','sc_cuenta_art');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_03();
            $ls_nro_release.=" - 2011_08_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spg','estaprfid');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_04();
            $ls_nro_release.=" - 2011_08_04 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spi','estaprfid');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_05();
            $ls_nro_release.=" - 2011_08_05 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_scg','estaprfid');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_06();
            $ls_nro_release.=" - 2011_08_06 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('cxp_documento','tipdocdon');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_07();
            $ls_nro_release.=" - 2011_08_07 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estretislr');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_08_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_08_08();
            $ls_nro_release.=" - 2011_08_08 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_variacioncontrato','fechaconta');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2011_08_09 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2011_08_09();
			$ls_nro_release.=" - 2011_08_09";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_01();
            $ls_nro_release.=" - 2011_09_01 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','inicencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_02();
            $ls_nro_release.=" - 2011_09_02 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','fincencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_03();
            $ls_nro_release.=" - 2011_09_03 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_cencosto');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_09_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_09_04();
			$ls_nro_release.=" - 2011_09_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','cencosact');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_05();
            $ls_nro_release.=" - 2011_09_05 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_almacen','codcencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_06();
            $ls_nro_release.=" - 2011_09_06 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_articulo','sc_cuentainv');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_09_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_09_07();
            $ls_nro_release.=" - 2011_09_06 ";   
        }  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dta','codresant');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_10_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_10_01();
            $ls_nro_release.=" - 2011_10_01 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_transferencia_scg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2011_10_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2011_10_02();
			$ls_nro_release.=" - 2011_10_02";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('MIS','RELEASE','2011_11_01');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2011_11_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2011_11_01();
			$ls_nro_release.=" - 2011_11_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep3','codcencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_02();
            $ls_nro_release.=" - 2011_11_02 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_ep5','codcencos');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_03();
            $ls_nro_release.=" - 2011_11_03 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_tablavacacion','diavaccal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_04();
            $ls_nro_release.=" - 2011_11_04 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','diavaccal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_05();
            $ls_nro_release.=" - 2011_11_05 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','diavaccal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_06();
            $ls_nro_release.=" - 2011_11_06 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thvacacpersonal','diavaccal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_07();
            $ls_nro_release.=" - 2011_11_07 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','candiaadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_08();
            $ls_nro_release.=" - 2011_11_08 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','candiaadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_09();
            $ls_nro_release.=" - 2011_11_09 ";   
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thvacacpersonal','candiaadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2011_11_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2011_11_10();
            $ls_nro_release.=" - 2011_11_10 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2011_12_01');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2011_12_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2011_12_01();
			$ls_nro_release.=" - 2011_12_01";   
		}
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_01_01');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_01_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_01_01();
			$ls_nro_release.=" - 2012_01_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_01_02');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_01_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_01_02();
			$ls_nro_release.=" - 2012_01_02";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sno_sueintegral');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2012_02_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2012_02_01();
			$ls_nro_release.=" - 2012_02_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('srh_dt_solicitud_adiestramiento','carper');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('srh_dt_solicitud_adiestramiento','carper',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="15")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_02_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_02_02();
            $ls_nro_release.=" - 2012_02_02 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('srh_dt_solicitud_adiestramiento','dep');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('srh_dt_solicitud_adiestramiento','dep',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="15")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_02_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_02_03();
            $ls_nro_release.=" - 2012_02_03 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_plantillacuentareporte','saldo_apro');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_02_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_02_04();
            $ls_nro_release.=" - 2012_02_04 ";   
        }
		//uf_create_release_db_libre_V_2012_02_04
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_sueintegral','bonvac');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_03_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_01();
            $ls_nro_release.=" - 2012_03_01 ";   
        }
		//uf_create_release_db_libre_V_2012_03_01
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcossig');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_03_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_02();
            $ls_nro_release.=" - 2012_03_02 ";   
        }
		//uf_create_release_db_libre_V_2012_03_01
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('spg_ep1','denestpro1');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('spg_ep1','denestpro1',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_03();
            $ls_nro_release.=" - 2012_03_03 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('spg_ep2','denestpro2');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('spg_ep2','denestpro2',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_04();
            $ls_nro_release.=" - 2012_03_04 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('spg_ep3','denestpro3');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('spg_ep3','denestpro3',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_05();
            $ls_nro_release.=" - 2012_03_05 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('spg_ep4','denestpro4');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('spg_ep4','denestpro4',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_06();
            $ls_nro_release.=" - 2012_03_06 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('spg_ep5','denestpro5');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('spg_ep5','denestpro5',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="254")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_07();
            $ls_nro_release.=" - 2012_03_07 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_activo','expediente');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_03_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_08();
            $ls_nro_release.=" - 2012_03_08 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('sno_profesion','codpro');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('sno_profesion','codpro',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="3")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2012_03_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_09();
            $ls_nro_release.=" - 2012_03_09 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','preaviso');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_03_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_03_10();
            $ls_nro_release.=" - 2012_03_10 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_11');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_11 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_11();
			$ls_nro_release.=" - 2012_03_11";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($lb_valido)
		{
			if ($_SESSION["ls_gestor"]=="POSTGRES")
			{
				$tamano=$this->io_function_db->uf_tamano_type_columna('sno_asignacioncargo','codasicar');
			}
			else
			{
				$as_valor1=0;
				$as_valor2=0;
				$as_valor3=0;
				$as_valor4=0;
				$this->io_function_db->uf_tamano_type_columna_Mysql('sno_asignacioncargo','codasicar',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
				$tamano=$as_valor1;
			}
			if ($tamano=="7")
			{
			   $this->io_msg->message(utf8_encode(" Release Version 2012_03_12 "));    
				$lb_valido=$this->uf_create_release_db_libre_V_2012_03_12();
				$ls_nro_release.=" - 2012_03_12 ";   
			}
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_13');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_13 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_13();
			$ls_nro_release.=" - 2012_03_13";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_14');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_14 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_14();
			$ls_nro_release.=" - 2012_03_14";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_15');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_15 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_15();
			$ls_nro_release.=" - 2012_03_15";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_16');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_16 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_16();
			$ls_nro_release.=" - 2012_03_16";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SNO','RELEASE','2012_03_17');
		if ((!$lb_existe)&&($lb_valido))
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_03_17 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_03_17();
			$ls_nro_release.=" - 2012_03_17";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($lb_valido)
		{
			if ($_SESSION["ls_gestor"]=="POSTGRES")
			{
				$tamano=$this->io_function_db->uf_tamano_type_columna('srh_concursante','codpro');
			}
			else
			{
				$as_valor1=0;
				$as_valor2=0;
				$as_valor3=0;
				$as_valor4=0;
				$this->io_function_db->uf_tamano_type_columna_Mysql('srh_concursante','codpro',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
				$tamano=$as_valor1;
			}
			if ($tamano=="3")
			{
			   $this->io_msg->message(utf8_encode(" Release Version 2012_03_18 "));    
				$lb_valido=$this->uf_create_release_db_libre_V_2012_03_18();
				$ls_nro_release.=" - 2012_03_18 ";   
			}
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiar','estbec');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_06_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_06_01();
            $ls_nro_release.=" - 2012_06_01 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_familiar','nivaca');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_06_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_06_02();
            $ls_nro_release.=" - 2012_06_02 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_cmp_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2012_06_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2012_06_03();
			$ls_nro_release.=" - 2012_06_03";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_dt_cmp_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2012_06_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2012_06_04();
			$ls_nro_release.=" - 2012_06_04";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','valestpre');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_06_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_06_05();
            $ls_nro_release.=" - 2012_06_05 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','nivvalest');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_06_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_06_06();
            $ls_nro_release.=" - 2012_06_06 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('spg_val_estructura');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2012_06_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2012_06_07();
			$ls_nro_release.=" - 2012_06_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','salnor');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_01();
            $ls_nro_release.=" - 2012_07_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_sueldoshistoricos','bonvac');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_02();
            $ls_nro_release.=" - 2012_07_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_sueldoshistoricos','confij');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_03();
            $ls_nro_release.=" - 2012_07_03 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','salnor');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_04();
            $ls_nro_release.=" - 2012_07_04 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','salnor');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_05();
            $ls_nro_release.=" - 2012_07_05 ";   
        }
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_usuarios','corele');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_06();
            $ls_nro_release.=" - 2012_07_06 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','codusureg');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_07();
            $ls_nro_release.=" - 2012_07_07 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_solicitudes','codusureg');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_08();
            $ls_nro_release.=" - 2012_07_08 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideiperiodo','bonvacadiper');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_07_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_07_09();
            $ls_nro_release.=" - 2012_07_09 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('rpc_proveedor','estrnc');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_08_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_08_01();
            $ls_nro_release.=" - 2012_08_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_concepto','recpagadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_08_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_08_02();
            $ls_nro_release.=" - 2012_08_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','recpagadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_08_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_08_03();
            $ls_nro_release.=" - 2012_08_03 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','recpagadi');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_08_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_08_04();
            $ls_nro_release.=" - 2012_08_04 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','feccieinv');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_09_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_09_01();
            $ls_nro_release.=" - 2012_08_04 ";   
        }
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SIV','RELEASE','2012_09_02');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_09_02 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_09_02();
			$ls_nro_release.=" - 2012_09_02";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_cuentagasto','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_01();
            $ls_nro_release.=" - 2012_10_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_spg','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_02();
            $ls_nro_release.=" - 2012_10_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_spi','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_03();
            $ls_nro_release.=" - 2012_10_03 ";   
        }*/
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_04();
            $ls_nro_release.=" - 2012_10_04 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_05();
            $ls_nro_release.=" - 2012_10_05 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_06 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_06();
            $ls_nro_release.=" - 2012_10_06 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		/*$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spi','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_07 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_07();
            $ls_nro_release.=" - 2012_10_07 ";   
        }*/
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_cuentagasto','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_08 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_08();
            $ls_nro_release.=" - 2012_10_08 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_solicitudcargos','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_09 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_09();
            $ls_nro_release.=" - 2012_10_09 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dt_bienes','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_10 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_10();
            $ls_nro_release.=" - 2012_10_10 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dt_servicio','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_11 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_11();
            $ls_nro_release.=" - 2012_10_11 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dta_cargos','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_12 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_12();
            $ls_nro_release.=" - 2012_10_12 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_dts_cargos','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_13 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_13();
            $ls_nro_release.=" - 2012_10_13 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_sol_cotizacion','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_14 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_14();
            $ls_nro_release.=" - 2012_10_14 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_cargos','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_15 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_15();
            $ls_nro_release.=" - 2012_10_15 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_spg','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_16 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_16();
            $ls_nro_release.=" - 2012_10_16 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dc_cargos','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_17 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_17();
            $ls_nro_release.=" - 2012_10_17 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dc_spg','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_18 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_18();
            $ls_nro_release.=" - 2012_10_18 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_dc_spi','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_10_19 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_10_19();
            $ls_nro_release.=" - 2012_10_19 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_despacho','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_11_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_11_01();
            $ls_nro_release.=" - 2012_11_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   		$lb_existe = $this->io_function_db->uf_select_column('siv_dt_spg','codfuefin');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_11_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_11_02();
            $ls_nro_release.=" - 2012_11_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   		$lb_existe = $this->io_function_db->uf_select_column('cxp_documento','tipdoctesnac');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_11_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_11_03();
            $ls_nro_release.=" - 2012_11_03 ";   
        }
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('CFG','RELEASE','2012_11_04');
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2012_11_04 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2012_11_04();
			$ls_nro_release.=" - 2012_11_04";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','tipdoctesnac');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_11_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_11_05();
            $ls_nro_release.=" - 2012_11_05 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   		$lb_existe = $this->io_function_db->uf_select_column('scb_dt_cmp_ret','tipdoctesnac');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2012_11_05 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2012_11_06();
            $ls_nro_release.=" - 2012_11_06 ";   
        }
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','cersindis');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_01_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_01_01();
            $ls_nro_release.=" - 2013_01_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','cersindis');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_01_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_01_02();
            $ls_nro_release.=" - 2013_01_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','cersindis');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_01_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_01_03();
            $ls_nro_release.=" - 2013_01_03 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estspidecimal');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_01_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_01_04();
            $ls_nro_release.=" - 2013_01_04 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','numexprel');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_02_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_02_01();
            $ls_nro_release.=" - 2013_02_01 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','docdestrans');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_02_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_02_02();
            $ls_nro_release.=" - 2013_02_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','tiptrans');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_02_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_02_03();
            $ls_nro_release.=" - 2013_02_03 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estverant');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_02_04 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_02_04();
            $ls_nro_release.=" - 2013_02_03 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_continente');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_03_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_03_01();
			$ls_nro_release.=" - 2013_03_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_pais','codcont');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_03_02 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_03_02();
            $ls_nro_release.=" - 2013_03_02 ";   
        }
        
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_misiones','codpai');
        if (!$lb_existe)
        {
            $this->io_msg->message(utf8_encode(" Release Version 2013_03_03 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2013_03_03();
            $ls_nro_release.=" - 2013_03_02 ";   
        }
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_regiones_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_03_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_03_04();
			$ls_nro_release.=" - 2013_03_04";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_dt_regiones_int');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_03_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_03_05();
			$ls_nro_release.=" - 2013_03_05";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_tarifacargos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_03_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_03_06();
			$ls_nro_release.=" - 2013_03_06";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_dt_tarifacargos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_03_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_03_07();
			$ls_nro_release.=" - 2013_03_07";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_incremento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_01();
			$ls_nro_release.=" - 2013_04_01";   
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_dt_incremento');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_02();
			$ls_nro_release.=" - 2013_04_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $lb_existe = $this->io_function_db->uf_select_column('sob_anticipo','numrecdoc');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_03();
			$ls_nro_release.=" - 2013_04_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sob_cuentaanticipo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_04();
			$ls_nro_release.=" - 2013_04_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sob_cargoanticipo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_05();
			$ls_nro_release.=" - 2013_04_05";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estantspg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_04_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_04_06();
			$ls_nro_release.=" - 2013_04_06";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estvarpar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_05_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_05_01();
			$ls_nro_release.=" - 2013_05_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('sob_variacionpartida','fk_sob_variacionpartida__sob_asignacionpartidaobra');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_05_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_05_02();
			$ls_nro_release.=" - 2013_05_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_usuarios','estblocon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_05_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_05_03();
			$ls_nro_release.=" - 2013_05_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_asignacionpartidaobra','estvar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_05_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_05_04();
			$ls_nro_release.=" - 2013_05_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('sob_asignacionpartidaobra','fk_sob_asignacionpartidaobra__sob_partidaobra');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_05_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_05_05();
			$ls_nro_release.=" - 2013_05_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config('SCV','RELEASE','2013_06_01');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_06_01 "));	
			$lb_valido=$this->uf_create_release_db_libre_V_2013_06_01();
			$ls_nro_release.=" - 2013_06_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_cargafamiliar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_06_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_06_02();
			$ls_nro_release.=" - 2013_06_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_medidas');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_06_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_06_03();
			$ls_nro_release.=" - 2013_06_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','codmisdes');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_06_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_06_04();
			$ls_nro_release.=" - 2013_06_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_sueldoshistoricos','alibonvac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_06_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_06_05();
			$ls_nro_release.=" - 2013_06_05";   
		}
   		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','codcar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_07_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_07_01();
			$ls_nro_release.=" - 2013_07_01";   
		}
   		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_otrasasignaciones','codmis');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_07_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_07_02();
			$ls_nro_release.=" - 2013_07_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_dt_misiones');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_07_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_07_03();
			$ls_nro_release.=" - 2013_07_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_tarifacargos','tipvia');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_07_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_07_04();
			$ls_nro_release.=" - 2013_07_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_tarifas','codmis');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_07_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_07_05();
			$ls_nro_release.=" - 2013_07_05";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_tarifacargos','exterior');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_08_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_08_01();
			$ls_nro_release.=" - 2013_08_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_tarifacargos','codmon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_08_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_08_02();
			$ls_nro_release.=" - 2013_08_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_tarifas','codmon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_08_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_08_03();
			$ls_nro_release.=" - 2013_08_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','tipodoc');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_08_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_08_04();
			$ls_nro_release.=" - 2013_08_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_catcargos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_09_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_09_01();
			$ls_nro_release.=" - 2013_09_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scv_dt_catcargos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_09_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_09_02();
			$ls_nro_release.=" - 2013_09_02";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_catcargos','codmon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_09_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_09_03();
			$ls_nro_release.=" - 2013_09_03";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_dt_misiones','montar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_09_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_09_04();
			$ls_nro_release.=" - 2013_09_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_dt_misiones','monaut');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_09_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_09_05();
			$ls_nro_release.=" - 2013_09_05";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','mondolsol');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_10_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_10_01();
			$ls_nro_release.=" - 2013_10_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','tascamsol');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_10_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_10_02();
			$ls_nro_release.=" - 2013_10_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','numaut');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_11_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_11_01();
			$ls_nro_release.=" - 2013_11_01";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','fecaut');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_11_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_11_02();
			$ls_nro_release.=" - 2013_11_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_misiones','estdesviaper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_12_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_12_01();
			$ls_nro_release.=" - 2013_12_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_contrato','codalt');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2013_12_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2013_12_02();
			$ls_nro_release.=" - 2013_12_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','estmonnac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_01();
			$ls_nro_release.=" - 2014_01_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','estsolfam');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_02();
			$ls_nro_release.=" - 2014_01_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estfilpremod');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_03();
			$ls_nro_release.=" - 2014_01_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_almacen','sc_cuenta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_04();
			$ls_nro_release.=" - 2014_01_04";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_produccion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_05();
			$ls_nro_release.=" - 2014_01_05";   
		}
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_produccion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_06();
			$ls_nro_release.=" - 2014_01_06";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_articulo','estproter');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_01_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_01_07();
			$ls_nro_release.=" - 2014_01_07";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_unidadadmin','coduniadmibs');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_03_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_03_01();
			$ls_nro_release.=" - 2014_03_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('soc_cotizacion','obscot','longtext');		
			 break;

			case "MYSQLI":
				$lb_existe =$this->io_function_db->uf_select_type_columna('soc_cotizacion','obscot','longtext');		
			 break;

				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('soc_cotizacion','obscot','text');
				   								
			break;  				  
	    }	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_03_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_03_02();
			$ls_nro_release.=" - 2014_03_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('saf_dta','idchapa');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('saf_dta','idchapa',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="15")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2014_04_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2014_04_01();
            $ls_nro_release.=" - 2014_04_01 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if (!$this->io_function_db->uf_select_columna_null('sno_thpersonalnomina', 'cueaboper')) {
			$this->io_msg->message(utf8_encode(" Release Version 2014_05_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2014_05_01();
            $ls_nro_release.=" - 2014_05_01 ";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_produccion_scg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_05_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_05_02();
			$ls_nro_release.=" - 2014_05_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estpereli');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_06_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_06_01();
			$ls_nro_release.=" - 2014_06_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_cestaticket','nrotarjeta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_07_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2014_07_01();
			$ls_nro_release.=" - 2014_07_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','blopresep');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_07_02 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_07_02();
			$ls_nro_release.=" - 2014_07_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_ctabanco','numnego');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_08_01 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_08_01();
			$ls_nro_release.=" - 2014_08_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_banco','codswift');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_08_02 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_08_02();
			$ls_nro_release.=" - 2014_08_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('rpc_proveedor','tipcueban');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_08_03 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_08_03();
			$ls_nro_release.=" - 2014_08_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_valuacion','fecrecdoc');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_08_04 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_08_04();
			$ls_nro_release.=" - 2014_08_04";
		}

		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tamano=$this->io_function_db->uf_tamano_type_columna('scb_banco','codsudeban');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scb_banco','codsudeban',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tamano=$as_valor1;
		}
		if ($tamano=="4")
		{
           $this->io_msg->message(utf8_encode(" Release Version 2014_09_01 "));    
            $lb_valido=$this->uf_create_release_db_libre_V_2014_09_01();
            $ls_nro_release.=" - 2014_09_01 ";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_ctabanco','ctarec');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_09_02 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_09_02();
			$ls_nro_release.=" - 2014_09_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_ctabanco','tipctarec');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_09_03 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_09_03();
			$ls_nro_release.=" - 2014_09_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_ctabanco','fecultcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_09_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_09_04();
			$ls_nro_release.=" - 2014_09_04";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','codperalf');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_10_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_10_01();
			$ls_nro_release.=" - 2014_10_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','blonumche');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_12_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_12_01();
			$ls_nro_release.=" - 2014_12_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dt_movimiento','coduniadm');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2014_12_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2014_12_02();
			$ls_nro_release.=" - 2014_12_01";
		}
 		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tam_num_nego=$this->io_function_db->uf_tamano_type_columna('scb_ctabanco','numnego');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scb_ctabanco','numnego',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tam_num_nego=$as_valor1;
		}
		if ($tam_num_nego=="8")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_03_01 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_03_01();
			$ls_nro_release.=" - 2015_03_01 ";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tam_num_nego=$this->io_function_db->uf_tamano_type_columna('cxp_rd','numref');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('cxp_rd','numref',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tam_num_nego=$as_valor1;
		}
		if ($tam_num_nego=="15")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_03_02 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_03_02();
			$ls_nro_release.=" - 2015_03_02 ";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','numdiacre');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_01();
			$ls_nro_release.=" - 2015_07_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','numdecper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_02();
			$ls_nro_release.=" - 2015_07_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','sc_ctaasu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_03();
			$ls_nro_release.=" - 2015_07_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','estretasu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_04();
			$ls_nro_release.=" - 2015_07_04";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estrescxp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_05();
			$ls_nro_release.=" - 2015_07_05";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp_md','juscomp');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_06();
			$ls_nro_release.=" - 2015_07_06";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_sol_dc','fecemi');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_07_07"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_07_07();
			$ls_nro_release.=" - 2015_07_07";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_deudaanterior','monantint');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_08_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_08_01();
			$ls_nro_release.=" - 2015_08_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','valiniislr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_01();
			$ls_nro_release.=" - 2015_09_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_deducciones','desserded');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_02();
			$ls_nro_release.=" - 2015_09_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_constraint('sno_fideiperiodointereses','fk_sno_fideiperiodointereses__sno_fideiperiodo');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_04();
			$ls_nro_release.=" - 2015_09_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_fideiperiodointereses','antpre');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_05();
			$ls_nro_release.=" - 2015_09_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_sol_dc','estlibcom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_06();
			$ls_nro_release.=" - 2015_09_06";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','tipsiscam');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_09_07"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_09_07();
			$ls_nro_release.=" - 2015_09_07";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','estagrapo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_10_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_10_01();
			$ls_nro_release.=" - 2015_10_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','estagrapo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_10_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_10_02();
			$ls_nro_release.=" - 2015_10_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','estagrapo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_10_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_10_03();
			$ls_nro_release.=" - 2015_10_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$tam_num_nego=$this->io_function_db->uf_tamano_type_columna('scb_cheques','codusu');
		}
		else
		{
			$as_valor1=0;
			$as_valor2=0;
			$as_valor3=0;
			$as_valor4=0;
			$this->io_function_db->uf_tamano_type_columna_Mysql('scb_cheques','codusu',$as_valor1,$as_valor2,$as_valor3,$as_valor4);
			$tam_num_nego=$as_valor1;
		}
		if ($tam_num_nego=="30")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_10_04 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_10_04();
			$ls_nro_release.=" - 2015_10_04 ";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->uf_select_config("SCB","RELEASE","2015_10_05");
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_10_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_10_05();
			$ls_nro_release.=" - 2015_10_05";
		}
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_01();
			$ls_nro_release.=" - 2015_11_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_personal','fecreg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_02();
			$ls_nro_release.=" - 2015_11_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_03();
			$ls_nro_release.=" - 2015_11_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spg_dt_cmp','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_04();
			$ls_nro_release.=" - 2015_11_04";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scg_dt_cmp','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_05();
			$ls_nro_release.=" - 2015_11_05";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('spi_dt_cmp','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_06();
			$ls_nro_release.=" - 2015_11_06";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_07"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_07();
			$ls_nro_release.=" - 2015_11_07";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_spg','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_08"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_08();
			$ls_nro_release.=" - 2015_11_08";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_scg','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_09"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_09();
			$ls_nro_release.=" - 2015_11_09";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_cargos','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_10"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_10();
			$ls_nro_release.=" - 2015_11_10";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('cxp_rd_deducciones','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_11"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_11();
			$ls_nro_release.=" - 2015_11_11";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$existe=false;
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$existe=$this->io_function_db->uf_select_type_columna('srh_gerencia','denger','character');
		}
		else
		{
			$existe=$this->io_function_db->uf_select_type_columna('srh_gerencia','denger','CHAR');
		}
		if ($existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_12 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_12();
			$ls_nro_release.=" - 2015_11_12 ";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_activo','colact');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_13"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_13();
			$ls_nro_release.=" - 2015_11_13";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_sede');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_14 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_14();
			$ls_nro_release.=" - 2015_11_14";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_movimiento','codsed');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_15"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_15();
			$ls_nro_release.=" - 2015_11_15";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_16"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_16();
			$ls_nro_release.=" - 2015_11_16";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_scg','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_17"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_17();
			$ls_nro_release.=" - 2015_11_17";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_spg','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_18"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_18();
			$ls_nro_release.=" - 2015_11_18";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('scb_movbco_spi','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_19"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_19();
			$ls_nro_release.=" - 2015_11_19";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('saf_dta','codsed');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_20"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_20();
			$ls_nro_release.=" - 2015_11_20";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','reucon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_21"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_21();
			$ls_nro_release.=" - 2015_11_21";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','nroconreu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_22"));
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_22();
			$ls_nro_release.=" - 2015_11_22";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sss_usuariosdetalle');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2015_11_23 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2015_11_23();
			$ls_nro_release.=" - 2015_11_23";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcanret');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_01_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_01_01();
			$ls_nro_release.=" - 2016_01_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_cuentasasignacion','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_01();
			$ls_nro_release.=" - 2016_02_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_cargoasignacion','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_02();
			$ls_nro_release.=" - 2016_02_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sob_cargovaluacion','codcencos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_03();
			$ls_nro_release.=" - 2016_02_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','recdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_04();
			$ls_nro_release.=" - 2016_02_04";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','recdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_05();
			$ls_nro_release.=" - 2016_02_05";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','recdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_06();
			$ls_nro_release.=" - 2016_02_06";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','tipdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_07"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_07();
			$ls_nro_release.=" - 2016_02_07";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','tipdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_08"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_08();
			$ls_nro_release.=" - 2016_02_08";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','tipdoccaunom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_02_09"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_02_09();
			$ls_nro_release.=" - 2016_02_09";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','codconobr');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_08_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_08_01();
			$ls_nro_release.=" - 2016_08_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','ressoc');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_08_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_08_02();
			$ls_nro_release.=" - 2016_08_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_movimientoconciliar');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_09_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_09_01();
			$ls_nro_release.=" - 2016_09_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_confconciliacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_09_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_09_02();
			$ls_nro_release.=" - 2016_09_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('cxp_confacta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_11_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_11_01();
			$ls_nro_release.=" - 2016_09_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_01"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_01();
			$ls_nro_release.=" - 2016_12_01";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_hvacacpersonal','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_02();
			$ls_nro_release.=" - 2016_12_02";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sno_thvacacpersonal','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_03();
			$ls_nro_release.=" - 2016_12_03";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp_md','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_04();
			$ls_nro_release.=" - 2016_12_04";
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_tipoarticulo','sc_cuenta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_05();
			$ls_nro_release.=" - 2016_12_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_empaquetado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_06();
			$ls_nro_release.=" - 2016_12_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_empaquetado');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_07();
			$ls_nro_release.=" - 2016_12_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_empaquetado_scg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_08 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_08();
			$ls_nro_release.=" - 2016_12_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estvercta');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2016_12_09 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2016_12_09();
			$ls_nro_release.=" - 2016_12_09";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_articulo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_01_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_01_01();
			$ls_nro_release.=" - 2017_01_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_dt_recepcion','serartdes');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_01_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_01_02();
			$ls_nro_release.=" - 2017_01_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_dt_transferencia','serartdes');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_02_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_02_01();
			$ls_nro_release.=" - 2017_02_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_causas');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_02_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_02_02();
			$ls_nro_release.=" - 2017_02_02";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_asignacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_02_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_02_03();
			$ls_nro_release.=" - 2017_02_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('siv_dt_asignacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_02_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_02_04();
			$ls_nro_release.=" - 2017_02_04";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('siv_dt_articulo','fecdesfac');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_02_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_02_05();
			$ls_nro_release.=" - 2017_02_05";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sss_derechos_usuarios','codintper');
		if ($lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_03_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_03_01();
			$ls_nro_release.=" - 2017_03_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estvalcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_01();
			$ls_nro_release.=" - 2017_04_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_nomina','codclanom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_02();
			$ls_nro_release.=" - 2017_04_02";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','codclanom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_03();
			$ls_nro_release.=" - 2017_04_03";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','codclanom');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_04();
			$ls_nro_release.=" - 2017_04_04";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_dt_spg','codcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_05();
			$ls_nro_release.=" - 2017_04_05";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_rd','codcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_06 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_06();
			$ls_nro_release.=" - 2017_04_06";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','codcla');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_04_07 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_04_07();
			$ls_nro_release.=" - 2017_04_07";   
		}
		switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('rpc_beneficiario','dirbene','longtext');		
			 break;

			case "MYSQLI":
				$lb_existe =$this->io_function_db->uf_select_type_columna('rpc_beneficiario','dirbene','longtext');		
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('rpc_beneficiario','dirbene','text');
				   								
			break;  				  
	    }	
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_05_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_05_01();
			$ls_nro_release.=" - 2017_05_01";   
		}		
		$lb_existe = $this->io_function_db->uf_select_column('sob_variacioncontrato','fecrevsup');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_06_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_06_01();
			$ls_nro_release.=" - 2017_06_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('scb_movimientoconciliar','estcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_08_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_08_01();
			$ls_nro_release.=" - 2017_08_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_permiso','desvacper');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_08_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_08_02();
			$ls_nro_release.=" - 2017_08_02";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','permisos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_08_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_08_03();
			$ls_nro_release.=" - 2017_08_03";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('srh_dt_entrevista_tecnica','codcon');
		if (!$lb_existe)
		{
			$lb_existe = $this->io_function_db->uf_select_constraint('srh_entrevista_tecnica','pk_srh_entrevista_tecnica');
			if ($lb_existe)
			{
				$this->io_msg->message(utf8_encode(" Release Version 2017_08_04 "));	
				$lb_valido=$this->uf_create_release_db_libre_V_2017_08_04();
				$ls_nro_release.=" - 2017_08_04";   
			}
			$this->io_msg->message(utf8_encode(" Release Version 2017_08_05 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_08_05();
			$ls_nro_release.=" - 2017_08_05";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('srh_odi','codusu');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_09_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_09_01();
			$ls_nro_release.=" - 2017_09_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estconlot');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_09_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_09_02();
			$ls_nro_release.=" - 2017_09_02";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('srh_dt_requisitos_minimos','codcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_09_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_09_03();
			$ls_nro_release.=" - 2017_09_03";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('srh_dt_evaluacion_psicologica','codcon');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_09_04 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_09_04();
			$ls_nro_release.=" - 2017_09_04";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_cargos','estpagele');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_10_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_10_01();
			$ls_nro_release.=" - 2017_10_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','forpag');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_10_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_10_02();
			$ls_nro_release.=" - 2017_10_02";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('soc_ordencompra','forpag');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_10_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_10_03();
			$ls_nro_release.=" - 2017_10_03";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sno_constanciatrabajo','consumcont');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2017_12_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2017_12_01();
			$ls_nro_release.=" - 2017_12_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','costo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_02_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_02_01();
			$ls_nro_release.=" - 2018_02_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_table('sno_historicocargo');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_03_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_03_01();
			$ls_nro_release.=" - 2018_03_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','filindspg');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_04_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_04_01();
			$ls_nro_release.=" - 2018_04_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_ctrl_numero');
		if ($lb_existe)
		{
			$lb_existe = $this->uf_select_config('CFG','RELEASE','2018_05_01');		
			if (!$lb_existe)
			{
				$this->io_msg->message(utf8_encode(" Release Version 2018_05_01 "));	
				$lb_valido=$this->uf_create_release_db_libre_V_2018_05_01();
				$ls_nro_release.=" - 2018_05_01";   
			}
		}
		else
		{
			$this->uf_insert_config('CFG','RELEASE','2018_05_01');		
		}
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','numsolini');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_06_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_06_01();
			$ls_nro_release.=" - 2018_06_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_table('mis_sigesp_cxc');
		if ($lb_existe)
		{
                    $lb_existe = $this->io_function_db->uf_select_column('mis_sigesp_cxc','codestpro1');
                    if (!$lb_existe)
                    {
                            $this->io_msg->message(utf8_encode(" Release Version 2018_06_02 "));				   	   
                            $lb_valido=$this->uf_create_release_db_libre_V_2018_06_02();
                            $ls_nro_release.=" - 2018_06_02";   
                    }
		}
		$lb_existe = $this->io_function_db->uf_select_column('sep_solicitud','obssol');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_07_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_07_01();
			$ls_nro_release.=" - 2018_07_01";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$existe=false;
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$existe=$this->io_function_db->uf_select_type_columna('sno_personalnomina','cauegrper','text');
		}
		else
		{
			$existe=$this->io_function_db->uf_select_type_columna('sno_personalnomina','cauegrper','longtext');
		}
		if (!$existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_09_01 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2018_09_01();
			$ls_nro_release.=" - 2018_09_01 ";
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_column('sep_tiposolicitud','estdifiva');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_09_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_09_02();
			$ls_nro_release.=" - 2018_09_02";   
		}		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_prefijos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_09_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_09_03();
			$ls_nro_release.=" - 2018_09_03";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('scb_archivoconciliacion');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2018_10_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2018_10_01();
			$ls_nro_release.=" - 2018_10_01";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sss_firmantesdinamicos');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_01_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2019_01_01();
			$ls_nro_release.=" - 2019_01_01";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('saf_color');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_02_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2019_02_01();
			$ls_nro_release.=" - 2019_02_01";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('saf_activo','codcol');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_02_02"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_02_02();
			$ls_nro_release.=" - 2019_02_02";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if ($_SESSION["ls_gestor"]=="POSTGRES")
		{
			$existe=$this->io_function_db->uf_select_type_columna('sno_hpersonalnomina','cauegrper','text');
		}
		else
		{
			$existe=$this->io_function_db->uf_select_type_columna('sno_hpersonalnomina','cauegrper','longtext');
		}
		if (!$existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_04_01 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_04_01();
			$ls_nro_release.=" - 2019_04_01 ";
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('sigesp_cmp','numconcom');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_06_01"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_06_01();
			$ls_nro_release.=" - 2019_06_01";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estconcom');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_06_02"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_06_02();
			$ls_nro_release.=" - 2019_06_02";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','nroinicom');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_06_03"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_06_03();
			$ls_nro_release.=" - 2019_06_03";   
		}
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$existe=$this->io_function_db->uf_select_type_columna('soc_servicios','denser','text');
		if (!$existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_07_01 "));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_07_01();
			$ls_nro_release.=" - 2019_07_01 ";
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_existe = $this->io_function_db->uf_select_column('sigesp_empresa','estcommas');
	    if(!$lb_existe)
	    {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_07_02"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_07_02();
			$ls_nro_release.=" - 2019_06_03";   
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe = $this->io_function_db->uf_select_table('sigesp_clasificador_economico');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_11_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_01();
			$ls_nro_release.=" - 2019_11_01";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('scg_casa_presu','cueclaeco');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_11_02"));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_02();
			$ls_nro_release.=" - 2019_11_02";
		}
		$lb_existe = $this->io_function_db->uf_select_column('scg_casa_presu','cueoncop');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_11_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_03();
			$ls_nro_release.=" - 2019_11_03";
		}
                $lb_existe = $this->io_function_db->uf_select_constraint('scg_casa_presu','pk_scg_casa_presu2');
                if(!$lb_existe)
                {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_11_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_04();
			$ls_nro_release.=" - 2019_11_04";   
		}
		$lb_existe = $this->io_function_db->uf_select_column('spg_cuentas','cueclaeco');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_11_05"));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_05();
			$ls_nro_release.=" - 2019_11_05";
		}
		$lb_existe = $this->io_function_db->uf_select_column('spi_cuentas','cueclaeco');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2019_11_06"));
			$lb_valido=$this->uf_create_release_db_libre_V_2019_11_06();
			$ls_nro_release.=" - 2019_11_06";
		}
                $lb_existe = $this->io_function_db->uf_select_column('sigesp_moneda','desmon');
                if(!$lb_existe)
                {
		    $this->io_msg->message(utf8_encode(" Release Version 2019_12_01"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2019_12_01();
			$ls_nro_release.=" - 2019_12_01";   
		}	
		$lb_existe = $this->uf_select_config('SPG','RELEASE','01_1');		
		if (!$lb_existe)
		{
		    $this->io_msg->message(utf8_encode(" Release Version 2020_SPG_01 "));	
                    $lb_valido=$this->uf_create_release_db_libre_V_2020_spg_01();
                    $ls_nro_release.=" - 2020_SPG_01";   
		}
                $lb_existe = $this->io_function_db->uf_select_column('soc_dtcot_bienes','desart');
                if(!$lb_existe)
                {
		    $this->io_msg->message(utf8_encode(" Release Version 2020_02_01"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2020_02_01();
			$ls_nro_release.=" - 2020_02_01";   
		}	
        $lb_existe = $this->io_function_db->uf_select_column('soc_dtcot_servicio','desser');
        if(!$lb_existe)
        {
		    $this->io_msg->message(utf8_encode(" Release Version 2020_02_02"));	
			$lb_valido=$this->uf_create_release_db_libre_V_2020_02_02();
			$ls_nro_release.=" - 2020_02_02";   
		}	
		/*$lb_existe = $this->io_function_db->uf_select_column('scv_solicitudviatico','estopediv');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2020_02_03"));
			$lb_valido=$this->uf_create_release_db_libre_V_2020_02_03();
			$ls_nro_release.=" - 2020_02_03";
		}*/
		$lb_existe = $this->io_function_db->uf_select_column('sno_metodobanco','estmet');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2020_02_04"));
			$lb_valido=$this->uf_create_release_db_libre_V_2020_02_04();
			$ls_nro_release.=" - 2020_02_04";
		}
		$tamano1=$this->io_function_db->uf_tamano_type_columna('sno_nomina','titrepnom');
		if ($tamano1=="70")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2020_11_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2020_11_01();
			$ls_nro_release.=" - 2020_11_01";   
		}
		$tamano1=$this->io_function_db->uf_tamano_type_columna('sno_hnomina','titrepnom');
		if ($tamano1=="50")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2020_11_02 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2020_11_02();
			$ls_nro_release.=" - 2020_11_02";   
		}
		$tamano1=$this->io_function_db->uf_tamano_type_columna('sno_thnomina','titrepnom');
		if ($tamano1=="50")
		{
			$this->io_msg->message(utf8_encode(" Release Version 2020_11_03 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2020_11_03();
			$ls_nro_release.=" - 2020_11_03";   
		}
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="PROCESS";
			$ls_descripcion="Ejecuto el release ".$ls_nro_release;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////
		}
		if($lb_valido)
		{

			$this->io_sql->commit();
		}
		else
		{
			$this->io_sql->rollback();
		}
		if ($lb_cambiado)
		{
			$_SESSION["ls_gestor"]='MYSQLI'; 
		}
		return $lb_valido;
	} // end function 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////	
   ////-----VERSIONES DESDE EL RELEASE 1_90------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_90()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_90
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 03/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_thclasificacionobrero     ".
			            " ADD COLUMN anovig char(4) DEFAULT 1900, ". 
			            " ADD COLUMN nrogac varchar(10)          ;";					
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_thclasificacionobrero     ".
			            " ADD COLUMN anovig char(4) DEFAULT 1900, ". 
			            " ADD COLUMN nrogac varchar(10)          ;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_thclasificacionobrero    ".
			            " ADD COLUMN anovig char(4) DEFAULT 1900, ". 
			            " ADD COLUMN nrogac varchar(10)          ;";		
		        break;	 			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_90");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_90
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_91()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_91
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 10/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE scb_banco   ".
			            " ADD codsudeban char(4) ;";					
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE scb_banco   ".
			            " ADD codsudeban char(4) ;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE scb_banco   ".
			            " ADD codsudeban char(4) ;";			
		        break;				  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_91");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_91
	
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_92()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_92
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 12/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_beneficiario ".
                        " ADD nexben VARCHAR(1) DEFAULT '-' ;";					
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_beneficiario ".
                        " ADD nexben VARCHAR(1) DEFAULT '-' ;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_beneficiario ".
                        " ADD nexben VARCHAR(1) DEFAULT '-' ;";			
		        break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_92");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_92

//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_93()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_93
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 12/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sigesp_deducciones    ".
			            " ADD tipopers char(1) DEFAULT 'J' ;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sigesp_deducciones    ".
			            " ADD tipopers char(1) DEFAULT 'J' ;";					
			   break;
			   
			case "POSTGRES":
			    $ls_sql= " ALTER TABLE sigesp_deducciones    ".
			             " ADD tipopers char(1) DEFAULT 'J' ;";				
		        break;  			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_93");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_93

//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_94()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_94
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 16/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_personal    ".
			            " ADD enviorec varchar(1) DEFAULT '-' ;";					
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_personal    ".
			            " ADD enviorec varchar(1) DEFAULT '-' ;";					
			   break;
			   
			case "POSTGRES":
			    $ls_sql= " ALTER TABLE sno_personal    ".
			             " ADD enviorec varchar(1) DEFAULT '-';";				
		        break;   			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_94");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_94
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_95()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_95
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 16/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_beneficiario ".
                        " ADD  cedaut varchar(10)";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_beneficiario ".
                        " ADD  cedaut varchar(10)";					
			   break;
			   
			case "POSTGRES":
			     $ls_sql= " ALTER TABLE sno_beneficiario ".
                          " ADD  cedaut varchar(10)";						
		        break;  			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_95");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_95
//----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_96()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_96
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 16/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_personal ".
						" ADD fecfevid date;       ";					
			   break;
			   
			case "POSTGRES":
			     $ls_sql= " ALTER TABLE sno_personal ".
						  " ADD fecfevid date;       ";						
		        break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_96");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_96
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_97()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_97
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 17/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sigesp_empresa ".
                        " ADD  estretiva varchar(1) DEFAULT 'C'";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sigesp_empresa ".
                        " ADD  estretiva varchar(1) DEFAULT 'C'";					
			   break;
			   
			case "POSTGRES":
			    $ls_sql= " ALTER TABLE sigesp_empresa ".
                         " ADD  estretiva varchar(1) DEFAULT 'C'";						
		        break; 			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_97");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_97
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_1_98()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_1_98
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 17/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE cxp_documento ".
                        " ADD  tipodocanti int2 NOT NULL DEFAULT 0";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE cxp_documento ".
                        " ADD  tipodocanti int2 NOT NULL DEFAULT 0";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE cxp_documento ".
                        " ADD  tipodocanti int2 NOT NULL DEFAULT 0";						
		        break; 			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_1_98");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_1_98

//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_1_99()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_1_99
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: Crea la tabla sno_categoria_rango
		// Fecha Creacion: 18/06/2008 								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			    $ls_sql="  CREATE TABLE sno_categoria_rango ( ".
						"  codemp char(4) NOT NULL,           ".
						"  codcat char(10) NOT NULL,          ".
						"  descat varchar(100),               ".
						"  CONSTRAINT pk_sno_categoria_rango PRIMARY KEY (codemp, codcat), ".
						"  CONSTRAINT fk_sno_cat_empresa___sigesp_e FOREIGN KEY (codemp)   ".
						"	  REFERENCES sigesp_empresa (codemp) MATCH SIMPLE              ".
						"	  ON UPDATE RESTRICT ON DELETE RESTRICT) WITHOUT OIDS;         ";
			   break;
			   
			case "MYSQLT":
			    $ls_sql="  CREATE TABLE sno_categoria_rango( ".
				        "  codemp char(4) NOT NULL,          ".
						"  codcat char(10) NOT NULL,         ". 
						"  descat varchar(100),              ".
						"  PRIMARY KEY (codemp, codcat)) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";
			   break;
			   
			case "MYSQLI":
			    $ls_sql="  CREATE TABLE sno_categoria_rango( ".
				        "  codemp char(4) NOT NULL,          ".
						"  codcat char(10) NOT NULL,         ". 
						"  descat varchar(100),              ".
						"  PRIMARY KEY (codemp, codcat)) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";
			   break;
		}	
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{ 
			 $this->io_msg->message("uf_create_release_db_libre_V_1_99");
			 $lb_valido=false;
		}
	  //------------------------------------------------------------------------------------------------------------------------
	  $ls_sql="";
		switch($_SESSION["ls_gestor"])
		   {
				 case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_categoria_rango                                    ".
				  			"  ADD  CONSTRAINT fk_sno_cat_empresa___sigesp_e FOREIGN KEY (codemp) ".
						    "  REFERENCES sigesp_empresa (codemp)                                 ".
						    "  ON UPDATE RESTRICT ON DELETE RESTRICT                              ";							
							
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 1_99 -1 -->Ver el tipo de las Tablas<--");
						 $lb_valido=false;
					}							  
				 break;			

				 case "MYSQLI":
				   $ls_sql= "  ALTER TABLE sno_categoria_rango                                    ".
				  			"  ADD  CONSTRAINT fk_sno_cat_empresa___sigesp_e FOREIGN KEY (codemp) ".
						    "  REFERENCES sigesp_empresa (codemp)                                 ".
						    "  ON UPDATE RESTRICT ON DELETE RESTRICT                              ";							
							
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 1_99 -1 -->Ver el tipo de las Tablas<--");
						 $lb_valido=false;
					}							  
				 break;			
			}
	  //------------------------------------------------------------------------------------------------------------------------
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_1_99
//-----------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_00()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_00
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 18/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_rango ADD COLUMN codcat char(10);";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_rango ADD COLUMN codcat char(10);";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_rango ADD COLUMN codcat char(10);";	
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_00");
				 $lb_valido=false;
			 }
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_00
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_01()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_01
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 18/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE srh_departamento       ".
			            "   ADD COLUMN minorguniadm Char(4), ".
						"   ADD COLUMN ofiuniadm Char(2),    ".	
						"   ADD COLUMN uniuniadm char(2),    ".	
						"   ADD COLUMN depuniadm char(2),    ".	
						"   ADD COLUMN prouniadm char(2);    ";						
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE srh_departamento       ".
			            "   ADD COLUMN minorguniadm Char(4), ".
						"   ADD COLUMN ofiuniadm Char(2),    ".	
						"   ADD COLUMN uniuniadm char(2),    ".	
						"   ADD COLUMN depuniadm char(2),    ".	
						"   ADD COLUMN prouniadm char(2);    ";						
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE srh_departamento       ".
			            "   ADD COLUMN minorguniadm Char(4), ".
						"   ADD COLUMN ofiuniadm Char(2),    ".	
						"   ADD COLUMN uniuniadm char(2),    ".	
						"   ADD COLUMN depuniadm char(2),    ".	
						"   ADD COLUMN prouniadm char(2);    ";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_01");
				 $lb_valido=false;
			 }
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_01
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_02()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_02
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 19/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE srh_movimiento_personal ".
			            "   ADD COLUMN minorguniadm Char(4),  ".
						"   ADD COLUMN ofiuniadm Char(2),     ".	
						"   ADD COLUMN uniuniadm char(2),     ".	
						"   ADD COLUMN depuniadm char(2),     ".	
						"   ADD COLUMN prouniadm char(2);     ";						
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE srh_movimiento_personal ".
			            "   ADD COLUMN minorguniadm Char(4),  ".
						"   ADD COLUMN ofiuniadm Char(2),     ".	
						"   ADD COLUMN uniuniadm char(2),     ".	
						"   ADD COLUMN depuniadm char(2),     ".	
						"   ADD COLUMN prouniadm char(2);     ";						
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE srh_movimiento_personal ".
			            "   ADD COLUMN minorguniadm Char(4),  ".
						"   ADD COLUMN ofiuniadm Char(2),     ".	
						"   ADD COLUMN uniuniadm char(2),     ".	
						"   ADD COLUMN depuniadm char(2),     ".	
						"   ADD COLUMN prouniadm char(2);     ";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_02");
				 $lb_valido=false;
			 }
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_02

//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_03()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_03
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 19/06/2008 								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			   $ls_sql= "  ALTER TABLE srh_movimiento_personal ".
						"  DROP COLUMN codunivi;               ";					  
			   break;
			   
			case "MYSQLI":
			   $ls_sql= "  ALTER TABLE srh_movimiento_personal ".
						"  DROP COLUMN codunivi;               ";					  
			   break;
			   
			case "POSTGRES":
			    $ls_sql= "  ALTER TABLE srh_movimiento_personal ".
						 "  DROP COLUMN codunivi;               ";		   
			   break;				
		}	
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{ 
			 $this->io_msg->message("Problemas al ejecutar Release 2008_2_03");
			 $lb_valido=false;
		}	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_03
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_04()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_04
		//		   Access: public 
		//        Modulos: SOC
		//	  Description: 
		// Fecha Creacion: 19/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE soc_ordencompra                          ".
			            " ADD COLUMN fechentdesde date DEFAULT '1900-01-01',   ". 
			            " ADD COLUMN fechenthasta date DEFAULT '1900-01-01'    ;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE soc_ordencompra                          ".
			            " ADD COLUMN fechentdesde date DEFAULT '1900-01-01',   ". 
			            " ADD COLUMN fechenthasta date DEFAULT '1900-01-01'    ;";		
		        break;				  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_04");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_04
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_05()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_05
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 23/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_nomina ADD informa TEXT;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_nomina ADD informa TEXT;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_nomina ADD informa TEXT;";		
		        break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_05");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_05

//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_06()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_06
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 23/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_hnomina ADD informa TEXT;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_hnomina ADD informa TEXT;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_hnomina ADD informa TEXT;";		
		        break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_06");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_06
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_07()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_07
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 23/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_thnomina ADD informa TEXT;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_thnomina ADD informa TEXT;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_thnomina ADD informa TEXT;";		
		        break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_07");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_07
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_08()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_08
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 23/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_existe=true;
	   $ls_sql="";
	   $ls_existe = $this->io_function_db->uf_select_constraint('srh_dt_ganadores_concurso','srh_dt_ganadores_concurso_pkey');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso DROP CONSTRAINT srh_dt_ganadores_concurso_pkey;";					
				   break;
				   
				case "MYSQLI":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso DROP CONSTRAINT srh_dt_ganadores_concurso_pkey;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso DROP CONSTRAINT srh_dt_ganadores_concurso_pkey;";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_08_1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 
	  
	   $ls_existe = $this->io_function_db->uf_select_constraint('srh_dt_ganadores_concurso','srh_dt_ganadores_concur_pkey');
	   if (!$ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso ".
                            " ADD CONSTRAINT srh_dt_ganadores_concur_pkey PRIMARY KEY(codemp, codcon, codper);";					
				   break;
				   
				case "MYSQLI":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso ".
                            " ADD CONSTRAINT srh_dt_ganadores_concur_pkey PRIMARY KEY(codemp, codcon, codper);";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_dt_ganadores_concurso ".
                            " ADD CONSTRAINT srh_dt_ganadores_concur_pkey PRIMARY KEY(codemp, codcon, codper);";		
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_08_2");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_08
	
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_2_09()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_09
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
		$lb_existe="";
	    $ls_sql="";
	    switch($_SESSION["ls_gestor"])
	    { 
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_nomina ".
                        " ADD COLUMN divcon varchar(1) DEFAULT 0;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_nomina ".
                        " ADD COLUMN divcon varchar(1) DEFAULT 0;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_nomina ".
                        " ADD COLUMN divcon character(1) DEFAULT 0;";		
		        break;	 			  
		 }
		 if (!empty($ls_sql))
		 {	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_09-1");
			 	$lb_valido=false;
		 	}
		 }
		 
		$lb_existe = $this->io_function_db->uf_select_column('sno_hnomina','divcon');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_hnomina ".
							" ADD COLUMN divcon varchar(1) DEFAULT 0;";					
				   break;

				case "MYSQLI":
				   $ls_sql= " ALTER TABLE sno_hnomina ".
							" ADD COLUMN divcon varchar(1) DEFAULT 0;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_hnomina ".
							" ADD COLUMN divcon character(1) DEFAULT 0;";		
					break;					  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_09-2");
					$lb_valido=false;
				}
			 }
		}
		
		$lb_existe = $this->io_function_db->uf_select_column('sno_thnomina','divcon');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_thnomina ".
							" ADD COLUMN divcon varchar(1) DEFAULT 0;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_thnomina ".
							" ADD COLUMN divcon character(1) DEFAULT 0;";		
					break;	   
				  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_09-3");
					$lb_valido=false;
				}
			 }
		}
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_09
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_10()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_10
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
		$lb_existe="";
	    $ls_sql="";
	    switch($_SESSION["ls_gestor"])
	    { 
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_concepto ".
                        " ADD COLUMN quirepcon varchar(1) DEFAULT '-';";					
			   break;

			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_concepto ".
                        " ADD COLUMN quirepcon varchar(1) DEFAULT '-';";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_concepto ".
                        " ADD COLUMN quirepcon character(1) DEFAULT '-';";		
		        break;	   
			  
		 }
		 if (!empty($ls_sql))
		 {	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_10-1");
			 	$lb_valido=false;
		 	}
		 }
		 
		$lb_existe = $this->io_function_db->uf_select_column('sno_hconcepto','quirepcon');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
			   case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_hconcepto ".
                        " ADD COLUMN quirepcon varchar(1) DEFAULT '-';";					
			   break;
			   
			   case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_hconcepto ".
                        " ADD COLUMN quirepcon character(1) DEFAULT '-';";		
		        break;	   
				  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_10-2");
					$lb_valido=false;
				}
			 }
		}
		
		$lb_existe = $this->io_function_db->uf_select_column('sno_thconcepto','quirepcon');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
				case "MYSQLT":
 			      $ls_sql= " ALTER TABLE sno_thconcepto ".
                           " ADD COLUMN quirepcon varchar(1) DEFAULT '-';";					
			   break;
			   
				case "MYSQLI":
 			      $ls_sql= " ALTER TABLE sno_thconcepto ".
                           " ADD COLUMN quirepcon varchar(1) DEFAULT '-';";					
			   break;
			   
			   case "POSTGRES":
			     $ls_sql= " ALTER TABLE sno_thconcepto ".
                          " ADD COLUMN quirepcon character(1) DEFAULT '-';";		
		        break;	     
				  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_10-3");
					$lb_valido=false;
				}
			 }
		}
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_10
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_11()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_11
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
		$lb_existe="";
	    $ls_sql="";
	    switch($_SESSION["ls_gestor"])
	    { 
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_salida ".
                        " ADD COLUMN priquisal double(19,4) DEFAULT 0, ".
                        " ADD COLUMN segquisal double(19,4) DEFAULT 0; ";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_salida ".
                        " ADD COLUMN priquisal float8 DEFAULT 0, ".
                        " ADD COLUMN segquisal float8 DEFAULT 0;";		
		        break;			  
		 }
		 if (!empty($ls_sql))
		 {	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_11-1");
			 	$lb_valido=false;
		 	}
		 }
		 
		$lb_existe = $this->io_function_db->uf_select_column('sno_hsalida','priquisal');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
			   case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_hsalida ".
                        " ADD COLUMN priquisal double(19,4) DEFAULT 0, ".
                        " ADD COLUMN segquisal double(19,4) DEFAULT 0; ";					
			   break;
			   
			   case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_hsalida ".
                        " ADD COLUMN priquisal double(19,4) DEFAULT 0, ".
                        " ADD COLUMN segquisal double(19,4) DEFAULT 0; ";					
			   break;
			   
			   case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_hsalida ".
                        " ADD COLUMN priquisal float8 DEFAULT 0, ".
                        " ADD COLUMN segquisal float8 DEFAULT 0;";		
		        break;	    
				  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_11-2");
					$lb_valido=false;
				}
			 }
		}
		
		$lb_existe = $this->io_function_db->uf_select_column('sno_thsalida','priquisal');
		 
		if (!$lb_existe)
		{
			$ls_sql="";
			switch($_SESSION["ls_gestor"])
			{ 
				case "MYSQLT":
 			    $ls_sql= " ALTER TABLE sno_thsalida ".
                         " ADD COLUMN priquisal double(19,4) DEFAULT 0, ".
                         " ADD COLUMN segquisal double(19,4) DEFAULT 0; ";					
			    break;
			   
				case "MYSQLI":
 			    $ls_sql= " ALTER TABLE sno_thsalida ".
                         " ADD COLUMN priquisal double(19,4) DEFAULT 0, ".
                         " ADD COLUMN segquisal double(19,4) DEFAULT 0; ";					
			    break;
			   
			    case "POSTGRES":
			    $ls_sql= " ALTER TABLE sno_thsalida ".
                         " ADD COLUMN priquisal float8 DEFAULT 0, ".
                         " ADD COLUMN segquisal float8 DEFAULT 0;";		
		        break;	  				  
			 }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_11-3");
					$lb_valido=false;
				}
			 }
		}
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_11
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_12()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_12
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 27/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_personal ADD fecleypen date DEFAULT '1900-01-01';";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_personal ADD fecleypen date DEFAULT '1900-01-01';";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_personal ADD fecleypen date DEFAULT '1900-01-01';";		
		       break;			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_12");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_12
//-----------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_13()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_13
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;	  
	   $ls_existe = $this->io_function_db->uf_select_constraint('srh_dt_cargo','srh_dt_cargo_codemp_fkey');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE srh_dt_cargo  DROP CONSTRAINT srh_dt_cargo_codemp_fkey;";		
				break;	
				
				case "MYSQLT":
					$ls_sql= " ALTER TABLE srh_dt_cargo DROP FOREIGN KEY srh_dt_cargo_codemp_fkey;";		
				break;				  
				
				case "MYSQLI":
					$ls_sql= " ALTER TABLE srh_dt_cargo DROP FOREIGN KEY srh_dt_cargo_codemp_fkey;";		
				break;				  
		   }
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_13-1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_13
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
function uf_create_release_db_libre_V_2008_2_14()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_14
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;	
	   $ls_existe="";	   
	   $ls_existe = $this->io_function_db->uf_select_constraint('srh_dt_cargo','FK_srh_dt_cargo_2');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {				   
				case "MYSQLT":
					$ls_sql= " ALTER TABLE srh_dt_cargo  DROP FOREIGN KEY FK_srh_dt_cargo_2;";		
				break;				  
		   }
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_14");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_14
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_15()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_15
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   $lb_existe = $this->io_function_db->uf_select_table('srh_tipocontratos');
	   if (!$lb_existe)
	   {
	    	switch($_SESSION["ls_gestor"])
	        {
			   case "POSTGRES":
			   	$ls_sql=" CREATE TABLE srh_tipocontratos(  ".
		   			    " codemp     char(4)     not null, ".
		                " codtipcon  char(15)    not null, ".
		   			    " dentipcon  char(254)   not null, ".
		                " PRIMARY KEY (codtipcon, codemp), ".
		                " FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ".
					    " ON DELETE RESTRICT ON UPDATE RESTRICT)  WITHOUT OIDS;  ";
			   break;
			   
			   case "MYSQLT":
			   	$ls_sql=" CREATE TABLE srh_tipocontratos(  ".
                        " codemp      char(4)    not null, ".
                        " codtipcon   char(15)   not null, ".
                        " dentipcon   char(254)  not null, ".
                        " PRIMARY KEY (codtipcon, codemp)  ".
                        " ) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
			   break;
			   
			   case "MYSQLI":
			   	$ls_sql=" CREATE TABLE srh_tipocontratos(  ".
                        " codemp      char(4)    not null, ".
                        " codtipcon   char(15)   not null, ".
                        " dentipcon   char(254)  not null, ".
                        " PRIMARY KEY (codtipcon, codemp)  ".
                        " ) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
			   break;
			}	
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-1");
					$lb_valido=false;
				}
			}
			//--------------------------------contrains en caso de mysql--------------------------------------------------------
			    $ls_sql="";
				$li_row="";
				switch($_SESSION["ls_gestor"])
				{
				   case "MYSQLT":
					$ls_sql=" ALTER TABLE srh_tipocontratos ".
							" ADD CONSTRAINT FK_srh_tipocontratos_1 FOREIGN KEY FK_srh_tipocontratos_1 (codemp) ".
							" REFERENCES sigesp_empresa (codemp) ".
							" ON DELETE RESTRICT  ".
							" ON UPDATE RESTRICT; ";
				   break;
				   case "MYSQLI":
					$ls_sql=" ALTER TABLE srh_tipocontratos ".
							" ADD CONSTRAINT FK_srh_tipocontratos_1 FOREIGN KEY FK_srh_tipocontratos_1 (codemp) ".
							" REFERENCES sigesp_empresa (codemp) ".
							" ON DELETE RESTRICT  ".
							" ON UPDATE RESTRICT; ";
				   break;
				}	
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-1.1");
						$lb_valido=false;
					}
				}	
			//------------------------------------------------------------------------------------------------------------------	
	   }//fin del Existe de la tabla srh_tipocontratos
	   
	   $ls_existe="";
	   $lb_existe = $this->io_function_db->uf_select_table('srh_contratos');
	   if (!$lb_existe)
	   {
	    	switch($_SESSION["ls_gestor"])
	        {
			   case "POSTGRES":
			   	$ls_sql=" CREATE TABLE srh_contratos ( ".
					    " codemp       char(4), ".
					    " nroreg       char(15) not null, ".
					    " codtipcon    char(15) not null, ".
					    " fecini       date, ".
					    " codper       char(15), ".
					    " fecfin	date, ".
					    " descripcion  char(254),  ".
					    " observacion	char(254), ".
					    " codcar 	char (10), ".
					    " codnom 	char (4),  ".
					    " minorguniadm char (4), ".
					    " ofiuniadm 	char (2), ".
					    " uniuniadm 	char (2), ".
					    " depuniadm 	char (2), ".
					    " prouniadm 	char (2), ".
					    " funcion 	char (254), ".
					    " horario 	char (254), ".
					    " monto	float, ".
					    " estado	char (15), ".
					    " PRIMARY KEY(codemp,nroreg), ".
					    " FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT ON UPDATE RESTRICT,  ".
					    " FOREIGN KEY(codemp,codtipcon) REFERENCES srh_tipocontratos (codemp,codtipcon) ".
						" ON DELETE RESTRICT ON UPDATE RESTRICT, ".
					    " FOREIGN KEY(codemp,minorguniadm,ofiuniadm,uniuniadm,depuniadm,prouniadm) ".
						" REFERENCES sno_unidadadmin(codemp, minorguniadm, ofiuniadm, uniuniadm, depuniadm, prouniadm) ".
						" ON DELETE RESTRICT ON UPDATE RESTRICT)  WITHOUT OIDS; ";
			   break;
			   
			   case "MYSQLT":
			   	$ls_sql="CREATE TABLE srh_contratos ( ".
					    " codemp  	  char(4)   not null,  ".
					    " nroreg         char(15)  not null, ".
					    " codtipcon      char(15) not null, ".
					    " fecini         date, ".
					    " codper         char(15), ".
					    " fecfin	  date, ".
					    " descripcion    char(254), ".
					    " observacion	  char(254), ".
					    " monto	  float, ".
					    " codcar 	  char (10), ".
					    " codnom 	  char (4), ".
					    " minorguniadm   char (4), ".
					    " ofiuniadm 	  char (2), ".
					    " uniuniadm 	  char (2), ".
					    " depuniadm 	  char (2), ".
					    " prouniadm 	  char (2), ".
					    " funcion 	  char (254), ".
					    " horario 	  char (254), ".
					    " estado	  char (15), ".
					    " PRIMARY KEY(codemp,nroreg) ".
					    " )  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";
			   break;
			}	
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-2");
					$lb_valido=false;
				}
			}
			//--------------------------------contrains en caso de mysql--------------------------------------------------------
			    $ls_sql="";
				$li_row="";
				switch($_SESSION["ls_gestor"])
				{
				   case "MYSQLT":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_1 FOREIGN KEY FK_srh_contratos_1 (codemp) ".
    						" REFERENCES sigesp_empresa(codemp) ".
    						" ON DELETE RESTRICT  ".
    						" ON UPDATE RESTRICT; ";
				   break;
				   case "MYSQLI":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_1 FOREIGN KEY FK_srh_contratos_1 (codemp) ".
    						" REFERENCES sigesp_empresa(codemp) ".
    						" ON DELETE RESTRICT  ".
    						" ON UPDATE RESTRICT; ";
				   break;
				}	
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-2.1");
						$lb_valido=false;
					}
				}	
				
				$ls_sql="";
				$li_row="";
				switch($_SESSION["ls_gestor"])
				{
				   case "MYSQLT":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_2 FOREIGN KEY FK_srh_contratos_2 (codemp,codtipcon) ".
    						" REFERENCES srh_tipocontratos (codemp,codtipcon) ".
    						" ON DELETE RESTRICT ".
    						" ON UPDATE RESTRICT;";
				   break;
				   case "MYSQLI":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_2 FOREIGN KEY FK_srh_contratos_2 (codemp,codtipcon) ".
    						" REFERENCES srh_tipocontratos (codemp,codtipcon) ".
    						" ON DELETE RESTRICT ".
    						" ON UPDATE RESTRICT;";
				   break;
				}	
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-2.2");
						$lb_valido=false;
					}
				}	
				
				$ls_sql="";
				$li_row="";
				switch($_SESSION["ls_gestor"])
				{
				   case "MYSQLT":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_3 FOREIGN KEY FK_srh_contratos_3 ".
							" (codemp,minorguniadm,ofiuniadm,uniuniadm,depuniadm,prouniadm) ".
							" REFERENCES sno_unidadadmin (codemp,minorguniadm,ofiuniadm,uniuniadm,depuniadm,prouniadm) ".
							" ON DELETE RESTRICT ON UPDATE RESTRICT;";
				   break;

				   case "MYSQLI":
					$ls_sql=" ALTER TABLE srh_contratos ".
    						" ADD CONSTRAINT FK_srh_contratos_3 FOREIGN KEY FK_srh_contratos_3 ".
							" (codemp,minorguniadm,ofiuniadm,uniuniadm,depuniadm,prouniadm) ".
							" REFERENCES sno_unidadadmin (codemp,minorguniadm,ofiuniadm,uniuniadm,depuniadm,prouniadm) ".
							" ON DELETE RESTRICT ON UPDATE RESTRICT;";
				   break;
				}	
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_15-2.3");
						$lb_valido=false;
					}
				}	
			//------------------------------------------------------------------------------------------------------------------	
	   }//fin del Existe de la tabla srh_contratos	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_15
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_15_1()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_15
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_contratos ".
							"   ADD COLUMN codcar char (10), ".
							"   ADD COLUMN codnom char (4),  ".
							"   ADD COLUMN minorguniadm char (4), ".
							"   ADD COLUMN ofiuniadm char (2), ".
							"   ADD COLUMN uniuniadm char (2), ".
							"   ADD COLUMN depuniadm char (2), ".
							"   ADD COLUMN prouniadm char (2), ".
							"   ADD COLUMN funcion char (254), ".
							"   ADD COLUMN horario char (254); ";					
				   break;
				   
		case "MYSQLI":
				   $ls_sql= " ALTER TABLE srh_contratos ".
							"   ADD COLUMN codcar char (10), ".
							"   ADD COLUMN codnom char (4),  ".
							"   ADD COLUMN minorguniadm char (4), ".
							"   ADD COLUMN ofiuniadm char (2), ".
							"   ADD COLUMN uniuniadm char (2), ".
							"   ADD COLUMN depuniadm char (2), ".
							"   ADD COLUMN prouniadm char (2), ".
							"   ADD COLUMN funcion char (254), ".
							"   ADD COLUMN horario char (254); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_contratos ".
							"   ADD COLUMN codcar char (10), ".
							"   ADD COLUMN codnom char (4),  ".
							"   ADD COLUMN minorguniadm char (4), ".
							"   ADD COLUMN ofiuniadm char (2), ".
							"   ADD COLUMN uniuniadm char (2), ".
							"   ADD COLUMN depuniadm char (2), ".
							"   ADD COLUMN prouniadm char (2), ".
							"   ADD COLUMN funcion char (254), ".
							"   ADD COLUMN horario char (254); ";							
					break;  
				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_15_1");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_15
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_16()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_16
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/06/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;	     
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE srh_puntuacion_bono_merito ADD  COLUMN nompunt char(254);";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE srh_puntuacion_bono_merito ADD  COLUMN nompunt char(254); ";							
		        break;  			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_16-1");
			 	$lb_valido=false;
		 	}
		}
	   //----------------------------------------------------------------------------------------------------------------------//
	     $ls_codemp=$_SESSION["la_empresa"]["codemp"];
	   	 $ls_select="SELECT codpunt, nombpunt FROM srh_puntuacion_bono_merito";
		 $rs_data=$this->io_sql->select($ls_select);
		 if ($rs_data==true)
		 {	
			 while($row=$this->io_sql->fetch_row($rs_data))
			 {
				$ls_codpunt=$row["codpunt"];
				$ls_nombpunt=$row["nombpunt"];
				$li_update="";
				$ls_update= " UPDATE srh_puntuacion_bono_merito SET nompunt='".$ls_nombpunt."'".
							" WHERE codemp='".$ls_codemp."' AND codpunt='".$ls_codpunt."'";			
				$li_update=$this->io_sql->execute($ls_update);
				if($li_update===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_16-2");
					$lb_valido=false;
				}				
			 } 
		 }
		 //-----elimina el campo nombpunt  de la tabla srh_puntuacion_bono_merito-----------///
		 switch($_SESSION["ls_gestor"])
	     {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE srh_puntuacion_bono_merito DROP COLUMN nombpunt;";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE srh_puntuacion_bono_merito DROP COLUMN nombpunt;";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE srh_puntuacion_bono_merito DROP COLUMN nombpunt; ";							
		        break;  
			  
		 }
		 if (!empty($ls_sql))
		 {	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_16-3");
			 	$lb_valido=false;
		 	}
		 }    
	   //----------------------------------------------------------------------------------------------------------------------//
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_16
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_2_17()
   {			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//	     Function: uf_create_release_db_libre_V_2008_2_17
			//		   Access: public 
			//        Modulos: SSS
			//	  Description: 
			// Fecha Creacion: 30/06/2008 								Fecha Ultima Modificacion : 
			////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;
		   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  CREATE TABLE sss_permisos_internos_grupos ( ".
						    "  codemp CHAR(4) NOT NULL, ".
							"  codsis CHAR(3) NOT NULL, ".
							"  nomgru CHAR(60) NOT NULL, ".
							"   PRIMARY KEY (codemp, codsis, nomgru)) ".
							"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					  
				   break;

				case "MYSQLI":
				   $ls_sql= "  CREATE TABLE sss_permisos_internos_grupos ( ".
						    "  codemp CHAR(4) NOT NULL, ".
							"  codsis CHAR(3) NOT NULL, ".
							"  nomgru CHAR(60) NOT NULL, ".
							"   PRIMARY KEY (codemp, codsis, nomgru)) ".
							"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					  
				   break;
				   
				case "POSTGRES":
				   $ls_sql="  CREATE TABLE sss_permisos_internos_grupos( ".
							"   codemp char(4), ".
							"   codsis char(3), ".
							"   nomgru char(60), ".
							"   CONSTRAINT pk_sss_permisos_internos_grupos PRIMARY KEY (codemp, codsis, nomgru),". 
							"   CONSTRAINT FK_sss_permisos_internos_grupos_1 ".
							"   FOREIGN KEY (codemp, nomgru) REFERENCES sss_grupos (codemp, nomgru)  ".  
							"   ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;";			   
				   break;					
			}	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_17 -1");
				 $lb_valido=false;
			}
			///----------------------------------cosntrains-----------------------------------------------------------------
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sss_permisos_internos_grupos ".
				  			"  ADD CONSTRAINT FK_sss_permisos_internos_grupos_1 ".
							"  FOREIGN KEY FK_sss_permisos_internos_grupos_1 (codemp, nomgru) ".
							"  REFERENCES sss_grupos (codemp, nomgru) ".
							"  ON DELETE RESTRICT ".
							"  ON UPDATE RESTRICT, COMMENT = 'InnoDB free: 73728 kB'";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_17-2");
						 $lb_valido=false;
					}							  
				   break;			

				case "MYSQLI":
				   $ls_sql= "  ALTER TABLE sss_permisos_internos_grupos ".
				  			"  ADD CONSTRAINT FK_sss_permisos_internos_grupos_1 ".
							"  FOREIGN KEY FK_sss_permisos_internos_grupos_1 (codemp, nomgru) ".
							"  REFERENCES sss_grupos (codemp, nomgru) ".
							"  ON DELETE RESTRICT ".
							"  ON UPDATE RESTRICT, COMMENT = 'InnoDB free: 73728 kB'";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_17-2");
						 $lb_valido=false;
					}							  
				   break;			
			}					
			///-------------------------------------------------------------------------------------------------------------
		   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_17
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_18()
	{				/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_18
		//		   Access: public 
		//        Modulos: SSS
		//	  Description: 
		// Fecha Creacion: 30/06/2008 								Fecha Ultima Modificacion : 
				////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			   $lb_valido=true;
			   $ls_sql="";
			   /*switch($_SESSION["ls_gestor"])
			   {
					case "MYSQLT":
					   $ls_sql="  ALTER TABLE sss_derechos_grupos ".
					   		   "  ADD COLUMN codintper VARCHAR(33) NOT NULL AFTER ejecutar, ".
 							   "  DROP PRIMARY KEY, ".
 							   "  ADD PRIMARY KEY  USING BTREE(codemp, nomgru, codsis, nomven, codintper); ";			  
					   break;
					   
					case "POSTGRES":
					   $ls_sql=" ALTER TABLE sss_derechos_grupos DROP CONSTRAINT pk_sss_derechos_grupos; ";			   
					   break;						
				}	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_18-1");
					 $lb_valido=false;
				}
				
				//------------------------------------------------------------------------------------------------------
				switch($_SESSION["ls_gestor"])
				   {
						case "MYSQLT":
						   $ls_sql="  ALTER TABLE sss_derechos_grupos ".
						           "  ADD CONSTRAINT FK_sss_derechos_grupos_3 ".
								   "  FOREIGN KEY FK_sss_derechos_grupos_3 (codemp, codsis, nomgru, codintper) ".
								   "  REFERENCES sss_permisos_internos_grupos (codemp, codsis, nomgru, codintper) ".
								   "  ON DELETE RESTRICT ".
								   "  ON UPDATE RESTRICT, COMMENT = 'InnoDB free: 36864 kB';";			  
						   break;
						   
						case "POSTGRES":
						   $ls_sql=" ALTER TABLE sss_derechos_grupos ADD COLUMN codintper varchar(33); ";			   
						   break;	   
						
					}	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_18-2");
						 $lb_valido=false;
					}
				//-----------------------------------------------------------------------------------------------------
				switch($_SESSION["ls_gestor"])
				   {
						case "POSTGRES":
						   $ls_sql=" ALTER TABLE sss_derechos_grupos ADD CONSTRAINT pk_sss_derechos_grupos ".
						           " PRIMARY KEY (codemp, nomgru, codsis, nomven, codintper); ";
						   $li_row=$this->io_sql->execute($ls_sql);
								if($li_row===false)
								{ 
									 $this->io_msg->message("Problemas al ejecutar Release 2008_2_18-3");
									 $lb_valido=false;
								}			   
						   break;					
					}	
					
				//-----------------------------------------------------------------------------------------------------
				switch($_SESSION["ls_gestor"])
				   {					   
						   case "POSTGRES":
						   $ls_sql=" ALTER TABLE sss_derechos_grupos ".
						           " ADD CONSTRAINT FK_sss_derechos_grupos_3 ".
								   " FOREIGN KEY (codemp, codsis, nomgru, codintper) ".
								   " REFERENCES sss_permisos_internos_grupos (codemp, codsis, nomgru, codintper) ".
								   " ON UPDATE NO ACTION ON DELETE NO ACTION; ";			   
						   $li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								 $this->io_msg->message("Problemas al ejecutar Release 2008_2_18-4");
								 $lb_valido=false;
							}
						   break;					
					}			*/			
				//-----------------------------------------------------------------------------------------------------
			   return $lb_valido;	
			} // end function uf_create_release_db_libre_V_2008_2_18		
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_19()
     {			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//	     Function: uf_create_release_db_libre_V_2008_2_19
			//		   Access: public 
			//        Modulos: RRHH
			//	  Description: 
			// Fecha Creacion: 01/07/2008 								Fecha Ultima Modificacion : 			////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;
		   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
				   $ls_sql= " CREATE TABLE srh_defcontrato( ".
						    " codemp   char(4) NOT NULL, ".
						    " codcont  char(3) NOT NULL, ".
						    " descont  char(254), ".
						    " concont  text,      ".
						    " tamletcont integer, ".
						    " intlincont integer, ".
						    " marinfcont double precision DEFAULT (3), ".
						    " marsupcont double precision DEFAULT (4), ".
						    " titcont    text,       ".
						    " piepagcont text,       ".
						    " tamletpiecont integer, ".
						    " arcrtfcont char (50),  ".
						    " PRIMARY KEY (codemp, codcont), ".
						    " FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp) ".
							" ON DELETE RESTRICT ON UPDATE RESTRICT) WITHOUT OIDS;  ";					  
				   break;
				   
				case "MYSQLT":
				   $ls_sql=" CREATE TABLE srh_defcontrato( ".
						   " codemp   char(4) NOT NULL, ".
						   " codcont  char(3) NOT NULL, ".
						   " descont  char(254), ".
						   " concont  text, ".
						   " tamletcont integer, ".
						   " intlincont integer, ".
						   " marinfcont float, ".
						   " marsupcont float, ".
						   " titcont    text, ".
						   " piepagcont text, ".
						   " tamletpiecont integer, ".
						   " arcrtfcont char (50),  ".
						   " PRIMARY KEY (codemp, codcont) ".
						   " ) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;  ";			   
				   break;				
				   
				case "MYSQLI":
				   $ls_sql=" CREATE TABLE srh_defcontrato( ".
						   " codemp   char(4) NOT NULL, ".
						   " codcont  char(3) NOT NULL, ".
						   " descont  char(254), ".
						   " concont  text, ".
						   " tamletcont integer, ".
						   " intlincont integer, ".
						   " marinfcont float, ".
						   " marsupcont float, ".
						   " titcont    text, ".
						   " piepagcont text, ".
						   " tamletpiecont integer, ".
						   " arcrtfcont char (50),  ".
						   " PRIMARY KEY (codemp, codcont) ".
						   " ) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;  ";			   
				   break;				
			}	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_19 -1");
				 $lb_valido=false;
			}
			///----------------------------------cosntrains-----------------------------------------------------------------
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE srh_defcontrato ".
    						"  ADD CONSTRAINT FK_srh_defcontrato_1 FOREIGN KEY FK_srh_defcontrato_1 (codemp) ".
    						"  REFERENCES sigesp_empresa(codemp) ".
    						"  ON DELETE RESTRICT ".
    						"  ON UPDATE RESTRICT;";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_19-2");
						 $lb_valido=false;
					}							  
				   break;			

				case "MYSQLI":
				   $ls_sql= "  ALTER TABLE srh_defcontrato ".
    						"  ADD CONSTRAINT FK_srh_defcontrato_1 FOREIGN KEY FK_srh_defcontrato_1 (codemp) ".
    						"  REFERENCES sigesp_empresa(codemp) ".
    						"  ON DELETE RESTRICT ".
    						"  ON UPDATE RESTRICT;";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_19-2");
						 $lb_valido=false;
					}							  
				   break;			
			}	
				
			///-------------------------------------------------------------------------------------------------------------
		   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_19
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_20()
    {			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//	     Function: uf_create_release_db_libre_V_2008_2_20
			//		   Access: public 
			//        Modulos: RRHH
			//	  Description: 
			// Fecha Creacion: 09/07/2008 								Fecha Ultima Modificacion : 
			////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;
		   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  CREATE TABLE srh_premiacion ( ".
							"	   codemp    char(4)    not null, ".
							"	   codper    char (10)    not null, ".
							"	   numprem   char(10)   not null, ".
							"	   fecprem   date, ".
							"	   denprem   char (254), ". 
							"	   motivoprem  char(254),  ".
							"	   PRIMARY KEY(codemp,numprem)) ".
							"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					  
				   break;
				   
				case "POSTGRES":
				   $ls_sql= "  CREATE TABLE srh_premiacion ( ".
							"	   codemp    char(4)    not null, ".
							"	   codper    char (10)    not null, ".
							"	   numprem   char(10)   not null, ".
							"	   fecprem   date, ".
							"	   denprem   char (254), ".
							"	   motivoprem  char(254), ".
							"	   PRIMARY KEY(codemp,numprem), ".
							"	   FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp) ".
							"      ON DELETE RESTRICT ON UPDATE RESTRICT, ".
							"	   FOREIGN KEY(codemp,codper) REFERENCES sno_personal (codemp,codper) ".
							"      ON DELETE RESTRICT ON UPDATE RESTRICT)  WITHOUT OIDS;";			   
				   break;	   
				
			}	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_20 -1");
				 $lb_valido=false;
			}
			///----------------------------------cosntrains-----------------------------------------------------------------
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE srh_premiacion ".
                            "  ADD CONSTRAINT FK_srh_premiacion_1 ".
							"  FOREIGN KEY FK_srh_premiacion_1 (codemp)  REFERENCES sigesp_empresa(codemp) ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT ";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_20-2");
						 $lb_valido=false;
					}	
					
					$ls_sql="";
					$ls_sql= "  ALTER TABLE srh_premiacion ".
                             "  ADD CONSTRAINT FK_srh_premiacion_2 ".
							 "  FOREIGN KEY FK_srh_premiacion_2 (codemp,codper) REFERENCES sno_personal (codemp,codper) ".
							 "  ON DELETE RESTRICT ON UPDATE RESTRICT ";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_20-3");
						 $lb_valido=false;
					}							  
				   break;			

				case "MYSQLI":
				   $ls_sql= "  ALTER TABLE srh_premiacion ".
                            "  ADD CONSTRAINT FK_srh_premiacion_1 ".
							"  FOREIGN KEY FK_srh_premiacion_1 (codemp)  REFERENCES sigesp_empresa(codemp) ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT ";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_20-2");
						 $lb_valido=false;
					}	
					
					$ls_sql="";
					$ls_sql= "  ALTER TABLE srh_premiacion ".
                             "  ADD CONSTRAINT FK_srh_premiacion_2 ".
							 "  FOREIGN KEY FK_srh_premiacion_2 (codemp,codper) REFERENCES sno_personal (codemp,codper) ".
							 "  ON DELETE RESTRICT ON UPDATE RESTRICT ";
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_20-3");
						 $lb_valido=false;
					}							  
				   break;			
			}	
				
			///-------------------------------------------------------------------------------------------------------------
		   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_20
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_21()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_21
		//		   Access: public 
		//        Modulos: Recursos Humanos
		//	  Description: 
		// Fecha Creacion: 09/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   $lb_existe = $this->io_function_db->uf_select_table('srh_llamada_atencion');
	   if ($lb_existe)
	   {
	    $ls_drop = "DROP TABLE srh_llamada_atencion;";
		$li_row=$this->io_sql->execute($ls_drop);
		 if($li_row===false)
		 { 
			 $this->io_msg->message("Problemas al ejecutar Release 2008_2_21 - 1");
		 }
	   }
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			   $ls_sql=" CREATE TABLE srh_llamada_atencion ( ".
					   "   codemp    char(4)    not null, ".
					   "   nrollam   char(10)   not null, ".
					   "   codtrab   char(15), ".
					   "   fecllam   date, ".
					   "   unidad  char(254), ".
					   "   causa    char (1), ".
					   "   tipo    char (1), ".
					   "   descripcion char(254), ".
					   "   PRIMARY KEY(codemp,nrollam), ".
					   "   FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ".
					   "   ON DELETE RESTRICT ON UPDATE RESTRICT, ".
					   "   FOREIGN KEY(codemp,codtrab) REFERENCES sno_personal (codemp,codper) ".
					   "   ON DELETE RESTRICT ON UPDATE RESTRICT )  WITHOUT OIDS;";
		        break;
			 
		}
		if (!empty($ls_sql))
		{	
		 $li_row=$this->io_sql->execute($ls_sql);
		 if($li_row===false)
		 { 
			 $this->io_msg->message("Problemas al ejecutar Release 2008_2_21");
			 $lb_valido=false;
		 }
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_21
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_22()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_22
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 11/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			   $ls_sql=" CREATE TABLE cxp_rd_amortizacion( ".
					   " codemp char(4), ".
					   " numrecdoc char(15), ". 
					   " codtipdoc char(5),  ".
					   " cod_pro char(10),   ".
					   " ced_bene char(10),  ".
					   " codamo char(5),     ".
					   " cuenta varchar(25), ".
					   " monamo float8,      ".
					   " monsal float8,      ".
					   " montotamo float8,   ".
					   " CONSTRAINT pk_cxp_rd_amortizacion PRIMARY KEY ".
					   " (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene, codamo), ".
					   " FOREIGN KEY (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene) ".
					   " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene) ".
					   " ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;";
		        break;	
				
			 case "MYSQLT":
				$ls_sql=" CREATE TABLE cxp_rd_amortizacion( ".
					    " codemp char(4), ".
					    " numrecdoc char(15), ". 
						"  codtipdoc char(5), ".
						"  cod_pro char(10),  ".
						"  ced_bene char(10), ".
						"  codamo char(5),    ".
						"  cuenta varchar(25),".
						"  monamo float8,     ".
						"  monsal float8,     ".
						"  montotamo float8,  ".
						"  CONSTRAINT pk_cxp_rd_amortizacion PRIMARY KEY ".
						"  (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene, codamo)) ".
						"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
				break;	

				
			 case "MYSQLI":
				$ls_sql=" CREATE TABLE cxp_rd_amortizacion( ".
					    " codemp char(4), ".
					    " numrecdoc char(15), ". 
						"  codtipdoc char(5), ".
						"  cod_pro char(10),  ".
						"  ced_bene char(10), ".
						"  codamo char(5),    ".
						"  cuenta varchar(25),".
						"  monamo float8,     ".
						"  monsal float8,     ".
						"  montotamo float8,  ".
						"  CONSTRAINT pk_cxp_rd_amortizacion PRIMARY KEY ".
						"  (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene, codamo)) ".
						"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
				break;	
			 
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_22-1");
				 $lb_valido=false;
			 }
		}
		//------------constrainst MYSQL-----------------------------------------------------
			switch($_SESSION["ls_gestor"])
			{
				case "MYSQLT":
					$ls_sql= " ALTER TABLE cxp_rd_amortizacion ".
							 " ADD CONSTRAINT FK_cxp_rd_amortizacion_2 ".
							 " FOREIGN KEY FK_cxp_rd_amortizacion_2 (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene)".
							 " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene) ".
							 " ON DELETE RESTRICT ON UPDATE RESTRICT";
					break;	

				case "MYSQLI":
					$ls_sql= " ALTER TABLE cxp_rd_amortizacion ".
							 " ADD CONSTRAINT FK_cxp_rd_amortizacion_2 ".
							 " FOREIGN KEY FK_cxp_rd_amortizacion_2 (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene)".
							 " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, cod_pro, ced_bene) ".
							 " ON DELETE RESTRICT ON UPDATE RESTRICT";
					break;	
				 
			
				if (!empty($ls_sql))
				{	
					 $li_row=$this->io_sql->execute($ls_sql);
					 if($li_row===false)
					 { 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_22-2");
						 $lb_valido=false;
					 }
				}	
			}	
		//-----------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_22
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_23()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_23
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 11/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			   $ls_sql=" CREATE TABLE cxp_dt_amortizacion( ".
					   " codemp char(4), ".
					   " numrecdoc char(15), ".
					   " codtipdoc char(5), ".
					   " ced_bene char(10), ".
					   " cod_pro char(10), ".
					   " codamo char(5), ".
					   " monto float8, ".
					   " CONSTRAINT pk_cxp_dt_amortizacion PRIMARY KEY ".
					   " (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, codamo), ". 
					   " CONSTRAINT fk_cxp_dt_amortizacion__cxp_rd FOREIGN KEY ".
					   " (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
					   " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
					   " ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;	";
		        break;
				
			  case "MYSQLT":
				 $ls_sql=" CREATE TABLE cxp_dt_amortizacion( ".
						 " codemp char(4),  ".
						 " numrecdoc char(15), ". 
						 " codtipdoc char(5),  ".
						 " ced_bene char(10),  ".
						 " cod_pro char(10),   ".
						 " codamo char(5),     ".
						 " monto float8,       ".
						 " CONSTRAINT pk_cxp_dt_amortizacion PRIMARY KEY  ".
						 " (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, codamo)) ".
						 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
				break;			
				
			  case "MYSQLI":
				 $ls_sql=" CREATE TABLE cxp_dt_amortizacion( ".
						 " codemp char(4),  ".
						 " numrecdoc char(15), ". 
						 " codtipdoc char(5),  ".
						 " ced_bene char(10),  ".
						 " cod_pro char(10),   ".
						 " codamo char(5),     ".
						 " monto float8,       ".
						 " CONSTRAINT pk_cxp_dt_amortizacion PRIMARY KEY  ".
						 " (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, codamo)) ".
						 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
				break;			
			 
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_23-1");
				 $lb_valido=false;
			 }
		}
		//------------constrainst MYSQL-----------------------------------------------------
			switch($_SESSION["ls_gestor"])
			{
				case "MYSQLT":
					$ls_sql= " ALTER TABLE cxp_dt_amortizacion ".
							 " ADD CONSTRAINT FK_cxp_dt_amortizacion_2  ".
							 " FOREIGN KEY FK_cxp_dt_amortizacion_2 (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
							 " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
							 " ON DELETE RESTRICT ON UPDATE RESTRICT";
					break;	

				case "MYSQLI":
					$ls_sql= " ALTER TABLE cxp_dt_amortizacion ".
							 " ADD CONSTRAINT FK_cxp_dt_amortizacion_2  ".
							 " FOREIGN KEY FK_cxp_dt_amortizacion_2 (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
							 " REFERENCES cxp_rd (codemp, numrecdoc, codtipdoc, ced_bene, cod_pro) ".
							 " ON DELETE RESTRICT ON UPDATE RESTRICT";
					break;	
				 
			
				if (!empty($ls_sql))
				{	
					 $li_row=$this->io_sql->execute($ls_sql);
					 if($li_row===false)
					 { 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_2_23-2");
						 $lb_valido=false;
					 }
				}	
			}	
		//-----------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_23
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_24()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_24
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 16/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_personalnomina ".
						"   ADD descasicar varchar(100);";					
			   break;
			   
			case "MYSQLI":
 			   $ls_sql= " ALTER TABLE sno_personalnomina ".
						"   ADD descasicar varchar(100);";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_personalnomina ".
						"   ADD descasicar varchar(100);";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_24-1");
				 $lb_valido=false;
			 }
		}
		//-----------------------------------------------------------------------------------------------------
		$ls_sql="";
		switch($_SESSION["ls_gestor"])
	    {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_hpersonalnomina ".
						"   ADD descasicar varchar(100);";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_hpersonalnomina ".
						"   ADD descasicar varchar(100);";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_24-2");
				 $lb_valido=false;
			 }
		}
	   //--------------------------------------------------------------------------------------------------------
	    $ls_sql="";
		switch($_SESSION["ls_gestor"])
	    {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_thpersonalnomina ".
						"   ADD descasicar varchar(100);";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_thpersonalnomina ".
						"   ADD descasicar varchar(100);";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_24-3");
				 $lb_valido=false;
			 }
		}
	   //--------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_24
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_25()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_25
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 18/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE sno_programacionreporte ".
						"	ADD numcarf int4  DEFAULT 0, ".
						"	ADD numcarm int4  DEFAULT 0, ".
						"	ADD numcarv int4  DEFAULT 0, ".
						"	ADD  carenef int4 DEFAULT 0, ".
						"	ADD  carfebf int4 DEFAULT 0, ".
						"	ADD  carmarf int4 DEFAULT 0, ".
						"	ADD  carabrf int4 DEFAULT 0, ".
						"	ADD  carmayf int4 DEFAULT 0, ".
						"	ADD  carjunf int4 DEFAULT 0, ".
						"	ADD  carjulf int4 DEFAULT 0, ".
						"	ADD  caragof int4 DEFAULT 0, ".
						"	ADD  carsepf int4 DEFAULT 0, ".
						"	ADD  caroctf int4 DEFAULT 0, ".
						"	ADD  carnovf int4 DEFAULT 0, ".
						"	ADD  cardicf int4 DEFAULT 0, ".
						"	ADD  carenem int4 DEFAULT 0, ".
						"	ADD  carfebm int4 DEFAULT 0, ".
						"	ADD  carmarm int4 DEFAULT 0, ".
						"	ADD  carabrm int4 DEFAULT 0, ".
						"	ADD  carmaym int4 DEFAULT 0, ".
						"	ADD  carjunm int4 DEFAULT 0, ".
						"	ADD  carjulm int4 DEFAULT 0, ".
						"	ADD  caragom int4 DEFAULT 0, ".
						"	ADD  carsepm int4 DEFAULT 0, ".
						"	ADD  caroctm int4 DEFAULT 0, ".
						"	ADD  carnovm int4 DEFAULT 0, ".
						"	ADD  cardicm int4 DEFAULT 0; ";					
			   break;
			   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sno_programacionreporte ".
						"	ADD numcarf int4  DEFAULT 0, ".
						"	ADD numcarm int4  DEFAULT 0, ".
						"	ADD numcarv int4  DEFAULT 0, ".
						"	ADD  carenef int4 DEFAULT 0, ".
						"	ADD  carfebf int4 DEFAULT 0, ".
						"	ADD  carmarf int4 DEFAULT 0, ".
						"	ADD  carabrf int4 DEFAULT 0, ".
						"	ADD  carmayf int4 DEFAULT 0, ".
						"	ADD  carjunf int4 DEFAULT 0, ".
						"	ADD  carjulf int4 DEFAULT 0, ".
						"	ADD  caragof int4 DEFAULT 0, ".
						"	ADD  carsepf int4 DEFAULT 0, ".
						"	ADD  caroctf int4 DEFAULT 0, ".
						"	ADD  carnovf int4 DEFAULT 0, ".
						"	ADD  cardicf int4 DEFAULT 0, ".
						"	ADD  carenem int4 DEFAULT 0, ".
						"	ADD  carfebm int4 DEFAULT 0, ".
						"	ADD  carmarm int4 DEFAULT 0, ".
						"	ADD  carabrm int4 DEFAULT 0, ".
						"	ADD  carmaym int4 DEFAULT 0, ".
						"	ADD  carjunm int4 DEFAULT 0, ".
						"	ADD  carjulm int4 DEFAULT 0, ".
						"	ADD  caragom int4 DEFAULT 0, ".
						"	ADD  carsepm int4 DEFAULT 0, ".
						"	ADD  caroctm int4 DEFAULT 0, ".
						"	ADD  carnovm int4 DEFAULT 0, ".
						"	ADD  cardicm int4 DEFAULT 0; ";		
		        break;			
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_2_25");
				 $lb_valido=false;
			 }
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_25
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_26()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_26
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 18/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_permiso ADD COLUMN tothorper float; ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_permiso ADD COLUMN tothorper float;";							
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_26");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_26

//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_27()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_27
		//		   Access: public 
		//        Modulos: SAF
		//	  Description: 
		// Fecha Creacion: 21/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		case "MYSQLT":
				   $ls_sql= " ALTER TABLE saf_movimiento add ubigeoact varchar(100); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE saf_movimiento add ubigeoact varchar(100);";							
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_27");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_27
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_28()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_28
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 22/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $lb_existe="";
	   $lb_existe =$this->io_function_db->uf_select_column('sigesp_empresa','clactacont');
	   if ($lb_existe)
	   {
	   	   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				      $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN clactacont;               ";					    				
					   break;
					   
				case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN clactacont;               ";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_28-1");
					$lb_valido=false;
				}
			}	
	   }
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa ADD clactacon int2; ";					
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa ADD clactacon int2; ";						
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_28-2");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_28
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_29()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_29
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 23/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE cxp_clasificador_rd ADD sc_cuenta char(25); ";					
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE cxp_clasificador_rd ADD sc_cuenta char(25); ";						
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_29");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_29
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_30()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_30
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 230/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;	  
	   $ls_existe = $this->io_function_db->uf_select_constraint('srh_premiacion','srh_premiacion_pkey');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE srh_premiacion  DROP CONSTRAINT srh_premiacion_pkey;";		
				break;				  
		   }
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_30-1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 
	   //---------------CREAR NUEVAMENTE LA CLAVE PRIMARIA------------------------------------------
	    switch($_SESSION["ls_gestor"])
		   {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE srh_premiacion  ".
					         " ADD CONSTRAINT srh_premiacion_2_pkey PRIMARY KEY (codemp,numprem,codper);";		
				break;				  
		   }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_30-2");
				$lb_valido=false;
			}
		}	
	   //----------------------------------------------------------------------------------------------   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_30
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_31()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_31
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 23/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";
	   $lb_existe =$this->io_function_db->uf_select_column('sigesp_empresa','empconso');
	   if ($lb_existe)
	   {
	   	   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				      $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN empconso;                 ";					    				
					   break;
					   
				case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN empconso;                 ";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_31-1");
					$lb_valido=false;
				}
			}	
	   } 
	   //--------------------------------------------------------------------------------- 
	   $lb_existe="";
	   $lb_existe =$this->io_function_db->uf_select_column('sigesp_empresa','bdconso');
	   if ($lb_existe)
	   {
	   	   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				      $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN bdconso;                  ";					    				
					   break;
					   
				case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN bdconso;                  ";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_31-2");
					$lb_valido=false;
				}
			}	
	   }  
	   //----------------------------------------------------------------------------------
	   $lb_existe="";
	   $lb_existe =$this->io_function_db->uf_select_column('sigesp_empresa','codaltemp');
	   if ($lb_existe)
	   {
	   	   $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				      $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN codaltemp;                ";					    				
					   break;
					   
				case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sigesp_empresa            ".
						       "  DROP COLUMN codaltemp;                ";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_31-3");
					$lb_valido=false;
				}
			}	
	   }  
	   //----------------------------------------------------------------------------------
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa      ".
				            " ADD estempcon  int2  DEFAULT 0, ".								
							" ADD codaltemp  CHAR(4);         ";		
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sigesp_empresa     ".
				             " ADD estempcon  int2 DEFAULT 0, ".						 
							 " ADD codaltemp  CHAR(4);        ";					
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_31-4");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_31
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_32()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_32
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " CREATE TABLE srh_hmovimiento_personal( ".
							 " codemp character(4) NOT NULL,          ".
							 " codhmov integer NOT NULL,              ".
							 " nummov character varying(15) NOT NULL, ".
							 " fecreg date,							  ".
							 " codper character varying(10) NOT NULL, ".
							 " codcar character varying(10) NOT NULL, ".
							 " codgra character varying(15),          ".
							 " codpas character varying(15),          ".
							 " suebas double precision,               ".
							 " motivo text,                           ".
							 " observacion text,                      ".
							 " codnom character(4),                   ".
							 " minorguniadm character(4),             ".
							 " ofiuniadm character(2),                ".
							 " uniuniadm character(2),                ".
							 " depuniadm character(2),                ".
							 " prouniadm character(2),                ".
							 " CONSTRAINT srh_hmovimiento_personal_pkey PRIMARY KEY (codemp, codhmov),       ".
							 " CONSTRAINT srh_hmovimiento_personal_codemp_fkey FOREIGN KEY (codemp, codper)  ".
							 " REFERENCES sno_personal (codemp, codper) MATCH SIMPLE                         ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT,                                        ".
							 " CONSTRAINT srh_hmovimiento_personal_codemp_fkey1 FOREIGN KEY (codemp)         ".
							 " REFERENCES sigesp_empresa (codemp) MATCH SIMPLE                               ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT)                                        ".
							 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                    ";			
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " CREATE TABLE srh_hmovimiento_personal( ".
							 " codemp character(4) NOT NULL,          ".
							 " codhmov integer NOT NULL,              ".
							 " nummov character varying(15) NOT NULL, ".
							 " fecreg date,							  ".
							 " codper character varying(10) NOT NULL, ".
							 " codcar character varying(10) NOT NULL, ".
							 " codgra character varying(15),          ".
							 " codpas character varying(15),          ".
							 " suebas double precision,               ".
							 " motivo text,                           ".
							 " observacion text,                      ".
							 " codnom character(4),                   ".
							 " minorguniadm character(4),             ".
							 " ofiuniadm character(2),                ".
							 " uniuniadm character(2),                ".
							 " depuniadm character(2),                ".
							 " prouniadm character(2),                ".
							 " CONSTRAINT srh_hmovimiento_personal_pkey PRIMARY KEY (codemp, codhmov),       ".
							 " CONSTRAINT srh_hmovimiento_personal_codemp_fkey FOREIGN KEY (codemp, codper)  ".
							 " REFERENCES sno_personal (codemp, codper) MATCH SIMPLE                         ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT,                                        ".
							 " CONSTRAINT srh_hmovimiento_personal_codemp_fkey1 FOREIGN KEY (codemp)         ".
							 " REFERENCES sigesp_empresa (codemp) MATCH SIMPLE                               ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT) WITHOUT OIDS;                          ";					
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_33");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_33
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_33()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_33
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				    $ls_sql= " CREATE TABLE sno_causales( ".
							 " codemp   char(4) NOT NULL, ".
							 " codcausa char(4) NOT NULL, ".
							 " dencausa varchar(100) NOT NULL, ".
							 " CONSTRAINT sno_causales_pkey PRIMARY KEY (codemp, codcausa),     ".
							 " CONSTRAINT sno_causales_codemp_fkey FOREIGN KEY (codemp)         ".
							 " REFERENCES sigesp_empresa (codemp)                               ".
							 " MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT)              ".
							 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                    ";					
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " CREATE TABLE sno_causales( ".
							 " codemp   char(4) NOT NULL, ".
							 " codcausa char(4) NOT NULL, ".
							 " dencausa varchar(100) NOT NULL, ".
							 " CONSTRAINT sno_causales_pkey PRIMARY KEY (codemp, codcausa),     ".
							 " CONSTRAINT sno_causales_codemp_fkey FOREIGN KEY (codemp)         ".
							 " REFERENCES sigesp_empresa (codemp)                               ".
							 " MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT) WITHOUT OIDS;" ;				
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_33");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_33
//------------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_34()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_34
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_personal ".
				            " ADD codcausa char(4);    ";								
				   break;
				   
			case "POSTGRES":
				     $ls_sql= " ALTER TABLE sno_personal ".
				              " ADD codcausa char(4);    ";				
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_34");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_34
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_35()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_35
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 28/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				     $ls_sql= " CREATE TABLE sigesp_consolidacion( ".
							  " codemp varchar(4) NOT NULL,        ".
							  " nombasdat varchar(254) NOT NULL,   ".
							  " codestpro1 varchar(25) NOT NULL,   ".
							  " estcla char(1) NOT NULL,           ".
							  " CONSTRAINT pk_sigesp_consolidacion PRIMARY KEY ".
							  " (codemp, nombasdat, codestpro1, estcla)) ".
							  " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;    ";									
				   break;
				   
			case "POSTGRES":
				     $ls_sql= " CREATE TABLE sigesp_consolidacion( ".
							  " codemp varchar(4) NOT NULL,        ".
							  " nombasdat varchar(254) NOT NULL,   ".
							  " codestpro1 varchar(25) NOT NULL,   ".
							  " estcla char(1) NOT NULL,           ".
							  " CONSTRAINT pk_sigesp_consolidacion PRIMARY KEY ".
							  " (codemp, nombasdat, codestpro1, estcla)) WITHOUT OIDS;    ";				
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_35");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_35
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_36()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_36
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 29/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_metodobanco ". 
							" ADD nroref char(1) DEFAULT 1; ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_metodobanco   ". 
							" ADD nroref char(1) DEFAULT 1; ";								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_36");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_36
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_37()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_37
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 30/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				    $ls_sql= " CREATE TABLE scg_cuentas_consolida( ".
  							 " codemp char(4) NOT NULL,            ".
  							 " sc_cuenta char(25) NOT NULL,        ".
  							 " status varchar(1) NOT NULL,       ".
							 " denominacion varchar(254) NOT NULL, ".
							 " nivel int2 NOT NULL,                  ".
							 " referencia varchar(25) NOT NULL,    ".
							 " CONSTRAINT pk_scg_cuentas_consolida PRIMARY KEY (codemp, sc_cuenta, status),    ".
							 " CONSTRAINT fk_scg_cuentas_consolida_scg_cuentas FOREIGN KEY (codemp, sc_cuenta) ".
							 "	  REFERENCES scg_cuentas (codemp, sc_cuenta) MATCH SIMPLE                     ".
							 "	  ON UPDATE NO ACTION ON DELETE NO ACTION)                                    ".
							 "     ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                  ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " CREATE TABLE scg_cuentas_consolida( ".
  							" codemp char(4) NOT NULL,            ".
  							" sc_cuenta char(25) NOT NULL,        ".
  							" status varchar(1) NOT NULL,       ".
							" denominacion varchar(254) NOT NULL, ".
							" nivel int2 NOT NULL,                  ".
							" referencia varchar(25) NOT NULL,    ".
							" CONSTRAINT pk_scg_cuentas_consolida PRIMARY KEY (codemp, sc_cuenta, status),    ".
							" CONSTRAINT fk_scg_cuentas_consolida_scg_cuentas FOREIGN KEY (codemp, sc_cuenta) ".
							"	  REFERENCES scg_cuentas (codemp, sc_cuenta) MATCH SIMPLE                     ".
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;                      ";								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_37");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_37
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_38()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_38
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 30/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= "  CREATE TABLE scg_saldos_consolida	(  ".
							"  sc_cuenta char(25) NOT NULL,            ".
							"  codemp char(4) NOT NULL,                ".
							"  fecsal date NOT NULL,                   ".
							"  debe_mes float8 NOT NULL,               ".
							"  haber_mes float8 NOT NULL,              ".
							"  CONSTRAINT pk_scg_saldos_consolida PRIMARY KEY (sc_cuenta, codemp),            ".
							"  CONSTRAINT fk_scg_saldos_consolida_scg_cuentas FOREIGN KEY (sc_cuenta, codemp) ".
							"	  REFERENCES scg_cuentas (sc_cuenta, codemp) MATCH SIMPLE                     ".
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION)                                    ".
						    "     ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                  ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= "  CREATE TABLE scg_saldos_consolida	(  ".
				   			"  codemp char(4) NOT NULL,                ".
							"  sc_cuenta char(25) NOT NULL,            ".							
							"  fecsal date NOT NULL,                   ".
							"  debe_mes float8 NOT NULL,               ".
							"  haber_mes float8 NOT NULL,              ".
							"  CONSTRAINT pk_scg_saldos_consolida PRIMARY KEY (codemp, sc_cuenta),            ".
							"  CONSTRAINT fk_scg_saldos_consolida_scg_cuentas FOREIGN KEY (codemp,sc_cuenta)  ".
							"	  REFERENCES scg_cuentas (sc_cuenta, codemp) MATCH SIMPLE                     ".
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION)  WITHOUT OIDS;                     ";								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_38");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_38
//-----------------------------------------------------------------------------------------------------------------------------------
///---------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_39()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_39
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 31/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_contratos  ".
				            " ADD  apeper varchar (100), ".
							" ADD  nomper varchar (100), ".
							" ADD  nacper varchar (1),   ".
							" ADD  codpro varchar (3);   ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE srh_contratos  ".
				             " ADD  apeper varchar (100), ".
							 " ADD  nomper varchar (100), ".
							 " ADD  nacper varchar (1),   ".
							 " ADD  codpro varchar (3);   ";									
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_39");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_39
//----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_40()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_40
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 31/07/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE spg_ep1          ".
				            " ADD estint int2 default 0,   ".
							" ADD sc_cuenta char(25);      ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE spg_ep1          ".
				            " ADD estint int2 default 0,   ".
							" ADD sc_cuenta char(25);      ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_40");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_40
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_41()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_41
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 01/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_bono_merito   ".
				            " ADD codpun character(4);      ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_bono_merito   ".
				            " ADD codpun character(4);      ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_41");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_41
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_42()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_42
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 01/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= "  CREATE TABLE srh_puntosunitri (".
							"  codemp     char(4) not null, ".
							"  codpun     char(4) not null, ".
							"  denpun     varchar(254),     ".
							"  codtipper  char(15) not null,".
							"  valunitri  float,            ".
							"  PRIMARY KEY(codemp,codpun),  ".
							"  FOREIGN KEY(codemp, codtipper) REFERENCES srh_tipopersonal(codemp, codtipper) ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT, ".
							"  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT )                ".
							"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                    ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= "  CREATE TABLE srh_puntosunitri (".
							"  codemp     char(4) not null, ".
							"  codpun     char(4) not null, ".
							"  denpun     varchar(254),     ".
							"  codtipper  char(15) not null,".
							"  valunitri  float,            ".
							"  PRIMARY KEY(codemp,codpun),  ".
							"  FOREIGN KEY(codemp, codtipper) REFERENCES srh_tipopersonal(codemp, codtipper) ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT, ".
							"  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT ) WITHOUT OIDS;  ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_42");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_42
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_43()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_43
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 01/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= "  CREATE TABLE srh_dt_puntosunitri ( ".
							"  codemp        char(4) not null,    ".
							"  codpun        char(4) not null,    ".
							"  prompun       int,                 ".
							"  unitri        int ,                ".
							"  monbs         float,               ".
							"  PRIMARY KEY(codemp,codpun,prompun),".
							"  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT ON UPDATE RESTRICT, ".
							"  FOREIGN KEY(codemp,codpun) REFERENCES  srh_puntosunitri (codemp,codpun)   ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT)                      ".
							"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                    ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= "  CREATE TABLE srh_dt_puntosunitri ( ".
							"  codemp        char(4) not null,    ".
							"  codpun        char(4) not null,    ".
							"  prompun       int,                 ".
							"  unitri        int ,                ".
							"  monbs         float,               ".
							"  PRIMARY KEY(codemp,codpun,prompun),".
							"  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT ON UPDATE RESTRICT, ".
							"  FOREIGN KEY(codemp,codpun) REFERENCES  srh_puntosunitri (codemp,codpun)   ".
							"  ON DELETE RESTRICT ON UPDATE RESTRICT) WITHOUT OIDS;                      ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_43");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_43
//----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_44()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_44
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 03/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_concepto          ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_concepto          ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_44");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_44
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_45()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_45
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 03/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_hconcepto                            ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_hconcepto                            ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_45");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_45
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_46()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_46
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 03/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_thconcepto                           ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";						
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_thconcepto                           ".
				            " ADD asifidper character(1) NOT NULL DEFAULT 0,       ".
							" ADD asifidpat character(1) NOT NULL DEFAULT 0,       ".
							" ADD frevarcon character(1) NOT NULL DEFAULT 0        ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_46");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_46
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_47()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_47
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 03/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_bono_merito          ".
				            " ADD codtipper character(15);         ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_bono_merito          ".
				            " ADD codtipper character(15);         ";				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_47");
					$lb_valido=false;
				}
			}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_47
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_48()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_48
		//		   Access: public 
		//        Modulos:CFG
		//	  Description: 
		// Fecha Creacion: 04/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa add basdatcon varchar(100); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa add basdatcon varchar(100); ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_48");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_48
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_49()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_49
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 05/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_personalnomina ".
							" ADD coddep char(15);           ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_personalnomina ".
							" ADD coddep char(15);           ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_49");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_49
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_50()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_50
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 05/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_hpersonalnomina ".
							" ADD coddep char(15);           ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_hpersonalnomina ".
							" ADD coddep char(15);           ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_50");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_50
//----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_51()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_51
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 05/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_thpersonalnomina ".
							" ADD coddep char(15);           ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_thpersonalnomina ".
							" ADD coddep char(15);           ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_51");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_51
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_52()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_52
		//		   Access: public 
		//        Modulos: SPG
		//	  Description: 
		// Fecha Creacion: 05/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE spg_cuentas ADD COLUMN scgctaint varchar(25) NOT NULL DEFAULT '-'; ";					
				   break;
				   
				case "POSTGRES":
				  $ls_sql= " ALTER TABLE spg_cuentas ADD COLUMN scgctaint varchar(25) NOT NULL DEFAULT '-'; ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_52");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_52
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_53()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_53
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa ADD COLUMN estcamemp  int2 DEFAULT 0; ";					
				   break;
				   
				case "POSTGRES":
				  $ls_sql= " ALTER TABLE sigesp_empresa ADD COLUMN estcamemp  int2 DEFAULT 0; ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_53");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_53
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_54()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_54
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= "  CREATE TABLE siv_dt_scg_int(    ".
				            "  codemp char(4) NOT NULL,        ".
							"  codart char(20) NOT NULL,       ".
							"  codcmp char(15) NOT NULL,       ".
							"  feccmp date NOT NULL,           ".
							"  sc_cuenta varchar(25) NOT NULL, ".
							"  debhab char(1) NOT NULL,        ".
							"  monto float8,				   ".
							"  estint int2,                    ".
							"  montoaux float8,                ".
							"  fechaconta date DEFAULT '1900-01-01', ".
							"  fechaanula date DEFAULT '1900-01-01', ".
							"  estrepasi int,                        ".  
							"  CONSTRAINT pk_siv_dt_scg_int PRIMARY KEY (codart, codcmp, feccmp, sc_cuenta, debhab, codemp), ".
							"  CONSTRAINT fk_siv_dt_scg_int_siv_artic_siv_arti FOREIGN KEY (codemp, codart)                  ". 
							"	  REFERENCES siv_articulo (codemp, codart) MATCH SIMPLE                                      ".
							"	  ON UPDATE RESTRICT ON DELETE RESTRICT)                                                     ".
							"     ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;                                 ";					
				   break;
				   
				case "POSTGRES":
				  $ls_sql= "  CREATE TABLE siv_dt_scg_int(     ".
						   "  codemp char(4) NOT NULL,        ".
						   "  codart char(20) NOT NULL,       ".
						   "  codcmp char(15) NOT NULL,       ".
						   "  feccmp date NOT NULL,           ".
						   "  sc_cuenta varchar(25) NOT NULL, ".
						   "  debhab char(1) NOT NULL,        ".
						   "  monto float8,                   ".
						   "  estint int2,                    ".
						   "  montoaux float8,                ".
						   "  fechaconta date DEFAULT '1900-01-01'::date, ".
						   "  fechaanula date DEFAULT '1900-01-01'::date, ".
						   "  estrepasi int2, ".
						   "  CONSTRAINT pk_siv_dt_scg_int PRIMARY KEY (codart, codcmp, feccmp, sc_cuenta, debhab, codemp), ".
						   "  CONSTRAINT fk_siv_dt_scg_int_siv_artic_siv_arti FOREIGN KEY (codemp, codart) ".
						   "	  REFERENCES siv_articulo (codemp, codart) MATCH SIMPLE ".
						   "	  ON UPDATE RESTRICT ON DELETE RESTRICT ) WITHOUT OIDS; ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_54");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_54
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_55()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_55
		//		   Access: public 
		//        Modulos: SSS
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= "   CREATE TABLE  sigesp_proc_cons( ".
							"   codproc  char(6) not null,      ".
							"   codsis   char(3)    not null,   ".
							"   denproc  varchar(254) not null, ".
							"   constraint pk_sigesp_proc_cons primary key (codproc, codsis)) ".
							"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;     ";					
				   break;
				   				   
				case "POSTGRES":
				  $ls_sql= " CREATE TABLE  sigesp_proc_cons( ".
				           " codproc  char(6) not null,      ".
						   " codsis   char(3)    not null,   ".
						   " denproc  varchar(254) not null, ".
						   " constraint pk_sigesp_proc_cons primary key (codproc, codsis), ".
						   " constraint fk_sigesp_proc_cons__sss_sist foreign key (codsis) ".
						   " references sss_sistemas (codsis)                              ".  
						   " on delete restrict on update restrict) WITHOUT OIDS;          ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_55 - 1");
				$lb_valido=false;
			}
		}
		if ($lb_valido)
		{
			$ls_sql="";	
			switch($_SESSION["ls_gestor"])
		    {
				case "MYSQLT":
					$ls_sql= "   alter table sigesp_proc_cons                                      ".
							 "   add constraint fk_sigesp_proc_cons__sss_sist foreign key (codsis) ".
							 "	  references sss_sistemas (codsis)                                 ".
							 "	  on delete restrict on update restrict;                           ";					
				break;								  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_55 - 2");
					$lb_valido=false;
				}
			}	
		
		}//fin del if		
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_55
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_56()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_56
		//		   Access: public 
		//        Modulos: SSS
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= "  CREATE TABLE  sigesp_dt_proc_cons(                            ".
							"   codres   varchar(10) not null,                               ".
							"   codproc  char(6) not null,                                   ".
							"   codsis   char(3)    not null,                                ".
							"   fecha    date not null,                                      ".
							"   bdorigen varchar(80) not null,                               ".
							"   bddestino varchar(80) not null,                              ".
							"   descripcion varchar(500),                                    ".
							"   constraint pk_sigesp_proc_dt_cons                            ".
							"   primary key (codres,codproc,codsis,fecha,bdorigen,bddestino) ".
							"   )ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;   ";					
				   break;
				   				   
				case "POSTGRES":
				  $ls_sql= "   CREATE TABLE  sigesp_dt_proc_cons( ".
						   "   codres   varchar(10) not null,     ".
						   "   codproc  char(6) not null,         ".
						   "   codsis   char(3)    not null,      ".
						   "   fecha    date not null,            ".
						   "   bdorigen varchar(80) not null,     ".
						   "   bddestino varchar(80) not null,    ".
						   "   descripcion varchar(500),          ".
						   "   constraint pk_sigesp_proc_dt_cons primary key (codres,codproc,codsis,fecha,bdorigen,bddestino), ".
						   "   constraint fk_sig_dt_proc_cons__sig_proc_cons foreign key (codproc, codsis) ".
						   "   references sigesp_proc_cons (codproc, codsis)                               ".
						   "		  on delete restrict on update restrict ) WITHOUT OIDS;                ";						
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_56 - 1");
				$lb_valido=false;
			}
		}
		if ($lb_valido)
		{
			$ls_sql="";	
			switch($_SESSION["ls_gestor"])
		    {
				case "MYSQLT":
					$ls_sql= "  alter table sigesp_dt_proc_cons                      ".
							 "  add constraint fk_sig_dt_proc_cons__sig_proc_cons    ".
							 "  foreign key (codproc, codsis)                        ".
							 "	  references sigesp_proc_cons (codproc, codsis)      ".
							 "	  on delete restrict on update restrict;             ";			  	
				break;								  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_56 - 2");
					$lb_valido=false;
				}
			}	
		
		}//fin del if		
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_56
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_57()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_57
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_asignacioncargo ADD grado char(4); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_asignacioncargo ADD grado char(4); ";								
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_57");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_57
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_58()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_58
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_hasignacioncargo ADD grado char(4); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_hasignacioncargo ADD grado char(4); ";								
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_58");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_58
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_59()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_59
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 07/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_thasignacioncargo ADD grado char(4); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sno_thasignacioncargo ADD grado char(4); ";								
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_59");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_59
//----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_60()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_60
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 08/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " CREATE TABLE scg_casa_presu (                                    ".
							"  codemp char(4) NOT NULL,                                        ".
							"  sig_cuenta char(25) NOT NULL,                                   ".  
							"  sc_cuenta char(25),                                             ".
							"  CONSTRAINT pk_scg_casa_presu PRIMARY KEY (codemp, sig_cuenta),  ".
							"  CONSTRAINT fk_scg_casa_presu FOREIGN KEY (codemp)               ".
							"	  REFERENCES sigesp_empresa (codemp) MATCH SIMPLE              ".  
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION,                     ".
							"  CONSTRAINT fk_scg_casa_presu2 FOREIGN KEY (sig_cuenta)          ".
							"	  REFERENCES sigesp_plan_unico_re (sig_cuenta) MATCH SIMPLE    ".
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION)	                   ".
							"     ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;    ";				
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " CREATE TABLE scg_casa_presu (                                    ".
							"  codemp char(4) NOT NULL,                                        ".
							"  sig_cuenta char(25) NOT NULL,                                   ".  
							"  sc_cuenta char(25),                                             ".
							"  CONSTRAINT pk_scg_casa_presu PRIMARY KEY (codemp, sig_cuenta),  ".
							"  CONSTRAINT fk_scg_casa_presu FOREIGN KEY (codemp)               ".
							"	  REFERENCES sigesp_empresa (codemp) MATCH SIMPLE              ".  
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION,                     ".
							"  CONSTRAINT fk_scg_casa_presu2 FOREIGN KEY (sig_cuenta)          ".
							"	  REFERENCES sigesp_plan_unico_re (sig_cuenta) MATCH SIMPLE    ".
							"	  ON UPDATE NO ACTION ON DELETE NO ACTION)	WITHOUT OIDS;      ";								
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_60");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_60
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_61()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_61
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 08/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa        ".
							" ADD estparsindis int DEFAULT 0;   ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa          ".
							" ADD estparsindis int2 DEFAULT 0;    ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_61");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_61
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_62()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_62
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 12/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa        ".
							" ADD basdatcmp varchar(150);       ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE sigesp_empresa        ".
							 " ADD basdatcmp varchar(150);       ";				
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_62");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_62
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_63()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_63
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 13/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " CREATE TABLE saf_depreciacion_int(      ".
							"  codemp char(4) NOT NULL,         ".
							"  procede char(6) NOT NULL,        ".
							"  comprobante char(15) NOT NULL,   ".
							"  fecha date NOT NULL,             ".
							"  codban char(3) NOT NULL DEFAULT '---', ".
							"  ctaban char(25) NOT NULL DEFAULT '-------------------------', ".
							"  sc_cuenta char(25) NOT NULL,     ".
							"  procede_doc char(6) NOT NULL,    ".
							"  documento char(15) NOT NULL,     ".
							"  debhab char(1) NOT NULL,         ".
							"  descripcion text NOT NULL,       ".  
							"  monto float8 NOT NULL,           ".
							"  orden int4 NOT NULL,             ".
							"  estrepasi int4 NOT NULL,         ".
							"  CONSTRAINT  pk_saf_depreciacion_int PRIMARY KEY               ".
							"  (codemp, procede, sc_cuenta, comprobante, procede_doc,       ".
 							"   documento, fecha, codban, ctaban, debhab))                  ".
							"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;   ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " CREATE TABLE saf_depreciacion_int ( ".
							 " codemp char(4) NOT NULL,            ". 
							 " procede char(6) NOT NULL,           ".
							 " comprobante char(15) NOT NULL,      ".
							 " fecha date NOT NULL,                ".
							 " codban char(3) NOT NULL DEFAULT '---'::bpchar, ".
							 " ctaban char(25) NOT NULL DEFAULT '-------------------------'::bpchar, ".
							 " sc_cuenta char(25) NOT NULL,        ".
							 " procede_doc char(6) NOT NULL,       ".
							 " documento char(15) NOT NULL,        ".
							 " debhab char(1) NOT NULL,            ".
							 " descripcion text NOT NULL,          ".
							 " monto float8 NOT NULL,              ".
							 " orden int4 NOT NULL,                ".
							 " estrepasi int4 NOT NULL,            ".
							 " CONSTRAINT pk_saf_depreciacion_int PRIMARY KEY ".
							 " (codemp, procede, sc_cuenta, comprobante, procede_doc,".
							 "  documento, fecha, codban, ctaban, debhab), ".
							 " CONSTRAINT fk_saf_depreciacion_int_scg_cuent_scg_cuen FOREIGN KEY (codemp, sc_cuenta) ". 
							 " REFERENCES scg_cuentas (codemp, sc_cuenta) MATCH SIMPLE ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT, ".
							 " CONSTRAINT fk_saf_depreciacion_int_sigesp_cm_sigesp_c FOREIGN KEY  ".
							 " (codemp, procede, comprobante, fecha, codban, ctaban) ".
							 " REFERENCES sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban) MATCH SIMPLE ".
							 " ON UPDATE RESTRICT ON DELETE RESTRICT)	WITHOUT OIDS; ";				
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_63-1");
				$lb_valido=false;
			}
		}
		if ($lb_valido)	
		{
			   $ls_sql="";	   
			   switch($_SESSION["ls_gestor"])
			   {
					   case "MYSQLT":
						   $ls_sql= " ALTER TABLE saf_depreciacion_int                                             ".
						            " ADD CONSTRAINT fk_saf_depreciacion_int_scg_cuent_scg_cuen_cuen               ".
						            " FOREIGN KEY (codemp, sc_cuenta)  REFERENCES scg_cuentas (codemp, sc_cuenta), ".
                                    " ADD  CONSTRAINT fk_saf_depreciacion_int_sigesp_cm_sigesp_c                   ".
									" FOREIGN KEY (codemp, procede, comprobante, fecha, codban, ctaban)            ".
									" REFERENCES sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban)  ";					
						   break;		   
							  
				}
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_63-2-(Ver el tipo de Datos)");
						$lb_valido=false;
					}
				}
		}	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_63 //-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_64()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_64
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 13/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " CREATE TABLE sno_dt_scg_int ( ".
							"	  codemp char(4) NOT NULL,  ".
							"	  codnom char(4) NOT NULL,  ".
							"	  codperi char(3) NOT NULL, ".
							"	  codcom char(15) NOT NULL, ".
							"	  tipnom char(1) NOT NULL,  ".
							"	  sc_cuenta char(25) NOT NULL, ".
							"	  debhab char(1) NOT NULL,     ".
							"	  codconc char(10) NOT NULL,   ".
							"	  cod_pro varchar(10) NOT NULL,  ".
							"	  ced_bene varchar(10) NOT NULL, ".
							"	  tipo_destino varchar(1) NOT NULL,  ".
							"	  descripcion varchar(254) NOT NULL, ".
							"	  monto float8 NOT NULL,             ".
							"	  estatus int NOT NULL,              ".
							"	  estrd int NOT NULL,                ".
							"	  codtipdoc varchar(5) NOT NULL,     ".
							"	  estnumvou int NOT NULL,            ".
							"	  estnotdeb int NOT NULL,            ".
							"	  codcomapo varchar(15) NOT NULL,    ".
							"	  fechaconta date DEFAULT '1900-01-01', ".
							"	  fechaanula date DEFAULT '1900-01-01', ".
							"	  montoaux float8,                      ".
							"	  CONSTRAINT pk_sno_dt_scg_int PRIMARY KEY ".
							"     (codemp, codnom, codperi, tipnom, sc_cuenta, debhab, codcom, codconc)) ".
							"     ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci               ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " CREATE TABLE sno_dt_scg_int(     ".     
							 "    codemp char(4) NOT NULL,      ".
  							 "    codnom char(4) NOT NULL,      ".
							 "    codperi char(3) NOT NULL,     ".
							 "    codcom char(15) NOT NULL,     ".
							 "    tipnom char(1) NOT NULL,      ".
							 "    sc_cuenta char(25) NOT NULL,  ".
							 "    debhab char(1) NOT NULL,      ".
							 "    codconc char(10) NOT NULL,    ".
							 "    cod_pro varchar(10) NOT NULL, ".
							 "	  ced_bene varchar(10) NOT NULL,".
							 "	  tipo_destino varchar(1) NOT NULL,  ".
							 "	  descripcion varchar(254) NOT NULL, ".
							 "	  monto float8 NOT NULL,             ".
							 "	  estatus int2 NOT NULL,             ".
							 "	  estrd int2 NOT NULL,               ". 
							 "	  codtipdoc varchar(5) NOT NULL,     ".
							 "	  estnumvou int2 NOT NULL,           ".
							 "	  estnotdeb int2 NOT NULL,           ".
							 "	  codcomapo varchar(15) NOT NULL,    ".
							 "	  fechaconta date DEFAULT '1900-01-01', ".
							 "	  fechaanula date DEFAULT '1900-01-01', ".
							 "	  montoaux float8,                      ".
							 "	  CONSTRAINT pk_sno_dt_scg_int PRIMARY KEY  ".
							 "    (codemp, codnom, codperi, tipnom, sc_cuenta, debhab, codcom, codconc), ".
							 "	  CONSTRAINT fk_sno_dt_s_int_empresa___sigesp_e FOREIGN KEY (codemp)     ".
							 "	  REFERENCES sigesp_empresa (codemp) MATCH SIMPLE                        ".
							 "	  ON UPDATE RESTRICT ON DELETE RESTRICT,                                 ".
							 "	  CONSTRAINT fk_sno_dt_s_int_sno_nomin_sno_nomi FOREIGN KEY (codemp, codnom) ".
							 "	  REFERENCES sno_nomina (codemp, codnom) MATCH SIMPLE                     ".
							 "	  ON UPDATE RESTRICT ON DELETE RESTRICT) WITHOUT OIDS;                    ";				
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_64-1");
				$lb_valido=false;
			}
		}
		if ($lb_valido)	
		{
			   $ls_sql="";	   
			   switch($_SESSION["ls_gestor"])
			   {
					   case "MYSQLT":
						   $ls_sql= " ALTER TABLE sno_dt_scg_int                                             ".
						            " ADD CONSTRAINT fk_sno_dt_s_int_empresa___sigesp_e FOREIGN KEY (codemp) ".
							        "	  REFERENCES sigesp_empresa (codemp), ".
                                    " ADD CONSTRAINT fk_sno_dt_s_int_sno_nomin_sno_nomi FOREIGN KEY (codemp, codnom) ".
							        "	  REFERENCES sno_nomina (codemp, codnom)  ";					
						   break;		   
							  
				}
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_2_64-2-(Ver el tipo de Datos)");
						$lb_valido=false;
					}
				}
		}	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_64 
  
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_65()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_65
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 14/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				  $ls_sql= " CREATE TABLE cxp_cmp_islr ( ".
							 "  codemp char(4),            ".
							 "  numcmpislr varchar(15),    ".
							 "  numsol varchar(15),        ".
							 "  cod_pro varchar(10),       ". 
							 "  ced_bene varchar(10),      ".
							 "  consol text,               ".
							 "  CONSTRAINT pk_cxp_cmp_islr PRIMARY KEY (codemp, numcmpislr, numsol),  ".
							 "  CONSTRAINT fk_sigesp_empresa__cxp_cmp_islr FOREIGN KEY (codemp)       ".
							 "  REFERENCES sigesp_empresa (codemp)                                    ".
							 "  ON UPDATE NO ACTION ON DELETE NO ACTION	)                             ".
							 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci              ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " CREATE TABLE cxp_cmp_islr ( ".
							 "  codemp char(4),            ".
							 "  numcmpislr varchar(15),    ".
							 "  numsol varchar(15),        ".
							 "  cod_pro varchar(10),       ". 
							 "  ced_bene varchar(10),      ".
							 "  consol text,               ".
							 "  CONSTRAINT pk_cxp_cmp_islr PRIMARY KEY (codemp, numcmpislr, numsol),  ".
							 "  CONSTRAINT fk_sigesp_empresa__cxp_cmp_islr FOREIGN KEY (codemp)       ".
							 "  REFERENCES sigesp_empresa (codemp)                                    ".
							 "  ON UPDATE NO ACTION ON DELETE NO ACTION	) WITHOUT OIDS;               ";				
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_65");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_65
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_66()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_66
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 14/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				  $ls_sql= " CREATE TABLE cxp_dt_cmp_islr ( ".
							 "  codemp char(4),               ".
							 "  numcmpislr varchar(15),       ".
							 "  numsol varchar(15),           ".
							 "  numrecdoc varchar(15),        ".
							 "  numref  varchar(15),          ".
							 "  fecpag date,                  ".
							 "  monobjret float8,             ".
							 "  porded float8,                ".
							 "  totimpret float8,             ".
							 "  CONSTRAINT pk_cxp_dt_cmp_islr PRIMARY KEY (codemp, numcmpislr, numsol, numrecdoc), ".
							 "  CONSTRAINT fk_cxp_cmp_islr__cxp_dt_cmp_islr             ".
							 "  FOREIGN KEY (codemp, numcmpislr, numsol) REFERENCES     ".
							 "  cxp_cmp_islr (codemp, numcmpislr, numsol)               ".
							 "  ON UPDATE NO ACTION ON DELETE NO ACTION)                ".
							 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " CREATE TABLE cxp_dt_cmp_islr ( ".
							 "  codemp char(4),               ".
							 "  numcmpislr varchar(15),       ".
							 "  numsol varchar(15),           ".
							 "  numrecdoc varchar(15),        ".
							 "  numref  varchar(15),          ".
							 "  fecpag date,                  ".
							 "  monobjret float8,             ".
							 "  porded float8,                ".
							 "  totimpret float8,             ".
							 "  CONSTRAINT pk_cxp_dt_cmp_islr PRIMARY KEY (codemp, numcmpislr, numsol, numrecdoc), ".
							 "  CONSTRAINT fk_cxp_cmp_islr__cxp_dt_cmp_islr             ".
							 "  FOREIGN KEY (codemp, numcmpislr, numsol) REFERENCES     ".
							 "  cxp_cmp_islr (codemp, numcmpislr, numsol)               ".
							 "  ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;  ";				
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_66");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_66
//-----------------------------------------------------------------------------------------------------------------------------------
///----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_67()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_67
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 15/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $lb_existe =$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','prompun','DOUBLE(19,4)');					
			 break;
				   
			case "POSTGRES":
				 $lb_existe =$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','prompun','double precision');   								
			break;  				  
		}
	  
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_dt_puntosunitri MODIFY COLUMN prompun DOUBLE(19,4); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_dt_puntosunitri ALTER prompun TYPE double precision; ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data 2008_2_67");
					$lb_valido=false;
				}
			}	   			
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_67
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_68()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_68
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 15/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','unitri','DOUBLE(19,4)');				
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('srh_dt_puntosunitri','unitri','double precision'); 								
			break;  				  
		}
	   
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE srh_dt_puntosunitri MODIFY COLUMN unitri DOUBLE(19,4); ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE srh_dt_puntosunitri ALTER unitri TYPE double precision; ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_68");
					$lb_valido=false;
				}
			}	   			
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_68
//-----------------------------------------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_69()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_69
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 15/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE scb_cmp_ret ADD COLUMN basdatori varchar(100);";					
			   break;
			   
			case "POSTGRES":
			    $ls_sql= " ALTER TABLE scb_cmp_ret ADD COLUMN basdatori varchar(100);";				
		        break;  			  
		}
		if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_69");
			 	$lb_valido=false;
		 	}
		}
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_69
//----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_70()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_70
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	  /* $lb_existe="";
	   $lb_existe =$this->io_function_db->uf_select_vista('cierre_contableaportes_contable');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_01();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-1");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('cierre_contableaportes_contable_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_02();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-2");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('cierre_contableaportes_contable_proy');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_03();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-3");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('cierre_contableaportes_contable_proy_intcom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_04();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-4");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_aportes_scg_ajuste');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_05();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-5");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_aportes_scg_ajuste_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_06();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-6");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_conceptos_scg_ajuste');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_07();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-7");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_conceptos_scg_ajuste_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_08();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-8");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaporte_contable_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_09();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-9");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaporte_contable_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_10();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-10");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_11();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-11");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_intcom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_12();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-12");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_13();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-13");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_dt');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_14();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-14");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_dt_intcom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_15();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-15");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_16();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-16");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_17();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-17");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_intcom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_18();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-18");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_19();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-19");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_20();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-20");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_21();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-21");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_historico_intcontableconceptos_contable_intercom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_22();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-22");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_23();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-23");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_24();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-24");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_25();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-25");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_26();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-26");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_27();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-27");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_28();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-28");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_29();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-29");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_intercom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_30();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-30");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('load_aportes_scg_normales_ajuste_proyecto');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_31();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-31");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('load_aportes_scg_normales_ajuste_proyecto_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_32();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-32");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('load_conceptos_scg_normales_ajuste_proyecto');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_33();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-33");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('load_conceptos_scg_normales_ajuste_proyecto_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_34();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-34");
			}	   			
	   }*/
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_70
//-----------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_71()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_71
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 18/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;	  
	   $ls_existe = $this->io_function_db->uf_select_constraint('cxp_dt_cmp_islr','pk_cxp_dt_cmp_islr');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE cxp_dt_cmp_islr DROP CONSTRAINT pk_cxp_dt_cmp_islr;";		
				break;
				
				case "MSQLT":
					$ls_sql= " ALTER TABLE srh_dt_cargo DROP FOREIGN KEY pk_cxp_dt_cmp_islr;";		
				break;					  
		   }
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_2_71-1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe)
	   //---------------CREA UN NUEVO CAMPO EN LA TABAL--------------------------------------------
	    $ls_sql="";
	    switch($_SESSION["ls_gestor"])
	    {
			case "MYSQLT":
 			   $ls_sql= " ALTER TABLE cxp_dt_cmp_islr ADD COLUMN codded char(5) NOT NULL DEFAULT '-----';";					
			   break;
			   
			case "POSTGRES":
			    $ls_sql= " ALTER TABLE cxp_dt_cmp_islr ADD COLUMN codded char(5) NOT NULL DEFAULT '-----';";				
		        break;  			  
		}
		 if (!empty($ls_sql))
		{	
		 	$li_row=$this->io_sql->execute($ls_sql);
		 	if($li_row===false)
		 	{ 
			 	$this->io_msg->message("Problemas al ejecutar Release 2008_2_71-2");
			 	$lb_valido=false;
		 	}
		 } 
	   //---------------CREAR NUEVAMENTE LA CLAVE PRIMARIA------------------------------------------
	    if ($lb_valido)
		{
			 switch($_SESSION["ls_gestor"])
			 {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE cxp_dt_cmp_islr  ".
							 " ADD CONSTRAINT pk_cxp_dt_cmp_islr2  ".
							 " PRIMARY KEY (codemp, numcmpislr, numsol, numrecdoc, codded);";		
				break;				  
			  }
			 if (!empty($ls_sql))
			 {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_71-3");
					$lb_valido=false;
				}
			}	
		}
	   //----------------------------------------------------------------------------------------------   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_71
//-----------------------------------------------------------------------------------------------------------------------------------
///------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_2_72()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_72
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 20/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sep_solicitud    ".
				            " ADD nombenalt varchar(100);  ";								
				   break;
				   
			case "POSTGRES":
				      $ls_sql= " ALTER TABLE sep_solicitud    ".
				               " ADD nombenalt varchar(100);     ";					
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_72");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_72
//-------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_73()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_73
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 20/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sep_tiposolicitud  ".
				            " ADD estayueco char(1);         ";								
				   break;
				   
			case "POSTGRES":
				       $ls_sql= " ALTER TABLE sep_tiposolicitud  ".
				                " ADD estayueco char(1);         ";							
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_73");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_73
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_74()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_74
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 20/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_cmp             ".
				            " ADD esttrfcmp smallint DEFAULT 0;  ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sigesp_cmp             ".
				            " ADD esttrfcmp smallint DEFAULT 0;  ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_74");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_74
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_75()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_75
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 20/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "ALTER TABLE sno_personal add situacion char(1);  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= "ALTER TABLE sno_personal add situacion char(1);  ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_75");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_75
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_76()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_76
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "ALTER TABLE sep_solicitud ADD tipsepbie char(1) default '-';  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= "ALTER TABLE sep_solicitud ADD tipsepbie char(1) default '-';  ";							
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_76");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_76
//-----------------------------------------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_77()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_77
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "ALTER TABLE soc_sol_cotizacion ADD tipsolbie char(1) default '-';  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= "ALTER TABLE soc_sol_cotizacion ADD tipsolbie char(1) default '-';  ";							
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_77");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_77
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_78()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_78
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "ALTER TABLE soc_ordencompra ADD tipbieordcom char(1) default '-';  ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= "ALTER TABLE soc_ordencompra ADD tipbieordcom char(1) default '-';  ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_78");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_78
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_79()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_79
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 25/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa           ".
				            "   ADD estciespg smallint default 0,  ".
							"   ADD estciespi smallint default 0;  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa           ".
				            "   ADD estciespg smallint default 0,  ".
							"   ADD estciespi smallint default 0;  ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_79");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_79
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_80()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_80
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 26/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   /*$ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_ctrl_numero       ".
				            "   ADD estcompscg char(1) DEFAULT 0;  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_ctrl_numero       ".
				            "   ADD estcompscg char(1) DEFAULT 0;  ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_80");
				$lb_valido=false;
			}
		}	*/	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_80
//-----------------------------------------------------------------------------------------------------------------------------------

 	function uf_create_release_db_libre_V_2008_2_81()
	{
		$lb_valido=true;
		$ls_sql="";
		$lb_valido=true;
		$ls_sql="";
		switch($_SESSION["ls_gestor"])
		{
			case "MYSQLT":
			$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN confinstr VARCHAR(1) DEFAULT 'N'; ";
			break;
			
			case "POSTGRES":
			$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN confinstr varchar(1) DEFAULT 'N'; ";
			break;
		}
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{ 
			 $this->io_msg->message("Problemas al ejecutar Release 2008_2_81");			 		 
			 $lb_valido=false;
		}
        return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_81
//-----------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_82()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_82
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 27/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE scg_pc_reporte                   ".
				            "   ADD saldo_real_ant double(19,4) default 0, ".
							"   ADD saldo_apro double(19,4) default 0,     ".
							"   ADD saldo_mod double(19,4) default 0;      ";				
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scg_pc_reporte                       ".
				            "   ADD saldo_real_ant double precision default 0, ".
							"   ADD saldo_apro double precision default 0,     ".
							"   ADD saldo_mod double precision default 0;      ";							
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_82");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_82
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_2_83()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_83
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 27/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa          ".
				            "   ADD estintcred CHAR(1) DEFAULT 0; ";				
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE sigesp_empresa          ".
				             "   ADD estintcred CHAR(1) DEFAULT 0; ";								
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_83");
				$lb_valido=false;
			}
		}	
		
		//-----------------------------------------------------------------------------------------------------------------------
		
		/*switch($_SESSION["ls_gestor"])
			{
					case "MYSQLT":
						 $ls_sql= "  ALTER TABLE sigesp_ctrl_numero MODIFY COLUMN codusu char(30) ".
						          "              character SET utf8 COLLATE utf8_general_ci ";					
					break;
						   
				    case "POSTGRES":
						 $ls_sql= "  ALTER TABLE sigesp_ctrl_numero ALTER COLUMN codusu TYPE char(30);";
														
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_83-2");
					$lb_valido=false;
				}
			}	*/   			
		//-------------------------------------------------------------------------------------------------------	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_83
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_84()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_84
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 27/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				  $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco','conmov','longtext');				
			 break;
				   
			case "POSTGRES":
				 $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco','conmov','text');
				   								
			break;  				  
		}	   
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				    $ls_sql=" ALTER TABLE scb_movbco MODIFY COLUMN conmov                     ".
				           "  LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT  NULL;  ";				
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scb_movbco ALTER conmov TYPE text;";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_84-1");
					$lb_valido=false;
				}
			}	   			
	   }
	   $lb_existe="";
	    switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				 $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_scg','desmov','longtext');			
			 break;
				   
			case "POSTGRES":
				  $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_scg','desmov','text');
				   								
			break;  				  
		}	  
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				  $ls_sql="  ALTER TABLE scb_movbco_scg MODIFY COLUMN desmov                    ".
				           "  LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT  NULL;      ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scb_movbco_scg ALTER desmov TYPE text; ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_84-2");
					$lb_valido=false;
				}
			}	   			
	   }
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spg','desmov','longtext');		
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spg','desmov','text');
				   								
			break;  				  
	   }	   
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				   $ls_sql="  ALTER TABLE scb_movbco_spg MODIFY COLUMN desmov                    ".
				           "  LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT  NULL;     ";	 					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scb_movbco_spg ALTER desmov TYPE text; ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_84-3");
					$lb_valido=false;
				}
			}	   			
	   }
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spi','desmov','longtext');		
			 break;
				   
			case "POSTGRES":
				$lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spi','desmov','text');
				   								
			break;  				  
	   }	   
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				   $ls_sql="  ALTER TABLE scb_movbco_spi MODIFY COLUMN desmov                    ".
				            "  LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT  NULL      ";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scb_movbco_spi ALTER desmov TYPE text; ";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_84-4");
					$lb_valido=false;
				}
			}	   			
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_84
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_85()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_85
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 27/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE cxp_rd                                                       ".
				            "   ADD COLUMN coduniadm varchar(10) DEFAULT '----------',                 ".
							"   ADD COLUMN codestpro1 varchar(25) DEFAULT '-------------------------', ".				
							"   ADD COLUMN codestpro2 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro3 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro4 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro5 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN estcla varchar(1) DEFAULT '-';                              ";
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE cxp_rd                                                      ".
				            "   ADD COLUMN coduniadm varchar(10) DEFAULT '----------',                 ".
							"   ADD COLUMN codestpro1 varchar(25) DEFAULT '-------------------------', ".				
							"   ADD COLUMN codestpro2 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro3 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro4 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN codestpro5 varchar(25) DEFAULT '-------------------------', ".
							"   ADD COLUMN estcla varchar(1) DEFAULT '-';                              ";							
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_85");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_85
//--------------------------------------------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_86()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_86
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 30/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_personal ADD fecsitu DATE DEFAULT '1900-01-01'; ";
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE sno_personal ADD fecsitu DATE DEFAULT '1900-01-01'; ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_86");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_86

//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_2_87()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_87
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 02/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
		       case "MYSQLT":
				   $ls_sql=  " ALTER table sno_personal           ". 
							 "	 ADD talcamper varchar(5),        ".
							 "	 ADD talzapper double  default 0, ".
							 "	 ADD talpanper varchar(5);        ";		
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER table sno_personal                     ". 
							 "	 ADD talcamper varchar(5),                  ".
							 "	 ADD talzapper double precision default 0,  ".
							 "	 ADD talpanper varchar(5);                  ";					
					break;  				  
	    }
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_87");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_87
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_88()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_88
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 03/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_empresa           ".
				            "   ADD estciescg smallint default 0;  ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa           ".
				            "   ADD estciescg smallint default 0;  ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_88");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_88
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_89()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_89
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 04/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sigesp_plan_unico_re     ".
				            "   ADD status char(1);                ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sigesp_plan_unico_re     ".
				            "   ADD status char(1);                ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_89");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_89
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_90()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_90
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 08/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $ls_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_dt_scg_int                   ".
							"   ADD  codestpro1 character(25) not null,    ".
							"   ADD  estcla character varying(1) NOT NULL; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sno_dt_scg_int                   ".
							"   ADD  codestpro1 character(25) not null,    ".
							"   ADD  estcla character varying(1) NOT NULL; ";								
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_90-1");
				$lb_valido=false;
			}
		}
	  //-------------------------------------------------------------------------------------------------------------------------------------  
	   $ls_existe = $this->io_function_db->uf_select_constraint('sno_dt_scg_int','pk_sno_dt_scg_int');
	   if (($lb_valido)&&( $ls_existe))
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "ALTER TABLE sno_dt_scg_int DROP PRIMARY KEY; ";								
					   break;
					   
				case "POSTGRES":
						$ls_sql= " ALTER TABLE sno_dt_scg_int DROP CONSTRAINT pk_sno_dt_scg_int; ";							
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_90-2");
					$lb_valido=false;
				}
			}
		}
//-------------------------------------------------------------------------------------------------------------------------------------		
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				  $ls_sql= "ALTER TABLE sno_dt_scg_int                       ".
				           "  ADD CONSTRAINT pk_sno_dt_scg_int2 PRIMARY KEY  ".
						   "  (codemp, codnom, codperi, tipnom, sc_cuenta, debhab, codcom, codconc, codestpro1, estcla, monto)";								
					   break;
					   
				case "POSTGRES":				
				 $ls_sql= "ALTER TABLE sno_dt_scg_int                        ".
				           "  ADD CONSTRAINT pk_sno_dt_scg_int2 PRIMARY KEY  ".
						   "  (codemp, codnom, codperi, tipnom, sc_cuenta, debhab, codcom, codconc, codestpro1, estcla, monto)";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_90-3");
					$lb_valido=false;
				}
			}
		}
	//------------------------------------------------------------------------------------------------------------------------------------	
	   /*if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				  $ls_sql= " DROP VIEW  contableaportes_contable_proyecto_dt;".
				           " DROP VIEW  contableaportes_contable_proyecto_dt_intcom;".
						   " DROP VIEW contabilizar_conceptos_scg_ajuste;".
						   " drop VIEW contabilizar_conceptos_scg_ajuste_int;".
						   " DROP VIEW contableconceptos_contable_historico_int;".
						   " drop VIEW contableconceptos_contable_intercom;".
						   " drop VIEW contableconceptos_contable_proyecto_dt_historico;".
						   " drop VIEW contableconceptos_contable_proyecto_dt_historico_int;".
						   " drop VIEW contableconceptos_contable_proyecto_historico; ".
						   " drop VIEW contableconceptos_contable_proyecto_historico_int;";								
					   break;
					   
				case "POSTGRES":
				  $ls_sql= " DROP VIEW  contableaportes_contable_proyecto_dt;".
				           " DROP VIEW  contableaportes_contable_proyecto_dt_intcom;".
						   " DROP VIEW contabilizar_conceptos_scg_ajuste;".
						   " drop VIEW contabilizar_conceptos_scg_ajuste_int;".
						   " DROP VIEW contableconceptos_contable_historico_int;".
						   " drop VIEW contableconceptos_contable_intercom;".
						   " drop VIEW contableconceptos_contable_proyecto_dt_historico;".
						   " drop VIEW contableconceptos_contable_proyecto_dt_historico_int;".
						   " drop VIEW contableconceptos_contable_proyecto_historico; ".
						   " drop VIEW contableconceptos_contable_proyecto_historico_int;";						
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_90-4");
					$lb_valido=false;
				}
			}
		}*/
	/*	//-----------------------------------------------------------------------------------------------------------------------------------		
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_conceptos_scg_ajuste');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_07();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-7");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contabilizar_conceptos_scg_ajuste_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_08();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-8");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_dt');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_14();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-14");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableaportes_contable_proyecto_dt_intcom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_15();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-15");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_21();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-21");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_historico_intcontableconceptos_contable_intercom');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_22();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-22");
			}	   			
	   }	   
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_25();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-25");
			}	   			
	   }
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_dt_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_26();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-26");
			}	   			
	   }	   
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_historico');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_28();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-28");
			}	   			
	   }
	   
	   $lb_existe =$this->io_function_db->uf_select_vista('contableconceptos_contable_proyecto_historico_int');
	   if (!$lb_existe)
	   {	   		
			$lb_valido=	$this->io_vistas_db->uf_crear_vista_29();
			if (!$lb_valido)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_70-29");
			}	   			
	   }*/
	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_90
//---------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_91()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_91
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE siv_articulo          ".
				            "   ADD estact char(1) DEFAULT '0'; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql= " ALTER TABLE siv_articulo          ".
				            "   ADD estact char(1) DEFAULT '0'; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_91");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_91
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_92()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_92
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 09/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_personal ".
                            "   ADD anoservprecont integer NOT NULL DEFAULT 0; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sno_personal ".
                             "   ADD anoservprecont integer NOT NULL DEFAULT 0; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_92");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_92
 //-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_93()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_93
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 09/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_personalpension           ".
							"     ADD tipjub char(1),                    ".
							"     ADD fecvid date default '1900-01-01',  ".
							"     ADD prirem double  NOT NULL default 0, ".
							"     ADD segrem double  NOT NULL default 0; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= "  ALTER TABLE SNO_PERSONALPENSION                   ".
							 "	  ADD tipjub char(1),                             ".
							 "	  ADD fecvid date default '1900-01-01',           ".
							 "	  ADD prirem double precision NOT NULL default 0, ".
							 "	  ADD segrem double precision NOT NULL default 0; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_93");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_93
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_94()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_94
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 10/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_thpersonalpension         ".
							"     ADD tipjub char(1),                    ".
							"     ADD fecvid date default '1900-01-01',  ".
							"     ADD prirem double  NOT NULL default 0, ".
							"     ADD segrem double  NOT NULL default 0; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= "  ALTER TABLE sno_thpersonalpension                 ".
							 "	  ADD tipjub char(1),                             ".
							 "	  ADD fecvid date default '1900-01-01',           ".
							 "	  ADD prirem double precision NOT NULL default 0, ".
							 "	  ADD segrem double precision NOT NULL default 0; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_94");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_94 //-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_95()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_95
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 10/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_hpersonalpension         ".
							"     ADD tipjub char(1),                    ".
							"     ADD fecvid date default '1900-01-01',  ".
							"     ADD prirem double  NOT NULL default 0, ".
							"     ADD segrem double  NOT NULL default 0; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= "  ALTER TABLE sno_hpersonalpension                 ".
							 "	  ADD tipjub char(1),                             ".
							 "	  ADD fecvid date default '1900-01-01',           ".
							 "	  ADD prirem double precision NOT NULL default 0, ".
							 "	  ADD segrem double precision NOT NULL default 0; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_95");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_95 
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_96()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_96
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 10/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " ALTER TABLE sno_personal ".
                            "   ADD anoservprefijo integer NOT NULL DEFAULT 0; ";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql= " ALTER TABLE sno_personal ".
                             "   ADD anoservprefijo integer NOT NULL DEFAULT 0; ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_96");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_96
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_97()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_97
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 10/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE siv_tipoarticulo ADD tipart char(1);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" ALTER TABLE siv_tipoarticulo ADD tipart char(1); ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_97");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_97
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_2_98()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_98
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 10/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE cxp_rd ADD COLUMN estact char(1) DEFAULT '0';";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" ALTER TABLE cxp_rd ADD COLUMN estact char(1) DEFAULT '0';";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_2_98");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_98
//-------------------------------------------------------------------------------------------------------------------------------------

	 function uf_create_release_db_libre_V_2008_2_99()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_2_99
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 16/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   $lb_existe="";
	   switch($_SESSION["ls_gestor"])
	  	{
			case "MYSQLT":
				  $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spgop','desmov','longtext');				
			 break;
				   
			case "POSTGRES":
				 $lb_existe =$this->io_function_db->uf_select_type_columna('scb_movbco_spgop','desmov','text');
				   								
			break;  				  
		}	   
	   if (!$lb_existe)
	   {
	   		switch($_SESSION["ls_gestor"])
	  		{
				case "MYSQLT":
				    $ls_sql=" ALTER TABLE scb_movbco_spgop MODIFY COLUMN desmov               ".
				           "  LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT  NULL;  ";				
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scb_movbco_spgop ALTER desmov TYPE text;";
				   								
					break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_2_99");
					$lb_valido=false;
				}
			}	   			
	   }	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_2_99
///-------------------------------------------------------------------------------------------------------------------------------------
   
  //-----------------------------------------------------------------------------------------------------------------------------------
  	function uf_create_release_db_libre_V_2008_3_00()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_00
		//		   Access: public 
		//        Modulos: SOB
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="  ALTER TABLE rpc_proveedor ADD COLUMN sc_ctaant varchar(25);";				
			  break;
				   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE rpc_proveedor ADD COLUMN sc_ctaant character varying(25);  ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_00-01");
					$lb_valido=false;
				}
	  }	
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="	ALTER TABLE sob_anticipo ADD COLUMN estgenrd varchar(1) DEFAULT '0'; ";				
			  break;
				   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sob_anticipo ADD COLUMN estgenrd character varying(1) DEFAULT '0';  ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_00-02");
					$lb_valido=false;
				}
	  }	
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="	ALTER TABLE sob_valuacion ADD COLUMN estgenrd varchar(1) DEFAULT '0';";				
			  break;
				   
			case "POSTGRES":
			   $ls_sql= " ALTER TABLE sob_valuacion ADD COLUMN estgenrd character varying(1) DEFAULT '0'; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_00-03");
					$lb_valido=false;
				}
	  }	            
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_00  
 //-----------------------------------------------------------------------------------------------------------------------------------
 //-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_01()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_01
		//		   Access: public 
		//        Modulos: SOB
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="  CREATE TABLE sob_documento (  ".
						 "	 codemp CHAR(4) NOT NULL,     ".
						 "	 coddoc CHAR(3) NOT NULL,     ".
						 "	 tipdoc VARCHAR(15) NOT NULL, ".
						 "	 desdoc VARCHAR(254),         ".
						 "	 condoc TEXT,                 ".
						 "	 tamletdoc INTEGER UNSIGNED,  ".
						 "	 intlindoc INTEGER UNSIGNED,  ".
						 "	 marinfdoc DOUBLE(8,2),       ".
						 "	 marsupdoc DOUBLE(8,2),       ".
						 "	 titdoc TEXT,                 ".
						 "	 piepagdoc TEXT,              ".
						 "	 arcrtfdoc VARCHAR(50),       ".
						 "	 PRIMARY KEY (codemp, coddoc)) ENGINE = InnoDB;";				
			  break;
				   
			case "POSTGRES":
			   $ls_sql= " CREATE TABLE sob_documento(        ".
						"	  codemp character(4) NOT NULL,  ".
						"	  coddoc character(3) NOT NULL,  ".
						"	  tipdoc character(15),          ".
						"	  desdoc character varying(254), ".
						"	  condoc text,                   ".
						"	  tamletdoc integer,             ".
						"	  intlindoc integer,             ".
						"	  marinfdoc double precision DEFAULT 3, ".
						"	  marsupdoc double precision DEFAULT 4, ".
						"	  titdoc text,                          ".
						"	  piepagdoc text,                       ".
						"	  tamletpiedoc integer,                 ".
						"	  arcrtfdoc character varying(50),      ".
						"	  CONSTRAINT pk_sob_documento PRIMARY KEY (codemp, coddoc), ".
						"	  CONSTRAINT sob_documento__sigesp_empresa                  ".
						"     FOREIGN KEY (codemp) REFERENCES sigesp_empresa (codemp)   ".
						"     ON UPDATE NO ACTION ON DELETE NO ACTION) WITHOUT OIDS;    ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas Release 2008_3_01");
				$lb_valido=false;
			}
	  }	    
	  if (($lb_valido)&&($_SESSION["ls_gestor"]=="MYSQLT"))
	  {
	  		$ls_sql= "ALTER TABLE sob_documento                           ".
			         "  ADD CONSTRAINT FK_sob_documento__sigesp_empresa ".
					 "  FOREIGN KEY FK_sob_documento__sigesp_empresa (codemp)".
					 "  REFERENCES sigesp_empresa (codemp) ".
					 "  ON DELETE RESTRICT                     ".
					 "  ON UPDATE RESTRICT                     ";
				
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas uf_cambiar_tipo_data Release 2008_3_01-1");
				$lb_valido=false;
			}		 	    
	  }
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_00   //-------------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_3_02()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_02
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD estvalspg smallint default 0; ";	
			  break;
				   
			case "POSTGRES":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD estvalspg smallint default 0; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_02-01");
					$lb_valido=false;
				}
	  }	    
	  switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD ctaspgrec varchar(254);       ";	
			  break;
				   
			case "POSTGRES":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD ctaspgrec varchar(254);       ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_02-02");
					$lb_valido=false;
				}
	  }	    
	  switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD ctaspgced varchar(254);       ";	
			  break;
				   
			case "POSTGRES":
			     $ls_sql="    ALTER TABLE sigesp_empresa ADD ctaspgced varchar(254);       ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas  Release 2008_3_02-03");
					$lb_valido=false;
				}
	  }	    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_02 
//------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_03()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_03
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE saf_conservacionbien ALTER codconbie TYPE character(2);  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE saf_conservacionbien                       ".
				         "   MODIFY COLUMN codconbie CHAR(2)                        ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci NOT    NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_03");
					$lb_valido=false;
				}
	  }	    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_03 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_04()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_04
		//		   Access: public 
		//        Modulos: CXP
		//	  Description: 
		// Fecha Creacion: 17/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" CREATE TABLE cxp_scg_inter(                                              ".
						 "	 codemp char(4) NOT NULL,												".
						 "	 procede char(6) NOT NULL,												".
						 "	 comprobante char(15) NOT NULL,											".
						 "	 fecha date NOT NULL,                                                   ".
						 "	 codban char(3) NOT NULL DEFAULT '---'::bpchar,                         ".
						 "	 ctaban char(25) NOT NULL DEFAULT '-------------------------'::bpchar,  ".
						 "	 sc_cuenta char(25) NOT NULL,                                           ".
						 "	 procede_doc char(6) NOT NULL,                                          ".
						 "	 documento char(15) NOT NULL,                                           ".
						 "	 debhab char(1) NOT NULL,                                               ".
						 "	 descripcion text NOT NULL,                                             ".
						 "	 monto float8 NOT NULL,                                                 ".
						 "	 orden int4 NOT NULL,                                                   ".
						 "	 CONSTRAINT pk_cxp_scg_inter                                            ".
						 "	 PRIMARY KEY (codemp, procede, sc_cuenta, comprobante, procede_doc,     ".
						 "	              documento, fecha, codban, ctaban, debhab)) WITHOUT OIDS;   ";	
			  break;				   
			case "MYSQLT":
			     $ls_sql=" CREATE TABLE cxp_scg_inter(                                        ".
						 "	 codemp char(4) NOT NULL,                                         ".
						 "	 procede char(6) NOT NULL,                                        ".
						 "	 comprobante char(15) NOT NULL,                                   ".
						 "	 fecha date NOT NULL,                                             ".
						 "	 codban char(3) NOT NULL DEFAULT '---',							  ".
						 "	 ctaban char(25) NOT NULL DEFAULT '-------------------------',    ".
						 "	 sc_cuenta char(25) NOT NULL,                                     ".
						 "	 procede_doc char(6) NOT NULL,                                    ".
						 "	 documento char(15) NOT NULL,                                     ".
						 "	 debhab char(1) NOT NULL,                                         ".
						 "	 descripcion text NOT NULL,                                       ".
						 "   monto float8 NOT NULL,                                           ".						
						 "	 orden int4 NOT NULL,                                             ".
						 "	 CONSTRAINT pk_cxp_scg_inter PRIMARY KEY                          ".
						 "   (codemp, procede, sc_cuenta, comprobante, procede_doc,           ".
						 "   documento, fecha, codban, ctaban, debhab))  ENGINE = InnoDB;     ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_04");
					$lb_valido=false;
				}
	  }	    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_04 
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_05()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_05
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 18/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_existe = $this->io_function_db->uf_select_constraint('scg_cuentas_consolida','fk_scg_cuentas_consolida_scg_cuentas');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
			  $ls_sql= " ALTER TABLE scg_cuentas_consolida DROP FOREIGN KEY fk_scg_cuentas_consolida_scg_cuentas;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scg_cuentas_consolida DROP CONSTRAINT fk_scg_cuentas_consolida_scg_cuentas;";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_05_1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe)	   
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_05 
//------------------------------------------------------------------------------------------------------------------------------------
 //-----------------------------------------------------------------------------------------------------------------------------------
      function uf_create_release_db_libre_V_2008_3_06()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_06
		//		   Access: public 
		//        Modulos: SCG
		//	  Description: 
		// Fecha Creacion: 18/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_existe = $this->io_function_db->uf_select_constraint('scg_saldos_consolida','pk_scg_saldos_consolida');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE scg_saldos_consolida DROP  FOREIGN KEY pk_scg_saldos_consolida;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scg_saldos_consolida DROP CONSTRAINT pk_scg_saldos_consolida;";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_06_1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 	     
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE scg_saldos_consolida ".
                            " ADD CONSTRAINT pk_scg_saldos_consolida2 PRIMARY KEY(codemp, sc_cuenta, fecsal);";					
				   break;
				   
				case "POSTGRES":
				    $ls_sql= " ALTER TABLE scg_saldos_consolida ".
                             " ADD CONSTRAINT pk_scg_saldos_consolida2 PRIMARY KEY(codemp, sc_cuenta, fecsal);";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_06_2");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($lb_valido) 	   
	   
	   $ls_existe = $this->io_function_db->uf_select_constraint('scg_saldos_consolida','fk_scg_saldos_consolida_scg_cuentas');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= " ALTER TABLE scg_saldos_consolida DROP FOREIGN KEY fk_scg_saldos_consolida_scg_cuentas;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scg_saldos_consolida DROP CONSTRAINT fk_scg_saldos_consolida_scg_cuentas;";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_06_1");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe) 	     
	   
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_06 
//--------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_07()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_07
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_anticipos	(                   ".
						   "  codemp     char(4)       not null,            ".
						   "  codnom     char(4)       not null,            ".
						   "  codper     char(10)      not null,            ".
						   "  fecantper  date          not null,            ".
						   "  anoserper  integer       not null,            ".
						   "  messerper  integer       not null,            ".
						   "  diaserper  integer       not null,            ".
						   "  motant     varchar(254)  not null,            ".
						   "  mondeulab  double(19,4)  not null,            ".
						   "  monporant  double(19,4)  not null,            ".
						   "  monant     double(19,4)  not null,            ".
						   "  estant     varchar(1)    not null default '0',".
						   "  obsant     varchar(254))ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_anticipos (                        ".
						   " codemp               CHAR(4)              not null, ".
						   " codnom               CHAR(4)              not null, ".
						   " codper               CHAR(10)             not null, ".
						   " fecantper            DATE                 not null, ".
						   " anoserper            INT4                 not null, ".
						   " messerper            INT4                 not null, ".
						   " diaserper            INT4                 not null, ".
						   " motant               VARCHAR(254)         not null, ".
						   " mondeulab            FLOAT8               not null, ".
						   " monporant            FLOAT8               not null, ".
						   " monant               FLOAT8               not null, ".
						   " estant               VARCHAR(1)           not null default '0' ".
						   " constraint CKC_ESTANT_SPS_ANTI check (estant in ('0','1','2','3')), ".
						   "obsant               VARCHAR(254)         null); ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_07-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_anticipos ".
   							"   add primary key (codemp, codper, codnom, fecantper); ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_anticipos ".
                           "   add constraint PK_SPS_ANTICIPOS primary key (codemp, codper, codnom, fecantper);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_07-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	
	   //----------------creacion de un index--------------------------------------------------------------------------------
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			
			case "MYSQLT":
				   $ls_sql= " create unique index idx_anticipos on sps_anticipos ( ".
							"   codemp, codnom,                                    ".							
							"   codper,                                            ".
							"   fecantper);                                        ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create unique index idx_anticipos on sps_anticipos ( ".
						   " codemp,                                              ".
						   " codnom,                                              ".
						   " codper,                                              ".
						   " fecantper);                                          ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_07-03");
				$lb_valido=false;
			}
		}		
	   //-------------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_07
	//-------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_3_08()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_08
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_antiguedad(
							   codemp                         char(4)                        not null,
							   codnom                         char(4)                        not null,
							   codper                         char(10)                       not null,
							   fecant                         date                           not null,
							   anoserant                      integer                        not null,
							   messerant                      integer                        not null,
							   diaserant                      integer                        not null,
							   salbas                         double(19,4)                   not null default 0,
							   incbonvac                      double(19,4)                   not null,
							   incbonnav                      double(19,4)                   not null,
							   salint                         double(19,4)                   not null default 0,
							   salintdia                      double(19,4)                   not null,
							   diabas                         integer                        not null,
							   diacom                         integer                        not null,
							   diaacu                         integer                        not null,
							   monant                         double(19,4)                   not null default 0,
							   monacuant                      double(19,4)                   not null default 0,
							   monantant                      double(19,4)                   not null default 0,
							   salparant                      double(19,4)                   not null default 0,
							   porint                         double(5,2)                    not null,
							   diaint                         integer                        not null,
							   monint                         double(19,4)                   not null default 0,
							   monacuint                      double(19,4)                   not null default 0,
							   saltotant                      double(19,4)                   not null,
							   estcapint                      char(1)                        not null,
							   estant                         char(1)                        not null,
							   liquidacion                    char(10)
							)ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_antiguedad (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codper               CHAR(10)             not null,
							   fecant               DATE                 not null,
							   anoserant            INT4                 not null,
							   messerant            INT4                 not null,
							   diaserant            INT4                 not null,
							   salbas               FLOAT8               not null default '0',
							   incbonvac            FLOAT8               not null,
							   incbonnav            FLOAT8               not null,
							   salint               FLOAT8               not null default '0',
							   salintdia            FLOAT8               not null,
							   diabas               INT4                 not null,
							   diacom               INT4                 not null,
							   diaacu               INT4                 not null,
							   monant               FLOAT8               not null default '0',
							   monacuant            FLOAT8               not null default '0',
							   monantant            FLOAT8               not null default '0',
							   salparant            FLOAT8               not null default '0',
							   porint               FLOAT8               not null,
							   diaint               INT4                 not null,
							   monint               FLOAT8               not null default '0',
							   monacuint            FLOAT8               not null default '0',
							   saltotant            FLOAT8               not null,
							   estcapint            CHAR(1)              not null,
							   estant               CHAR(1)              not null 
							   constraint CKC_ESTANT_SPS_ANTI check (estant in ('R','P','L')),
							   liquidacion          CHAR(10)             null
							);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_08-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_antiguedad
   								add primary key (codemp, codper, codnom, fecant);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_antiguedad
   							   add constraint PK_SPS_ANTIGUEDAD primary key (codemp, codper, codnom, fecant);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_08-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	
	   //----------------creacion de un index--------------------------------------------------------------------------------
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			
			case "MYSQLT":
				   $ls_sql= " create unique index idx_antiguedad on sps_antiguedad	(
							  codemp,
							  codnom,
							  codper,
							  fecant); ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create unique index idx_antiguedad on sps_antiguedad (
							 codemp,
							 codnom,
							 codper,
							 fecant);   ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_08-03");
				$lb_valido=false;
			}
		}		
	   //-------------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_08
//----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_09()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_09
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_articulos(
							   id_art                         char(4)                        not null,
							   numart                         char(4)                        not null,
							   fecvig                         date                           not null,
							   numlitart                      char(2)                        not null,
							   numcon                         char(1)                        not null,
							   conart                         varchar(60)                    not null,
							   operador                       char(1)                        not null,
							   canmes                         integer                        not null,
							   tiempo                         char(1)                        not null,
							   diasal                         double                         not null,
							   condicion                      char(4)                        not null,
							   estacu                         char(1)                        not null,
							   diaacu                         double                         not null
							)ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_articulos (
							   id_art               CHAR(4)              not null,
							   numart               CHAR(4)              not null,
							   fecvig               DATE                 not null,
							   numlitart            CHAR(2)              not null,
							   numcon               CHAR(1)              not null,
							   conart               VARCHAR(60)          not null,
							   operador             CHAR(1)              not null,
							   canmes               INT4                 not null,
							   tiempo               CHAR(1)              not null,
							   diasal               FLOAT8               not null,
							   condicion            CHAR(4)              not null,
							   estacu               CHAR(1)              not null,
							   diaacu               FLOAT8               not null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_09-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_articulos
   								add primary key (id_art, numart, fecvig, numlitart, numcon);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_articulos
   							   add constraint PK_SPS_ARTICULOS primary key (id_art, numart, fecvig, numlitart, numcon);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_09-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_09
//---------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_10()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_10
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_carta_anticipos(
							   codemp                         char(4)          not null,
							   codcarant                      char(3)          not null,
							   descarant                      varchar(254),
							   concarant                      text,
							   tamletcarant                   int,
							   intlincarant                   int,
							   marinfcarant                   double(5,2),
							   marsupcarant                   double(5,2),
							   titcarant                      text,
							   piepagcarant                   text,
							   tamletpiepag                   int,
							   arcrtfcarant                   varchar(50)
							)ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_carta_anticipos (
							   codemp               CHAR(4)              not null,
							   codcarant            CHAR(3)              not null,
							   descarant            VARCHAR(254)         null,
							   concarant            TEXT                 null,
							   tamletcarant         INT4                 null,
							   intlincarant         INT4                 null,
							   marinfcarant         FLOAT8               null,
							   marsupcarant         FLOAT8               null,
							   titcarant            TEXT                 null,
							   piepagcarant         TEXT                 null,
							   tamletpiepag         INT4                 null,
							   arcrtfcarant         VARCHAR(50)          null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_10-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_carta_anticipos
   								add primary key (codemp, codcarant);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_carta_anticipos
                               add constraint PK_SPS_CARTA_ANTICIPOS primary key (codemp, codcarant);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_10-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_10
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_11()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_11
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_causaretiro(
							   codcauret                      char(2)      not null,
							   dencauret                      varchar(50)  not null
							)ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_causaretiro (
							   codcauret            CHAR(2)     not null,
							   dencauret            VARCHAR(50) not null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_11-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_causaretiro
   								add primary key (codcauret);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_causaretiro
   							   add constraint PK_SPS_CAUSARETIRO primary key (codcauret);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_11-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_11
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_12()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_12
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_configuracion(
							   id                             char(1)     not null,
							   porant                         double(5,2) not null,
							   estsue                         char(1)     not null,
							   estincbon                      char(1)     not null,
							   sc_cuenta_ps                   char(25)    default ' ',
							   sig_cuenta_emp_fijo_ps         char(25)    default ' ',
							   sig_cuenta_emp_fijo_vac        char(25)    default ' ',
							   sig_cuenta_emp_fijo_agu        char(25)    default ' ',
							   sig_cuenta_obr_fijo_ps         char(25)    default ' ',
							   sig_cuenta_obr_fijo_vac        char(25)    default ' ',
							   sig_cuenta_obr_fijo_agu        char(25)    default ' ',
							   sig_cuenta_emp_cont_ps         char(25)    default ' ',
							   sig_cuenta_emp_cont_vac        char(25)    default ' ',
							   sig_cuenta_emp_cont_agu        char(25)    default ' ',
							   sig_cuenta_emp_esp_ps          char(25)    default ' ',
							   sig_cuenta_emp_esp_vac         char(25)    default ' ',
							   sig_cuenta_emp_esp_agu         char(25)    default ' '
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_configuracion (
							   id                   CHAR(1)              not null,
							   porant               FLOAT8               not null,
							   estsue               CHAR(1)              not null,
							   estincbon            CHAR(1)              not null,
							   sc_cuenta_ps         CHAR(25)             null default ' ',
							   sig_cuenta_emp_fijo_ps CHAR(25)           null default ' ',
							   sig_cuenta_emp_fijo_vac CHAR(25)          null default ' ',
							   sig_cuenta_emp_fijo_agu CHAR(25)          null default ' ',
							   sig_cuenta_obr_fijo_ps CHAR(25)           null default ' ',
							   sig_cuenta_obr_fijo_vac CHAR(25)          null default ' ',
							   sig_cuenta_obr_fijo_agu CHAR(25)          null default ' ',
							   sig_cuenta_emp_cont_ps CHAR(25)           null default ' ',
							   sig_cuenta_emp_cont_vac CHAR(25)          null default ' ',
							   sig_cuenta_emp_cont_agu CHAR(25)          null default ' ',
							   sig_cuenta_emp_esp_ps CHAR(25)            null default ' ',
							   sig_cuenta_emp_esp_vac CHAR(25)           null default ' ',
							   sig_cuenta_emp_esp_agu CHAR(25)           null default ' ');";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_12-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_configuracion
							   add primary key (id);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_configuracion
   							   add constraint PK_SPS_CONFIGURACION primary key (id);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_12-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_12
//------------------------------------------------------------------------------------------------------------------------------------- 
    function uf_create_release_db_libre_V_2008_3_13()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_13
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_deuda_anterior(
							   codemp                         char(4)           not null,
							   codnom                         char(4)           not null,
							   codper                         char(10)          not null,
							   feccordeuant                   date              not null,
							   deuantant                      double(19,4)      not null default 0,
							   deuantint                      double(19,4)      not null default 0,
							   antpag                         double(19,4)      not null default 0,
							   estdeuant                      char(1)           not null
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_deuda_anterior (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codper               CHAR(10)             not null,
							   feccordeuant         DATE                 not null,
							   deuantant            FLOAT8               not null default '0',
							   deuantint            FLOAT8               not null default '0',
							   antpag               FLOAT8               not null default '0',
							   estdeuant            CHAR(1)              not null 
								  constraint CKC_ESTDEUANT_SPS_DEUD check (estdeuant in ('E','P')));";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_13-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_deuda_anterior
   								add primary key (codemp, codper, codnom, feccordeuant);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_deuda_anterior
   							   add constraint PK_SPS_DEUDA_ANTERIOR primary key (codemp, codper, codnom, feccordeuant);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_13-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   //----------------creacion de un index--------------------------------------------------------------------------------
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			
			case "MYSQLT":
				   $ls_sql= " create unique index idx_deuda_anterior on sps_deuda_anterior(
							   codemp,
							   codnom,
							   codper,
							   feccordeuant); ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create unique index idx_deuda_anterior on sps_deuda_anterior (
								codemp,
								codnom,
								codper,
								feccordeuant);  ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_13-03");
				$lb_valido=false;
			}
		}		
	   //-------------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_13
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_14()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_14
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_dt_liquidacion(
							   codemp                         char(4)        not null,
							   codper                         char(10)       not null,
							   codnom                         char(4)        not null,
							   numliq                         char(10)       not null,
							   numespliq                      char(2)        not null,
							   desespliq                      char(150)      not null,
							   salpro                         double(19,4)   not null,
							   diapag                         double(8,4)    not null,
							   subtotal                       double(19,4)   not null,
							   sc_cuenta_ded                  char(25)
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_dt_liquidacion (
							   codemp               CHAR(4)              not null,
							   codper               CHAR(10)             not null,
							   codnom               CHAR(4)              not null,
							   numliq               CHAR(10)             not null,
							   numespliq            CHAR(2)              not null,
							   desespliq            CHAR(150)            not null,
							   salpro               FLOAT8               not null,
							   diapag               FLOAT8               not null,
							   subtotal             FLOAT8               not null,
							   sc_cuenta_ded        CHAR(25)             null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_14-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_dt_liquidacion
   								add primary key (codemp, codper, codnom, numliq, numespliq);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_dt_liquidacion
  							   add constraint PK_SPS_DT_LIQUIDACION primary key (codemp, codper, codnom, numliq, numespliq);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_14-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_14
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_15()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_15
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_dt_scg(
							   codemp                         char(4)                        not null,
							   codnom                         char(4)                        not null,
							   codcom                         char(15)                       not null,
							   tipo                           char(1)                        not null,
							   sc_cuenta                      char(25)                       not null,
							   debhab                         char(1)                        not null,
							   ced_bene                       varchar(10)                    not null,
							   descripcion                    varchar(254)                   not null,
							   monto                          double(19,4)                   not null,
							   estatus                        smallint                       not null,
							   estrd                          smallint                       not null,
							   codtipdoc                      varchar(5)                     not null,
							   fechaconta                     date,
							   fechaanula                     date
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_dt_scg (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codcom               CHAR(15)             not null,
							   tipo                 CHAR(1)              not null,
							   sc_cuenta            CHAR(25)             not null,
							   debhab               CHAR(1)              not null,
							   ced_bene             VARCHAR(10)          not null,
							   descripcion          VARCHAR(254)         not null,
							   monto                FLOAT8               not null,
							   estatus              INT2                 not null,
							   estrd                INT2                 not null,
							   codtipdoc            VARCHAR(5)           not null,
							   fechaconta           DATE                 null,
							   fechaanula           DATE                 null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_15-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_dt_scg
   								add primary key (codemp, codnom, tipo, sc_cuenta, debhab, codcom);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_dt_scg
   							   add constraint PK_SPS_DT_SCG primary key (codemp, codnom, tipo, sc_cuenta, debhab, codcom);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_15-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_15
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_16()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_16
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_dt_spg(
							   codemp                         char(4)       not null,
							   codnom                         char(4)       not null,
							   codcom                         char(15)      not null,
							   tipo                           char(1)       not null,
							   codestpro1                     char(20)      not null,
							   codestpro2                     char(6)       not null,
							   codestpro3                     char(3)       not null,
							   codestpro4                     char(2)       not null,
							   codestpro5                     char(2)       not null,
							   spg_cuenta                     char(25)      not null,
							   operacion                      char(3)       not null,
							   ced_bene                       varchar(10)   not null,
							   descripcion                    varchar(254)  not null,
							   monto                          double(19,4)  not null,
							   estatus                        smallint      not null,
							   estrd                          smallint      not null,
							   codtipdoc                      varchar(5)    not null,
							   fechaconta                     date,
							   fechaanula                     date
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_dt_spg (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codcom               CHAR(15)             not null,
							   tipo                 CHAR(1)              not null,
							   codestpro1           CHAR(20)             not null,
							   codestpro2           CHAR(6)              not null,
							   codestpro3           CHAR(3)              not null,
							   codestpro4           CHAR(2)              not null,
							   codestpro5           CHAR(2)              not null,
							   spg_cuenta           CHAR(25)             not null,
							   operacion            CHAR(3)              not null,
							   ced_bene             VARCHAR(10)          not null,
							   descripcion          VARCHAR(254)         not null,
							   monto                FLOAT8               not null,
							   estatus              INT2                 not null,
							   estrd                INT2                 not null,
							   codtipdoc            VARCHAR(5)           not null,
							   fechaconta           DATE                 null,
							   fechaanula           DATE                 null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_16-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_dt_spg
   							    add primary key (codemp, codnom, codcom, tipo, codestpro1, codestpro2, codestpro3, 
								                 codestpro4, codestpro5, spg_cuenta, operacion);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_dt_spg
                               add constraint PK_SPS_DT_SPG primary key (codemp, codnom, codcom, tipo, codestpro1, 
							                                             codestpro2, codestpro3, codestpro4, 
																		 codestpro5, spg_cuenta, operacion);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_16-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_16
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_17()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_17
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_liquidacion(
							   codemp                         char(4)        not null,
							   codnom                         char(4)        not null,
							   codper                         char(10)       not null,
							   numliq                         char(10)       not null,
							   codcauret                      char(2)        not null,
							   fecliq                         date           not null,
							   fecing                         date           not null,
							   fecegr                         date           not null,
							   salint                         double(19,4)   not null,
							   descargo                       char(40)       not null,
							   anoser                         integer        not null,
							   messer                         integer        not null,
							   diaser                         integer        not null,
							   totasiliq                      double(19,4)   not null,
							   totdedliq                      double(19,4)   not null,
							   totpagliq                      double(19,4)   not null,
							   estliq                         char(1)        not null,
							   obsliq                         varchar(200),
							   dedicacion                     varchar(100)   not null,
							   tipopersonal                   varchar(100)   not null
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_liquidacion (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codper               CHAR(10)             not null,
							   numliq               CHAR(10)             not null,
							   codcauret            CHAR(2)              not null,
							   fecliq               DATE                 not null,
							   fecing               DATE                 not null,
							   fecegr               DATE                 not null,
							   salint               FLOAT8               not null,
							   descargo             CHAR(40)             not null,
							   anoser               INT4                 not null,
							   messer               INT4                 not null,
							   diaser               INT4                 not null,
							   totasiliq            FLOAT8               not null,
							   totdedliq            FLOAT8               not null,
							   totpagliq            FLOAT8               not null,
							   estliq               CHAR(1)              not null 
								  constraint CKC_ESTLIQ_SPS_LIQU check (estliq in ('R','A','P')),
							   obsliq               VARCHAR(200)         null,
							   dedicacion           VARCHAR(100)         not null,
							   tipopersonal         VARCHAR(100)         not null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_17-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_liquidacion
							   add primary key (codemp, codper, codnom, numliq);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_liquidacion
                               add constraint PK_SPS_LIQUIDACION primary key (codemp, codper, codnom, numliq);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_17-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   //----------------creacion de un index--------------------------------------------------------------------------------
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			
			case "MYSQLT":
				   $ls_sql= " create unique index idx_liquidacion on sps_liquidacion(
							   codemp,
							   codnom,
							   codper,
							   numliq);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create unique index idx_liquidacion on sps_liquidacion (
								codemp,
								codnom,
								codper,
								numliq); ";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_17-03");
				$lb_valido=false;
			}
		}		
	   //-------------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_17
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_18()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_18
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_sueldos(
							   codemp                         char(4)       not null,
							   codnom                         char(4)       not null,
							   codper                         char(10)      not null,
							   fecincsue                      date          not null,
							   monsuebas                      double(19,4)  not null,
							   monsueint                      double(19,4)  not null,
							   monsuenordia                   double(19,4)  not null
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_sueldos (
							   codemp               CHAR(4)              not null,
							   codnom               CHAR(4)              not null,
							   codper               CHAR(10)             not null,
							   fecincsue            DATE                 not null,
							   monsuebas            FLOAT8               not null,
							   monsueint            FLOAT8               not null,
							   monsuenordia         FLOAT8               not null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_18-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_sueldos
   								add primary key (codemp, codper, codnom, fecincsue);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_sueldos
                               add constraint PK_SPS_SUELDOS primary key (codemp, codper, codnom, fecincsue);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_18-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   //----------------creacion de un index--------------------------------------------------------------------------------
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			
			case "MYSQLT":
				   $ls_sql= " create unique index idx_sueldos on sps_sueldos(
							   codemp,
							   codnom,
							   codper,
							   fecincsue);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create unique index idx_sueldos on sps_sueldos (
								codemp,
								codnom,
								codper,
								fecincsue);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_18-03");
				$lb_valido=false;
			}
		}		
	   //-------------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_18
//-------------------------------------------------------------------------------------------------------------------------------------
     function constrains_foraneos()
	 {
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				  $ls_sql="alter table sps_tasa_interes
   							   add primary key (anotasint, mestasint);
							alter table sps_anticipos add constraint FK_reference_437 foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper) on delete restrict on update restrict;							
							alter table sps_antiguedad add constraint FK_reference_435 foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper) on delete restrict on update restrict;							
							alter table sps_carta_anticipos add constraint FK_reference_150 foreign key (codemp)
								  references sigesp_empresa (codemp) on delete restrict on update restrict;							
							alter table sps_deuda_anterior add constraint FK_reference_439 foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper) on delete restrict on update restrict;							
							alter table sps_dt_liquidacion add constraint FK_reference_8 foreign key (codemp, codper, 
							      codnom, numliq) references sps_liquidacion (codemp, codper, codnom, numliq) 
								  on delete restrict on update restrict;							
							alter table sps_dt_scg add constraint FK_reference_151 foreign key (codemp)
								  references sigesp_empresa (codemp) on delete restrict on update restrict;							
							alter table sps_dt_spg add constraint FK_reference_152 foreign key (codemp)
								  references sigesp_empresa (codemp) on delete restrict on update restrict;							
							alter table sps_liquidacion add constraint FK_reference_436 foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper) on delete restrict on update restrict;							
							alter table sps_liquidacion add constraint FK_reference_7 foreign key (codcauret)
								  references sps_causaretiro (codcauret) on delete restrict on update restrict;							
							alter table sps_sueldos add constraint FK_reference_438 foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper) on delete restrict on update restrict;";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql=" alter table sps_anticipos
							  add constraint FK_SPS_ANTI_REFERENCE_SNO_PERS foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper)
								  on delete restrict on update restrict;							
							alter table sps_antiguedad
							   add constraint FK_SPS_ANTI_REFERENCE_SNO_PERS foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper)
								  on delete restrict on update restrict;							
							alter table sps_carta_anticipos
							   add constraint FK_SPS_CART_REFERENCE_SIGESP_E foreign key (codemp)
								  references sigesp_empresa (codemp)
								  on delete restrict on update restrict;							
							alter table sps_deuda_anterior
							   add constraint FK_SPS_DEUD_REFERENCE_SNO_PERS foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper)
								  on delete restrict on update restrict;							
							alter table sps_dt_liquidacion
							   add constraint FK_SPS_DT_L_REFERENCE_SPS_LIQU foreign key (codemp, codper, codnom, numliq)
								  references sps_liquidacion (codemp, codper, codnom, numliq)
								  on delete restrict on update restrict;							
							alter table sps_dt_scg
							   add constraint FK_SPS_DT_S_REFERENCE_SIGESP_E foreign key (codemp)
								  references sigesp_empresa (codemp)
								  on delete restrict on update restrict;							
							alter table sps_dt_spg
							   add constraint FK_SPS_DT_S_REFERENCE_SIGESP_E foreign key (codemp)
								  references sigesp_empresa (codemp)
								  on delete restrict on update restrict;							
							alter table sps_liquidacion
							   add constraint FK_SPS_LIQU_REFERENCE_SNO_PERS foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper)
								  on delete restrict on update restrict;							
							alter table sps_liquidacion
							   add constraint FK_SPS_LIQU_REFERENCE_SPS_CAUS foreign key (codcauret)
								  references sps_causaretiro (codcauret)
								  on delete restrict on update restrict;							
							alter table sps_sueldos
							   add constraint FK_SPS_SUEL_REFERENCE_SNO_PERS foreign key (codemp, codnom, codper)
								  references sno_personalnomina (codemp, codnom, codper)
								  on delete restrict on update restrict;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release constrains_foraneos");
				$lb_valido=false;
			}
		}	
	 return $lb_valido;	
	} // end function cosntrains_foraneos
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_19()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_19
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 21/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table sps_tasa_interes(
							   anotasint                      integer     not null,
							   mestasint                      integer     not null,
							   valtas                         double      not null,
							   numgac                         char(6)     not null
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" create table sps_tasa_interes (
							   anotasint            INT4                 not null,
							   mestasint            INT4                 not null,
							   valtas               FLOAT8               not null,
							   numgac               CHAR(6)              not null);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_19-01");
				$lb_valido=false;
			}
		}	
	   
	   //-----------creacion de la clave primaria---------------------------------------------------------------------------
       $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql= " alter table sps_tasa_interes
                                add primary key (anotasint, mestasint);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" alter table sps_tasa_interes
                              add constraint PK_SPS_TASA_INTERES primary key (anotasint, mestasint);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_19-02");
				$lb_valido=false;
			}
		}		
	   //--------------------------------------------------------------------------------------------------------------------	  
	   if ($lb_valido)
	   {
	   		$this->constrains_foraneos();
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_19   
///-------------------------------------------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_20()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_20
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 24/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" ALTER TABLE scb_cheques ALTER orden TYPE INT4;  ";	
			  break;		 
									  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_20");
					$lb_valido=false;
				}
	  }	    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_20 
//---------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_21()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_21
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 24/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE scb_cheques ADD codusu varchar(30);  ";	
			  break;
			  
			case "MYSQLT":
				  $ls_sql="   ALTER TABLE scb_cheques ADD codusu varchar(30);  ";								
				   break;								  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_21");
					$lb_valido=false;
				}
	  }	    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_21 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_22()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_22
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" DROP TABLE srh_persona_concurso;";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" DROP TABLE srh_persona_concurso;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_2236-01");
				$lb_valido=false;
			}
		} 
		
	   $lb_existe = $this->io_function_db->uf_select_table('srh_asignar_concurso');  
	   if ($lb_existe) 
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql=" DROP TABLE srh_asignar_concurso;";								
					   break;
					   
				case "POSTGRES":
					   $ls_sql=" DROP TABLE srh_asignar_concurso;";										
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_2_22-02");
					$lb_valido=false;
				}
			}    
	   }  	     
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_22 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_23()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_23
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" CREATE TABLE srh_concursante (
							   codemp    char(4)    not null,
							   codcon    varchar(10)   not null, 
							   codper    char(10)   not null,
							   fecreg    date,
							   nomper    varchar(100),
							   apeper    varchar(100),
							   dirper    text,
							   fecnacper date,
							   edocivper char(1),
							   codpai    char(3),
							   codest    char(3),
							   nacper    char(1),
							   telhabper varchar(20),
							   telmovper varchar(20),
							   sexper    char(1),
							   coreleper varchar(100),
							   nivacaper char(1),
							   codpro    char(3),
							   estconper char(1),
							   tipper    char(1),
							   PRIMARY KEY (codemp,codcon,codper))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql="CREATE TABLE srh_concursante (
							   codemp    char(4)    not null,
							   codcon    varchar(10)   not null, 
							   codper    char(10)   not null,
							   fecreg    date,
							   nomper    varchar(100),
							   apeper    varchar(100),
							   dirper    text,
							   fecnacper date,
							   edocivper char(1),
							   codpai    char(3),
							   codest    char(3),
							   nacper    char(1),
							   telhabper varchar(20),
							   telmovper varchar(20),
							   sexper    char(1),
							   coreleper varchar(100),
							   nivacaper char(1),
							   codpro    char(3),
							   estconper char(1),
							   tipper    char(1),
							   PRIMARY KEY (codemp,codcon,codper))  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_23-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE srh_concursante 
					               ADD FOREIGN KEY(codemp,codpro) REFERENCES sno_profesion (codemp,codpro) 
								       ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                   ADD FOREIGN KEY(codemp,codcon) REFERENCES srh_concurso (codemp,codcon)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                   ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp) 
								       ON DELETE RESTRICT ON UPDATE RESTRICT; ";								
			   break;
			   case "POSTGRES":
					  $ls_sql=" ALTER TABLE srh_concursante 
					               ADD FOREIGN KEY(codemp,codpro) REFERENCES sno_profesion (codemp,codpro) 
								       ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                   ADD FOREIGN KEY(codemp,codcon) REFERENCES srh_concurso (codemp,codcon)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                   ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp) 
								       ON DELETE RESTRICT ON UPDATE RESTRICT; ";								
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_23-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_23 
//-------------------------------------------------------------------------------------------------------------------------------------
///------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_24()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_24
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" CREATE TABLE  srh_estudiosconcursante (
							   codemp        char(4)    not null,
							   codper        char(10)   not null,
							   codcon        char(10)   not null,
							   codestper     smallint   not null,
							   nivestper     char(1),
							   insestper     varchar(254),
							   carestper     varchar(254),
							   titestper     char(1),  
							   anofinestper  smallint, 
							   anoaprestper  smallint,
							   PRIMARY KEY (codemp,codper,codcon,codestper))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_estudiosconcursante (
							   codemp        char(4)    not null,
							   codper        char(10)   not null,
							   codcon        char(10)   not null,
							   codestper     smallint   not null,
							   nivestper     char(1),
							   insestper     varchar(254),
							   carestper     varchar(254),
							   titestper     char(1),  
							   anofinestper  smallint, 
							   anoaprestper  smallint,
							   PRIMARY KEY (codemp,codper,codcon,codestper)							     
							)  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_24-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE  srh_estudiosconcursante  
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,  
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT   ";								
			   break;
			   case "POSTGRES":
					  $ls_sql=" ALTER TABLE  srh_estudiosconcursante  
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,  
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT   ";										
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_24-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_24 
//------------------------------------------------------------------------------------------------------------------------------------
///------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_25()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_25
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  CREATE TABLE  srh_cursosconcursante(
							   codemp        char(4)    not null,
							   codper        char(10)   not null,
							   codcon        char(10)   not null,
							   codcurper     smallint   not null,
							   descurper     varchar(254),
							   horcurper     char(1),
							   PRIMARY KEY (codemp,codper,codcon,codcurper)) 
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_cursosconcursante(
							   codemp        char(4)    not null,
							   codper        char(10)   not null,
							   codcon        char(10)   not null,
							   codcurper     smallint   not null,
							   descurper     varchar(254),
							   horcurper     char(1),
							   PRIMARY KEY (codemp,codper,codcon,codcurper)							     
							)  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_25-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE srh_cursosconcursante
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								      ON UPDATE RESTRICT   ";								
			   break;
			   case "POSTGRES":
					 $ls_sql=" ALTER TABLE srh_cursosconcursante
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								      ON UPDATE RESTRICT   ";										
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_25-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_25 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_26()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_26
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" CREATE TABLE  srh_trabajosconcursante(
							   codemp       char(4)    not null,
							   codper       char(10)  not null,
							   codcon       char(10)  not null,
							   codtraper    smallint   not null,
							   emptraper    varchar(100),
							   cartraant    varchar(100),
							   fecingtraper date,
							   fecegrtraper date,   
							   PRIMARY KEY (codemp,codper,codcon,codtraper)							    
							)  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_trabajosconcursante(
							   codemp       char(4)    not null,
							   codper       char(10)  not null,
							   codcon       char(10)  not null,
							   codtraper    smallint   not null,
							   emptraper    varchar(100),
							   cartraant    varchar(100),
							   fecingtraper date,
							   fecegrtraper date,   
							   PRIMARY KEY (codemp,codper,codcon,codtraper)							    
							)  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_26-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE srh_trabajosconcursante
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								      ON UPDATE RESTRICT    ";								
			   break;
			   case "POSTGRES":
					 $ls_sql=" ALTER TABLE srh_trabajosconcursante
					              ADD FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								      ON UPDATE RESTRICT    ";											
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_26-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_26 
//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_27()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_27
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  CREATE TABLE  srh_familiaresconcursante(
							   codemp      char(4)     not null,
							   codper      varchar(10) not null,
							   codcon      char(10)    not null,
							   codfamper   smallint    not null,
							   cedfamper   char(10),   
							   nomfamper   varchar(100),
							   apefamper   varchar(100),
							   sexfamper   char(1),
							   nexfamper   char(1),
							   fecnacfamper   date,   
							   PRIMARY KEY (codemp,codper,codcon,codfamper))  
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_familiaresconcursante(
							   codemp      char(4)     not null,
							   codper      char(10)    not null,
							   codcon      varchar(10) not null,
							   codfamper   smallint    not null,
							   cedfamper   char(10),   
							   nomfamper   varchar(100),
							   apefamper   varchar(100),
							   sexfamper   char(1),
							   nexfamper   char(1),
							   fecnacfamper   date,   
							   PRIMARY KEY (codemp,codper,codcon,codfamper))  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_27-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE   srh_familiaresconcursante
					              ADD  FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT,  
                                  ADD  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								       ON UPDATE RESTRICT ";								
			   break;
			   case "POSTGRES":
					 $ls_sql=" ALTER TABLE   srh_familiaresconcursante
					              ADD  FOREIGN KEY(codemp,codcon,codper) REFERENCES srh_concursante (codemp,codcon,codper)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT,  
                                  ADD  FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  ON DELETE RESTRICT 
								       ON UPDATE RESTRICT ";										
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_27-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_27 
//-------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_28()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_28
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  CREATE TABLE  srh_requisitosconcursante(
							   codemp      char(4)     not null,
							   codcon      char(10)    not null,
							   codper      char(10)    not null,
							   codreqcon   smallint    not null,
							   entreqcon   smallint,
							   canentreqcon  smallint, 
							   PRIMARY KEY (codemp,codper,codcon,codreqcon)) 
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_requisitosconcursante(
							   codemp      char(4)     not null,
							   codcon      char(10)    not null,
							   codper      char(10)    not null,
							   codreqcon   smallint    not null,
							   entreqcon   smallint,
							   canentreqcon  smallint, 
							   PRIMARY KEY (codemp,codper,codcon,codreqcon)							    
							)  WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_28-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql="  ALTER TABLE srh_requisitosconcursante
					               ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT";								
			   break;
			   case "POSTGRES":
					 $ls_sql="  ALTER TABLE srh_requisitosconcursante
					               ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								       ON DELETE RESTRICT ON UPDATE RESTRICT";											
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_28-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_28 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_29()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_29
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  CREATE TABLE  srh_requisitos_concurso(
							   codemp      char(4)     not null,
							   codcon      char(10)    not null,
							   codreqcon   smallint    not null,
							   desreqcon   varchar(254),
							   canreqcon   smallint,  
							   reqindcon   char (1),
							   PRIMARY KEY (codemp,codcon,codreqcon))  
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" CREATE TABLE  srh_requisitos_concurso(
							   codemp      char(4)     not null,
							   codcon      char(10)    not null,
							   codreqcon   smallint    not null,
							   desreqcon   varchar(254),
							   canreqcon   smallint,  
							   reqindcon   char (1),
							   PRIMARY KEY (codemp,codcon,codreqcon))  
							   WITHOUT OIDS;";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_29-01");
				$lb_valido=false;
			}
	   } 
	   if ($lb_valido)	   
	   {
	   		switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE srh_requisitos_concurso
					              ADD FOREIGN KEY(codemp,codcon) REFERENCES srh_concurso(codemp,codcon)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT ";								
			   break;
			   case "POSTGRES":
			   		  $ls_sql=" ALTER TABLE srh_requisitos_concurso
					              ADD FOREIGN KEY(codemp,codcon) REFERENCES srh_concurso(codemp,codcon)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT,   
                                  ADD FOREIGN KEY(codemp) REFERENCES sigesp_empresa(codemp)  
								      ON DELETE RESTRICT ON UPDATE RESTRICT ";										
				  break;									  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_29-02");
					$lb_valido=false;
				}
		   } 	   
	   }
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_29 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_30()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_30
		//		   Access: public 
		//        Modulos: scb
		//	  Description: 
		// Fecha Creacion: 25/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scb_colocacion ADD codconmov char(3);";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql="  ALTER TABLE scb_colocacion ADD codconmov char(3);";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_30-01");
				$lb_valido=false;
			}
	   } 
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scb_colocacion ADD cod_pro char(10);";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql="  ALTER TABLE scb_colocacion	ADD cod_pro char(10);";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_30-02");
				$lb_valido=false;
			}
	   } 	  
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scb_colocacion ADD ced_bene char(10);";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql="  ALTER TABLE scb_colocacion	ADD ced_bene char(10);";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_30-03");
				$lb_valido=false;
			}
	   } 	  	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_30 
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_31()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_31
		//		   Access: public 
		//        Modulos: SCV
		//	  Description: 
		// Fecha Creacion: 26/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	    
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro1 varchar(25); ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro1 varchar(25); ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-01");
				$lb_valido=false;
			}
	   } 
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro2 varchar(25); ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro2 varchar(25); ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-02");
				$lb_valido=false;
			}
	   } 	  
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro3 varchar(25); ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro3 varchar(25); ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-03");
				$lb_valido=false;
			}
	   } 	  
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro4 varchar(25); ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro4 varchar(25); ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-04");
				$lb_valido=false;
			}
	   } 	  
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro5 varchar(25); ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scv_solicitudviatico ADD COLUMN codestpro5 varchar(25); ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-05");
				$lb_valido=false;
			}
	   } 	
	    switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN estcla     varchar(1);  ";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql="  ALTER TABLE scv_solicitudviatico ADD COLUMN estcla     varchar(1);  ";									
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_31-06");
				$lb_valido=false;
			}
	   } 	  	    	  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_31 
//----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_32()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_32
		//		   Access: public 
		//        Modulos: SOC
		//	  Description: 
		// Fecha Creacion: 29/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" ALTER TABLE soc_solicitudcargos ADD numsol varchar(15);";								
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" ALTER TABLE soc_solicitudcargos ADD numsol varchar(15);";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_32");
				$lb_valido=false;
			}
		} 	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_32 
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_33()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_33
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 29/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" ALTER TABLE sigesp_empresa ADD estmodpartsep char(1) DEFAULT '0';";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql=" ALTER TABLE sigesp_empresa ADD estmodpartsep char(1) DEFAULT '0';";											
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_33-01");
				$lb_valido=false;
			}
		} 
			   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				    $ls_sql=" ALTER TABLE sigesp_empresa ADD estmodpartsoc char(1) DEFAULT '0';";							
				   break;
				   
			case "POSTGRES":
				   $ls_sql=" ALTER TABLE sigesp_empresa ADD estmodpartsoc char(1) DEFAULT '0';";										
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_33-02");
				$lb_valido=false;
			}
		} 	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_33
//----------------------------------------------------------------------------------------------------------------------------------- 
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_34()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_03
		//		   Access: public 
		//        Modulos: SPS
		//	  Description: 
		// Fecha Creacion: 29/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER codestpro1 TYPE char(25) ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN codestpro1 CHAR(25)                     ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-01");
					$lb_valido=false;
				}
	  }	
	  //-----------------------------------------------------------------------------------------------
	  switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER codestpro2 TYPE char(25) ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN codestpro2 CHAR(25)                     ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-02");
					$lb_valido=false;
				}
	  }	    
	  //----------------------------------------------------------------------------------------------------	      
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER codestpro3 TYPE char(25) ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN codestpro3 CHAR(25)                     ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-03");
					$lb_valido=false;
				}
	  }	    
	  //----------------------------------------------------------------------------------------------------
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER codestpro4 TYPE char(25) ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN codestpro4 CHAR(25)                     ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-04");
					$lb_valido=false;
				}
	  }	    
	  //--------------------------------------------------------------------------------------------------------
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER codestpro5 TYPE char(25) ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN codestpro5 CHAR(25)                     ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-05");
					$lb_valido=false;
				}
	  }	    
	  //--------------------------------------------------------------------------------------------------------
	  switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER estatus TYPE int2 ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN estatus int2                         ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-06");
					$lb_valido=false;
				}
	  }	    
	  //--------------------------------------------------------------------------------------------------------
	  switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ALTER estrd  TYPE int2 ;  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sps_dt_spg                                ".
				         "   MODIFY COLUMN estrd  int2                         ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci  NOT  NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-07");
					$lb_valido=false;
				}
	  }	
	   //------------------------------------------------------------------------------------------------------
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sps_dt_spg ADD estcla  varchar(1)  not null;  ";	
			  break;
				   
			case "MYSQLT":
			      $ls_sql="   ALTER TABLE sps_dt_spg ADD estcla  varchar(1)  not null;  ";			   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-08");
					$lb_valido=false;
				}
	  }	  
	  //-----------------------------------------------------------------------------------------------------------------------
	  $ls_existe = $this->io_function_db->uf_select_constraint('sps_dt_spg','pk_sps_dt_spg');
	   if ($ls_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {				   
				case "POSTGRES":
					$ls_sql= " ALTER TABLE sps_dt_spg  DROP CONSTRAINT pk_sps_dt_spg;";		
				break;	
				
				case "MSQLT":
					$ls_sql= " ALTER TABLE sps_dt_spg  DROP CONSTRAINT pk_sps_dt_spg;";		
				break;				  
		   }
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-09");
					 $lb_valido=false;
				 }
			}
	   }//fin del if($ls_existe)
	   //-----------------------------------------------------------------------------------------------------
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
					  $ls_sql=" ALTER TABLE sps_dt_spg
					              ADD constraint pk_sps_dt_spg primary key 
								  (codemp, codnom, codcom, tipo, 
								   codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla, spg_cuenta, operacion)";								
			   break;
			   case "POSTGRES":
			   		 $ls_sql=" ALTER TABLE sps_dt_spg
					              ADD constraint pk_sps_dt_spg primary key 
								  (codemp, codnom, codcom, tipo, 
								   codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla, spg_cuenta, operacion)";						
				  break;							  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_34-10");
					$lb_valido=false;
				}
	  }	  
	  //----------------------------------------------------------------------------------------------------------   
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_34 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_35()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_35
		//		   Access: public 
		//        Modulos: RRHH
		//	  Description: 
		// Fecha Creacion: 30/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	  
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table srh_organigrama (
						   			codemp               char(4)              not null,
						   			codorg               char(10)             not null,
						  			desorg               varchar(254)         null,
						   			nivorg               int2                 null,
						   			padorg               char(10)             null default '----------',
						   	constraint pk_srh_organigrama primary key (codemp, codorg)	);";								
				   break;
				   
			case "POSTGRES":
				     $ls_sql=" create table srh_organigrama (
						   			codemp               char(4)              not null,
						   			codorg               char(10)             not null,
						  			desorg               varchar(254)         null,
						   			nivorg               int2                 null,
						   			padorg               char(10)             null default '----------',
						   	constraint pk_srh_organigrama primary key (codemp, codorg)	);";															
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_34-01");
				$lb_valido=false;
			}
		} 
	   //--------------------------------------------------------------------------------------------------------
	   if ($lb_valido)	
	   {   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=" alter table srh_organigrama
								   add constraint fk_srh_organigrama__sigesp_empresa foreign key (codemp)
									  references sigesp_empresa (codemp)
									  on delete restrict on update restrict;";									
					   break;
					   
				case "POSTGRES":
					   $ls_sql=" alter table srh_organigrama
								   add constraint fk_srh_organigrama__sigesp_empresa foreign key (codemp)
									  references sigesp_empresa (codemp)
									  on delete restrict on update restrict;";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_34-02");
					$lb_valido=false;
				}
			} 
		}//fin del if	
		if ($lb_valido)
		{
		    $ls_codemp=$_SESSION["la_empresa"]["codemp"];
		    $ls_sql=" INSERT INTO srh_organigrama (codemp,codorg,desorg, nivorg, padorg) VALUES ".
			        "                             ('".$ls_codemp."','----------','',0,'----------')"; 
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_34-03 ERROR->".$this->io_function->uf_convertirmsg($this->io_sql->message));
				$lb_valido=false;
			}
		}	
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_35
//----------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_3_36()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_36
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 30/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" ALTER TABLE sno_personal ADD COLUMN codorg char (10) DEFAULT '----------';";								
				   break;
				   
			case "POSTGRES":
				    $ls_sql=" ALTER TABLE sno_personal ADD COLUMN codorg char (10) DEFAULT '----------';";											
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_36-01");
				$lb_valido=false;
			}
		} 
		if ($lb_valido)	
	    {   
			   switch($_SESSION["ls_gestor"])
			   {
					case "MYSQLT":
							$ls_sql=" alter table sno_personal
									   add constraint fk_sno_personal__srh_organigrama foreign key (codemp, codorg)
										  references srh_organigrama (codemp, codorg)
										  on delete restrict on update restrict;";							
						   break;
						   
					case "POSTGRES":
						   $ls_sql=" alter table sno_personal
									   add constraint fk_sno_personal__srh_organigrama foreign key (codemp, codorg)
										  references srh_organigrama (codemp, codorg)
										  on delete restrict on update restrict;";										
							break;  				  
				}
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_3_36-02");
						$lb_valido=false;
					}
				}
	    } 	   
	 return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_36
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_37()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_37
		//		   Access: public 
		//        Modulos: 
		//	  Description: SCB
		// Fecha Creacion: 30/09/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe="";   
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
				   $ls_sql=" create table scb_dt_colocacion (
								   codemp               char(4)              not null,
								   codban               char(3)              not null,
								   ctaban               char(25)             not null,
								   numcol               char(15)             not null,
								   fecreint             date                 not null default '1900-01-01',
								   montoreint           float8               null default '0',
								   constraint pk_scb_dt_colocacion primary key (codemp, codban, ctaban, numcol, fecreint));";								
				   break;
				   
			case "POSTGRES":
				  $ls_sql=" create table scb_dt_colocacion (
								   codemp               char(4)              not null,
								   codban               char(3)              not null,
								   ctaban               char(25)             not null,
								   numcol               char(15)             not null,
								   fecreint             date                 not null default '1900-01-01',
								   montoreint           float8               null default '0',
								   constraint pk_scb_dt_colocacion primary key (codemp, codban, ctaban, numcol, fecreint));";												
					break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_37-01");
				$lb_valido=false;
			}
		} 
		if ($lb_valido)	
	    {   
			   switch($_SESSION["ls_gestor"])
			   {
					case "MYSQLT":
							$ls_sql=" alter table scb_dt_colocacion
									   add constraint fk_scb_dt_colocacion__scb_colocacion foreign key 
									      (codemp, codban, ctaban, numcol)
										  references scb_colocacion (codemp, codban, ctaban, numcol)
										  on delete restrict on update restrict;";							
						   break;
						   
					case "POSTGRES":
						  $ls_sql=" alter table scb_dt_colocacion
									   add constraint fk_scb_dt_colocacion__scb_colocacion foreign key 
									      (codemp, codban, ctaban, numcol)
										  references scb_colocacion (codemp, codban, ctaban, numcol)
										  on delete restrict on update restrict;";										
							break;  				  
				}
				if (!empty($ls_sql))
				{	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas al ejecutar Release 2008_3_37-02");
						$lb_valido=false;
					}
				}
	    } 	   
	 return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_37
//----------------------------------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_38()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_38
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql=" ALTER TABLE saf_activo ".
							   "   ADD tipinm varchar(1)";								
					   break;
					   
				case "POSTGRES":
					   $ls_sql=" ALTER TABLE saf_activo ".
							   "   ADD tipinm varchar(1)";											
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_38");
					$lb_valido=false;
				}
			}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_38 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_39()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_39
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql=" CREATE TABLE saf_edificios(
								  codemp varchar(4) NOT NULL,
								  codact varchar(15) NOT NULL,
								  expact varchar(15) NOT NULL,
								  clasfun text,
								  diract text,
								  areatot double precision,
								  areacons double precision,
								  numpiso int4,
								  areatotpiso double precision,
								  areanex double precision,  
								  lindero text,
								  estlegprop text,
								  avaluo text,
								  feccont date default '1900-01-01',
								  moncont double  precision default 0.00,
								  CONSTRAINT pk_saf_edificios PRIMARY KEY (codemp, codact, expact))
								  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci";								
					   break;
					   
				case "POSTGRES":
					      $ls_sql=" CREATE TABLE saf_edificios(
								  codemp varchar(4) NOT NULL,
								  codact varchar(15) NOT NULL,
								  expact varchar(15) NOT NULL,
								  clasfun text,
								  diract text,
								  areatot double precision,
								  areacons double precision,
								  numpiso int4,
								  areatotpiso double precision,
								  areanex double precision,  
								  lindero text,
								  estlegprop text,
								  avaluo text,
								  feccont date default '1900-01-01',
								  moncont double  precision default 0.00,
								  CONSTRAINT pk_saf_edificios PRIMARY KEY (codemp, codact, expact))";													
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_39-01");
					$lb_valido=false;
				}
			}
		if ($lb_valido)
		{
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql=" ALTER TABLE saf_edificios								
									ADD CONSTRAINT fk_saf_activos FOREIGN KEY (codemp, codact)
									REFERENCES saf_activo (codemp, codact) MATCH SIMPLE
									ON UPDATE NO ACTION ON DELETE NO ACTION";								
					   break;
					   
				case "POSTGRES":
					      $ls_sql=" ALTER TABLE saf_edificios									
									ADD CONSTRAINT fk_saf_activos FOREIGN KEY (codemp, codact)
									REFERENCES saf_activo (codemp, codact) MATCH SIMPLE
									ON UPDATE NO ACTION ON DELETE NO ACTION";												
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_39-02");
					$lb_valido=false;
				}
			}
		}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_39 
//----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_40()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_40
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql="create table saf_tipoestructura(
								    codemp varchar(4) NOT NULL,
								    codtipest varchar(4) NOT NULL,
								    dentipest varchar(50),
								    CONSTRAINT pk_saf_tipoest PRIMARY KEY (codemp, codtipest))								    
									ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
					   break;
					   
				case "POSTGRES":
					      $ls_sql="create table saf_tipoestructura(
								    codemp varchar(4) NOT NULL,
								    codtipest varchar(4) NOT NULL,
								    dentipest varchar(50),
								    CONSTRAINT pk_saf_tipoest PRIMARY KEY (codemp, codtipest),
									CONSTRAINT fk_saf_tipoest_emp FOREIGN KEY (codemp)
								    REFERENCES sigesp_empresa (codemp) 
								    MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT)								    
									WITHOUT OIDS; ";												
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_40-01");
					$lb_valido=false;
				}
			}
		if ($lb_valido)
		{
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE saf_tipoestructura									
								ADD CONSTRAINT fk_saf_tipoest_emp FOREIGN KEY (codemp)
								    REFERENCES sigesp_empresa (codemp) 
								    MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT";							
					   break;				  
			}
			if ((!empty($ls_sql))&&($_SESSION["ls_gestor"]=="MSQLT"))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_40-02");
					$lb_valido=false;
				}
			}
		}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_40
//----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_41()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_41
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql="create table saf_componente(
								 codemp varchar(4) NOT NULL,
								 codtipest varchar(4) NOT NULL,
								 codcomp varchar(4) NOT NULL,
								 dencomp varchar(50),
								 CONSTRAINT pk_saf_componente PRIMARY KEY (codemp, codtipest, codcomp))
								 ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
					   break;
					   
				case "POSTGRES":
					      $ls_sql="create table saf_componente(
								 codemp varchar(4) NOT NULL,
								 codtipest varchar(4) NOT NULL,
								 codcomp varchar(4) NOT NULL,
								 dencomp varchar(50),
								 CONSTRAINT pk_saf_componente PRIMARY KEY (codemp, codtipest, codcomp))
								 WITHOUT OIDS;";												
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_41-01");
					$lb_valido=false;
				}
			}
		if ($lb_valido)
		{
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE saf_componente									
								ADD  CONSTRAINT fk_saf_componente_emp FOREIGN KEY (codemp)
                                     REFERENCES sigesp_empresa (codemp) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT";							
					   break;
					   
				case "POSTGRES":
					  $ls_sql=" ALTER TABLE saf_componente									
								ADD  CONSTRAINT fk_saf_componente_emp FOREIGN KEY (codemp)
                                     REFERENCES sigesp_empresa (codemp) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT";													
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_41-02");
					$lb_valido=false;
				}
			}
		}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_41
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_42()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_42
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql="create table saf_edificiotipest(
								 codemp varchar(4) NOT NULL,
								 codtipest varchar(4) NOT NULL,
								 codcomp varchar(4) NOT NULL,
								 codact character varying(15) NOT NULL,
								 expact character varying(15) NOT NULL,
								 CONSTRAINT pk_saf_edificiotipest PRIMARY KEY (codemp, codtipest, codcomp, codact, expact))
								 ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";								
					   break;
					   
				case "POSTGRES":
					      $ls_sql="create table saf_edificiotipest(
									 codemp varchar(4) NOT NULL,
									 codtipest varchar(4) NOT NULL,
									 codcomp varchar(4) NOT NULL,
									 codact character varying(15) NOT NULL,
									 expact character varying(15) NOT NULL,
									 CONSTRAINT pk_saf_edificiotipest PRIMARY KEY (codemp, codtipest, codcomp, codact, expact),
									 CONSTRAINT fk_saf_edificiotipest_emp FOREIGN KEY (codemp)
									 REFERENCES sigesp_empresa (codemp) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT)
									 WITHOUT OIDS;";												
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_42-01");
					$lb_valido=false;
				}
			}
		if ($lb_valido)
		{
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE saf_edificiotipest									
								ADD   CONSTRAINT fk_saf_edificiotipest_emp FOREIGN KEY (codemp)
									  REFERENCES sigesp_empresa (codemp) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT,
								ADD   CONSTRAINT fk_saf_edificiotipest_tipoestructura FOREIGN KEY (codemp, codtipest)
									  REFERENCES saf_tipoestructura (codemp, codtipest) MATCH SIMPLE ON UPDATE RESTRICT 
									  ON DELETE RESTRICT,
							    ADD   CONSTRAINT fk_saf_edificiotipest_componente FOREIGN KEY (codemp, codtipest, codcomp)
									  REFERENCES saf_componente (codemp, codtipest, codcomp) MATCH SIMPLE ON UPDATE 
									  RESTRICT ON DELETE RESTRICT,
								ADD   CONSTRAINT fk_saf_edificiotipest_edificio FOREIGN KEY (codemp, codact, expact)
									  REFERENCES saf_edificios (codemp, codact, expact) MATCH SIMPLE ON UPDATE RESTRICT 
									  ON DELETE RESTRICT";							
					   break;			  				  
			}
			if ((!empty($ls_sql))&&($_SESSION["ls_gestor"]=="MSQLT"))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_42-02");
					$lb_valido=false;
				}
			}
		}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_42
//------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_43()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_43
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN estmanant char(1) NOT NULL DEFAULT '0';";								
					   break;
					   
				case "POSTGRES":
					$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN estmanant char(1) NOT NULL DEFAULT '0';";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_43");
					$lb_valido=false;
				}
			}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_43 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_44()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_44
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 01/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_existe=true;
	    $ls_sql="";
	    $ls_existe = $this->io_function_db->uf_select_constraint('scv_tarifas','fk_scv_tari_scv_regio_scv_regi');
		if ($ls_existe)
		{   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					$ls_sql=" ALTER TABLE scv_tarifas DROP FOREIGN KEY fk_scv_tari_scv_regio_scv_regi;";								
					   break;
					   
				case "POSTGRES":
					$ls_sql=" ALTER TABLE scv_tarifas DROP CONSTRAINT fk_scv_tari_scv_regio_scv_regi;";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_44");
					$lb_valido=false;
				}
			}
	    }// fin del if	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_44 
//----------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_3_45()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_45
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 07/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    switch($_SESSION["ls_gestor"])
		{
			case "MYSQLT":
				 $ls_sql=" create table spi_cuentas_estructuras (
						   codemp               char(4)              not null,						
						   spi_cuenta           char(25)             not null,						
						   codestpro1           char(25)             not null,						
						   codestpro2           char(25)             not null,						
						   codestpro3           char(25)             not null,						
						   codestpro4           char(25)             not null,						
						   codestpro5           char(25)             not null,						
						   estcla               varchar(1)           not null,						
						   constraint pk_spi_cuentas_estructuras primary key (codemp, spi_cuenta, codestpro1, 
						                                                      codestpro2,  codestpro3, codestpro4,
																			  codestpro5, estcla));";								
			     break;
					   
			case "POSTGRES":
				 $ls_sql=" create table spi_cuentas_estructuras (
						   codemp               char(4)              not null,						
						   spi_cuenta           char(25)             not null,						
						   codestpro1           char(25)             not null,						
						   codestpro2           char(25)             not null,						
						   codestpro3           char(25)             not null,						
						   codestpro4           char(25)             not null,						
						   codestpro5           char(25)             not null,						
						   estcla               varchar(1)           not null,						
						   constraint pk_spi_cuentas_estructuras primary key (codemp, spi_cuenta, codestpro1, 
						                                                      codestpro2,  codestpro3, codestpro4,
																			  codestpro5, estcla));";												
				 break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_45-01");
				$lb_valido=false;
			}
		}
		//--------------------------fin del Release 2008_3_45-01---------------------------------------------
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
			{
				case "MYSQLT":
					 $ls_sql=" alter table spi_cuentas_estructuras
                                 add constraint fk_spi_cuentas_estructuras__spg_ep5 foreign key 
								     (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5)
                                 references spg_ep5 (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5)
                                 on delete restrict on update restrict;";								
					 break;
						   
				case "POSTGRES":
					$ls_sql=" alter table spi_cuentas_estructuras
                                 add constraint fk_spi_cuentas_estructuras__spg_ep5 foreign key 
								     (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5)
                                 references spg_ep5 (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5)
                                 on delete restrict on update restrict;";												
					 break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_45-02");
					$lb_valido=false;
				}
			}
		}// fin del if	   	   
		//--------------------------fin del Release 2008_3_45-02---------------------------------------------
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
			{
				case "MYSQLT":
					 $ls_sql=" alter table spi_cuentas_estructuras
                                 add constraint fk_spi_cuentas_estructuras__spi_cuentas foreign key (codemp, spi_cuenta)
                               references spi_cuentas (codemp, spi_cuenta) on delete restrict on update restrict;";								
					 break;
						   
				case "POSTGRES":
					 $ls_sql=" alter table spi_cuentas_estructuras
                                 add constraint fk_spi_cuentas_estructuras__spi_cuentas foreign key (codemp, spi_cuenta)
                               references spi_cuentas (codemp, spi_cuenta) on delete restrict on update restrict;";			
					 break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_45-03");
					$lb_valido=false;
				}
			}
		}// fin del if	   	   
		//--------------------------fin del Release 2008_3_45-03---------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_45 
//-------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_46()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_46
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 07/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					$ls_sql=" ALTER TABLE sigesp_empresa ADD estpreing int2 DEFAULT 0;";								
					   break;
					   
				case "POSTGRES":
					$ls_sql=" ALTER TABLE sigesp_empresa ADD estpreing int2 DEFAULT 0;";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_46");
					$lb_valido=false;
				}
			}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_46 
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_47()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_47
		//		   Access: public 
		//        Modulos: SNO 
		//	  Description: 
		// Fecha Creacion: 07/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					$ls_sql=" ALTER TABLE sno_archivotxt ADD COLUMN tiparch char(1) DEFAULT 'I';";								
					   break;
					   
				case "POSTGRES":
					$ls_sql=" ALTER TABLE sno_archivotxt ADD COLUMN tiparch char(1) DEFAULT 'I';";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_47-01");
					$lb_valido=false;
				}
			}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					$ls_sql=" ALTER TABLE sno_archivotxt ADD COLUMN acumon  Char(1) DEFAULT '0';";								
					   break;
					   
				case "POSTGRES":
					$ls_sql=" ALTER TABLE sno_archivotxt ADD COLUMN acumon  Char(1) DEFAULT '0';";									
						break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_47-02");
					$lb_valido=false;
				}
			}	   
		}	   
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_47 
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_48()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_48
		//		   Access: public 
		//        Modulos: SNO 
		//	  Description: 
		// Fecha Creacion: 07/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		switch($_SESSION["ls_gestor"])
        {
			case "MYSQLT":
				$ls_sql=" ALTER TABLE spi_cuentas_estructuras ADD COLUMN previsto float8 null default 0;";								
			  break;
					   
			case "POSTGRES":
				$ls_sql=" ALTER TABLE spi_cuentas_estructuras ADD COLUMN previsto float8 null default 0;";									
				break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_48");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_48 
//--------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_49()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_49
		//		   Access: public 
		//        Modulos: SNO 
		//	  Description: 
		// Fecha Creacion: 07/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		switch($_SESSION["ls_gestor"])
        {
			case "MYSQLT":
				$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN concommun varchar(6)";								
			  break;
					   
			case "POSTGRES":
				$ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN concommun varchar(6)";									
				break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_49");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_49 
//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_50()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_50
		//		   Access: public 
		//        Modulos: SCB 
		//	  Description: 
		// Fecha Creacion: 08/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		switch($_SESSION["ls_gestor"])
        {
			case "MYSQLT":
				$ls_sql=" ALTER TABLE scb_movbco ADD estant char(1) default '0';";								
			  break;
					   
			case "POSTGRES":
				$ls_sql=" ALTER TABLE scb_movbco ADD estant char(1) default '0';";									
				break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_50");
				$lb_valido=false;
			}
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_50 
//-------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_51()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_51
		//		   Access: public 
		//        Modulos: SCB 
		//	  Description: 
		// Fecha Creacion: 08/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=true;
	    $ls_sql="";	   
		switch($_SESSION["ls_gestor"])
        {
			case "MYSQLT":
				$ls_sql=" CREATE TABLE scb_movbco_anticipo(
							  codemp character(4) NOT NULL,
							  codban character(3) NOT NULL,
							  ctaban character(25) NOT NULL,
							  numdoc character(15) NOT NULL,
							  codope character(2) NOT NULL,
							  estmov character(1) NOT NULL,
							  codamo character(5) NOT NULL,
							  monamo double precision,
							  monsal double precision,
							  montotamo double precision,
							  CONSTRAINT pk_mvobco_ant PRIMARY KEY (codemp, codban, ctaban, numdoc, codope, estmov, codamo)
							) ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";										
			  break;
					   
			case "POSTGRES":
				$ls_sql=" CREATE TABLE scb_movbco_anticipo(
							  codemp character(4) NOT NULL,
							  codban character(3) NOT NULL,
							  ctaban character(25) NOT NULL,
							  numdoc character(15) NOT NULL,
							  codope character(2) NOT NULL,
							  estmov character(1) NOT NULL,
							  codamo character(5) NOT NULL,
							  monamo double precision,
							  monsal double precision,
							  montotamo double precision,
							  CONSTRAINT pk_mvobco_ant PRIMARY KEY (codemp, codban, ctaban, numdoc, codope, estmov, codamo),
							  CONSTRAINT fk_mvobco_mvobco FOREIGN KEY (codemp, codban, ctaban, numdoc, codope, estmov)
								  REFERENCES scb_movbco (codemp, codban, ctaban, numdoc, codope, estmov) MATCH SIMPLE
								  ON UPDATE NO ACTION ON DELETE NO ACTION
							)WITHOUT OIDS;";									
				break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas al ejecutar Release 2008_3_51");
				$lb_valido=false;
			}
		}
		if (($_SESSION["ls_gestor"]=="MYSQLT")&&($lb_valido))
		{		
			$ls_sql=" ALTER TABLE scb_movbco_anticipo
			            ADD CONSTRAINT fk_mvobco_mvobco FOREIGN KEY (codemp, codban, ctaban, numdoc, codope, estmov)
					    REFERENCES scb_movbco (codemp, codban, ctaban, numdoc, codope, estmov) MATCH SIMPLE
						ON UPDATE NO ACTION ON DELETE NO ACTION";		
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas al ejecutar Release 2008_3_51-02");
					$lb_valido=false;
				}
			}		
		}		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_51 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_52()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_52
		//		   Access: public 
		//        Modulos: SCV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_existe1 = $this->io_function_db->uf_select_constraint('scv_solicitudviatico','fk_scv_soli_scv_rutas_scv_ruta');
	   if ($ls_existe1)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
			       $ls_sql= " ALTER TABLE scv_solicitudviatico DROP CONSTRAINT fk_scv_soli_scv_rutas_scv_ruta;";					
				   break;
				   
				case "POSTGRES":
				   $ls_sql= " ALTER TABLE scv_solicitudviatico DROP CONSTRAINT fk_scv_soli_scv_rutas_scv_ruta;";	
					break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_52-01");
					 $lb_valido=false;
				 }
			}
	    }//fin del if($ls_existe)	   
	   //-----------------------------------------------------------------------------------------
	   if ($lb_valido)
	   {
		   $ls_existe2 = $this->io_function_db->uf_select_constraint('scv_rutas','ak_key_2_scv_ruta');
		   if ($ls_existe2)
		   {
			   switch($_SESSION["ls_gestor"])
			   {
					case "MYSQLT":
				  $ls_sql= " ALTER TABLE scv_rutas DROP CONSTRAINT ak_key_2_scv_ruta;";					
					   break;
					   
					case "POSTGRES":
					   $ls_sql= " ALTER TABLE scv_rutas DROP CONSTRAINT ak_key_2_scv_ruta;";	
						break;				  
				}
				if (!empty($ls_sql))
				{	
					 $li_row=$this->io_sql->execute($ls_sql);
					 if($li_row===false)
					 { 
						 $this->io_msg->message("Problemas al ejecutar Release 2008_3_52-02");
						 $lb_valido=false;
					 }
				}
		   }//fin del if($ls_existe)
		}// fin del if($lb_valido)	   
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_52 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_53()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_53
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql= " create table siv_segmento (
							   codemp   char(4)   not null,
							   codseg   char(2)   not null,
							   desseg   text      null,
							   tipo     char(1)   null,
							   constraint pk_siv_segmento primary key (codemp, codseg))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					
              break;
				   
			case "POSTGRES":
				 $ls_sql= " create table siv_segmento (
							   codemp   char(4)   not null,
							   codseg   char(2)   not null,
							   desseg   text      null,
							   tipo     char(1)   null,
							   constraint pk_siv_segmento primary key (codemp, codseg))
							   WITHOUT OIDS";	
			  break;				  
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_3_53-01");
				 $lb_valido=false;
			 }
		}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  alter table siv_segmento
								   add constraint fk_siv_segmento__sigesp_empresa foreign key (codemp)
									  references sigesp_empresa (codemp)
									  on delete restrict on update restrict;";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  alter table siv_segmento
								   add constraint fk_siv_segmento__sigesp_empresa foreign key (codemp)
									  references sigesp_empresa (codemp)
									  on delete restrict on update restrict;";	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_53-02");
					 $lb_valido=false;
				 }
			}
		}// fin del if  
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  insert into siv_segmento (codemp, codseg) values ('".$this->ls_codemp."', '--');";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  insert into siv_segmento (codemp, codseg) values ('".$this->ls_codemp."', '--');";					
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_53-03");
					 $lb_valido=false;
				 }
			}
		}// fin del if    
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_53 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_54()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_54
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql= " create table siv_familia (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   desfami              text                 null,
							   constraint pk_siv_familia primary key (codemp, codseg, codfami))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					
              break;
				   
			case "POSTGRES":
				$ls_sql= " create table siv_familia (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   desfami              text                 null,
							   constraint pk_siv_familia primary key (codemp, codseg, codfami))
							   WITHOUT OIDS";	
			  break;				  
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_3_54-01");
				 $lb_valido=false;
			 }
		}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  alter table siv_familia
								    add constraint fk_siv_familia__siv_segmento foreign key (codemp, codseg)
									  references siv_segmento (codemp, codseg)
									  on delete restrict on update restrict;";					
				  break;
					   
				case "POSTGRES":
					   $ls_sql= "  alter table siv_familia
								    add constraint fk_siv_familia__siv_segmento foreign key (codemp, codseg)
									  references siv_segmento (codemp, codseg)
									  on delete restrict on update restrict;";	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_54-02");
					 $lb_valido=false;
				 }
			}
		}// fin del if
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  insert into siv_familia (codemp, codseg, codfami) values ('".$this->ls_codemp."', '--','----');";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  insert into siv_familia  (codemp, codseg, codfami) values ('".$this->ls_codemp."', '--', '----');";					
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_54-03");
					 $lb_valido=false;
				 }
			}
		}// fin del if       
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_54 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_55()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_55
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql= " create table siv_clase (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   codclase             char(6)              not null,
							   desclase             text                 null,
							   constraint pk_siv_clase primary key (codemp, codseg, codfami, codclase))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					
              break;
				   
			case "POSTGRES":
				 $ls_sql= " create table siv_clase (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   codclase             char(6)              not null,
							   desclase             text                 null,
							   constraint pk_siv_clase primary key (codemp, codseg, codfami, codclase))
							   WITHOUT OIDS";	
			  break;				  
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_3_55-01");
				 $lb_valido=false;
			 }
		}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  alter table siv_clase
								    add constraint fk_siv_clase__siv_familia foreign key (codemp, codseg, codfami)
									    references siv_familia (codemp, codseg, codfami)
									    on delete restrict on update restrict;";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  alter table siv_clase
								    add constraint fk_siv_clase__siv_familia foreign key (codemp, codseg, codfami)
									    references siv_familia (codemp, codseg, codfami)
									    on delete restrict on update restrict;";
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_55-02");
					 $lb_valido=false;
				 }
			}
		}// fin del if
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  insert into siv_clase (codemp, codseg, codfami, codclase) values ('".$this->ls_codemp."', '--','----','------');";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  insert into siv_clase (codemp, codseg, codfami, codclase) values ('".$this->ls_codemp."', '--', '----', '------');";					
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_55-03");
					 $lb_valido=false;
				 }
			}
		}// fin del if          
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_55 
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_56()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_56
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql= " create table siv_producto (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   codclase             char(6)              not null,
							   codprod              char(8)              not null,
							   desproducto          text                 null,
							   constraint pk_siv_producto primary key (codemp, codseg, codfami, codclase, codprod))
							   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					
              break;
				   
			case "POSTGRES":
				  $ls_sql= " create table siv_producto (
							   codemp               char(4)              not null,
							   codseg               char(2)              not null,
							   codfami              char(4)              not null,
							   codclase             char(6)              not null,
							   codprod              char(8)              not null,
							   desproducto          text                 null,
							   constraint pk_siv_producto primary key (codemp, codseg, codfami, codclase, codprod))
							   WITHOUT OIDS";	
			  break;				  
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_3_56-01");
				 $lb_valido=false;
			 }
		}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  alter table siv_producto
								   add constraint fk_siv_producto__siv_clase foreign key (codemp, codseg, codfami, codclase)
									   references siv_clase (codemp, codseg, codfami, codclase)
									   on delete restrict on update restrict;";					
				  break;
					   
				case "POSTGRES":
					   $ls_sql= "  alter table siv_producto
								   add constraint fk_siv_producto__siv_clase foreign key (codemp, codseg, codfami, codclase)
									   references siv_clase (codemp, codseg, codfami, codclase)
									   on delete restrict on update restrict;";	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_56-02");
					 $lb_valido=false;
				 }
			}
		}// fin del if
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
	   		{
				case "MYSQLT":
					  $ls_sql= "  insert into siv_producto (codemp, codseg, codfami, codclase, codprod) values ('".$this->ls_codemp."', '--','----','------','--------');";					
				  break;
					   
				case "POSTGRES":
					  $ls_sql= "  insert into siv_producto (codemp, codseg, codfami, codclase, codprod) values ('".$this->ls_codemp."', '--', '----', '------', '--------');";					
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_55-03");
					 $lb_valido=false;
				 }
			}
		}// fin del if             
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_56 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_57()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_57
		//		   Access: public 
		//        Modulos: SIV
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			     $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codseg char(2) null default '--'; ";

              break;
				   
			case "POSTGRES":
				  $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codseg char(2) null default '--'; ";						  	
			  break;				  
		}
		if (!empty($ls_sql))
		{	
			 $li_row=$this->io_sql->execute($ls_sql);
			 if($li_row===false)
			 { 
				 $this->io_msg->message("Problemas al ejecutar Release 2008_3_57-01");
				 $lb_valido=false;
			 }
		}
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codfami char(4) null default '----'; ";
	
				  break;
					   
				case "POSTGRES":
					  $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codfami char(4) null default '----'; ";				  	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_57-02");
					 $lb_valido=false;
				 }
			}
		}// fin del if   
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codclase  char(6) null default '------'; ";
	
				  break;
					   
				case "POSTGRES":
					   $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codclase  char(6) null default '------'; ";			  	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_57-03");
					 $lb_valido=false;
				 }
			}
		}// fin del if  
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codprod  char(8) null default '--------'; ";
	
				  break;
					   
				case "POSTGRES":
					  $ls_sql= " ALTER TABLE siv_articulo ADD COLUMN codprod  char(8) null default '--------'; ";			  	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_57-04");
					 $lb_valido=false;
				 }
			}
		}// fin del if  
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql= " alter table siv_articulo
								   add constraint fk_siv_articulo__siv_producto foreign key 
								      (codemp, codseg, codfami, codclase, codprod)
									  references siv_producto (codemp, codseg, codfami, codclase, codprod)
									  on delete restrict on update restrict; ";	
				  break;
					   
				case "POSTGRES":
					  $ls_sql= " alter table siv_articulo
								   add constraint fk_siv_articulo__siv_producto foreign key 
								      (codemp, codseg, codfami, codclase, codprod)
									  references siv_producto (codemp, codseg, codfami, codclase, codprod)
									  on delete restrict on update restrict; ";			  	
				  break;				  
			}
			if (!empty($ls_sql))
			{	
				 $li_row=$this->io_sql->execute($ls_sql);
				 if($li_row===false)
				 { 
					 $this->io_msg->message("Problemas al ejecutar Release 2008_3_57-05");
					 $lb_valido=false;
				 }
			}
		}// fin del if  
	    return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_57 
//---------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_58()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_58
		//		   Access: public 
		//        Modulos: CFG
		//	  Description: 
		// Fecha Creacion: 09/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   /*$ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
		  	   $ls_sql= "  ALTER TABLE sigesp_ctrl_numero MODIFY COLUMN codusu char(30) ".
						          "              character SET utf8 COLLATE utf8_general_ci ";					
			 break;
			 
		   case "POSTGRES":
			   $ls_sql= "  ALTER TABLE sigesp_ctrl_numero ALTER COLUMN codusu TYPE char(30);";
														
			  break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_58");
				$lb_valido=false;
			}
		}*/		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_58
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_59()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_59
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 10/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
		  	   $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
			            "     ADD COLUMN codestpro1 char(25) NOT NULL DEFAULT '-------------------------'; ";					
			 break;
			 
		   case "POSTGRES":
			  $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
			            "     ADD COLUMN codestpro1 char(25) NOT NULL DEFAULT '-------------------------'; ";														
			  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
		   $li_row=$this->io_sql->execute($ls_sql);
		   if($li_row===false)
		   { 
			   $this->io_msg->message("Problemas con el  Release 2008_3_59-01");
			   $lb_valido=false;
		   }
	   }	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro2 char(25) NOT NULL DEFAULT '-------------------------'; ";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro2 char(25) NOT NULL DEFAULT '-------------------------'; ";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-02");
				   $lb_valido=false;
			   }
		   }		
	   }// fin del if ($lb_valido)	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro3 char(25) NOT NULL DEFAULT '-------------------------'; ";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro3 char(25) NOT NULL DEFAULT '-------------------------'; ";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-03");
				   $lb_valido=false;
			   }
		   }		
	   }// fin del if ($lb_valido)	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro4 char(25) NOT NULL DEFAULT '-------------------------'; ";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro4 char(25) NOT NULL DEFAULT '-------------------------'; ";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-04");
				   $lb_valido=false;
			   }
		   }		
	   }// fin del if ($lb_valido)
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro5 char(25) NOT NULL DEFAULT '-------------------------'; ";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_spi                                                     ".
							"     ADD COLUMN codestpro5 char(25) NOT NULL DEFAULT '-------------------------'; ";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-05");
				   $lb_valido=false;
			   }
		   }		
	   }// fin del if ($lb_valido)	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                         ".
							"     ADD COLUMN estcla char(1) NOT NULL DEFAULT '-'; ";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi                         ".
							"     ADD COLUMN estcla char(1) NOT NULL DEFAULT '-'; ";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-06");
				   $lb_valido=false;
			   }
		   }		
	   }// fin del if ($lb_valido)	
	   $ls_existe = $this->io_function_db->uf_select_constraint('scb_movbco_spi','pk_scb_movbco_spi');	
	   if ($ls_existe)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi DROP CONSTRAINT pk_scb_movbco_spi;";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi DROP CONSTRAINT pk_scb_movbco_spi;";														
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-07");
				   $lb_valido=false;
				   $lb_valido2=false;
			   }
			   else
			   {
			   		$lb_valido2=true;
			   }
		   }		
	   }// fin de if($ls_existe)
	   else
	   {
	   		$lb_valido2=false;
	   }
	   if ($lb_valido2)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_spi ".
				            "    ADD CONSTRAINT pk_scb_movbco_spi ".
							"    PRIMARY KEY (codemp, codban, ctaban, numdoc, ". 
							"                 codope, estmov, spi_cuenta, documento, ".
							"                 codestpro1, codestpro2, codestpro3,    ".
							"                 codestpro4, codestpro5, estcla);       ";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_spi ".
				            "    ADD CONSTRAINT pk_scb_movbco_spi ".
							"    PRIMARY KEY (codemp, codban, ctaban, numdoc, ". 
							"                 codope, estmov, spi_cuenta, documento, ".
							"                 codestpro1, codestpro2, codestpro3,    ".
							"                 codestpro4, codestpro5, estcla);       ";																
				  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
			   $li_row=$this->io_sql->execute($ls_sql);
			   if($li_row===false)
			   { 
				   $this->io_msg->message("Problemas con el  Release 2008_3_59-08");
				   $lb_valido=false;
			   }
		   }		
	   }// fin de if($lb_valido2)
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_59
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_60()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_60
		//		   Access: public 
		//        Modulos: SAF
		//	  Description: 
		// Fecha Creacion: 12/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
		  	   $ls_sql= "  ALTER TABLE saf_activo MODIFY COLUMN codconbie char(2) ".
					    "  character SET utf8 COLLATE utf8_general_ci ";					
			 break;
			 
		   case "POSTGRES":
			   $ls_sql= "  ALTER TABLE saf_activo ALTER COLUMN codconbie TYPE char(2);";
														
			  break;  				  
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_60-01");
				$lb_valido=false;
			}
		}	
		if ($lb_valido)
		{
			switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE saf_activo MODIFY COLUMN codrot char(2) ".
							"  character SET utf8 COLLATE utf8_general_ci ";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE saf_activo ALTER COLUMN codrot TYPE char(2);";
															
				  break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_60-02");
					$lb_valido=false;
				}
			}		
		}// fin del if($lb_valido)
		if ($lb_valido)
		{
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
				   $ls_sql= "  ALTER TABLE saf_rotulacion MODIFY COLUMN codrot char(2) ".
							"  character SET utf8 COLLATE utf8_general_ci ";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE saf_rotulacion ALTER COLUMN codrot TYPE char(2);";
															
				  break;  				  
			}
			if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_60-03");
					$lb_valido=false;
				}
			}		
		}// fin del if($lb_valido)
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_60
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_61()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_61
		//		   Access: public 
		//        Modulos: SOB
		//	  Description: 
		// Fecha Creacion: 12/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";		   
	   if ($lb_valido)
	   {
	   		switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN civinsact varchar(10);";					
					 break;
					 
				   case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN civinsact varchar(10);";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_61-01");
					$lb_valido=false;
				}
		   }	
	   }// fin del if
	   if ($lb_valido)
	   {
	   		switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN civresact varchar(10);";					
					 break;
					 
				   case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN civresact varchar(10);";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_61-02");
					$lb_valido=false;
				}
		   }	
	   }// fin del if	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN nomresact varchar(254);";					
					 break;
					 
				   case "POSTGRES":
					  $ls_sql= "  ALTER TABLE sob_acta ADD COLUMN nomresact varchar(254);";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_61-03");
					$lb_valido=false;
				}
		   }	
	   }// fin del if
	   if ($lb_valido)
	   {    
	        $ls_existe="";
	   		$ls_existe = $this->io_function_db->uf_select_constraint('sob_acta','rpc_supervisores__sob_acta_3');
			if ($ls_existe)
			{
				   switch($_SESSION["ls_gestor"])
				   {
						case "MYSQLT":
							   $ls_sql= " ALTER TABLE sob_acta DROP FOREIGN KEY rpc_supervisores__sob_acta_3;";					
							 break;
							 
						   case "POSTGRES":
							 $ls_sql= " ALTER TABLE sob_acta DROP CONSTRAINT rpc_supervisores__sob_acta_3;";																
							  break;  				  
				   }
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-04");
							$lb_valido=false;
						}
				   }	
			}// fin del if($ls_existe)
	   }// fin del if($lb_valido)
	   
	   if ($lb_valido)
	   {    
	        $ls_existe="";
	   		$ls_existe = $this->io_function_db->uf_select_constraint('sob_acta','rpc_supervisores__sob_acta_2');
			if ($ls_existe)
			{
				   switch($_SESSION["ls_gestor"])
				   {
						case "MYSQLT":
							   $ls_sql= " ALTER TABLE sob_acta DROP FOREIGN KEY rpc_supervisores__sob_acta_2;";					
							 break;
							 
						   case "POSTGRES":
							 $ls_sql= " ALTER TABLE sob_acta DROP CONSTRAINT rpc_supervisores__sob_acta_2;";																
							  break;  				  
				   }
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-05");
							$lb_valido=false;
						}
				   }	
			}// fin del if($ls_existe)
	   }// fin del if($lb_valido)	
	   
	   if ($lb_valido)
	   {    
	        $ls_existe="";
	   		$ls_existe = $this->io_function_db->uf_select_constraint('sob_acta','rpc_supervisores__sob_acta_1');
			if ($ls_existe)
			{
				   switch($_SESSION["ls_gestor"])
				   {
						case "MYSQLT":
							  $ls_sql= " ALTER TABLE sob_acta DROP FOREIGN KEY rpc_supervisores__sob_acta_1;";				
							 break;
							 
						   case "POSTGRES":
							 $ls_sql= " ALTER TABLE sob_acta DROP CONSTRAINT rpc_supervisores__sob_acta_1;";																
							  break;  				  
				   }
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-06");
							$lb_valido=false;
						}
				   }	
			}// fin del if($ls_existe)
	   }// fin del if($lb_valido)
	   if ($lb_valido)
	   {    $valor=0;
	   	    $ls_sql= " SELECT COUNT(*) AS valor FROM sob_unidad  WHERE coduni='---' AND codtun='---' ";
		    if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->select($ls_sql); 
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el select-01");
					$lb_valido=false;
				}
				else
				{
					if($row=$this->io_sql->fetch_row($li_row))
					{
						$valor=$row["valor"];
					}
				}
			}//fin del if
			if ($valor=0)
			{
				  $ls_sql= " INSERT INTO sob_unidad (codemp, coduni,codtun,nomuni) VALUES ('0001','---','---','Por Defecto');";
				  if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-07");
							$lb_valido=false;
						}
				   }	
			}		   
	   }// fin del if	
	   if ($lb_valido)
	   {    $valor=0;
	   	    $ls_sql= " SELECT COUNT(*) AS valor FROM sigesp_procedencias  
			            WHERE procede='SOBCON' 
						  AND codsis='SOB' 
						  AND opeproc='CON'";
		    if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->select($ls_sql); 
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el select-02");
					$lb_valido=false;
				}
				else
				{
					if($row=$this->io_sql->fetch_row($li_row))
					{
						$valor=$row["valor"];
					}
				}
			}//fin del if
			if ($valor=0)
			{
				  $ls_sql= "INSERT INTO sigesp_procedencias(procede,codsis,opeproc,desproc) 
									       VALUES ('SOBCON','SOB','CON','Contabilizar Contratos');";
				  if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-08");
							$lb_valido=false;
						}
				   }	
			}		   
	   }// fin del if
	   if ($lb_valido)
	   {    $valor=0;
	   	    $ls_sql= " SELECT COUNT(*) AS valor FROM sigesp_procedencias  
			            WHERE procede='SOBCON' 
						  AND codsis='SOB' 
						  AND opeproc='RPC'";
		    if (!empty($ls_sql))
			{	
				$li_row=$this->io_sql->select($ls_sql); 
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el select-02");
					$lb_valido=false;
				}
				else
				{
					if($row=$this->io_sql->fetch_row($li_row))
					{
						$valor=$row["valor"];
					}
				}
			}//fin del if
			if ($valor=0)
			{
				  $ls_sql= "INSERT INTO sigesp_procedencias(procede,codsis,opeproc,desproc)
									       VALUES ('SOBRPC','SOB','RPC','Contabilizar Contratos');";
				  if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_61-08");
							$lb_valido=false;
						}
				   }	
			}		   
	   }// fin del if																		
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_61
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_62()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_62
		//		   Access: public 
		//        Modulos: SOB
		//	  Description: 
		// Fecha Creacion: 12/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scb_movbco_anticipo ADD COLUMN sc_cuenta char(25);";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE scb_movbco_anticipo ADD COLUMN sc_cuenta char(25);";																
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_62-01");
				$lb_valido=false;
			}
	   }
	   $ls_existe = $this->io_function_db->uf_select_constraint('scb_movbco_anticipo','pk_mvobco_ant');
	   if (($lb_valido)&&($ls_existe))
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql= "ALTER TABLE scb_movbco_anticipo DROP PRIMARY KEY; ";				
					 break;
					 
				   case "POSTGRES":
					 $ls_sql= " ALTER TABLE scb_movbco_anticipo".
					           "  DROP CONSTRAINT pk_mvobco_ant;";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_62-02");
					$lb_valido=false;
				}
		   }	   
	   }
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql= " ALTER TABLE scb_movbco_anticipo
			                       ADD CONSTRAINT pk_mvobco_ant 
								   PRIMARY KEY (codemp, codban, ctaban, numdoc, codope, estmov, codamo, sc_cuenta)";				
					 break;
					 
				   case "POSTGRES":
					 $ls_sql= " ALTER TABLE scb_movbco_anticipo
			                       ADD CONSTRAINT pk_mvobco_ant 
								   PRIMARY KEY (codemp, codban, ctaban, numdoc, codope, estmov, codamo, sc_cuenta)";															
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_62-03");
					$lb_valido=false;
				}
		   }	   
	   }	   						   					
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_62
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_63()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_63
		//		   Access: public 
		//        Modulos: SOB
		//	  Description: 
		// Fecha Creacion: 12/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sob_tipounidad ADD COLUMN tipper char(1);";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE sob_tipounidad ADD COLUMN tipper char(1);";																
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_63");
				$lb_valido=false;
			}
	   }
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "   INSERT INTO sob_tipounidad (codtun, nomtun) VALUES ('---','Por Defecto');";					
					 break;
					 
				   case "POSTGRES":
					 $ls_sql= "   INSERT INTO sob_tipounidad (codtun, nomtun) VALUES ('---','Por Defecto');";															
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_63-02");
					$lb_valido=false;
				}
		   }	
	   }// fin del if
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_63()
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_64()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_64
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 15/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sigesp_deducciones ADD COLUMN retaposol int2 DEFAULT 0;";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE sigesp_deducciones ADD COLUMN retaposol int2 DEFAULT 0;";																
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_64");
				$lb_valido=false;
			}
	   }	   
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_64() ///-----------------------------------------------------------------------------------------------------------------------------------
 //----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_65()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_65
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 15/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  alter table  scb_movbco ".
                            "    add docant character(15) default '---------------';";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  alter table  scb_movbco ".
                            "    add docant character(15) default '---------------';";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_65-01");
				$lb_valido=false;
			}
	   }
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  alter table  scb_movbco ".
								"    add monamo double precision default 0.00; ";					
					 break;
					 
				   case "POSTGRES":
					    $ls_sql= "  alter table  scb_movbco ".
								"    add monamo double precision default 0.00; ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_65-02");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_65() 
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_66()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_66
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 17/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_fideicomiso ADD COLUMN fecconpreant date;";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE sno_fideicomiso ADD COLUMN fecconpreant date;";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_66-01");
				$lb_valido=false;
			}
	   }
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_fideicomiso ADD COLUMN conpreant char(1); ";					
					 break;
					 
				   case "POSTGRES":
					    $ls_sql= "  ALTER TABLE sno_fideicomiso ADD COLUMN conpreant char(1); ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_66-02");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_66() 
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_67()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_67
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 23/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   $lb_existe = $this->io_function_db->uf_select_column('sno_vacacpersonal','diapervac');
	   if (!$lb_existe)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_vacacpersonal ADD COLUMN diapervac smallint DEFAULT 0;";					
					 break;
					 
				 case "POSTGRES":
					   $ls_sql= "  ALTER TABLE sno_vacacpersonal ADD COLUMN diapervac smallint DEFAULT 0;";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_67-01");
					$lb_valido=false;
				}
		   }
	   }//fin del existe
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_hvacacpersonal ADD COLUMN diapervac smallint DEFAULT 0; ";					
					 break;
					 
				   case "POSTGRES":
					    $ls_sql= "  ALTER TABLE sno_hvacacpersonal ADD COLUMN diapervac smallint DEFAULT 0; ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_67-02");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_thvacacpersonal ADD COLUMN diapervac smallint DEFAULT 0; ";					
					 break;
					 
				   case "POSTGRES":
					    $ls_sql= "  ALTER TABLE sno_thvacacpersonal ADD COLUMN diapervac smallint DEFAULT 0; ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_67-03");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_67() 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_68()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_68
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 23/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sigesp_empresa ADD COLUMN confiva varchar(1) DEFAULT 'P';";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= " ALTER TABLE sigesp_empresa ADD COLUMN confiva varchar(1) DEFAULT 'P';";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_68-01");
				$lb_valido=false;
			}
	   }	  
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_68() 
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_69()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_69
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 24/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE sno_vacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0;";					
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  ALTER TABLE sno_vacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0;";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_69-01");
				$lb_valido=false;
			}
	   }
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_hvacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0;";					
					 break;
					 
				   case "POSTGRES":
					   $ls_sql= "  ALTER TABLE sno_hvacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0;";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_69-02");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	   if ($lb_valido)
	   {
		   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_thvacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0; ";					
					 break;
					 
				   case "POSTGRES":
					    $ls_sql= "  ALTER TABLE sno_thvacacpersonal ADD COLUMN pagpersal char(1) DEFAULT 0;";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_69-03");
					$lb_valido=false;
				}
		   }
	   } //fin del if 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_69() 
 //--------------------------------------------------------------------------------------------------------------------------------------
 //-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_70()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_70
		//		   Access: public 
		//        Modulos: SCV
		//	  Description: 
		// Fecha Creacion: 29/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  ALTER TABLE scv_dt_personal ADD COLUMN codnom char(4);";					
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  ALTER TABLE scv_dt_personal ADD COLUMN codnom char(4);";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_70-01");
				$lb_valido=false;
			}
	   }
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  UPDATE scv_dt_personal ".
					            "     SET codnom = ( SELECT min(codnom) ".
								"                      FROM sno_personalnomina ".
								"                     WHERE codper = scv_dt_personal.codper".
								"                     AND staper = 1 )";					
					 
				   case "POSTGRES":
					   $ls_sql= "  UPDATE scv_dt_personal ".
					            "     SET codnom = ( SELECT min(codnom) ".
								"                      FROM sno_personalnomina ".
								"                     WHERE codper = scv_dt_personal.codper ".
								"                     AND staper = 1 )";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_70-02");
					$lb_valido=false;
				}
		   }	  	   
	   }// fin de valido	  
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_70()
 //------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_71()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_71
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 30/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				  $ls_sql=  "  INSERT INTO spg_ep1(codemp, codestpro1, estcla, denestpro1, estint, sc_cuenta)    ".
                            "  VALUES ('0001','-------------------------','-','',0,'');                          ";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}	  	
                   $ls_sql= "  INSERT INTO spg_ep2(codemp, codestpro1, estcla, codestpro2, denestpro2)           ".
                            "  VALUES ('0001','-------------------------','-', '-------------------------', ''); ";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}	 
                   $ls_sql="  INSERT INTO spg_ep3(codemp, codestpro1, estcla, codestpro2, codestpro3, denestpro3, codfuefin)".
                            "  VALUES ('0001','-------------------------','-', '-------------------------',      ".
							"         '-------------------------','', '--');                                     ";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}	
                  $ls_sql=  "  INSERT INTO spg_ep4(codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, denestpro4)".
                            "  VALUES ('0001','-------------------------','-', '-------------------------',  ".
							"         '-------------------------','-------------------------','');           ";
				  if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}	
                $ls_sql=    "  INSERT INTO spg_ep5( codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, ".
							"                      codestpro5, denestpro5, codfuefin)                               ".
                            "   VALUES ('0001','-------------------------','-', '-------------------------',        ".
							"          '-------------------------','-------------------------',                     ".
							"          '-------------------------', '', '--');                                      ";
					if (!empty($ls_sql))
					{	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}	
                $ls_sql=    "   INSERT INTO spi_cuentas_estructuras(codemp, spi_cuenta, codestpro1, codestpro2,     ".
							"                                       codestpro3, codestpro4, codestpro5, estcla, previsto) ".   
                            "   SELECT codemp, spi_cuenta, '-------------------------','-------------------------', ".
							"   '-------------------------','-------------------------','-------------------------', ".
							"   '-',0 FROM spi_cuentas;";	
					if (!empty($ls_sql))
					{	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
							$lb_valido=false;
						}
					}							
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  INSERT INTO spg_ep1(codemp, codestpro1, estcla, denestpro1, estint, sc_cuenta)    ".
                            "  VALUES ('0001','-------------------------','-','',0,'');                          ".
                            "  INSERT INTO spg_ep2(codemp, codestpro1, estcla, codestpro2, denestpro2)           ".
                            "  VALUES ('0001','-------------------------','-', '-------------------------', ''); ".
                            "  INSERT INTO spg_ep3(codemp, codestpro1, estcla, codestpro2, codestpro3, denestpro3, codfuefin)".
                            "  VALUES ('0001','-------------------------','-', '-------------------------',      ".
							"         '-------------------------','', '--');                                     ".
                            "  INSERT INTO spg_ep4(codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, denestpro4)".
                            "  VALUES ('0001','-------------------------','-', '-------------------------',  ".
							"         '-------------------------','-------------------------','');           ".
                            "  INSERT INTO spg_ep5( codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, ".
							"                      codestpro5, denestpro5, codfuefin)                               ".
                            "   VALUES ('0001','-------------------------','-', '-------------------------',        ".
							"          '-------------------------','-------------------------',                     ".
							"          '-------------------------', '', '--');                                      ".
                            "   INSERT INTO spi_cuentas_estructuras(codemp, spi_cuenta, codestpro1, codestpro2,     ".
							"                                       codestpro3, codestpro4, codestpro5, estcla, previsto) ".   
                            "   SELECT codemp, spi_cuenta, '-------------------------','-------------------------', ".
							"   '-------------------------','-------------------------','-------------------------', ".
							"   '-',0 FROM spi_cuentas;";	
					   if (!empty($ls_sql))
					   {	
							$li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								$this->io_msg->message("Problemas con el  Release 2008_3_71-01");
								$lb_valido=false;
							}
						}	  																		
				  break; 
			      				  
	   }
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_dt_spi ".
								"	  ADD  codestpro1 char(25) not null default '-------------------------', ".
								"	  ADD  codestpro2 char(25) not null default '-------------------------', ".
								"     ADD  codestpro3 char(25) not null default '-------------------------', ".
								"     ADD  codestpro4 char(25) not null default '-------------------------', ".
								"  	  ADD  codestpro5 char(25) not null default '-------------------------', ".
								"  	  ADD  estcla     varchar(1)           not null default '-';             ";					
					 
				   case "POSTGRES":
					   $ls_sql= "  ALTER TABLE sno_dt_spi ".
								"	  ADD  codestpro1 char(25) not null default '-------------------------', ".
								"	  ADD  codestpro2 char(25) not null default '-------------------------', ".
								"     ADD  codestpro3 char(25) not null default '-------------------------', ".
								"     ADD  codestpro4 char(25) not null default '-------------------------', ".
								"  	  ADD  codestpro5 char(25) not null default '-------------------------', ".
								"  	  ADD  estcla     varchar(1)           not null default '-';             ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_70-02");
					$lb_valido=false;
				}
		   }	  	   
	   }// fin de valido 
	   
	   $ls_existe = $this->io_function_db->uf_select_constraint('sno_dt_spi','pk_sno_dt_spi');
	   if (($lb_valido)&&($ls_existe))
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql= "ALTER TABLE sno_dt_spi DROP PRIMARY KEY; ";				
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " ALTER TABLE sno_dt_spi           ".
					           "  DROP CONSTRAINT pk_sno_dt_spi;  ";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_71-03");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  "  ALTER TABLE sno_dt_spi ADD CONSTRAINT pk_sno_dt_spi ".
                               "  PRIMARY KEY (codemp, codnom, codperi, codcom, tipnom, spi_cuenta, operacion, codconc, ".
                               "              codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla);  ";			
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  "  ALTER TABLE sno_dt_spi ADD CONSTRAINT pk_sno_dt_spi ".
                               "  PRIMARY KEY (codemp, codnom, codperi, codcom, tipnom, spi_cuenta, operacion, codconc, ".
                               "              codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla);  ";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_71-04- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql=  "  ALTER TABLE sno_dt_spi ADD CONSTRAINT fk_sno_dt_spi_cuentas_estructuras ".
					           "  FOREIGN KEY (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3,    ".
							   "               codestpro4, codestpro5, estcla)                            ".
                               "   REFERENCES spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1,    ".
							   "              codestpro2, codestpro3, codestpro4, codestpro5, estcla)     ".
							   "   MATCH SIMPLE    ON UPDATE RESTRICT ON DELETE RESTRICT;                 ";					
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  "  ALTER TABLE sno_dt_spi ADD CONSTRAINT fk_sno_dt_spi_cuentas_estructuras ".
					           "  FOREIGN KEY (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3,    ".
							   "               codestpro4, codestpro5, estcla)                            ".
                               "   REFERENCES spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1,    ".
							   "              codestpro2, codestpro3, codestpro4, codestpro5, estcla)     ".
							   "   MATCH SIMPLE    ON UPDATE RESTRICT ON DELETE RESTRICT;                 ";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_71-05");
					$lb_valido=false;
				}
		   }	   
	   } 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_71()
////---------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_72()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_72
		//		   Access: public 
		//        Modulos: MIS
		//	  Description: 
		// Fecha Creacion: 31/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "   alter table spi_dt_cmp
								 add codestpro1 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-1");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dt_cmp
								 add codestpro2 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-2");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dt_cmp
								 add codestpro3 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-3");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dt_cmp
								 add codestpro4 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-4");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dt_cmp
								 add codestpro5 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-5");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dt_cmp
								add estcla     varchar(1) not null default '-';	";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72-00-6");
							$lb_valido=false;
						}
				   }				  		  					
			break;
				 
		    case "POSTGRES":
				   $ls_sql= "   alter table spi_dt_cmp
								add codestpro1 char(25)   not null default '-------------------------',
								add codestpro2 char(25)   not null default '-------------------------',
								add codestpro3 char(25)   not null default '-------------------------',
								add codestpro4 char(25)   not null default '-------------------------',
								add codestpro5 char(25)   not null default '-------------------------',
								add estcla     varchar(1) not null default '-';	";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_72");
							$lb_valido=false;
						}
				   }	  																		
			 break;  				  
	   }
	    $ls_existe = $this->io_function_db->uf_select_constraint('spi_dt_cmp','pk_spi_dt_cmp');
	   if (($lb_valido)&&($ls_existe))
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql= "ALTER TABLE spi_dt_cmp DROP PRIMARY KEY; ";				
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dt_cmp drop constraint pk_spi_dt_cmp; ";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-01");
					$lb_valido=false;
				}
		   }	   
	    } 
		
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dt_cmp ".
							   "  add constraint pk_spi_dt_cmp primary key ".
							   "  (procede, codemp, spi_cuenta, comprobante, procede_doc, documento, ".
							   "  fecha, codban, ctaban, operacion, codestpro1, codestpro2, codestpro3, ".
							   "   codestpro4, codestpro5, estcla); ";			
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dt_cmp ".
							   "  add constraint pk_spi_dt_cmp primary key ".
							   "  (procede, codemp, spi_cuenta, comprobante, procede_doc, documento, ".
							   "  fecha, codban, ctaban, operacion, codestpro1, codestpro2, codestpro3, ".
							   "   codestpro4, codestpro5, estcla); ";																	
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-03- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_cuentas_estructuras__spi_dt_cmp foreign key ".
							   "   (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla)".
                               "   references spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3,".
							   "   codestpro4, codestpro5, estcla)".
                               "   on delete restrict on update restrict;";			
					 break;
					 
				   case "POSTGRES":
					  $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_cuentas_estructuras__spi_dt_cmp foreign key ".
							   "   (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla)".
                               "   references spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3,".
							   "   codestpro4, codestpro5, estcla)".
                               "   on delete restrict on update restrict;";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-04- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dt_cmp ".
                               "   add constraint fk_spi_dt_cmp__sigesp_cmp foreign key (codemp, procede, comprobante, ".
							   "   fecha, codban, ctaban) ".
                               "   references sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban)".
                               "   on delete restrict on update restrict; ";			
					 break;
					 
				   case "POSTGRES":
					  $ls_sql=  " alter table spi_dt_cmp ".
                               "   add constraint fk_spi_dt_cmp__sigesp_cmp foreign key (codemp, procede, comprobante, ".
							   "   fecha, codban, ctaban) ".
                               "   references sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban)".
                               "   on delete restrict on update restrict; ";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-05- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   }
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_dt_cmp__spi_cuentas foreign key (codemp, spi_cuenta) ".
   							   "   references spi_cuentas (codemp, spi_cuenta) ".
                               "   on delete restrict on update restrict;";			
					 break;
					 
				   case "POSTGRES":
					  $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_dt_cmp__spi_cuentas foreign key (codemp, spi_cuenta) ".
   							   "   references spi_cuentas (codemp, spi_cuenta) ".
                               "   on delete restrict on update restrict;";																			
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-06- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   }
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_dt_cmp__spi_operaciones foreign key (operacion) ".
                               "   references spi_operaciones (operacion) ".
                               "   on delete restrict on update restrict;";			
					 break;
					 
				   case "POSTGRES":
					  $ls_sql=  " alter table spi_dt_cmp ".
   							   "   add constraint fk_spi_dt_cmp__spi_operaciones foreign key (operacion) ".
                               "   references spi_operaciones (operacion) ".
                               "   on delete restrict on update restrict;";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-08- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   }
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_72()
//-----------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_73()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_73
		//		   Access: public 
		//        Modulos: MIS
		//	  Description: 
		// Fecha Creacion: 31/10/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "   alter table spi_dtmp_cmp
								 add codestpro1 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-1");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dtmp_cmp
								 add codestpro2 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-2");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dtmp_cmp
								 add codestpro3 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-3");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dtmp_cmp
								 add codestpro4 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-4");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dtmp_cmp
								 add codestpro5 char(25)   not null default '-------------------------';";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-5");
							$lb_valido=false;
						}
				   }
				   $ls_sql= "   alter table spi_dtmp_cmp
								add estcla     varchar(1) not null default '-';	";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73-00-6");
							$lb_valido=false;
						}
				   }				  		  					
			break;
				 
		    case "POSTGRES":
				   $ls_sql= "   alter table spi_dtmp_cmp
								add codestpro1 char(25)   not null default '-------------------------',
								add codestpro2 char(25)   not null default '-------------------------',
								add codestpro3 char(25)   not null default '-------------------------',
								add codestpro4 char(25)   not null default '-------------------------',
								add codestpro5 char(25)   not null default '-------------------------',
								add estcla     varchar(1) not null default '-';	";
				   if (!empty($ls_sql))
				   {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas con el  Release 2008_3_73");
							$lb_valido=false;
						}
				   }	  																		
			 break;  				  
	   }
	    $ls_existe = $this->io_function_db->uf_select_constraint('spi_dtmp_cmp','pk_spi_dtmp_cmp');
	   if (($lb_valido)&&($ls_existe))
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					  $ls_sql= "ALTER TABLE spi_dtmp_cmp DROP PRIMARY KEY; ";				
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dtmp_cmp drop constraint pk_spi_dtmp_cmp; ";																
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_73-01");
					$lb_valido=false;
				}
		   }	   
	    } 	
			
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add  constraint pk_spi_dtmp_cmp primary key (procede, codemp, spi_cuenta,".
							   "   comprobante, codestpro1, codestpro2, ".
                               "   codestpro3, codestpro4, codestpro5, estcla, procede_doc, documento, fecha, operacion);";			
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add  constraint pk_spi_dtmp_cmp primary key (procede, codemp, spi_cuenta,".
							   "   comprobante, codestpro1, codestpro2, ".
                               "   codestpro3, codestpro4, codestpro5, estcla, procede_doc, documento, fecha, operacion);";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-03- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add constraint fk_spi_cuentas_estructuras__spi_dtmp_cmp foreign key (codemp, spi_cuenta, ".
							   "   codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla) ".
                               "   references spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3, ".                               "   codestpro4, codestpro5, estcla) ".
                               "   on delete restrict on update restrict;";			
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add constraint fk_spi_cuentas_estructuras__spi_dtmp_cmp foreign key (codemp, spi_cuenta, ".
							   "   codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla) ".
                               "   references spi_cuentas_estructuras (codemp, spi_cuenta, codestpro1, codestpro2, codestpro3, ".                               "   codestpro4, codestpro5, estcla) ".
                               "   on delete restrict on update restrict;";																			
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-04- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add constraint fk_spi_dtmp_cmp__sigesp_cmp_md foreign key ".
							   "       (codemp, procede, comprobante, fecha) ".
                               "       references sigesp_cmp_md (codemp, procede, comprobante, fecha) ".
                               "       on delete restrict on update restrict;";			
					 break;
					 
				   case "POSTGRES":
					 $ls_sql=  " alter table spi_dtmp_cmp ".
                               "   add constraint fk_spi_dtmp_cmp__sigesp_cmp_md foreign key ".
							   "       (codemp, procede, comprobante, fecha) ".
                               "       references sigesp_cmp_md (codemp, procede, comprobante, fecha) ".
                               "       on delete restrict on update restrict;";																					
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_72-05- ADD CONSTRAINT ");
					$lb_valido=false;
				}
		   }	   
	   } 
	   
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_73()
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_74()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_74
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 04/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  CREATE TABLE sno_codigounicorac ( ".
							"  codemp  char(4)  not null,        ".							
							"  codnom  char(4)  not null,        ".							
							"  codasicar  char(7) not null,      ".							
							"  codunirac  varchar(10) not null,  ".
							"  estcodunirac char(1) null default '0', ".							
							"  constraint pk_sno_codigounicorac  ".
							"  primary key (codunirac, codemp, codnom, codasicar)) ".
							"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";						
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= "  CREATE TABLE sno_codigounicorac ( ".
							"  codemp  char(4)  not null,        ".							
							"  codnom  char(4)  not null,        ".							
							"  codasicar  char(7) not null,      ".							
							"  codunirac  varchar(10) not null,  ".
							"  estcodunirac char(1) null default '0', ".							
							"  constraint pk_sno_codigounicorac  ".
							"  primary key (codunirac, codemp, codnom, codasicar));";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_74-01");
				$lb_valido=false;
			}
	   }
	   	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= " ALTER TABLE sno_codigounicorac ".
   								"   ADD constraint fk_sno_codigounicorac__sno_asignacioncargo  ".
								"   foreign key (codemp, codnom, codasicar)                    ".
                                "   references sno_asignacioncargo (codemp, codnom, codasicar) ".
                                "   on delete restrict on update restrict;                     ";					
					 break;
					 
				   case "POSTGRES":
					   $ls_sql= " ALTER TABLE sno_codigounicorac ".
   								"   ADD constraint fk_sno_codigounicorac__sno_asignacioncargo  ".
								"   foreign key (codemp, codnom, codasicar)                    ".
                                "   references sno_asignacioncargo (codemp, codnom, codasicar) ".
                                "   on delete restrict on update restrict;                     ";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_74-02 CONSTRAINT");
					$lb_valido=false;
				}
		   }   
	   }// FIN DEL VALIDO
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_74()
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_75()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_75
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 04/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				   $ls_sql= "  CREATE TABLE sno_hcodigounicorac (         ".
							"   codemp               char(4)   not null,  ".
							"   codnom               char(4)   not null,  ".
							"   anocur               char(4)   not null,  ".
							"   codperi              char(3)   not null,  ".
							"   codasicar            char(7)   not null,  ".
							"   codunirac            varchar(10) not null, ".
							"   estcodunirac         char(1)     null default '0', ".
							"   constraint pk_sno_hcodigounicorac primary  ".
							"   key (codemp, codnom, anocur, codperi, codasicar, codunirac))".
							"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";						
				 break;
				 
			   case "POSTGRES":
				   $ls_sql= " CREATE TABLE sno_hcodigounicorac (          ".
							"   codemp               char(4)   not null,  ".
							"   codnom               char(4)   not null,  ".
							"   anocur               char(4)   not null,  ".
							"   codperi              char(3)   not null,  ".
							"   codasicar            char(7)   not null,  ".
							"   codunirac            varchar(10) not null, ".
							"   estcodunirac         char(1)     null default '0', ".
							"   constraint pk_sno_hcodigounicorac primary  ".
							"   key (codemp, codnom, anocur, codperi, codasicar, codunirac)); ";																		
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_75-01");
				$lb_valido=false;
			}
	   }
	   	
	   if ($lb_valido)
	   {
	   	   switch($_SESSION["ls_gestor"])
		   {
				case "MYSQLT":
					   $ls_sql= "  ALTER TABLE sno_hcodigounicorac ".
                                "  ADD constraint fk_sno_hcodigounicorac__sno_hasignacioncargo ".
								"  foreign key (codemp, codnom, anocur, codperi, codasicar) ".
                                "  references sno_hasignacioncargo (codemp, codnom, anocur, codperi, codasicar) ".
                                "  on delete restrict on update restrict;";							
					 break;
					 
				   case "POSTGRES":
					   $ls_sql= "  ALTER TABLE sno_hcodigounicorac ".
                                "  ADD constraint fk_sno_hcodigounicorac__sno_hasignacioncargo ".
								"  foreign key (codemp, codnom, anocur, codperi, codasicar) ".
                                "  references sno_hasignacioncargo (codemp, codnom, anocur, codperi, codasicar) ".
                                "  on delete restrict on update restrict;";																		
					  break;  				  
		   }
		   if (!empty($ls_sql))
		   {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas con el  Release 2008_3_75-02 - CONSTRAINT");
					$lb_valido=false;
				}
		   }   
	   }// FIN DEL VALIDO
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_75()
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
   function uf_create_release_db_libre_V_2008_3_76()
   {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_76
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 04/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";	
	   switch($_SESSION["ls_gestor"])
	   {
	   		case "MYSQLT":
				  $ls_sql= "  CREATE TABLE sno_thcodigounicorac ( ".
						   "  codemp               char(4)              not null, ".
						   "  codnom               char(4)              not null, ".
						   "  anocur               char(4)              not null, ".
						   "  codperi              char(3)              not null, ".
						   "  codasicar            char(7)              not null, ".
						   "  codunirac            varchar(10)          not null, ".
						   "  estcodunirac         char(1)              null default '0',  ".
						   "  constraint pk_sno_thcodigounicorac primary                   ".
						   "  key (codemp, codnom, anocur, codperi, codasicar, codunirac)) ".
						   "  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;   ";						
				 break;
				 
			   case "POSTGRES":
				  $ls_sql= "  CREATE TABLE sno_thcodigounicorac ( ".
						   "  codemp               char(4)              not null, ".
						   "  codnom               char(4)              not null, ".
						   "  anocur               char(4)              not null, ".
						   "  codperi              char(3)              not null, ".
						   "  codasicar            char(7)              not null, ".
						   "  codunirac            varchar(10)          not null, ".
						   "  estcodunirac         char(1)              null default '0', ".
						   "  constraint pk_sno_thcodigounicorac primary ".
						   "  key (codemp, codnom, anocur, codperi, codasicar, codunirac));";																			
				  break;  				  
	   }
	   if (!empty($ls_sql))
	   {	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas con el  Release 2008_3_76");
				$lb_valido=false;
			}
	   }	 
	  return $lb_valido;	
   }//FIN DE uf_create_release_db_libre_V_2008_3_76()
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
	function uf_create_release_db_libre_V_2008_3_77()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_77
		//		   Access: public 
		//        Modulos: SNO
		//	  Description: 
		// Fecha Creacion: 04/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   ALTER TABLE sno_asignacioncargo ALTER claasicar TYPE varchar(10);  ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   ALTER TABLE sno_asignacioncargo                       ".
				         "   MODIFY COLUMN claasicar VARCHAR(10)                   ".
						 "   CHARACTER SET utf8 COLLATE utf8_general_ci NOT    NULL ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_77-01");
					$lb_valido=false;
				}
	  }	
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="   ALTER TABLE sno_hasignacioncargo ALTER claasicar TYPE varchar(10);  ";	
				  break;
					   
				case "MYSQLT":
					 $ls_sql="   ALTER TABLE sno_hasignacioncargo                       ".
							 "   MODIFY COLUMN claasicar VARCHAR(10)                   ".
							 "   CHARACTER SET utf8 COLLATE utf8_general_ci NOT    NULL ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_77-02");
						$lb_valido=false;
					}
		  }	    
	  }    
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="   ALTER TABLE sno_thasignacioncargo ALTER claasicar TYPE varchar(10);  ";	
				  break;
					   
				case "MYSQLT":
					 $ls_sql="   ALTER TABLE sno_thasignacioncargo                       ".
							 "   MODIFY COLUMN claasicar VARCHAR(10)                   ".
							 "   CHARACTER SET utf8 COLLATE utf8_general_ci NOT    NULL ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas uf_cambiar_tamaño_tipo_data Release 2008_3_77-03");
						$lb_valido=false;
					}
		  }	    
	  }    
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_77 
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_78()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_78
		//		   Access: public 
		//        Modulos: 
		//	  Description: 
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="   create table spg_variacion ( ".
						 "   codemp       char(4)  not null, ".
						 "   procede      char(6)  not null, ".
						 "   comprobante  char(15) not null, ".
						 "   fecha        date     not null default '1900-01-01', ".
						 "   codban       char(3)  not null default '---',        ".
						 "   ctaban       char(25) not null default '-------------------------', ".
						 "   spg_cuenta   char(25) not null, ".
						 "   procede_doc  char(6)  not null, ".
						 "   documento    char(15) not null, ".
						 "   monto        float8   not null default '0', ".
						 "   constraint pk_spg_dt_cmp1 primary key (codemp, comprobante, procede_doc, ".
						 "   documento, spg_cuenta, fecha, codban, ctaban, procede)) ".
						 "   without oids; ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="   create table spg_variacion ( ".
						 "   codemp       char(4)  not null, ".
						 "   procede      char(6)  not null, ".
						 "   comprobante  char(15) not null, ".
						 "   fecha        date     not null default '1900-01-01', ".
						 "   codban       char(3)  not null default '---',        ".
						 "   ctaban       char(25) not null default '-------------------------', ".
						 "   spg_cuenta   char(25) not null, ".
						 "   procede_doc  char(6)  not null, ".
						 "   documento    char(15) not null, ".
						 "   monto        float8   not null default '0', ".
						 "   constraint pk_spg_dt_cmp1 primary key (codemp, comprobante, procede_doc, ".
						 "   documento, spg_cuenta, fecha, codban, ctaban, procede)) ".
						 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_78-01");
					$lb_valido=false;
				}
	  }	
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table spg_variacion ".
   							 "   add constraint fk_spg_variacion__sigesp_cmp foreign key  ".
							 "   (codemp, procede, comprobante, fecha, codban, ctaban)    ".
							 "   references sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban) ".
							 "   on delete restrict on update restrict; ";	
				  break;
					   
				case "MYSQLT":
					$ls_sql=" alter table spg_variacion ".
   							 "   add constraint fk_spg_variacion__sigesp_cmp foreign key  ".
							 "   (codemp, procede, comprobante, fecha, codban, ctaban)    ".
							 "   references sigesp_cmp (codemp, procede, comprobante, fecha, codban, ctaban) ".
							 "   on delete restrict on update restrict; ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas  Release 2008_3_78-02 -CONSTRAINT");
						$lb_valido=false;
					}
		  }		  
	  }// FIN DEL IF	  
	  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_78 
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_79()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_79
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="  create table scg_confvariacion ( ".
						 "  codemp               char(4)       not null, ".
						 "  sc_cuenta            char(25)      not null, ".
						 "  operacion            char(1)       not null, ".
						 "  spg_cuenta           char(25)      not null, ".
						 "  constraint pk_scg_confvariacion primary key (codemp, sc_cuenta, operacion));";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="  create table scg_confvariacion ( ".
						 "  codemp               char(4)       not null, ".
						 "  sc_cuenta            char(25)      not null, ".
						 "  operacion            char(1)       not null, ".
						 "  spg_cuenta           char(25)      not null, ".
						 "  constraint pk_scg_confvariacion primary key (codemp, sc_cuenta, operacion)) ".
						 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_79-01");
					$lb_valido=false;
				}
	  }	
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table scg_confvariacion ".
							 "  add constraint fk_scg_confvariacion__scg_cuentas foreign key (codemp, sc_cuenta) ".
							 "	  references scg_cuentas (codemp, sc_cuenta) ".
							 "	  on delete restrict on update restrict;     ";	
				  break;
					   
				case "MYSQLT":
					 $ls_sql=" alter table scg_confvariacion ".
							 "  add constraint fk_scg_confvariacion__scg_cuentas foreign key (codemp, sc_cuenta) ".
							 "	  references scg_cuentas (codemp, sc_cuenta) ".
							 "	  on delete restrict on update restrict;     ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_79-02-CONSTRAINT");
						$lb_valido=false;
					}
		  }		  
	  }// FIN DEL IF	  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_79 
///-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_80()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_80
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="  create table spg_dt_fuentefinanciamiento ( ".
						 "  codemp               char(4)              not null, ".
						 "  codfuefin            char(2)              not null, ".
						 "  codestpro1           char(25)             not null, ".  
						 "  codestpro2           char(25)             not null, ".
						 "  codestpro3           char(25)             not null, ".
						 "  codestpro4           char(25)             not null, ".
						 "  codestpro5           char(25)             not null, ".  
						 "  estcla               varchar(1)           not null, ".
						 "  constraint pk_spg_dt_fuentefinanciami primary key   ".
						 " (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5,codfuefin));	";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="  create table spg_dt_fuentefinanciamiento ( ".
						 "  codemp               char(4)              not null, ".
						 "  codfuefin            char(2)              not null, ".
						 "  codestpro1           char(25)             not null, ".  
						 "  codestpro2           char(25)             not null, ".
						 "  codestpro3           char(25)             not null, ".
						 "  codestpro4           char(25)             not null, ".
						 "  codestpro5           char(25)             not null, ".  
						 "  estcla               varchar(1)           not null, ".
						 "  constraint pk_spg_dt_fuentefinanciami primary key   ".
						 " (codemp, codestpro1, estcla, codestpro2, codestpro3, codestpro4, codestpro5,codfuefin))".
						 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_80");
					$lb_valido=false;
				}
	  }		  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_80 
///-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_81()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_81
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" create table spg_cuenta_fuentefinanciamiento (  ".
						 "  codemp               char(4)              not null,   ".
						 "  codfuefin            char(2)              not null,   ".
						 "  codestpro1           char(25)             not null,   ".
						 "  codestpro2           char(25)             not null,   ".
						 "  codestpro3           char(25)             not null,   ".
						 "  codestpro4           char(25)             not null,   ".
						 "  codestpro5           char(25)             not null,   ".
						 "  estcla               varchar(1)           not null,   ".
						 "  spg_cuenta           char(25)             not null,   ".
						 "  monto                float8               not null default '0', ".
						 "  constraint pk_spg_cuenta_fuentefinanciami primary  ".
						 "  key (codemp, codestpro1, estcla, codestpro2, codestpro3, ".
						 "  codestpro4, codestpro5, spg_cuenta, codfuefin)); 	";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="  create table spg_cuenta_fuentefinanciamiento (  ".
						 "  codemp               char(4)              not null,   ".
						 "  codfuefin            char(2)              not null,   ".
						 "  codestpro1           char(25)             not null,   ".
						 "  codestpro2           char(25)             not null,   ".
						 "  codestpro3           char(25)             not null,   ".
						 "  codestpro4           char(25)             not null,   ".
						 "  codestpro5           char(25)             not null,   ".
						 "  estcla               varchar(1)           not null,   ".
						 "  spg_cuenta           char(25)             not null,   ".
						 "  monto                float8               not null default '0', ".
						 "  constraint pk_spg_cuenta_fuentefinanciami primary  ".
						 "  key (codemp, codestpro1, estcla, codestpro2, codestpro3, ".
						 "  codestpro4, codestpro5, spg_cuenta, codfuefin)) ".
						 "   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";				   								
				break;
				
				case "oci8po":
				$ls_sql="CREATE TABLE spg_cuenta_fuentefinan ( ".
						 "  codemp               char(4)              NOT NULL,   ".
						 "  codfuefin            char(2)              NOT NULL,   ".
						 "  codestpro1           char(25)             NOT NULL,   ".
						 "  codestpro2           char(25)             NOT NULL,   ".
						 "  codestpro3           char(25)             NOT NULL,   ".
						 "  codestpro4           char(25)             NOT NULL,   ".
						 "  codestpro5           char(25)             NOT NULL,   ".
						 "  estcla               varchar(1)           NOT NULL,   ".
						 "  spg_cuenta           char(25)             NOT NULL,   ".
						 "  monto                float8               NOT NULL DEFAULT '0', ".
						 "  constraint pk_spg_cuenta_fuentefinanciami PRIMARY  ".
						 "  KEY (codemp, codestpro1, estcla, codestpro2, codestpro3, ".
						 "  codestpro4, codestpro5, spg_cuenta, codfuefin)) 	";	
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_81");
					$lb_valido=false;
				}
	  }		  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_81 
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_82()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_82
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" ALTER TABLE scv_solicitudviatico ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--';";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql=" ALTER TABLE scv_solicitudviatico ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--'; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_82");
					$lb_valido=false;
				}
	  }		  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_82
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_83()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_83
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 05/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" ALTER TABLE scv_dt_spg ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--'; ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql=" ALTER TABLE scv_dt_spg ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--'; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_83");
					$lb_valido=false;
				}
	  }		  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_83
//-------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_2008_3_84()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_84
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 10/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql="  create table scb_casamientoconcepto ( ".
                         "  codconmov  char(3)  not null,         ".
                         "  codban     char(3)  not null,         ".
   						 "  ctaban     char(25) not null,         ".
                         "  constraint pk_scb_casamientoconcepto primary key (codconmov, codban, ctaban) ); ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql="  create table scb_casamientoconcepto ( ".
                         "  codconmov  char(3)  not null,         ".
                         "  codban     char(3)  not null,         ".
   						 "  ctaban     char(25) not null,         ".
                         "  constraint pk_scb_casamientoconcepto primary key (codconmov, codban, ctaban) ) ".
						 "  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_84-01");
					$lb_valido=false;
				}
	  }	
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="  alter table scb_casamientoconcepto ".
                             "  add constraint fk_scb_casamientoconcepto__scb_concepto foreign key (codconmov) ".
                             "  references scb_concepto (codconmov) on delete restrict on update restrict;     ";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="  alter table scb_casamientoconcepto ".
                             "  add constraint fk_scb_casamientoconcepto__scb_concepto foreign key (codconmov) ".
                             "  references scb_concepto (codconmov) on delete restrict on update restrict;     ";			   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_84-02 CONSTRAINT");
						$lb_valido=false;
					}
		  }		  
	  }// fin de valido  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_84
///-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_85()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_85
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 10/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN casconmov int2 DEFAULT 0; ";	
			  break;
				   
			case "MYSQLT":
			     $ls_sql=" ALTER TABLE sigesp_empresa ADD COLUMN casconmov int2 DEFAULT 0; ";				   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_85");
					$lb_valido=false;
				}
	  }		  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_85
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_86()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_86
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 11/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;		   
	   switch($_SESSION["ls_gestor"])
	   {
			case "POSTGRES":
			     $ls_sql=" create table spg_tipomodificacion ( ".
				         " codemp               char(4)              not null, ".
						 " codtipmodpre         char(4)              not null, ".
						 " dentipmodpre         text                 null,     ".
						 " pretipmodpre         char(3)              null,     ".
						 " contipmodpre         varchar(12)          null,     ".
						 " constraint pk_spg_tipomodificacion primary key (codemp, codtipmodpre)); ";	
			  break;
				   
			case "MYSQLT":
			      $ls_sql=   " create table spg_tipomodificacion ( ".
							 " codemp               char(4)              not null, ".
							 " codtipmodpre         char(4)              not null, ".
							 " dentipmodpre         text                 null,     ".
							 " pretipmodpre         char(3)              null,     ".
							 " contipmodpre         varchar(12)          null,     ".
							 " constraint pk_spg_tipomodificacion primary key (codemp, codtipmodpre)) ".
							 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";					   								
				break;  				  
	  }
	  if (!empty($ls_sql))
	  {	
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2008_3_86-01");
					$lb_valido=false;
				}
	  }	
	  if ($lb_valido)
	  {
	  	   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table spg_tipomodificacion ".
                             " add constraint fk_spg_tipomodificacion__sigesp_empresa foreign key (codemp) ".
                             " references sigesp_empresa (codemp) on delete restrict on update restrict;   ";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" alter table spg_tipomodificacion ".
                             " add constraint fk_spg_tipomodificacion__sigesp_empresa foreign key (codemp) ".
                             " references sigesp_empresa (codemp) on delete restrict on update restrict;   ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_86 -02 CONSTRAINT");
						$lb_valido=false;
					}
		  }	
	  }	//fin de valido  
	  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_86
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_87()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_87
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 13/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table spg_ep3 ".
							 "   add estreradi char(1) default 0 ";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" alter table spg_ep3 ".
							  "   add estreradi char(1) default 0 ";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_87");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_87
//------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_88()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_88
		//		   Access: public 
		//        Modulos: 
		//	  Description: CXP
		// Fecha Creacion: 13/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" create table cxp_dc_cargos ( ".
							 "  codemp               char(4)              not null, ".
							 "  numsol               char(15)             not null, ".
							 "  numrecdoc            char(15)             not null, ".
							 "  cod_pro              char(10)             not null, ".
							 "  ced_bene             char(10)             not null, ".
							 "  codtipdoc            char(5)              not null, ".
							 "  codope               char(2)              not null, ".
							 "  numdc                char(15)             not null, ".
							 "  codcar               char(5)              not null, ".
							 "  codestpro1           varchar(25)          null,     ".
							 "  codestpro2           varchar(25)          null,     ".
							 "  codestpro3           varchar(25)          null,     ".
							 "  codestpro4           varchar(25)          null,     ".
							 "  codestpro5           varchar(25)          null,     ".
							 "  estcla               varchar(1)           null,     ".
							 "  spg_cuenta           varchar(25)          null,     ".
							 "  porcar               float8               null,     ".
							 "  formula              varchar(254)         null,     ".
							 "  monobjret            float8               null,     ".
							 "  monret               float8               null,     ".
							 "  constraint pk_cxp_dc_cargos primary key (codemp,    ".
							 "  numsol, numrecdoc, cod_pro, ced_bene, codtipdoc, codope, numdc, codcar)); ";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" create table cxp_dc_cargos ( ".
							 "  codemp               char(4)              not null, ".
							 "  numsol               char(15)             not null, ".
							 "  numrecdoc            char(15)             not null, ".
							 "  cod_pro              char(10)             not null, ".
							 "  ced_bene             char(10)             not null, ".
							 "  codtipdoc            char(5)              not null, ".
							 "  codope               char(2)              not null, ".
							 "  numdc                char(15)             not null, ".
							 "  codcar               char(5)              not null, ".
							 "  codestpro1           varchar(25)          null,     ".
							 "  codestpro2           varchar(25)          null,     ".
							 "  codestpro3           varchar(25)          null,     ".
							 "  codestpro4           varchar(25)          null,     ".
							 "  codestpro5           varchar(25)          null,     ".
							 "  estcla               varchar(1)           null,     ".
							 "  spg_cuenta           varchar(25)          null,     ".
							 "  porcar               float8               null,     ".
							 "  formula              varchar(254)         null,     ".
							 "  monobjret            float8               null,     ".
							 "  monret               float8               null,     ".
							 "  constraint pk_cxp_dc_cargos primary key (codemp,    ".
							 "  numsol, numrecdoc, cod_pro, ced_bene, codtipdoc, codope, numdc, codcar)) ".
							 "  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";					   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_88-01");
						$lb_valido=false;
					}
		  }	 
		  
		  if ($lb_valido) 
		  {
		  		switch($_SESSION["ls_gestor"])
		   		{
					case "POSTGRES":
					$ls_sql="  alter table cxp_dc_cargos ".
                            "  add constraint fk_cxp_dc_cargos__cxp_sol_dc foreign key ".
							"  (codemp, numsol, numrecdoc, codtipdoc, ced_bene, cod_pro, codope, numdc) ".
                            "  references cxp_sol_dc (codemp, numsol, numrecdoc, codtipdoc, ced_bene, cod_pro, codope, numdc) ".
                            "  on delete restrict on update restrict;";
					break;
					
					case "MYSQLT":
					$ls_sql="  alter table cxp_dc_cargos ".
                            "  add constraint fk_cxp_dc_cargos__cxp_sol_dc foreign key ".
							"  (codemp, numsol, numrecdoc, codtipdoc, ced_bene, cod_pro, codope, numdc) ".
                            "  references cxp_sol_dc (codemp, numsol, numrecdoc, codtipdoc, ced_bene, cod_pro, codope, numdc) ".
                            "  on delete restrict on update restrict;";
					break;
				}
				if (!empty($ls_sql))
			    {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_88-02 CONSTRAINT");
							$lb_valido=false;
						}
			    }		  
		  }//fin del valido 
		  
		  if ($lb_valido) 
		  {
		  		switch($_SESSION["ls_gestor"])
		   		{
					case "POSTGRES":
					$ls_sql="  alter table cxp_dc_cargos ".
                            "  add constraint fk_cxp_dc_cargos__sigesp_cargos foreign key (codemp, codcar) ".
                            "  references sigesp_cargos (codemp, codcar) ".
                            "  on delete restrict on update restrict;";
					break;
					
					case "MYSQLT":
					$ls_sql="  alter table cxp_dc_cargos ".
                            "  add constraint fk_cxp_dc_cargos__sigesp_cargos foreign key (codemp, codcar) ".
                            "  references sigesp_cargos (codemp, codcar) ".
                            "  on delete restrict on update restrict;";
					break;
				}
				if (!empty($ls_sql))
			    {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_88-03 CONSTRAINT");
							$lb_valido=false;
						}
			    }		  
		  }//fin del valido   
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_88
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_89()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_89
		//		   Access: public 
		//        Modulos: 
		//	  Description: RRHH
		// Fecha Creacion: 13/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;	
		   $lb_existe = $this->io_function_db->uf_select_table('srh_dt_odi');
		   if ($lb_existe)
		   {	   
			   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" DROP TABLE srh_dt_odi;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" DROP TABLE srh_dt_odi; ";				   								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_89-01");
							$lb_valido=false;
						}
			  }
		   }//fin del existe 
		   	
		   if (($lb_valido)||(!$lb_existe))
		   {
				   switch($_SESSION["ls_gestor"])
				   {
						case "POSTGRES":
							 $ls_sql=" CREATE TABLE srh_dt_odi (   ".
									 " codemp  char(4)   not null, ".
									 " nroreg  char (15) not null, ".
									 " cododi  smallint not null,  ".
									 " odi	  text,                ".
									 " valor   float,              ".
									 " PRIMARY KEY (codemp, nroreg ,cododi)) ".
									 " WITHOUT OIDS;";	
						  break;
							   
						case "MYSQLT":
							 $ls_sql=" CREATE TABLE srh_dt_odi (   ".
									 " codemp  char(4)   not null, ".
									 " nroreg  char (15) not null, ".
									 " cododi  smallint not null,  ".
									 " odi	  text,                ".
									 " valor   float,              ".
									 " PRIMARY KEY (codemp, nroreg ,cododi)) ".
									 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";				   								
							break;  				  
				  }
				  if (!empty($ls_sql))
				  {	
							$li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								$this->io_msg->message("Problemas Release 2008_3_89-02");
								$lb_valido=false;
							}
				  }	    
		   } /// fin de valido	
		   		 
		   if (($lb_valido)||(!$lb_existe))
		   {
		  	   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" alter table srh_dt_odi ".
                                 "   add constraint fk_srh_dt_odi__srh_odi foreign key (codemp, nroreg) ".
                                 "   references srh_odi (codemp, nroreg) ".
                                 "   on delete restrict on update restrict;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" alter table srh_dt_odi ".
                                 "   add constraint fk_srh_dt_odi__srh_odi foreign key (codemp, nroreg) ".
                                 "   references srh_odi (codemp, nroreg) ".
                                 "   on delete restrict on update restrict;";							
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_89-03 CONSTRAINT");
							$lb_valido=false;
						}
			  }	    
		  } /// fin de valido  
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_89
////-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_90()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_90
		//		   Access: public 
		//        Modulos: 
		//	  Description: RRHH
		// Fecha Creacion: 13/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;	
		   $lb_existe = $this->io_function_db->uf_select_table('srh_dt_revisiones_odi');
		   if ($lb_existe)
		   {	   
			   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" DROP TABLE srh_dt_revisiones_odi;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" DROP TABLE srh_dt_revisiones_odi; ";				   								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_90-01");
							$lb_valido=false;
						}
			  }
		   }//fin del existe 
		   	
		   if (($lb_valido)||(!$lb_existe))
		   {
				   switch($_SESSION["ls_gestor"])
				   {
						case "POSTGRES":
							 $ls_sql=" CREATE TABLE srh_dt_revisiones_odi ( ".
									 "  codemp  	char(4) not null,   ".
									 "  nroreg  	char (15) not null, ".
									 "  fecrev   	date,               ".
									 "  cododi      smallint not null,  ".
									 "  odi	        text,               ".
									 "  observacion  text,              ".
									 "  PRIMARY KEY (codemp, nroreg, fecrev, cododi)) ".
									 "  WITHOUT OIDS;						          ";			
						  break;
							   
						case "MYSQLT":
							 $ls_sql= " CREATE TABLE srh_dt_revisiones_odi ( ".
									 "  codemp  	char(4) not null,   ".
									 "  nroreg  	char (15) not null, ".
									 "  fecrev   	date,               ".
									 "  cododi      smallint not null,  ".
									 "  odi	        text,               ".
									 "  observacion  text,              ".
									 "  PRIMARY KEY (codemp, nroreg, fecrev, cododi)) ".
									 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";				   								
							break;  				  
				  }
				  if (!empty($ls_sql))
				  {	
							$li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								$this->io_msg->message("Problemas Release 2008_3_90-02");
								$lb_valido=false;
							}
				  }	    
		   } /// fin de valido	
		   		 
		   if (($lb_valido)||(!$lb_existe))
		   {
		  	   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" alter table srh_dt_revisiones_odi ".
                                 "   add constraint fk_srh_dt_revisiones_odi__srh_revisiones_odi ".
								 "   foreign key (codemp, nroreg, fecrev)  ".
                                 "   references srh_revisiones_odi (codemp, nroreg, fecrev) ".
                                 "   on delete restrict;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" alter table srh_dt_revisiones_odi ".
                                 "   add constraint fk_srh_dt_revisiones_odi__srh_revisiones_odi ".
								 "   foreign key (codemp, nroreg, fecrev)  ".
                                 "   references srh_revisiones_odi (codemp, nroreg, fecrev) ".
                                 "   on delete restrict;";								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_90-03 CONSTRAINT");
							$lb_valido=false;
						}
			  }	    
		  } /// fin de valido  
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_90
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_91()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_91
		//		   Access: public 
		//        Modulos: 
		//	  Description: RRHH
		// Fecha Creacion: 13/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;	
		   $lb_existe = $this->io_function_db->uf_select_table('srh_evaluacion_odi');
		   if ($lb_existe)
		   {	   
			   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" DROP TABLE srh_evaluacion_odi;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" DROP TABLE srh_evaluacion_odi; ";				   								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_91-01");
							$lb_valido=false;
						}
			  }
		   }//fin del existe 
		   	
		   if (($lb_valido)||(!$lb_existe))
		   {
				   switch($_SESSION["ls_gestor"])
				   {
						case "POSTGRES":
							 $ls_sql=" CREATE TABLE srh_evaluacion_odi ( ".
									 "  codemp   char(4)     not null,   ".
									 "  nroeval  char(10)    not null,   ".
									 "  cododi  smallint not null,       ".
									 "  rango    int2,                   ".
									 "  peso_rango int2,                 ".
									 "  PRIMARY KEY(codemp,nroeval,cododi)) ".
									 "  WITHOUT OIDS;                    ";			
						  break;
							   
						case "MYSQLT":
							 $ls_sql= " CREATE TABLE srh_evaluacion_odi ( ".
									 "  codemp   char(4)     not null,   ".
									 "  nroeval  char(10)    not null,   ".
									 "  cododi  smallint not null,       ".
									 "  rango    int2,                   ".
									 "  peso_rango int2,                 ".
									 "  PRIMARY KEY(codemp,nroeval,cododi)) ".
									 " ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";				   								
							break;  				  
				  }
				  if (!empty($ls_sql))
				  {	
							$li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								$this->io_msg->message("Problemas Release 2008_3_91-02");
								$lb_valido=false;
							}
				  }	    
		   } /// fin de valido	
		   		 
		   if (($lb_valido)||(!$lb_existe))
		   {
		  	   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" alter table srh_evaluacion_odi ".
                                 "   add constraint fk_srh_evaluacion_odi__sigesp_empresa foreign key (codemp) ".
                                 "   references sigesp_empresa (codemp) ".
                                 "   on delete restrict on update restrict;";	
					  break;
						   
					case "MYSQLT":
						 $ls_sql=" alter table srh_evaluacion_odi ".
                                 "   add constraint fk_srh_evaluacion_odi__sigesp_empresa foreign key (codemp) ".
                                 "   references sigesp_empresa (codemp) ".
                                 "   on delete restrict on update restrict;";								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_91-03 CONSTRAINT");
							$lb_valido=false;
						}
			  }	    
		  } /// fin de valido
		  
		   if (($lb_valido)||(!$lb_existe))
		   {
		  	   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" alter table srh_evaluacion_odi ".
                                  "  add constraint fk_srh_evaluacion_odi__srh_evaluacion_desempeno  ".
								  "  foreign key (codemp, nroeval) ".
                                  "  references srh_evaluacion_desempeno (codemp, nroeval) ".
                                  "  on delete restrict on update restrict;";	
					  break;
						   
					case "MYSQLT":
						 $ls_sql=" alter table srh_evaluacion_odi ".
                                  "  add constraint fk_srh_evaluacion_odi__srh_evaluacion_desempeno  ".
								  "  foreign key (codemp, nroeval) ".
                                  "  references srh_evaluacion_desempeno (codemp, nroeval) ".
                                  "  on delete restrict on update restrict;";								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_3_91-04 CONSTRAINT");
							$lb_valido=false;
						}
			  }	    
		  } /// fin de valido  
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_91
//---------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_92()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_92
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 17/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE sno_personal ADD COLUMN porcajahoper FLOAT DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE sno_personal ADD COLUMN porcajahoper FLOAT DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_92");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_92
//-------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------
	 function uf_create_release_db_libre_V_2008_3_93()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_93
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 17/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE sno_familiar ADD COLUMN hijesp char (1) DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="ALTER TABLE sno_familiar ADD COLUMN hijesp char (1) DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_93");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_93
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_94()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_94
		//		   Access: public 
		//        Modulos: 
		//	  Description: SPG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table sigesp_cmp add estrenfon char(1) default '0';";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="alter table sigesp_cmp add estrenfon char(1) default '0';";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_94");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_94
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_95()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_95
		//		   Access: public 
		//        Modulos: 
		//	  Description: SPG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="alter table sigesp_cmp ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--';";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="alter table sigesp_cmp ADD COLUMN codfuefin char(2) NOT NULL DEFAULT '--';";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_95");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_95
//-----------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_96()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_96
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="ALTER TABLE sno_concepto ADD COLUMN persalnor char (1) DEFAULT '0';";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="ALTER TABLE sno_concepto ADD COLUMN persalnor char (1) DEFAULT '0';";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_96");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_96
//---------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_97()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_97
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="ALTER TABLE sno_hconcepto ADD COLUMN persalnor char (1) DEFAULT '0';";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="ALTER TABLE sno_hconcepto ADD COLUMN persalnor char (1) DEFAULT '0';";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_97");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_97
//-------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_98()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_98
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql="ALTER TABLE sno_thconcepto ADD COLUMN persalnor char (1) DEFAULT '0';";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql="ALTER TABLE sno_thconcepto ADD COLUMN persalnor char (1) DEFAULT '0';";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_98");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_98
//------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_3_99()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_3_99
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE sno_personalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE sno_personalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_3_99");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_3_99
//-----------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------------------- 
     function uf_create_release_db_libre_V_2008_4_00()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_00
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE sno_hpersonalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE sno_hpersonalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_00");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_00
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_01()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_01
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE sno_thpersonalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE sno_thpersonalnomina ADD COLUMN salnorper FLOAT DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_01");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_01
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_02()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_01
		//		   Access: public 
		//        Modulos: 
		//	  Description: SNO
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" ALTER TABLE cxp_sol_dc  ADD COLUMN moncar FLOAT8 DEFAULT 0;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" ALTER TABLE cxp_sol_dc  ADD COLUMN moncar DOUBLE(19,4) DEFAULT 0;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_02");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_02
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_03()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_03
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table sigesp_moneda drop imamon;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" alter table sigesp_moneda drop imamon;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_03");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_03
//-----------------------------------------------------------------------------------------------------------------------------------
///----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_04()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_03
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table sigesp_moneda drop tascamaux;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" alter table sigesp_moneda drop tascamaux;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_04");
						$lb_valido=false;
					}
		  }	    
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_04
//-----------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_05()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_05
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" alter table sigesp_moneda drop tascam;";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" alter table sigesp_moneda drop tascam;";				   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_05");
						$lb_valido=false;
					}
		  }	 
		  if ($lb_valido)
		  {
		  		 switch($_SESSION["ls_gestor"])
				   {
						case "POSTGRES":
							 $ls_sql=" alter table sigesp_moneda add abrmon character(4);";	
						  break;
							   
						case "MYSQLT":
							 $ls_sql=" alter table sigesp_moneda add abrmon character(4);";					   								
							break;  				  
				  }
				  if (!empty($ls_sql))
				  {	
							$li_row=$this->io_sql->execute($ls_sql);
							if($li_row===false)
							{ 
								$this->io_msg->message("Problemas Release 2008_4_05-01");
								$lb_valido=false;
							}
				  }	    
		  }// fin del valido
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_05
//------------------------------------------------------------------------------------------------------------------------------------
     function uf_create_release_db_libre_V_2008_4_06()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2008_4_06
		//		   Access: public 
		//        Modulos: 
		//	  Description: CFG
		// Fecha Creacion: 18/11/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		   $lb_valido=true;		   
		   switch($_SESSION["ls_gestor"])
		   {
				case "POSTGRES":
					 $ls_sql=" create table sigesp_dt_moneda ( ".
							 "  codmon               char(3)              not null, ".
							 "  fecha                date                 not null default '1900-01-01',".
							 "  tascam1              float8               not null default '0', ".
							 "  tascam2              float8               not null default '0', ".
							 "  constraint pk_sigesp_dt_moneda primary key (codmon, fecha));";	
				  break;
					   
				case "MYSQLT":
					  $ls_sql=" create table sigesp_dt_moneda ( ".
							 "  codmon               char(3)              not null, ".
							 "  fecha                date                 not null default '1900-01-01',".
							 "  tascam1              float8               not null default '0', ".
							 "  tascam2              float8               not null default '0', ".
							 "  constraint pk_sigesp_dt_moneda primary key (codmon, fecha))".
							 "  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";					   								
					break;  				  
		  }
		  if (!empty($ls_sql))
		  {	
					$li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						$this->io_msg->message("Problemas Release 2008_4_06-01");
						$lb_valido=false;
					}
		  }	 
		  if ($lb_valido)   
		  {
		  	   switch($_SESSION["ls_gestor"])
			   {
					case "POSTGRES":
						 $ls_sql=" alter table sigesp_dt_moneda ".
                                 "  add constraint fk_sigesp_dt_moneda__sigesp_moneda foreign key (codmon)".
                                 "  references sigesp_moneda (codmon) ".
                                 "  on delete restrict on update restrict;";	
					  break;
						   
					case "MYSQLT":
						  $ls_sql=" alter table sigesp_dt_moneda ".
                                 "  add constraint fk_sigesp_dt_moneda__sigesp_moneda foreign key (codmon)".
                                 "  references sigesp_moneda (codmon) ".
                                 "  on delete restrict on update restrict;";						   								
						break;  				  
			  }
			  if (!empty($ls_sql))
			  {	
						$li_row=$this->io_sql->execute($ls_sql);
						if($li_row===false)
						{ 
							$this->io_msg->message("Problemas Release 2008_4_06-01 CONSTRAINT");
							$lb_valido=false;
						}
			  }	    
		  }//fin de lb_valido
		  return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2008_4_06
//------------------------------------------------------------------------------------------------------------------------------------     
//-----------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_4_07()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_4_07
		//		   Access: public 
		//        Modulos: Activos Fijos
		//	  Description: 
		// Fecha Creacion: 20/11/2008 								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT": 			   
				 $ls_sql= " create table saf_autsalida( ".
						"   codemp               char(4) not null, ".
						"   cmpsal               char(15) not null, ".
						"   coduniadm            varchar(10) not null, ".
						"   fecaut               date not null, ".
						"   codpro               varchar(10) not null, ".
						"   codrep               varchar(10) not null, ".
						"   fecent               date not null, ".
						"   fecdev               date not null, ".
						"   estprosal            smallint default 0, ".
						"   consal               varchar(500), ".
						"   obssal               varchar(500), ".
						"   primary key (codemp, cmpsal, coduniadm, fecaut)) ".
						"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
			   break;
			   
			case "POSTGRES":
			   $ls_sql=	" CREATE TABLE saf_autsalida( ".
						"  codemp character(4) NOT NULL, ".
						"  cmpsal character varying(15) NOT NULL, ".
						"  coduniadm character varying(10) NOT NULL, ".
						"  codpro character varying(10) NOT NULL, ".
						"  codrep character varying(10) NOT NULL, ".
						"  fecaut date NOT NULL, ".
						"  fecent date NOT NULL, ".
						"  fecdev date NOT NULL, ".
						"  estprosal smallint DEFAULT 0, ".
						"  consal character varying(500), ".
						"  obssal character varying(500), ".
						"  CONSTRAINT pk_saf_autsalida PRIMARY KEY (codemp, cmpsal, coduniadm, fecaut), ".
						"  CONSTRAINT fk_sigesp_empresa__saf_autsal foreign key (codemp) REFERENCES sigesp_empresa (codemp) ".
                        "  on delete restrict on update restrict) ".
						"  WITHOUT OIDS;";
			   break;
		}	
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{ 
			 $this->io_msg->message("Problemas al ejecutar Release 4_07");
			 $lb_valido=false;
		}
   	   //-----------------------------------------------------------------------------------------------------------------------
	       $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				 case "MYSQLT":
				   $ls_sql= "  ALTER TABLE saf_autsalida ".
				  			"  ADD constraint fk_sigesp_empresa_saf_autsalida foreign key (codemp) ".
						    "  references sigesp_empresa (codemp) on delete restrict on update restrict";							
							
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 3.58-1 -->Ver el tipo de las Tablas<--");
						 $lb_valido=false;
					}							  
				 break;			
			}
	   //-----------------------------------------------------------------------------------------------------------------------
	     $ls_sql="";
		 switch($_SESSION["ls_gestor"])
	     {
			case "MYSQLT": 			  
				 $ls_sql= " create table saf_dt_autsalida( ".
						"   codemp               char(4) not null, ".
						"   cmpsal               char(15) not null, ".
						"   coduniadm            varchar(10) not null, ".
						"   fecaut               date not null, ".
						"   codact               char(15) not null, ".
						"   ideact               char(15) not null, ".
						"   primary key (codemp, cmpsal, coduniadm, fecaut, codact, ideact)) ".
						"   ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci; ";
			   break;
			   
			case "POSTGRES":
			   $ls_sql=	" CREATE TABLE saf_dt_autsalida( ".
						"  codemp character(4) NOT NULL, ".
						"  cmpsal character varying(15) NOT NULL, ".
						"  coduniadm character varying(10) NOT NULL, ".
						"  fecaut date NOT NULL, ".
						"  codact character(15) NOT NULL, ".
						"  ideact character(15) NOT NULL, ".
						"  CONSTRAINT pk_saf_dt_autsalida PRIMARY KEY (codemp, cmpsal, coduniadm, fecaut, codact, ideact), ".
						"  CONSTRAINT fk_saf_dt_a_reference_saf_dta FOREIGN KEY (codemp, codact, ideact) ".
						"      REFERENCES saf_dta (codemp, codact, ideact) MATCH SIMPLE ".
						"      ON UPDATE RESTRICT ON DELETE RESTRICT, ".
						"  CONSTRAINT fk_saf_dta__saf_autsalida FOREIGN KEY (codemp, cmpsal, coduniadm, fecaut) ".
						"      REFERENCES saf_autsalida (codemp, cmpsal, coduniadm, fecaut) MATCH SIMPLE ".
						"      ON UPDATE RESTRICT ON DELETE RESTRICT) ".
						"  WITHOUT OIDS;";
			   break;
		  }	
		  $li_row=$this->io_sql->execute($ls_sql);
		  if($li_row===false)
		  { 
			 $this->io_msg->message("Problemas al ejecutar Release 4_07 - 2 ");
			 $lb_valido=false;
		  }
	   
	   //-----------------------------------------------------------------------------------------------------------------------
	        $ls_sql="";
		   switch($_SESSION["ls_gestor"])
		   {
				 case "MYSQLT":
				   $ls_sql= "  ALTER TABLE saf_dt_autsalida ".
				  			"  ADD constraint fk_saf_autsalida__saf_dt_autsal foreign key (codemp, cmpsal, coduniadm, fecaut) ".
						    "      references saf_autsalida (codemp, cmpsal, coduniadm, fecaut) ".
							"  on delete restrict on update restrict, ".
						    "  ADD constraint fk_saf_dta__saf_dt_autsalida foreign key (codemp, codact, ideact) ".
						    "      references saf_dta (codemp, codact, ideact) on delete restrict on update restrict";							
							
				   $li_row=$this->io_sql->execute($ls_sql);
					if($li_row===false)
					{ 
						 $this->io_msg->message("Problemas al ejecutar Release 4-07-3 -->Ver el tipo de las Tablas<--");
						 $lb_valido=false;
					}							  
				 break;			
			}
	   //-----------------------------------------------------------------------------------------------------------------------
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_4_07
//----------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------
    function uf_create_release_db_libre_V_4_08()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_4_08
		//		   Access: public 
		//        Modulos: SAF
		//	  Description: Crea la tabla saf_entrega
		// Fecha Creacion: 20/11/2008 								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true;
	   $ls_sql="";
	   switch($_SESSION["ls_gestor"])
	   {
			case "MYSQLT":
			    $ls_sql="  CREATE TABLE saf_entrega( ".
  						"  codemp char(4) NOT NULL,  ".
						"  cmpent char(15) NOT NULL, ".
						"  feccmp date NOT NULL, ".
						"  fecent date NOT NULL, ".
						"  coduniadm varchar(10) NOT NULL, ".
						"  codunisol varchar(10) DEFAULT '----------', ".
						"  estproent smallint default 0, ".
						"  codres varchar(10), ".
						"  coddes varchar(10), ".
						"  codrec varchar(10), ".
						"  tipres char(1), ".
						"  tipdes char(1), ".
						"  tiprec char(1), ".
						"  obsent text, ".
						"  CONSTRAINT pk_saf_entrega PRIMARY KEY (codemp, cmpent, feccmp, coduniadm)) ".
						"  ENGINE = InnoDB CHAR SET utf8 COLLATE utf8_general_ci;";
			   break;
			   
			case "POSTGRES":
			    $ls_sql=" CREATE TABLE saf_entrega( ".
  						" codemp char(4) NOT NULL,  ".
  						" cmpent char(15) NOT NULL, ".
  						" feccmp date NOT NULL,     ".
  						" fecent date NOT NULL,     ".
  						" coduniadm varchar(10) NOT NULL, ".
  						" codunisol varchar(10) DEFAULT '----------', ".
  						" estproent smallint default 0, ".
  						" codres varchar(10), ".
  						" coddes varchar(10), ".
  						" codrec varchar(10), ".
  						" tipres char(1), ".
  						" tipdes char(1), ".
  						" tiprec char(1), ".
  						" obsent text,    ".
  						" CONSTRAINT pk_saf_entrega PRIMARY KEY (codemp, cmpent, feccmp, coduniadm), ".
  						" CONSTRAINT fk_saf_entr_empresa__sigesp_e FOREIGN KEY (codemp) ".
      					" REFERENCES sigesp_empresa (codemp) ".
      					" ON UPDATE RESTRICT ON DELETE RESTRICT ) WITHOUT OIDS; ";
			   break;
		}	
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{ 
			 $this->io_msg->message("Problemas al ejecutar Release_db_libre_V_4_08-01");
			 $lb_valido=false;
		}
		/