<?php
////////////////////////////////////////////////////////////////////////////////////////////////////
//            CLASS:  sigesp_release
//	         Access:  public
//     Programador:  Ing. Wilmer Brice�
//     Description:  Clase que tiene comom Funcion actualizar los nuevos campos y tablas de la base 
//                   de datos SIGESP.db
////////////////////////////////////////////////////////////////////////////////////////////////////
class sigesp_release 
{
	var $io_function;
	var $io_function_db;
	var $io_msg;
	var $io_include;
	var $io_connect;
	var $io_sql;
	
	function sigesp_release()
	{
		require_once("class_sql.php");  
		require_once("sigesp_include.php");
		require_once("class_funciones.php");
		require_once("class_mensajes.php");
		require_once("class_funciones_db.php");
		require_once("class_vistas_db.php");  
		require_once("sigesp_c_seguridad.php");
		$this->io_function=new class_funciones();	
		$this->io_msg=new class_mensajes();
		$this->io_include=new sigesp_include();
		$this->io_connect=$this->io_include->uf_conectar();
		//$this->io_connect->debug=true;
		$this->io_sql=new class_sql($this->io_connect);
		$this->io_function_db=new class_funciones_db($this->io_connect);
		$this->io_vistas_db=new class_vistas_db($this->io_connect);						
		$this->io_seguridad=new sigesp_c_seguridad();		
		$this->ls_codemp=$_SESSION["la_empresa"]["codemp"];		
	} //  end contructor

	function uf_destructor()
	{	
		unset($this->io_function);	
		unset($this->io_msg);				
		unset($this->io_include);				
		unset($this->io_connect);				
		unset($this->io_sql);	
		unset($this->io_seguridad);	
	} // end function uf_destructor

    function uf_check_update($aa_seguridad) // main()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_check_update
		//		   Access: public 
		//	  Description: chequea los updates
		//	   Creado Por: Ing. Wilmer Brice�
		// Fecha Creacion: 06/07/2006 								Fecha �tima Modificaci� : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$this->io_sql->begin_transaction();	
		$ls_nro_release="";   
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$existe=false;
		$lb_existe =$this->io_function_db->uf_select_type_columna('srh_solicitud_empleo','pessol','numeric');
		if (!$lb_existe)
		{
			$this->io_msg->message(utf8_encode(" Release Version 2021_01_01 "));				   	   
			$lb_valido=$this->uf_create_release_db_libre_V_2021_01_01();
			$ls_nro_release.=" - 2021_01_01";   
		}
                
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if($lb_valido)
		{ 
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="PROCESS";
			$ls_descripcion="Ejecute el release ".$ls_nro_release;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////
		}
		if($lb_valido)
		{

			$this->io_sql->commit();
		}
		else
		{
			$this->io_sql->rollback();
		}
		return $lb_valido;
	} // end function 
        
	 function uf_create_release_db_libre_V_2021_01_01()
	 {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_create_release_db_libre_V_2021_01_01
		//		   Access: public 
		//        Modulos: SCB
		//	  Description: 
		// Fecha Creacion: 16/08/2008								Fecha Ultima Modificacion : 
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	   $lb_valido=true; 
		$ls_sql="SELECT TABLE_NAME as tabla, COLUMN_NAME as columna ".
				"  FROM INFORMATION_SCHEMA.COLUMNS ".                
				" WHERE TABLE_CATALOG='".$_SESSION["ls_database"]."' ".
				"   AND UPPER(DATA_TYPE)=UPPER('double precision') ".
				"   AND UPPER(TABLE_SCHEMA)=UPPER('PUBLIC') ".
				"   AND TABLE_NAME NOT IN('calculo_conceptospersonal','calculo_personal','calculo_personaltabulador','contableaportes_contable_proyecto_dt','contableaportes_contable_proyecto_dt_intcom','contableconceptos_contable_proyecto_dt','contableconceptos_contable_proyecto_dt_int','detalle_acumulado','scg_listado_comprobante','scg_listado_comprobante_detalle') ".
				" ORDER BY TABLE_NAME ";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_msg->message("Problemas Release 2021_01_01");
			$lb_valido=false;
		}
		else
		{
			while((!$rs_data->EOF)&&($lb_valido))
			{
				$ls_sql= " ALTER TABLE ".$rs_data->fields["tabla"]." ALTER COLUMN ".$rs_data->fields["columna"]." TYPE numeric;";
				$li_row=$this->io_sql->execute($ls_sql);
				if($li_row===false)
				{ 
					$this->io_msg->message("Problemas Release 2021_01_01");
					$lb_valido=false;
				}				
				$rs_data->MoveNext();
			}
		}  
	   return $lb_valido;	
	} // end function uf_create_release_db_libre_V_2021_01_01
///-------------------------------------------------------------------------------------------------------------------------------------
   
		
///////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////OTROS PROCESOS ADICIONALES//////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////
//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_config($as_codsis,$as_seccion,$as_entry)
	{
		$lb_existe=false;
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$ls_sql="SELECT * ".
			    "  FROM sigesp_config ".
			    " WHERE codemp='".$ls_codemp."' ".
			    "   AND codsis='".$as_codsis."' ".
			    "   AND seccion='".$as_seccion."' ".
			    "   AND entry='".$as_entry."' ";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_msg->message("No existe la tabla.");
			return false;
		}
		else
		{
			if(!$rs_data->EOF)
			{
				$lb_existe=true;
			}
		}
		return $lb_existe;
	}//fin de uf_select_config
//-----------------------------------------------------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_config($as_codsis,$as_seccion,$as_entry)
	{
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$lb_valido=true;
		if (!$this->uf_select_config($as_codsis,$as_seccion,$as_entry))
		{
			$ls_sql="INSERT INTO sigesp_config(codemp, codsis, seccion, entry, type, value)".
					"     VALUES ('".$ls_codemp."','".$as_codsis."','".$as_seccion."','".$as_entry."','C',' ')";	
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				print $this->io_sql->message;
				$this->io_msg->message("CLASE->release MÉTODO->uf_insert_config ERROR->".$this->io_function->uf_convertirmsg($this->io_sql->message));
				$lb_valido=false;
			}
		}
		return $lb_valido;

	}	
///------------------------------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------------------------------------
    function uf_buscar_unidad()
	{
		$ls_sql="";
		$lb_valido=true;
		$valor=0;	
	    switch(strtoupper($_SESSION["ls_gestor"]))
		{
			case "MYSQLT":
			   $ls_sql= "  SELECT count(*) as valor from spg_dt_unidadadministrativa WHERE coduniadm='----------' ";					
		    break;
			case "MYSQLI":
			   $ls_sql= "  SELECT count(*) as valor from spg_dt_unidadadministrativa WHERE coduniadm='----------' ";					
		    break;
			case "POSTGRES":
				 $ls_sql= "  SELECT count(*) as valor from spg_dt_unidadadministrativa WHERE coduniadm='----------' ";													
			break;  				  
		   
		}
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->select($ls_sql); 
			if($li_row===false)
			{ 
				$this->io_msg->message("Problemas uf_buscar_unidad");
				$lb_valido=false;
			}
			else
			{
				if($row=$this->io_sql->fetch_row($li_row))
				{
					$valor=$row["valor"];
				}
			}
		}
	    return $valor;
	}//fin del la funcion
////------------------------------------------------------------------------------------------------------------------------------- 

///-------------------------------------------------------------------------------------------------------------------------------------
    function uf_buscar_sep_solicitud()
	{
		$ls_sql="";
		$lb_valido=true;
		$valor1=0;	
	    switch(strtoupper($_SESSION["ls_gestor"]))
		{
			case "MYSQLT":
			   $ls_sql= " select count(*) as valor from sep_solicitud where numsol='---------------' ";					
		    break;
			case "MYSQLI":
			   $ls_sql= " select count(*) as valor from sep_solicitud where numsol='---------------' ";					
		    break;
			case "POSTGRES":
				$ls_sql= " select count(*) as valor from sep_solicitud where numsol='---------------' ";													
			break;  				  
		} 
		if (!empty($ls_sql))
		{	
			$li_row=$this->io_sql->select($ls_sql); 
			if($li_row===false)
			{
				$this->io_msg->message("uf_buscar_sep_solicitud");
				$lb_valido=false;
			}
			else
			{
				if($row=$this->io_sql->fetch_row($li_row))
				{ 
					$valor1=$row["valor"];
				}
			}
		} 
	    return $valor1;
	}//fin del la funcion
///------------------------------------------------------------------------------------------------------------------------------------


} // end class uf_check_update()
?>