<?php
class sigesp_scb_c_conciliacionautomatica
{
	private $io_sql;
	private $io_msg;
	private $io_seguridad;
	private $io_excel;
	private $io_conalt;
	private $io_fecha; 
	
	public function sigesp_scb_c_conciliacionautomatica()
        {
		require_once("../shared/class_folder/class_sql.php");
		require_once("../shared/class_folder/class_mensajes.php");
		require_once("../shared/class_folder/sigesp_include.php");
		require_once("../shared/class_folder/sigesp_c_seguridad.php");
		require_once("../shared/class_folder/class_fecha.php");
		$io_include 		= new sigesp_include();
		$io_connect         = $io_include->uf_conectar();
		$io_connect->debug  = true;
		$this->io_sql       = new class_sql($io_connect);
		$this->io_msg       = new class_mensajes();
		$this->io_seguridad = new sigesp_c_seguridad();
		$this->io_fecha     = new class_fecha();
		$this->io_conalt    = null;
                $this->codemp    = $_SESSION["la_empresa"]["codemp"];
	}
	
	public function uf_buscar_configuracion_archivo($codigo)
        {
		$ls_sql = "SELECT * FROM scb_archivoconciliacion WHERE codarc='{$codigo}'";
		return $this->io_sql->execute($ls_sql);
	}
	
	public function uf_abrir_archivo($as_nombrearchivo,$ao_archivo)
	{
		$lb_valido=true;
		if (file_exists("$as_nombrearchivo"))
		{
			$ao_archivo=@file("$as_nombrearchivo");
		}
		else
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Importar/Exportar Datos MTODO->uf_abrir_archivo ERROR->el archivo no existe."); 
		}
		$arrResultado['ao_archivo']=$ao_archivo;
		$arrResultado['lb_valido']=$lb_valido;
		return $arrResultado;
	}// end function uf_abrir_archivo

	public function uf_load_configuracion_campos($as_codarc,$ai_totrows,$ao_object)
	{
		$lb_valido=true;
		$ls_sql="SELECT codcam, inicam, loncam, colcam, camrel, forcam, cricam ".
                        "  FROM scb_dt_archivoconciliacion".
                        " WHERE codemp='".$this->codemp."'".	
			"   AND codarc = '".$as_codarc."' ".	
			" ORDER BY codcam, inicam ";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Archivo txt MTODO->uf_load_configuracion_campos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
		}
		else
		{
			$ai_totrows=0;
			while(!$rs_data->EOF)
			{
				$ai_totrows++;
				$li_codcam=$rs_data->fields["codcam"];
				$li_inicam=$rs_data->fields["inicam"];
				$li_loncam=$rs_data->fields["loncam"];
				$ls_colcam=$rs_data->fields["colcam"];
				$ls_camrel=$rs_data->fields["camrel"];
				$ls_forcam=$rs_data->fields["forcam"];
				$ls_cricam=$rs_data->fields["cricam"];
				$ao_object["codcam"][$ai_totrows]=$li_codcam;
				$ao_object["inicam"][$ai_totrows]=$li_inicam;
				$ao_object["loncam"][$ai_totrows]=$li_loncam;
				$ao_object["colcam"][$ai_totrows]=$ls_colcam;
				$ao_object["camrel"][$ai_totrows]=$ls_camrel;
				$ao_object["forcam"][$ai_totrows]=$ls_forcam;
				$ao_object["cricam"][$ai_totrows]=$ls_cricam;
                                $rs_data->MoveNext();
			}
			$this->io_sql->free_result($rs_data);
		}
		$arrResultado['ai_totrows']=$ai_totrows;
		$arrResultado['ao_object']=$ao_object;
		$arrResultado['lb_valido']=$lb_valido;
		return $arrResultado;
	}// end function uf_load_configuracion_campos
        
	public function uf_cargar_estado_cuenta($archivo, $codarc, $codban, $ctaban, $saldoInicial)
        {
		$ls_nombrearchivo=$archivo;
		$lo_archivo="";
		$arrResultado=$this->uf_abrir_archivo($ls_nombrearchivo,$lo_archivo);
		$lo_archivo=$arrResultado['ao_archivo'];
		$lb_valido=$arrResultado['lb_valido'];
		$li_totrows=0;
		$lo_object="";
		if($lb_valido)
		{
			$directorioResultado = 'resultado_conciliacion';
			if(!file_exists ($directorioResultado))
                        {
				$exito = mkdir($directorioResultado,0777);
				if(!$exito)
                                {
                                    $this->io_msg->message('No se pudo crear la capeta de resultados');
                                    return false;
				}
                                else
                                {
                                    $arcResultado = @fopen($directorioResultado.'/resultado_estcuenta_'.date("dmY").'_'.date("H_i").'.txt',"a+");
                                }
			}
			$dataConf = $this->uf_buscar_configuracion_archivo($codarc);
			$tiparc = $dataConf->fields['tiparc'];
			$separc = $dataConf->fields['separc'];
			$filiniarc  = $dataConf->fields['filiniarc'];
			$ndequarc  = $dataConf->fields['ndequarc'];
			$ncequarc  = $dataConf->fields['ncequarc'];
			$chequarc  = $dataConf->fields['chequarc'];
			$dpequarc  = $dataConf->fields['dpequarc'];
			$rtequarc  = $dataConf->fields['rtequarc'];
                        $saldoInicial = str_replace('.', '', $saldoInicial);
			$saldoInicial = str_replace(',', '.', $saldoInicial);
			
                        $arrResultado=$this->uf_load_configuracion_campos($codarc,$li_totrows,$lo_object);
			$li_totrows=$arrResultado['ai_totrows'];
			$lo_object=$arrResultado['ao_object'];
			$lb_valido=$arrResultado['lb_valido'];	
			if($lb_valido)
			{
                            $contRegistros = 0;
                            $contInsert    = 0;
                            $contError     = 0;
                            $saldoBanco    = 0;
                            if (($tiparc == '0')||(($tiparc == '1'))) //ARCHIVO TXT 
                            {
                                $lb_valido=true;
                                $li_total=count($lo_archivo);
                                for($li_i=0;($li_i<$li_total);$li_i++)
                                {
                                        $valNumdoc = "";
                                        $valTipdoc = "";
                                        $valFecha  = "1900-01-01";
                                        $valMonto = 0;
                                        for($li_z=1;($li_z<=$li_totrows);$li_z++)
                                        {
                                                $li_codcam=$lo_object["codcam"][$li_z];
                                                $li_inicam=$lo_object["inicam"][$li_z];
                                                $li_loncam=$lo_object["loncam"][$li_z];
                                                $ls_camrel=$lo_object["camrel"][$li_z];
                                                $ls_forcam=ltrim(rtrim($lo_object["forcam"][$li_z]));
                                                $ls_cricam=ltrim(rtrim($lo_object["cricam"][$li_z]));
                                                if ($tiparc == '0')
                                                {
                                                    $ls_campo=substr($lo_archivo[$li_i],$li_inicam,$li_loncam);
                                                }
                                                else
                                                {
                                                    $ls_campos = explode($separc,$lo_archivo[$li_i]);
                                                    $ls_campo = $ls_campos[$li_z-1];
                                                    
                                                }
                                                if($ls_camrel=="monto")
                                                {
                                                        $ls_campo=number_format($ls_campo,2,".","");
                                                }
                                                if($ls_forcam!="")
                                                {
                                                        if($ls_camrel=="fecmov")
                                                        {
                                                                $newDate = date("d/m/Y", strtotime($ls_campo));
                                                                $ls_campo=ltrim(rtrim($newDate));
                                                        }
                                                }
                                                if($ls_cricam!="")
                                                {
                                                        if($ls_camrel=="monto")
                                                        {
                                                                $ls_cricam=str_replace("campo",$ls_campo,$ls_cricam);
                                                                $ls_campo=$this->io_eval->uf_evaluar_formula($ls_cricam,$ls_campo);
                                                        }
                                                        else
                                                        {
                                                                $ls_campo="'".ltrim(rtrim($ls_campo))."'";
                                                                $ls_cricam=str_replace("campo",$ls_campo,$ls_cricam);
                                                                $ls_campo=@eval(" return $ls_cricam;");
                                                        }
                                                }
                                                if($ls_camrel=="numdoc")
                                                {
                                                        $valNumdoc = str_pad($ls_campo, 15, 0, 0);
                                                }
                                                if($ls_camrel=="fecmov")
                                                {
                                                    $valFecha = $this->io_fecha->uf_convert_date_to_db($ls_campo);
                                                }
                                                if($ls_camrel=="monto")
                                                {
                                                        $valMonto = $ls_campo;
                                                }
                                                if($ls_camrel=="codope")
                                                {
                                                    if (trim($dpequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'DP';
                                                    }
                                                    elseif (trim($ncequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'NC';
                                                    }
                                                    elseif (trim($ndequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'ND';
                                                    }
                                                    elseif (trim($chequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'CH';
                                                    }
                                                    elseif (trim($rtequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'RE';
                                                    }
                                                }                                                
                                        }
                                        if (($valTipdoc=='DP')||($valTipdoc=='NC'))
                                        {
                                            $saldoInicial = $saldoInicial + $valMonto;
                                        }
                                        else
                                        {
                                            $saldoInicial = $saldoInicial - $valMonto;
                                        }
                                        $cadenaSQL = "INSERT INTO scb_movimientoconciliar(codban, ctaban, numref, fecmov, tipmov, monto)
                                                                        VALUES ('{$codban}', '{$ctaban}', '{$valNumdoc}', '{$valFecha}', '{$valTipdoc}', {$valMonto})";
                                                                        print $cadenaSQL."<br>";
                                        $respuesta = $this->io_sql->execute($cadenaSQL);
                                        if($respuesta === false)
                                        {
                                                $ls_cadena .= "Ocurrio un error en la linea ".$contRegistros." Error BD:".$this->io_sql->conn->ErrorMsg()." .\r\n";
                                                $contError++;
                                        }
                                        else
                                        {
                                                $contInsert++;
                                        }
                                        $contRegistros++;
                                }
                            }
                            if ($tiparc == '2') //ARCHIVO EXCEL 
                            {
				require_once("../shared/readexcel/reader.php");
				$this->io_excel = new Spreadsheet_Excel_Reader();
				$this->io_excel->setOutputEncoding("CP1251");
				$this->io_excel->read($archivo);
                                $lb_valido=true;
                                for($li_indexfil=$filiniarc;($li_indexfil<=$this->io_excel->sheets[0]['numRows']);$li_indexfil++)
                                {
                                        $valNumdoc = "";
                                        $valTipdoc = "";
                                        $valFecha  = "1900-01-01";
                                        $valMonto = 0;
                                        for($li_z=1;($li_z<=$li_totrows);$li_z++)
                                        {
                                                $li_codcam=$lo_object["codcam"][$li_z];
                                                $li_colcam=$lo_object["colcam"][$li_z];
                                                $ls_camrel=$lo_object["camrel"][$li_z];
                                                $ls_forcam=ltrim(rtrim($lo_object["forcam"][$li_z]));
                                                $ls_cricam=ltrim(rtrim($lo_object["cricam"][$li_z]));
                                                $ls_campo = trim($this->io_excel->sheets[0]['cells'][$li_indexfil][$li_colcam]);
                                                if($ls_camrel=="monto")
                                                {
                                                        $ls_campo=number_format($ls_campo,2,".","");
                                                }
                                                if($ls_cricam!="")
                                                {
                                                        if($ls_camrel=="monto")
                                                        {
                                                                $ls_cricam=str_replace("campo",$ls_campo,$ls_cricam);
                                                                $ls_campo=$this->io_eval->uf_evaluar_formula($ls_cricam,$ls_campo);
                                                        }
                                                        else
                                                        {
                                                                $ls_campo="'".ltrim(rtrim($ls_campo))."'";
                                                                $ls_cricam=str_replace("campo",$ls_campo,$ls_cricam);
                                                                $ls_campo=@eval(" return $ls_cricam;");
                                                        }
                                                }
                                                if($ls_camrel=="numdoc")
                                                {
                                                        $valNumdoc = str_pad($ls_campo, 15, 0, 0);
                                                }
                                                if($ls_camrel=="fecmov")
                                                {
                                                    $valFecha = $this->io_fecha->uf_convert_date_to_db($ls_campo);
                                                }
                                                if($ls_camrel=="monto")
                                                {
                                                        $valMonto = $ls_campo;
                                                }
                                                if($ls_camrel=="codope")
                                                {
                                                    if (trim($dpequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'DP';
                                                    }
                                                    elseif (trim($ncequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'NC';
                                                    }
                                                    elseif (trim($ndequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'ND';
                                                    }
                                                    elseif (trim($chequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'CH';
                                                    }
                                                    elseif (trim($rtequarc) == trim($ls_campo))
                                                    {
                                                            $valTipdoc = 'RE';
                                                    }
                                                }                                                
                                        }
                                        if (($valTipdoc=='DP')||($valTipdoc=='NC'))
                                        {
                                            $saldoInicial = $saldoInicial + $valMonto;
                                        }
                                        else
                                        {
                                            $saldoInicial = $saldoInicial - $valMonto;
                                        }
                                        $cadenaSQL = "INSERT INTO scb_movimientoconciliar(codban, ctaban, numref, fecmov, tipmov, monto)
                                                                        VALUES ('{$codban}', '{$ctaban}', '{$valNumdoc}', '{$valFecha}', '{$valTipdoc}', {$valMonto})";
                                        $respuesta = $this->io_sql->execute($cadenaSQL);
                                        if($respuesta === false)
                                        {
                                                $ls_cadena .= "Ocurrio un error en la linea ".$contRegistros." Error BD:".$this->io_sql->conn->ErrorMsg()." .\r\n";
                                                $contError++;
                                        }
                                        else
                                        {
                                                $contInsert++;
                                        }
                                        $contRegistros++;
                                }
                            }
                        }
			$ls_cadreuslt   = "Total movimientos procesados ->".$contRegistros." Total movimientos cargados para conciliar ->".$contInsert." Total movimientos con errores ->".$contError." Saldo banco calculado ->".$saldoInicial."\r\n".$ls_cadena;
			@fwrite($arcResultado,$ls_cadreuslt);
			fclose($arcResultado);
			$this->io_msg->message('La lectura del estado de cuenta finalizo descargue el archivo con los resultados');
			unset($dataConf);                        
                }
	}
	
	public function uf_obtener_movconcilian_externo($codban, $ctaban, $numref, $tipmov, $fechasta)
        {
		$concilia = false;
		require_once("../base/librerias/php/general/sigesp_lib_conexion.php");
		$arrConfi = parse_ini_file('../base/conf/conf_conexion.ini');
		$this->io_conalt = ConexionBaseDatos::conectarAlternaBD($arrConfi['HOST_DBALT'], $arrConfi['LOGG_DBALT'], $arrConfi['PASS_DBALT'], 
																$arrConfi['NOMB_DBALT'], $arrConfi['GEST_DBALT'], $arrConfi['PORT_DBALT']);
		$cadenaSQL = "SELECT numref
						FROM mis_sigesp_banco_detalle_intt
						WHERE codban='{$codban}' AND ctaban='{$ctaban}' 
				  		  AND numref='{$numref}' AND operacion='{$tipmov}'
				  		  AND fecdep <='{$fechasta}'	";
		$resConcilia = $this->io_conalt->Execute($cadenaSQL);
		if ($resConcilia === false) {
			$concilia = -1;
		}
		else {
			if ($resConcilia->_numOfRows > 0) {
				$concilia = true;
			}
		}
		
		return $concilia;
	}
	
	public function uf_obtener_movimiento_concilian($codban, $ctaban, $fechasta, $conExterna=false) {
		if (!$conExterna) {
			$cadenaSQL = "SELECT MOVCON.codban, MOVCON.ctaban, MOVCON.numref, MOVCON.tipmov, MOVCON.monto 
							FROM scb_movimientoconciliar MOVCON
								INNER JOIN scb_movbco MOVBCO ON MOVCON.codban=MOVBCO.codban AND MOVCON.ctaban=MOVBCO.ctaban
														    AND MOVCON.numref=MOVBCO.numdoc AND MOVCON.tipmov=MOVBCO.codope
														    AND MOVCON.monto=(MOVBCO.monto-MOVBCO.monret) 
							WHERE MOVCON.codban='{$codban}' AND MOVCON.ctaban='{$ctaban}' AND MOVCON.estcon = '0'
			                  AND MOVCON.fecmov <='{$fechasta}' AND estmov <>'N' 
					          AND (feccon='1900-01-01' AND MOVBCO.fecmov<='{$fechasta}') ";
			return $this->io_sql->execute($cadenaSQL);
		}
		else {
			$x = 0;
			$arrMovCon = array();
			$cadenaSQL = "SELECT MOVCON.numref, MOVCON.tipmov
							FROM scb_movimientoconciliar
							WHERE MOVCON.codban='{$codban}' AND MOVCON.ctaban='{$ctaban}' AND MOVCON.fecmov <='{$fechasta}'";
			$dataConciliar = $this->io_sql->execute($cadenaSQL);
			while (!$dataConciliar->EOF) {
				$numref = $dataConciliar->fields['numref'];
				$tipmov = $dataConciliar->fields['tipmov'];
				if ($this->uf_obtener_movconcilian_externo($codban, $ctaban, $numref, $tipmov, $fechasta)) {
					$arrMovCon[$x]['codban'] = $codban;
					$arrMovCon[$x]['ctaban'] = $ctaban;
					$arrMovCon[$x]['numref'] = $numref;
					$arrMovCon[$x]['tipmov'] = $tipmov;
					$x++;
				}
				$dataConciliar->MoveNext();
			}
			return $arrMovCon;
		}
	}
	
	public function procesar_movnolibro($codban, $ctaban, $fechasta, $conExterna=false) {
		$arrResultado = array();
		$contNoLibro  = 0;
		$saldoNoLibro = 0;
		$cadenaError  = '';
		if (!$conExterna) {
			$cadenaSQL = "SELECT MOVCON.*, MOVBCO.numdoc
							FROM scb_movimientoconciliar MOVCON
								LEFT OUTER JOIN scb_movbco MOVBCO ON MOVCON.codban=MOVBCO.codban AND MOVCON.ctaban=MOVBCO.ctaban
														         AND MOVCON.numref=MOVBCO.numdoc AND MOVCON.tipmov=MOVBCO.codope
														         AND MOVCON.monto=(MOVBCO.monto-MOVBCO.monret)
							WHERE MOVCON.codban='{$codban}' AND MOVCON.ctaban='{$ctaban}' AND MOVCON.estcon = '0'
							  AND MOVCON.fecmov <='{$fechasta}'";
			$dataNolibro = $this->io_sql->execute($cadenaSQL);
			while (!$dataNolibro->EOF) {
				if ($dataNolibro->fields['numdoc'] == NULL) {
					$numref = $dataNolibro->fields['numref'];
					$fecmov = $dataNolibro->fields['fecmov'];
					$tipmov = $dataNolibro->fields['tipmov'];
					$monto  = $dataNolibro->fields['monto'];
					
					$insertSQL = "INSERT INTO scb_movnolibro(codban, ctaban, numref, fecmov, tipmov, monto)
									VALUES ('{$codban}', '{$ctaban}', '{$numref}', '{$fecmov}', '{$tipmov}', {$monto})"; 
					if ($this->io_sql->execute($insertSQL) === false) {
						$cadenaError .= "Ocurrio un insertando un movimiento no registrado en libro, Error SQL:".$this->io_sql->conn->ErrorMsg()." .\r\n"; 
					}
					else {
						$contNoLibro++;
						$saldoNoLibro += $monto; 
					}
				}				
				$dataNolibro->MoveNext();
			}
			unset($dataNolibro);
		}
		else {
			
		}
		
		$arrResultado['contNoLibro']  = $contNoLibro;
		$arrResultado['saldoNoLibro'] = $saldoNoLibro;
		$arrResultado['cadenaError']  = $cadenaError;
		
		return $arrResultado;
	}
	
	public function procesar_movnobanco($codban, $ctaban, $fechasta, $conExterna=false) {
		$arrResultado = array();
		$contNoBanco  = 0;
		$saldoNoBanco = 0;
		$cadenaError  = '';
		if (!$conExterna) {
			$cadenaSQL = "SELECT MOVCON.numref, MOVBCO.numdoc, MOVBCO.fecmov, MOVBCO.codope, MOVBCO.monto
							FROM scb_movimientoconciliar MOVCON
								RIGHT OUTER JOIN scb_movbco MOVBCO ON MOVCON.codban=MOVBCO.codban AND MOVCON.ctaban=MOVBCO.ctaban
																  AND MOVCON.numref=MOVBCO.numdoc AND MOVCON.tipmov=MOVBCO.codope
																  AND MOVCON.monto=(MOVBCO.monto-MOVBCO.monret)
								WHERE MOVBCO.codban='{$codban}' AND MOVBCO.ctaban='{$ctaban}' AND estmov <>'N' 
					              AND (MOVBCO.feccon='1900-01-01' AND MOVBCO.fecmov<='{$fechasta}')";
			$dataNoBanco = $this->io_sql->execute($cadenaSQL);
			while (!$dataNoBanco->EOF) {
				if ($dataNoBanco->fields['numref'] == NULL) {
					$numref = $dataNoBanco->fields['numdoc'];
					$fecmov = $dataNoBanco->fields['fecmov'];
					$tipmov = $dataNoBanco->fields['codope'];
					$monto  = $dataNoBanco->fields['monto'];
						
					$insertSQL = "INSERT INTO scb_movnobanco(codban, ctaban, numref, fecmov, tipmov, monto)
									VALUES ('{$codban}', '{$ctaban}', '{$numref}', '{$fecmov}', '{$tipmov}', {$monto})";
					if ($this->io_sql->execute($insertSQL) === false) {
						$cadenaError .= "Ocurrio un error insertando un movimiento no registrado en banco, Error SQL:".$this->io_sql->conn->ErrorMsg()." .\r\n";
					}
					else {
						$contNoBanco++;
						$saldoNoBanco += $monto;
					}
				}
					$dataNoBanco->MoveNext();
			}
			unset($dataNoBanco);
		}
		else {
			
		}
		
		$arrResultado['contNoBanco']  = $contNoBanco;
		$arrResultado['saldoNoBanco'] = $saldoNoBanco;
		$arrResultado['cadenaError']  = $cadenaError;
		
		return $arrResultado;
	}
	
	public function uf_actualizar_movbco_estcon($codban, $ctaban, $numref, $tipmov, $fechasta) {
		$actualizo = true;
		$mensajeError = '';
		$arrRespuesta = array();
		$cadenaSQL = "UPDATE scb_movbco
						 SET estcon = '1', feccon='{$fechasta}' 
		               WHERE codban='{$codban}' AND ctaban='{$ctaban}' 
		                 AND numdoc='{$numref}' AND codope='{$tipmov}'";
		if ($this->io_sql->execute($cadenaSQL) === false) {
			$actualizo = false;
			$mensajeError .= "Ocurrio un error actualizando estatus de conciliacion en movbco, Error SQL:".$this->io_sql->conn->ErrorMsg()." .\r\n";
		}
		
		$arrRespuesta['exito'] = $actualizo;
		$arrRespuesta['mensajeError'] = $mensajeError;
		return $arrRespuesta;
	}
	
	public function uf_actualizar_movcon_estcon($codban, $ctaban, $numref, $tipmov) {
		$actualizo = true;
		$mensajeError = '';
		$arrRespuesta = array();
		$cadenaSQL = "UPDATE scb_movimientoconciliar
						 SET estcon = '1'
					   WHERE codban='{$codban}' AND ctaban='{$ctaban}'
						 AND numref='{$numref}' AND tipmov='{$tipmov}'";
		if ($this->io_sql->execute($cadenaSQL) === false) {
			$actualizo = false;
			$mensajeError .= "Ocurrio un error actualizando estatus de conciliacion en movimientoconciliar, Error SQL:".$this->io_sql->conn->ErrorMsg()." .\r\n";
		}
		
		$arrRespuesta['exito'] = $actualizo;
		$arrRespuesta['mensajeError'] = $mensajeError;
		return $arrRespuesta;
	}
	
	public function uf_calcular_saldo_libro($codban,$ctaban,$fecha) {
		$saldoDebe = 0;
		$saldoHaber = 0;
		$cadSQLDeb = "SELECT SUM(monto - monret) As mondeb, estmov
				   		FROM scb_movbco
				   		WHERE codban='{$codban}' AND ctaban='{$ctaban}' 
				   		AND (codope='NC' OR codope='DP')  
						AND ((estreglib IS NULL) or estreglib<>'A' or (estreglib='A' AND estcon=1)) 
				   		AND codemp='{$_SESSION['la_empresa']['codemp']}' AND fecmov<='{$fecha}' 
						GROUP BY estmov";
		$resDebe = $this->io_sql->execute($cadSQLDeb);
		while (!$resDebe->EOF) {
			if ($resDebe->fields['estmov'] != 'A') {
				$saldoDebe += $resDebe->fields['mondeb'];
			}
			else {
				$saldoDebe -= $resDebe->fields['mondeb'];
			}
			$resDebe->MoveNext();
		}
		unset($resDebe);
		
		$cadSQLHab = "SELECT SUM(monto - monret) As monhab,estmov
				   		FROM  scb_movbco
				   		WHERE codban='{$codban}' AND ctaban='{$ctaban}' 
				   		AND (codope='RE' OR codope='ND' OR codope='CH')
					 	AND ((estreglib IS NULL) or estreglib<>'A' OR (estreglib='A' AND estcon=1)) 
				   		AND codemp='{$_SESSION['la_empresa']['codemp']}' AND fecmov<='{$fecha}'
				   		GROUP BY estmov";
		//echo $cadSQLHab;
		$resHaber = $this->io_sql->execute($cadSQLHab);
		while (!$resHaber->EOF) {
			if ($resHaber->fields['estmov'] != 'A') {
				$saldoDebe += $resHaber->fields['monhab'];
			}
			else {
				$saldoDebe -= $resHaber->fields['monhab'];
			}
			$resHaber->MoveNext();
		}
		unset($resHaber);
		
		return $saldoDebe - $saldoHaber;
	}
	
	public function uf_buscar_cabecera_conciliacion($codban, $ctaban, $mesano) {
		$existe = false;
		$cadenaSQL = "SELECT estcon
			 	   	FROM scb_conciliacion
				  	WHERE codemp = '{$_SESSION['la_empresa']['codemp']}' AND codban ='{$codban}'
				   	AND ctaban = '{$ctaban}' AND mesano='{$mesano}'";
		$resultado = $this->io_sql->execute($cadenaSQL);
		if ($resultado->_numOfRows > 0) {
			$existe = true;
		}
		
		return $existe;
	}
	
	public function uf_guardar_cabecera_conciliacion($codban, $ctaban, $mesano, $saldoConcilia, $saldoBanco, $saldoLibro) {
		$guardo = true;
		$arrRespuesta = array();
		$mensajeError = '';
		$mesano = str_replace("/","",$mesano);
				
		if ($this->uf_buscar_cabecera_conciliacion($codban, $ctaban, $mesano)) {
			$cadenaSQL = "INSERT INTO scb_conciliacion(codemp,codban,ctaban,salseglib,salsegbco,conciliacion,mesano,estcon)
							VALUES ('{$_SESSION['la_empresa']['codemp']}','{$codban}','{$ctaban}',{$saldoLibro},{$saldoBanco},{$saldoConcilia},'{$mesano}',0)";
		}
		else {
			$cadenaSQL = "UPDATE scb_conciliacion
						   SET	salseglib={$saldoLibro},salsegbco={$saldoBanco},
						        conciliacion={$saldoConcilia},mesano='{$mesano}'
						  WHERE codban='{$codban}' AND ctaban='{$ctaban}' 
							AND codemp='{$_SESSION['la_empresa']['codemp']}' AND mesano='{$mesano}'";
		}
		
		if ($this->io_sql->execute($cadenaSQL) === false) {
			$guardo = false;
			$mensajeError = "Ocurrio un error guardando la cabecera de la conciliacion, Error SQL:".$this->io_sql->conn->ErrorMsg()." .\r\n";
		}
		
		$arrRespuesta['exito'] = $guardo;
		$arrRespuesta['mensajeError'] = $mensajeError;
		
		return $arrRespuesta;
	}
	
	public function uf_conciliar_movimientos($codban, $denban, $ctaban, $mesano, $saldoBanco, $conExterna=false)
        {
		//CREANDO DIRECTORIO Y ARCHIVO DE RESULTADO
		$directorioResultado = 'resultado_conciliacion';
		if(!file_exists ($directorioResultado))
                {
			$exito = mkdir($directorioResultado,0777);
			if(!$exito)
                        {
				$this->io_msg->message('No se pudo crear la capeta de resultados');
				return false;
			}
		}
		$arcResultado = @fopen($directorioResultado.'/resultado_conciliacion_'.date("dmY").'_'.date("H_i").'.txt',"a+");
		
		//INICILIZANDO VARIBALES
		$cadenaError   = '';
		$contRegistros = 0;
		$contConci     = 0;
		$saldoConcilia = 0;
		$saldoLibro    = 0;
		
		$mes  = substr($mesano,0,2);
		$anno = substr($mesano,3,4);
		$fechasta = $this->io_fecha->uf_last_day($mes, $anno);
		$fechasta = $this->io_fecha->uf_convert_date_to_db($fechasta);
		$fechacon = $anno.'-'.$mes.'-01';
		
		//INICIANDO PROCESO
		if (!$conExterna)
                {//CONCILIANDO CON TABLA SCB_MOVBCO
			$dataConcilian = $this->uf_obtener_movimiento_concilian($codban, $ctaban, $fechasta);
			if ($dataConcilian!==false)
                        {
				while (!$dataConcilian->EOF)
                                {
					$codban = $dataConcilian->fields['codban'];
					$ctaban = $dataConcilian->fields['ctaban'];
					$numref = $dataConcilian->fields['numref'];
					$tipmov = $dataConcilian->fields['tipmov'];
					$monto = $dataConcilian->fields['monto'];
					$arrResActMovbco = $this->uf_actualizar_movbco_estcon($codban, $ctaban, $numref, $tipmov, $fechacon); 
					if ($arrResActMovbco['exito'])
                                        {
						$arrResActMovcon = $this->uf_actualizar_movcon_estcon($codban, $ctaban, $numref, $tipmov);
						if($arrResActMovcon['exito'])
                                                {
							$contConci++;
							$saldoConcilia += $monto;
						}
						else
                                                {
							$cadenaError .= $arrResActMovcon['mensajeError'];
						}
					}
					else
                                        {
						$cadenaError .= $arrResActMovbco['mensajeError'];
					}
					$dataConcilian->MoveNext();
				}
			}
			else
                        {
				$cadenaError .= "Ocurrio un error obteniendo los movimientos que concilian, Error SQL:".$this->io_sql->conn->ErrorMsg()."\r\n";
			}
			
			//PROCESANDO SALDO LIBRO, MOV NO EN LIBRO, MOV NO EN BCO, CABECER DE CONCILIACION
			$saldoLibro    = $this->uf_calcular_saldo_libro($codban, $ctaban, $fechasta);
			$arrResNoLibro = $this->procesar_movnolibro($codban, $ctaban, $fechasta);
			$cadenaError  .= $arrResNoLibro['cadenaError'];
			$arrResNoBanco = $this->procesar_movnobanco($codban, $ctaban, $fechasta);
			$cadenaError  .= $arrResNoBanco['cadenaError'];
			$saldoBanco = str_replace('.', '', $saldoBanco);
			$saldoBanco = str_replace(',', '.', $saldoBanco);
			$arrResCon = $this->uf_guardar_cabecera_conciliacion($codban, $ctaban, $mesano, $saldoConcilia, $saldoBanco, $saldoLibro);
			$cadenaError  .= $arrResCon['mensajeError'];
			
			//ESCRIBIENDO RESULTADO DEL PROCESO
			$etiquetaBanco    = $codban.' - '.$denban;
			$cadenaResultado  = "RESULTADO DEL PROCESO DE CONCILIACION \r\n BANCO:{$etiquetaBanco} \r\n CUENTA:{$ctaban}  \r\n";
			$cadenaResultado .= "Saldo segun libro: ".number_format($saldoLibro,2,',','.').", Saldo segun banco: ".number_format($saldoBanco,2,',','.').", Saldo conciliado:".number_format($saldoConcilia,2,',','.')." \r\n";
			$cadenaResultado .= "Saldo transacciones no registradas en banco: ".number_format($arrResNoBanco['saldoNoBanco'],2,',','.')."  , Saldo transacciones no registradas en libro: ".number_format($arrResNoLibro['saldoNoLibro'],2,',','.')."  \r\n";
			$cadenaResultado .= "Errores en el proceso: \r\n".$cadenaError; 
			@fwrite($arcResultado,$cadenaResultado);
			fclose($arcResultado);
			$this->io_msg->message('El proceso de conciliacion finalizo descargue el archivo con los resultados');
		}
		else {//CONCILIANDO CON TABLA EXTERNA
			
		}
	}
}