<?php
/*
 * User Class
 * This class is used for database related (connect fetch, and insert) operations
 * @author    CodexWorld.com
 * @url       http://www.codexworld.com
 * @license   http://www.codexworld.com/license
 */
class User{
    private $dbUsername = "sigatplusadmin";
    private $dbPassword = "changepass$.";
    private $dbName     = "db_alcaldia_ccs_2024";
    private $userTbl    = "sss_usuarios";
    private $port    	= "5432";
    
    public function __construct(){
        if(!isset($this->db)){
            // Connect to the database

	    $data = "host=".$_SERVER['HTTP_HOST']." port=".$this->port." dbname=".$this->dbName." user=".$this->dbUsername." password=".$this->dbPassword;
	    $conn = pg_connect($data);
            //$conn = new mysqli($this->dbHost, $this->dbUsername, $this->dbPassword, $this->dbName);
            if($conn->connect_error){
                die("Failed to connect with PostgreSQL: " . $conn->connect_error);
            }else{
                $this->db = $conn;
            }
        }
    }
    
    /*
     * Returns rows from the database based on the conditions
     * @param string name of the table
     * @param array select, where, order_by, limit and return_type conditions
     */
    public function getRows($conditions = array()){
        $sql = 'SELECT ';
        if(array_key_exists("select",$conditions)){
            $i = 0;
            foreach($conditions['select'] as $key => $value){
                $pre = ($i > 0)?', ':'';
                $sql .= $pre.$value;
                $i++;
            }
	}else{
		$sql .= ' * ';
	}
	
        //$sql .= array_key_exists("select",$conditions)?$conditions['select']:'*';
        $sql .= ' FROM '.$this->userTbl;
        if(array_key_exists("where",$conditions)){
            $sql .= ' WHERE ';
            $i = 0;
            foreach($conditions['where'] as $key => $value){
                $pre = ($i > 0)?' AND ':'';
                $sql .= $pre.$key." = '".$value."'";
                $i++;
            }
	    $sql .= " AND codusu <> 'ADMINISTRADOR' ";
        }else{
	    $sql .= " WHERE codusu <> 'ADMINISTRADOR' ";
 	}	
        
        if(array_key_exists("order_by",$conditions)){
            $sql .= ' ORDER BY '.$conditions['order_by']; 
        }
        
        if(array_key_exists("start",$conditions) && array_key_exists("limit",$conditions)){
            $sql .= ' LIMIT '.$conditions['start'].','.$conditions['limit']; 
        }elseif(!array_key_exists("start",$conditions) && array_key_exists("limit",$conditions)){
            $sql .= ' LIMIT '.$conditions['limit']; 
        }
        $result = pg_query($sql);
        
        if(array_key_exists("return_type",$conditions) && $conditions['return_type'] != 'all'){
            switch($conditions['return_type']){
                case 'count':
                    $data = pg_fetch_row($result);
                    break;
                case 'single':
                    $data = pg_fetch_row($result);
                    break;
                default:
                    $data = '';
            }
        }else{
            if(pg_fetch_row($result) > 0){
                while($row = pg_fetch_row($result)){
                    $data[] = $row;
                }
            }
        }
        return !empty($data)?$data:false;
    }
    
    /*
     * Insert data into the database
     * @param string name of the table
     * @param array the data for inserting into the table
     */
    public function insert($data){
        if(!empty($data) && is_array($data)){
            $columns = '';
            $values  = '';
            $i = 0;
            if(!array_key_exists('created',$data)){
                $data['created'] = date("Y-m-d H:i:s");
            }
            if(!array_key_exists('modified',$data)){
                $data['modified'] = date("Y-m-d H:i:s");
            }
            foreach($data as $key=>$val){
                $pre = ($i > 0)?', ':'';
                $columns .= $pre.$key;
                $values  .= $pre."'".$val."'";
                $i++;
            }
            $query = "INSERT INTO ".$this->userTbl." (".$columns.") VALUES (".$values.")";
            $insert = $this->db->query($query);
            return $insert?$this->db->insert_id:false;
        }else{
            return false;
        }
    }
    
    /*
     * Update data into the database
     * @param string name of the table
     * @param array the data for inserting into the table
     */
    public function update($data, $conditions){
        if(!empty($data) && is_array($data) && !empty($conditions)){
            //prepare columns and values sql
            $cols_vals = '';
            $i = 0;
            if(!array_key_exists('pwdusu',$data)){
                $data['modified'] = date("Y-m-d H:i:s");
            }
            foreach($data as $key=>$val){
                $pre = ($i > 0)?', ':'';
                $cols_vals .= $pre.$key." = '".$val."'";
                $i++;
            }
            
            //prepare where conditions
            $whereSql = '';
            $ci = 0;
            foreach($conditions as $key => $value){
                $pre = ($ci > 0)?' AND ':'';
                $whereSql .= $pre.$key." = '".$value."'";
                $ci++;
            }
            if(array_key_exists('pwdusu',$data)){
	    	if ($whereSql != ''){
	    		$whereSql .= " AND date_part('MINUTE',(age(timestamp 'now()',modified)-interval '15 minute'))<=0 AND estatus<>'3'";
            	}else{
	    		$whereSql = " WHERE date_part('MINUTE',(age(timestamp 'now()',modified)-interval '15 minute'))<=0 AND estatus<>'3' ";
     	    	}	
	    }
            //prepare sql query
            $query = "UPDATE ".$this->userTbl." SET ".$cols_vals." WHERE ".$whereSql;

            //update data
            $update = pg_query($query);
	    $result=pg_affected_rows($update);
            return $result?true:false;
        }else{
            return false;
        }
    }

}
?>
