<?php
/***********************************************************************************
* @Modelo para proceso de asignacion de usuarios a sistema.
* @fecha de creacion: 30/09/2008.
* @autor: Ing.Gusmary Balza
* **************************
* @fecha modificacion  
* @autor 
* @descripcion  
***********************************************************************************/
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'].'/base/librerias/php/general/sigesp_lib_daogenerico.php');

class UsuarioSistema extends DaoGenerico
{
	public $mensaje;
	public $evento;
	public $valido=true;
	public $existe = true;
	public $nomfisico;
	private $conexionbd;

	/**
	 * @desc Metodo constructor de la clase, hace uso del constructor de la clase padre
	 * 		 para convertirse en un objeto active record del adodb
	 * @author Ing. Gerardo Cordero
	 */
	public function __construct() {
		parent::__construct ( 'sss_usuario_sistema' );
		$this->conexionbd = $this->obtenerConexionBd(); 
	}
	
	
/***********************************************************************************
* @Funcion que incluye un usuario en un sistema
* @parametros: 
* @retorno:
* @fecha de creacion: 08/08/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion: 10/10/2008
* @descripcion: Se agrego la seguridad
* @autor: Ing. Yesenia Moreno de Lang
***********************************************************************************/	
	public function incluir()
	{
		$this->mensaje='Incluyo el Usuario '.$this->codusu.' en el Sistema '.$this->codsis;
		$this->save();
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
		}
		$this->incluirSeguridad('INSERTAR',$this->valido);
	}

	
/***********************************************************************************
* @Funcion que Elimina el usuario de un sistema
* @parametros: 
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	public function eliminar()
	{
		$this->mensaje='Elimino el Usuario '.$this->codusu.' del Sistema '.$this->codsis;
		$this->delete();
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
		}
		$this->incluirSeguridad('ELIMINAR',$this->valido);
	}

	
/***********************************************************************************
* @Funcion que Elimina todos los usuarios de un Sistema
* @parametros: 
* @retorno:
* @fecha de creacion: 14/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/	
	public function eliminarTodos()
	{
		$this->mensaje='Elimino los Usuarios del Sistema '.$this->codsis;
		$consulta = "DELETE FROM $this->_table ".
					" WHERE codemp = '$this->codemp' ".
					"   AND codsis = '$this->codsis' ";
		$result = $this->conexionbd->Execute($consulta);
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg;
		}
		$this->incluirSeguridad('ELIMINAR',$this->valido);
	}	
	
	
/***************************************************************************
* @Funcion que verifica si un usuario está en un sistema
* @parametros: 
* @retorno:
* @fecha de creacion: 06/08/2008
* @autor: Ing. Gusmary Balza
***************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
****************************************************************************/		
	function buscarUsuarioSistema()
	{
		try
		{	
			$consulta = " SELECT codsis,codusu ". 
						" FROM $this->_table ".
						" WHERE codemp='{$this->codemp}' ".
						" AND codusu='{$this->codusu}' ";
			$result = $this->conexionbd->Execute($consulta);
			if ($result->EOF)
			{
				$this->existe = false;
			}			
		}
		catch (exception $e) 
		{
			$this->valido  = false;	
			$this->mensaje='Error al consultar el Usuario '.$this->codusu.' en los Sistemas '.' '.$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('CONSULTAR',$this->valido);
		}
	}
	
/***********************************************************************************
* @Funcion que Incluye el registro de la transaccion exitosa
* @parametros: $evento
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function incluirSeguridad($evento,$tipotransaccion)
	{
		if($tipotransaccion) // Transaccion Exitosa
		{
			$objEvento = new RegistroEventos();
		}
		else // Transaccion fallida
		{
			$objEvento = new RegistroFallas();
		}
		// Registro del Evento
		$objEvento->codemp = $this->codemp;
		$objEvento->codsis = 'SSS';
		$objEvento->nomfisico = $this->nomfisico;
		$objEvento->evento = $evento;
		$objEvento->desevetra = $this->mensaje;
		$objEvento->incluir();
		unset($objEvento);
	}	
}
?>
