<?php
/***********************************************************************************
* @Modelo para proceso de asignacion de usuarios a grupo.
* @fecha de creacion: 30/09/2008.
* @autor: Ing.Gusmary Balza
* **************************
* @fecha modificacion  
* @autor 
* @descripcion  
***********************************************************************************/
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'].'/base/librerias/php/general/sigesp_lib_daogenerico.php');
require_once('sigesp_dao_sss_registroeventos.php');
require_once('sigesp_dao_sss_registrofallas.php');

class UsuarioGrupo extends DaoGenerico
{
	public $mensaje;
	public $valido = true;
	public $existe = true;
	public $codsis;
	public $nomfisico;
	private $conexionbd;

	/**
	 * @desc Metodo constructor de la clase, hace uso del constructor de la clase padre
	 * 		 para convertirse en un objeto active record del adodb
	 * @author Ing. Gerardo Cordero
	 */
	public function __construct() {
		parent::__construct ( 'sss_usuarios_en_grupos' );
		$this->conexionbd = $this->obtenerConexionBd(); 
	}
	
	
/***********************************************************************************
* @Funcion que incluye un usuario en un grupo
* @parametros: 
* @retorno:
* @fecha de creacion: 08/08/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion: 10/10/2008
* @descripcion: Se agrego la seguridad
* @autor: Ing. Yesenia Moreno de Lang
***********************************************************************************/	
	public function incluir()
	{
		$this->mensaje='Incluyo el Usuario '.$this->codusu.' en el Grupo '.$this->nomgru;
		$this->save();
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
		}
		$this->incluirSeguridad('INSERTAR',$this->valido);
	}

	
/***********************************************************************************
* @Funcion que Elimina el usuario de un Grupo
* @parametros: 
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/	
	public function eliminar()
	{
		$this->mensaje='Elimino el Usuario '.$this->codusu.' del Grupo '.$this->nomgru;
		$this->delete();
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
		}
		$this->incluirSeguridad('ELIMINAR',$this->valido);
	}	
	

/***********************************************************************************
* @Funcion que Elimina todos los usuarios de un Grupo
* @parametros: 
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/	
	public function eliminarTodos()
	{
		$this->mensaje='Elimino los Usuarios del Grupo '.$this->nomgru;
		$consulta = "DELETE FROM $this->_table ".
					" WHERE codemp = '$this->codemp' ".
					"   AND nomgru = '$this->nomgru' ";
		$result = $this->conexionbd->Execute($consulta);
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg;
		}
		$this->incluirSeguridad('ELIMINAR',$this->valido);
	}

	
/***************************************************************************
* @Funcion que Busca si un usuario esta asignado a un grupo
* @parametros: 
* @retorno:
* @fecha de creacion: 03/09/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
******************************************************************************/			
	function buscarUsuarioGrupo()
	{
		try
		{
			$consulta = " SELECT nomgru,codusu ".
						"   FROM $this->_table ".
						"  WHERE codemp = '{$this->codemp}' ".
						"    AND codusu = '{$this->codusu}' ";	
			$result = $this->conexionbd->Execute($consulta); 
			if ($result->EOF)
			{
				$this->existe = false;	
			}
			$result->Close();			 
		}
		catch (exception $e) 
		{
			$this->valido  = false;	
			$this->mensaje='Error al consultar el Usuario'.$this->codusu.' en los Grupos '.' '.$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('CONSULTAR',$this->valido);
		}
	}
	
	
/***********************************************************************************
* @Funcion que Incluye el registro de la transaccion exitosa
* @parametros: $evento
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function incluirSeguridad($evento,$tipotransaccion)
	{
		if($tipotransaccion) // Transaccion Exitosa
		{
			$objEvento = new RegistroEventos();
		}
		else // Transaccion fallida
		{
			$objEvento = new RegistroFallas();
		}
		// Registro del Evento
		$objEvento->codemp = $this->codemp;
		$objEvento->codsis = $this->codsis;
		$objEvento->nomfisico = $this->nomfisico;
		$objEvento->evento = $evento;
		$objEvento->desevetra = $this->mensaje;
		$objEvento->incluir();
		unset($objEvento);
	}
}
?>
