<?php
/***********************************************************************************
* @Modelo para la definicion de Sistema Ventana. 
* de datos.
* @fecha de creacion:: 30/09/2008.
* @autor: Ing.Gusmary Balza
* **************************
* @fecha modificacion  10/10/2008
* @autor  Ing. Yesenia Moreno de Lang
* @descripcion  Se agrego la seguridad y manejo de errores
***********************************************************************************/

require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'].'/base/librerias/php/general/sigesp_lib_daogenerico.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'].'/modelo/sss/sigesp_dao_sss_registroeventos.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'].'/modelo/sss/sigesp_dao_sss_registrofallas.php');

class SistemaVentana extends DaoGenerico
{
	public $valido = true;
	public $mensaje;
	public $criterio;
	public $campo;
	public $arrsistema = array();
	private $conexionbd;
	
	/**
	 * @desc Metodo constructor de la clase, hace uso del constructor de la clase padre
	 * 		 para convertirse en un objeto active record del adodb
	 * @author Ing. Gerardo Cordero
	 */
	public function __construct()
	{
		parent::__construct ( 'sss_sistemas_ventanas' );
		$this->conexionbd = $this->obtenerConexionBd(); 
	}
	
/***********************************************************************************
* @Funcion para insertar las ventanas por sistema
* @parametros: 
* @retorno:
* @fecha de creacion:: 02/10/2008.
* @autor: Ing.Gusmary Balza
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/			
	function incluir()
	{
		$this->save();	
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('INSERTAR',$this->valido);
		}
	}

/***********************************************************************************
* @Funcion para insertar las ventanas por sistema
* @parametros: 
* @retorno:
* @fecha de creacion:: 02/10/2008.
* @autor: Ing.Gusmary Balza
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/			
	function modificar()
	{
		$this->Replace();	
		if($this->conexionbd->HasFailedTrans())
		{
			$this->valido  = false;	
			$this->mensaje=$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('ACTUALIZAR',$this->valido);
		}
	}
	
/***********************************************************************************
* @Funcion que busca el Codigo del sistema ventana
* @parametros: 
* @retorno: 
* @fecha de creacion:: 09/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerCodigoMenu()
	{
            $codmenu="";
		$consulta = "SELECT codmenu ".
					"  FROM $this->_table ".
					" WHERE $this->_table.codsis = '$this->codsis' ".
					"	AND $this->_table.nomfisico ='$this->nomfisico' ";
		$result = $this->conexionbd->Execute($consulta); 
		if($result === false)
		{
			$this->valido  = false;
		}
		else
		{
			if(!$result->EOF)
			{   
				$codmenu=$result->fields["codmenu"];
			}
			$result->Close();
		}
		return $codmenu;
	}
	
	
/***********************************************************************************
* @Funcion que busca especificacmente si una opcion de menu es valida o no 
* @parametros: 
* @retorno: 
* @fecha de creacion:: 12/11/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function verificarCampoMenu()
	{
		$campo=0;
		$consulta = "SELECT codmenu ".
					"  FROM $this->_table ".
					" WHERE $this->_table.codsis = '$this->codsis' ".
					"	AND $this->_table.codmenu = '$this->codmenu' ".
					"   AND $this->_table.$this->campo = '1'";
		$result = $this->conexionbd->Execute($consulta); 
		if($result === false)
		{
			$this->valido  = false;
		}
		else
		{
			if(!$result->EOF)
			{   
				$campo=1;
			}
			$result->Close();
		}
		return $campo;
	}
	
	
	
/***********************************************************************************
* @Funcion que busca las opciones de menu segun el usuario
* @parametros: 
* @retorno: 
* @fecha de creacion:: 28/08/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerMenuUsuario()
	{
		$consulta = "SELECT $this->_table.codmenu, $this->_table.codsis, nomlogico, nomfisico, codpadre, nivel, hijo, marco, orden, ".
					" $this->_table.visible,$this->_table.enabled,$this->_table.leer,$this->_table.incluir,$this->_table.cambiar,$this->_table.eliminar,$this->_table.imprimir,$this->_table.administrativo,".
					" $this->_table.anular,$this->_table.ejecutar,$this->_table.ayuda,$this->_table.cancelar,$this->_table.enviarcorreo, $this->_table.descargar,  1 as valido ".
					"  FROM $this->_table ".
					" WHERE $this->_table.hijo = 1 ".
					"   AND $this->_table.codsis = '$this->codsis' ".
					"   AND $this->_table.visible = 1 ".
					"   AND $this->_table.enabled = 1 ".
					" UNION ".
					" SELECT $this->_table.codmenu, $this->_table.codsis, nomlogico, nomfisico, codpadre, nivel, hijo, marco, orden, ".
					" $this->_table.visible,$this->_table.enabled,$this->_table.leer,$this->_table.incluir,$this->_table.cambiar,$this->_table.eliminar,$this->_table.imprimir,$this->_table.administrativo,".
					" $this->_table.anular,$this->_table.ejecutar,$this->_table.ayuda,$this->_table.cancelar,$this->_table.enviarcorreo, $this->_table.descargar, 1 as valido ".
					"  FROM $this->_table ".
					" INNER JOIN sss_derechos_usuarios ".
					"    ON $this->_table.hijo = 0 ".
					"   AND $this->_table.codsis = '$this->codsis' ".
					"   AND sss_derechos_usuarios.codusu = '$this->codusu' ".
					"   AND sss_derechos_usuarios.enabled = 1 ". 
					"   AND sss_derechos_usuarios.visible = 1 ". 
					"   AND $this->_table.codsis = sss_derechos_usuarios.codsis ".
					"   AND $this->_table.codmenu = sss_derechos_usuarios.codmenu ".
					" ORDER BY nivel, orden";
		$result = $this->conexionbd->Execute($consulta); 
		return $result;
	}
	
	
/***********************************************************************************
* @Funcion que busca las funcionalidades del menu
* @parametros: 
* @retorno: 
* @fecha de creacion:: 07/11/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerOpcionesMenu()
	{
		$consulta = "SELECT $this->_table.codmenu, $this->_table.codsis, nomlogico, nomfisico, codpadre, nivel, hijo, marco, orden, ".
					" 		$this->_table.visible,$this->_table.enabled,$this->_table.leer,$this->_table.incluir,$this->_table.cambiar,$this->_table.eliminar,$this->_table.imprimir,$this->_table.administrativo,".
					" 		$this->_table.anular,$this->_table.ejecutar,$this->_table.ayuda,$this->_table.cancelar,$this->_table.enviarcorreo, $this->_table.descargar, 1 as valido ".
					"  FROM $this->_table ".				
					" WHERE $this->_table.codsis='$this->codsis'".
			        "   AND $this->_table.enabled=1 ".
			        "   AND $this->_table.visible=1 "; 								   
		$cadena=" ";
        $total = count($this->criterio);
        for ($contador = 0; $contador < $total; $contador++)
		{
          	$cadena.= $this->criterio[$contador]['operador']." ".$this->criterio[$contador]['criterio']." ".
 		               $this->criterio[$contador]['condicion']." ".$this->criterio[$contador]['valor']." ";
        }
        $consulta.= $cadena;
        $consulta.= "ORDER BY codmenu, nomlogico";
		$result = $this->conexionbd->Execute($consulta); 
		return $result;
	}
		
	
/***********************************************************************************
* @Funcion que busca las opciones de la Barra de Herramientas segun el usuario
* @parametros: 
* @retorno: 
* @fecha de creacion:: 29/08/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerBarraHerramientaUsuario()
	{
		$consulta = "SELECT $this->_table.codmenu, $this->_table.codsis, MAX(sss_derechos_usuarios.visible) AS visible, MAX(sss_derechos_usuarios.leer) as leer, ".
					"       MAX(sss_derechos_usuarios.incluir) as incluir, MAX(sss_derechos_usuarios.cambiar) as cambiar, MAX(sss_derechos_usuarios.eliminar) as eliminar, ".
					"       MAX(sss_derechos_usuarios.imprimir) as imprimir, MAX(sss_derechos_usuarios.anular) as anular, MAX(sss_derechos_usuarios.ejecutar) as ejecutar, ".
					"       MAX(sss_derechos_usuarios.administrativo) as administrativo, MAX(sss_derechos_usuarios.ayuda) as ayuda, MAX(sss_derechos_usuarios.cancelar) as cancelar, ".
					"       MAX(sss_derechos_usuarios.descargar) as descargar ".
					"  FROM $this->_table ".
					" INNER JOIN sss_derechos_usuarios ".
					"    ON $this->_table.hijo = 0 ".
					"   AND $this->_table.codsis = '$this->codsis' ".
					"   AND $this->_table.nomfisico = '$this->nomfisico' ".
					"   AND sss_derechos_usuarios.codusu = '$this->codusu' ".
					"   AND sss_derechos_usuarios.visible = '1' ". 
					"   AND $this->_table.codsis = sss_derechos_usuarios.codsis ".
					"   AND $this->_table.codmenu = sss_derechos_usuarios.codmenu ".
					" GROUP BY $this->_table.codmenu, $this->_table.codsis, nivel, orden ".										
					" ORDER BY codmenu,codsis, nivel, orden";
		$result = $this->conexionbd->Execute($consulta); 
		return $result;
	}
	

/****************************************************************************
* @Funcion que Verifica que el usuario tenga acceso a la funcionalidad y 
* a la accion que proceso
* @parametros: 
* @retorno: Verdadero o false segun la permisologia
* @fecha de creacion:: 03/09/2008
* @autor: Ing. Yesenia Moreno de Lang
*****************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
*******************************************************************************/		
	public function verificarUsuario()
	{
		$usuariovalido = false;
		$consulta = "SELECT $this->_table.codmenu ".
					"  FROM $this->_table ".
					" INNER JOIN sss_derechos_usuarios ".
					"    ON $this->_table.hijo = 0 ".
					"   AND $this->_table.codsis = '$this->codsis' ".
					"   AND $this->_table.nomfisico = '$this->nomfisico' ".
					"   AND sss_derechos_usuarios.codusu = '$this->codusu' ".
					"   AND sss_derechos_usuarios.visible = '1' ". 
					"   AND sss_derechos_usuarios.$this->campo = '1' ". 
					"   AND $this->_table.codsis = sss_derechos_usuarios.codsis ".
					"   AND $this->_table.codmenu = sss_derechos_usuarios.codmenu ";
		$result = $this->conexionbd->Execute($consulta); 
		if(!$result->EOF)
		{   
			$usuariovalido=true;
		}
		$result->Close();
		return $usuariovalido;
	}
	
	
/****************************************************************************
* @Funcion que obtiene las opciones de menu de un usuario y funcionalidad
* @parametros: 
* @retorno: Verdadero o false segun la permisologia
* @fecha de creacion:: 03/09/2008
* @autor: Ing. Gusmary Balza
*****************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
*******************************************************************************/		
	function obtenerMenu()
	{
		try
		{
			$consulta = " SELECT $this->_table.codmenu, $this->_table.codsis, nomlogico, $this->_table.visible,$this->_table.enabled,".
						" 		 $this->_table.leer,$this->_table.incluir,$this->_table.cambiar,$this->_table.eliminar,".
						" 		 $this->_table.imprimir,$this->_table.administrativo,$this->_table.anular, ".
						" 		 $this->_table.ejecutar,$this->_table.ayuda,$this->_table.cancelar,$this->_table.enviarcorreo, ".
						"        $this->_table.descargar, 1 as valido".
						"   FROM $this->_table ".
						"  WHERE $this->_table.hijo = 0 ".
						"    AND $this->_table.codsis = '$this->codsis' ".
						"    AND $this->_table.codmenu = $this->codmenu ";
			 
			$result = $this->conexionbd->Execute($consulta);
			return $result;
		}
		catch (exception $e) 
		{ 
			$this->valido  = false;	
			$this->mensaje='Error al consultar el meNro de la funcionalidad '.$consulta.' '.$this->conexionbd->ErrorMsg();
	   	} 	
	}
	
/***********************************************************************************
* @Funcion que busca en los arboles de seguridad y los inserta en Sistema Ventana
* @parametros: 
* @retorno: 
* @fecha de creacion:: 21/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	public function ActualizarMenu()
    {   
		try
		{
			$total=	count($this->arrsistema);
			$this->actualizarData();
			for ($contsis=0; $contsis < $total; $contsis++)
			{	
				$nuevo=false;
				$codsis = $this->arrsistema[$contsis];
				$codsisaux = strtolower($codsis);
				$ext='.php';
				$ruta='../../sss/arbol/sigesp_arbol_';
				$version2=false;
				if (($codsisaux == 'apr') || ($codsisaux == 'sss')|| ($codsisaux == 'sfd'))
				{
					$ruta='../../controlador/sss/arbol/';
					$version2=true;
				}
				if ($codsisaux == 'cfg')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/cfg/sigesp_vis_cfg_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'mis')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/mis/sigesp_vis_mis_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'rpc')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/rpc/sigesp_vis_rpc_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'spg')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/spg/sigesp_vis_spg_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'scg')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/scg/sigesp_vis_scg_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'scf')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/scf/sigesp_vis_scf_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				/*if ($codsisaux == 'spi')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/spi/sigesp_vis_spi_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}
				if ($codsisaux == 'sep')
				{
					$accsis=$this->obtenerTipoSistema($codsis);
					if($accsis=='vista/sep/sigesp_vis_sep_principal.html')
					{
						$ruta='../../controlador/sss/arbol/';
						$version2=true;
					}
				}*/
				if(file_exists($ruta.$codsisaux.$ext))
				{
					include($ruta.$codsisaux.$ext);					
					for ($contador = 1; $contador <= $gi_total; $contador++)
					{
						$codpadre=0;
						if (intval($arbol['padre'][$contador])>0)
						{
							$padre=intval($arbol['padre'][$contador]);
							$this->codsis= $codsis;
							$this->nomlogico=$arbol['nombre_logico'][$padre];
							$this->nomfisico=$arbol['nombre_fisico'][$padre];
							if (trim($this->nomfisico)=='')
							{
								$this->nomfisico=' ';
							}
							$codpadre=$this->obtenerCodigo();
						}
						$hijo = 0;
						if (intval($arbol['numero_hijos'][$contador])>0)
						{
							$hijo = 1;
						}
						$this->actualizarNombreLogico($codsis,$arbol['nombre_logico'][$contador],$arbol['nombre_fisico'][$contador]);
						$obj = new SistemaVentana();
						$obj->codsis    = $codsis;
						$obj->nomlogico = $arbol['nombre_logico'][$contador];
						$obj->nomfisico = $arbol['nombre_fisico'][$contador];
						if (trim($obj->nomfisico)=='')
						{
							$obj->nomfisico=' ';
						}
						$codmenu=$obj->obtenerCodigo();
						if($codmenu>0)
						{
							$obj->codmenu   = $codmenu;	
						}
						else
						{
							$obj->codmenu   = $obj->obtenerCodigoMenuFinal();
							$nuevo=true;	
						}
						$obj->codpadre  = $codpadre;
						$obj->nivel     = $arbol['nivel'][$contador]+1;
						$obj->hijo      = $hijo;
						$obj->marco     = 'principal';
						$obj->orden     = $arbol['id'][$contador];
						$obj->visible   = 1;
						$obj->enabled   = 1;
						$obj->leer      = 1;
						$obj->incluir   = 1;
						$obj->cambiar   = 1;
						$obj->eliminar  = 1;
						$obj->imprimir  = 1;
						$obj->administrativo = 1;
						$obj->anular         = 1;
						$obj->ejecutar       = 1;
						$obj->ayuda          = 1;
						$obj->cancelar       = 1;
						$obj->enviarcorreo   = 0;
						$obj->descargar      = 1;
						if ($version2)
						{
							$obj->visible   = $arbol['visible'][$contador];
							$obj->enabled   = $arbol['enabled'][$contador];
							$obj->leer      = $arbol['leer'][$contador];
							$obj->incluir   = $arbol['incluir'][$contador];
							$obj->cambiar   = $arbol['cambiar'][$contador];
							$obj->eliminar  = $arbol['eliminar'][$contador];
							$obj->imprimir  = $arbol['imprimir'][$contador];
							$obj->administrativo = $arbol['administrativo'][$contador];
							$obj->anular         = $arbol['anular'][$contador];
							$obj->ejecutar       = $arbol['ejecutar'][$contador];
							$obj->ayuda          = $arbol['ayuda'][$contador];
							$obj->cancelar       = $arbol['cancelar'][$contador];
							$obj->enviarcorreo   = $arbol['enviarcorreo'][$contador];
							$obj->descargar      = $arbol['descargar'][$contador];
						}
						if($nuevo)
						{
							$obj->incluir();
						}
						else
						{
                                                    $obj->modificar();
						}
						$nuevo=false;
				    	unset($obj);		    	
					}
				}
			}		
		}
		catch (exception $e) 
		{ 
			$this->valido  = false;	
			$this->mensaje='Error al Actualizar el meNro ';
	   	}
    }
    
/***********************************************************************************
* @Funcion que busca el Codigo del padre
* @parametros: 
* @retorno: 
* @fecha de creacion:: 01/11/2011
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerCodigo()
	{
		$codmenu=0;
		$consulta = "SELECT codmenu ".
					"  FROM $this->_table ".
					" WHERE $this->_table.codsis = '$this->codsis' ".
					"   AND $this->_table.nomlogico = '$this->nomlogico' ".
					"	AND $this->_table.nomfisico = '$this->nomfisico' ";
		$result = $this->conexionbd->Execute($consulta); 
		if($result === false)
		{
			$this->valido  = false;
		}
		else
		{
			if(!$result->EOF)
			{   
				$codmenu=$result->fields["codmenu"];
			}
			$result->Close();
		}
		return $codmenu;
	}    

    
/***********************************************************************************
* @Funcion que busca el el ultimo Codigo Menu
* @parametros: 
* @retorno: 
* @fecha de creacion:: 01/11/2011
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function obtenerCodigoMenuFinal()
	{
		$codmenu=0;
		$consulta = "SELECT codmenu ".
					"  FROM $this->_table ".
					"ORDER BY codmenu DESC";
		$result = $this->conexionbd->Execute($consulta); 
		if($result === false)
		{
			$this->valido  = false;
		}
		else
		{
			if(!$result->EOF)
			{   
				$codmenu=$result->fields["codmenu"]+1;
			}
			$result->Close();
		}
		return $codmenu;
	}    	

/***********************************************************************************
* @Funcion que busca el Codigo del sistema ventana
* @parametros: 
* @retorno: 
* @fecha de creacion:: 09/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function actualizarData()
	{
		$consulta = "UPDATE $this->_table SET nomfisico=' ' ".
					" WHERE trim(nomfisico) ='' ";
		$result = $this->conexionbd->Execute($consulta); 
		
		$consulta = "UPDATE $this->_table SET nomlogico=replace(nomlogico,'á','a')";
		$result = $this->conexionbd->Execute($consulta); 

		$consulta = "UPDATE $this->_table SET nomlogico=replace(nomlogico,'é','e')";
		$result = $this->conexionbd->Execute($consulta); 

		$consulta = "UPDATE $this->_table SET nomlogico=replace(nomlogico,'Ã','í')";
		$result = $this->conexionbd->Execute($consulta); 
		
		$consulta = "UPDATE $this->_table SET nomlogico=replace(nomlogico,'o','o')";
		$result = $this->conexionbd->Execute($consulta); 
		
		$consulta = "UPDATE $this->_table SET nomlogico=replace(nomlogico,'ú','u')";
		$result = $this->conexionbd->Execute($consulta); 

	}
/***********************************************************************************
* @Funcion que busca el Codigo del sistema ventana
* @parametros: 
* @retorno: 
* @fecha de creacion:: 09/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	public function actualizarNombreLogico($codsis,$nomlogico,$nomfisico)
	{
		$consulta = "UPDATE sss_sistemas_ventanas SET nomlogico = REPLACE(nomlogico,'�','�')";
		$result = $this->conexionbd->Execute($consulta); 
		if(trim($nomfisico)<>'')
		{
			$consulta = "UPDATE $this->_table ".
						"   SET nomlogico='$nomlogico' ".
						" WHERE $this->_table.codsis = '$codsis' ".
						"	AND $this->_table.nomfisico = '$nomfisico' ";
			$result = $this->conexionbd->Execute($consulta); 
		}
	}

	public function obtenerTipoSistema($codsis)
	{
		$accsis='';
		$consulta = "SELECT accsis ".
					"  FROM sss_sistemas ".
					" WHERE codsis = '".strtoupper($codsis)."' ";
		$result = $this->conexionbd->Execute($consulta); 
		if($result === false)
		{
			$this->valido  = false;
		}
		else
		{
			if(!$result->EOF)
			{   
				$accsis=$result->fields["accsis"];
			}
			$result->Close();
		}
		return $accsis;
	}  	
	
/***********************************************************************************
* @Funcion que Incluye el registro de la transacci�n exitosa
* @parametros: $evento
* @retorno:
* @fecha de creacion:: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha  modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function incluirSeguridad($evento,$tipotransaccion)
	{
		if($tipotransaccion)
		{
			$objEvento = new RegistroEventos();
			$tiponotificacion = 'NOTIFICACION';
		}
		else
		{
			$objEvento = new RegistroFallas();
			$tiponotificacion = 'ERROR';
		}
		// Registro del Evento
		$objEvento->codemp = $this->codemp;
		$objEvento->codsis = 'SSS';
		$objEvento->nomfisico = $this->nomfisico;
		$objEvento->evento = $evento;
		$objEvento->desevetra = $this->mensaje;
		$objEvento->incluir();
		// Env�o de Notificaci�n
		$objEvento->objNotificacion->codemp=$this->codemp;
		$objEvento->objNotificacion->sistema=$this->codsis;
		$objEvento->objNotificacion->tipo=$tiponotificacion;
		$objEvento->objNotificacion->titulo='ACTUALIZAR MENU';
		$objEvento->objNotificacion->usuario=$_SESSION['la_logusr'];
		$objEvento->objNotificacion->operacion=$this->mensaje;
		$objEvento->objNotificacion->enviarNotificacion();
		unset($objEvento);
	}
	
}	
?>