<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/spi/sigesp_srv_spi_imod_presupuestaria.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv."/modelo/servicio/mis/sigesp_srv_mis_comprobante.php");
require_once ($dirsrv."/modelo/servicio/mis/sigesp_srv_mis_comprobantespi.php");

class ServicioModificacionPresupuestaria implements IModificacionPresupuestaria {

	public  $mensaje; 
	public  $valido; 
	private $conexionbd; 
	private $daoComprobante;
	
	public function ServicioModificacionPresupuestaria() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoComprobante = null;
		$this->conexionbd  = ConexionBaseDatos::getInstanciaConexion();
//		$this->conexionbd->debug=true;
	}
	
	public function buscarUltNumCom($codemp,$procede)
	{
		$numero='';	
		$cadenaSQL = " SELECT comprobante ".
					"  FROM  sigesp_cmp_md   ".
					"  WHERE codemp = '{$codemp}' ".
					"	 AND procede ='{$procede}' ".
		            "  ORDER BY comprobante DESC LIMIT 1";
		$resultado = $this->conexionbd->Execute($cadenaSQL);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MTODO->buscarUltNumComAum ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$resultado->EOF){
				$numero=$resultado->fields['comprobante'];
			}
			else{
				$numero='000000000000000';
			}
		}
		return $numero;
	}
	
	public function buscarComprobantes($codemp,$comprobante,$procede,$fechades,$fechahas)
    {
    	$cadenaFiltro = '';
    	if (!empty($fechades) && !empty($fechahas)){
			$fechades = convertirFechaBd($fechades);
			$fechahas = convertirFechaBd($fechahas);
			$cadenaFiltro = $cadenaFiltro." AND fecha BETWEEN '{$fechades}' AND '{$fechahas}'";
		}
		$cadenaSQL=" SELECT procede,comprobante,descripcion,fecha,cod_pro,ced_bene,estapro,total ".
		           " FROM sigesp_cmp_md  ".
		           " WHERE codemp='".$codemp."' ".
				   "   AND comprobante like '%".$comprobante."%'".
				   "   AND procede ='".$procede."' ".$cadenaFiltro;
		$resultado = $this->conexionbd->Execute($cadenaSQL);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MTODO->buscarComprobantes ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
    	return $resultado;
	}
	
	public function buscarDetalleComprobantes($codemp,$comprobante,$procede,$fecha)
    {
    	$fecha=convertirFechaBd($fecha);
    	$cadenaSQL=" SELECT DISTINCT DT.spi_cuenta as spi_cuenta,C.denominacion as denominacion,DT.procede_doc as procede_doc, ".
          		   " 		P.desproc as desproc,DT.documento as documento,DT.operacion as operacion, ".
				   "		DT.descripcion as descripcion,DT.monto as monto,DT.orden as orden, ".
				   "        OP.denominacion as denominacion, ".
				   "        DT.codestpro1, DT.codestpro2, DT.codestpro3, DT.codestpro4, DT.codestpro5, DT.estcla ".
  		    	   " FROM spi_dtmp_cmp DT,spi_cuentas C, sigesp_procedencias P,spi_operaciones OP ".
		    	   " WHERE DT.procede=P.procede ".
				   "   AND DT.codemp=C.codemp   ".
				   "   AND DT.spi_cuenta=C.spi_cuenta   ".
				   "   AND OP.operacion = DT.operacion  ".
				   "   AND DT.codemp='".$codemp."'  ".
				   "   AND DT.procede='".$procede."' ".
				   "   AND DT.comprobante='".$comprobante."' ".
				   "   AND DT.fecha='".$fecha."' ".
				   " ORDER BY DT.orden ";
		$resultado = $this->conexionbd->Execute($cadenaSQL);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MTODO->buscarDetalleComprobantes ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
    	return $resultado;
	}
	
	public function buscarDetalleContable($codemp,$comprobante,$procede,$fecha)
    {
    	$fecha=convertirFechaBd($fecha);
    	$cadenaSQL=" SELECT DISTINCT DT.sc_cuenta as sc_cuenta,C.denominacion as denominacion,DT.procede_doc as procede_doc,P.desproc as despro,".
               	   "        DT.documento as documento,DT.fecha as fecha,DT.debhab as debhab,DT.descripcion as descripcion,DT.monto as monto,DT.orden as orden " .
				   " FROM scg_dtmp_cmp DT,scg_cuentas C, sigesp_procedencias P ".
				   " WHERE DT.codemp='".$codemp."' AND DT.procede='".$procede."' AND DT.comprobante='".$comprobante."' AND ".
				   "       DT.fecha= '".$fecha."' AND DT.sc_cuenta=C.sc_cuenta AND DT.procede=P.procede ".
				   " ORDER BY DT.orden ";
		$resultado = $this->conexionbd->Execute($cadenaSQL);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MTODO->buscarDetalleContable ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
    	return $resultado;
	}
	
	public function existeComprobante($codemp,$procede,$comprobante,$fecha) 
	{
		$existe = false;
		$cadenaSql = "SELECT comprobante ".
					 "	FROM sigesp_cmp_md ".
					 " WHERE codemp='{$codemp}' ".
					 "   AND procede='{$procede}' ".
					 "   AND comprobante='{$comprobante}' ".
					 "   AND fecha='{$fecha}' ";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if (!$dataSet->EOF)
			{
				$existe = true;
			}
		}
		return $existe;
	}
	
	public function existeCierreSPI()
	{
		$existe = false;
		$cadenaSql = "SELECT estciespi ".
					 "	FROM sigesp_empresa ".
					 " WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
					 "   AND estciespi=1";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if (!$dataSet->EOF)
			{
				$existe = true;
				$this->mensaje .= '  -> Ya se realizo el cierre presupuestario de ingreso no se pueden registrar movimientos de este tipo';
				$this->valido = false;
			}
		}
		unset($dataSet);
		return $existe;
	}

	public function existeCuenta() 
	{
		$existe = false;
		$cadenaSql = "SELECT status ".
					 "	FROM spi_cuentas ".
					 " WHERE codemp='".$this->daoDetalleSpi->codemp."' ".
					 "   AND trim(spi_cuenta)='".$this->daoDetalleSpi->spi_cuenta."' ";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if (!$dataSet->EOF)
			{
				$status = $dataSet->fields['status']; 
				if($status==='C')
				{
					$existe = true;
				}
				else
				{
					$this->mensaje .= '  -> La cuenta '.$this->daoDetalleSpi->spi_cuenta.'::'.formatoprogramatica($this->daoDetalleSpi->codestpro1.$this->daoDetalleSpi->codestpro2.$this->daoDetalleSpi->codestpro3.$this->daoDetalleSpi->codestpro4.$this->daoDetalleSpi->codestpro5).'::'.$this->daoDetalleSpi->estcla.' No es de movimiento';
					$this->valido = false;
				}
			}
			else
			{
				$this->mensaje .= '  -> La cuenta '.$this->daoDetalleSpi->spi_cuenta.'::'.formatoprogramatica($this->daoDetalleSpi->codestpro1.$this->daoDetalleSpi->codestpro2.$this->daoDetalleSpi->codestpro3.$this->daoDetalleSpi->codestpro4.$this->daoDetalleSpi->codestpro5).'::'.$this->daoDetalleSpi->estcla.' No existe en la estructura ';
				$this->valido = false;
			}
		}
		unset($dataSet);
		return $existe;
	}
	
	public function existeReverso($operacion)
	{
		$existe=false;
		$operacion_reverso = "";
		if(trim($operacion) == "AU")
		{
		 	$operacion_reverso = "DI";
		}
		elseif(trim($operacion) == "DI")
		{
		  	$operacion_reverso = "AU";
		}
		$cadenaSql=" SELECT * ".
		        "    FROM spi_dtmp_cmp   ".
				"    WHERE codemp = '".$this->daoDetalleSpi->codemp."' ".
				"      AND procede = '".$this->daoDetalleSpi->procede."' ".
				"      AND operacion = '".$operacion_reverso."' ".
				"      AND comprobante = '".$this->daoDetalleSpi->comprobante."' ".
				"      AND fecha = '".$this->daoDetalleSpi->fecha."'  ".
				"      AND codestpro1='".$this->daoDetalleSpi->codestpro1."' ".
				"      AND codestpro2='".$this->daoDetalleSpi->codestpro2."' ".
				"      AND codestpro3='".$this->daoDetalleSpi->codestpro3."' ".
				"      AND codestpro4='".$this->daoDetalleSpi->codestpro4."' ".
				"      AND codestpro5='".$this->daoDetalleSpi->codestpro5."' ".
				"      AND estcla='".$this->daoDetalleSpi->estcla."' ".
				"      AND spi_cuenta = '".$this->daoDetalleSpi->spi_cuenta."'".
				"      AND procede_doc = '".$this->daoDetalleSpi->procede_doc."'".
				"      AND documento = '".$this->daoDetalleSpi->documento."'";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
        else
		{
			if(!$dataSet->EOF) 
			{ 
				$existe=true;
			}  
		}//fin del else	
		return 	$existe;	
	}
	
	public function existeMovimiento($tipo_comp)
	{
 	    $existe=false;
 	    $monto=0;
 	    $orden=0;
		if(($this->estmodprog==1)&&($tipo_comp=='2'))
		{
			$mes=substr($cabecera->fecha,5,2);
			$cadenaSql="SELECT SUM(enero+febrero+marzo) as trimestre1, SUM(abril+mayo+junio) as trimestre2,".
					   "       SUM(julio+agosto+septiembre) as trimestre3, SUM(octubre+noviembre+diciembre) as trimestre4,".
					   "       SUM(enero) as enero, SUM(febrero) as febrero, SUM(marzo) as marzo, SUM(abril) as abril, SUM(mayo) as mayo,".
					   "       SUM(junio) as junio, SUM(julio) as julio, SUM(agosto) as agosto, SUM(septiembre) as septiembre,".
					   "       SUM(octubre) as octubre, SUM(noviembre) as noviembre, SUM(diciembre) as diciembre, SUM(orden) AS orden".
					   "  FROM spi_dtmp_mensual, spi_dtmp_cmp, sigesp_cmp_md  ".
					   " WHERE spi_dtmp_mensual.codemp='".$this->daoDetalleSpi->codemp."' ".
					   "   AND spi_dtmp_mensual.spi_cuenta = '".$this->daoDetalleSpi->spi_cuenta."' ".
					   "   AND spi_dtmp_mensual.codestpro1='".$this->daoDetalleSpi->codestpro1."' ".
					   "   AND spi_dtmp_mensual.codestpro2='".$this->daoDetalleSpi->codestpro2."' ".
					   "   AND spi_dtmp_mensual.codestpro3='".$this->daoDetalleSpi->codestpro3."' ".
					   "   AND spi_dtmp_mensual.codestpro4='".$this->daoDetalleSpi->codestpro4."' ".
					   "   AND spi_dtmp_mensual.codestpro5='".$this->daoDetalleSpi->codestpro5."' ".
					   "   AND spi_dtmp_mensual.estcla='".$this->daoDetalleSpi->estcla."' ".
					   "   AND spi_dtmp_mensual.procede='".$this->daoDetalleSpi->procede."' ".
					   "   AND spi_dtmp_mensual.comprobante='".$this->daoDetalleSpi->comprobante."' ".
					   "   AND sigesp_cmp_md.fechaconta = '".$this->daoDetalleSpi->fecha."' ".
					   "   AND spi_dtmp_mensual.procede_doc = '".$this->daoDetalleSpi->procede_doc."' ".
				  	   "   AND spi_dtmp_mensual.documento = '".$this->daoDetalleSpi->documento."' ".
					   "   AND spi_dtmp_mensual.operacion = '".$this->daoDetalleSpi->operacion."' ".
					   "   AND spi_dtmp_cmp.codemp=spi_dtmp_mensual.codemp".
					   "   AND spi_dtmp_cmp.procede=spi_dtmp_mensual.procede".
					   "   AND spi_dtmp_cmp.comprobante=spi_dtmp_mensual.comprobante".
					   "   AND spi_dtmp_cmp.fecha=spi_dtmp_mensual.fecha".
					   "   AND spi_dtmp_cmp.codestpro1=spi_dtmp_mensual.codestpro1".
					   "   AND spi_dtmp_cmp.codestpro2=spi_dtmp_mensual.codestpro2".
					   "   AND spi_dtmp_cmp.codestpro3=spi_dtmp_mensual.codestpro3".
					   "   AND spi_dtmp_cmp.codestpro4=spi_dtmp_mensual.codestpro4".
					   "   AND spi_dtmp_cmp.codestpro5=spi_dtmp_mensual.codestpro5".
					   "   AND spi_dtmp_cmp.estcla=spi_dtmp_mensual.estcla".
					   "   AND spi_dtmp_cmp.spi_cuenta=spi_dtmp_mensual.spi_cuenta".
					   "   AND spi_dtmp_cmp.operacion=spi_dtmp_mensual.operacion".
					   "   AND spi_dtmp_cmp.procede_doc=spi_dtmp_mensual.procede_doc".
					   "   AND spi_dtmp_cmp.documento=spi_dtmp_mensual.documento".
					   "   AND spi_dtmp_cmp.codemp=sigesp_cmp_md.codemp".
					   "   AND spi_dtmp_cmp.procede=sigesp_cmp_md.procede".
					   "   AND spi_dtmp_cmp.comprobante=sigesp_cmp_md.comprobante".
					   "   AND spi_dtmp_cmp.fecha=sigesp_cmp_md.fecha".
					   " GROUP BY spi_dtmp_mensual.codemp,spi_dtmp_mensual.procede,spi_dtmp_mensual.comprobante,spi_dtmp_mensual.fecha,".
					   "          spi_dtmp_mensual.codestpro1,spi_dtmp_mensual.codestpro2,spi_dtmp_mensual.codestpro3,spi_dtmp_mensual.codestpro4,".
					   "          spi_dtmp_mensual.codestpro5,spi_dtmp_mensual.estcla,spi_dtmp_mensual.spi_cuenta,spi_dtmp_mensual.operacion,".
					   "          spi_dtmp_mensual.procede_doc,spi_dtmp_mensual.documento";
			$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
			if ($dataSet===false)
			{
				$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
				$this->valido = false;
			}
			else
			{
				if (!$dataSet->EOF)
				{
					$trimestre1 = number_format($dataSet->fields['trimestre1'],2,'.','');
					$trimestre2 = number_format($dataSet->fields['trimestre2'],2,'.','');
					$trimestre3 = number_format($dataSet->fields['trimestre3'],2,'.','');
					$trimestre4 = number_format($dataSet->fields['trimestre4'],2,'.','');
					$enero = number_format($dataSet->fields['enero'],2,'.','');
					$febrero = number_format($dataSet->fields['febrero'],2,'.','');
					$marzo = number_format($dataSet->fields['marzo'],2,'.','');
					$abril = number_format($dataSet->fields['abril'],2,'.','');
					$mayo = number_format($dataSet->fields['mayo'],2,'.','');
					$junio = number_format($dataSet->fields['junio'],2,'.','');
					$julio = number_format($dataSet->fields['julio'],2,'.','');
					$agosto = number_format($dataSet->fields['agosto'],2,'.','');
					$septiembre = number_format($dataSet->fields['septiembre'],2,'.','');
					$octubre = number_format($dataSet->fields['octubre'],2,'.','');
					$noviembre = number_format($dataSet->fields['noviembre'],2,'.','');
					$diciembre = number_format($dataSet->fields['diciembre'],2,'.','');
					$orden=$dataSet->fields['orden'];
					$existe=true;
					switch($mes)
					{
						case'01':
							$monto=$trimestre1;
							if($this->estmodape==0)
							{
								$monto=$enero;
							}
						break;
						case'02':
							$monto=$trimestre1;
							if($this->estmodape==0)
							{
								$monto=$febrero;
							}
						break;
						case'03':
							$monto=$trimestre1;
							if($this->estmodape==0)
							{
								$monto=$marzo;
							}
						break;
						case'04':
							$monto=$trimestre2;
							if($this->estmodape==0)
							{
								$monto=$abril;
							}
						break;
						case'05':
							$monto=$trimestre2;
							if($this->estmodape==0)
							{
								$monto=$mayo;
							}
						break;
						case'06':
							$monto=$trimestre2;
							if($this->estmodape==0)
							{
								$monto=$junio;
							}
						break;
						case'07':
							$monto=$trimestre3;
							if($this->estmodape==0)
							{
								$monto=$julio;
							}
						break;
						case'08':
							$monto=$trimestre3;
							if($this->estmodape==0)
							{
								$monto=$agosto;
							}
						break;
						case'09':
							$monto=$trimestre3;
							if($this->estmodape==0)
							{
								$monto=$septiembre;
							}
						break;
						case'10':
							$monto=$trimestre4;
							if($this->estmodape==0)
							{
								$monto=$octubre;
							}
						break;
						case'11':
							$monto=$trimestre4;
							if($this->estmodape==0)
							{
								$monto=$noviembre;
							}
						break;
						case'12':
							$monto=$trimestre4;
							if($this->estmodape==0)
							{
								$monto=$diciembre;
							}
						break;
					}
				}
			}
			unset($dataSet);
		}
		else
		{
			$cadenaSql="SELECT monto, orden ".
					   "  FROM spi_dtmp_cmp ".		
					   " WHERE codemp='".$this->daoDetalleSpi->codemp."' ".
					   "   AND spi_cuenta = '".$this->daoDetalleSpi->spi_cuenta."' ".
					   "   AND codestpro1='".$this->daoDetalleSpi->codestpro1."' ".
					   "   AND codestpro2='".$this->daoDetalleSpi->codestpro2."' ".
					   "   AND codestpro3='".$this->daoDetalleSpi->codestpro3."' ".
					   "   AND codestpro4='".$this->daoDetalleSpi->codestpro4."' ".
					   "   AND codestpro5='".$this->daoDetalleSpi->codestpro5."' ".
					   "   AND estcla='".$this->daoDetalleSpi->estcla."' ".
					   "   AND procede='".$this->daoDetalleSpi->procede."' ".
					   "   AND comprobante='".$this->daoDetalleSpi->comprobante."' ".
					   "   AND fecha = '".$this->daoDetalleSpi->fecha."' ".
					   "   AND procede_doc = '".$this->daoDetalleSpi->procede_doc."' ".
				  	   "   AND documento = '".$this->daoDetalleSpi->documento."' ".
					   "   AND operacion = '".$this->daoDetalleSpi->operacion."' ";
			$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
			if ($dataSet===false)
			{
				$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
				$this->valido = false;
			}
			else
			{
				if (!$dataSet->EOF)
				{
					$orden=$dataSet->fields['orden'];
					$monto=number_format($dataSet->fields['monto'],2,'.','');
					$existe=true;
				}			
			}
			unset($dataSet);
		}
		return $existe;
	}	
	
	public function guardarDetalleSPI($daoComprobante,$arrdetallespi,$arrevento) 
	{
		if(!$this->existeCierreSPI())
		{
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$totalspi = count($arrdetallespi);
			for($i=1;($i<=$totalspi)&&($this->valido);$i++)
			{
				$this->daoDetalleSpi = FabricaDao::CrearDAO('N', 'spi_dtmp_cmp');				
				$this->daoDetalleSpi->codemp=$arrdetallespi[$i]['codemp'];
				$this->daoDetalleSpi->procede=$arrdetallespi[$i]['procede'];
				$this->daoDetalleSpi->comprobante=$arrdetallespi[$i]['comprobante'];
				$this->daoDetalleSpi->estcla=$arrdetallespi[$i]['estcla'];
				$this->daoDetalleSpi->codestpro1=$arrdetallespi[$i]['codestpro1'];
				$this->daoDetalleSpi->codestpro2=$arrdetallespi[$i]['codestpro2'];
				$this->daoDetalleSpi->codestpro3=$arrdetallespi[$i]['codestpro3'];
				$this->daoDetalleSpi->codestpro4=$arrdetallespi[$i]['codestpro4'];
				$this->daoDetalleSpi->codestpro5=$arrdetallespi[$i]['codestpro5'];
				$this->daoDetalleSpi->spi_cuenta=$arrdetallespi[$i]['spi_cuenta'];
				$this->daoDetalleSpi->procede_doc=$arrdetallespi[$i]['procede_doc'];
				$this->daoDetalleSpi->documento=$arrdetallespi[$i]['documento'];
				$this->daoDetalleSpi->operacion=$arrdetallespi[$i]['operacion'];
				$this->daoDetalleSpi->fecha=$arrdetallespi[$i]['fecha'];
				$this->daoDetalleSpi->descripcion=$arrdetallespi[$i]['descripcion'];
				$this->daoDetalleSpi->monto=$arrdetallespi[$i]['monto'];
				$this->daoDetalleSpi->orden=$arrdetallespi[$i]['orden'];
				if((is_null($this->daoDetalleSpi->documento)) or (empty($this->daoDetalleSpi->documento)))
				{
					$this->mensaje .= 'El Documento no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if((is_null($this->daoDetalleSpi->procede_doc)) or (empty($this->daoDetalleSpi->procede_doc)))
				{
					$this->mensaje .= 'El Procede no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if((is_null($this->daoDetalleSpi->descripcion)) or (empty($this->daoDetalleSpi->descripcion)))
				{
					$this->mensaje .= 'La Descripci&#243;n no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if(($this->existeCuenta())&&($this->valido))
				{
					if(!$this->existeReverso($daoComprobante->operacion)) //existeReverso
					{
						if(!$this->existeMovimiento($daoComprobante->tipo_comp))
						{
							$this->valido=$this->daoDetalleSpi->incluir();
							if(!$this->valido)
							{
								$this->mensaje .= $this->daoDetalleSpi->ErrorMsg;
							}
							$servicioEvento->tipoevento=$this->valido; 
							if($this->valido)
							{
								$servicioEvento->desevetra='Incluyo detalle presupuestario '.$this->daoDetalleSpi->codestpro1.'::'.
															   $this->daoDetalleSpi->codestpro2.'::'.$this->daoDetalleSpi->codestpro3.'::'.
															   $this->daoDetalleSpi->codestpro4.'::'.$this->daoDetalleSpi->codestpro5.'::'.
															   $this->daoDetalleSpi->spi_cuenta.'::'.$this->daoDetalleSpi->procede_doc.'::'.
															   $this->daoDetalleSpi->documento.'::'.$this->daoDetalleSpi->operacion.'::'.
															   $this->daoDetalleSpi->codfuefin.'::'.$this->daoDetalleSpi->fecha.'::'.
															   $this->daoDetalleSpi->monto.'   del comprobante '.$daoComprobante->codemp.'::'.
															   $daoComprobante->procede.'::'.$daoComprobante->comprobante.'::'.$daoComprobante->fecha;			
								$servicioEvento->incluirEvento();
							}
							else
							{
								$this->valido=false;
								$servicioEvento->desevetra=$this->mensaje;
								$servicioEvento->incluirEvento();
							}	
						}
						else
						{
							$this->valido=false;
							$this->mensaje .= ' -> El movimiento Ya existe.';
							$servicioEvento->tipoevento=$this->valido; 
							$servicioEvento->desevetra=$this->mensaje;
							$servicioEvento->incluirEvento();
						}
					}
					else{
						//por aqui
					}
				}
				else
				{
					$this->valido=false;
					$servicioEvento->tipoevento=$this->valido; 
					$servicioEvento->desevetra=$this->mensaje;
					$servicioEvento->incluirEvento();
				}
			}
			unset($servicioEvento);
		}
		return $this->valido;	
	}
	
	public function existeProcedencia($procede) 
	{
		$existe = false;
		$cadenaSql = "SELECT procede ".
				     "  FROM sigesp_procedencias ".
				     " WHERE procede='{$procede}'";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if ($dataSet->_numOfRows > 0) {
				$existe = true;
			}
		}
		return $existe;
	}
	
	public function validarComprobante($arrdetallespi)
	{
		$validar=true;
		if((is_null($this->daoComprobante->comprobante)) or (empty($this->daoComprobante->comprobante)))
		{
			$this->mensaje .= 'El Comprobante no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;			
			$this->valido = false;	
		}
		if((is_null($this->daoComprobante->procede)) or (empty($this->daoComprobante->procede)))
		{
			$this->mensaje = 'La procedencia no puede tener valor nulo o vacio .'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		} 	  
		if((is_null($this->daoComprobante->descripcion)) or (empty($this->daoComprobante->descripcion)))
		{
			$this->mensaje .= 'La descripci&#243;n no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		} 	
		if((is_null($this->daoComprobante->tipo_destino)) or (empty($this->daoComprobante->tipo_destino)))
		{ 
			$this->mensaje .= 'El Tipo (Beneficiario o Proveedor) no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		} 	
		if((is_null($this->daoComprobante->cod_pro)) or ($this->daoComprobante->cod_pro=='') or (is_null($this->daoComprobante->ced_bene)) or ($this->daoComprobante->ced_bene==''))
		{
			$this->mensaje .=  'El Beneficiario o Proveedor no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		}
		if(!($this->existeProcedencia($this->daoComprobante->procede)))
		{ 
			$this->mensaje .=  'El Procede '.$this->daoComprobante->procede.' no Existe.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		}
		if($validar)
		{
			if (!(validarFechaMes($this->daoComprobante->fecha)))
			{
				$this->mensaje .=  'El Mes '.obtenerNombreMes(substr($this->daoComprobante->fecha,5,2)).' no esta abierto.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
				$this->valido = false;	
			}
			else
			{
				if(!validarFechaPeriodo($this->daoComprobante->fecha))
				{
					$this->mensaje .=  'La fecha '.substr($this->daoComprobante->fecha,5,2).' Est&#225; fuera del periodo.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
					$this->valido = false;	
				}
			}
		}
		$totalSPI=count($arrdetallespi);
		if($totalSPI<=0)
		{
			$this->mensaje .=  'El comprobante '.$this->daoComprobante->comprobante.' No tiene detalles.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;
			$this->valido = false;	
		}
		return $this->valido;
	}
	
	public function cargarDetallesComprobante($tipoevento='',$fechaanula='',$procedeanula='',$conceptoanula='')
	{
		$arrdetallespi=null;
		//CARGAMOS LOS DETALLES PRESUPUESARIOS DE INGRESO
		$cadenaSql="SELECT codemp,procede,comprobante,estcla,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,spi_cuenta,".
				   "       procede_doc,documento,operacion,fecha,descripcion,monto,orden ".
				   "  FROM spi_dtmp_cmp ".
				   " WHERE codemp='".$this->daoComprobante->codemp."' ".
				   "   AND procede='".$this->daoComprobante->procede."' ".
				   "   AND comprobante='".$this->daoComprobante->comprobante."' ".
				   "   AND fecha='".$this->daoComprobante->fecha."'".
				   " ORDER BY orden ";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$i=0;
			while(!$dataSet->EOF)
			{
				$i++;
				$arrdetallespi[$i]['codemp']=$dataSet->fields['codemp'];
				$arrdetallespi[$i]['procede']= $dataSet->fields['procede'];
				$arrdetallespi[$i]['comprobante']= $dataSet->fields['comprobante'];
				$arrdetallespi[$i]['estcla']=$dataSet->fields['estcla'];
				$arrdetallespi[$i]['codestpro1']=$dataSet->fields['codestpro1'];
				$arrdetallespi[$i]['codestpro2']=$dataSet->fields['codestpro2'];
				$arrdetallespi[$i]['codestpro3']=$dataSet->fields['codestpro3'];
				$arrdetallespi[$i]['codestpro4']=$dataSet->fields['codestpro4'];
				$arrdetallespi[$i]['codestpro5']=$dataSet->fields['codestpro5'];
				$arrdetallespi[$i]['spi_cuenta']=$dataSet->fields['spi_cuenta'];
				$arrdetallespi[$i]['procede_doc']= $dataSet->fields['procede_doc'];
				$arrdetallespi[$i]['documento']= $dataSet->fields['documento'];
				$arrdetallespi[$i]['operacion']= $dataSet->fields['operacion'];
				$arrdetallespi[$i]['fecha']= $dataSet->fields['fecha'];
				$arrdetallespi[$i]['descripcion']= $dataSet->fields['descripcion'];
				$arrdetallespi[$i]['monto']=$dataSet->fields['monto'];
				$arrdetallespi[$i]['orden']= $dataSet->fields['orden'];
				$dataSet->MoveNext();
			}
		}
		unset($dataSet);
		$arrResultado['Spi']=$arrdetallespi;
		return $arrResultado;
	}	
	
	public function guardarComprobante($arrcabecera,$arrdetallespi,$arrevento) 
	{
		$this->daoComprobante = FabricaDao::CrearDAO('N', 'sigesp_cmp_md');
		$this->daoComprobante->codemp      = $arrcabecera['codemp'];
		$this->daoComprobante->procede     = $arrcabecera['procede'];
		$this->daoComprobante->comprobante = fillComprobante($arrcabecera['comprobante']);
		$this->daoComprobante->fecha       = $arrcabecera['fecha'];
		$this->daoComprobante->descripcion = $arrcabecera['descripcion'];
		$this->daoComprobante->tipo_comp   = $arrcabecera['tipo_comp'];
		$this->daoComprobante->tipo_destino= $arrcabecera['tipo_destino'];
		$this->daoComprobante->cod_pro     = $arrcabecera['cod_pro'];
		$this->daoComprobante->ced_bene    = $arrcabecera['ced_bene'];
		$this->daoComprobante->total       = $arrcabecera['total'];
		$this->daoComprobante->numpolcon   = $arrcabecera['numpolcon'];
		$this->daoComprobante->esttrfcmp   = $arrcabecera['esttrfcmp'];
		$this->daoComprobante->estrenfon   = $arrcabecera['estrenfon'];
		$this->daoComprobante->estapro     = $arrcabecera['estapro'];
		$this->daoComprobante->coduac      = $arrcabecera['coduac'];
		$this->daoComprobante->codtipmodpre= $arrcabecera['codtipmodpre'];
		$this->daoComprobante->codfuefin   = $arrcabecera['codfuefin'];
		$this->daoComprobante->codusu      = $arrcabecera['codusu'];
		if(!$this->existeComprobante($this->daoComprobante->codemp,$this->daoComprobante->procede,$this->daoComprobante->comprobante,$this->daoComprobante->fecha))
		{
			if($this->validarComprobante($arrdetallespi))
			{
				$this->valido = $this->daoComprobante->incluir();
				if($this->valido)
				{
					if((count($arrdetallespi)>0)&&($this->valido))
					{
						// incluir detalles de Presupuesto de Gasto
						$this->valido=$this->guardarDetalleSPI($this->daoComprobante,$arrdetallespi,$arrevento);			
					}
				}
				else
				{
					$this->mensaje .= $this->daoComprobante->ErrorMsg;
				}
			}
			else
			{
				$this->valido = false;
			}
		}
		else
		{
			$this->mensaje .= 'El Comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha.' ya existe.';			
			$this->valido = false;	
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra='Incluyo el comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;			
		if ($this->valido) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
	}
	
	public function eliminarDetalleSPI($daoComprobante,$arrdetallespi,$arrevento) 
	{
		$this->valido=true;
		if(!$this->existeCierreSPI())
		{
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$totalspi = count($arrdetallespi);
			for($i=1;($i<=$totalspi)&&($this->valido);$i++)
			{
				$criterio="     codemp  = '".$arrdetallespi[$i]['codemp']."'".
				          " AND procede = '".$arrdetallespi[$i]['procede']."' ".
						  " AND comprobante = '".$arrdetallespi[$i]['comprobante']."' ".
//						  " AND estcla = '".$arrdetallespi[$i]['estcla']."' ".
//						  " AND codestpro1 = '".$arrdetallespi[$i]['codestpro1']."' ".
//						  " AND codestpro2 = '".$arrdetallespi[$i]['codestpro2']."' ".
//						  " AND codestpro3 = '".$arrdetallespi[$i]['codestpro3']."' ".
//						  " AND codestpro4 = '".$arrdetallespi[$i]['codestpro4']."' ".
//						  " AND codestpro5 = '".$arrdetallespi[$i]['codestpro5']."' ".
						  " AND spi_cuenta = '".$arrdetallespi[$i]['spi_cuenta']."' ".
						  " AND procede_doc = '".$arrdetallespi[$i]['procede_doc']."' ".
						  " AND documento = '".$arrdetallespi[$i]['documento']."' ".
						  " AND operacion = '".$arrdetallespi[$i]['operacion']."' ".
						  " AND orden = '".$arrdetallespi[$i]['orden']."' ";					  
				$this->daoDetalleSpi = FabricaDao::CrearDAO('C','spi_dtmp_cmp','',$criterio);
				if((is_null($this->daoDetalleSpi->documento)) or (empty($this->daoDetalleSpi->documento)))
				{
					$this->mensaje .= 'El Documento no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if((is_null($this->daoDetalleSpi->procede_doc)) or (empty($this->daoDetalleSpi->procede_doc)))
				{
					$this->mensaje .= 'El Procede no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if((is_null($this->daoDetalleSpi->descripcion)) or (empty($this->daoDetalleSpi->descripcion)))
				{
					$this->mensaje .= 'La Descripci&#243;n no puede tener valor nulo o vac&#237;o.';			
					$this->valido = false;	
				}
				if(($this->existeCuenta())&&($this->valido))
				{
					if($this->existeMovimiento($daoComprobante->tipo_comp))
					{
						$this->valido=$this->daoDetalleSpi->eliminar('','',true);
						if(!$this->valido)
						{
							$this->mensaje .= $this->daoDetalleSpi->ErrorMsg;
						}
						$servicioEvento->tipoevento=$this->valido; 
						if($this->valido)
						{
							$servicioEvento->desevetra='Elimino detalle presupuestario '.$this->daoDetalleSpi->codestpro1.'::'.
													   $this->daoDetalleSpi->codestpro2.'::'.$this->daoDetalleSpi->codestpro3.'::'.
													   $this->daoDetalleSpi->codestpro4.'::'.$this->daoDetalleSpi->codestpro5.'::'.
													   $this->daoDetalleSpi->spi_cuenta.'::'.$this->daoDetalleSpi->procede_doc.'::'.
													   $this->daoDetalleSpi->documento.'::'.$this->daoDetalleSpi->operacion.'::'.
													   $this->daoDetalleSpi->fecha.'::'.
													   $this->daoDetalleSpi->monto.'   del comprobante '.$daoComprobante->codemp.'::'.
													   $daoComprobante->procede.'::'.$daoComprobante->comprobante.'::'.
													   $daoComprobante->codban.'::'.$daoComprobante->ctaban;			
							$servicioEvento->incluirEvento();
						}
						else
						{
							$this->valido=false;
							$servicioEvento->desevetra=$this->mensaje;
							$servicioEvento->incluirEvento();
						}
					}
					else
					{
						$this->valido=false;
						$servicioEvento->tipoevento=$this->valido; 
						$servicioEvento->desevetra=$this->mensaje;
						$servicioEvento->incluirEvento();
					}
				}
				else
				{
					$this->valido=false;
					$servicioEvento->tipoevento=$this->valido; 
					$servicioEvento->desevetra=$this->mensaje;
					$servicioEvento->incluirEvento();
				}
			}
			unset($servicioEvento);
		}
		return $this->valido;	
	}
	
	public function eliminarComprobante($arrcabecera,$arrevento)
	{
		$criterio="codemp = '".$arrcabecera['codemp']."' AND procede='".$arrcabecera['procede']."' AND comprobante='".fillComprobante($arrcabecera['comprobante'])."' AND fecha='".$arrcabecera['fecha']."' ";
		$this->daoComprobante = FabricaDao::CrearDAO('C','sigesp_cmp_md','',$criterio);
		if($this->existeComprobante($this->daoComprobante->codemp,$this->daoComprobante->procede,$this->daoComprobante->comprobante,$this->daoComprobante->fecha))
		{	
			$_SESSION['fechacomprobante']=$this->daoComprobante->fecha;
			$arrResultado=$this->cargarDetallesComprobante();
			$arrdetallespi=$arrResultado['Spi'];
			if(($this->validarComprobante($arrdetallespi))&&($this->valido))
			{
				if((count($arrdetallespi)>0)&&($this->valido))
				{
					// eliminar detalles de Presupuesto de Ingreso
					$this->valido=$this->eliminarDetalleSPI($this->daoComprobante,$arrdetallespi,$arrevento);
				}
				if ($this->valido)
				{
					$this->valido = $this->daoComprobante->eliminar();
					if(!$this->valido)
					{
						$this->mensaje .= $this->daoComprobante->ErrorMsg;
					}
				}
			}
			else
			{
				$this->valido = false;
			}
		}
		else
		{
			$this->mensaje .= 'El Comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha.' no existe.';			
			$this->valido = false;	
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra='Elimino el comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->fecha;			
		if ($this->valido) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
	}
	
	public function guardar($codemp,$objson,$arrevento)
	{
		$arrDetPre = $objson->detallesPresupuestario;
		$i=1;
		$arrcabecera = array();
		$arregloSCG = array();
		$arregloSPI = array();
		$fecha = convertirFechaBd($objson->fecha);
		DaoGenerico::iniciarTrans();
		
		if($this->valido)
		{
			if(!validarFechaPeriodo($fecha))
			{
				$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
				$this->valido = false;	
			}
		}
		if($this->valido)
		{
			$arrcabecera['codemp'] = $codemp;
			$arrcabecera['procede'] = $objson->procede;
			$arrcabecera['comprobante'] = fillComprobante($objson->comprobante);
			$arrcabecera['fecha'] = $fecha;
			$arrcabecera['descripcion'] = $objson->descripcion;
			$arrcabecera['tipo_comp'] = 2;
			$arrcabecera['tipo_destino'] = '-';
			$arrcabecera['cod_pro'] = '----------';
			$arrcabecera['ced_bene'] = '----------';
			$arrcabecera['numpolcon'] = 0;
			$arrcabecera['esttrfcmp'] = 0;
			$arrcabecera['estrenfon'] = 0;
			$arrcabecera['codfuefin'] = '--';
			$arrcabecera['estapro'] = 0;
			$arrcabecera['coduac'] = '-----';
			$arrcabecera['codtipmodpre'] = '----';
			$arrcabecera['total'] = formatoNumericoBd($objson->monto);
			$arrcabecera['codusu'] = $_SESSION['la_logusr'];
			foreach ($arrDetPre as $detalle)
			{
				$arregloSPI[$i]['codemp']=$codemp;
				$arregloSPI[$i]['procede']= $arrcabecera['procede'];
				$arregloSPI[$i]['comprobante']= $arrcabecera['comprobante'];
				$arregloSPI[$i]['fecha']= $arrcabecera['fecha'];
				$arregloSPI[$i]['orden']= $i;	
				$arregloSPI[$i]['descripcion']= $detalle->descripcion;		
				$arregloSPI[$i]['spi_cuenta'] = $detalle->spi_cuenta;
				$arregloSPI[$i]['procede_doc'] = $detalle->procede_doc;
				$arregloSPI[$i]['documento'] = $detalle->documento;
				$arregloSPI[$i]['operacion'] = $detalle->operacion;
				$arregloSPI[$i]['estcla'] = '-';
				$arregloSPI[$i]['codestpro1'] = '-------------------------';
				$arregloSPI[$i]['codestpro2'] = '-------------------------';
				$arregloSPI[$i]['codestpro3'] = '-------------------------';
				$arregloSPI[$i]['codestpro4'] = '-------------------------';
				$arregloSPI[$i]['codestpro5'] = '-------------------------';
				$arregloSPI[$i]['monto'] = formatoNumericoBd($detalle->monto,1);
				$i++;
			}
			if($objson->evento!='UPDATE'){
				$this->valido = $this->guardarComprobante($arrcabecera,$arregloSPI,$arrevento);
			}
			else{
				$this->valido = $this->eliminarComprobante($arrcabecera,$arrevento);
				if($this->valido){
					$this->valido = $this->guardarComprobante($arrcabecera,$arregloSPI,$arrevento);
				}
			}
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				$this->mensaje.='Registro guardado con exito'; 		
			}
			else{
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}
	
	public function eliminar($codemp,$objson,$arrevento)
	{
		$i=0;
		$monto=0;
		$arrcabecera = array();
		$fecha = convertirFechaBd($objson->fecha);
		DaoGenerico::iniciarTrans();
		
		if($this->valido){
			if(!validarFechaPeriodo($fecha)){
				$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
				$this->valido = false;	
			}
		}
		if($this->valido)
		{
			$arrcabecera['codemp'] = $codemp;
			$arrcabecera['procede'] = $objson->procede;
			$arrcabecera['comprobante'] = fillComprobante($objson->comprobante);
			$arrcabecera['fecha'] = $fecha;
			$arrcabecera['descripcion'] = $objson->descripcion;
			$arrcabecera['tipo_comp'] = 2;
			$arrcabecera['tipo_destino'] = '-';
			$arrcabecera['cod_pro'] = '----------';
			$arrcabecera['ced_bene'] = '----------';
			$arrcabecera['numpolcon'] = 0;
			$arrcabecera['esttrfcmp'] = 0;
			$arrcabecera['estrenfon'] = 0;
			$arrcabecera['codfuefin'] = '--';
			$arrcabecera['estapro'] = 0;
			$arrcabecera['coduac'] = '-----';
			$arrcabecera['codtipmodpre'] = '----';
			$arrcabecera['total'] = 0; 
			$arrcabecera['codusu'] = $_SESSION['la_logusr'];
			
			$this->valido = $this->eliminarComprobante($arrcabecera,$arrevento);
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->incluirEvento();
				$this->mensaje.='Registro eliminado exitosamente'; 		
			}
			else{
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$this->mensaje;
				$servicioEvento->incluirEvento();
				$this->valido=false;
			}
			unset($servicioEvento);
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}

}
?>