<?php
/**
 * @author Ing. Leonardo Vargas
 * @desc Interfaz del servicio comprobante presupuestario de Ingreso
 */
interface IComprobantePresupuestarioIngreso 
{
	
	public function buscarComprobantes($codemp,$comprobante,$procede,$tipo,$provben,$fecdesde,$fechasta);
	/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que busca los comprobantes existentes segun los filtros de busqueda
	 * @param string $codemp - codigo de empresa
	 * @param string $procede - procedencia del comprobante
	 * @param string $comprobante - numero del comprobante
	 * @param string $tipo - tipo (proveedor/beneficiario)
	 * @param string $provben - nombre del (proveedor/beneficiario)
	 * @param string $fecdesde - rango de fecha desde
	 * @param string $fechasta - rango de fecha hasta
	 * @return Resulset Adodb con los datos de los comprobantes.
	 */
	
	public function cargarDetalleContable($codemp,$procede,$comprobante,$fecha,$codban,$ctaban);
	/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que busca los detalles contables del comprobante
	 * @param string $codemp - codigo de empresa
	 * @param string $procede - procedencia del comprobante
	 * @param string $comprobante - numero del comprobante
	 * @param string $fecha - fecha del comprobante
	 * @param string $codban - codigo del banco del comprobante
	 * @param string $ctaban - cuenta bancaria del comprobante
	 * @return Resulset Adodb con los datos de los detalles contables del comprobante.
	 */
	
	public function buscarCuentas($codemp);
	/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que busca las cuentas contables
	 * @param string $codemp - codigo de empresa
	*/
	public function cargarDetallePresupuestario($codemp,$procede,$comprobante,$fecha,$codban,$ctaban);
	/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que busca los detalles presupuestario de ingreso del comprobante
	 * @param string $codemp - codigo de empresa
	 * @param string $procede - procedencia del comprobante
	 * @param string $comprobante - numero del comprobante
	 * @param string $fecha - fecha del comprobante
	 * @param string $codban - codigo del banco del comprobante
	 * @param string $ctaban - cuenta bancaria del comprobante
	 * @return Resulset Adodb con los datos de los detalles presupuestario de gasto del comprobante.
*/

	public function guardar($codemp,$objson,$arrevento);
		/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que guardar el comprobante contable
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	*/
	public function eliminar($codemp,$objson,$arrevento);
	 	/**
	 * @author Ing. Leonardo Vargas
	 * @desc Metodo que elimina el comprobante contable
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
}
?>