<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/spi/sigesp_srv_spi_iapertura.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv."/modelo/servicio/mis/sigesp_srv_mis_comprobante.php");
require_once ($dirsrv."/modelo/servicio/mis/sigesp_srv_mis_comprobantespi.php");

class ServicioComprobanteAperturaSPI implements IComprobanteAperturaSPI {

	public  $mensaje; 
	public  $valido; 
	private $conexionBaseDatos; 
	private $daoComprobante;
	
	public function ServicioComprobanteAperturaSPI() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoComprobante = null;
		$this->conexionbd  = ConexionBaseDatos::getInstanciaConexion();
//		$this->conexionbd->debug=true;
	}
	
	public function buscarCuentasApertura($codemp)
	{
		$cadenasql = '';
		$cadenasql="SELECT spi_cuenta,denominacion,status,previsto,distribuir,enero,febrero,marzo, ".
	           "           abril,mayo,junio,julio,agosto,septiembre,octubre,noviembre,diciembre ".
			   "    FROM spi_cuentas  ".
			   "    WHERE codemp='".$codemp."'  AND ".
			   "          status='C' ".
			   "    ORDER BY spi_cuenta ";
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->cuentasApertura ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $resultado;
	}
	
//	,$objetoJson->operacion
	public function buscarRepComprobantes($codemp,$comprobante,$procede,$tipo,$provben,$fecdesde,$fechasta,$operacion)
	{
		$cadenaFiltro='';
		if(!empty($tipo)){
			if(($tipo=="P")&&($provben!=""))
			{
				$cadenaFiltro=$cadenaFiltro." AND cod_pro like '".$provben."'";
			}
			else if(($tipo=="B")&&($provben!=""))
			{
				$cadenaFiltro=$cadenaFiltro." AND ced_bene like'".$provben."'";
			}
		}
		if(!empty($fecdesde) && !empty($fechasta)){
		   	$fecdesde = convertirFechaBd($fecdesde);
			$fechasta = convertirFechaBd($fechasta);
		    $cadenaFiltro = $cadenaFiltro." AND a.fecha BETWEEN '{$fecdesde}' AND '{$fechasta}'";
		}
		if($operacion=='NA'){
		   $cadena2 =" AND b.comprobante=c.comprobante AND b.codemp=c.codemp ";
		   $sql="SELECT distinct a.procede,a.codemp,a.comprobante,c.fecha,a.ced_bene,a.cod_pro,a.descripcion, ".
		        "       a.tipo_destino,b.monto ".
		 		"FROM sigesp_cmp_md a,spi_dtmp_cmp b,spi_dt_cmp c ".
		  		"WHERE a.procede=b.procede AND a.tipo_comp=2 AND a.comprobante=b.comprobante ".
		        "      AND a.fecha=b.fecha AND a.codemp=b.codemp AND a.codemp='".$codemp."' ".
		        "      AND a.comprobante like '%".$comprobante."%' AND".
				"	   a.procede like '%".$procede."%' AND a.estapro='0' ".$cadena2;
		}
		else{
			$cadena2 =" ";
		  	$sql="SELECT distinct a.procede,a.codemp,a.comprobante,a.fecha,a.ced_bene,a.cod_pro,a.descripcion,  ".
		  	     "       a.tipo_destino,b.monto ".
		 		 "FROM sigesp_cmp_md a,spi_dtmp_cmp b ".
		  		 "WHERE a.procede=b.procede AND a.tipo_comp=2 AND a.comprobante=b.comprobante  ".
		  		 "      AND a.fecha=b.fecha AND a.codemp=b.codemp AND a.codemp='".$codemp."' ".
		  	     "      AND a.comprobante like '%".$comprobante."%' AND a.procede like '%".$procede."%' ".
		  	     "      AND a.estapro='1' ".$cadena2;
		}
		$sql = $sql.$cadenaFiltro." ORDER BY fecha ASC ,comprobante ASC ,procede ASC ";
		$resultado = $this->conexionbd->Execute($sql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->buscarRepComprobantes ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $resultado;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: operacionMensajeCodigo
	//		   Access: public 
	//       Argument: mensaje // Mensaje 
	//	  Description: Este método mediante la cadena mensaje retorna el codigo operacion asociado
	//	      Returns: retorna el codigo de operacion del gasto definida en las tablas spg_operaciones
	//	   Creado Por: Ing. Wilmer Briceño
	// Modificado Por: Ing. Yesenia Moreno								Fecha Última Modificacion : 01/06/2007
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function operacionMensajeCodigo($mensaje)
	{		
		$previsto=0;
		$aumento=0;
		$disminucion=0;
		$devengado=0;
		$cobrado =0;
		$cobrado_ant=0;
		$codigo="";
		$operacion="";
		$mensaje=strtoupper($mensaje); // devuelve cadena en MAYUSCULAS
		$pos_i=strpos($mensaje,"I"); 
		if(!($pos_i===false))
		{
			$previsto=1;
		}
		$pos_a=strpos($mensaje,"A"); 
		if(!($pos_a===false))
		{
			$aumento=1;
		}
		$pos_d=strpos($mensaje,"D"); 
		if(!($pos_d===false))
		{
			$disminucion=1;
		}
		$pos_e=strpos($mensaje,"E"); 
		if(!($pos_e===false))
		{
			$devengado=1;
		}
		$pos_c=strpos($mensaje,"C"); 
		if(!($pos_c===false))
		{
			$cobrado=1;
		}
		$pos_n=strpos($mensaje,"N"); 
		if(!($pos_n===false))
		{
			$cobrado_ant=1;
		}
		$sql="SELECT operacion ".
			" FROM spi_operaciones ".
			" WHERE previsto=".$previsto." ".
			"   AND aumento=".$aumento." ".
			"   AND disminucion=".$disminucion." ".
			"   AND devengado=".$devengado." ".
			"   AND cobrado=".$cobrado." ".
			"   AND cobrado_ant=".$cobrado_ant." "; ///print $ls_sql;
		$data = $this->conexionbd->Execute($sql);
		if($data===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->operacionMensajeCodigo ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$data->EOF)
			{
				$operacion=$data->fields["operacion"];
			}
			else  
			{  
				$this->mensaje =  "No hay operacion asociada al mensaje ".$mensaje;		
				$this->valido = false;   		  		  			 
			}			
		}
		return $operacion;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_insertar_estructurapresupuestaria1
	//		   Access: public
	//		 Argumens: aa_codestpro // Arreglo de estructuras
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que inserta una estructura de nivel 1
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 04/06/2008  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertarEstructuraPresupuestaria1($codemp,$codestpro)
	{
		$this->valido=true;
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$estcla="'".$codestpro[5]."'";
		if($codestpro[0]!='-------------------------')
		{
			$this->daoEstPre1 = FabricaDao::CrearDAO("N","spg_ep1");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoEstPre1->codemp=$codemp;
			$this->daoEstPre1->codestpro1 = $codestpro[0];
			$this->daoEstPre1->denestpro1 = 'POR DEFECTO';
			$this->daoEstPre1->estcla = $estcla;
			if(!$this->daoEstPre1->incluir())
			{
				$this->mensaje .= 'CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria1 ERROR->'.$this->conexionbd->ErrorMsg();
				$this->valido = false;
			}
		}
		else
		{
			$this->valido=true;
		}	
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria1
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta presupuestaria existe
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 23/09/2007  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearEstructuraPresupuestaria1($codemp,$codestpro)
	{
		$this->valido=true;
		$tabla="";
		$criterio="";
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$cadenasql="SELECT codemp ".
				   "FROM spg_ep1 ".
				   "WHERE codemp='".$codemp."'".
				   "  AND codestpro1='".$codestpro[0]."'".
				   "  AND estcla = ".$estcla;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria1 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
			else
			{
				$this->valido=$this->insertarEstructuraPresupuestaria1($codemp,$codestpro);
			}
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_insertar_estructurapresupuestaria2
	//		   Access: public
	//		 Argumens: aa_codestpro // Arreglo de estructuras
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que inserta una estructura de nivel 1
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 04/06/2008  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertarEstructuraPresupuestaria2($codemp,$codestpro)
	{
		
		$this->valido=true;
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$this->daoEstPre2 = FabricaDao::CrearDAO("N","spg_ep2");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoEstPre2->codemp=$codemp;
		$this->daoEstPre2->codestpro1 = $codestpro[0];
		$this->daoEstPre2->codestpro2 = $codestpro[1];
		$this->daoEstPre2->denestpro2 = 'POR DEFECTO';
		$this->daoEstPre2->estcla = $estcla;
		if(!$this->daoEstPre2->incluir())
		{
			$this->mensaje .= 'CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria2 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria2
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta presupuestaria existe
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 23/09/2007  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearEstructuraPresupuestaria2($codemp,$codestpro)
	{
		
		$this->valido=true;
		$tabla="";
		$criterio="";
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$cadenasql="SELECT codemp ".
				 "  FROM spg_ep2 ".
				 "  WHERE codemp='".$codemp."'".
				 "    AND codestpro1='".$codestpro[0]."'".
				 "    AND codestpro2='".$codestpro[1]."'".
				 "    AND estcla =".$estcla;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->chequearEstructuraPresupuestaria2 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
			else
			{
				$this->valido=$this->insertarEstructuraPresupuestaria2($codemp,$codestpro);
			}
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_insertar_estructurapresupuestaria3
	//		   Access: public
	//		 Argumens: aa_codestpro // Arreglo de estructuras
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que inserta una estructura de nivel 1
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 04/06/2008  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertarEstructuraPresupuestaria3($codemp,$codestpro)
	{
		
		$this->valido=true;
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$this->daoEstPre3 = FabricaDao::CrearDAO("N","spg_ep3");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoEstPre3->codemp=$codemp;
		$this->daoEstPre3->codestpro1 = $codestpro[0];
		$this->daoEstPre3->codestpro2 = $codestpro[1];
		$this->daoEstPre3->codestpro3 = $codestpro[2];
		$this->daoEstPre3->denestpro3 = 'POR DEFECTO';
		$this->daoEstPre3->estcla = $estcla;
		if(!$this->daoEstPre3->incluir())
		{
			$this->mensaje .= 'CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria3 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta presupuestaria existe
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 23/09/2007  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearEstructuraPresupuestaria3($codemp,$codestpro)
	{
		$this->valido=true;
		$tabla="";
		$criterio="";
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$cadenasql="SELECT codemp ".
				 "  FROM spg_ep3 ".
				 "  WHERE codemp='".$codemp."'".
				 "    AND codestpro1='".$codestpro[0]."'".
				 "    AND codestpro2='".$codestpro[1]."'".
				 "    AND codestpro3='".$codestpro[2]."'".
				 "    AND estcla    =".$estcla;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->chequearEstructuraPresupuestaria3 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
			else
			{
				$this->valido=$this->insertarEstructuraPresupuestaria3($codemp,$codestpro);
			}
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_insertar_estructurapresupuestaria4
	//		   Access: public
	//		 Argumens: aa_codestpro // Arreglo de estructuras
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que inserta una estructura de nivel 1
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 04/06/2008  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertarEstructuraPresupuestaria4($codemp,$codestpro)
	{
		$this->valido=true;
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$codestpro[3]=str_pad($codestpro[3],$_SESSION["la_empresa"]["loncodestpro4"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$this->daoEstPre4 = FabricaDao::CrearDAO("N","spg_ep4");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoEstPre4->codemp=$codemp;
		$this->daoEstPre4->codestpro1 = $codestpro[0];
		$this->daoEstPre4->codestpro2 = $codestpro[1];
		$this->daoEstPre4->codestpro3 = $codestpro[2];
		$this->daoEstPre4->codestpro4 = $codestpro[3];
		$this->daoEstPre4->denestpro4 = 'POR DEFECTO';
		$this->daoEstPre4->estcla = $estcla;
		if(!$this->daoEstPre4->incluir())
		{
			$this->mensaje .= 'CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria4 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria4
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta presupuestaria existe
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 23/09/2007  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearEstructuraPresupuestaria4($codemp,$codestpro)
	{
		$this->valido=true;
		$tabla="";
		$criterio="";
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$codestpro[3]=str_pad($codestpro[3],$_SESSION["la_empresa"]["loncodestpro4"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$cadenasql="SELECT codemp ".
				 "  FROM spg_ep4 ".
				 "  WHERE codemp='".$codemp."'".
				 "    AND codestpro1='".$codestpro[0]."'".
				 "    AND codestpro2='".$codestpro[1]."'".
				 "    AND codestpro3='".$codestpro[2]."'".
				 "    AND codestpro4='".$codestpro[3]."'".
				 "    AND estcla = ".$estcla;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->chequearEstructuraPresupuestaria4 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
			else
			{
				$this->valido=$this->insertarEstructuraPresupuestaria4($codemp,$codestpro);
			}
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_insertar_estructurapresupuestaria1_destino
	//		   Access: public
	//		 Argumens: aa_codestpro // Arreglo de estructuras
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que inserta una estructura de nivel 1
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 04/06/2008  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertarEstructuraPresupuestaria5($codemp,$codestpro)
	{
		
		$this->valido=true;
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$codestpro[3]=str_pad($codestpro[3],$_SESSION["la_empresa"]["loncodestpro4"],"0",0);
		$codestpro[4]=str_pad($codestpro[4],$_SESSION["la_empresa"]["loncodestpro5"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$this->daoEstPre5 = FabricaDao::CrearDAO("N","spg_ep5");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoEstPre5->codemp=$codemp;
		$this->daoEstPre5->codestpro1 = $codestpro[0];
		$this->daoEstPre5->codestpro2 = $codestpro[1];
		$this->daoEstPre5->codestpro3 = $codestpro[2];
		$this->daoEstPre5->codestpro4 = $codestpro[3];
		$this->daoEstPre5->codestpro5 = $codestpro[4];
		$this->daoEstPre5->denestpro5 = 'POR DEFECTO';
		$this->daoEstPre5->estcla = $estcla;
		if(!$this->daoEstPre5->incluir())
		{
			$this->mensaje .= 'CLASE->SPI MÉTODO->insertarEstructuraPresupuestaria5 ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta presupuestaria existe
	//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
	// Fecha Creacion: 23/09/2007  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearEstructuraPresupuestaria($codemp,$codestpro,$nivel,$for)
	{
		$this->valido=true;
		$tabla="";
		$criterio="";
		$cadenasql="";
		for($i=0;$i<=5;$i++)
		{
			if($i==$nivel)
			{
				$tabla="spg_ep".$nivel;
			}
			if($i<$nivel)
			{
				$j=$i+1;
				$criterio=$criterio." AND codestpro".$j."='".$codestpro[$i]."' ";
			}
		}
		$criterio=$criterio." AND estcla='".$codestpro[$nivel]."' ";
		$cadenasql="SELECT codemp ".
			 	   "FROM ".$tabla." ".
			       "WHERE codemp='".$codemp."' ".
			       " ".$criterio;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->chequearEstructuraPresupuestaria ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
			else
			{
				switch($nivel) 
				{
					case 1:
						$this->valido=$this->insertarEstructuraPresupuestaria1($codemp,$codestpro);
					break;
					case 2:
						$this->valido=$this->chequearEstructuraPresupuestaria1($codemp,$codestpro);
						if($this->valido)
						{
							$this->valido=$this->insertarEstructuraPresupuestaria2($codemp,$codestpro);
						}
					break;
					case 3:
						$this->valido=$this->chequearEstructuraPresupuestaria1($codemp,$codestpro);
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria2($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->insertarEstructuraPresupuestaria3($codemp,$codestpro);
						}
					break;
					case 4:
						$this->valido=$this->chequearEstructuraPresupuestaria1($codemp,$codestpro);
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria2($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria3($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->insertarEstructuraPresupuestaria4($codemp,$codestpro);						}
					break;
					case 5:
						$this->valido=$this->chequearEstructuraPresupuestaria1($codemp,$codestpro);
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria2($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria3($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->chequearEstructuraPresupuestaria4($codemp,$codestpro);
						}
						if($this->valido)
						{
							$this->valido=$this->insertarEstructuraPresupuestaria5($codemp,$codestpro);
						}
					break;
					default:
						$this->valido=false;
					break;
				}
			}
		}
		return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_check_estructurapresupuestaria
	//		   Access: public
	//		 Argumens: as_codemp // Codigo de Empresa
	//				   aa_codestpro // Estructura Presupuestaria
	//                 as_spi_cuenta // Cuenta de Ingreso a chequear
	//				   ai_nivel // Nivel que se quiere validar
	//	      Returns: lb_valido si la cuenta existe
	//	  Description: Funcion que verifica si la cuenta de ingreso existe
	//	   Creado Por: Ing. Arnaldo Suárez
	// Fecha Creacion: 17/03/2009  								Fecha Última Modificacion : 
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function chequearSPICuentaEstructuraPresupuestaria($codemp,$spi_cuenta,$codestpro)
	{
		$this->valido=false;
		$tabla="";
		$criterio="";
		$codestpro[0]=str_pad($codestpro[0],$_SESSION["la_empresa"]["loncodestpro1"],"0",0);
		$codestpro[1]=str_pad($codestpro[1],$_SESSION["la_empresa"]["loncodestpro2"],"0",0);
		$codestpro[2]=str_pad($codestpro[2],$_SESSION["la_empresa"]["loncodestpro3"],"0",0);
		$codestpro[3]=str_pad($codestpro[3],$_SESSION["la_empresa"]["loncodestpro4"],"0",0);
		$codestpro[4]=str_pad($codestpro[4],$_SESSION["la_empresa"]["loncodestpro5"],"0",0);
		$estcla="'".$codestpro[5]."'";
		$cadenasql="SELECT codemp ".
				"   FROM spi_cuentas_estructuras ".
				"   WHERE codemp='".$codemp."'".
				"     AND codestpro1='".$codestpro[0]."'".
				"     AND codestpro2='".$codestpro[1]."'".
				"     AND codestpro3='".$codestpro[2]."'".
				"     AND codestpro4='".$codestpro[3]."'".
				"     AND codestpro5='".$codestpro[4]."'".
				"     AND estcla =".$estcla.
				"     AND spi_cuenta = '".$spi_cuenta."'";		
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->chequearEstructuraPresupuestaria ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$this->valido=true;
			}
		}
		return $this->valido;
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	      Function:  uf_spi_insert_sipcuentas_estructuras 
	//	     Arguments:  $estprog // estructura programática
	//                   $ad_previsto // monto previsto
	//	       Returns:	 $lb_valido true si es correcto la funcion o false en caso contrario
	//	   Description:  Método que inserta en la tabla spi_cuentas_estructura la cuenta de ingreso con su respectiva estructura. 
	//     Creado por :  
	// Fecha Creacion :            Fecha última Modificacion : 
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function insertSPICuentasEstructuras($codemp,$cuenta,$estprog,$previsto,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12)
  	{
		$this->valido=true;
	 	$codestpro1=$estprog[0];
	 	$codestpro2=$estprog[1];
	 	$codestpro3=$estprog[2];
	 	$codestpro4=$estprog[3];
	 	$codestpro5=$estprog[4];
	 	$estcla=$estprog[5];
	 	
		$this->daoCuenEst = FabricaDao::CrearDAO("N","spi_cuentas_estructuras");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoCuenEst->codemp=$codemp;
		$this->daoCuenEst->spi_cuenta = $cuenta;
		$this->daoCuenEst->codestpro1 = $codestpro1;
		$this->daoCuenEst->codestpro2 = $codestpro2;
		$this->daoCuenEst->codestpro3 = $codestpro3;
		$this->daoCuenEst->codestpro4 = $codestpro4;
		$this->daoCuenEst->codestpro5 = $codestpro5;
		$this->daoCuenEst->estcla = $estcla;
		$this->daoCuenEst->previsto = $previsto;
		$this->daoCuenEst->enero = formatoNumericoBd($m1);
		$this->daoCuenEst->febrero = formatoNumericoBd($m2);
		$this->daoCuenEst->marzo = formatoNumericoBd($m3);
		$this->daoCuenEst->abril = formatoNumericoBd($m4);
		$this->daoCuenEst->mayo = formatoNumericoBd($m5);
		$this->daoCuenEst->junio = formatoNumericoBd($m6);
		$this->daoCuenEst->julio = formatoNumericoBd($m7);
		$this->daoCuenEst->agosto = formatoNumericoBd($m8);
		$this->daoCuenEst->septiembre = formatoNumericoBd($m9);
		$this->daoCuenEst->octubre = formatoNumericoBd($m10);
		$this->daoCuenEst->noviembre = formatoNumericoBd($m11);
		$this->daoCuenEst->diciembre = formatoNumericoBd($m12);
		if(!$this->daoCuenEst->incluir())
		{
			$this->mensaje .= 'CLASE->SPI MÉTODO->insertSPICuentasEstructuras ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
	 	return  $this->valido;
   	}
	
   	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	     Function: uf_spi_select_cuenta
	//		   Access: public 
	//       Argument: as_codemp // Codigo de Empresa
	//       		   as_spi_cuenta // Cuenta
	//       		   as_status // Estatus de la Cuenta
	//       		   as_denominacion // Denominacion de la Cuenta
	//       		   as_scgcuenta // Cuenta Contable
	//	  Description: Verifica si existe o no la cuenta y retorna informacion de la cuenta
	//	      Returns: un boolean 
	//	   Creado Por: Ing. Wilmer Briceño
	// Modificado Por: Ing. Yesenia Moreno								Fecha Última Modificacion : 31/05/2007
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function spiSelectCuenta($codemp,$spi_cuenta)
	{
		$cadenasql="";
		$arreglo=array();
		$arreglo['existe'] = false;
		if($_SESSION["ls_gestor"]=="INFORMIX")
		{
		  $cadenasql="SELECT spi_cuenta,status,denominacion,sc_cuenta ".
				  "   FROM spi_cuentas ".
		   		  "   WHERE codemp='".$codemp."' ".
				  "     AND spi_cuenta= '".$spi_cuenta."'"; ///print $ls_sql."1";
		}
		else
		{
		  $cadenasql="SELECT spi_cuenta,status,denominacion,sc_cuenta ".
				  "   FROM spi_cuentas ".
		   		  "   WHERE codemp='".$codemp."' ".
				  "     AND spi_cuenta= '".$spi_cuenta."' "; ///print $ls_sql."2";
		}
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{ 
			$this->mensaje .= ' CLASE->SPI MÉTODO->spiSelectCuenta ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				$arreglo['denominacion']=$resultado->field['denominacion'];
				$arreglo['status']=$resultado->field['status'];
				$arreglo['scgcuenta']=$resultado->field["sc_cuenta"];
				$arreglo['existe'] = true;	 			
			}
			else
			{
				$this->mensaje .= "La cuenta Presupuestaria ".$spi_cuenta." no esta registrada";
			}    
		}
		return $arreglo;
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	      Function:  uf_spi_update_sipcuentas_estructuras 
	//	     Arguments:  $estprog // estructura programática
	//                   $ad_previsto // monto previsto
	//	       Returns:	 $lb_valido true si es correcto la funcion o false en caso contrario
	//	   Description:  Método que inserta en la tabla spi_cuentas_estructura la cuenta de ingreso con su respectiva estructura. 
	//     Creado por :  
	// Fecha Creacion :            Fecha última Modificacion : 17/03/2009
	// Modificado por : Ing. Arnaldo Suárez
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function spiUpdateCuentasEstructuras($codemp,$cuenta,$estprog,$previsto,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12)
  	{
  		$this->valido=true;
		$codestpro1=$estprog[0];
		$codestpro2=$estprog[1];
		$codestpro3=$estprog[2];
		$codestpro4=$estprog[3];
		$codestpro5=$estprog[4];
		$estcla=$estprog[5];
		if (($codestpro1 == '0000000000000000000000000') && ($codestpro2 == '0000000000000000000000000') &&
		    ($codestpro3 == '0000000000000000000000000') && ($codestpro4 == '0000000000000000000000000') &&
		    ($codestpro5 == '0000000000000000000000000') && (empty($estcla)))
		{
			$codestpro1='-------------------------';
		 	$codestpro2='-------------------------';
			$codestpro3='-------------------------';
			$codestpro4='-------------------------';
			$codestpro5='-------------------------';
			$estcla    ='-';
		}
     
		$strPK = "codemp='{$codemp}' AND spi_cuenta='".$cuenta."' AND codestpro1='".$codestpro1."' AND codestpro2='".$codestpro2."' ";
		$strPK .= " AND codestpro3='".$codestpro3."' AND codestpro4='".$codestpro4."' AND codestpro5='".$codestpro5."' AND estcla='".$estcla."'";
		$this->daoSPICuenEstr = FabricaDao::CrearDAO('C','spi_cuentas_estructuras',null,$strPK);
		$this->daoSPICuenEstr->previsto = $previsto;
		$this->daoSPICuenEstr->enero = formatoNumericoBd($m1);
		$this->daoSPICuenEstr->febrero = formatoNumericoBd($m2);
		$this->daoSPICuenEstr->marzo = formatoNumericoBd($m3);
		$this->daoSPICuenEstr->abril = formatoNumericoBd($m4);
		$this->daoSPICuenEstr->mayo = formatoNumericoBd($m5);
		$this->daoSPICuenEstr->junio = formatoNumericoBd($m6);
		$this->daoSPICuenEstr->julio = formatoNumericoBd($m7);
		$this->daoSPICuenEstr->agosto = formatoNumericoBd($m8);
		$this->daoSPICuenEstr->agosto = formatoNumericoBd($m9);
		$this->daoSPICuenEstr->octubre = formatoNumericoBd($m10);
		$this->daoSPICuenEstr->noviembre = formatoNumericoBd($m11);
		$this->daoSPICuenEstr->diciembre = formatoNumericoBd($m12);
		if($this->daoSPICuenEstr->modificar()==0){
			$this->mensaje .= ' CLASE->SPI MÉTODO->spiUpdateCuentasEstructuras ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido=false;
		}
	 	return  $this->valido;
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //	Function:  uf_spi_buscar_meses_cuentas
    //	Access:  public
    //	Description:
    // Desarrollado 
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function buscarMesesCuentas($codemp,$cuenta)
  	{
	 	$ls_sql="";  
		$this->valido=true;
		$acum_previsto=0;
	  	$cadenasql= " SELECT sum(previsto) as previsto, sum(enero) as enero, sum(febrero) as febrero, sum(marzo) as marzo , sum(abril) as abril, ".
	           		"        sum(mayo) as mayo, sum(junio) as junio, sum(julio) as julio, sum(agosto) as agosto, sum(septiembre) as septiembre, ".
			   		"        sum(octubre) as octubre, sum(noviembre) as noviembre, sum(diciembre) as diciembre ".
			   		" FROM spi_cuentas_estructuras ".
			   		" WHERE codemp='".$codemp."' AND spi_cuenta='".$cuenta."' ";	   
  		$resultado = $this->conexionbd->Execute($cadenasql);
  		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->buscarMesesCuentas ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
	 	else
	  	{
		  	if(!$resultado->EOF)
		  	{
		  	    $montos_acum["previsto"]=$resultado->fields['previsto'];
				$montos_acum["enero"]=$resultado->fields['enero'];
				$montos_acum["febrero"]=$resultado->fields['febrero'];
				$montos_acum["marzo"]=$resultado->fields['marzo'];
				$montos_acum["abril"]=$resultado->fields['abril'];
				$montos_acum["mayo"]=$resultado->fields['mayo'];
				$montos_acum["junio"]=$resultado->fields['junio'];
				$montos_acum["julio"]=$resultado->fields['julio'];
				$montos_acum["agosto"]=$resultado->fields['agosto'];
				$montos_acum["septiembre"]=$resultado->fields['septiembre'];
				$montos_acum["octubre"]=$resultado->fields['octubre'];
				$montos_acum["noviembre"]=$resultado->fields['noviembre'];
				$montos_acum["diciembre"]=$resultado->fields['diciembre'];
			}
			else
			{
				$montos_acum["previsto"]  = 0;
				$montos_acum["enero"]     = 0;
				$montos_acum["febrero"]   = 0;
				$montos_acum["marzo"]     = 0;
				$montos_acum["abril"]     = 0;
				$montos_acum["mayo"]      = 0;
				$montos_acum["junio"]     = 0;
				$montos_acum["julio"]     = 0;
				$montos_acum["agosto"]    = 0;
				$montos_acum["septiembre"]= 0;
				$montos_acum["octubre"]   = 0;
				$montos_acum["noviembre"] = 0;
				$montos_acum["diciembre"] = 0;
			}
	  	}
	  	return $montos_acum;
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	      Function:  uf_update_saldos_apertura()                                   
	//	     Arguments:  $as_codemp --- codigo de la empresa    
	//                   $estprog --- estructura programatica        
	//                   $adec_m1.. $adec_m12 --- monto desde el  mes de enreo hasta diciembre
	//                   $ai_distribuir --- modo de distribucion
	//                   $as_spg_cuenta --- codigo de la cuenta 
	//	       Returns:  True si es correcto o false es otro caso                  
	//	   Description:  Funcion que se usa  para actualizar los saldos de la distribucion de la apertura
	//     Creado por :  Ing. Yozelin Barragán                                 
	// Fecha Creacion :  13/07/2006        Fecha última Modificacion :         
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function updateSaldosApertura($codemp,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12,$spi_cuenta,$distribuir,$previsto)
	{
		$this->valido=true;
		$strPK = "codemp='{$codemp}' AND spi_cuenta='".$spi_cuenta."' ";
		$this->daoSPICuentas = FabricaDao::CrearDAO('C','spi_cuentas',null,$strPK);
		$this->daoSPICuentas->previsto = $previsto;
		$this->daoSPICuentas->distribuir = $distribuir;
		$this->daoSPICuentas->enero = formatoNumericoBd($m1);
		$this->daoSPICuentas->febrero = formatoNumericoBd($m2);
		$this->daoSPICuentas->marzo = formatoNumericoBd($m3);
		$this->daoSPICuentas->abril = formatoNumericoBd($m4);
		$this->daoSPICuentas->mayo = formatoNumericoBd($m5);
		$this->daoSPICuentas->junio = formatoNumericoBd($m6);
		$this->daoSPICuentas->julio = formatoNumericoBd($m7);
		$this->daoSPICuentas->agosto = formatoNumericoBd($m8);
		$this->daoSPICuentas->agosto = formatoNumericoBd($m9);
		$this->daoSPICuentas->octubre = formatoNumericoBd($m10);
		$this->daoSPICuentas->noviembre = formatoNumericoBd($m11);
		$this->daoSPICuentas->diciembre = formatoNumericoBd($m12);
		if($this->daoSPICuentas->modificar()==0){
			$this->mensaje .= ' CLASE->SPI MÉTODO->updateSaldosApertura ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido=false;
		}
	    return $this->valido;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Function :        uf_obtener_hijos
	// Descripcion:      Metodo que retorna las cuentas hijas de la cuenta enviada.
	// Desarrollado por: Ing. Nelson Barraez   Modificado: Ing. Yozelin Baragán --> Fecha:13/07/2006
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function obtenerHijosMontos($codemp,$spi_cuenta)
	{
		$cadenasql = " SELECT spi_cuenta ".
			  	  	 " FROM   spi_cuentas ".
			  		 " WHERE  spi_cuenta like '".$spi_cuenta."%'  AND status='C' ".
			  		 " ORDER  BY spi_cuenta " ;
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SPI MÉTODO->obtenerHijosMontos ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$i=1;
			$data=array();
			while(!$resultado->EOF)
			{
				$sc_cuenta  =  $resultado->fields['spi_cuenta'];
				$data[$i]=$sc_cuenta;
				$i=$i+1;
				$resultado->MoveNext();
			}
		}
   		return $data;
 	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	      Function:  uf_update_distribucion_apertura()                                   
	//	     Arguments:  $as_codemp --- codigo de la empresa    
	//                   $as_cuenta --- cuenta                 
	//	       Returns:  True si es correcto o false es otro caso                  
	//	   Description:  Funcion que se usa  para actualizar los saldos de la distribucion y de las cuentas madres 
	//     Creado por :  Ing. Nelson Barraez                                 
	// Fecha Creacion :  11/04/2006        Ultima Modificacion :  Ing. Yozelin Barraagán  ---->  Fecha: 13/07/2006       
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function updateDistribucion($codemp,$cuenta,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12,$distribuir,$previsto,$estprog)
	{ 
		$this->valido=true;
		$arreglo=array();
		$serviciocomprobante = new ServicioComprobanteSPI();
		$nivel = obtenerNivelPlus($cuenta,$_SESSION["la_empresa"]['formspi']);
		$nextcuenta=$cuenta;
		$ep1=$estprog[0];
		$ep2=$estprog[1];
		$ep3=$estprog[2];
		$ep4=$estprog[3];
		$ep5=$estprog[4];
		$estcla=$estprog[5];
		//Distribuyo los montos para la cuenta actual.
		$this->valido=$this->updateSaldosApertura($codemp,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12,
		                                          $nextcuenta,$distribuir,$previsto);
		//Obtengo la cuenta anterior.
		$nextcuenta = obtenerCuentaSiguientePlus($nextcuenta,$_SESSION["la_empresa"]['formspi']);
		while(($this->valido)&&($nivel>=1))
		{
		  	//Obtengo los hijos y los montos de la cuenta.
		  	$arreglo=$this->obtenerHijosMontos($codemp,$nextcuenta);
	  	  	//Actualizo los saldos para la cuenta.
	  	  	$m1=$arreglo['enero'];
	  	  	$m2=$arreglo['febrero'];
	  	  	$m3=$arreglo['marzo'];
	  	  	$m4=$arreglo['abril'];
	  	  	$m5=$arreglo['mayo'];
	  	  	$m6=$arreglo['junio'];
	  	  	$m7=$arreglo['julio'];
	  	  	$m8=$arreglo['agosto'];
	  	  	$m9=$arreglo['septiembre'];
	  	  	$m10=$arreglo['octubre'];
	  	  	$m11=$arreglo['noviembre'];
	  	  	$m12=$arreglo['diciembre'];
			$this->valido=$this->updateSaldosApertura($codemp,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12,
		                                              $nextcuenta,$distribuir,$previsto);
			if(obtenerNivelPlus($nextcuenta,$_SESSION["la_empresa"]['formspi'])==1)
			{ 
		  		break;
			}
			$nextcuenta = obtenerCuentaSiguientePlus($nextcuenta,$_SESSION["la_empresa"]['formspi']);
			$nivel = obtenerNivelPlus($nextcuenta,$_SESSION["la_empresa"]['formspi']);
   		}//while	
   		return $this->valido;
	}
   	
	public function guardar($codemp,$objson,$arrevento)
	{
		$arrDet = $objson->arrDetalle;
		$i=0;
		$funcion = '';
		$arrcabecera = array();
		$arregloSPI = array();
		$fecha = '01/01/'.$objson->periodo;
		$fecha = convertirFechaBd($fecha);
		$codestpro[0]="";
		$codestpro[1]="";
		$codestpro[2]="";
		$codestpro[3]="";
		$codestpro[4]="";
		$codestpro[5]="";
		DaoGenerico::iniciarTrans();
		
		if(!validarFechaPeriodo($fecha)){
			$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
			$this->valido = false;
		}
		if($this->valido){
			$arrcabecera['codemp'] = $codemp;
			$arrcabecera['procede'] = 'SPIAPR';
			$arrcabecera['comprobante'] = '0000000APERTURA';
			$arrcabecera['codban'] = '---';
			$arrcabecera['ctaban'] = '-------------------------';
			$arrcabecera['fecha'] = $fecha;
			$arrcabecera['descripcion'] = 'APERTURA DE CUENTAS';
			$arrcabecera['tipo_comp'] = 2;
			$arrcabecera['tipo_destino'] = '-';
			$arrcabecera['cod_pro'] = '----------';
			$arrcabecera['ced_bene'] = '----------';
			$arrcabecera['numpolcon'] = 0;
			$arrcabecera['esttrfcmp'] = 0;
			$arrcabecera['estrenfon'] = 0;
			$arrcabecera['codfuefin'] = '--';
			$arrcabecera['total'] = 0;
			$arrcabecera['codusu'] = $_SESSION['la_logusr'];
			$for=0;
			foreach ($arrDet as $detalle){
				$cuenta=$detalle->spi_cuenta;
				$denominacion=$detalle->denominacion;
				$previsto=formatoNumericoBd($detalle->monto);
				$distribuir=$detalle->distribuir;
				$m1=$detalle->enero;
				$m2=$detalle->febrero;
				$m3=$detalle->marzo;
				$m4=$detalle->abril;
				$m5=$detalle->mayo;
				$m6=$detalle->junio;
				$m7=$detalle->julio;
				$m8=$detalle->agosto;
				$m9=$detalle->septiembre;
				$m10=$detalle->octubre;
				$m11=$detalle->noviembre;
				$m12=$detalle->diciembre;	
		
				if($_SESSION['estpreing']=='1'){
//					$ls_codestpro1=$estprog[0]; 
//			        $ls_codestpro2=$estprog[1];
//				    $ls_codestpro3=$estprog[2];
//				    $ls_codestpro4=$estprog[3];
//				    $ls_codestpro5=$estprog[4];
//				    $ls_estcla=$estprog[5];	
//				    
//				    $la_codestpro[0]=$ls_codestpro1;
//					$la_codestpro[1]=$ls_codestpro2;
//					$la_codestpro[2]=$ls_codestpro3;
//					$la_codestpro[3]=$ls_codestpro4;
//					$la_codestpro[4]=$ls_codestpro5;
//					$la_codestpro[5]=$ls_estcla;
//				    
//				    $lb_existe = $this->uf_check_spi_cuenta_estructurapresupuestaria($this->is_codemp,$as_cuenta,$la_codestpro);
//				    if (!$lb_existe)
//					{
//					   $lb_valido = $this->uf_spi_insert_sipcuentas_estructuras($this->is_codemp,$as_cuenta,$la_codestpro,$ad_previsto,$ad_m1,$ad_m2,
//							                                                         $ad_m3,$ad_m4,$ad_m5,$ad_m6,$ad_m7,$ad_m8,$ad_m9,$ad_m10,$ad_m11,
//																					 $ad_m12,$aa_seguridad);
//				    }
//				 	if(!$this->int_spi->uf_spi_select_cuenta_estructuras($this->is_codemp,$as_cuenta,$ls_status,$ls_denominacion,$ls_sc_cuenta,
//																   $ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,
//																   $ls_codestpro5,$ls_estcla))
//					  {
//						return false;												   
//					  }
				}
				else{
					$codestpro[0]="-------------------------";
					$codestpro[1]="-------------------------";
					$codestpro[2]="-------------------------";
					$codestpro[3]="-------------------------";
					$codestpro[4]="-------------------------";
					$codestpro[5]="-";
					$this->valido=$this->chequearEstructuraPresupuestaria($codemp,$codestpro,5,$for);
					if($this->valido){
						$existe=$this->chequearSPICuentaEstructuraPresupuestaria($codemp,$cuenta,$codestpro);
					}
					if(!$existe){
						$this->valido=$this->insertSPICuentasEstructuras($codemp,$cuenta,$codestpro,$previsto,
						                                                 $m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,
						                                                 $m11,$m12);
					}
					$arreglo=$this->spiSelectCuenta($codemp,$cuenta);
					if(!$arreglo['existe'])
				   	{
				    	$this->valido=false;		
				   	}
				}
				$previsto=formatoNumericoBd($detalle->monto);
				if ($previsto <> 0) 
		  		{ 
		  			$arregloSPI[$i]['codemp']=$codemp;
					$arregloSPI[$i]['procede']= $arrcabecera['procede'];
					$arregloSPI[$i]['comprobante']= $arrcabecera['comprobante'];
					$arregloSPI[$i]['codban']= $arrcabecera['codban'];
					$arregloSPI[$i]['ctaban']= $arrcabecera['ctaban'];
					$arregloSPI[$i]['fecha']= $arrcabecera['fecha'];
					$arregloSPI[$i]['orden']= $i;	
					$arregloSPI[$i]['descripcion']= $arrcabecera['descripcion'];		
					$arregloSPI[$i]['spi_cuenta'] = $detalle->spi_cuenta;
					$arregloSPI[$i]['procede_doc'] = $arrcabecera['procede'];
					$arregloSPI[$i]['documento'] = $arrcabecera['comprobante'];
					$arregloSPI[$i]['operacion'] = $this->operacionMensajeCodigo("I");
					$arregloSPI[$i]['estcla'] = $codestpro[5];
					$arregloSPI[$i]['codestpro1'] = $codestpro[0];
					$arregloSPI[$i]['codestpro2'] = $codestpro[1];
					$arregloSPI[$i]['codestpro3'] = $codestpro[2];
					$arregloSPI[$i]['codestpro4'] = $codestpro[3];
					$arregloSPI[$i]['codestpro5'] = $codestpro[4];
					$arregloSPI[$i]['codfuefin'] = '--';
					$arregloSPI[$i]['monto'] = $previsto;
					$i++;
			   		if($this->valido)
			   		{
			        	$this->valido = $this->spiUpdateCuentasEstructuras($codemp,$cuenta,$codestpro,$previsto,$m1,$m2,
					                                                       $m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11,$m12);
						$acum_ad_m1=$m1; 
						$acum_ad_m2=$m2; 
						$acum_ad_m3=$m3; 
						$acum_ad_m4=$m4;
						$acum_ad_m5=$m5;
						$acum_ad_m6=$m6;
						$acum_ad_m7=$m7;
						$acum_ad_m8=$m8;
						$acum_ad_m9=$m9;			
						$acum_ad_m10=$m10;
						$acum_ad_m11=$m11;
						$acum_ad_m12=$m12;
						$acum_ad_previsto = $previsto;													 
				   		if($_SESSION["la_empresa"]['estpreing']=='1')// si maneja estructura con las cuentas de ingreso
			       		{
			       			$montos_acum=$this->buscarMesesCuentas($codemp,$cuenta);
							$acum_ad_m1=$montos_acum["enero"]; 
							$acum_ad_m2=$montos_acum["febrero"]; 
							$acum_ad_m3=$montos_acum["marzo"]; 
							$acum_ad_m4=$montos_acum["abril"];
							$acum_ad_m5=$montos_acum["mayo"];
							$acum_ad_m6=$montos_acum["junio"];
							$acum_ad_m7=$montos_acum["julio"];
							$acum_ad_m8=$montos_acum["agosto"];
							$acum_ad_m9=$montos_acum["septiembre"];			
							$acum_ad_m10=$montos_acum["octubre"];
							$acum_ad_m11=$montos_acum["noviembre"];
							$acum_ad_m12=$montos_acum["diciembre"];
							$acum_ad_previsto=$montos_acum["previsto"];
				   		}
			  			if($this->valido)
						{
							$this->valido=$this->updateDistribucion($codemp,$cuenta,$acum_ad_m1,$acum_ad_m2,$acum_ad_m3,$acum_ad_m4,
																    $acum_ad_m5,$acum_ad_m6,$acum_ad_m7,$acum_ad_m8,$acum_ad_m9,$acum_ad_m10,
																    $acum_ad_m11,$acum_ad_m12,$distribuir,$acum_ad_previsto,$codestpro);	
						}	
			   		}
		   		}
			}
			$serviciocomprobante = new ServicioComprobante();
			if($serviciocomprobante->existeComprobante($codemp,$arrcabecera['procede'],$arrcabecera['comprobante'],$arrcabecera['codban'],$arrcabecera['ctaban'])){
				$arrevento['desevetra'] = 'Elimino el Comprobante numero '.$arrcabecera['comprobante'].' asociado a la empresa '.$codemp;
				$this->valido = /*$serviciocomprobante*/$this->eliminarComprobante($arrcabecera,$arrevento);
//				$this->mensaje .= $serviciocomprobante->mensaje;
				if($this->valido){
					$arrevento['desevetra'] .= 'Guardo el Comprobante numero '.$arrcabecera['comprobante'].' asociado a la empresa '.$codemp;
					$this->valido = /*$serviciocomprobante->*/$this->guardarComprobante($arrcabecera,null,null,$arregloSPI,$arrevento);
//					$this->mensaje .= $serviciocomprobante->mensaje;
				}
			}
			else{
				$arrevento['desevetra'] = 'Guardo el Comprobante numero '.$arrcabecera['comprobante'].' asociado a la empresa '.$codemp;
				$this->valido = /*$serviciocomprobante->*/$this->guardarComprobante($arrcabecera,null,null,$arregloSPI,$arrevento);
//				$this->mensaje .= $serviciocomprobante->mensaje;
			}
			unset($serviciocomprobante);
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				$this->mensaje.='Registro guardado con exito'; 		
			}
			else{
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}
	
	public function existeProcedencia($procede) 
	{
		$existe = false;
		$cadenaSql = "SELECT procede ".
				     "  FROM sigesp_procedencias ".
				     " WHERE procede='{$procede}'";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if ($dataSet->_numOfRows > 0) {
				$existe = true;
			}
		}
		return $existe;
	}
	
	public function validarComprobante($arrdetallespg,$arrdetallescg,$arrdetallespi)
	{
		$validar=true;
		if($this->bloanu=='0')
		{
			switch ($this->daoComprobante->procede)
			{
				case 'SEPSPA':
					$validar=false;
				break;
				case 'SCBBAC':
					$validar=false;
				break;
				case 'SOBRAS':
					$validar=false;
				break;
				case 'SOBACO':
					$validar=false;
				break;
				case 'CXPARD':
					$validar=false;
				break;
				case 'SEPAOS':
					$validar=false;
				break;
				case 'SOCAOC':
					$validar=false;
				break;
				case 'CXPAOP':
					$validar=false;
				break;
				case 'SCBBAC':
					$validar=false;
				break;
				case 'SCBBAH':
					$validar=false;
				break;
			}
		}
		if((is_null($this->daoComprobante->comprobante)) or (empty($this->daoComprobante->comprobante)))
		{
			$this->mensaje .= 'El N° de Comprobante no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;			
			$this->valido = false;	
		}
		if((is_null($this->daoComprobante->procede)) or (empty($this->daoComprobante->procede)))
		{
			$this->mensaje = 'La procedencia no puede tener valor nulo o vacio .'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		} 	  
		if((is_null($this->daoComprobante->descripcion)) or (empty($this->daoComprobante->descripcion)))
		{
			$this->mensaje .= 'La descripci&#243;n no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		} 	
		if((is_null($this->daoComprobante->tipo_destino)) or (empty($this->daoComprobante->tipo_destino)))
		{ 
			$this->mensaje .= 'El Tipo (Beneficiario o Proveedor) no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		} 	
		if((is_null($this->daoComprobante->cod_pro)) or ($this->daoComprobante->cod_pro=='') or (is_null($this->daoComprobante->ced_bene)) or ($this->daoComprobante->ced_bene==''))
		{
			$this->mensaje .=  'El Beneficiario o Proveedor no puede tener valor nulo o vac&#237;o.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		}
		$servicioBeneficiario = new ServicioBeneficiario();
		if($servicioBeneficiario->existeBeneficiario($this->daoComprobante->codemp,$this->daoComprobante->ced_bene)===false)
		{
			$this->mensaje .=  'El Beneficiario '.$this->daoComprobante->ced_bene.' no Existe en la Ficha de Beneficiarios.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		}
		unset($servicioBeneficiario);
		$servicioProveedor = new servicioProveedor();
		if($servicioProveedor->existeProveedor($this->daoComprobante->codemp,$this->daoComprobante->cod_pro)===false)
		{
			$this->mensaje .=  'El Proveedor '.$this->daoComprobante->cod_pro.' no Existe en la Ficha de Proveedores.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		}
		unset($servicioProveedor);
		if(!($this->existeProcedencia($this->daoComprobante->procede)))
		{ 
			$this->mensaje .=  'El Procede '.$this->daoComprobante->procede.' no Existe.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
			$this->valido = false;	
		}
		if($validar)
		{
			if (!(validarFechaMes($this->daoComprobante->fecha)))
			{
				$this->mensaje .=  'El Mes '.obtenerNombreMes(substr($this->daoComprobante->fecha,5,2)).' no esta abierto.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
				$this->valido = false;	
			}
			else
			{
				if(!validarFechaPeriodo($this->daoComprobante->fecha))
				{
					$this->mensaje .=  'La fecha '.substr($this->daoComprobante->fecha,5,2).' Est&#225; fuera del periodo.'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
					$this->valido = false;	
				}
			}
		}
		$totalSPG=count($arrdetallespg);
		$totalSCG=count($arrdetallescg);
		$totalSPI=count($arrdetallespi);
		if($totalSCG<=0)
		{
			if($totalSPG<=0)
			{
				if($totalSPI<=0)
				{
				}
			}
		}
		else
		{
			$totalDebe=0;
			$totalHaber=0;
			for($i=1;$i<=$totalSCG;$i++)
			{
				if($arrdetallescg[$i]['debhab']==='D')
				{
					$totalDebe=$totalDebe + number_format($arrdetallescg[$i]['monto'],2,'.','');
				}
				else
				{
					$totalHaber=$totalHaber + number_format($arrdetallescg[$i]['monto'],2,'.','');
				}
			}
			if( number_format($totalDebe,2,'.','')!=number_format($totalHaber,2,'.',''))
			{
				$this->mensaje .=  'El comprobante '.$this->daoComprobante->comprobante.', esta descuadrado Debe ('.number_format($totalDebe,2,',','.').') Haber ('.number_format($totalHaber,2,',','.').') .'.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;
				$this->valido = false;	
			}
		}
		return $this->valido;
	}
	
	public function cargarDetallesComprobante($tipoevento='',$fechaanula='',$procedeanula='',$conceptoanula='')
	{
		$arrdetallespg=null;
		$arrdetallescg=null;
		$arrdetallespi=null;
		//CARGAMOS LOS DETALLES CONTABLES
		$cadenaSql="SELECT codemp,procede,comprobante,codban,ctaban,sc_cuenta,procede_doc,documento,debhab,fecha,descripcion,monto,orden ".
				   "  FROM scg_dt_cmp ".
				   " WHERE codemp='".$this->daoComprobante->codemp."' ".
				   "   AND procede='".$this->daoComprobante->procede."' ".
				   "   AND comprobante='".$this->daoComprobante->comprobante."' ".
				   "   AND fecha='".$this->daoComprobante->fecha."'".
				   "   AND codban='".$this->daoComprobante->codban."'".
				   "   AND ctaban='".$this->daoComprobante->ctaban."'".
				   " ORDER BY orden";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$i=0;
			while(!$dataSet->EOF)
			{
				$i++;
				$arrdetallescg[$i]['codemp'] = $dataSet->fields['codemp'];
				$arrdetallescg[$i]['procede'] = $dataSet->fields['procede'];
				$arrdetallescg[$i]['comprobante'] = $dataSet->fields['comprobante'];
				$arrdetallescg[$i]['codban'] = $dataSet->fields['codban'];
				$arrdetallescg[$i]['ctaban'] = $dataSet->fields['ctaban'];
				$arrdetallescg[$i]['sc_cuenta'] = $dataSet->fields['sc_cuenta'];
				$arrdetallescg[$i]['procede_doc'] = $dataSet->fields['procede_doc'];
				$arrdetallescg[$i]['documento'] = $dataSet->fields['documento'];
				$arrdetallescg[$i]['debhab'] = $dataSet->fields['debhab'];
				$arrdetallescg[$i]['fecha'] = $dataSet->fields['fecha'];
				$arrdetallescg[$i]['descripcion'] = $dataSet->fields['descripcion'];
				$arrdetallescg[$i]['monto'] = $dataSet->fields['monto'];
				$arrdetallescg[$i]['orden'] = $dataSet->fields['orden'];
				if($tipoevento=='ANULA')
				{
					if($arrdetallescg[$i]['debhab']=='D')
					{
						$arrdetallescg[$i]['debhab']='H';
					}
					else
					{
						$arrdetallescg[$i]['debhab']='D';
					}
					$arrdetallescg[$i]['procede'] = $procedeanula;	
					$arrdetallescg[$i]['fecha'] = $fechaanula;
					$arrdetallescg[$i]['descripcion'] .= ' '.$conceptoanula;
					$arrdetallescg[$i]['procede_doc'] = $dataSet->fields['procede'];
					$arrdetallescg[$i]['documento'] = $dataSet->fields['comprobante'];
				}
				$dataSet->MoveNext();
			}
		}
		unset($dataSet);
		//CARGAMOS LOS DETALLES PRESUPUESARIOS DE GASTO
		$cadenaSql="SELECT codemp,procede,comprobante,codban,ctaban,estcla,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,spg_cuenta,".
				   "       procede_doc,documento,operacion,codfuefin,fecha,descripcion,monto,orden ".
				   "  FROM spg_dt_cmp ".
				   " WHERE codemp='".$this->daoComprobante->codemp."' ".
				   "   AND procede='".$this->daoComprobante->procede."' ".
				   "   AND comprobante='".$this->daoComprobante->comprobante."' ".
				   "   AND fecha='".$this->daoComprobante->fecha."'".
				   "   AND codban='".$this->daoComprobante->codban."'".
				   "   AND ctaban='".$this->daoComprobante->ctaban."'".
				   " ORDER BY orden";
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$i=0;
			while(!$dataSet->EOF)
			{
				$i++;
				$arrdetallespg[$i]['codemp']=$dataSet->fields['codemp'];
				$arrdetallespg[$i]['procede']= $dataSet->fields['procede'];
				$arrdetallespg[$i]['comprobante']= $dataSet->fields['comprobante'];
				$arrdetallespg[$i]['codban']= $dataSet->fields['codban'];
				$arrdetallespg[$i]['ctaban']= $dataSet->fields['ctaban'];
				$arrdetallespg[$i]['estcla']=$dataSet->fields['estcla'];
				$arrdetallespg[$i]['codestpro1']=$dataSet->fields['codestpro1'];
				$arrdetallespg[$i]['codestpro2']=$dataSet->fields['codestpro2'];
				$arrdetallespg[$i]['codestpro3']=$dataSet->fields['codestpro3'];
				$arrdetallespg[$i]['codestpro4']=$dataSet->fields['codestpro4'];
				$arrdetallespg[$i]['codestpro5']=$dataSet->fields['codestpro5'];
				$arrdetallespg[$i]['spg_cuenta']=$dataSet->fields['spg_cuenta'];
				$arrdetallespg[$i]['procede_doc']= $dataSet->fields['procede_doc'];
				$arrdetallespg[$i]['documento']= $dataSet->fields['documento'];
				$arrdetallespg[$i]['operacion']= $dataSet->fields['operacion'];
				$arrdetallespg[$i]['codfuefin']=$dataSet->fields['codfuefin'];
				$arrdetallespg[$i]['fecha']= $dataSet->fields['fecha'];
				$arrdetallespg[$i]['descripcion']= $dataSet->fields['descripcion'];
				$arrdetallespg[$i]['monto']=$dataSet->fields['monto'];
				$arrdetallespg[$i]['orden']= $dataSet->fields['orden'];
				if($tipoevento=='ANULA')
				{
					$arrdetallespg[$i]['procede'] = $procedeanula;	
					$arrdetallespg[$i]['fecha'] = $fechaanula;
					$arrdetallespg[$i]['descripcion'] .= ' '.$conceptoanula;
					$arrdetallespg[$i]['monto'] = $arrdetallespg[$i]['monto']*(-1);
					$arrdetallespg[$i]['mensaje'] = '';
					$arrdetallespg[$i]['procede_doc']= $dataSet->fields['procede'];
					$arrdetallespg[$i]['documento']= $dataSet->fields['comprobante'];
				}
				$dataSet->MoveNext();
			}
		}
		unset($dataSet);
		//CARGAMOS LOS DETALLES PRESUPUESARIOS DE INGRESO
		$cadenaSql="SELECT codemp,procede,comprobante,codban,ctaban,estcla,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,spi_cuenta,procede_doc,documento,operacion,fecha,descripcion,monto,orden ".
				   "  FROM spi_dt_cmp ".
				   " WHERE codemp='".$this->daoComprobante->codemp."' ".
				   "   AND procede='".$this->daoComprobante->procede."' ".
				   "   AND comprobante='".$this->daoComprobante->comprobante."' ".
				   "   AND fecha='".$this->daoComprobante->fecha."'".
				   "   AND codban='".$this->daoComprobante->codban."'".
				   "   AND ctaban='".$this->daoComprobante->ctaban."'".
				   " ORDER BY orden";	
		$dataSet  = $this->conexionbd->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= '  ->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$i=0;
			while(!$dataSet->EOF)
			{
				$i++;
				$arrdetallespi[$i]['codemp']=$dataSet->fields['codemp'];
				$arrdetallespi[$i]['procede']= $dataSet->fields['procede'];
				$arrdetallespi[$i]['comprobante']= $dataSet->fields['comprobante'];
				$arrdetallespi[$i]['codban']= $dataSet->fields['codban'];
				$arrdetallespi[$i]['ctaban']= $dataSet->fields['ctaban'];
				$arrdetallespi[$i]['estcla']=$dataSet->fields['estcla'];
				$arrdetallespi[$i]['codestpro1']=$dataSet->fields['codestpro1'];
				$arrdetallespi[$i]['codestpro2']=$dataSet->fields['codestpro2'];
				$arrdetallespi[$i]['codestpro3']=$dataSet->fields['codestpro3'];
				$arrdetallespi[$i]['codestpro4']=$dataSet->fields['codestpro4'];
				$arrdetallespi[$i]['codestpro5']=$dataSet->fields['codestpro5'];
				$arrdetallespi[$i]['spi_cuenta']=$dataSet->fields['spi_cuenta'];
				$arrdetallespi[$i]['procede_doc']= $dataSet->fields['procede_doc'];
				$arrdetallespi[$i]['documento']= $dataSet->fields['documento'];
				$arrdetallespi[$i]['operacion']= $dataSet->fields['operacion'];
				$arrdetallespi[$i]['fecha']= $dataSet->fields['fecha'];
				$arrdetallespi[$i]['descripcion']= $dataSet->fields['descripcion'];
				$arrdetallespi[$i]['monto']=$dataSet->fields['monto'];
				$arrdetallespi[$i]['orden']= $dataSet->fields['orden'];
				if($tipoevento=='ANULA')
				{
					$arrdetallespi[$i]['procede'] = $procedeanula;	
					$arrdetallespi[$i]['fecha'] = $fechaanula;
					$arrdetallespi[$i]['descripcion'] .= ' '.$conceptoanula;
					$arrdetallespi[$i]['monto'] = $arrdetallespi[$i]['monto']*(-1);
					$arrdetallespi[$i]['procede_doc']= $dataSet->fields['procede'];
					$arrdetallespi[$i]['documento']= $dataSet->fields['comprobante'];
				}
				$dataSet->MoveNext();
			}
		}
		unset($dataSet);
		$arrResultado['Spg']=$arrdetallespg;
		$arrResultado['Scg']=$arrdetallescg;
		$arrResultado['Spi']=$arrdetallespi;
		return $arrResultado;
	}
	
	public function eliminarComprobante($arrcabecera,$arrevento)
	{
		$criterio="codemp = '".$arrcabecera['codemp']."' AND procede='".$arrcabecera['procede']."' AND comprobante='".fillComprobante($arrcabecera['comprobante'])."' AND codban='".$arrcabecera['codban']."' AND ctaban='".$arrcabecera['ctaban']."'";
		$this->daoComprobante = FabricaDao::CrearDAO('C','sigesp_cmp','',$criterio);
		$_SESSION['fechacomprobante']=$this->daoComprobante->fecha;
		$arrResultado=$this->cargarDetallesComprobante();
		$arrdetallespg=$arrResultado['Spg'];
		$arrdetallescg=$arrResultado['Scg'];
		$arrdetallespi=$arrResultado['Spi'];
		if($this->validarComprobante($arrdetallespg,$arrdetallescg,$arrdetallespi)&&($this->valido))
		{
			if((count($arrdetallespg)>0)&&($this->valido))
			{
				// eliminar detalles de Presupuesto de Gasto
				$servicioDetalleSPG = new ServicioComprobanteSPG();
				$servicioDetalleSPG->conexionBaseDatos = $this->conexionBaseDatos;
				$this->valido=$servicioDetalleSPG->eliminarDetalleSPG($this->daoComprobante,$arrdetallespg,$arrevento);
				$this->mensaje=$servicioDetalleSPG->mensaje;
				unset($servicioDetalleSPG);
			}
			if((count($arrdetallescg)>0)&&($this->valido))
			{
				// eliminar detalles de contabilidad
				$servicioDetalleSCG = new ServicioComprobanteSCG();
				$servicioDetalleSCG->conexionBaseDatos = $this->conexionBaseDatos;
				$this->valido=$servicioDetalleSCG->eliminarDetalleSCG($this->daoComprobante,$arrdetallescg,$arrevento);
				$this->mensaje=$servicioDetalleSCG->mensaje;
				unset($servicioDetalleSCG);
			}
			if((count($arrdetallespi)>0)&&($this->valido))
			{
				// incluir detalles de Contabilidad 
				$servicioDetalleSPI = new ServicioComprobanteSPI();
				//$servicioDetalleSPI->conexionBaseDatos = $this->conexionBaseDatos;
				$this->valido=$servicioDetalleSPI->eliminarDetalleSPI($this->daoComprobante,$arrdetallespi,$arrevento);
				$this->mensaje=$servicioDetalleSPI->mensaje;
				unset($servicioDetalleSPI);						
			}
			if ($this->valido)
			{
				$this->valido = $this->daoComprobante->eliminar();
				if(!$this->valido)
				{
					$this->mensaje .= $this->daoComprobante->ErrorMsg;
				}
			}
		}
		else
		{
			$this->valido = false;
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra='Elimino el comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;			
		if ($this->valido) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
	}
	
	public function guardarComprobante($arrcabecera,$arrdetallespg,$arrdetallescg,$arrdetallespi,$arrevento) 
	{
		$this->daoComprobante = FabricaDao::CrearDAO('N', 'sigesp_cmp');
		$this->daoComprobante->codemp      = $arrcabecera['codemp'];
		$this->daoComprobante->procede     = $arrcabecera['procede'];
		$this->daoComprobante->comprobante = fillComprobante($arrcabecera['comprobante']);
		$this->daoComprobante->codban      = $arrcabecera['codban'];
		$this->daoComprobante->ctaban      = $arrcabecera['ctaban'];
		$this->daoComprobante->fecha       = $arrcabecera['fecha'];
		$this->daoComprobante->descripcion = $arrcabecera['descripcion'];
		$this->daoComprobante->tipo_comp   = $arrcabecera['tipo_comp'];
		$this->daoComprobante->tipo_destino= $arrcabecera['tipo_destino'];
		$this->daoComprobante->cod_pro     = $arrcabecera['cod_pro'];
		$this->daoComprobante->ced_bene    = $arrcabecera['ced_bene'];
		$this->daoComprobante->total       = $arrcabecera['total'];
		$this->daoComprobante->numpolcon   = $arrcabecera['numpolcon'];
		$this->daoComprobante->esttrfcmp   = $arrcabecera['esttrfcmp'];
		$this->daoComprobante->estrenfon   = $arrcabecera['estrenfon'];
		$this->daoComprobante->codfuefin   = $arrcabecera['codfuefin'];
		$this->daoComprobante->codusu      = $arrcabecera['codusu'];
		if($this->validarComprobante($arrdetallespg,$arrdetallescg,$arrdetallespi))
		{
			$this->valido = $this->daoComprobante->incluir();
			if($this->valido)
			{
				if((count($arrdetallespg)>0)&&($this->valido))
				{
					// incluir detalles de Presupuesto de Gasto
					$servicioDetalleSPG = new ServicioComprobanteSPG();
					$servicioDetalleSPG->conexionBaseDatos = $this->conexionBaseDatos;
					$this->valido=$servicioDetalleSPG->guardarDetalleSPG($this->daoComprobante,$arrdetallespg,$arrevento);
					$this->mensaje=$servicioDetalleSPG->mensaje;
					unset($servicioDetalleSPG);				
				}
				if((count($arrdetallescg)>0)&&($this->valido))
				{
					// incluir detalles de Contabilidad 
					$servicioDetalleSCG = new ServicioComprobanteSCG();
					$servicioDetalleSCG->conexionBaseDatos = $this->conexionBaseDatos;
					$this->valido=$servicioDetalleSCG->guardarDetalleSCG($this->daoComprobante,$arrdetallescg,$arrevento);
					$this->mensaje=$servicioDetalleSCG->mensaje;
					unset($servicioDetalleSCG);						
				}
				if((count($arrdetallespi)>0)&&($this->valido))
				{
					// incluir detalles de Contabilidad 
					$servicioDetalleSPI = new ServicioComprobanteSPI();
					//$servicioDetalleSPI->conexionBaseDatos = $this->conexionBaseDatos;
					$this->valido=$servicioDetalleSPI->guardarDetalleSPI($arrdetallespi,$arrevento);
					$this->mensaje=$servicioDetalleSPI->mensaje;
					unset($servicioDetalleSPI);						
				}
			}
			else
			{
				$this->mensaje .= $this->daoComprobante->ErrorMsg;
			}
		}
		else
		{
			$this->valido = false;
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra='Incluyo el comprobante '.$this->daoComprobante->codemp.'::'.$this->daoComprobante->procede.'::'.$this->daoComprobante->comprobante.'::'.$this->daoComprobante->codban.'::'.$this->daoComprobante->ctaban;			
		if ($this->valido) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
	}
}
?>