<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio modificacion de presupuesto programado 
 * 		 
 */
interface IModPrePro 
{
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca las cuentas presupuestarias asociadas a la estructura
	 * @param string $codemp - codigo de empresa
	 * @param string $codigo - numero de la cuenta presupuestaria
	 * @param string $denominacion - denominacion de la cuenta presupuestaria
	 * @param string $codcontable - cuenta contable asociada a la cuenta presupuestaria
	 * @param string $codestpro1 - estructura nivel 1
	 * @param string $codestpro2 - estructura nivel 2
	 * @param string $codestpro3 - estructura nivel 3
	 * @param string $codestpro4 - estructura nivel 4
	 * @param string $codestpro5 - estructura nivel 5
	 * @param string $estcla - estatus de clasificacion
	 * @return Resulset Adodb con los datos de las cuentas presupuestarias.
	 */ 
	public function buscarCuentasPresupuestarias($codemp,$codigo,$denominacion,$codcontable,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla);

	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que guardar la modificacion presupuestaria programada
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function buscarDisponibilidadMensual($codemp,$objson,$arrevento);
//	
//	/**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que elimina el comprobante de modificacion presupuestaria (rectificacion)
//	 * @param string $codemp - codigo de empresa
//	 * @param Json $objson - json con los datos de la interfaz
//	 * @param Array $arrevento - arreglo con los datos del log
//	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
//	 */
//	public function eliminar($codemp,$objson,$arrevento);
//	
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que verifica si existe un comprobante
//	 * @param string $codemp - codigo de empresa
//	 * @param string $procede - procede
//	 * @param string $comprobante - nro de comprobante
//	 * @param string $fecha - fecha
//	 * @return boolean $existe - Si existe el comprobante o no
//	 */	
//	public function existeComprobante($codemp,$procede,$comprobante,$fecha);
//	
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que verifica si existe un procede
//	 * @param string $codemp - codigo de empresa
//	 * @param string $procede - procede
//	 * @return boolean $existe - Si existe la procedencia
//	 */	
//	public function existeProcedencia($procede);	
//	
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que verifica si la informacion del comprobante esta correcta
//	 * @return boolean $valido - Si la informacion del comprobante es válida
//	 */	
//	public function validarComprobante($arrdetallespg);		
//
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que obtiene los detalles presupuestario de un comprobante 
//	 * @param arreglo $arrdetallespg - Arreglo con la informacion del detalle presupuestario de gasto
//	 * @param string  $tipoevento    - tipo de evento si es para normal o si es para anular
//	 * @param string  $fechaanula    - Fecha de anulacion para el caso de que el tipo evento sea de anulacion 
//	 * @param string  $procedeanula  - Procede de anulacion para el caso de que el tipo evento sea de anulacion
//	 * @param string  $conceptoanula - Concepto de anulacion para el caso de que el tipo evento sea de anulacion
//	 * @return boolean $valido - Si se obtuvieron los detalles de manera exitosa.
//	 */
//	public function cargarDetallesComprobante($tipoevento='',$fechaanula='',$procedeanula='',$conceptoanula='');	
//	
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que guarda un comprobante
//	 * @param arreglo $arrcabecera - Arreglo con la informacion de la cabecera
//	 * @param arreglo $arrdetallespg - Arreglo con la informacion del detalle presupuestario de gasto
//	 * @param  arreglo $arrevento - Arreglo con la informacion del evento que se está ejecutando 
//	 * @return boolean $valido - Si el comprobante se guardo de manera exitosa
//	 */
//	public function guardarComprobante($arrcabecera,$arrdetallespg,$arrevento);
//
//	 /**
//	 * @author Ing. Maryoly Caceres
//	 * @desc Metodo que elimina un comprobante
//	 * @param arreglo $arrcabecera - Arreglo con la informacion de la cabecera
//	 * @param  arreglo $arrevento - Arreglo con la informacion del evento que se está ejecutando
//	 * @return boolean $valido - Si se elimino el comprobante de manera exitosa
//	 */
//	public function eliminarComprobante($arrcabecera,$arrevento);	
	
}
?>