<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio de cierre presupuestario de gasto
 */
interface ICierrePresupuestarioGasto 
{
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Mtodo que genera el cierre/reverso de presupuesto de gasto.
	 * @param string $codemp - codigo de empresa.
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function procesarCierrePresupuestario($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Mtodo que retorna el valor del estatus de cierre presupuestario.
	 * @param string $codemp - codigo de la empresa.
	 * @return integer $resultado - numero que indica el valor del estatus de cierre presupuestario 1 y 0
	 */
	public function buscarEstCiePreGas($codemp);

}