<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/soc/sigesp_srv_soc_iregistro_orden_compra.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_comprobantespg.php');

class ServicioRegistroOrdenCompra implements IRegistroOrdenCompra {

	public  $mensaje; 
	public  $valido;   
	private $conexionBaseDatos; 
	private $servicioComprobante;
	private $daoRegistroEvento;
	private $daoRegistroOrdenCompra;
	private $daoDetalleSEP;
	private $daoDetalle;
	private $daoCuentaGasto;
	private $daoSolicitudCargo;
	private $daoPais;
	private $daoCambioEstatusItemSep;
	private $daoCambioEstatus;
	private $daoEliminar;
	private $daoDetalleCargos;
	
	public function ServicioRegistroOrdenCompra() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoRegistroOrdenCompra = null;
		$this->daoRegistroEvento = null;
		$this->daoDetalleSEP = null;
		$this->daoDetalle = null;
		$this->daoCuentaGasto = null;
		$this->daoSolicitudCargo = null;
		$this->daoCambioEstatusItemSep = null;
		$this->daoPais = null;
		$this->daoCambioEstatus = null;
		$this->daoEliminar = null;
		$this->daoDetalleCargos = null;
	}
	
	
	public function buscarNumeroOrdenCompra($codemp,$estcondat) {
		$this->daoRegistroOrdenCompra = FabricaDao::CrearDAO('N','soc_ordencompra');
		$this->daoRegistroOrdenCompra->codemp = $codemp;
		$arreglo = array();
		if($estcondat=='B'){
		  $procede="SOCCOC";
		  $arreglo['estcondat'] = 'B';
		}
		else{
		  $procede="SOCCOS";
		  $arreglo['estcondat'] = 'S';
		}
		return $this->daoRegistroOrdenCompra->buscarCodigo('numordcom',true,15,$arreglo,'SOC',$procede,$_SESSION['la_logusr']);
	}
	
	public function buscarExistenciaCuenta($codemp,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT COUNT(spg_cuentas.spg_cuenta) as existecuenta ".
				"  	  FROM spg_cuentas ".
				"	  WHERE spg_cuentas.codemp = '{$codemp}'  ". 
				"       AND spg_cuentas.codestpro1 = '{$codestpro1}'".
				"       AND spg_cuentas.codestpro2 = '{$codestpro2}' ".
				"   	AND spg_cuentas.codestpro3 = '{$codestpro3}' ".
				"   	AND spg_cuentas.codestpro4 = '{$codestpro4}' ".
			 	"   	AND spg_cuentas.codestpro5 = '{$codestpro5}' ".
				"   	AND spg_cuentas.estcla = '{$estcla}' ";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['existecuenta'];
	}
	
	public function buscarModCla($codemp, $codtipmod, $denmodcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT  codtipmod,denmodcla ".
				   "  FROM soc_modalidadclausulas ".
				   "  WHERE soc_modalidadclausulas.codemp='{$codemp}' ".
				   "    AND codtipmod <> '--' "; 
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarTipoMoneda($restriccion){
		$this->daoTipoMoneda = FabricaDao::CrearDAO("N", "sigesp_moneda");
		$dataTipoMoneda = $this->daoTipoMoneda->buscarCampoRestriccion($restriccion);
		unset($this->daoRegistroOrdenCompra);
		return $dataTipoMoneda;
	}
	
	public function buscarPais() {
		$this->daoPais = FabricaDao::CrearDAO("N", "sigesp_pais");
		$dataPais = $this->daoPais->leerTodos();
		unset($this->daoRegistroOrdenCompra);
		return $dataPais;
	}
	
	public function buscarEstado($restriccion) {
		$this->daoEstado = FabricaDao::CrearDAO("N", "sigesp_estados");
		$dataEstado = $this->daoEstado->buscarCampoRestriccion($restriccion);
		unset($this->daoRegistroOrdenCompra);
		return $dataEstado;
	}
	
	public function buscarMunicipio($restriccion) {
		$this->daoMunicipio = FabricaDao::CrearDAO("N", "sigesp_municipio");
		$dataMunicipio = $this->daoMunicipio->buscarCampoRestriccion($restriccion);
		unset($this->daoRegistroOrdenCompra);
		return $dataMunicipio;
	}
	
	public function buscarParroquia($restriccion) {
		$this->daoParroquia = FabricaDao::CrearDAO("N", "sigesp_parroquia");
		$dataParroquia = $this->daoParroquia->buscarCampoRestriccion($restriccion);
		unset($this->daoRegistroOrdenCompra);
		return $dataParroquia;
	}
	
	//funciones elaboradas por maryoly caceres
	function select_cuentacontable($codemp,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$cuenta,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "SELECT sc_cuenta ".
				"  	  FROM spg_cuentas ".
				" 	  WHERE codemp='{$codemp}' ".
				"   	AND codestpro1='{$codestpro1}' ".
				"   	AND codestpro2='{$codestpro2}' ".
				"  		AND codestpro3='{$codestpro3}' ".
				"  		AND codestpro4='{$codestpro4}' ".
				"   	AND codestpro5='{$codestpro5}' ".
				"   	AND estcla= '{$estcla}'".
				"	   	AND spg_cuenta='{$cuenta}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['sc_cuenta'];
	}
	
	public function existeCuenta($codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla,$spgcuenta)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$existe=false;
		$cadenaSQL="SELECT spg_cuenta FROM spg_cuentas ".
				"   WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
				"     AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
				"     AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
				"     AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
				"     AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
				"     AND spg_cuentas.estcla = '".$estcla."' ".
				"     AND spg_cuentas.spg_cuenta='".$spgcuenta."' ";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  CLASE->INTEGRADOR SOC METODO->existeCuenta ERROR->->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$data->EOF)
			{
				$existe=true;
			}
		}
		return $existe;
	}
	
	public function buscarCuentasGastos($codemp,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,
	 									$estcla,$codfuefin,$spgcuenta,$numordcom,$estcondat,$monto)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$cadenaSQL="SELECT * FROM soc_cuentagasto ".
				"   WHERE codemp = '".$codemp."' ".
				"     AND codestpro1 = '".$codestpro1."' ".
				"     AND codestpro2 = '".$codestpro2."' ".
				"     AND codestpro3 = '".$codestpro3."' ".
				"     AND codestpro4 = '".$codestpro4."' ".
				"     AND codestpro5 = '".$codestpro5."' ".
				"     AND estcla = '".$estcla."' ".
				"     AND codfuefin = '".$codfuefin."' ".
				"     AND spg_cuenta='".$spgcuenta."' ";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  CLASE->INTEGRADOR SOC METODO->buscarCuentasGastos ERROR->->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$data->EOF)
			{
				if($data->fields['codestpro1']==$codestpro1 && $data->fields['codestpro2']==$codestpro2
				   && $data->fields['codestpro3']==$codestpro3 && $data->fields['codestpro4']==$codestpro4
				   && $data->fields['codestpro5']==$codestpro5 && $data->fields['estcla']==$estcla
				   && $data->fields['codfuefin']==$codfuefin && $data->fields['spg_cuenta']==$spgcuenta
				   && $data->fields['numordcom']==$numordcom && $data->fields['estcondat']==$estcondat)
				{
					$monto=formatoNumericoBd($monto,1);
	                $total=$monto+$data->fields['monto'];			
					$str = "codemp='{$codemp}' AND codestpro1='{$codestpro1}' AND codestpro2='{$codestpro2}' ".
					       "AND codestpro3='{$codestpro3}' AND codestpro4='{$codestpro4}' AND codestpro5='{$codestpro5}' ".
					       "AND estcla='{$estcla}' AND codfuefin='{$codfuefin}' AND spg_cuenta='{$spgcuenta}' ".
					       "AND numordcom='{$numordcom}' AND estcondat='{$estcondat}' ";
					$this->daoCambioMontoCuenta = FabricaDao::CrearDAO('C','soc_cuentagasto','',$str);
					$this->daoCambioMontoCuenta->monto=$total;
					if(!$this->daoCambioMontoCuenta->modificar())
					{
						$this->mensaje .= '  CLASE->INTEGRADOR SOC METODO->buscarCuentasGastos ERROR->->'.$this->conexionBaseDatos->ErrorMsg();
						$this->valido = false;
						break;
					}
				}
				else{
					$this->daoCuentaGasto = FabricaDao::CrearDAO("N","soc_cuentagasto");
					$this->daoCuentaGasto->codemp = $codemp;
					$this->daoCuentaGasto->codestpro1 = $codestpro1;
					$this->daoCuentaGasto->codestpro2 = $codestpro2;
					$this->daoCuentaGasto->codestpro3 = $codestpro3;
					$this->daoCuentaGasto->codestpro4 = $codestpro4;
					$this->daoCuentaGasto->codestpro5 = $codestpro5;
					$this->daoCuentaGasto->codfuefin = $codfuefin;
					$this->daoCuentaGasto->spg_cuenta = $spgcuenta;
					$this->daoCuentaGasto->estcla = $estcla;
					$this->daoCuentaGasto->numordcom = $numordcom;
					$this->daoCuentaGasto->estcondat = $estcondat;
					$this->daoCuentaGasto->monto = formatoNumericoBd($monto,1); 
					if(!$this->daoCuentaGasto->incluir())
					{
						$this->mensaje .= 'Error al guardar el detalle de cuentas en soc_cuentagasto->';
						$this->valido = false;
						break;
					}
				}
			}
		}
		return $this->valido;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/soc/iregistro_orden_compra::guardarParametro()
	*/
	public function guardarOrdCom($codemp,$objJson,$arrevento)
	 {
		$resultado = 0;//variable que indica el resultado de la operacion
		$i=0;
		$arreglo = array();
		$arrDetalle = $objJson->detallesOrdenCompra;
		$arrDetalleSEP = $objJson->detalleSep;
		$numero = count($arrDetalleSEP);
		$arrCueGas = $objJson->detallesCuentasGastos;
		$arrSolCar = $objJson->detallesSolicitudCargos;
		$arrCargos = $objJson->detallesCargos;
		$numcuegas = count($arrCueGas);
		$numsolcar = count($arrSolCar);
		$fecha = $this->validarFecha($codemp);
		$fechaordcom = convertirFechaBd($objJson->fecordcom);
		DaoGenerico::iniciarTrans();
		
		if($objJson->permisoAdm!='1'){
			if(compararFecha($fecha,$fechaordcom)){
				$this->valido=false;
				$this->mensaje.='La Fecha de esta Orden de Compra es menor, a la ultima orden registrada ';
			}
		}
		if($this->valido){
			if(!$this->validaFechaPeriodo($fechaordcom,$codemp)){
				$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
				$this->valido = false;	
			}
		}
		if($this->valido){
			//obteniendo las instacias de los dao's
			$this->daoRegistroOrdenCompra = FabricaDao::CrearDAO("N","soc_ordencompra");
	
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroOrdenCompra->setData($objJson);
			$this->daoRegistroOrdenCompra->codemp=$codemp;
			$this->daoRegistroOrdenCompra->fecordcom = $fechaordcom;
			$this->daoRegistroOrdenCompra->monsubtotbie = 0;
			$this->daoRegistroOrdenCompra->monsubtotser = 0;
			$this->daoRegistroOrdenCompra->monbasimp = 0;
			$this->daoRegistroOrdenCompra->mondes = 0;
			$this->daoRegistroOrdenCompra->estpenalm = 0;
			$this->daoRegistroOrdenCompra->fecaprord = '1900-01-01';
			$this->daoRegistroOrdenCompra->numpolcon = 0;
			$this->daoRegistroOrdenCompra->fecent = '1900-01-01';
			$this->daoRegistroOrdenCompra->fechaconta = '1900-01-01';
			$this->daoRegistroOrdenCompra->fechaanula = '1900-01-01';
			$this->daoRegistroOrdenCompra->monant = formatoNumericoBd($objJson->monant,1); 
			$this->daoRegistroOrdenCompra->fechentdesde = convertirFechaBd($objJson->fechentdesde);
			$this->daoRegistroOrdenCompra->fechenthasta = convertirFechaBd($objJson->fechenthasta);
			
			if($objJson->evento=='INSERT'){
				$resultado = $this->daoRegistroOrdenCompra->incluir(true,"numordcom",true,15);
				$arrcadres = explode(",",$resultado);
				//insertando el registro y escribiendo en el log
			}
			else{
				$this->daoRegistroOrdenCompra->modificar();
				//insertando el registro y escribiendo en el log
			}	
				
			if($arrcadres[0]==1 || $arrcadres[0]==-1 || $objJson->evento=='UPDATE')
			{
				if($objJson->evento=='UPDATE'){
					$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_cuentagasto');
					if($this->valido){
						
					}
					if($this->valido){
						
					}
					if($this->valido){
						
					}
				}
				if($numcuegas>0){
					if($objJson->evento=='UPDATE'){
						$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_cuentagasto');
					}
					if($this->valido){
						foreach ($arrCueGas as $detcuengas)
						{
							if($this->valido){
								$this->valido=$this->existeCuenta($detcuengas->codestpro1,$detcuengas->codestpro2,$detcuengas->codestpro3,
														          $detcuengas->codestpro4,$detcuengas->codestpro5,$detcuengas->estcla,$detcuengas->spg_cuenta);
							}
							if($this->valido){
								$this->daoCuentaGasto = FabricaDao::CrearDAO("N","soc_cuentagasto");
								$this->daoCuentaGasto->setData($detcuengas);
								$this->daoCuentaGasto->codemp = $codemp;
								$this->daoCuentaGasto->monto = formatoNumericoBd($detcuengas->monto,1); 
								if(!$this->daoCuentaGasto->incluir())
								{
									$this->mensaje .= 'Error al guardar el detalle de cuentas en soc_cuentagasto->';
									break;
								}
							}
							else{
								switch($_SESSION["la_empresa"]["estmodest"]) {
									case "1": // Modalidad por Proyecto
										$codest1 = SUBSTR($detcuengas->codestpro1,25-$_SESSION["la_empresa"]["loncodestpro1"],$_SESSION["la_empresa"]["loncodestpro1"]);
										$codest2 = SUBSTR($detcuengas->codestpro2,25-$_SESSION["la_empresa"]["loncodestpro2"],$_SESSION["la_empresa"]["loncodestpro2"]);
										$codest3 = SUBSTR($detcuengas->codestpro3,25-$_SESSION["la_empresa"]["loncodestpro3"],$_SESSION["la_empresa"]["loncodestpro3"]);
										$cadenaEstructura = $codest1.'-'.$codest2.'-'.$codest3;
										break;
											
									case "2": // Modalidad por Programatica
										$codest1 = SUBSTR($detcuengas->codestpro1,25-$_SESSION["la_empresa"]["loncodestpro1"],$_SESSION["la_empresa"]["loncodestpro1"]);
										$codest2 = SUBSTR($detcuengas->codestpro2,25-$_SESSION["la_empresa"]["loncodestpro2"],$_SESSION["la_empresa"]["loncodestpro2"]);
										$codest3 = SUBSTR($detcuengas->codestpro3,25-$_SESSION["la_empresa"]["loncodestpro3"],$_SESSION["la_empresa"]["loncodestpro3"]);
										$codest4 = SUBSTR($detcuengas->codestpro4,25-$_SESSION["la_empresa"]["loncodestpro4"],$_SESSION["la_empresa"]["loncodestpro4"]);
										$codest5 = SUBSTR($detcuengas->codestpro5,25-$_SESSION["la_empresa"]["loncodestpro5"],$_SESSION["la_empresa"]["loncodestpro5"]);
										$cadenaEstructura = $codest1.'-'.$codest2.'-'.$codest3.'-'.$codest4.'-'.$codest5;
										break;
								}
								$this->valido=false;
								$this->mensaje.='La cuenta '.$detcuengas->spg_cuenta.' No Existe en la Estructura '.$cadenaEstructura.'; Tipo = '.$detcuengas->estcla;
							}
						}
					}
				}
				if($numsolcar>0 && $this->valido){
					foreach ($arrSolCar as $detsolcar)
					{
						if($this->valido){
							$this->valido=$this->existeCuenta($detcuengas->codestpro1,$detcuengas->codestpro2,$detcuengas->codestpro3,
														      $detcuengas->codestpro4,$detcuengas->codestpro5,$detcuengas->estcla,$detcuengas->spg_cuenta);
						}
						if($this->valido){
							$this->valido=$this->buscarCuentasGastos($codemp,$detcuengas->codestpro1,$detcuengas->codestpro2,
							                                         $detcuengas->codestpro3,$detcuengas->codestpro4,$detcuengas->codestpro5,
							                                         $detcuengas->estcla,$detcuengas->codfuefin,$detcuengas->spgcuenta,
							                                         $detcuengas->numordcom,$detcuengas->estcondat,$detcuengas->monto);
						}
						else{
							switch($_SESSION["la_empresa"]["estmodest"]) {
								case "1": // Modalidad por Proyecto
									$codest1 = SUBSTR($detcuengas->codestpro1,25-$_SESSION["la_empresa"]["loncodestpro1"],$_SESSION["la_empresa"]["loncodestpro1"]);
									$codest2 = SUBSTR($detcuengas->codestpro2,25-$_SESSION["la_empresa"]["loncodestpro2"],$_SESSION["la_empresa"]["loncodestpro2"]);
									$codest3 = SUBSTR($detcuengas->codestpro3,25-$_SESSION["la_empresa"]["loncodestpro3"],$_SESSION["la_empresa"]["loncodestpro3"]);
									$cadenaEstructura = $codest1.'-'.$codest2.'-'.$codest3;
									break;
									
								case "2": // Modalidad por Programatica
									$codest1 = SUBSTR($detcuengas->codestpro1,25-$_SESSION["la_empresa"]["loncodestpro1"],$_SESSION["la_empresa"]["loncodestpro1"]);
									$codest2 = SUBSTR($detcuengas->codestpro2,25-$_SESSION["la_empresa"]["loncodestpro2"],$_SESSION["la_empresa"]["loncodestpro2"]);
									$codest3 = SUBSTR($detcuengas->codestpro3,25-$_SESSION["la_empresa"]["loncodestpro3"],$_SESSION["la_empresa"]["loncodestpro3"]);
									$codest4 = SUBSTR($detcuengas->codestpro4,25-$_SESSION["la_empresa"]["loncodestpro4"],$_SESSION["la_empresa"]["loncodestpro4"]);
									$codest5 = SUBSTR($detcuengas->codestpro5,25-$_SESSION["la_empresa"]["loncodestpro5"],$_SESSION["la_empresa"]["loncodestpro5"]);
									$cadenaEstructura = $codest1.'-'.$codest2.'-'.$codest3.'-'.$codest4.'-'.$codest5;
									break;
							}
							$this->valido=false;
							$this->mensaje.='La cuenta '.$detcuengas->spg_cuenta.' No Existe en la Estructura '.$cadenaEstructura.'; Tipo = '.$detcuengas->estcla;
						}
					}
				}
				if($numero>0){
					if($objJson->evento=='UPDATE'){
						$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_enlace_sep');
					}
					if($this->valido){
						foreach ($arrDetalleSEP as $detalleSEP){
							$this->daoDetalleSEP = FabricaDao::CrearDAO("N","soc_enlace_sep");
							$this->daoDetalleSEP->setData($detalleSEP);
							$this->daoDetalleSEP->codemp = $codemp;
							if(!$this->daoDetalleSEP->incluir()){
								$this->mensaje .= 'Error al guardar en soc_enlace_sep->';
								break;
							}
							$strPK = "codemp='{$codemp}'";
							$strPK .= " AND numsol='{$detalleSEP->numsol}'";
							$this->daoCambioEstatusSep = FabricaDao::CrearDAO('C','sep_solicitud',null,$strPK);
							$this->daoCambioEstatusSep->estsol = 'P';
							if($this->daoCambioEstatusSep->modificar()==0){
								$this->mensaje .= 'Error al modificar en sep_solicitud->';
								break;
							}
						}
					}
				}
				if($numsolcar>0){
					if($objJson->evento=='UPDATE'){
						$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_solicitudcargos');
					}
					if($this->valido){
						foreach ($arrSolCar as $detsolcar)
						{
							$sccuenta = '';
							$this->daoSolicitudCargo = FabricaDao::CrearDAO("N","soc_solicitudcargos");
							$this->daoSolicitudCargo->setData($detsolcar);
							$this->daoSolicitudCargo->codemp = $codemp;
							$this->daoSolicitudCargo->monret = 0;
							$this->daoSolicitudCargo->monobjret = 0;
							$sccuenta = $this->select_cuentacontable($codemp,$detsolcar->codestpro1,$detsolcar->codestpro2,$detsolcar->codestpro3,
														             $detsolcar->codestpro4,$detsolcar->codestpro5,$detsolcar->spg_cuenta,
														             $detsolcar->estcla);
							$this->daoSolicitudCargo->sc_cuenta = $sccuenta;
							$this->daoSolicitudCargo->monto = formatoNumericoBd($detsolcar->monto,1);
							if(!$this->daoSolicitudCargo->incluir()){
								$this->mensaje .= 'Error al guardar los cargos en soc_solicitudcargos->';
								break;
							}
						}
					}
				}
				if($objJson->estcondat=='B'){
					if($objJson->evento=='UPDATE'){
						$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dta_cargos');
						if($this->valido){
							$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dt_bienes');
						}
					}
					if($this->valido){
						foreach ($arrDetalle as $detalle){
							$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dt_bienes");
							$this->daoDetalle->setData($detalle);
							$this->daoDetalle->codemp = $codemp;
							$this->daoDetalle->penart = 0;
							$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1); 
							$this->daoDetalle->preuniart = formatoNumericoBd($detalle->preuniart,1);
							$this->daoDetalle->monsubart = formatoNumericoBd($detalle->monsubart,1);
							$this->daoDetalle->montotart = formatoNumericoBd($detalle->montotart,1);
							if(!$this->daoDetalle->incluir()){
								$this->mensaje .= 'Error al guardar los detalles del articulo->';
								break;
							}
							if($numero>0){
								$str = "codemp='{$codemp}'";
				 				$str .= " AND numsol='{$detalle->numsol}'";
				 				$str .= " AND codart='{$detalle->codart}'";
				 				$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_articulos',null,$str);
				 				$this->daoCambioEstatusItemSep->estincite='OC';
				 				$this->daoCambioEstatusItemSep->numdocdes=$detalle->numordcom;
								if($this->daoCambioEstatusItemSep->modificar()==0){
									$this->mensaje .= 'Error al modificar en sep_dt_articulos->';
								 	break;
								}
							}
						}
						$numcargos = count($arrCargos);
						if($numcargos>0){
							foreach ($arrCargos as $detalleCargos){
								$this->daoDetalleCargos = FabricaDao::CrearDAO("N","soc_dta_cargos");
								$this->daoDetalleCargos->setData($detalleCargos);
								$this->daoDetalleCargos->codemp = $codemp;
								$this->daoDetalleCargos->monbasimp = formatoNumericoBd($detalleCargos->monbasimp,1); 
								$this->daoDetalleCargos->monimp = formatoNumericoBd($detalleCargos->monimp,1);
								$this->daoDetalleCargos->monto = formatoNumericoBd($detalleCargos->monto,1);
								if(!$this->daoDetalleCargos->incluir()){
									$this->mensaje .= 'Error al guardar los cargos del articulo->';
									break;
								}
							}
						}
					}
				}
				if($objJson->estcondat=='S'){
					if($objJson->evento=='UPDATE'){
						$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dts_cargos');
						if($this->valido){
							$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dt_servicio');
						} 
					}
					if($this->valido){
						foreach ($arrDetalle as $detalle) {
							$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dt_servicio");
							$this->daoDetalle->setData($detalle);
							$this->daoDetalle->codemp = $codemp;
							$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
							$this->daoDetalle->monuniser = formatoNumericoBd($detalle->monuniser,1);
							$this->daoDetalle->monsubser = formatoNumericoBd($detalle->monsubser,1);
							$this->daoDetalle->montotser = formatoNumericoBd($detalle->montotser,1);
							if(!$this->daoDetalle->incluir()){
								$this->mensaje .= 'Error al guardar los detalles del servicio->';
								break;
							}
							if($numero>0){
								$str = "codemp='{$codemp}'";
								$str .= " AND numsol='{$detalle->numsol}'";
								$str .= " AND codser='{$detalle->codser}'";
								$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_servicio',null,$str);
								$this->daoCambioEstatusItemSep->estincite='OC';
								$this->daoCambioEstatusItemSep->numdocdes=$detalle->numordcom;
						 	    if($this->daoCambioEstatusItemSep->modificar()==0){
						 	    	$this->mensaje .= 'Error al modificar en sep_dt_servicio->';
								  	break;
								}
							}
						}
						$numcargos = count($arrCargos);
						if($numcargos>0){
							foreach ($arrCargos as $detalleCargos){
								$this->daoDetalleCargos = FabricaDao::CrearDAO("N","soc_dts_cargos");
								$this->daoDetalleCargos->setData($detalleCargos);
								$this->daoDetalleCargos->codemp = $codemp;
								$this->daoDetalleCargos->monbasimp = formatoNumericoBd($detalleCargos->monbasimp,1); 
								$this->daoDetalleCargos->monimp = formatoNumericoBd($detalleCargos->monimp,1);
								$this->daoDetalleCargos->monto = formatoNumericoBd($detalleCargos->monto,1);
								if(!$this->daoDetalleCargos->incluir()){
									$this->mensaje .= 'Error al guardar los cargos del servicio->';
									break;
								}
							}
						}
					}
				}
				if($this->valido){
					$estatus = $this->validarCuentas($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat);
				}
				 
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
		
				//completando la transaccion retorna 1 si no hay errores
				if(DaoGenerico::completarTrans($this->valido)) {
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
					if($arrcadres[0]==1 || $objJson->evento=='UPDATE'){
						$this->mensaje.='Registro guardado con exito';
					}
					else{
						$this->mensaje.='Registro guardado con exito, con el c&#243;digo '.$arrcadres[1];
					}	 		
				}
				else{
					$arrevento ['desevetra'] = $mensaje.$this->daoRegistroOrdenCompra->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
					$this->valido=false;
					$this->mensaje.=$this->daoRegistroOrdenCompra->ErrorMsg();
				}
				 
				//liberando variables y retornando el resultado de la operacion
				unset($this->daoRegistroOrdenCompra);
				unset($this->daoRegistroEvento);
			}
			else{
				$this->valido=false;
				$this->mensaje.='Ocurrio un error al generar un nuevo numero para la Orden de Compra';
			}
		}
		return $this->valido;
	}
	
	function eliminar($codemp,$numordcom,$estcondat,$tabla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "DELETE FROM {$tabla} ".
				" 	  WHERE codemp='{$codemp}' ".
		        "       AND numordcom='{$numordcom}' ".
				"       AND estcondat='{$estcondat}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= ' Error al eliminar en la tabla '.$tabla.' ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		else{
			return true;
		}
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/soc/iregistro_orden_compra::eliminarParametro()
	*/
	public function eliminarOrdCom($codemp,$objJson,$arrevento) 
	{
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objJson->detallesOrdenCompra;
		$arrDetalleSEP = $objJson->detalleSep;
		$numero = count($arrDetalleSEP);
		$arrCueGas = $objJson->detallesCuentasGastos;
		$arrSolCar = $objJson->detallesSolicitudCargos;
		$arrCargos = $objJson->detallesCargos;
		$numsolcar = count($arrSolCar);
		$ultnumordcom = $this->buscarUltimaOrden($codemp,$objJson->estcondat);
		
		if($objJson->permisoAdm!='1'){
			if(trim($objJson->numordcom)!=trim(ultnumordcom)){
				$this->valido=false;
				$this->mensaje.='La Orden de Compra no puede ser Eliminada, no es el ultimo archivo registrado!!!';
			}
		}
		if($this->valido){
			//obteniendo las instacias de los dao's
			$this->daoRegistroOrdenCompra = FabricaDao::CrearDAO("N","soc_ordencompra");
	
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroOrdenCompra->setData($objJson);
			$this->daoRegistroOrdenCompra->codemp=$codemp;
			$this->daoRegistroOrdenCompra->fecordcom = convertirFechaBd($objJson->fecordcom);
			$this->daoRegistroOrdenCompra->monsubtotbie = 0;
			$this->daoRegistroOrdenCompra->monsubtotser = 0;
			$this->daoRegistroOrdenCompra->monbasimp = 0;
			$this->daoRegistroOrdenCompra->mondes = 0;
			$this->daoRegistroOrdenCompra->estpenalm = 0;
			$this->daoRegistroOrdenCompra->fecaprord = '1900-01-01';
			$this->daoRegistroOrdenCompra->numpolcon = 0;
			$this->daoRegistroOrdenCompra->fecent = '1900-01-01';
			$this->daoRegistroOrdenCompra->fechaconta = '1900-01-01';
			$this->daoRegistroOrdenCompra->fechaanula = '1900-01-01';
			$this->daoRegistroOrdenCompra->fechentdesde = convertirFechaBd($objJson->fechentdesde);
			$this->daoRegistroOrdenCompra->fechenthasta = convertirFechaBd($objJson->fechenthasta);
			DaoGenerico::iniciarTrans();
			
			$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_enlace_sep');
			if($this->valido)
			{
				$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_cuentagasto');
			}
			if($this->valido)
			{
				$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_solicitudcargos');
			}
				
			if($numero>0){
				foreach ($arrDetalleSEP as $detalleSEP){
					$strPK = "codemp='{$codemp}'";
					$strPK .= " AND numsol='{$detalleSEP->numsol}'";
					$this->daoCambioEstatusSep = FabricaDao::CrearDAO('C','sep_solicitud',null,$strPK);
					$this->daoCambioEstatusSep->estsol = 'C';
					if($this->daoCambioEstatusSep->modificar()==0){
						break;
					}
					$this->daoDetalleSEP = FabricaDao::CrearDAO("N","soc_enlace_sep");
					$this->daoDetalleSEP->setData($detalleSEP);
					$this->daoDetalleSEP->codemp = $codemp;
					if(!$this->daoDetalleSEP->eliminar()){
						break;
					}
				}
			}
				
			if($objJson->estcondat=='B')
			{
				if($this->valido)
				{
					$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dta_cargos');
				}
				foreach ($arrDetalle as $detalle){
					if($numero>0){
						$str = "codemp='{$codemp}'";
		 				$str .= " AND numsol='{$detalle->numsol}'";
		 				$str .= " AND codart='{$detalle->codart}'";
		 				$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_articulos',null,$str);
		 				$this->daoCambioEstatusItemSep->estincite='NI';
		 				$this->daoCambioEstatusItemSep->numdocdes='';
						if($this->daoCambioEstatusItemSep->modificar()==0){
						 	break;
						}
					}
				}
				if($this->valido)
				{
					$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dt_bienes');
				}
			}
			if($objJson->estcondat=='S')
			{
				if($this->valido)
				{
					$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dts_cargos');
				}
				foreach ($arrDetalle as $detalle) 
				{
					if($numero>0){
						$str = "codemp='{$codemp}'";
						$str .= " AND numsol='{$detalle->numsol}'";
						$str .= " AND codser='{$detalle->codser}'";
						$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_servicio',null,$str);
						$this->daoCambioEstatusItemSep->estincite='NI';
						$this->daoCambioEstatusItemSep->numdocdes='';
				 	    if($this->daoCambioEstatusItemSep->modificar()==0){
						  	break;
						}
					}
				}
				if($this->valido)
				{
					$this->valido = $this->eliminar($codemp,$this->daoRegistroOrdenCompra->numordcom,$this->daoRegistroOrdenCompra->estcondat,'soc_dt_servicio');
				}
			}
			
			$this->daoRegistroOrdenCompra->eliminar();
			//insertando el registro y escribiendo en el log
					
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
		
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$this->mensaje.=' Registro eliminado exitosamente ';
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();	 		
			}
			else{
				$arrevento ['desevetra'] = $this->daoRegistroOrdenCompra->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
				$this->mensaje.=$this->daoRegistroOrdenCompra->ErrorMsg();
			}
		}
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoRegistroOrdenCompra);
		unset($this->daoRegistroEvento);
		return $this->valido;
	}
	
	public function cargarBieSerOrdCom($codemp, $numordcom, $estcondat) {
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				if($estcondat=='B'){
					$tabla = 'soc_dt_bienes';
				}
				if($estcondat=='S'){
					$tabla = 'soc_dt_servicio';
				}
				$codest1 = "SUBSTR({$tabla}.codestpro1,length({$tabla}.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR({$tabla}.codestpro2,length({$tabla}.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR({$tabla}.codestpro3,length({$tabla}.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				if($estcondat=='B'){
					$tabla = 'soc_dt_bienes';
				}
				if($estcondat=='S'){
					$tabla = 'soc_dt_servicio';
				}
				$codest1 = "SUBSTR({$tabla}.codestpro1,length({$tabla}.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR({$tabla}.codestpro2,length({$tabla}.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR({$tabla}.codestpro3,length({$tabla}.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR({$tabla}.codestpro4,length({$tabla}.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR({$tabla}.codestpro5,length({$tabla}.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		
		if($estcondat=='B'){
			$cadenaSQL = "SELECT soc_dt_bienes.codart,soc_dt_bienes.numordcom,soc_dt_bienes.canart,  ".
			         "           soc_dt_bienes.codestpro1,soc_dt_bienes.codestpro2,soc_dt_bienes.codestpro3, ".
					 "	  		 soc_dt_bienes.numsol, spg_unidadadministrativa.denuniadm,soc_dt_bienes.monsubart,  ".
			         "           soc_dt_bienes.codestpro4,soc_dt_bienes.codestpro5,soc_dt_bienes.estcla, ".
					 "	         TRIM(siv_articulo.spg_cuenta) AS spg_cuenta,soc_dt_bienes.unidad,soc_dt_bienes.preuniart,  ".
			         "           soc_dt_bienes.coduniadm,soc_dt_bienes.numsol,soc_dt_bienes.montotart,  ".
			         "           siv_articulo.denart AS denart, siv_unidadmedida.unidad AS unimed,{$cadenaEstructura} AS estructura, ".
					 "	         soc_dt_bienes.codfuefin    ".
					 "	  FROM soc_dt_bienes  ".   
	 				 "	  INNER JOIN spg_unidadadministrativa USING(codemp,coduniadm)".
					 "	  INNER JOIN siv_articulo USING(codemp, codart)".
					 "	  INNER JOIN soc_ordencompra USING(codemp,numordcom,estcondat)".
					 "	  INNER JOIN siv_unidadmedida USING(codunimed)".
					 "	  WHERE soc_dt_bienes.codemp= '{$codemp}'  ".
					 "		 AND soc_dt_bienes.numordcom= '{$numordcom}' ".
					 "     	 AND soc_dt_bienes.estcondat='B' ".
					 "    ORDER BY siv_articulo.codart";
		}
		else{
			$cadenaSQL = "SELECT soc_dt_servicio.codser,soc_dt_servicio.canser,soc_dt_servicio.monuniser,  ".
			         "           soc_dt_servicio.codestpro1,soc_dt_servicio.codestpro2,soc_dt_servicio.codestpro3, ".   
					 "           soc_dt_servicio.monsubser,soc_dt_servicio.montotser,soc_dt_servicio.orden,  ".
			         "           soc_dt_servicio.codestpro4,soc_dt_servicio.codestpro5,soc_dt_servicio.estcla,  ".
					 "           TRIM(soc_servicios.spg_cuenta) AS spg_cuenta,soc_servicios.denser,soc_dt_servicio.numsol, ".
					 "           soc_dt_servicio.coduniadm,{$cadenaEstructura} AS estructura,soc_dt_servicio.codfuefin ". 
					 " 	  FROM soc_dt_servicio  ".
					 " 	  INNER JOIN spg_unidadadministrativa USING(codemp,coduniadm)".
					 " 	  INNER JOIN soc_servicios USING(codemp,codser) ".
					 " 	  INNER JOIN soc_ordencompra USING(codemp,numordcom,estcondat)".
					 "	  WHERE soc_dt_servicio.codemp= '{$codemp}' ".
					 "		AND soc_dt_servicio.estcondat='S'  ".
					 "		AND soc_dt_servicio.numordcom = '{$numordcom}' ".
					 "	  ORDER BY soc_dt_servicio.codser";
			
		}
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return generarJson($data,true,false);
	}
	
	public function cargarCargosBienes($codemp,$codart,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR('{$codestpro1}',length('{$codestpro1}')-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR('{$codestpro2}',length('{$codestpro2}')-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR('{$codestpro3}',length('{$codestpro3}')-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR('{$codestpro1}',length('{$codestpro1}')-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR('{$codestpro2}',length('{$codestpro2}')-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR('{$codestpro3}',length('{$codestpro3}')-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR('{$codestpro4}',length('{$codestpro4}')-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR('{$codestpro5}',length('{$codestpro5}')-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenaSQL = "SELECT siv_articulo.codart,siv_cargosarticulo.codcar,sigesp_cargos.dencar,sigesp_cargos.estcla, ".
		        "            {$cadenaEstructura} AS estructura,TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta,  ".
		        "            sigesp_cargos.formula,sigesp_cargos.codestpro,(SELECT COUNT(spg_cuenta) ".
		        "                                                           FROM spg_cuentas ".
				"		 													WHERE spg_cuentas.codestpro1 = '{$codestpro1}' ".
				"		    												  AND spg_cuentas.codestpro2 = '{$codestpro2}' ".
				"		    												  AND spg_cuentas.codestpro3 = '{$codestpro3}' ".
				"		    												  AND spg_cuentas.codestpro4 = '{$codestpro4}' ".
				"		    												  AND spg_cuentas.codestpro5 = '{$codestpro5}' ".
				"															  AND spg_cuentas.estcla='{$estcla}' 				".
				"															  AND siv_articulo.codemp = spg_cuentas.codemp ".
				"															  AND siv_articulo.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
				" 	  FROM siv_cargosarticulo   ".
				"     INNER JOIN sigesp_cargos USING(codemp,codcar)".
				"     INNER JOIN siv_articulo USING(codemp,codart)".
				"     WHERE siv_articulo.codemp = '{$codemp}' ".
				"     	AND siv_articulo.codart = '{$codart}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarCargosServicios($codemp,$codser,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR('{$codestpro1}',length('{$codestpro1}')-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR('{$codestpro2}',length('{$codestpro2}')-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR('{$codestpro3}',length('{$codestpro3}')-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR('{$codestpro1}',length('{$codestpro1}')-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR('{$codestpro2}',length('{$codestpro2}')-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR('{$codestpro3}',length('{$codestpro3}')-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR('{$codestpro4}',length('{$codestpro4}')-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR('{$codestpro5}',length('{$codestpro5}')-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenaSQL = "SELECT soc_servicios.codser,sigesp_cargos.codcar,sigesp_cargos.dencar,sigesp_cargos.estcla,  ".
		       "             {$cadenaEstructura} AS estructura,TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta, ".
		       "             sigesp_cargos.formula,sigesp_cargos.codestpro,(SELECT COUNT(spg_cuenta)  ".
		       "                                                            FROM spg_cuentas ".
			   "		  													WHERE spg_cuentas.codestpro1 = '{$codestpro1}' ".
			   "		    												  AND spg_cuentas.codestpro2 = '{$codestpro2}' ".
			   "		    												  AND spg_cuentas.codestpro3 = '{$codestpro3}' ".
		       "		    												  AND spg_cuentas.codestpro4 = '{$codestpro4}' ".
			   "		    												  AND spg_cuentas.codestpro5 = '{$codestpro5}' ".
			   "															  AND spg_cuentas.estcla='{$estcla}' ".
			   "															  AND soc_servicios.codemp = spg_cuentas.codemp ".
			   "															  AND soc_servicios.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
			   " 	  FROM soc_serviciocargo ".
			   " 	  INNER JOIN sigesp_cargos USING(codemp,codcar)".
			   " 	  INNER JOIN soc_servicios USING(codemp,codser)".
			   "	  WHERE soc_servicios.codemp = '{$codemp}' ".
			   "	  	 AND soc_servicios.codser = '{$codser}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarCuentas($codemp,$numero,$estcondat,$tipsol){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		switch($_SESSION["ls_gestor"]){
	   		case "MYSQLT":
				$round="ROUND(monto,2) ";
			break;

	   		case "MYSQLI":
				$round="ROUND(monto,2) ";
			break;
			
			default:
				$round="cast(round(CAST (monto AS numeric), 2)as double precision)";
			break;
	    }
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		switch($tipsol){
			case "SEP":
				if($estcondat=='B'){
					$tabla="sep_dt_articulos"; 
				    $total="(canart*monpre)";
				}
				else{
					$tabla="sep_dt_servicio"; 
				    $total="(canser*monpre)";
				}
				$cadenaSQL = "SELECT TRIM(codestpro1) AS codestpro1 , TRIM(codestpro2) AS codestpro2 ,". 
			                 "		 TRIM(codestpro3) AS codestpro3 , TRIM(codestpro4) AS codestpro4 ,". 
					         "       TRIM(codestpro5) AS codestpro5 , TRIM(spg_cuenta) AS spg_cuenta ,". 
                             "		 estcla, {$total} AS total,codfuefin, {$cadenaEstructura} AS estructura ".
                     		 "FROM  {$tabla}  ".
                    		 "WHERE codemp='{$codemp}'  ".
					       	 "	AND	numsol='{$numero}' AND estincite='NI'";
				            break;
			case "SOC":
				$cadenaSQL = "SELECT {$cadenaEstructura} AS estructura,TRIM(codestpro1) AS codestpro1,TRIM(codestpro2) AS codestpro2,".
							 "		 TRIM(codestpro3) AS codestpro3,TRIM(codestpro4) AS codestpro4,TRIM(codestpro5) AS codestpro5,".
							 "		 TRIM(spg_cuenta) AS spg_cuenta,codfuefin,estcla, $round AS total ".
					 		 "FROM soc_cuentagasto  ".
					 		 "WHERE codemp='{$codemp}' AND ".
					       	 "  	numordcom='{$numero}' AND ".
					         "      estcondat='{$estcondat}'  ".
					 		 "UNION ".
					 		 "SELECT {$cadenaEstructura} AS estructura,TRIM(codestpro1) AS codestpro1,TRIM(codestpro2) AS codestpro2,".
					 	     "  	 TRIM(codestpro3) AS codestpro3,TRIM(codestpro4) AS codestpro4,TRIM(codestpro5) AS codestpro5,".
					 	     "       TRIM(spg_cuenta) AS spg_cuenta,estcla,codfuefin, - sum($round) AS total ".
					 		 "FROM soc_solicitudcargos ".
					 		 "WHERE codemp='{$codemp}' AND ". 
					         "	   	numordcom='{$numero}' AND ".
					         "      estcondat='{$estcondat}' ".
					  		 "GROUP BY codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla,spg_cuenta,codfuefin";
				break;
		}
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarCuentasCreditos($codemp,$numero,$estcondat,$tipsol){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		switch($tipsol){
			case "SOC":
				switch($_SESSION["la_empresa"]["estmodest"]) {
					case "1": // Modalidad por Proyecto
						$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
						$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
						$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
						$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
						break;
						
					case "2": // Modalidad por Programatica
						$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
						$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
						$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
						$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
						$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
						$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
						break;
				}
				$cadenaSQL = "SELECT codcar,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5, ".
					         "		TRIM(spg_cuenta) AS spg_cuenta,estcla,monto AS total,codfuefin, numsol,".
					         "		{$cadenaEstructura} AS estructura,formula ".
					 		 "FROM soc_solicitudcargos  ".
					 		 "WHERE codemp='{$codemp}' ". 
					         "  AND	numordcom='{$numero}' ". 
					         " 	AND	estcondat='{$estcondat}'";
				break;
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarUltimaOrden($codemp,$tipo) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$cadenaSql="SELECT numordcom  ".  
				"	FROM soc_ordencompra  ".
				"	WHERE codemp='{$codemp}' ".
				"     AND estcondat='{$tipo}'";
		
		switch (strtoupper($_SESSION["ls_gestor"])){
	   		case "MYSQLT":
				$limite="LIMIT 0,1 ";
				$cadenaSql = $cadenaSql."ORDER BY numordcom DESC {$limite}";
			break;
	   		case "MYSQLI":
				$limite="LIMIT 0,1 ";
				$cadenaSql = $cadenaSql."ORDER BY numordcom DESC {$limite}";
			break;
			case "POSTGRES":
				$limite="LIMIT 1";
				$cadenaSql = $cadenaSql."ORDER BY numordcom DESC {$limite}";
			break;
			case "OCI8PO":
				$limite="AND rownum<1";
				$cadenaSql = $cadenaSql."{$limite} ORDER BY numordcom DESC";
	   }
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['numordcom'];
	}
	
    public function validarFecha($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$numero = $this->buscarUltimaOrden();
		$cadenaSql="SELECT fecordcom ".  
				"	FROM soc_ordencompra  ".
				"	WHERE codemp='{$codemp}' ". 
				"	  AND numordcom='{$numero}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['fecordcom'];
	}
	
	public function validaFechaPeriodo($as_fecha,$as_codemp)
	{
	    $li_ano    = 0 ; $li_mes=0;$li_ano_periodo=0;$li_mes_periodo=0;
	    $ls_fecha  = ""; $ls_periodo_final=""; 
	    $lb_valido = true;
   	    //$as_fecha=$this->uf_convert_date_to_db($as_fecha);
	    $li_ano = intval(substr($as_fecha,0,4));
	    $li_mes = intval(substr($as_fecha,5,2));
	    $li_ano_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],0,4));
	    $li_mes_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],5,2));
	    $ld_periodo_final = "31/12/".$li_ano_periodo;
		if ($li_ano == $li_ano_periodo)
		{
			if($li_mes >= $li_mes_periodo)
			{
			   if($this->validaFechaMes( $as_codemp, $as_fecha ))
			   {
			 	  $lb_valido = true;
			   }
			   else	 
			   {
				  $lb_valido = false;
			 	  //$this->is_msg_error = "Mes no esta Abierto";
				  return false;
			   }
			} 			
			else {  $lb_valido = false;	}
		}
		else 
		{ 
			$lb_valido = false;	
		}
		return $lb_valido;	
	} // end function()

	public function validaFechaMes($as_codemp,$as_fecha)
 	{ 
		 $li_mes=0;$li_M01=0;$li_M02=0;$li_M03=0;$li_M04=0;$li_M05=0;
		 $li_M06=0;$li_M07=0;$li_M08=0;$li_M09=0;$li_M10=0;$li_M11=0;$li_M12=0;
		 $lb_abierto_mes=false;
		 $lb_valido=false;
		 $ls_cadena="";
		 $li_mes = intval(substr($as_fecha,5,2));
		 $cadenasql=" SELECT m01,m02,m03,m04,m05,m06,m07,m08,m09,m10,m11,m12 ". 
		 			" FROM sigesp_empresa WHERE codemp = '".$as_codemp."' ";
		 $conexionbd = ConexionBaseDatos::getInstanciaConexion();
		 $resultado = $conexionbd->Execute ( $cadenasql );
		 if ($resultado===false)
		 {
	 		 $mensaje .= '  ->'.$conexionbd->ErrorMsg();
		 }
		 else
		 {
			$lb_valido=true;
			while((!$resultado->EOF))
			{
				$li_M01=$resultado->fields["m01"];
				$li_M02=$resultado->fields["m02"];
				$li_M03=$resultado->fields["m03"];
				$li_M04=$resultado->fields["m04"];
				$li_M05=$resultado->fields["m05"];
				$li_M06=$resultado->fields["m06"];
				$li_M07=$resultado->fields["m07"];
				$li_M08=$resultado->fields["m08"];
				$li_M09=$resultado->fields["m09"];
				$li_M10=$resultado->fields["m10"];
				$li_M11=$resultado->fields["m11"];
				$li_M12=$resultado->fields["m12"];
				$resultado->MoveNext();
			}
		 } 
		 if ($lb_valido)
		 {
			switch ($li_mes)
			{
				case 1:
					if($li_M01==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 2:
					if($li_M02==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 3:
					if($li_M03==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 4:
					if($li_M04==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 5:
					if($li_M05==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 6:
					if($li_M06==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 7:
					if($li_M07==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 8:
					if($li_M08==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 9:
					if($li_M09==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 10:
					if($li_M10==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 11:
					if($li_M11==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 12:
					if($li_M12==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				default:
			}
		 }	
		 if (!$lb_abierto_mes)
		 {
		   	 //$this->is_msg_error = "El Mes ".$li_mes." no esta abierto.";
			 $lb_valido = false;
		 }
		 unset($conexionbd);
		 unset($resultado);
		 return $lb_valido;
    } // end fuction
	
	public function buscarCuentasSpg($codemp,$tipo,$spg_cuenta,$codestpro1ue,$codestpro2ue,$codestpro3ue,$codestpro4ue,$codestpro5ue,$estclaue,$codfuefin)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$lugar='';
		$cadenaSQL = '';
		$orden = 'ASC';
		$campoorden = 'codpro';
		if(tipo=="B")
		{
			$lugar=1;
		}
		else{
			$lugar=3;
		}
		$codespro1=str_pad($codestpro1ue,25,"0",0);
		$codespro2=str_pad($codestpro2ue,25,"0",0);
		$codespro3=str_pad($codestpro3ue,25,"0",0);
		$codespro4=str_pad($codestpro4ue,25,"0",0);
		$codespro5=str_pad($codestpro5ue,25,"0",0);
		$estcla=$estclaue;
		$cadena = $this->conexionBaseDatos->Concat('spg_cuentas.codestpro1','spg_cuentas.codestpro2','spg_cuentas.codestpro3','spg_cuentas.codestpro4','spg_cuentas.codestpro5','spg_cuentas.estcla','spg_cuentas.spg_cuenta');
	    $criterio = " AND  ".$cadena." <> ('$codespro1$codespro2$codespro3$codespro4$codespro5$estcla$spg_cuenta')";
		if($_SESSION["la_empresa"]["estmodest"]==1)
		{
			$codest1 = "SUBSTR(spg_cuentas.codestpro1,length(spg_cuentas.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
			$codest2 = "SUBSTR(spg_cuentas.codestpro2,length(spg_cuentas.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
			$codest3 = "SUBSTR(spg_cuentas.codestpro3,length(spg_cuentas.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
			$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
		}	
		else{
			$codest1 = "SUBSTR(spg_cuentas.codestpro1,length(spg_cuentas.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
			$codest2 = "SUBSTR(spg_cuentas.codestpro2,length(spg_cuentas.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
			$codest3 = "SUBSTR(spg_cuentas.codestpro3,length(spg_cuentas.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
			$codest4 = "SUBSTR(spg_cuentas.codestpro4,length(spg_cuentas.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
			$codest5 = "SUBSTR(spg_cuentas.codestpro5,length(spg_cuentas.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
			$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
		}

	    //------------------------Con respecto a la seguridad------------------------------------------------
		$sesion = "'{$_SESSION['la_logusr']}'";
		$cadena1 = $this->conexionBaseDatos->Concat("'{$codemp}'","'SPG'",$sesion,'spg_cuentas.codestpro1','spg_cuentas.codestpro2','spg_cuentas.codestpro3','spg_cuentas.codestpro4','spg_cuentas.codestpro5','spg_cuentas.estcla');
		$cadena2 = $this->conexionBaseDatos->Concat('codemp','codsis','codusu','codintper');
		$sql_seguridad = "AND {$cadena1} IN ".
					 "    (SELECT {$cadena2} ".    
					 "     FROM sss_permisos_internos                  ".    
					 "     WHERE codusu = '{$_SESSION['la_logusr']}'   ".               
					 "       AND codsis = 'SPG'  AND enabled=1)";
//		//-------------------------------------------------------------------------------------------------- 
		if($campoorden=='codpro'){
			$campoorden= "codestpro1,codestpro2,codestpro3,codestpro4,codestpro5";
		}
		$cadenaSQL="SELECT TRIM(spg_cuentas.spg_cuenta) AS spg_cuenta , spg_cuentas.denominacion, spg_cuentas.codestpro1,spg_cuentas.codestpro2, spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5,spg_cuentas.status,spg_cuentas.estcla, ".
				"          (asignado-(comprometido+precomprometido)+aumento-disminucion) as disponible, {$cadenaEstructura} AS estructura ".
			    " 	FROM spg_cuentas, spg_cuenta_fuentefinanciamiento ".
				" 	WHERE spg_cuentas.codemp = '{$codemp}'  ".
				"	  AND spg_cuentas.spg_cuenta like '%{$spg_cuenta}%' ".
				"     AND status ='C' {$criterio} {$sql_seguridad}".
				"     AND spg_cuenta_fuentefinanciamiento.codfuefin='".$codfuefin."'".
				"     AND spg_cuentas.codemp = spg_cuenta_fuentefinanciamiento.codemp".
				"     AND spg_cuentas.codestpro1 = spg_cuenta_fuentefinanciamiento.codestpro1".
				"     AND spg_cuentas.codestpro2 = spg_cuenta_fuentefinanciamiento.codestpro2".
				"     AND spg_cuentas.codestpro3 = spg_cuenta_fuentefinanciamiento.codestpro3".
				"     AND spg_cuentas.codestpro4 = spg_cuenta_fuentefinanciamiento.codestpro4".
				"     AND spg_cuentas.codestpro5 = spg_cuenta_fuentefinanciamiento.codestpro5".
				"     AND spg_cuentas.estcla = spg_cuenta_fuentefinanciamiento.estcla".
				"     AND spg_cuentas.spg_cuenta = spg_cuenta_fuentefinanciamiento.spg_cuenta".					
				"  	ORDER BY {$campoorden} {$orden} ";
				//print $cadenaSQL;
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarOrdenCompra($codemp,$numordcom,$tipbieser,$codpro,$fecordcomdes,
									  $fecordcomhas,$tipope,$codmon,$codfuefin,$codtipmod,
									  $estsegcom,$porsegcom,$forpagcom,$estcom,$diaplacom,
									  $concom,$obscom,$estpenalm,$codpai,$codest,$codmun,
									  $codpar,$lugentnomdep,$lugentdir,$estlugcom,$origenCat){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL='';
		$cadenaFiltro='';
		
		if(!empty($tipbieser)){
		  $cadenaFiltro =" AND soc_ordencompra.estcondat= '{$tipbieser}' ";
		}
		if(!empty($numordcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.numordcom like '%{$numordcom}%' ";
		}
		if(!empty($codpro)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.cod_pro like '%{$codpro}%'";
		}
		if (!empty($fecordcomdes) && !empty($fecordcomhas)){
			$fecordcomdes = convertirFechaBd($fecordcomdes);
			$fecordcomhas = convertirFechaBd($fecordcomhas);
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.fecordcom BETWEEN '{$fecordcomdes}' AND '{$fecordcomhas}'";
		}
		if(!empty($codmon)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codmon='{$codmon}'";
		}
		if(!empty($codfuefin)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codfuefin='{$codfuefin}'";
		}
		if(!empty($codtipmod)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codtipmod='{$codtipmod}'";
		}
		if(!empty($estsegcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estsegcom='{$estsegcom}'";
		}
		if(!empty($porsegcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.porsegcom='{$porsegcom}'";
		}
		if(!empty($forpagcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.forpagcom='{$forpagcom}'";
		}
		if(!empty($estcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estcom='{$estcom}'";
		}
		if(!empty($diaplacom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.diaplacom='{$diaplacom}'";
		}
		if(!empty($concom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.concom='{$concom}'";
		}
		if(!empty($obscom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.obscom='{$obscom}'";
		}
		if(!empty($estpenalm)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estpenalm='{$estpenalm}'";
		}
		if(!empty($codpai)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codpai='{$codpai}'";
		}
		if(!empty($codest)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codest='{$codest}'";
		}
		if(!empty($codmun)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codmun='{$codmun}'";
		}
		if(!empty($codpar)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.codpar='{$codpar}'";
		}
		if(!empty($lugentnomdep)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.lugentnomdep='{$lugentnomdep}'";
		}
		if(!empty($lugentdir)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.lugentdir='{$lugentdir}'";
		}
		if(!empty($estlugcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estlugcom='{$estlugcom}'";
		}
		if(!empty($origenCat)){
			switch ($origenCat){
				case 'Aprobacion':
					if($tipope=='1'){ 
		     			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estapro='0'";
		   			}
					if($tipope=='0'){
			 			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estapro='1'";
		   			}
		   			$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estcom='1'";
					break;
				case 'Anulacion':
					$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estcom='1' ";
					$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estapro='1' ";
					break;
				case 'AceptacionServicio':
					if($tipope=='A'){
						$cadenaFiltro = $cadenaFiltro."AND soc_ordencompra.estcom=2";
					}
					if($tipope=='R'){
						$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estcom=7 ".
						               				  " AND soc_ordencompra.numordcom NOT IN(SELECT CASE WHEN numdoccom IS NULL THEN '-----' ELSE numdoccom END ".
						                                                                  "  FROM cxp_rd_spg ".									   
 						   			                                                      "  WHERE cxp_rd_spg.procede_doc='SOCCOS' ".             
 						   			   									   				  "    AND soc_ordencompra.codemp=cxp_rd_spg.codemp       ".
                                                                           				  "    AND soc_ordencompra.cod_pro=cxp_rd_spg.cod_pro     ".
 						                                                    			  "    AND soc_ordencompra.numordcom=cxp_rd_spg.numdoccom)";
					}
					$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estcondat='S'";
					$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.estapro=1";
					break;
				case 'Reporte':
					break;
			}
		}

		$cadenaSQL= "SELECT soc_ordencompra.codemp,soc_ordencompra.numordcom,soc_ordencompra.estcondat,  ".
		        "           soc_ordencompra.fecordcom,soc_ordencompra.estsegcom,soc_ordencompra.porsegcom,  ".
		        "           soc_ordencompra.monsegcom,soc_ordencompra.forpagcom,soc_ordencompra.estcom,  ".
		        "           soc_ordencompra.diaplacom,soc_ordencompra.concom,soc_ordencompra.obscom,   ".
                "           soc_ordencompra.monsubtot,soc_ordencompra.monbasimp,soc_ordencompra.monimp,   ".
		        "           soc_ordencompra.mondes,soc_ordencompra.montot,soc_ordencompra.lugentnomdep,  ".
		        "           soc_ordencompra.lugentdir,soc_ordencompra.monant,soc_ordencompra.estlugcom,   ".
		        "           soc_ordencompra.tascamordcom,soc_ordencompra.montotdiv,soc_ordencompra.estapro, ". 
                "           soc_ordencompra.fecaprord,soc_ordencompra.coduniadm,soc_ordencompra.obsordcom,  ".
		        "           soc_ordencompra.cod_pro,soc_ordencompra.codfuefin,spg_unidadadministrativa.denuniadm, ".
		        " 			soc_ordencompra.codestpro1,soc_ordencompra.codestpro2,soc_ordencompra.tipbieordcom,  ".
		        "           soc_ordencompra.codestpro3,soc_ordencompra.codestpro4,soc_ordencompra.codestpro5,  ".
		        "           soc_ordencompra.estcla,sigesp_fuentefinanciamiento.denfuefin,soc_ordencompra.codmon,  ".
		        "           soc_ordencompra.codtipmod,soc_ordencompra.codpai,soc_ordencompra.codest,   ".
				"           soc_ordencompra.codmun,soc_ordencompra.codpar,soc_ordencompra.conanusoc,   ".
		        "           soc_ordencompra.numanacot,soc_ordencompra.uniejeaso,soc_ordencompra.fechentdesde,  ".
		        "           soc_ordencompra.fechenthasta,  ".   
				"          (SELECT despai FROM sigesp_pais  ".
				"           WHERE soc_ordencompra.codpai=sigesp_pais.codpai)AS despai,  ". 
				"          (SELECT desest FROM sigesp_estados    ". 
				"           WHERE soc_ordencompra.codpai=sigesp_estados.codpai   ".
				"              AND soc_ordencompra.codest=sigesp_estados.codest)AS desest,  ".  
                "          (SELECT denmun FROM sigesp_municipio   ".
				"           WHERE soc_ordencompra.codpai=sigesp_municipio.codpai   ". 
				"             AND soc_ordencompra.codest=sigesp_municipio.codest   ".
				"             AND soc_ordencompra.codmun=sigesp_municipio.codmun) AS denmun,  ". 
				"          (SELECT denpar FROM sigesp_parroquia   ".
				"           WHERE soc_ordencompra.codpai=sigesp_parroquia.codpai  ". 
				"              AND soc_ordencompra.codest=sigesp_parroquia.codest   ".
				"              AND soc_ordencompra.codmun=sigesp_parroquia.codmun    ".
				"              AND soc_ordencompra.codpar=sigesp_parroquia.codpar) AS denpar,  ". 
				"          (SELECT denmon FROM sigesp_moneda   ". 
				"           WHERE soc_ordencompra.codmon=sigesp_moneda.codmon)AS denmon, ".
		        "           rpc_proveedor.nompro,rpc_proveedor.tipconpro,   ".
				"          (SELECT denmodcla FROM soc_modalidadclausulas   ".
				"           WHERE soc_ordencompra.codemp=soc_modalidadclausulas.codemp   ".
				"             AND soc_ordencompra.codtipmod=soc_modalidadclausulas.codtipmod)AS denmodcla   ". 
                " 	 FROM  soc_ordencompra  ".
				"	 INNER JOIN rpc_proveedor USING(codemp,cod_pro)  ".
 				"	 INNER JOIN spg_unidadadministrativa USING(codemp,coduniadm)  ".
				"	 INNER JOIN spg_dt_unidadadministrativa USING(codemp,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla)  ".
				"	 INNER JOIN sigesp_fuentefinanciamiento USING(codemp,codfuefin)  ".
				"	 WHERE soc_ordencompra.codemp = '{$codemp}'  ".  
                "      AND soc_ordencompra.numordcom<>'000000000000000'  {$cadenaFiltro} ".
				"    GROUP BY soc_ordencompra.codemp,soc_ordencompra.numordcom,soc_ordencompra.estcondat,  ".
		        "             soc_ordencompra.fecordcom,soc_ordencompra.estsegcom,soc_ordencompra.porsegcom,  ".
		        "             soc_ordencompra.monsegcom,soc_ordencompra.forpagcom,soc_ordencompra.estcom,  ".
		        "             soc_ordencompra.diaplacom,soc_ordencompra.concom,soc_ordencompra.obscom,   ".
                "             soc_ordencompra.monsubtot,soc_ordencompra.monbasimp,soc_ordencompra.monimp,   ".
		        "             soc_ordencompra.mondes,soc_ordencompra.montot,soc_ordencompra.lugentnomdep,  ".
		        "             soc_ordencompra.lugentdir,soc_ordencompra.monant,soc_ordencompra.estlugcom,   ".
		        "             soc_ordencompra.tascamordcom,soc_ordencompra.montotdiv,soc_ordencompra.estapro, ". 
                "             soc_ordencompra.fecaprord,soc_ordencompra.coduniadm,soc_ordencompra.obsordcom,  ".
		        "             soc_ordencompra.cod_pro,soc_ordencompra.codfuefin,spg_unidadadministrativa.denuniadm, ".
		        " 			  soc_ordencompra.codestpro1,soc_ordencompra.codestpro2,soc_ordencompra.tipbieordcom,  ".
		        "             soc_ordencompra.codestpro3,soc_ordencompra.codestpro4,soc_ordencompra.codestpro5,  ".
		        "             soc_ordencompra.estcla,sigesp_fuentefinanciamiento.denfuefin,soc_ordencompra.codmon,  ".
		        "             soc_ordencompra.codtipmod,soc_ordencompra.codpai,soc_ordencompra.codest,   ".
				"             soc_ordencompra.codmun,soc_ordencompra.codpar,soc_ordencompra.conanusoc,   ".
		        "             soc_ordencompra.numanacot,soc_ordencompra.uniejeaso,soc_ordencompra.fechentdesde,  ".
		        "             soc_ordencompra.fechenthasta,rpc_proveedor.nompro,rpc_proveedor.tipconpro  ".
		        "    ORDER BY soc_ordencompra.numordcom ASC";
 			 $data = $this->conexionBaseDatos->Execute($cadenaSQL);
 			 if($data === false){
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
			return $data;
	}
	
	public function cargarCargos($codemp,$tipo,$numero){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL='';
		$cadenaFiltro='';

		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		if($tipo=='B'){
			$tabla = 'soc_dta_cargos';
			$campo = 'codart'; 
		}
		else if($tipo=='S'){
			$tabla = 'soc_dts_cargos';
			$campo = 'codser';
		}
		$cadenaSQL=" SELECT ".$tabla.".".$campo." AS codigo, ".$tabla.".codcar, ".$tabla.".monbasimp,{$cadenaEstructura} as estructura,".
				"		    ".$tabla.".monimp, ".$tabla.".numsol, ".$tabla.".monto, ".$tabla.".formula, ".
				"		    estcla,codestpro1, codestpro2, codestpro3,codestpro4, codestpro5,codfuefin,".
				"           (SELECT dencar FROM sigesp_cargos".
				"            WHERE ".$tabla.".codemp = sigesp_cargos.codemp".
				"            AND ".$tabla.".codcar = sigesp_cargos.codcar)AS dencar, ".
				"           (SELECT spg_cuenta FROM sigesp_cargos".
				"            WHERE ".$tabla.".codemp = sigesp_cargos.codemp".
				"            AND ".$tabla.".codcar = sigesp_cargos.codcar)AS spg_cuenta, ".
				"           (SELECT COUNT(spg_cuenta) ".
		        "            FROM spg_cuentas ".
				"		 	 WHERE spg_cuentas.codestpro1 = codestpro1 ".
				"		       AND spg_cuentas.codestpro2 = codestpro2 ".
				"		       AND spg_cuentas.codestpro3 = codestpro3 ".
				"		       AND spg_cuentas.codestpro4 = codestpro4 ".
				"		       AND spg_cuentas.codestpro5 = codestpro5 ".
				"			   AND spg_cuentas.estcla=estcla ".
				"		       AND spg_cuentas.codemp = '{$codemp}' ".
				"			   AND spg_cuentas.spg_cuenta = (SELECT spg_cuenta ". 
				"				                             FROM sigesp_cargos".
				"            								 WHERE ".$tabla.".codemp = sigesp_cargos.codemp".
				"                                            AND ".$tabla.".codcar = sigesp_cargos.codcar)) AS existecuenta ".
				"    FROM ".$tabla." ".
				"    WHERE ".$tabla.".codemp = '".$codemp."' AND ".
				"          ".$cadena." ".
				"          ".$tabla.".numordcom = '".$numero."' ";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
 		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarDenomMoneda($codpai)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql=" SELECT codmon, denmon ".
				"    FROM sigesp_moneda ".
				"    WHERE codpai='".$codpai."' ".
				"    ORDER BY codmon ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	function validarCuentas($codemp,$numordcom,$estcondat)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$estcom='1';
		$cadenaSQL='';
		$cadenaSQL="SELECT codestpro1, codestpro2, codestpro3, codestpro4, codestpro5,estcla, TRIM(spg_cuenta) AS spg_cuenta, monto, ".
				"	    (SELECT (asignado-(comprometido+precomprometido)+aumento-disminucion) ".
				"		 FROM spg_cuentas ".
				"		 WHERE spg_cuentas.codemp = soc_cuentagasto.codemp ".
				"		   AND spg_cuentas.codestpro1 = soc_cuentagasto.codestpro1 ".
				"		   AND spg_cuentas.codestpro2 = soc_cuentagasto.codestpro2 ".
				"		   AND spg_cuentas.codestpro3 = soc_cuentagasto.codestpro3 ".
				"		   AND spg_cuentas.codestpro4 = soc_cuentagasto.codestpro4 ".
				"		   AND spg_cuentas.codestpro5 = soc_cuentagasto.codestpro5 ".
				"          AND spg_cuentas.estcla=soc_cuentagasto.estcla".
				"		   AND spg_cuentas.spg_cuenta = soc_cuentagasto.spg_cuenta) AS disponibilidad, ".		
				"		(SELECT COUNT(codemp) ".
				"		 FROM spg_cuentas ".
				"		 WHERE spg_cuentas.codemp = soc_cuentagasto.codemp ".
				"		   AND spg_cuentas.codestpro1 = soc_cuentagasto.codestpro1 ".
				"		   AND spg_cuentas.codestpro2 = soc_cuentagasto.codestpro2 ".
				"		   AND spg_cuentas.codestpro3 = soc_cuentagasto.codestpro3 ".
				"		   AND spg_cuentas.codestpro4 = soc_cuentagasto.codestpro4 ".
				"		   AND spg_cuentas.codestpro5 = soc_cuentagasto.codestpro5 ".
				"          AND spg_cuentas.estcla=soc_cuentagasto.estcla".
				"		   AND spg_cuentas.spg_cuenta = soc_cuentagasto.spg_cuenta) AS existe ".		
				"FROM soc_cuentagasto  ".
				"WHERE codemp='".$codemp."' ".
				"  AND numordcom='".$numordcom."'".
				"  AND estcondat='".$estcondat."'";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
    	if($data===false){		
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;		
		}
		else
		{
			$continuar=true;
			$_SESSION['fechacomprobante'] = '1900-01-01';
			while((!$data->EOF) && ($continuar))
			{
				$monto=$data->fields["monto"];
				$existe=$data->fields["existe"];
				$this->servicioComprobante = new ServicioComprobanteSPG();
				$arrdetallespg['codemp']     = $_SESSION['la_empresa']['codemp'];
				$arrdetallespg['codestpro1'] = $data->fields['codestpro1'];
				$arrdetallespg['codestpro2'] = $data->fields['codestpro2'];
				$arrdetallespg['codestpro3'] = $data->fields['codestpro3'];
				$arrdetallespg['codestpro4'] = $data->fields['codestpro4'];
				$arrdetallespg['codestpro5'] = $data->fields['codestpro5'];
				$arrdetallespg['estcla']     = $data->fields['estcla'];
				$arrdetallespg['spg_cuenta'] = $data->fields['spg_cuenta'];
				$this->servicioComprobante->setDaoDetalleSpg($arrdetallespg);
				$this->servicioComprobante->saldoSelect('ACTUAL');
				$disponibilidad =  (($this->servicioComprobante->asignado + $this->servicioComprobante->aumento) - ( $this->servicioComprobante->disminucion + $this->servicioComprobante->comprometido + $this->servicioComprobante->precomprometido));
				if($existe>0)
				{
					$monto=number_format($monto,2,".","");
					$disponibilidad=number_format($disponibilidad,2,".","");
					if($monto>$disponibilidad)
					{
						$monto=number_format($monto,2,",",".");
						$disponibilidad=number_format($disponibilidad,2,",",".");
						$this->mensaje .= '  ->No hay Disponibilidad en la cuenta'.$arrdetallespg['spg_cuenta'].' Disponible=['.$disponibilidad.'] Cuenta=['.$monto.']';
						$continuar= false;
						$estcom="0";
					}
				}
				else
				{
					$continuar = false;
					$estcom="0";
					$this->mensaje .= '  ->La Cuenta '.$arrdetallespg['spg_cuenta']." No Existe en la Estructura ".formatoprogramatica($arrdetallespg['codestpro1'].$arrdetallespg['codestpro2'].$arrdetallespg['codestpro3'].$arrdetallespg['codestpro4'].$arrdetallespg['codestpro5']).'::'.$arrdetallespg['estcla'];
				}
				unset($this->servicioComprobante);
				$data->MoveNext();
			}
			$str = "codemp='{$codemp}'";
			$str .= " AND numordcom='{$numordcom}'";
			$str .= " AND estcondat='{$estcondat}'";
			$this->daoCambioEstatusSoc = FabricaDao::CrearDAO('C','soc_ordencompra','',$str);
			$this->daoCambioEstatusSoc->estcom=$estcom;
			if($this->daoCambioEstatusSoc->modificar()==0)
			{
				break;
			}
			return $estcom; 					
		}
	}
	
	
}
?>