<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/soc/sigesp_srv_soc_iregistro_cotizacion.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");

class ServicioRegistroCotizacion implements IRegistroCotizacion {

	public  $mensaje; 
	public  $valido; 
	private $conexionBaseDatos; 
	private $servicioComprobante;
	private $daoRegistroEvento;
	private $daoRegistroCotizacion;
	private $daoDetalle;
	private $daoCambioEstatusSolCot;
	
	public function ServicioRegistroCotizacion() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoRegistroEvento = null;
		$this->daoRegistroCotizacion = null;
		$this->daoCambioEstatusSolCot = null;
	}
	
	
	public function buscarNumeroCotizacion($codemp) {
		$this->daoRegistroCotizacion = FabricaDao::CrearDAO('N','soc_cotizacion');
		$this->daoRegistroCotizacion->codemp = $codemp;
		return $this->daoRegistroCotizacion->buscarCodigo('numcot',true,15,array(),'SOC','SOCCOT',$_SESSION['la_logusr']);
	}
	
	public function guardarCotizacion($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detallesBienesServicios;
		
		//obteniendo las instacias de los dao's
		$this->daoRegistroCotizacion = FabricaDao::CrearDAO("N","soc_cotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoRegistroCotizacion->setData($objson);
		$this->daoRegistroCotizacion->codemp=$codemp;
		$this->daoRegistroCotizacion->feccot = convertirFechaBd($objson->feccot);
		$this->daoRegistroCotizacion->poriva = formatoNumericoBd($objson->poriva,1);
		$this->daoRegistroCotizacion->mondes = formatoNumericoBd(0,1);
		$this->daoRegistroCotizacion->estinciva = 0;
		DaoGenerico::iniciarTrans();
		
		$resultado = $this->daoRegistroCotizacion->incluir(true,"numcot",true,15);
		$arrcadres = explode(",",$resultado);
		//insertando el registro y escribiendo en el log
		
		if($arrcadres[0]==1||$arrcadres[0]==-1){
			if($objson->tipcot=='B'){
				foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_bienes");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1);
					$this->daoDetalle->preuniart = formatoNumericoBd($detalle->preuniart,1);
					$this->daoDetalle->monsubart = formatoNumericoBd($detalle->monsubart,1);
					$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
					$this->daoDetalle->montotart = formatoNumericoBd($detalle->montotart,1);
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
			else{
				foreach ($arrDetalle as $detalle) {
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_servicio");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
					$this->daoDetalle->monuniser = formatoNumericoBd($detalle->monuniser,1);
					$this->daoDetalle->monsubser = formatoNumericoBd($detalle->monsubser,1);
					$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
					$this->daoDetalle->montotser = formatoNumericoBd($detalle->montotser,1);
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans()){
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				if($arrcadres[0]==1){
					return "|1";
				}
				else{
					return "|".$arrcadres[0]."|".$arrcadres[1];
				} 		
			}
			else{
				$arrevento ['desevetra'] = $this->daoRegistroCotizacion->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				return "|0";
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroCotizacion);
			unset($this->daoRegistroEvento);	
		}
		else{
			return "|0";
		}
		
	}

	function eliminar($codemp,$numcot,$tabla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "DELETE FROM {$tabla} ".
				" 	  WHERE codemp='{$codemp}' ".
		        "       AND numcot='{$numcot}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		else{
			return true;
		}
	}
	
	public function modificarCotizacion($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detallesBienesServicios;
		
		//obteniendo las instacias de los dao's
		$this->daoRegistroCotizacion = FabricaDao::CrearDAO("N","soc_cotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoRegistroCotizacion->setData($objson);
		$this->daoRegistroCotizacion->codemp=$codemp;
		$this->daoRegistroCotizacion->feccot = convertirFechaBd($objson->feccot);
		$this->daoRegistroCotizacion->poriva = formatoNumericoBd($objson->poriva,1);
		$this->daoRegistroCotizacion->mondes = formatoNumericoBd(0,1);
		$this->daoRegistroCotizacion->estinciva = 0;
		DaoGenerico::iniciarTrans();
		
		$this->daoRegistroCotizacion->modificar();
		//insertando el registro y escribiendo en el log
		
		if($objson->tipcot=='B'){
			$eliminobie = $this->eliminar($codemp,$objson->numcot,'soc_dtcot_bienes');
			if($eliminobie){
				foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_bienes");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1);
					$this->daoDetalle->preuniart = formatoNumericoBd($detalle->preuniart,1);
					$this->daoDetalle->monsubart = formatoNumericoBd($detalle->monsubart,1);
					$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
					$this->daoDetalle->montotart = formatoNumericoBd($detalle->montotart,1);
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}	
			}
		}
		else{
			$eliminoser = $this->eliminar($codemp,$objson->numcot,'soc_dtcot_servicio');
			if($eliminoser){
				foreach ($arrDetalle as $detalle) {
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_servicio");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
					$this->daoDetalle->monuniser = formatoNumericoBd($detalle->monuniser,1);
					$this->daoDetalle->monsubser = formatoNumericoBd($detalle->monsubser,1);
					$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
					$this->daoDetalle->montotser = formatoNumericoBd($detalle->montotser,1);
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
		}
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else{
			$arrevento ['desevetra'] = $this->daoRegistroCotizacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoRegistroCotizacion);
		unset($this->daoRegistroEvento);
    	return $resultado;
		
	}

	public function eliminarCotizacion($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detallesBienesServicios;
		
		//obteniendo las instacias de los dao's
		$this->daoRegistroCotizacion = FabricaDao::CrearDAO("N","soc_cotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoRegistroCotizacion->setData($objson);
		$this->daoRegistroCotizacion->codemp=$codemp;
		$this->daoRegistroCotizacion->feccot = convertirFechaBd($objson->feccot);
		$this->daoRegistroCotizacion->poriva = formatoNumericoBd($objson->poriva,1);
		$this->daoRegistroCotizacion->mondes = formatoNumericoBd(0,1);
		$this->daoRegistroCotizacion->estinciva = 0;
		DaoGenerico::iniciarTrans();
		
		if($objson->tipcot=='B'){
			foreach ($arrDetalle as $detalle){
				$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_bienes");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1);
				$this->daoDetalle->preuniart = formatoNumericoBd($detalle->preuniart,1);
				$this->daoDetalle->monsubart = formatoNumericoBd($detalle->monsubart,1);
				$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
				$this->daoDetalle->montotart = formatoNumericoBd($detalle->montotart,1);
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
		}
		else{
			foreach ($arrDetalle as $detalle) {
				$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtcot_servicio");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
				$this->daoDetalle->monuniser = formatoNumericoBd($detalle->monuniser,1);
				$this->daoDetalle->monsubser = formatoNumericoBd($detalle->monsubser,1);
				$this->daoDetalle->moniva = formatoNumericoBd($detalle->moniva,1);
				$this->daoDetalle->montotser = formatoNumericoBd($detalle->montotser,1);
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
		}
		
		//insertando el registro y escribiendo en el log
		$this->daoRegistroCotizacion->eliminar();
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else{
			$arrevento ['desevetra'] = $this->daoRegistroCotizacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoRegistroCotizacion);
		unset($this->daoRegistroEvento);
    	return $resultado;
		
	}
	public function buscarCotizaciones($codemp,$numcot,$numsolcot,$codpro,$tipbieser,$fecdes,$fechas,
									   $obscot,$estcot,$forpagcom,$daivalofe,$estasitec,$estesp,
									   $garanacot,$diaentcom,$origenCat){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$cadenaFiltro = '';
		$tablas = '';
		
		if(!empty($numcot)){
			$cadenaFiltro = "AND soc_cotizacion.numcot like '%{$numcot}%'";
		}
		if(!empty($numsolcot)){
			$cadenaFiltro = $cadenaFiltro."AND soc_cotizacion.numsolcot like '%{$numsolcot}%'";
		}
		if(!empty($codpro)){
			$cadenaFiltro = $cadenaFiltro."AND soc_cotizacion.cod_pro = '{$codpro}'";
		}
		if(!empty($tipbieser)){
		    $cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.tipcot ='{$tipbieser}'";
		}
		if(!empty($fecdes) && !empty($fechas)){
			$fecdes = convertirFechaBd($fecdes);
			$fechas = convertirFechaBd($fechas);
		    $cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.feccot BETWEEN '{$fecdes}' AND '{$fechas}'";
		}
		if(!empty($obscot)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.obscot = '{$obscot}'";
		}
		if(!empty($estcot)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.estcot = '{$estcot}'";
		}
		if(!empty($forpagcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.forpagcom = '{$forpagcom}'";
		}
		if(!empty($daivalofe)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.daivalofe = '{$daivalofe}'";
		}
		if(!empty($estasitec)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.estasitec = '{$estasitec}'";
		}
		if(!empty($estesp)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.forpagcom = '{$estesp}'";
		}
		if(!empty($garanacot)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.garanacot = '{$garanacot}'";
		}
		if(!empty($diaentcom)){
			$cadenaFiltro = $cadenaFiltro." AND soc_cotizacion.diaentcom = '{$diaentcom}'";
		}
		if(!empty($origenCat)){
			if($origenCat=='Anulacion'){
				$tablas=", soc_analisicotizacion, soc_cotxanalisis";
				$cadenaFiltro = $cadenaFiltro."	AND  soc_analisicotizacion.estana= '2' ".
					 						  "	AND  soc_cotizacion.estcot= '0'";
				$cadenaFiltro = $cadenaFiltro."	AND  soc_cotizacion.codemp=soc_cotxanalisis.codemp ".
					  						  "	AND  soc_cotizacion.numcot=soc_cotxanalisis.numcot ".
					                          "	AND  soc_cotizacion.cod_pro=soc_cotxanalisis.cod_pro ".
					                          "	AND  soc_analisicotizacion.codemp=soc_cotxanalisis.codemp ".
				  	                          "	AND  soc_analisicotizacion.numanacot=soc_cotxanalisis.numanacot ";
			}
		}
		
		$cadenaSQL = "SELECT soc_cotizacion.numcot,soc_cotizacion.cod_pro,soc_cotizacion.numsolcot,soc_cotizacion.feccot,".
					"	     soc_cotizacion.obscot,soc_cotizacion.monsubtot,soc_cotizacion.monimpcot,soc_cotizacion.mondes, ".
					"	     soc_cotizacion.montotcot,soc_cotizacion.diaentcom,soc_cotizacion.estcot,soc_cotizacion.forpagcom, ".
					"	     soc_cotizacion.poriva,soc_cotizacion.estinciva,soc_cotizacion.tipcot,rpc_proveedor.nompro,soc_cotizacion.diavalofe,soc_cotizacion.estasitec,soc_cotizacion.estesp,soc_cotizacion.garanacot ".
					" FROM soc_cotizacion {$tablas}".
					" INNER  JOIN rpc_proveedor USING(codemp,cod_pro) ".
					" WHERE soc_cotizacion.codemp='{$codemp}' {$cadenaFiltro} ".
		            " ORDER BY soc_cotizacion.numcot";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarBienesServicios($codemp,$numcot,$tipcot,$codpro) {
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$cadenaFiltro = '';
		
		if($tipcot=='B'){
			if(!empty($codpro)){
				$cadenaFiltro = "AND soc_dtcot_bienes.cod_pro = '{$codpro}'";
			}
			$cadenaSQL = "SELECT soc_dtcot_bienes.codart,soc_dtcot_bienes.unidad,soc_dtcot_bienes.canart,  ".
			          "          soc_dtcot_bienes.preuniart,soc_dtcot_bienes.moniva,soc_dtcot_bienes.monsubart,  ".
			          "          soc_dtcot_bienes.montotart,soc_dtcot_bienes.nivcalart,siv_articulo.denart, ".
			          "          soc_cotizacion.estcot,siv_unidadmedida.denunimed ".
					  "	  FROM soc_dtcot_bienes ".
					  "	  INNER JOIN soc_cotizacion USING(codemp,numcot) ".
				 	  "	  INNER JOIN siv_articulo USING(codemp,codart) ".
					  "	  INNER JOIN siv_unidadmedida USING(codunimed)".
				   	  "	  WHERE soc_dtcot_bienes.codemp='{$codemp}' ".
				      "	  	AND soc_dtcot_bienes.numcot='{$numcot}' ". 
				   	  "	  ORDER BY soc_dtcot_bienes.orden ASC";
		}
		if($tipcot=='S'){
			if(!empty($codpro)){
				$cadenaFiltro = "AND soc_dtcot_servicio.cod_pro = '{$codpro}'";
			}
			$cadenaSQL = "SELECT soc_dtcot_servicio.codser,soc_dtcot_servicio.canser,soc_cotizacion.estcot, ".
					   "	 	 soc_dtcot_servicio.monuniser,soc_dtcot_servicio.moniva,soc_dtcot_servicio.monsubser, ".
					   "	 	 soc_dtcot_servicio.montotser,soc_dtcot_servicio.nivcalser,soc_servicios.denser ".
				       "  FROM soc_dtcot_servicio ".
				       "  INNER JOIN soc_cotizacion USING(codemp,numcot)".
				       "  INNER JOIN soc_servicios USING(codemp,codser) ".
				   	   "  WHERE soc_dtcot_servicio.codemp='{$codemp}' ".
				       "	AND soc_dtcot_servicio.numcot='{$numcot}' {$cadenaFiltro} ".
				   	   "  ORDER BY soc_dtcot_servicio.orden ASC";
			
		}
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarFormulaCredito($codemp,$codigo,$tipo){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$tabla1 = '';
		$tabla2 = '';
		$campo = '';
		                      
		switch($tipo){
	  		case 'B':
	    		$tabla1 = 'siv_articulo';
				$tabla2 = 'siv_cargosarticulo';
				$campo  = 'codart';
	  		break;
	  		case 'S':
	    		$tabla1 = 'soc_servicios';
				$tabla2 = 'soc_serviciocargo';
				$campo  = 'codser';
	  		break;
		}
	
		$cadenaSQL = "SELECT sigesp_cargos.formula AS formula, sigesp_cargos.porcar ".
			     	 "FROM sigesp_cargos,{$tabla1},{$tabla2} ".
			    	 "WHERE {$tabla2}.codemp='{$codemp}' ".
			      	 "	AND {$tabla2}.{$campo}='{$codigo}' ".
			      	 "	AND sigesp_cargos.codemp={$tabla2}.codemp ".
				  	 "	AND sigesp_cargos.codcar={$tabla2}.codcar ".
				  	 "	AND {$tabla1}.codemp={$tabla2}.codemp ".
				  	 "	AND {$tabla1}.{$campo}={$tabla2}.{$campo}";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarUltimaCotizacion($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$cadenaSql="SELECT numcot  ".  
				"	FROM soc_cotizacion  ".
				"   WHERE codemp='{$codemp}'";
		
		switch ($_SESSION["ls_gestor"]){
	   		case "MYSQLT":
				$limite="LIMIT 0,0 ";
				$cadenaSql = $cadenaSql."ORDER BY numcot DESC {$limite}";
			break;
	   		case "MYSQLI":
				$limite="LIMIT 0,0 ";
				$cadenaSql = $cadenaSql."ORDER BY numcot DESC {$limite}";
			break;
			case "POSTGRES": // POSTGRES
				$limite="LIMIT 1";
				$cadenaSql = $cadenaSql."ORDER BY numcot DESC {$limite}";
			break;
			case "ORACLE":
				$limite="AND rownum<1";
				$cadenaSql = $cadenaSql."{$limite} ORDER BY numcot DESC";
	   }
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['numcot'];
	}
	
    public function ValidarFecha($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$numero = $this->buscarUltimaCotizacion();
		$cadenaSql="SELECT feccot ".  
				"	FROM soc_cotizacion  ".
				"	WHERE codemp='{$codemp}' ". 
				"	  AND numcot='{$numero}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
    	if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['feccot'];
	}
	
}
?>