<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio solicitud de cotizaciones.
 */
interface ISolicitudCotizacion {
	 
	 /**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca el numero siguiente de la cotizacion
	 * @param $codemp - codigo de empresa
	 * @return srting numero de la cotizacion.
	 */
	public function buscarNumeroCotizacion($codemp);
		 
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca en la tabla de personal, la informacion del empleado que sera registrado como solicitante.
	 * @param string $codemp - codigo de empresa
	 * @param string $cedula - cedula del personal
	 * @param string $nombre - nombre del personal
	 * @param string $apellido - apellido del personal
	 * @return Resulset Adodb con los datos del personal.
	 */
	public function buscarPersonal($codemp, $cedula, $nombre, $apellido);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que guarda la solicitud de cotizacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param Array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarSolCot($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que modifica la solicitud de cotizacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarSolCot($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que elimina la solicitud de cotizacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarSolCot($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca los (bienes-servicios) asociados a una solicitud de cotizacion segun filtros                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numsolcot - numero de la cotizacion
	 * @param string $tipsolcot - tipo de la solicitud de cotizacion
	 * @param string $codpro - codigo del proveedor
	 * @return Resulset Adodb con los datos de los (bienes-servicios) asociados a la solicitud de cotizacion.
	 */
	public function cargarBieSerSolCot($codemp, $numsolcot, $tipsolcot, $codpro);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca los proveedores asociados a una solicitud de cotizacion segun filtros                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numsolcot - numero de la cotizacion
	 * @param string $tipsolcot - tipo de la solicitud de cotizacion
	 * @return Resulset Adodb con los datos de los proveedores asociados a la solicitud de cotizacion.
	 */
	public function cargarProSolCot($codemp,$numsolcot,$tipsolcot,$codpro,$nompro);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca las SEP asociadas a una solicitud de cotizacion segun filtros                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numsolcot - numero de la cotizacion
	 * @param string $tipsolcot - tipo de la solicitud de cotizacion
	 * @return Resulset Adodb con los datos de las SEP asociadas a la solicitud de cotizacion.
	 */
	public function cargarSepSolCot($codemp,$numsolcot);
	
	/**
	 * @author 
	  * @desc Metodo para la busqueda de una o varias solicitudes de cotizacion segun filtros
	 * @param string $codemp - codigo de empresa
	 * @param string $numsolcot - numero de la solicitud de cotizacion
	 * @param string $tipsolcot - tipo de la solicitud (Bien-Servicio)
	 * @param string $codpro -
	 * @param string $fecdes - fecha (desde) de la solicitud de cotizacion
	 * @param string $fechas - fecha (hasta) de la solicitud de cotizacion
	 * @return Resulset Adodb con los datos de las solicitudes de cotizacion.
	 */ 
	public function buscarSolCot($codemp,$numsolcot,$tipsolcot,$codpro,$fecdes,$fechas,$obssol,
								 $estcot,$cedper,$codcar,$soltel,$solfax,$coduniadm,$codfuefin,
								 $consolcot,$uniejeaso,$tipsolbie,$origenCat);
}
?>