<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio del reporte de orden de compra.
 */
interface IReporteOrdenCompra {
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca la o las ordenes de compra existentes, segun filtros.
	 * @param string $codemp - codigo de empresa
	 * @param string $numordcomdes - numero orden de compra rango desde
	 * @param string $numordcomhas - numero orden de compra rango hasta
	 * @param string $tipo - tipo de la orden de compra
	 * @param string $codprodes - codigo del proveedor rango desde
	 * @param string $codprohas - codigo del proveedor rango hasta
	 * @param string $fecordcomdes - fecha de la orden de compra rango desde
	 * @param string $fecordcomhas - fecha de la orden de compra rango hasta
	 * @param string $coduniejedes - codigo de la unidad ejecutora rango desde
	 * @param string $coduniejehas - codigo de la unidad ejecutora rango hasta
	 * @param string $codartdes - codigo del articulo rango desde
	 * @param string $codarthas - codigo del articulo rango hasta
	 * @param string $codserdes - codigo del servicio rango dsede
	 * @param string $codserhas - codigo del servicio rango hasta
	 * @param string $estanu,$estcom,$estemi,$estemiapro,$estentcom,$esttip - estatus de la orden de compra
	 * @return Resulset Adodb con los datos de la o las ordenes de compra.
	 */
	 public function buscarRepOrdCom($codemp,$numordcomdes,$numordcomhas,$tipo,$codprodes,$codprohas,
	 						 		$fecordcomdes,$fecordcomhas,$coduniejedes,$coduniejehas,$codartdes,
	 						 		$codarthas,$codserdes,$codserhas,$esttip,$estemi,$estemiapro,
	 						 		$estcom,$estanu,$estentcom);
}
?>