<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio de ordenes de compra.
 */
interface IRegistroOrdenCompra {
	 
	 /**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca el numero siguiente de la orden de compra
	 * @return srting numero de la orden de compra.
	 */
	public function buscarNumeroOrdenCompra($codemp,$estcondat);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * @return string $codigo - codigo de parametro de clasificacion
	 */ 
	public function buscarPais();
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * @param string $restriccion - restriccion (pais)
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarEstado($restriccion);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * @param string $restriccion - restriccion (pais-estado)
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarMunicipio($restriccion);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * @param string $restriccion - restriccion (pais-estado-municipio)
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarParroquia($restriccion);
	
	/**
	 * @author Ing. Gerardo Cordero
	  * @desc Metodo que busca en la tabla de modalidad de clausulas, la informacion de las mismas
	 * @param string $codemp - codigo de empresa
	 * @param string $codcla - codigo de la modalidad de clausula
	 * @param string $dencla - denominacion de la modalidad de clausula
	 * @return Resulset Adodb con los datos de la modalidad de clausula.
	 */
	public function buscarModCla($codemp, $codtipmod, $denmodcla);
	
	/**
	 * @author Ing. Gerardo Cordero
	  * @desc Metodo que busca un codigo de parametro para insertar
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarTipoMoneda($restriccion);	
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que guarda un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarOrdCom($codemp,$objJson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que elimina un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarOrdCom($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que busca los bienes o servicios asociados a una orden de compra
	 * @param string $codemp - codigo de empresa
	 * @param string $numordcom - numero de la orden de compra
	 * @param string $estcondat - tipo de la orden de compra (bien-servicio)
	 * @return Resulset Adodb con los datos de los bienes o servicios.
	 */
	public function cargarBieSerOrdCom($codemp, $numordcom, $estcondat);

	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que busca los cargos de un bien 
	 * @param string $codemp - codigo de empresa
	 * @param string $codart - codigo del articulo
	 * @return Resulset Adodb con los cargos del bien.
	 */
	public function cargarCargosBienes($codemp,$codart,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que busca los cargos de un servicio 
	 * @param string $codemp - codigo de empresa
	 * @param string $codser - codigo del servicio
	 * @return Resulset Adodb con los cargos del servicio.
	 */
	public function cargarCargosServicios($codemp,$codser,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que busca las cuentas asociadas a la orden de compra 
	 * @param string $codemp - codigo de empresa
	 * @param string $numero - numero de la orden de compra
	 * @param string $estcondat - tipo de distribucion (bien-servicio)
	 * @param string $tipsol - tipo SOC
	 * @return Resulset Adodb con las cuentas de la orden de compra.
	 */
	public function cargarCuentas($codemp,$numero,$estcondat,$tipsol);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que busca las cuentas creditos asociadas a la orden de compra 
	 * @param string $codemp - codigo de empresa
	 * @param string $numero - numero de la orden de compra
	 * @param string $estcondat - tipo de distribucion (bien-servicio)
	 * @param string $tipsol - tipo SOC
	 * @return Resulset Adodb con las cuentas creditos de la orden de compra.
	 */
	public function cargarCuentasCreditos($codemp,$numero,$estcondat,$tipsol);
	
	/**
	 *@author 
	 * @desc Mtodo que inprime el resultado de la busqueda de las cuentas presupuestarias de los cargos
	 * @param string $codemp - codigo de empresa
	 * @return Resulset Adodb con las cuentas presupuestarias de los cargos.
	 */
	public function buscarCuentasSpg($codemp,$tipo,$spg_cuenta,$codestpro1ue,$codestpro2ue,$codestpro3ue,$codestpro4ue,$codestpro5ue,$estclaue,$codfuefin);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Mtodo que busca la fecha de la ultima orden de compra registrada
	 * @param string $codemp - codigo de empresa
	 * @return string fecha de la ultima orden de compra registrada.
	 */
	public function ValidarFecha($codemp);
	
	 /**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo para la busqueda de una o varias ordenes de compra segun filtros
	 * @param string $codemp - codigo de empresa
	 * @param string $numeordcom - numero de la orden de compra
	 * @param string $tipbieser - tipo de distribucion (Bien-Servicio)
	 * @param string $cod_pro - codigo del proveedor
	 * @param string $fechentdesde - fecha (desde) de la orden de compra
	 * @param string $fechenthasta - fecha (hasta) de la orden de compra
	 * @return Resulset Adodb con los datos de las ordenes de compra.
	 */  
	public function buscarOrdenCompra($codemp,$numordcom,$tipbieser,$codpro,$fecordcomdes,
									  $fecordcomhas,$tipope,$codmon,$codfuefin,$codtipmod,
									  $estsegcom,$porsegcom,$forpagcom,$estcom,$diaplacom,
									  $concom,$obscom,$estpenalm,$codpai,$codest,$codmun,
									  $codpar,$lugentnomdep,$lugentdir,$estlugcom,$origenCat);
}
?>