<?php
/**
 * 
 * Interfaz del servicio del registro de cotizaciones
 */
interface IRegistroCotizacion {
	 
	 /**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca el numero siguiente de la cotizacion
	 * @param $codemp - codigo de empresa
	 * @return srting numero de la cotizacion.
	 */
	public function buscarNumeroCotizacion($codemp);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que guarda un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarCotizacion($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que modifica un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarCotizacion($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que elimina un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarCotizacion($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca los (bienes-servicios) asociados a una cotizacion segun filtros                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numcot - numero de la cotizacion
	 * @param string $tipcot - tipo de la cotizacion (bien-servicio)
	 * @param string $codpro - codigo del proveedor
	 * @return Resulset Adodb con los datos de los (bienes-servicios) asociados a la solicitud de cotizacion.
	 */
	public function cargarBienesServicios($codemp,$numcot,$tipcot,$codpro);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca las cotizaciones segun parametros de clasificacion                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numcot - numero de la cotizacion
	 * @param string $numsolcot - numero de la solicitud de cotizacion
	 * @param string $tipbieser - tipo de la cotizacion (bien-servicio)
	 * @param string $fecdes - rango de fecha desde
	 * @param string $fechas - rango de fecha hasta
	 * @return Resulset Adodb con los datos de las cotizaciones.
	 */ 
	public function buscarCotizaciones($codemp,$numcot,$numsolcot,$codpro,$tipbieser,$fecdes,$fechas,
									   $obscot,$estcot,$forpagcom,$daivalofe,$estasitec,$estesp,
									   $garanacot,$diaentcom,$origenCat);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca la formula del cargo del bien o servicio                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $codigo - codigo del bien o servicio
	 * @param string $tipo - tipo de distribucion (bien-servicio)
	 * @return Resulset Adodb con la formula del cargo del bien o servicio.
	 */
	public function cargarFormulaCredito($codemp,$codigo,$tipo);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca la ultima cotizacion registrada
	 * @return string con el numero de la ultima cotizacion registrada.
	 */
	public function buscarUltimaCotizacion($codemp);
	
	/**
	 * @author Ing. Maryoly Caceres
	  * @desc Metodo que busca la fecha de la ultima cotizacion registrada                                           
	 * @param string $codemp - codigo de empresa
	 * @return string con la fecha de la ultima cotizacion registrada.
	 */
	public function ValidarFecha($codemp);
	
}
?>