<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio solicitud de cotizaciones.
 */
interface IComunSOC {
	 
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca los proveedores que estara asociada a la solicitud de cotizacion.
	 * @return Resulset Adodb con los datos de los tipos de articulo. 
	 */
	public function buscarTipoArticulo();
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para la busqueda de uno o varios bienes.
	 * @param string $codemp     - codigo de empresa
	 * @param string $origenCat  - variable para indicar el origen del catalogo
	 * @param string $codart     - codigo del articulo
	 * @param string $denart     - denominacion del articulo
	 * @param string $tipoart    - tipo del articulo
	 * @param string $tipobien   - tipo de bien (Material o Activo)
	 * @param string $codestpro1 - codigo de estructura presupuestaria nivel 1
	 * @param string $codestpro2 - codigo de estructura presupuestaria nivel 2
	 * @param string $codestpro3 - codigo de estructura presupuestaria nivel 3
	 * @param string $codestpro4 - codigo de estructura presupuestaria nivel 4
	 * @param string $codestpro5 - codigo de estructura presupuestaria nivel 5
	 * @param string $estcla     - codigo de estus de clasificacion
	 * @return Resulset Adodb con los datos de los bienes.
	 */
	public function buscarBienes($codemp,$origenCat,$codart,$denart,$tipoart,$tipobien,$codestpro1,$codestpro2,
	 							 $codestpro3,$codestpro4,$codestpro5,$estcla);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para la busqueda de uno o varios servicios.
	 * @param string $codemp
	 * @param string $origenCat
	 * @param string $codser
	 * @param string $denser
	 * @param string $codestpro1
	 * @param string $codestpro2
	 * @param string $codestpro3
	 * @param string $codestpro4
	 * @param string $codestpro5
	 * @param string $estcla
	 * @return Resulset Adodb con los datos de los servicios.
	 */
	public function buscarServicios($codemp,$origenCat,$codser,$denser,$codestpro1,$codestpro2,$codestpro3,
									$codestpro4,$codestpro5,$estcla);	

}
?>