<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio analisis de cotizaciones.
 */
interface IAnalisisCotizacion {
	 
	 /**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca el numero siguiente de analisis de cotizacion
	 * @param $codemp - codigo de la empresa
	 * @return srting numero de analisis de cotizacion.
	 */
	public function buscarNumAnaCot($codemp);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca los proveedores que cotizaron un bien o servicio
	 * @param $codemp - codigo de la empresa
	 * @return Resulset Adodb con los datos de los proveedores.
	 */
	public function cargarProveedores($codemp,$numsolcot,$tipo,$codigo);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca el monto total de cada bien o servicio por numero de cotizacion y proveedor
	 * @param $codemp - codigo de la empresa
	 * @param $numcot - numero de la cotizacion
	 * @param $tipcot - tipo de distribucion (bien-servicio)
	 * @param $codpro - codigo del proveedor
	 * @return Resulset Adodb con los datos de cada bien o servicio.
	 */
	public function buscarAnaPre($codemp,$numcot,$tipcot,$codpro);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que busca el nivel de calidad de cada bien o servicio por numero de cotizacion y proveedor
	 * @param $codemp - codigo de la empresa
	 * @param $numcot - numero de la cotizacion
	 * @param $tipcot - tipo de distribucion (bien-servicio)
	 * @param $codpro - codigo del proveedor
	 * @return Resulset Adodb con los datos de cada bien o servicio.
	 */
	public function buscarAnaCuaItems($codemp,$numcot,$tipcot,$codpro);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que  devuelve los datos de la cotizacion por proveedor
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @return Resulset Adodb con los datos de la cotizacion por proveedor.
	 */
	public function buscarAnaCuaCot($codemp,$numcot,$codpro);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que devuelve el numero del ultimo analisis de cotizacion registrado
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @return string numero del ultimo analisis de cotizacion registrado.
	 */
	public function  buscarUltimoAnalisis($codemp);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que devuelve la fecha del ultimo analisis de cotizacion registrado
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @return string fecha del ultimo analisis de cotizacion registrado.
	 */
	public function ValidarFecha($codemp);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que guarda el analisis de cotizacion
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarAnaCot($codemp,$objson,$arrevento); 
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que modifica el analisis de cotizacion
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarAnaCot($codemp,$objson,$arrevento); 
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que elimina el analisis de cotizacion
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarAnaCot($codemp,$objson,$arrevento); 
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que  devuelve las cotizaciones que participaron en un determinado analisis
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return Resulset Adodb que contiene las cotizaciones que participaron en un determinado analisis
	 */
	public function cargarCotizaciones($codemp,$numanacot);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que  devuelve los items (Bienes-Servicios) que participaron en un determinado analisis
	 * @param $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return Resulset Adodb que contiene los items (Bienes-Servicios) que participaron en un determinado analisis
	 */
	public function cargarBienesServicios($codemp,$numanacot,$tipsolcot);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que devuelve las distintas denominaciones de clasificacion existentes en la tabla rpc_clasificacion
	 * @param $codemp - codigo de la empresa
	 * @return Resulset Adodb que contiene las denominaciones de clasificacion
	 */
	public function buscarDenClasificacion($codemp);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que devuelve el nivel de clasificacion de cada proveedor 
	 * @param $codemp - codigo de la empresa
	 * @param $codpro - codigo del proveedor
	 * @return Resulset Adodb con el nivel de clasificacion del proveedor
	 */
	public function buscarNivClasificacion($codemp,$objson);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo para la busqueda de uno o varios analisis de cotizacion segun filtros                                           
	 * @param string $codemp - codigo de empresa
	 * @param string $numsolcot - numero de la solicitud de cotizacion
	 * @param string $numanacot - numero de analisis de cotizacion
	 * @param string $fecdes - fecha (desde) del analisis de cotizacion
	 * @param string $fechas - fecha (hasta) del analisis de cotizacion
	 * @return Resulset Adodb con los datos de los analisis de cotizacion.
	 */ 
	public function buscarAnaCot($codemp,$numsolcot,$numanacot,$tipsolcot,$fecdes,$fechas,$origenCatalogo,
	                             $tipope,$codpro,$estana,$obsana,$fecapro,$recanacot,$estasitec,$estesp,
	                             $garanacot); 
	
}    
?>