<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/soc/sigesp_srv_soc_igenerar_orden_analisis.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");

class ServicioGeneracionOrdAna implements IGeneracionOrdAna {

	public  $mensaje; 
	public  $valido; 
	private $conexionBaseDatos; 
	private $daoRegistroEvento;
	private $servicioComprobante;
	private $daoGeneracionOrdAna;
	private $daoDetalleSEP;
	private $daoDetalle;
	private $daoOrdenCompra;
	private $daoDetalleCuenta;
	private $daoDetalleCargo;
	private $daoCambioEstatusSep;
	private $daoCambioEstatusItemSep;
	
	public function ServicioGeneracionOrdAna() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoOrdenCompra = null;
		$this->daoGeneracionOrdAna = null;
		$this->daoDetalleSEP = null;
		$this->daoDetalle = null;
		$this->daoRegistroEvento = null;
		$this->daoCambioEstatusSep = null;
		$this->daoCambioEstatusItemSep = null;
		$this->daoDetalleCuenta = null;
		$this->daoDetalleCargo = null;
	}
	
	function buscarCotAna($codemp,$numanacot,$tipsolcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		if($tipsolcot=="B")
			$tabla = "soc_dtac_bienes";
		if($tipsolcot == "S")	
			$tabla = "soc_dtac_servicios";
				
		$cadenaSQL= "SELECT soc_cotxanalisis.numcot,soc_cotxanalisis.cod_pro,rpc_proveedor.tipconpro ".
				  	"FROM soc_cotxanalisis, rpc_proveedor  ".
				  	"WHERE soc_cotxanalisis.codemp='{$codemp}'  ".
		            "  AND soc_cotxanalisis.numanacot='{$numanacot}' ".
				  	"  AND soc_cotxanalisis.codemp= rpc_proveedor.codemp  ".
		            "  AND soc_cotxanalisis.cod_pro = rpc_proveedor.cod_pro ".
				  	"  AND soc_cotxanalisis.numcot IN (SELECT numcot FROM {$tabla} WHERE codemp='{$codemp}')";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
		
	}
	
	function buscarDetallesCotizacion($codemp,$cod_pro,$numcot,$numanacot,$tipsolcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		if($tipsolcot=="B"){
			$cadenaSQL= "SELECT soc_dtac_bienes.codart as codigo,MAX(siv_articulo.denart) as denominacion,  ".
			            "       MAX(rpc_proveedor.nompro) AS nompro,MAX(soc_dtcot_bienes.canart) as cantidad,  ".
			            "       MAX(soc_dtcot_bienes.preuniart) as precio,MAX(soc_dtcot_bienes.moniva) AS moniva, ".
						"		MAX(soc_dtcot_bienes.montotart) as monto,MAX(soc_dtac_bienes.obsanacot) AS obsanacot,  ".
						"       MAX(soc_dtsc_bienes.coduniadm) as coduniadm,MAX(soc_dtsc_bienes.codestpro1) as codestpro1,  ".
						"       MAX(soc_dtsc_bienes.codestpro2) as codestpro2,MAX(soc_dtsc_bienes.codestpro3) as codestpro3,  ".
						"       MAX(soc_dtsc_bienes.codestpro4) as codestpro4,MAX(soc_dtsc_bienes.codestpro5) as codestpro5,  ".
						"	    MAX(soc_dtsc_bienes.estcla) as estcla,MAX(soc_sol_cotizacion.codfuefin) as codfuefin, ".
			            "       MAX(soc_dtac_bienes.numcot) AS numcot,MAX(soc_dtac_bienes.cod_pro) AS cod_pro,  ".
			            "       MAX(soc_dtsc_bienes.numsep) AS numsep,MAX(siv_unidadmedida.unidad) AS unidad, ".
						"		MAX(soc_dtcot_bienes.unidad) AS modalidad ".
					   	"FROM soc_dtac_bienes   	".
						"INNER JOIN rpc_proveedor USING(codemp,cod_pro) ".
						"INNER JOIN siv_articulo USING(codemp,codart) ".
						"INNER JOIN siv_unidadmedida USING(codunimed) ".
						"INNER JOIN soc_dtcot_bienes USING(codemp,codart,numcot) ".
						"INNER JOIN soc_dtsc_bienes USING(codemp,codart) ".
						"INNER JOIN soc_cotizacion USING(codemp,numcot,numsolcot) ".
						"INNER JOIN soc_sol_cotizacion USING(codemp,numsolcot) ".
						"WHERE soc_dtac_bienes.codemp='{$codemp}' ".
					    "  AND soc_dtac_bienes.numanacot='{$numanacot}' ". 
					    "  AND soc_dtcot_bienes.cod_pro='{$cod_pro}' ".
						"  AND soc_dtcot_bienes.numcot='{$numcot}'  ".
					  	"GROUP BY soc_dtac_bienes.codart";
		}
		if($tipsolcot == "S"){
			$cadenaSQL= "SELECT soc_dtac_servicios.codser as codigo,MAX(soc_servicios.denser) as denominacion,  ".
			            "       MAX(rpc_proveedor.nompro) AS nompro,MAX(soc_dtcot_servicio.canser) as cantidad,  ".
			            "       MAX(soc_dtcot_servicio.monuniser) as precio,MAX(soc_dtcot_servicio.moniva) AS moniva,".
						"		MAX(soc_dtcot_servicio.montotser) as monto,MAX(soc_dtac_servicios.obsanacot) AS obsanacot, ".
			            "       MAX(soc_dtsc_servicios.coduniadm) as coduniadm,MAX(soc_dtsc_servicios.codestpro1) as codestpro1,  ".
			            "       MAX(soc_dtsc_servicios.codestpro2) as codestpro2,MAX(soc_dtsc_servicios.codestpro3) as codestpro3,  ".
			            "       MAX(soc_dtsc_servicios.codestpro4) as codestpro4,MAX(soc_dtsc_servicios.codestpro5) as codestpro5,   ".
						" 	    MAX(soc_dtsc_servicios.estcla) as estcla,MAX(soc_sol_cotizacion.codfuefin) as codfuefin, ".
			            "       MAX(soc_dtac_servicios.numcot) AS numcot,MAX(soc_dtac_servicios.cod_pro) AS cod_pro,  ".
			            "       MAX(soc_dtsc_servicios.numsep) AS numsep ".
					   	"FROM soc_dtac_servicios   ".
					   	"INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
					   	"INNER JOIN soc_servicios USING(codemp,codser) ".
					   	"INNER JOIN soc_dtcot_servicio USING(codemp,codser,numcot)".
					   	"INNER JOIN soc_dtsc_servicios USING(codemp,codser)".
						"INNER JOIN soc_cotizacion USING(codemp,numcot,numsolcot)		".	
						"INNER JOIN soc_sol_cotizacion USING(codemp,numsolcot) ".	  
					  	"WHERE soc_dtac_servicios.codemp='{$codemp}' ".
					    "  AND soc_dtac_servicios.numanacot='{$numanacot}' ".
						"  AND soc_dtcot_servicio.cod_pro='{$cod_pro}' ".
						"  AND soc_dtcot_servicio.numcot='{$numcot}'".
					  	"GROUP BY soc_dtac_servicios.codser";	
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	function buscarsiVienedeSep($codemp,$numcot,$cod_pro){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$arreglo = array();
		$valido = true;
		
		$cadenaSQL= "SELECT soc_solcotsep.numsol AS numsol ".
					"FROM soc_solcotsep ".
					"INNER JOIN soc_cotizacion USING(codemp,numsolcot)".
					"WHERE soc_solcotsep.codemp='{$codemp}'".
					"  AND soc_cotizacion.numcot='{$numcot}' ".
					"  AND soc_cotizacion.cod_pro = '{$cod_pro}'";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		$numsol = $data->fields['numsol'];
		$arreglo[0]['numsol'] = $numsol;
		if($numsol==''){
			$valido = false;
		}
		$arreglo[0]['viene_sep'] = $valido;
		return $arreglo;
	}
	
	function obtenercargos($codemp,$codigo,$numsep,$tipsolcot,$subtotal,$numcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		if($tipsolcot=="B"){				
			$cadenaSQL="SELECT moniva".
					"   FROM soc_dtcot_bienes".
					"   WHERE soc_dtcot_bienes.codemp='{$codemp}' ".
					"     AND soc_dtcot_bienes.numcot='{$numcot}'".
					"     AND soc_dtcot_bienes.codart='{$codigo}' ";				
		}
		else{
			$cadenaSQL="SELECT moniva".
					"   FROM soc_dtcot_servicio".
					"   WHERE soc_dtcot_servicio.codemp='{$codemp}' ".
					"     AND soc_dtcot_servicio.numcot='{$numcot}'".
					"     AND soc_dtcot_servicio.codser='{$codigo}' ";				
		}
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return number_format($data->fields['moniva'],2,'.','');
	}
	
	function calculardetallesmontos($codemp,$arrDet,$tipsolcot,$numcot,$tipconpro,$viene_sep){
		$total = count($arrDet);
		$valido = false;
		$moncargo = 0;
		$arreglo = array();
		for($j=0; $j<$total; $j++){
			$codigo=$arrDet[$j]["codigo"];
			$numsep=$arrDet[$j]["numsep"];
			$cantidad=$arrDet[$j]["cantidad"];
			$precio=$arrDet[$j]["precio"];
			$subtotal=($cantidad*$precio);
			if($viene_sep){
				$formula  = $this->loadFormula($codemp,$numsep,$codigo,$tipsolcot);
				$formula  = str_replace("IIF","\$this->iif",$formula);
	  			$formula  = str_replace("\$LD_MONTO",$subtotal,$formula);
	  			$moncargo = @eval("return $formula;");
	  			$valido = true;
			}
			else{
				$moncargo = $this->obtenercargos($codemp,$codigo,$numsep,$tipsolcot,$subtotal,$numcot);
			}
			if($tipconpro == "F"){
				$moncargo=0;
			}
			$montotal=($subtotal+$moncargo);
			$arreglo[$j]["moniva"]=$moncargo;
			$arreglo[$j]["monto"]=$montotal;
		}
		return $arreglo;
	}
	
	function calcularmontos($arrDet){
		$totaldet = count($arrDet);
		$arreglo = array();
		for($j=0; $j<$totaldet; $j++){
			$subtotal += $arrDet[$j]['cantidad']*$arrDet[$j]['precio'];
			$ivatotal += $arrDet[$j]['moniva'];
			$montotal += $arrDet[$j]['monto'];
		}
		$arreglo[0]['subtotal'] = number_format($subtotal,2,'.','');
		$arreglo[0]['ivatotal'] = number_format($ivatotal,2,'.','');  
		$arreglo[0]['montotal'] = number_format($montotal,2,'.','');
		return $arreglo;
	}
	
	function buscarNumOrdCom($codemp,$estcondat){
		$this->daoGeneracionOrdAna = FabricaDao::CrearDAO('N','soc_ordencompra');
		$this->daoGeneracionOrdAna->codemp = $codemp;
		if($estcondat=='B'){
		  $procede="SOCCOC";
		}
		else{
		  $procede="SOCCOS";
		}
		return $this->daoGeneracionOrdAna->buscarCodigo('numordcom',true,15,array(),'SOC',$procede,$_SESSION['la_logusr']);
	}
	
	function buscarDatosSol($codemp,$numanacot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$valido = true;
		$arrDatos = array();
		
		$cadenaSQL = "SELECT soc_sol_cotizacion.uniejeaso,soc_sol_cotizacion.consolcot,".
		             "     	 soc_sol_cotizacion.coduniadm,soc_sol_cotizacion.tipsolbie ".
					 "FROM soc_sol_cotizacion  ".
					 "INNER JOIN soc_analisicotizacion USING(codemp,numsolcot)".
					 "WHERE soc_sol_cotizacion.codemp = '{$codemp}' ".
					 "	AND soc_analisicotizacion.numanacot = '{$numanacot}'";
		
		$datos = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($datos === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			$valido = false;
		}
		$arrDatos[0]['concepto'] = $datos->fields['consolcot'];
		$arrDatos[0]['uniejeaso'] = $datos->fields['uniejeaso'];
		$arrDatos[0]['unidad'] = $datos->fields['coduniadm'];
		$arrDatos[0]['tipbiesolcot'] = $datos->fields['tipsolbie'];
		$arrDatos[0]['valido'] = $valido;
		return $arrDatos;
	}
	
	function buscarNumeroSep($codemp,$numcot,$cod_pro,$numanacot,$tipsolcot,$codigo){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$arrNumSep = array();
		
		if($tipsolcot=='B'){
			$cadenaSQL = "SELECT soc_dtac_bienes.codart as codigo,MAX(siv_articulo.denart) as denominacion, ".
			             "       MAX(rpc_proveedor.nompro) AS nompro, MAX(soc_dtcot_bienes.canart) as cantidad, ".
						 "		 MAX(soc_dtcot_bienes.preuniart) as precio,MAX(soc_dtcot_bienes.moniva) AS moniva,MAX(soc_dtcot_bienes.montotart) as monto,  ".
			             "       MAX(soc_dtac_bienes.obsanacot) AS obsanacot,MAX(soc_dtac_bienes.numcot) AS numcot, ".
			             "       MAX(soc_dtac_bienes.cod_pro) AS cod_pro,soc_dtsc_bienes.numsep AS numsep ".
					   	 "FROM soc_dtac_bienes 	".
					   	 "INNER JOIN rpc_proveedor USING(codemp,cod_pro) ".
					   	 "INNER JOIN siv_articulo USING(codemp,codart)".
					     "INNER JOIN siv_unidadmedida USING(codunimed) ".
					   	 "INNER JOIN soc_dtcot_bienes USING(codemp,codart,numcot) ".
					   	 "INNER JOIN soc_dtsc_bienes USING(codemp,codart) ".
					   	 "INNER JOIN soc_cotizacion USING(codemp,numsolcot)		".		  
					   	 "WHERE soc_dtac_bienes.codemp='{$codemp}' ".
					     "	AND soc_dtac_bienes.numanacot='{$numanacot}' ".
						 "	AND soc_dtcot_bienes.cod_pro='{$cod_pro}' ".
						 " 	AND soc_dtcot_bienes.numcot='{$numcot}'".
						 "	AND soc_dtsc_bienes.codart='{$codigo}'".
					  	 "GROUP BY soc_dtac_bienes.codart,soc_dtsc_bienes.numsep";
		}
		else{
			$cadenaSQL = "SELECT soc_dtac_servicios.codser as codigo,MAX(soc_servicios.denser) as denominacion,  ".
			             "       MAX(rpc_proveedor.nompro) AS nompro, MAX(soc_dtcot_servicio.canser) as cantidad, ".
						 "		 MAX(soc_dtcot_servicio.monuniser) as precio,MAX(soc_dtcot_servicio.moniva) AS moniva,  ".
			             "       MAX(soc_dtcot_servicio.montotser) as monto,MAX(soc_dtac_servicios.obsanacot) AS obsanacot, ".
			             "       MAX(soc_dtac_servicios.numcot) AS numcot, MAX(soc_dtac_servicios.cod_pro) AS cod_pro, ".
			             "       soc_dtsc_servicios.numsep AS numsep ".
					   	 "FROM soc_dtac_servicios 	".
					   	 "INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
					   	 "INNER JOIN soc_servicios USING(codemp,codser)".
					   	 "INNER JOIN soc_dtcot_servicio USING(codemp,codser,numcot)".
					   	 "INNER JOIN soc_dtsc_servicios USING(codemp,codser)".
						 "INNER JOIN soc_cotizacion USING(codemp,numsolcot)	".				  
					  	 "WHERE soc_dtac_servicios.codemp='{$codemp}' ".
					     "	AND soc_dtac_servicios.numanacot='{$numanacot}' ".
						 "	AND soc_dtcot_servicio.cod_pro='{$cod_pro}' ".
						 "	AND soc_dtcot_servicio.numcot='{$numcot}' ".
						 "	AND soc_dtsc_servicios.codser='{$codigo}' ".
						 "GROUP BY soc_dtac_servicios.codser,soc_dtsc_servicios.numsep";
		}
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		$arrDatosSep = object_to_array($data);
		$total = count($arrDatosSep);
		for($k=0;$k<$total;$k++){
			$arrNumSep[$k]['numsep'] = $arrDatosSep[$k]['numsep']; 
		}
		return $arrNumSep; 
	}
		   
	function buscarUniEje($codemp,$unidad,$viene_sep,$arrDet,$numcot,$cod_pro,$tipsolcot,$numanacot,$numsol){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$entro = true;
		$valido = true;
		$cadenaSQL = '';
		$dsunidades = array();
		$arregloUnidades = array();
		
		if($viene_sep){
			$sep = array();
			for($j=0;$j<count($arrDet);$j++){
				$codigo = $arrDet[$j]['codigo'];
				$numsep = $this->buscarNumeroSep($codemp,$numcot,$cod_pro,$numanacot,$tipsolcot,$codigo);
				for($z=0;$z<count($numsep);$z++){
					$sep[$z]['numsep'] = $numsep[$z]['numsep'];
				}
			}
			$sep = array_unique($sep);//se eliminan los repetidos	
			sort($sep);//se reordena la matriz
			for($k=0; $k<count($sep); $k++){
				$numero = $sep[$k]['numsep'];
				$cadenaSQL = "SELECT soc_solcotsep.numsol,soc_solcotsep.codunieje,soc_solcotsep.codestpro1,  ".
				         "           soc_solcotsep.codestpro2,soc_solcotsep.codestpro3,soc_solcotsep.codestpro4,  ".
				         "           soc_solcotsep.codestpro5,soc_solcotsep.estcla,spg_unidadadministrativa.denuniadm,  ".
				         "           soc_sol_cotizacion.consolcot ".
		 				 "	  FROM soc_solcotsep   ".
						 "	  INNER JOIN spg_unidadadministrativa USING(codemp) ".
						 "	  INNER JOIN soc_sol_cotizacion USING(codemp,numsolcot) ".
						 "	  INNER JOIN soc_analisicotizacion USING(codemp) ".
						 "	  WHERE soc_solcotsep.codemp = '{$codemp}' ".
	  					 "		AND soc_analisicotizacion.numanacot = '{$numanacot}' ".
						 "		AND soc_solcotsep.numsol = '{$numero}'"; 
				
				$data = $this->conexionBaseDatos->Execute($cadenaSQL);
				if($data===false){
					$entro=false;
				}
				else{
					$arreglo = object_to_array($data);
					$cantidad = count($arreglo);
					for($i=0;$i<$cantidad;$i++){
						$dsunidades[$i]['codunieje']= $arreglo[$i]['codunieje'];
					    $dsunidades[$i]['codestpro1'] = $arreglo[$i]['codestpro1'];
					    $dsunidades[$i]['codestpro2'] = $arreglo[$i]['codestpro2'];
					    $dsunidades[$i]['codestpro3'] = $arreglo[$i]['codestpro3'];
					    $dsunidades[$i]['codestpro4'] = $arreglo[$i]['codestpro4'];
					    $dsunidades[$i]['codestpro5'] = $arreglo[$i]['codestpro5'];
					    $dsunidades[$i]['estcla']     = $arreglo[$i]['estcla'];
						$dsunidades[$i]['concepto'] =$arreglo[$i]['consolcot'];
					}
				}
			}
			$totalrow = count($dsunidades);
			for($i=0;$i<$cantidad;$i++){
				$l=i+1;
				while($l<$cantidad){
					if($dsunidades[i]['codunieje']!=$dsunidades[l]['codunieje'] && 
					   $dsunidades[i]['codestpro1']!=$dsunidades[l]['codestpro1'] &&
					   $dsunidades[i]['codestpro2']!=$dsunidades[l]['codestpro2'] &&
					   $dsunidades[i]['codestpro3']!=$dsunidades[l]['codestpro3'] &&
					   $dsunidades[i]['codestpro4']!=$dsunidades[l]['codestpro4'] &&
					   $dsunidades[i]['codestpro5']!=$dsunidades[l]['codestpro5'] &&
					   $dsunidades[i]['estcla']!=$dsunidades[l]['estcla']){
						$valido = false;
					}
					$l++;	
				}
			}
			if($valido){
				 $unidad     = $dsunidades[0]['codunieje'];
				 $codestpro1 = $dsunidades[0]['codestpro1'];
				 $codestpro2 = $dsunidades[0]['codestpro2'];
				 $codestpro3 = $dsunidades[0]['codestpro3'];
				 $codestpro4 = $dsunidades[0]['codestpro4'];
				 $codestpro5 = $dsunidades[0]['codestpro5'];
				 $estcla     = $dsunidades[0]['estcla'];
				 $concepto   = $dsunidades[0]['concepto'];
			}
			else{
				$unidad     = "----------";
				$codestpro1 = "-------------------------";
				$codestpro2 = "-------------------------";
				$codestpro3 = "-------------------------";
				$codestpro4 = "-------------------------";
				$codestpro5 = "-------------------------"; 
				$estcla     = "-";
			}
			unset($this->dsunidades);
		}
		else{
			$cadenaSQL = "SELECT soc_sol_cotizacion.coduniadm,soc_sol_cotizacion.codestpro1,  ".
			             "       soc_sol_cotizacion.codestpro2,soc_sol_cotizacion.codestpro3,  ".
			             "       soc_sol_cotizacion.codestpro4,soc_sol_cotizacion.codestpro5,  ".
			             "       soc_sol_cotizacion.estcla,soc_sol_cotizacion.consolcot ".
						 "FROM soc_analisicotizacion ".
						 "INNER JOIN soc_sol_cotizacion USING(codemp,numsolcot)".
						 "WHERE soc_analisicotizacion.codemp = '{$codemp}'".
						 "	AND soc_analisicotizacion.numanacot = '{$numanacot}'";
			
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data===false){
				$entro = false;
			}
			else{
				$unidad = $data->fields['coduniadm'];
				$codestpro1 = $data->fields['codestpro1'];
				$codestpro2 = $data->fields['codestpro2'];
				$codestpro3 = $data->fields['codestpro3'];
				$codestpro4 = $data->fields['codestpro4'];
				$codestpro5 = $data->fields['codestpro5'];
				$estcla = $data->fields['estcla'];
				$concepto = $data->fields['consolcot'];
			}
		}
		$arregloUnidades[0]['unidad'] = $unidad;
		$arregloUnidades[0]['codestpro1'] = $codestpro1;
		$arregloUnidades[0]['codestpro2'] = $codestpro2;
		$arregloUnidades[0]['codestpro3'] = $codestpro3;
		$arregloUnidades[0]['codestpro4'] = $codestpro4;
		$arregloUnidades[0]['codestpro5'] = $codestpro5;
		$arregloUnidades[0]['estcla'] = $estcla;
		$arregloUnidades[0]['concepto'] = $concepto;
		$arregloUnidades[0]['valido'] = $entro;
		return $arregloUnidades;
	}
	
	function buscarDatosEntrega($codemp,$numanacot,$cod_pro){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$arreglo = array();
		
		$cadenaSQL = "SELECT soc_cotizacion.diaentcom,soc_cotizacion.forpagcom ".
				   	 "FROM soc_cotizacion  ".
				   	 "INNER JOIN soc_cotxanalisis USING(codemp,numcot) ".
				  	 "WHERE soc_cotxanalisis.codemp='{$codemp}' ".
				     "	AND soc_cotxanalisis.cod_pro='{$cod_pro}' ".
				     "	AND soc_cotxanalisis.numanacot='{$numanacot}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		$arreglo[0]['diaentcom'] = $data->fields['diaentcom'];
		$arreglo[0]['forpagcom'] = $data->fields['forpagcom'];
 		return $arreglo;
	}
	
	function loadFormula($codemp,$numsep,$codigo,$tipsolcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$sql = '';
		$formula="";
		
		if($tipsolcot=="B"){
			$sql="SELECT formula".
				" FROM sep_dta_cargos".
				" WHERE sep_dta_cargos.codemp='{$codemp}' ".
				"   AND sep_dta_cargos.numsol='{$numsep}'".
				"   AND sep_dta_cargos.codart='{$codigo}' ";
		}
		else{
			$sql="SELECT formula".
				" FROM sep_dts_cargos".
				" WHERE sep_dts_cargos.codemp='{$codemp}' ".
				"   AND sep_dts_cargos.numsol='{$numsep}'".
				"   AND sep_dts_cargos.codser='{$codigo}' ";
		}
		$data = $this->conexionBaseDatos->Execute($sql);
		if($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;	
		}
		else
		{
			$formula = $data->fields['formula'];															
		}
		return $formula;
	}
	
	function selectCargos($codemp,$codigo,$tipo,$posicion){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$sql = '';
		$capiva=$_SESSION["la_empresa"]["capiva"];
		$parcapiva=trim($_SESSION["la_empresa"]["parcapiva"]);
		$cargos=0;
		$valido=false;
		$arreglo = array();
		
		if($tipo=="B"){				
			if($capiva=="1"){
				$sql="SELECT siv_articulo.codart, sigesp_cargos.codcar, sigesp_cargos.dencar, sigesp_cargos.estcla,".
					"		TRIM(siv_articulo.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro ".
					" FROM sigesp_cargos, siv_cargosarticulo,siv_articulo ".
					" WHERE siv_articulo.codemp = '{$codemp}' ".
					"   AND siv_articulo.codart = '{$codigo}' ".
					"   AND siv_articulo.codemp = siv_cargosarticulo.codemp ".
					"   AND siv_articulo.codart = siv_cargosarticulo.codart ".
					"	AND sigesp_cargos.codemp = siv_cargosarticulo.codemp ".
					"   AND sigesp_cargos.codcar = siv_cargosarticulo.codcar ";
				$spg_cuenta=explode(",",$parcapiva);
				$total=count($spg_cuenta);
				for($l=0;$l<$total;$l++){
					if($l==0){
						$sql=$sql."   AND (siv_articulo.spg_cuenta like '".$spg_cuenta[$l]."%'";
					}
					else{
						$sql=$sql."    OR siv_articulo.spg_cuenta like '".$spg_cuenta[$l]."%'";
					}
				}
				if($l>0){
					$sql=$sql." )";
				}
				$data = $this->conexionBaseDatos->Execute($sql);
				if($data===false){
					$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;	
				}
		
			}
			if(($data->EOF)||($capiva!="1")){
				$sql= "SELECT siv_cargosarticulo.codart,siv_cargosarticulo.codcar,  ".
				    "  sigesp_cargos.formula,sigesp_cargos.codestpro,sigesp_cargos.estcla,sigesp_cargos.spg_cuenta ".
					"  FROM siv_cargosarticulo, sigesp_cargos ".
					"  WHERE siv_cargosarticulo.codemp='{$codemp}'  ".
					"    AND siv_cargosarticulo.codart='$codigo'   ".
					"	 AND siv_cargosarticulo.codemp=sigesp_cargos.codemp      ".
					"	 AND siv_cargosarticulo.codcar=sigesp_cargos.codcar";
			}
		}
		else{
			if($capiva=="1"){
				$sql="SELECT soc_servicios.codser , sigesp_cargos.codcar, sigesp_cargos.dencar, sigesp_cargos.estcla,".
				  "	         TRIM(soc_servicios.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro".
				  "   FROM sigesp_cargos, soc_serviciocargo,soc_servicios ".
				  "   WHERE soc_servicios.codemp = '{$codemp}' ".
				  "     AND soc_servicios.codser = '{$codigo}' ".
				  "	    AND soc_servicios.codemp = soc_serviciocargo.codemp ".
				  "     AND soc_servicios.codser = soc_serviciocargo.codser ".
				  "	    AND sigesp_cargos.codemp = soc_serviciocargo.codemp ".
				  "     AND sigesp_cargos.codcar = soc_serviciocargo.codcar ";
				$spg_cuenta=explode(",",$parcapiva);
				$total=count($spg_cuenta);
				for($i=0;$i<$total;$i++){
					if($i==0){
						$sql=$sql."   AND (soc_servicios.spg_cuenta like '".$spg_cuenta[$i]."%'";
					}
					else{
						$sql=$sql."    OR soc_servicios.spg_cuenta like '".$spg_cuenta[$i]."%'";
					}
				
				}
				if($total>0){
					$sql=$sql." )";
				}
				$data = $this->conexionBaseDatos->Execute($sql);
				if($data===false){
					$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;	
				}
			}
			if(($data->EOF)||($capiva!="1")){
				
				$sql= "SELECT soc_serviciocargo.codser,soc_serviciocargo.codcar,sigesp_cargos.formula, ".
				    "         sigesp_cargos.codestpro,sigesp_cargos.estcla,sigesp_cargos.spg_cuenta  ".
					"  FROM soc_serviciocargo, sigesp_cargos   ".
 					"  WHERE soc_serviciocargo.codemp='{$codemp}'  ". 
					"	 AND soc_serviciocargo.codser='{$codigo}'  ".
					"	 AND soc_serviciocargo.codemp=sigesp_cargos.codemp   ".
					"	 AND soc_serviciocargo.codcar=sigesp_cargos.codcar";			
			}
		}
		$data = $this->conexionBaseDatos->Execute($sql);
		if($data===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;	
		}
		else{	
//			if($data->fields['formula']!=''){
				$arreglo[$posicion]["codcar"] = $data->fields['codcar'];
				$arreglo[$posicion]["cuenta_cargo"] = $data->fields['spg_cuenta'];
				$arreglo[$posicion]["formula"] = $data->fields['formula']; 
//			}
//			else{
//				$arreglo[$posicion]["codcar"] = "";
//				$arreglo[$posicion]["cuenta_cargo"] = "";
//				$arreglo[$posicion]["formula"] = "";
//			}	
		}
		return $arreglo;	
	}
	
	function selectBienesServicios($codemp,$tipo,$codigo,$codpro,$numcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$sql = '';
		$arreglo = array();
		
		if($tipo=="B"){
			$sql= "SELECT siv_articulo.spg_cuenta,soc_dtcot_bienes.unidad  ".
				"  FROM siv_articulo,soc_dtcot_bienes  ".
				"  WHERE siv_articulo.codemp='{$codemp}'  ".
				"    AND siv_articulo.codemp=soc_dtcot_bienes.codemp  ".
				"	 AND siv_articulo.codart='{$codigo}'  ". 
				"    AND soc_dtcot_bienes.cod_pro='{$codpro}' ".
				"	 AND soc_dtcot_bienes.numcot='{$numcot}' ".
				"	 AND siv_articulo.codart=soc_dtcot_bienes.codart";				
		}
		else{
			$sql= "SELECT soc_servicios.spg_cuenta  ".
				"  FROM soc_servicios,soc_dtcot_servicio  ".
				"  WHERE soc_servicios.codemp='{$codemp}'  ". 
				"    AND soc_servicios.codemp=soc_dtcot_servicio.codemp  ".
				"	 AND soc_servicios.codser='{$codigo}'  ".
				"	 AND soc_dtcot_servicio.cod_pro='{$codpro}'   ".
				"	 AND soc_dtcot_servicio.numcot='{$numcot}' ".
				"	 AND soc_servicios.codser=soc_dtcot_servicio.codser";	
		}
		$data = $this->conexionBaseDatos->Execute($sql);
		if($data===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;	
		}
		else{
			$spg_cuenta = $data->fields['spg_cuenta'];
			if($tipo=='B'){
				$unidad = $data->fields['unidad'];
				$arreglo[0]['unidad'] = $unidad;
			}
		}
		$arreglo[0]['spg_cuenta'] = $spg_cuenta;
		return $arreglo;
		
	}
	
	function selectCuentasPresupuestarias($codemp,$vienesep,$tipsolcot,$numcot,$codpro,$codigo,$numsep){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$sql = '';
		$valido=false;
		
		if($vienesep){
			if($tipsolcot=="B"){
				$sql="SELECT sep_dt_articulos.spg_cuenta,sep_dt_articulos.codestpro1,sep_dt_articulos.codestpro2,  ".
				   "         sep_dt_articulos.codestpro3,sep_dt_articulos.codestpro4,sep_dt_articulos.codestpro5,  ".
				   "		 sep_dt_articulos.estcla,sep_dt_articulos.canart as cantidad,sep_solicitud.codfuefin as codfuefin ".
				   "  FROM sep_dt_articulos,soc_solcotsep,soc_cotizacion,sep_solicitud  ".
				   "  WHERE sep_dt_articulos.codemp = '{$codemp}'  ".
				   "	AND soc_cotizacion.numcot = '{$numcot}'  ". 
				   "	AND	soc_cotizacion.cod_pro = '{$codpro}'  ". 
				   "	AND sep_dt_articulos.codart = '{$codigo}' ". 
				   "	AND	soc_solcotsep.numsol = '{$numsep}'   ". 
				   "	AND soc_cotizacion.codemp = soc_solcotsep.codemp ".
				   "	AND soc_cotizacion.numsolcot = soc_solcotsep.numsolcot  ". 
				   "	AND soc_solcotsep.codemp = sep_dt_articulos.codemp   ".
				   "	AND soc_solcotsep.numsol = sep_dt_articulos.numsol   ".
				   "	AND sep_solicitud.codemp = sep_dt_articulos.codemp  ".
				   "	AND sep_solicitud.numsol = sep_dt_articulos.numsol";
			}
			else{
				$sql="SELECT sep_dt_servicio.spg_cuenta,sep_dt_servicio.codestpro1,sep_dt_servicio.codestpro2, ". 
					"	     sep_dt_servicio.codestpro3,sep_dt_servicio.codestpro4,sep_dt_servicio.codestpro5,".
					"		 sep_dt_servicio.estcla,sep_dt_servicio.canser as cantidad,sep_solicitud.codfuefin as codfuefin ".
 					" FROM sep_dt_servicio,soc_solcotsep,soc_cotizacion,sep_solicitud   ".
					" WHERE sep_dt_servicio.codemp = '{$codemp}'  ".
					"	    AND soc_cotizacion.numcot = '{$numcot}'   ".
					"		AND	soc_cotizacion.cod_pro = '{$codpro}'  ".
					"		AND sep_dt_servicio.codser = '{$codigo}'  ".
					"		AND soc_solcotsep.numsol = '{$numsep}'   ".
					"		AND soc_cotizacion.codemp = soc_solcotsep.codemp  ".
 					"		AND soc_cotizacion.numsolcot = soc_solcotsep.numsolcot  ". 
					"		AND soc_solcotsep.codemp = sep_dt_servicio.codemp  ".
					"		AND	soc_solcotsep.numsol = sep_dt_servicio.numsol  ".
					"		AND sep_solicitud.codemp = sep_dt_servicio.codemp  ".
					"		AND sep_solicitud.numsol = sep_dt_servicio.numsol";
			}
		}
		else{
			if($tipsolcot=="B"){
				$sql="SELECT siv_articulo.spg_cuenta,spg_dt_unidadadministrativa.codestpro1,  ". 
				" 			 spg_dt_unidadadministrativa.codestpro2,spg_dt_unidadadministrativa.codestpro3, ". 
				"			 spg_dt_unidadadministrativa.codestpro4,spg_dt_unidadadministrativa.codestpro5,  ".
				"			 spg_dt_unidadadministrativa.estcla,soc_sol_cotizacion.codfuefin  ".
				"	  FROM siv_articulo,spg_unidadadministrativa,spg_dt_unidadadministrativa,  ".
				"          soc_sol_cotizacion,soc_cotizacion,soc_dtsc_bienes  ".
				"	  WHERE siv_articulo.codemp = '{$codemp}'   ". 
				"		AND	siv_articulo.codart = '{$codigo}'  ".
				"		AND soc_cotizacion.numcot = '{$numcot}'  ". 
				"		AND soc_cotizacion.cod_pro= '{$codpro}'   ".
				"	    AND siv_articulo.codemp = soc_sol_cotizacion.codemp  ". 
				"		AND siv_articulo.codart = soc_dtsc_bienes.codart  ".
				"		AND soc_cotizacion.codemp = soc_sol_cotizacion.codemp  ". 
				"		AND soc_cotizacion.numsolcot = soc_sol_cotizacion.numsolcot  ". 
				"		AND soc_cotizacion.cod_pro=soc_dtsc_bienes.cod_pro  ".
				"		AND spg_unidadadministrativa.codemp = spg_dt_unidadadministrativa.codemp  ". 
				"		AND spg_unidadadministrativa.coduniadm = spg_dt_unidadadministrativa.coduniadm  ".
				"		AND soc_dtsc_bienes.codemp=soc_sol_cotizacion.codemp   ".
				"		AND soc_dtsc_bienes.numsolcot=soc_sol_cotizacion.numsolcot  ".
				"		AND soc_dtsc_bienes.codemp=spg_dt_unidadadministrativa.codemp   ".
				"		AND soc_dtsc_bienes.coduniadm=spg_dt_unidadadministrativa.coduniadm ".
				"	    AND soc_dtsc_bienes.codestpro1=spg_dt_unidadadministrativa.codestpro1  ".
				"		AND soc_dtsc_bienes.codestpro2=spg_dt_unidadadministrativa.codestpro2  ".
				"		AND soc_dtsc_bienes.codestpro3=spg_dt_unidadadministrativa.codestpro3  ".
				"		AND soc_dtsc_bienes.codestpro4=spg_dt_unidadadministrativa.codestpro4  ".
				"		AND soc_dtsc_bienes.codestpro5=spg_dt_unidadadministrativa.codestpro5  ".
				"		AND soc_dtsc_bienes.estcla=spg_dt_unidadadministrativa.estcla";
			}
			else{
				$sql="SELECT soc_servicios.spg_cuenta,spg_dt_unidadadministrativa.codestpro1,  ". 
					"		 spg_dt_unidadadministrativa.codestpro2,spg_dt_unidadadministrativa.codestpro3, ".
					"		 spg_dt_unidadadministrativa.codestpro4,spg_dt_unidadadministrativa.codestpro5,  ".
					"		 spg_dt_unidadadministrativa.estcla,soc_sol_cotizacion.codfuefin ".
					" FROM soc_servicios,spg_unidadadministrativa,spg_dt_unidadadministrativa,  ".
				    "      soc_sol_cotizacion,soc_cotizacion,soc_dtsc_servicios  ".
					" WHERE soc_servicios.codemp = '{$codemp}' ". 
					"   AND soc_servicios.codser = '{$codigo}'   ". 
					"   AND	soc_cotizacion.numcot = '{$numcot}'  ". 
					"	AND soc_cotizacion.cod_pro= '{$codpro}'  ".
					"	AND soc_servicios.codemp = soc_sol_cotizacion.codemp ".
					"	AND soc_servicios.codser = soc_dtsc_servicios.codser  ".
					"	AND soc_cotizacion.codemp = soc_sol_cotizacion.codemp ".
					"	AND soc_cotizacion.numsolcot = soc_sol_cotizacion.numsolcot  ". 
					"	AND soc_cotizacion.cod_pro=soc_dtsc_servicios.cod_pro  ".
					"	AND spg_unidadadministrativa.codemp = spg_dt_unidadadministrativa.codemp  ". 
					"	AND spg_unidadadministrativa.coduniadm = spg_dt_unidadadministrativa.coduniadm  ".
					"	AND soc_dtsc_servicios.codemp=soc_sol_cotizacion.codemp   ".
					"	AND soc_dtsc_servicios.numsolcot=soc_sol_cotizacion.numsolcot  ".
					"	AND soc_dtsc_servicios.codemp=spg_dt_unidadadministrativa.codemp ".
					"	AND soc_dtsc_servicios.coduniadm=spg_dt_unidadadministrativa.coduniadm  ".
					"	AND soc_dtsc_servicios.codestpro1=spg_dt_unidadadministrativa.codestpro1  ".
					"	AND soc_dtsc_servicios.codestpro2=spg_dt_unidadadministrativa.codestpro2  ".
					"	AND soc_dtsc_servicios.codestpro3=spg_dt_unidadadministrativa.codestpro3  ".
					"	AND soc_dtsc_servicios.codestpro4=spg_dt_unidadadministrativa.codestpro4  ".
					"	AND soc_dtsc_servicios.codestpro5=spg_dt_unidadadministrativa.codestpro5  ".
					"	AND soc_dtsc_servicios.estcla=spg_dt_unidadadministrativa.estcla";  
			}
		}
		$data=$this->conexionBaseDatos->Execute($sql);
		if($data===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;	
		}
		$arreglo = object_to_array($data);
		return $arreglo;
	}
	
	function select_cuentacontable($codemp,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$cuenta,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "SELECT sc_cuenta ".
				"  	  FROM spg_cuentas ".
				" 	  WHERE codemp='{$codemp}' ".
				"   	AND codestpro1='{$codestpro1}' ".
				"   	AND codestpro2='{$codestpro2}' ".
				"  		AND codestpro3='{$codestpro3}' ".
				"  		AND codestpro4='{$codestpro4}' ".
				"   	AND codestpro5='{$codestpro5}' ".
				"   	AND estcla= '{$estcla}'".
				"	   	AND spg_cuenta='{$cuenta}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['sc_cuenta'];
	}
	
	function insertarBienes($codemp,$arrDet,$tipsolcot,$codpro,$numcot,$tipconpro,$numordcom,$viene_sep){
		$valido = true;
		$monimp = 0;
		$formula = '';
		$arreglo = array();
		for($i=0;($i<count($arrDet))&&($valido);$i++){
			$numsep = $arrDet[$i]["numsep"];
			$codigo = $arrDet[$i]["codigo"];
			$denominacion = $arrDet[$i]["denominacion"];
			$cantidad = $arrDet[$i]["cantidad"];
			$precio = $arrDet[$i]["precio"];
			$monsubtotal= ($arrDet[$i]["precio"])*($arrDet[$i]["cantidad"]);
			if($numsep=='0'){
				$formula = $this->loadFormula($codemp,$numsep,$codigo,$tipsolcot);
				if($formula==""){
					$arrCargos = $this->selectCargos($codemp,$codigo,"B",$i);
					$formula = $arrCargos[$i]["formula"];
					if($formula!=""){
						$arreglo[$i]["codcar"] = $arrCargos[$i]["codcar"];
						$arreglo[$i]["cuenta_cargo"] = $arrCargos[$i]["cuenta_cargo"];
						$arreglo[$i]["formula"] = $arrCargos[$i]["formula"];
						$formula = str_replace("IIF","\$this->iif",$formula);
	  					$formula = str_replace("\$LD_MONTO",$monsubtotal,$formula);
	  					$monimp = @eval("return $formula;");	
					}	
				}
			 	if($tipconpro!="F"){
			 		$montotal=number_format($monsubtotal+$monimp,2,'.','');
                }
                else{
                    $montotal=number_format($monsubtotal,2,'.','');    
                }
			}
			else{
				$montotal = number_format($arrDet[$i]["monto"],2,'.','');
				$monimp   = number_format($arrDet[$i]["moniva"],2,'.','');
			}
			$codunieje  = trim($arrDet[$i]["coduniadm"]);
			$codestpro1 = trim($arrDet[$i]["codestpro1"]);
			$codestpro2 = trim($arrDet[$i]["codestpro2"]);
			$codestpro3 = trim($arrDet[$i]["codestpro3"]);
			$codestpro4 = trim($arrDet[$i]["codestpro4"]);
			$codestpro5 = trim($arrDet[$i]["codestpro5"]);
			$estcla     = trim($arrDet[$i]["estcla"]);
			$codfuefin  = trim($arrDet[$i]["codfuefin"]);
			$unidad = $spg_cuenta = "";
			$arregloDatos = $this->selectBienesServicios($codemp,'B',$codigo,$codpro,$numcot);
			$spg_cuenta = $arregloDatos[0]["spg_cuenta"];
			$unidad =  $arregloDatos[0]["unidad"];
			$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dt_bienes");
			$this->daoDetalle->codemp = $codemp;
			$this->daoDetalle->numordcom = $numordcom;
			$this->daoDetalle->estcondat = 'B';
			$this->daoDetalle->codart = $codigo;
			$this->daoDetalle->unidad = $unidad;
			$this->daoDetalle->canart = $cantidad;
			$this->daoDetalle->penart = 0;
			$this->daoDetalle->preuniart = $precio;
			$this->daoDetalle->monsubart = $monsubtotal;
			$this->daoDetalle->montotart = $montotal;
			$this->daoDetalle->orden = $i;
			$this->daoDetalle->numsol = $numsep;
			$this->daoDetalle->coduniadm = $codunieje;
			$this->daoDetalle->codestpro1 = $codestpro1;
			$this->daoDetalle->codestpro2 = $codestpro2;
			$this->daoDetalle->codestpro3 = $codestpro3;
			$this->daoDetalle->codestpro4 = $codestpro4;
			$this->daoDetalle->codestpro5 = $codestpro5;
			$this->daoDetalle->estcla = $estcla;
			$this->daoDetalle->codfuefin = $codfuefin;
			if(!$this->daoDetalle->incluir()){
				break;
			}
			if($tipconpro!="F"){
				if($formula!=""){
					$this->daoDetalleCargos = FabricaDao::CrearDAO("N","soc_dta_cargos");
					$this->daoDetalleCargos->codemp = $codemp;
					$this->daoDetalleCargos->numordcom = $numordcom;
					$this->daoDetalleCargos->estcondat = 'B';
					$this->daoDetalleCargos->codart = $codigo;
					$this->daoDetalleCargos->numsol = $numsep;
					$this->daoDetalleCargos->codcar = $arreglo[$i]["codcar"];
					$this->daoDetalleCargos->formula = $arreglo[$i]["formula"];
					$this->daoDetalleCargos->codestpro1 = $codestpro1;
					$this->daoDetalleCargos->codestpro2 = $codestpro2;
					$this->daoDetalleCargos->codestpro3 = $codestpro3;
					$this->daoDetalleCargos->codestpro4 = $codestpro4;
					$this->daoDetalleCargos->codestpro5 = $codestpro5;
					$this->daoDetalleCargos->estcla = $estcla;
					$this->daoDetalleCargos->codfuefin = $codfuefin;
					$this->daoDetalleCargos->monbasimp = $monsubtotal; 
					$this->daoDetalleCargos->monimp = $monimp;
					$this->daoDetalleCargos->monto = $montotal;
					if(!$this->daoDetalleCargos->incluir()){
						break;
					}	
				}
			}
			if($viene_sep){
				$str = "codemp='{$codemp}'";
				$str .= " AND numsol='{$numsep}'";
				$str .= " AND codart='{$codigo}'";
				$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_articulos',null,$str);
				$this->daoCambioEstatusItemSep->estincite='OC';
				$this->daoCambioEstatusItemSep->numdocdes=$numordcom;
		 	    if($this->daoCambioEstatusItemSep->modificar()==0){
				  	break;
				}
			}
			$monimp=0;
		}
		return $arreglo;
	}
	
	function insertarServicios($codemp,$arrDet,$tipsolcot,$codpro,$numcot,$tipconpro,$numordcom,$viene_sep){
		$valido = true;
		$monimp = 0;
		$formula = '';
		$arreglo = array();
		for($i=0;($i<count($arrDet))&&($valido);$i++){
			$numsep = $arrDet[$i]["numsep"];
			$codigo = $arrDet[$i]["codigo"];
			$denominacion = $arrDet[$i]["denominacion"];
			$cantidad = $arrDet[$i]["cantidad"];
			$precio = $arrDet[$i]["precio"];
			$monsubtotal= ($arrDet[$i]["precio"])*($arrDet[$i]["cantidad"]);
			if($numsep=='0'){
				$formula = $this->loadFormula($codemp,$numsep,$codigo,$tipsolcot);
				if($formula==""){
					$arrCargos = $this->selectCargos($codemp,$codigo,"S",$i);
					$formula = $arrCargos[$i]["formula"];
					if($formula!=""){
						$arreglo[$i]["codcar"] = $arrCargos[$i]["codcar"];
						$arreglo[$i]["cuenta_cargo"] = $arrCargos[$i]["cuenta_cargo"];
						$arreglo[$i]["formula"] = $arrCargos[$i]["formula"];
						$formula  = str_replace("IIF","\$this->iif",$formula);
	  					$formula  = str_replace("\$LD_MONTO",$monsubtotal,$formula);
	  					$monimp = @eval("return $formula;");	
					}		
				}
			 	if($tipconpro!="F"){
			 		$montotal=number_format($monsubtotal+$monimp,2,'.','');
                }
                else{
                	$monimp=number_format($monimp,2,'.','');
                	$montotal=number_format($monsubtotal,2,'.',''); 
                }
			}
			else{
				$montotal = $arrDet[$i]["monto"];
				$monimp   = $arrDet[$i]["moniva"];
			}
			$codunieje  = trim($arrDet[$i]["coduniadm"]);
			$codestpro1 = trim($arrDet[$i]["codestpro1"]);
			$codestpro2 = trim($arrDet[$i]["codestpro2"]);
			$codestpro3 = trim($arrDet[$i]["codestpro3"]);
			$codestpro4 = trim($arrDet[$i]["codestpro4"]);
			$codestpro5 = trim($arrDet[$i]["codestpro5"]);
			$estcla     = trim($arrDet[$i]["estcla"]);
			$codfuefin  = trim($arrDet[$i]["codfuefin"]);
			$spg_cuenta = "";
			$arregloDatos = $this->selectBienesServicios($codemp,'S',$codigo,$codpro,$numcot);
			$spg_cuenta = $arregloDatos[0]["spg_cuenta"];
			$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dt_servicio");
			$this->daoDetalle->codemp = $codemp;
			$this->daoDetalle->numordcom = $numordcom;
			$this->daoDetalle->estcondat = 'S';
			$this->daoDetalle->codser = $codigo;
			$this->daoDetalle->canser = $cantidad;
			$this->daoDetalle->monuniser = $precio;
			$this->daoDetalle->monsubser = $monsubtotal;
			$this->daoDetalle->montotser = $montotal;
			$this->daoDetalle->orden = $i;
			$this->daoDetalle->numsol = $numsep;
			$this->daoDetalle->coduniadm = $codunieje;
			$this->daoDetalle->codestpro1 = $codestpro1;
			$this->daoDetalle->codestpro2 = $codestpro2;
			$this->daoDetalle->codestpro3 = $codestpro3;
			$this->daoDetalle->codestpro4 = $codestpro4;
			$this->daoDetalle->codestpro5 = $codestpro5;
			$this->daoDetalle->estcla = $estcla;
			$this->daoDetalle->codfuefin = $codfuefin;
			if(!$this->daoDetalle->incluir()){
				break;
			}
			if($viene_sep){
				$str = "codemp='{$codemp}'";
				$str .= " AND numsol='{$numsep}'";
				$str .= " AND codser='{$codigo}'";
				$this->daoCambioEstatusItemSep = FabricaDao::CrearDAO('C','sep_dt_servicio',null,$str);
				$this->daoCambioEstatusItemSep->estincite='OC';
				$this->daoCambioEstatusItemSep->numdocdes=$numordcom;
		 	    if($this->daoCambioEstatusItemSep->modificar()==0){
				  	break;
				}
			}
			if($tipconpro!="F"){
				if($formula!=""){
					$this->daoDetalleCargos = FabricaDao::CrearDAO("N","soc_dts_cargos");
					$this->daoDetalleCargos->codemp = $codemp;
					$this->daoDetalleCargos->numordcom = $numordcom;
					$this->daoDetalleCargos->estcondat = 'S';
					$this->daoDetalleCargos->codser = $codigo;
					$this->daoDetalleCargos->numsol = $numsep;
					$this->daoDetalleCargos->codcar = $arreglo[$i]["codcar"];
					$this->daoDetalleCargos->formula = $arreglo[$i]["formula"];
					$this->daoDetalleCargos->codestpro1 = $codestpro1;
					$this->daoDetalleCargos->codestpro2 = $codestpro2;
					$this->daoDetalleCargos->codestpro3 = $codestpro3;
					$this->daoDetalleCargos->codestpro4 = $codestpro4;
					$this->daoDetalleCargos->codestpro5 = $codestpro5;
					$this->daoDetalleCargos->estcla = $estcla;
					$this->daoDetalleCargos->codfuefin = $codfuefin;
					$this->daoDetalleCargos->monbasimp = $monsubtotal; 
					$this->daoDetalleCargos->monimp = $monimp;
					$this->daoDetalleCargos->monto = $montotal;
					if(!$this->daoDetalleCargos->incluir()){
						break;
					}
				}
			}
			$monimp=0;
		}
		return $arreglo;
	}
	
	function insertarCuentas($codemp,$numcot,$arrDet,$vienesep,$tipsolcot,$codpro,$numordcom){
		$total = count($arrDet);  
		$cuentas = array();
		for($j=0; $j<$total; $j++){
			$codigo  = $arrDet[$j]["codigo"];
			$numsep  = $arrDet[$j]["numsep"];	
			$cantidad = $arrDet[$j]["cantidad"];
			$precio = $arrDet[$j]["precio"];
			$subtotal = $cantidad*$precio;
			$data = $this->selectCuentasPresupuestarias($codemp,$vienesep,$tipsolcot,$numcot,$codpro,$codigo,$numsep);
			$cuentas[$j]["spg_cuenta"]=$data[0]["spg_cuenta"];
			$cuentas[$j]["codestpro1"]=$data[0]["codestpro1"];
			$cuentas[$j]["codestpro2"]=$data[0]["codestpro2"];
			$cuentas[$j]["codestpro3"]=$data[0]["codestpro3"];
			$cuentas[$j]["codestpro4"]=$data[0]["codestpro4"];
			$cuentas[$j]["codestpro5"]=$data[0]["codestpro5"];
			$cuentas[$j]["estcla"]=$data[0]["estcla"];
			$cuentas[$j]["codfuefin"]=$data[0]["codfuefin"];	 
			$cuentas[$j]["monto"]=$subtotal;
			$cuentas[$j]["insertar"]='S';
		}
		$totalcuentas = count($cuentas);
		for($i=0; $i<$totalcuentas; $i++){
			$l=$i+1;
			while($l<$totalcuentas){
				if($cuentas[$i]["spg_cuenta"]==$cuentas[$l]["spg_cuenta"]){
					$monto = $cuentas[$i]["monto"];
					$montoaux = $cuentas[$l]["monto"];
					$suma = $monto+$montoaux;
					$cuentas[$i]["monto"]=$suma;
					$cuentas[$l]["insertar"]='N';
				}
				$l++;
			}
			if($cuentas[$i]["insertar"]=='S'){
				$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","soc_cuentagasto");
				$this->daoDetalleCuenta->codemp = $codemp;
				$this->daoDetalleCuenta->numordcom = $numordcom;
				$this->daoDetalleCuenta->estcondat = $tipsolcot;
				$this->daoDetalleCuenta->codestpro1 = $cuentas[$i]["codestpro1"];
				$this->daoDetalleCuenta->codestpro2 = $cuentas[$i]["codestpro2"];
				$this->daoDetalleCuenta->codestpro3 = $cuentas[$i]["codestpro3"];
				$this->daoDetalleCuenta->codestpro4 = $cuentas[$i]["codestpro4"];
				$this->daoDetalleCuenta->codestpro5 = $cuentas[$i]["codestpro5"];
				$this->daoDetalleCuenta->estcla = $cuentas[$i]["estcla"];
				$this->daoDetalleCuenta->codfuefin = $cuentas[$i]["codfuefin"];
				$this->daoDetalleCuenta->spg_cuenta = $cuentas[$i]["spg_cuenta"];
				$this->daoDetalleCuenta->monto = $cuentas[$i]["monto"];
				if(!$this->daoDetalleCuenta->incluir()){
					break;
				}
			}
		}
	}
	
	function insertarCuentasCargos($codemp,$arrDet,$numordcom,$tipsolcot,$tipconpro){
		$total = count($arrDet);
		$arrDet[0]["insertar"]='S';
		for($i=0; $i<$total; $i++){
			$l=$i+1;
			if($arrDet[$i]["codcar"]!=''){
				$arrDet[$i]["monobjret"] = $arrDet[$i]["cantidad"]*$arrDet[$i]["precio"];
				$formula  = str_replace("IIF","\$this->iif",$arrDet[$i]["formula"]);
			  	$formula  = str_replace("\$LD_MONTO",$arrDet[$i]["cantidad"]*$arrDet[$i]["precio"],$formula);
			  	$monimpuno = @eval("return $formula;");
			  	$arrDet[$i]["montocargo"] = $monimpuno;
				while($l<$total){
					if($arrDet[$l]["codcar"]!=''){
						if($arrDet[$i]["cuenta_cargo"]==$arrDet[$l]["cuenta_cargo"] && 
						   $arrDet[$i]["codcar"]==$arrDet[$l]["codcar"]){
						   	$form  = str_replace("IIF","\$this->iif",$arrDet[$l]["formula"]);
			  				$form  = str_replace("\$LD_MONTO",$arrDet[$l]["cantidad"]*$arrDet[$l]["precio"],$form);
			  				$monimpdos = @eval("return $form;");
			  				$sumaimp = $monimpuno+$monimpdos;
			  				$arrDet[$i]["montocargo"]=$sumaimp;
			  				$monsubuno = $arrDet[$i]["monobjret"];
			  				$monsubdos = $arrDet[$l]["cantidad"]*$arrDet[$l]["precio"];
			  				$sumasub = $monsubuno+$monsubdos;
			  				$arrDet[$i]["monobjret"]=$sumasub;
							$arrDet[$l]["insertar"]='N';
						}	
					}
					else{
						$arrDet[$l]["insertar"]='S';
					}
					$l++;
				}
				if($tipconpro!="F"){
					if($arrDet[$i]["codcar"]!=''){
						if($arrDet[$i]["insertar"]=='S'){
							$this->daoDetalleCargo = FabricaDao::CrearDAO("N","soc_solicitudcargos");
							$this->daoDetalleCargo->codemp = $codemp;
							$this->daoDetalleCargo->numordcom = $numordcom;
							$this->daoDetalleCargo->estcondat = $tipsolcot;
							$this->daoDetalleCargo->codcar = $arrDet[$i]["codcar"];
							$this->daoDetalleCargo->codestpro1 = $arrDet[$i]["codestpro1"];
							$this->daoDetalleCargo->codestpro2 = $arrDet[$i]["codestpro2"];
							$this->daoDetalleCargo->codestpro3 = $arrDet[$i]["codestpro3"];
							$this->daoDetalleCargo->codestpro4 = $arrDet[$i]["codestpro4"];
							$this->daoDetalleCargo->codestpro5 = $arrDet[$i]["codestpro5"];
							$this->daoDetalleCargo->estcla = $arrDet[$i]["estcla"];
							$this->daoDetalleCargo->codfuefin = $arrDet[$i]["codfuefin"];
							$this->daoDetalleCargo->spg_cuenta = $arrDet[$i]["cuenta_cargo"];
							$this->daoDetalleCargo->numsol = $arrDet[$i]["numsep"];
							$this->daoDetalleCargo->formula = $arrDet[$i]["formula"];
							$this->daoDetalleCargo->monret = $arrDet[$i]["montocargo"];
							$this->daoDetalleCargo->monobjret = $arrDet[$i]["monobjret"];
							$this->daoDetalleCargo->monto = $arrDet[$i]["montocargo"];
							$this->daoDetalleCargo->sc_cuenta = $this->select_cuentacontable($codemp,$arrDet[$i]["codestpro1"],
																							 $arrDet[$i]["codestpro2"],$arrDet[$i]["codestpro3"],
																							 $arrDet[$i]["codestpro4"],$arrDet[$i]["codestpro5"],
																							 $arrDet[$i]["cuenta_cargo"],$arrDet[$i]["estcla"]);
							if(!$this->daoDetalleCargo->incluir()){
								break;
							}
						}	
					}	
				}
			}
		}
	}
	
	function insertarOrdCom($codemp,$numanacot,$cod_pro,$numordcom,$tipsolcot,$cod_pro,$concepto,
						   $subtotal,$ivatotal,$montotal,$coduniadm,$codestpro1,$codestpro2,
						   $codestpro3,$codestpro4,$codestpro5,$estcla,$uniejeaso,$tipbiesolcot,
						   $viene_sep,$numsol,$arrDet,$numcot,$tipconpro){
		$resultado = 0;//variable que indica el resultado de la operacion   
		$fecha = date("Y-m-d");
		$diaentcom = '';
		$forpagcom = '';
		$arrevento  = array();
		DaoGenerico::iniciarTrans();
		
		$arrevento ['codemp']  = $codemp;
		$arrevento ['codusu']  = $_SESSION['la_logusr'];
		$arrevento ['codmenu'] = $_SESSION['codmenu'];
		$arrevento ['codsis']  = 'SOC';
		$arrevento ['evento']  = 'INSERT';
		$arrevento ['nomven']  = 'sigesp_vis_soc_generar_orden_analisis.html';
		$arrevento ['desevetra'] = 'Inserto la orden de compra con el numero'.$numordcom.', asociado a la empresa '.$codemp;
			
		$arrDatos = $this->buscarDatosEntrega($codemp,$numanacot,$cod_pro);
		$diaentcom = $arrDatos[0]['$diaentcom'];
		$forpagcom = $arrDatos[0]['forpagcom'];
		
		//obteniendo las instacias de los dao's
		$this->daoOrdenCompra = FabricaDao::CrearDAO("N","soc_ordencompra");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoOrdenCompra->codemp = $codemp;
		$this->daoOrdenCompra->numordcom = $numordcom;
		$this->daoOrdenCompra->estcondat = $tipsolcot;
		$this->daoOrdenCompra->cod_pro = $cod_pro;
		$this->daoOrdenCompra->codmon = '---';
		$this->daoOrdenCompra->codfuefin = '--';
		$this->daoOrdenCompra->fecordcom = $fecha;
		$this->daoOrdenCompra->estsegcom = 0;
		$this->daoOrdenCompra->porsegcom = 0;
		$this->daoOrdenCompra->monsegcom = 0;
		$this->daoOrdenCompra->forpagcom = $forpagcom;
		$this->daoOrdenCompra->estcom = 0;
		$this->daoOrdenCompra->diaplacom = $diaentcom;
		$this->daoOrdenCompra->concom = '-';
		$this->daoOrdenCompra->obscom = $concepto;
		$this->daoOrdenCompra->monsubtotbie = 0;
		$this->daoOrdenCompra->monsubtotser = 0;
		$this->daoOrdenCompra->monsubtot = formatoNumericoBd($subtotal);
		$this->daoOrdenCompra->monbasimp = 0;
		$this->daoOrdenCompra->monimp = formatoNumericoBd($ivatotal);
		$this->daoOrdenCompra->mondes = 0;
		$this->daoOrdenCompra->montot = formatoNumericoBd($montotal);
		$this->daoOrdenCompra->estpenalm = 0;
		$this->daoOrdenCompra->codpai = '---';
		$this->daoOrdenCompra->codest = '---';
		$this->daoOrdenCompra->codpar = '---';
		$this->daoOrdenCompra->codmun = '---';
		$this->daoOrdenCompra->lugentnomdep = '';
		$this->daoOrdenCompra->lugentdir = '';
		$this->daoOrdenCompra->monant = 0;
		$this->daoOrdenCompra->estlugcom = 0;
		$this->daoOrdenCompra->tascamordcom = 0;
		$this->daoOrdenCompra->montotdiv = 0;
		$this->daoOrdenCompra->estapro = 0;
		$this->daoOrdenCompra->fecaprord = '1900-01-01';
		$this->daoOrdenCompra->numpolcon = 0;
		$this->daoOrdenCompra->coduniadm = $coduniadm;
		$this->daoOrdenCompra->codestpro1 = $codestpro1;
		$this->daoOrdenCompra->codestpro2 = $codestpro2;
		$this->daoOrdenCompra->codestpro3 = $codestpro3;
		$this->daoOrdenCompra->codestpro4 = $codestpro4;
		$this->daoOrdenCompra->codestpro5 = $codestpro5;
		$this->daoOrdenCompra->estcla = $estcla;
		$this->daoOrdenCompra->obsordcom = '';
		$this->daoOrdenCompra->codusureg = $_SESSION['la_logusr'];
		$this->daoOrdenCompra->fecent = '1900-01-01';
		$this->daoOrdenCompra->numanacot = $numanacot;
		$this->daoOrdenCompra->codtipmod = '--';
		$this->daoOrdenCompra->uniejeaso = $uniejeaso;
		$this->daoOrdenCompra->tipbieordcom = $tipbiesolcot;
		$this->daoOrdenCompra->fechentdesde = $fecha;
		$this->daoOrdenCompra->fechenthasta = $fecha;
		
		$resultado = $this->daoOrdenCompra->incluir(true,"numordcom",true,15);
		$arrcadres = explode(",",$resultado);
		//insertando el registro y escribiendo en el log
		
		if($arrcadres[0]==1||$arrcadres[0]==-1){
			if($arrcadres[0]==-1){
				$numordcom = $arrcadres[1];
			}
			if($viene_sep){
				$this->daoDetalleSEP = FabricaDao::CrearDAO("N","soc_enlace_sep");
				$this->daoDetalleSEP->codemp = $codemp;
				$this->daoDetalleSEP->numordcom = $numordcom;
				$this->daoDetalleSEP->estcondat = $tipsolcot;
				$this->daoDetalleSEP->numsol = $numsol;
				$this->daoDetalleSEP->coduniadm = $coduniadm;
				$this->daoDetalleSEP->codestpro1 = $codestpro1;
				$this->daoDetalleSEP->codestpro2 = $codestpro2;
				$this->daoDetalleSEP->codestpro3 = $codestpro3;
				$this->daoDetalleSEP->codestpro4 = $codestpro4;
				$this->daoDetalleSEP->codestpro5 = $codestpro5;
				$this->daoDetalleSEP->estcla = $estcla;
				$this->daoDetalleSEP->codfuefin = "--";
				if(!$this->daoDetalleSEP->incluir()){
					break;
				}
				$strPK = "codemp='{$codemp}'";
				$strPK = "numsol='$numsol'";
				$this->daoCambioEstatusSep = FabricaDao::CrearDAO('C','sep_solicitud',null,$strPK);
				$this->daoCambioEstatusSep->estsol = 'P';
				if($this->daoCambioEstatusSep->modificar()==0){
					break;
				}
			}
			if($tipsolcot=='B'){
				$data = $this->insertarBienes($codemp,$arrDet,'B',$cod_pro,$numcot,$tipconpro,$numordcom,$viene_sep);
				$total = count($arrDet);
				for($i=0;$i<$total;$i++){
					$arrDet[$i]["codcar"] = $data[$i]["codcar"];
					$arrDet[$i]["cuenta_cargo"] = $data[$i]["cuenta_cargo"];
					$arrDet[$i]["formula"] = $data[$i]["formula"];	
				}
			}
			if($tipsolcot=='S'){
				$data = $this->insertarServicios($codemp,$arrDet,'S',$cod_pro,$numcot,$tipconpro,$numordcom,$viene_sep);
				for($i=0;$i<count($arrDet);$i++){
					$arrDet[$i]["codcar"] = $data[$i]["codcar"];
					$arrDet[$i]["cuenta_cargo"] = $data[$i]["cuenta_cargo"];
					$arrDet[$i]["formula"] = $data[$i]["formula"];	
				}
			}
			$this->insertarCuentas($codemp,$numcot,$arrDet,$viene_sep,$tipsolcot,$cod_pro,$numordcom);
			$this->insertarCuentasCargos($codemp,$arrDet,$numordcom,$tipsolcot,$tipconpro);
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
			
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans()) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				return "1"; 		
			}
			else{
				$arrevento ['desevetra'] = $this->daoOrdenCompra->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				return "0";
			}
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoOrdenCompra);
			unset($this->daoRegistroEvento);
		}
		else{
			return "0";	
		}
	}
	
	public function generarOrdCom($codemp,$objson){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arrDetAnaCot = $objson->arrAnalisisCotizacion;
		$total = count($arrDetAnaCot);
		$resultado = 0;
		
		foreach($arrDetAnaCot as $detalle){
			$numanacot = $detalle->numanacot;
			$tipsolcot = $detalle->tipsolcot;
			$obsana = $detalle->obsana;
			$data = $this->buscarCotAna($codemp,$numanacot,$tipsolcot);
			$total = $data->_numOfRows;
			$arreglo = array();
			$arreglo = object_to_array($data);
			for($i=0; $i<$total; $i++){
				$validamonto=false;
				$valido=false;
				$numordcom = 0;
				$numcot = $arreglo[$i]['numcot'];
				$cod_pro = $arreglo[$i]['cod_pro'];
				$tipconpro = $arreglo[$i]['tipconpro'];
				$dataDet =  $this->buscarDetallesCotizacion($codemp,$cod_pro,$numcot,$numanacot,$tipsolcot);
				$arrDet = array();
				$arrDet = object_to_array($dataDet);
				$viene_sep = false;
				$numsol = 0;
				$arreglosep = $this->buscarsiVienedeSep($codemp,$numcot,$cod_pro);
				$numsol = $arreglosep[0]['numsol'];
				$viene_sep = $arreglosep[0]['viene_sep'];
				$subtotal = 0;
				$ivatotal = 0;
				$montotal = 0;
				$montos = $this->calculardetallesmontos($codemp,$arrDet,$tipsolcot,$numcot,$tipconpro,$viene_sep);
				for($k=0;$k<count($arrDet);$k++){
					$arrDet[$k]["moniva"] = $montos[$k]["moniva"];
					$arrDet[$k]["monto"] = $montos[$k]["monto"];	
				}
				$arreglomontos = $this->calcularmontos($arrDet);
				$subtotal = $arreglomontos[0]['subtotal'];
				$ivatotal = $arreglomontos[0]['ivatotal'];
				$montotal = $arreglomontos[0]['montotal'];
				if($subtotal>0 && $montotal>0){
					$validamonto=true;
				}
				if($validamonto){
					$numordcom = $this->buscarNumOrdCom($codemp,$tipsolcot);
					$concepto = $uniejeaso = $unidad = $tipbiesolcot = "";
					$arregloDatos = $this->buscarDatosSol($codemp,$numanacot);
					$concepto = $arregloDatos[0]['concepto'];
					$uniejeaso = $arregloDatos[0]['uniejeaso'];
					$unidad = $arregloDatos[0]['unidad'];
					$tipbiesolcot = $arregloDatos[0]['tipbiesolcot']; 
					$valido = $arregloDatos[0]['valido'];
					if($valido){
						$codestpro1 = $codestpro2 = $codestpro3 = $codestpro4 = $codestpro5 = $estcla = $concepto = "";
						$arrUnidades = $this->buscarUniEje($codemp,$unidad,$viene_sep,$arrDet,$numcot,$cod_pro,
														   $tipsolcot,$numanacot,$numsol);
					    $codestpro1 = $arrUnidades[0]['codestpro1'];
					    $codestpro2 = $arrUnidades[0]['codestpro2'];
					    $codestpro3 = $arrUnidades[0]['codestpro3'];
					    $codestpro4 = $arrUnidades[0]['codestpro4'];
					    $codestpro5 = $arrUnidades[0]['codestpro5'];
					    $estcla     = $arrUnidades[0]['estcla'];
					    $concepto   = $arrUnidades[0]['concepto'];
					    $unidad     = $arrUnidades[0]['unidad'];
					    $valido     = $arrUnidades[0]['valido'];
						if($valido){
							$resultado = $this->insertarOrdCom($codemp,$numanacot,$cod_pro,$numordcom,$tipsolcot,$cod_pro,$concepto,
												              $subtotal,$ivatotal,$montotal,$unidad,$codestpro1,$codestpro2,
												              $codestpro3,$codestpro4,$codestpro5,$estcla,$uniejeaso,$tipbiesolcot,
												              $viene_sep,$numsol,$arrDet,$numcot,$tipconpro);
						}
					}
				}
			}
		}
		return $resultado;
	}
}
?>