<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/soc/sigesp_srv_soc_ianalisis_cotizacion.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");

class ServicioAnalisisCotizacion implements IAnalisisCotizacion {

	public  $mensaje; 
	public  $valido; 
	private $conexionBaseDatos; 
	private $servicioComprobante;
	private $daoAnalisisCotizacion;
	private $daoDetalleCotxAna;
	private $daoDetalle;
	
	public function ServicioAnalisisCotizacion() {
		$this->mensaje = '';
		$this->valido = true;
	}
	
	public function buscarNumAnaCot($codemp) {
		$this->daoAnalisisCotizacion = FabricaDao::CrearDAO('N','soc_analisicotizacion');
		$this->daoAnalisisCotizacion->codemp = $codemp;
		return $this->daoAnalisisCotizacion->buscarCodigo('numanacot',true,15,array(),'SOC','SOCANA',$_SESSION['la_logusr']);
	}
	
	public function cargarProveedores($codemp,$numsolcot,$tipo,$codigo){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		if($tipo=='B'){
			$cadenaSQL = "SELECT soc_cotizacion.numcot,soc_cotizacion.cod_pro,rpc_proveedor.nompro, ".
						 "       soc_dtcot_bienes.canart AS cantidad,soc_dtcot_bienes.preuniart AS precio, ".
						 "	     soc_dtcot_bienes.moniva,soc_dtcot_bienes.montotart AS montotal,   ".
			             "       soc_dtcot_bienes.nivcalart AS calidad,soc_dtcot_bienes.codart AS codigo ".
						 "FROM rpc_proveedor,soc_cotizacion,soc_dtcot_bienes ".
						 "WHERE soc_cotizacion.codemp='{$codemp}' ".
						 "	AND soc_cotizacion.numsolcot='{$numsolcot}' ".
						 "	AND soc_dtcot_bienes.codart='{$codigo}' ".
						 "	AND soc_cotizacion.codemp=soc_dtcot_bienes.codemp ".
						 "	AND soc_dtcot_bienes.codemp=rpc_proveedor.codemp ".
						 "	AND soc_cotizacion.cod_pro=soc_dtcot_bienes.cod_pro ".
						 "	AND soc_cotizacion.cod_pro=rpc_proveedor.cod_pro ".
						 "	AND soc_cotizacion.numcot=soc_dtcot_bienes.numcot";					
		}
		else if($tipo=='S'){
			$cadenaSQL = "SELECT soc_cotizacion.numcot,soc_cotizacion.cod_pro,rpc_proveedor.nompro,  ".
			             "       soc_dtcot_servicio.canser AS cantidad,soc_dtcot_servicio.monuniser AS precio, ".
			 			 "	     soc_dtcot_servicio.moniva,soc_dtcot_servicio.montotser AS montotal,  ".
			             "       soc_dtcot_servicio.nivcalser AS calidad,soc_dtcot_servicio.codser AS codigo ".
						 "FROM rpc_proveedor,soc_cotizacion,soc_dtcot_servicio ".
						 "WHERE soc_cotizacion.codemp='{$codemp}' ".
						 "	AND soc_cotizacion.numsolcot='{$numsolcot}' ". 
						 "	AND soc_dtcot_servicio.codser='{$codigo}' ".
						 "	AND soc_cotizacion.codemp=soc_dtcot_servicio.codemp ".
						 "	AND soc_dtcot_servicio.codemp=rpc_proveedor.codemp ".
						 "	AND soc_cotizacion.cod_pro=soc_dtcot_servicio.cod_pro ".
						 "	AND soc_cotizacion.cod_pro=rpc_proveedor.cod_pro ".
						 "	AND soc_cotizacion.numcot=soc_dtcot_servicio.numcot";		
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarAnaPre($codemp,$numcot,$tipcot,$codpro){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		if($tipcot=='B'){
			$cadenaSQL= "SELECT siv_articulo.denart as denominacion, soc_dtcot_bienes.montotart as monto ".
						"FROM soc_dtcot_bienes,siv_articulo ".
						"WHERE soc_dtcot_bienes.codemp='{$codemp}' ".
						"  AND soc_dtcot_bienes.numcot='{$numcot}' ".
						"  AND soc_dtcot_bienes.cod_pro='{$codpro}' ".
						"  AND soc_dtcot_bienes.codemp=siv_articulo.codemp ".
						"  AND siv_articulo.codart=soc_dtcot_bienes.codart";					
		}
		else{
			$cadenaSQL= "SELECT soc_servicios.denser as denominacion, soc_dtcot_servicio.montotser as monto ".
						"FROM soc_dtcot_servicio,soc_servicios ".
						"WHERE soc_dtcot_servicio.codemp='{$codemp}' ".
						"  AND soc_dtcot_servicio.numcot='{$numcot}' ".
						"  AND soc_dtcot_servicio.cod_pro='{$codpro}' ".
						"  AND soc_dtcot_servicio.codemp=soc_servicios.codemp ".
						"  AND soc_servicios.codser=soc_dtcot_servicio.codser";		
		}
		
		$data =	$this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
		
	}
	
	public function buscarAnaCuaItems($codemp,$numcot,$tipcot,$codpro){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		if($tipcot=='B'){
			$cadenaSQL= "SELECT siv_articulo.denart as denominacion,soc_dtcot_bienes.nivcalart AS calificacion ".
						"FROM soc_dtcot_bienes,siv_articulo ".
						"WHERE soc_dtcot_bienes.codemp='{$codemp}' ".
						"  AND soc_dtcot_bienes.numcot='{$numcot}' ".
						"  AND soc_dtcot_bienes.cod_pro='{$codpro}' ".
						"  AND soc_dtcot_bienes.codemp=siv_articulo.codemp ".
						"  AND siv_articulo.codart=soc_dtcot_bienes.codart";					
		}
		else{
			$cadenaSQL= "SELECT soc_servicios.denser as denominacion,soc_dtcot_servicio.nivcalser AS calificacion ".
						"FROM soc_dtcot_servicio,soc_servicios ".
						"WHERE soc_dtcot_servicio.codemp='{$codemp}' ".
						"  AND soc_dtcot_servicio.numcot='{$numcot}' ".
						"  AND soc_dtcot_servicio.cod_pro='{$codpro}' ".
						"  AND soc_dtcot_servicio.codemp=soc_servicios.codemp ".
					    "  AND soc_servicios.codser=soc_dtcot_servicio.codser";		
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarAnaCuaCot($codemp,$numcot,$codpro){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		$cadenaSQL= "SELECT numcot,estasitec,estesp,garanacot, ".
					"		forpagcom,diaentcom,diavalofe ".
					"FROM soc_cotizacion ".
					"WHERE codemp='{$codemp}' ". 
					"  AND numcot='{$numcot}' ".
					"  AND cod_pro='{$codpro}'";				
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarUltimoAnalisis($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$cadenaSql=" SELECT numanacot  ".  
				"	 FROM soc_analisicotizacion  ".
				"	 WHERE codemp='{$codemp}' ";
		
		switch ($_SESSION["ls_gestor"]){
	   		case "MYSQLT":
				$limite="LIMIT 0,0 ";
				$cadenaSql = $cadenaSql."ORDER BY numanacot DESC {$limite}";
			break;
	   		case "MYSQLI":
				$limite="LIMIT 0,0 ";
				$cadenaSql = $cadenaSql."ORDER BY numanacot DESC {$limite}";
			break;
			case "POSTGRES": //  POSTGRES
				$limite="LIMIT 1";
				$cadenaSql = $cadenaSql."ORDER BY numanacot DESC {$limite}";
			break;
			case "ORACLE":
				$limite="AND rownum<1";
				$cadenaSql = $cadenaSql."{$limite} ORDER BY numanacot DESC";
	   }
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['numanacot'];
	}
	
	public function ValidarFecha($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$numero = $this->buscarUltimoAnalisis($codemp);
		$cadenaSql="SELECT fecanacot ".  
				"	FROM soc_analisicotizacion  ".
				"	WHERE codemp='{$codemp}' ". 
				"	  AND numanacot='{$numero}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data->fields['fecanacot'];
	}
	
	public function guardarAnaCot($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrCotxAna = $objson->detallesCotxAna;
		//obteniendo las instacias de los dao's
		$this->daoAnalisisCotizacion = FabricaDao::CrearDAO("N","soc_analisicotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoAnalisisCotizacion->setData($objson);
		$this->daoAnalisisCotizacion->codemp=$codemp;
		$this->daoAnalisisCotizacion->fecanacot = convertirFechaBd($objson->fecanacot);
		DaoGenerico::iniciarTrans();
		
		$resultado = $this->daoAnalisisCotizacion->incluir(true,"numanacot",true,15);
		$arrcadres = explode(",",$resultado);
		//insertando el registro y escribiendo en el log
		
		if($arrcadres[0]==1||$arrcadres[0]==-1){
			foreach ($arrCotxAna as $detalleCotxAna){
				$this->daoDetalleCotxAna = FabricaDao::CrearDAO("N","soc_cotxanalisis");
				$this->daoDetalleCotxAna->setData($detalleCotxAna);
				$this->daoDetalleCotxAna->codemp = $codemp;
				if(!$this->daoDetalleCotxAna->incluir()){
					break;
				}
			}
			
			if($objson->tipsolcot=='B'){
				$arrDetBie = $objson->detalleBienes;
				foreach ($arrDetBie as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_bienes");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
			if($objson->tipsolcot=='S'){
				$arrDetSer = $objson->detalleServicios;
				foreach ($arrDetSer as $detalle) {
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_servicios");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans()){
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento(); 	
				if($arrcadres[0]==1){
					return "|1";
				}
				else{
					return "|".$arrcadres[0]."|".$arrcadres[1];
				}	
			}
			else{
				$arrevento ['desevetra'] = $this->daoAnalisisCotizacion->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				return "|0";
			}
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoAnalisisCotizacion);
			unset($this->daoRegistroEvento);
		}
		else{
			return "|0";
		}
	}
	
	function eliminar($codemp,$numanacot,$tabla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "DELETE FROM {$tabla} ".
				" 	  WHERE codemp='{$codemp}' ".
		        "       AND numanacot='{$numanacot}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		else{
			return true;
		}
	}
	
	public function modificarAnaCot($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrCotxAna = $objson->detallesCotxAna;
		//obteniendo las instacias de los dao's
		$this->daoAnalisisCotizacion = FabricaDao::CrearDAO("N","soc_analisicotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoAnalisisCotizacion->setData($objson);
		$this->daoAnalisisCotizacion->codemp=$codemp;
		$this->daoAnalisisCotizacion->fecanacot = convertirFechaBd($objson->fecanacot);
		DaoGenerico::iniciarTrans();
		
		$this->daoAnalisisCotizacion->modificar();
		//insertando el registro y escribiendo en el log
		
		$eliminocotxana = $this->eliminar($codemp,$objson->numanacot,'soc_cotxanalisis');
		foreach ($arrCotxAna as $detalleCotxAna){
			if($eliminocotxana){
				$this->daoDetalleCotxAna = FabricaDao::CrearDAO("N","soc_cotxanalisis");
				$this->daoDetalleCotxAna->setData($detalleCotxAna);
				$this->daoDetalleCotxAna->codemp = $codemp;
				if(!$this->daoDetalleCotxAna->incluir()){
					break;
				}
			}
		}
		
		if($objson->tipsolcot=='B'){
			$eliminobie = $this->eliminar($codemp,$objson->numanacot,'soc_dtac_bienes');
			$arrDetBie = $objson->detalleBienes;
			if($eliminobie){
				foreach ($arrDetBie as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_bienes");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					if(!$this->daoDetalle->modificar()){
						break;
					}
				}	
			}
		}
		else{
			$eliminoser = $this->eliminar($codemp,$objson->numanacot,'soc_dtac_servicios');
			$arrDetSer = $objson->detalleServicios;
			if($eliminoser){
				foreach ($arrDetSer as $detalle) {
					$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_servicios");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					if(!$this->daoDetalle->modificar()){
						break;
					}
				}
			}
		}
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else{
			$arrevento ['desevetra'] = $this->daoAnalisisCotizacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoAnalisisCotizacion);
		unset($this->daoRegistroEvento);
    	return $resultado;
	}
	
	public function eliminarAnaCot($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrCotxAna = $objson->detallesCotxAna;
		//obteniendo las instacias de los dao's
		$this->daoAnalisisCotizacion = FabricaDao::CrearDAO("N","soc_analisicotizacion");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoAnalisisCotizacion->setData($objson);
		$this->daoAnalisisCotizacion->codemp=$codemp;
		$this->daoAnalisisCotizacion->fecanacot = convertirFechaBd($objson->fecanacot);
		DaoGenerico::iniciarTrans();
		
		foreach ($arrCotxAna as $detalleCotxAna){
			$this->daoDetalleCotxAna = FabricaDao::CrearDAO("N","soc_cotxanalisis");
			$this->daoDetalleCotxAna->setData($detalleCotxAna);
			$this->daoDetalleCotxAna->codemp = $codemp;
			if(!$this->daoDetalleCotxAna->eliminar()){
				break;
			}
		}
		
		if($objson->tipsolcot=='B'){
			$arrDetBie = $objson->detalleBienes;
			foreach ($arrDetBie as $detalle){
				$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_bienes");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
		}
		else{
			$arrDetSer = $objson->detalleServicios;
			foreach ($arrDetSer as $detalle) {
				$this->daoDetalle = FabricaDao::CrearDAO("N","soc_dtac_servicios");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
		}
		
		$this->daoAnalisisCotizacion->eliminar();
		//insertando el registro y escribiendo en el log
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else{
			$arrevento ['desevetra'] = $this->daoAnalisisCotizacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoAnalisisCotizacion);
		unset($this->daoRegistroEvento);
    	return $resultado;
	}
	
	public function cargarCotizaciones($codemp,$numanacot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = '';
		
		$cadenaSql = "SELECT soc_analisicotizacion.numsolcot,soc_cotxanalisis.numcot,soc_cotxanalisis.cod_pro,  ".
		    "                soc_cotizacion.feccot,soc_cotizacion.montotcot,soc_cotizacion.poriva,  ".
			"		         soc_cotizacion.numsolcot,soc_cotizacion.monsubtot,soc_cotizacion.monimpcot,  ".
			"                soc_cotizacion.obscot,soc_cotizacion.forpagcom,soc_cotizacion.diaentcom, ".
			"       		 soc_cotizacion.tipcot,rpc_proveedor.nompro ".
			"         FROM soc_cotizacion  ".
			"		  INNER JOIN soc_cotxanalisis USING(codemp,numcot,cod_pro) ".
			"         INNER JOIN soc_analisicotizacion USING(codemp,numanacot)".
			"		  INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
			"         WHERE soc_analisicotizacion.codemp='{$codemp}' ".
			"	      	AND soc_analisicotizacion.numanacot='{$numanacot}'".
			"	      	AND soc_analisicotizacion.codemp=soc_cotxanalisis.codemp ".
			"	      	AND soc_analisicotizacion.numanacot=soc_cotxanalisis.numanacot";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function cargarBienesServicios($codemp,$numanacot,$tipsolcot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = '';
		
		if($tipsolcot=='B'){
			$cadenaSql = "SELECT soc_dtac_bienes.codart as codigo,siv_articulo.denart as denominacion,  ".
			       "             rpc_proveedor.nompro,soc_dtcot_bienes.canart as cantidad,soc_dtcot_bienes.preuniart as precio,  ".
			       "             soc_dtcot_bienes.moniva,soc_dtcot_bienes.montotart as monto,soc_dtac_bienes.obsanacot,  ".
			       "             soc_dtac_bienes.numcot,soc_dtac_bienes.cod_pro,soc_dtcot_bienes.unidad,  ".
			       "             siv_unidadmedida.denunimed,soc_cotizacion.numsolcot ".
				   "	  FROM soc_dtac_bienes  ".
				   "	  INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
				   "	  INNER JOIN soc_dtcot_bienes USING(codemp,numcot,cod_pro,codart) ".
				   "	  INNER JOIN soc_cotizacion USING(codemp,numcot)".
				   "	  INNER JOIN siv_articulo USING(codemp,codart)".
				   "	  INNER JOIN siv_unidadmedida USING(codunimed)".
				   "	  WHERE soc_dtac_bienes.codemp='{$codemp}' ".
				   "	  	AND soc_dtac_bienes.numanacot='{$numanacot}' ";
		}
		else{
			$cadenaSql = "SELECT soc_dtac_servicios.codser as codigo,soc_servicios.denser as denominacion,  ".
			            "        rpc_proveedor.nompro,soc_dtcot_servicio.canser as cantidad,soc_dtcot_servicio.monuniser as precio,  ".
			            "        soc_dtcot_servicio.moniva,soc_dtcot_servicio.montotser as monto,soc_dtac_servicios.obsanacot,  ".
			            "        soc_dtac_servicios.numcot, soc_dtac_servicios.cod_pro, ".
						"		 soc_cotizacion.numsolcot ".
						" FROM soc_dtac_servicios ".
						" INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
						" INNER JOIN soc_dtcot_servicio USING(codemp,numcot,cod_pro,codser)".
						" INNER JOIN soc_cotizacion USING(codemp,numcot)".
						" INNER JOIN soc_servicios USING(codemp,codser)".
						" WHERE soc_dtac_servicios.codemp='{$codemp}' ".
						" 	AND soc_dtac_servicios.numanacot='{$numanacot}' ";
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarDenClasificacion($codemp){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = '';
		
		$cadenaSql = "SELECT denclas ".
					 "FROM rpc_clasificacion ".
					 "WHERE codemp='{$codemp}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarNivClasificacion($codemp,$objson){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arreglo = $objson->arrProveedor;
		$total = count($arreglo);
		
		for($i=0;$i<$total;$i++){
			$codpro = $arreglo[$i]->codpro;
			if($i==0){
				$cadenaSql = "(SELECT rpc_clasifxprov.codclas,rpc_clasifxprov.nivstatus,rpc_clasifxprov.cod_pro,  ".
				             "        rpc_clasificacion.denclas as calificador,rpc_proveedor.nompro ".
							 " FROM rpc_clasifxprov ".
							 " INNER JOIN rpc_clasificacion USING(codemp,codclas) ".
							 " INNER JOIN rpc_proveedor USING(codemp,cod_pro) ".
							 " WHERE rpc_clasifxprov.codemp='{$codemp}' ".
							 "	 AND rpc_clasifxprov.cod_pro='{$codpro}' )";
			}
			else{
				$cadenaSql .= "UNION (SELECT rpc_clasifxprov.codclas,rpc_clasifxprov.nivstatus,rpc_clasifxprov.cod_pro, ".
				              "              rpc_clasificacion.denclas as calificador, rpc_proveedor.nompro ".
							  "  	  FROM rpc_clasifxprov   ".
							  " 	  INNER JOIN rpc_clasificacion USING(codemp,codclas)".
							  "  	  INNER JOIN rpc_proveedor USING(codemp,cod_pro)".
							  " 	  WHERE rpc_clasifxprov.codemp='{$codemp}' ".
							  "	  	  	 AND rpc_clasifxprov.cod_pro='{$codpro}') ";
			}
		}
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		if($data === false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data; 
	}
	
	public function buscarAnaCot($codemp,$numsolcot,$numanacot,$tipsolcot,$fecdes,$fechas,$origenCatalogo,
	                             $tipope,$codpro,$estana,$obsana,$fecapro,$recanacot,$estasitec,$estesp,
	                             $garanacot){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL='';
		$cadenaFiltro='';
		$cadenaJson='';
		
		if(!empty($numsolcot)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.numsolcot like '%{$numsolcot}%'";
		}
		if(!empty($numanacot)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.numanacot like '%{$numanacot}%'";
		}
		if(!empty($tipsolcot)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.tipsolcot='{$tipsolcot}'";
		}
	    if(!empty($estana)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.estana='{$estana}'";
		}
	    if(!empty($obsana)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.obsana='{$obsana}'";
		}
		if(!empty($fecapro)){
			$fecapro = convertirFechaBd($fecapro);
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.fecapro='{$fecapro}'";
		}
	    if(!empty($recanacot)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.recanacot='{$recanacot}'";
		}
	    if(!empty($estasitec)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.estasitec='{$estasitec}'";
		}
		if(!empty($estesp)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.estesp='{$estesp}'";
		}
	    if(!empty($garanacot)){
			$cadenaFiltro=$cadenaFiltro."AND soc_analisicotizacion.garanacot='{$garanacot}'";
		}
		if(!empty($fecdes) && !empty($fechas)){
		   	 $fecdes = convertirFechaBd($fecdes);
			 $fechas = convertirFechaBd($fechas); 
		     $cadenaFiltro = $cadenaFiltro." AND soc_analisicotizacion.fecanacot BETWEEN '{$fecdes}' AND '{$fechas}'";
	 	}
	 	if(!empty($origenCatalogo)){
	 		if($origenCatalogo=='Generacion'){
	 			$cadenaFiltro = $cadenaFiltro."AND soc_analisicotizacion.estana=1 ";
	 			$cadenaFiltro = $cadenaFiltro."AND soc_analisicotizacion.numanacot NOT IN (SELECT CASE WHEN numanacot IS NULL THEN '-------' ELSE numanacot END ".
					                          "  										   FROM soc_ordencompra ".
				                              "											   WHERE codemp='{$codemp}' AND estcom<>3) ";
	 		}
	 		if($origenCatalogo=='Aprobacion'){
		 		if($tipope=='A'){//Aprobacion
				    $cadenaFiltro = $cadenaFiltro." AND soc_analisicotizacion.estana='0'";
				}
				else{//Reverso
					$cadenaFiltro = $cadenaFiltro." AND soc_analisicotizacion.estana='1' AND soc_analisicotizacion.numanacot not in (SELECT CASE WHEN soc_ordencompra.numanacot IS NULL THEN '------' ELSE soc_ordencompra.numanacot END FROM soc_ordencompra WHERE soc_ordencompra.codemp='{$codemp}')";
				}
	 		}
	 		if($origenCatalogo=='Anulacion'){
	 			$cadenaJson = "INNER JOIN soc_ordencompra USING(codemp,numanacot) ";
	 			$cadenaFiltro = $cadenaFiltro."AND soc_ordencompra.estcom= '3'";
	 			$cadenaFiltro = $cadenaFiltro."AND soc_analisicotizacion.estana= '1'";
	 			if(!empty($codpro)){
			 		$cadenaFiltro = $cadenaFiltro." AND soc_ordencompra.cod_pro='{$codpro}'"; 
			 	}
	 		}
	 	}
	 	
	 	$cadenaSQL = "SELECT numanacot,max(fecanacot) as fecanacot,max(obsana) as obsana, ".
					 "		 max(numsolcot) as numsolcot,max(tipsolcot) as tipsolcot,max(estana) as estana, ".
					 "		 max(estasitec) as estasitec,max(estesp) as estesp,max(garanacot) as garanacot, ".
					 "		 max(recanacot) as recanacot,max(fecapro) as fecapro ".
					 "FROM soc_analisicotizacion {$cadenaJson}".
					 "WHERE codemp='{$codemp}' {$cadenaFiltro} ".
					 "GROUP BY numanacot ".
	 	             "ORDER BY numanacot ASC";
	 	
			 $data = $this->conexionBaseDatos->Execute($cadenaSQL);
			 if($data === false){
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
			return $data;		
	}
}
?>