<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_itipoindicador.php");

class ServicioTipoIndicador implements ITipoIndicador{
	private $daoTipoIndicador;
	
	public function ServicioUnidadMedida() {
		$this->daoTipoIndicador = null;
	}
	
	public function incluirTipoIndicador($codemp,$objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoTipoIndicador = FabricaDao::CrearDAO('N', 'sig_tipoindicadores');
		$this->daoTipoIndicador->setData($objson);
		$this->daoTipoIndicador->codemp          = $codemp;
		$this->daoTipoIndicador->incluir();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}

		unset($this->daoTipoIndicador);
		return $procesado;
	}
	
	public function buscarCodigoTipoIndicador($codemp) {
		$this->daoTipoIndicador = FabricaDao::CrearDAO('N', 'sig_tipoindicadores');
		$this->daoTipoIndicador->codemp  = $codemp;
		$codigo = $this->daoTipoIndicador->buscarCodigo('cod_tipoind',true,10);
		
		unset($this->daoTipoIndicador);
		return $codigo;
		
	}
	
	public function buscarTipoInidacadores($codemp) {
		$this->daoTipoIndicador = FabricaDao::CrearDAO('N', 'sig_tipoindicadores');
		$this->daoTipoIndicador->codemp  = $codemp;
		$dataUnidad = $this->daoTipoIndicador->leerTodos('cod_tipoind',1,$codemp);
		
		unset($this->daoTipoIndicador);
		return $dataUnidad;
	}
	
	public function modificarTipoIndicador($codemp, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoTipoIndicador = FabricaDao::CrearDAO('N', 'sig_tipoindicadores');
		$this->daoTipoIndicador->setData($objson);
		$this->daoTipoIndicador->codemp  = $codemp;
		$this->daoTipoIndicador->modificar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function eliminarTipoIndicador($codemp, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoTipoIndicador = FabricaDao::CrearDAO('N', 'sig_tipoindicadores');
		$this->daoTipoIndicador->setData($objson);
		$this->daoTipoIndicador->codemp          = $codemp;
		$this->daoTipoIndicador->eliminar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
}