<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_funciones.php");

class ServicioReporteCAIF {
	
	public function ServicioReporteCAIF() {
		
	}
	
	public function tieneMovimiento($codemp, $anPresupuesto, $grupoCuenta) {
		$movimiento = false; 
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select * 
						from spe_plan_ingr 
						where codemp='{$codemp}' and 
						      ano_presupuesto={$anPresupuesto} and 
			  			      sig_cuenta like '{$grupoCuenta}%'";
		$dataSet = $conexionBaseDatos->Execute ( $cadenaSql );
		if($dataSet->_numOfRows > 0){
			$movimiento = true;
		}
		else{
			$cadenaSql = "select sig_cuenta 
							from sfp_dt_cmp_variacion 
							where codemp='{$codemp}' and 
						          ano_presupuesto={$anPresupuesto} and 
								  sig_cuenta like '{$grupoCuenta}%'";
			$dataPlan  = $conexionBaseDatos->Execute($cadenaSql);
			if($dataPlan->_numOfRows > 0){
				$movimiento = true;
			}
		}
		
		return $movimiento;
	}
	
	public function buscarSaldosCAIFPlan($codemp, $anPresupuesto, $cuenta) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros=uf_spg_cuenta_sin_cero(trim($cuenta));
		
		$cadenaSql = "select sigesp_plan_unico_re.denominacion, sigesp_sfp_asociacion.codcaif,
			                 COALESCE((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '{$cuentasinceros}%'),0000) as anestimado ,
			                 COALESCE((select sum(monto_anreal)  from sigesp_sfp_plancuentas where sig_cuenta like '{$cuentasinceros}%'),0000) as anreal,
							 {$cuenta} as codcuenta,
			                 COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobal 
						from spe_plan_ingr
							INNER JOIN sigesp_plan_unico_re ON SUBSTR(spe_plan_ingr.sig_cuenta,1,9)=sigesp_plan_unico_re.sig_cuenta
     						INNER JOIN sigesp_sfp_asociacion ON SUBSTR(spe_plan_ingr.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta  
						where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
						      spe_plan_ingr.sig_cuenta like '{$cuentasinceros}%'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarTotalIngresosCorrientes($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoIngresosCorrientes = 0;
		
		$cadenaSql = "select COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobal
						from spe_plan_ingr  
						where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
						      (spe_plan_ingr.sig_cuenta like '30501%' or spe_plan_ingr.sig_cuenta like '30401%' or 
						      spe_plan_ingr.sig_cuenta like '30402%' or  spe_plan_ingr.sig_cuenta like '301%' or  
						      spe_plan_ingr.sig_cuenta like '30499%' or  spe_plan_ingr.sig_cuenta like '303%')";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoIngresosCorrientes = $dataSet->fields['montoglobal'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoIngresosCorrientes;
	}
	
	public function buscarTotalGastosCorrientes($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoGastoCorrientes = 0;
		
		$cadenaSql = "select COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoglobalgas 
			  			from  spe_int_cuentas 
			  			where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
			  			      nat_gasto='co' and sig_cuenta not like '411%' and sig_cuenta not like '405%'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoGastoCorrientes = $dataSet->fields['montoglobalgas'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoGastoCorrientes;
	}
	
	public function buscarTotalIngresosCapital($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoIngresosCapital = 0;
		
		$cadenaSql = "select COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobal
						from spe_plan_ingr spe_plan_ingr 
						where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
						 	  (spe_plan_ingr.sig_cuenta like '30502%' or spe_plan_ingr.sig_cuenta like '306%' or 
						 	  spe_plan_ingr.sig_cuenta like '30801%' or  spe_plan_ingr.sig_cuenta like '30802%' or  
						 	  spe_plan_ingr.sig_cuenta like '30803%' or  spe_plan_ingr.sig_cuenta like '3090101%' or 
						 	  spe_plan_ingr.sig_cuenta like '30902%' or  spe_plan_ingr.sig_cuenta like '30903%' or 
						 	  spe_plan_ingr.sig_cuenta like '31001%' or  spe_plan_ingr.sig_cuenta like '31002%' or  
						 	  spe_plan_ingr.sig_cuenta like '31003%')";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoIngresosCapital = $dataSet->fields['montoglobal'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoIngresosCapital;
	}
	
	public function buscarTotalGastoCapital($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoGastoCapital = 0;
		
		$cadenaSql = "select COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoglobalgas
						from  spe_int_cuentas 
						where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and nat_gasto='ca'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoGastoCapital = $dataSet->fields['montoglobalgas'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoGastoCapital;
	}
	
	public function calcularAhorroDesahorro($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoIngresoCorriente = $this->buscarTotalIngresosCorrientes($codemp, $anPresupuesto);
		$montoGastoCorriente   = $this->buscarTotalGastosCorrientes($codemp, $anPresupuesto);
		$totalGastoCorriente   = $montoIngresoCorriente - $montoGastoCorriente;
		
		/* En la version anterior se calculaba el total de los gasto de capital
		 * restando el total de ingresos y gastos de capital obtenido con sus 
		 * respectivos metodos pero luego este monto no fue incluido en los datos
		 * a retornar motivo por el cual no se incluyo en esta funcion, se hace 
		 * la observacion para tener en cuenta para cualquier ajuste futuro
		 * */
		
		$cadenaSql = "select '' as codcuenta, 'Ahorro/Desahorro en Cuenta Corriente' as denominacion,{$totalGastoCorriente} as montoglobal";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarSaldoVariacion($codemp, $anPresupuesto, $debhab){
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoVariacion = 0;
		
		$cadenaSql = "select sum(monto) as saldovariacion  
						from sfp_dt_cmp_variacion 
						where debhab='{$debhab}' and codemp = '{$codemp}'  and ano_presupuesto={$anPresupuesto}";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoVariacion = $dataSet->fields['saldovariacion'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoVariacion;
	}
	
	public function buscarSaldoCAIFInversion($codemp, $anPresupuesto, $cuenta) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros = uf_spg_cuenta_sin_cero(trim($cuenta));
		$totalvariacion = $this->buscarSaldoVariacion($codemp, $anPresupuesto, 'H');
		
		$cadenaSql = "select sigesp_plan_unico_re.denominacion, sigesp_sfp_asociacion.codcaif,
							 COALESCE((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '{$cuentasinceros}%'),0000) as anestimado ,
							 COALESCE((select sum(monto_anreal)  from sigesp_sfp_plancuentas where sig_cuenta like '{$cuentasinceros}%'),0000) as anreal,
							 {$cuenta} as codcuenta,
							 COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000)+{$totalvariacion} as montoglobal 
						from spe_plan_ingr 
							INNER JOIN sigesp_plan_unico_re ON SUBSTR(spe_plan_ingr.sig_cuenta,1,9)=sigesp_plan_unico_re.sig_cuenta
     						INNER JOIN sigesp_sfp_asociacion ON SUBSTR(spe_plan_ingr.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta 
							where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
							      spe_plan_ingr.sig_cuenta like '{$cuentasinceros}%'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarSaldoCAIFAplicacionFinanciera($codemp, $anPresupuesto, $cuenta, $naturalezaGasto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros = uf_spg_cuenta_sin_cero(trim($cuenta));
				
		$cadenaSql = "select sigesp_plan_unico_re.denominacion as denominaciongas, 
							 sigesp_sfp_asociacion.codcaif as codcaifgas,
			  				 COALESCE(sum((spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+spe_int_cuentas.diciembre)),000)+($totalvariacion) as montoglobalgas 
			  			from  spe_int_cuentas  
			  				INNER JOIN sigesp_plan_unico_re ON SUBSTR(spe_int_cuentas.sig_cuenta,1,9)=sigesp_plan_unico_re.sig_cuenta
     						INNER JOIN sigesp_sfp_asociacion ON SUBSTR(spe_int_cuentas.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta
			  			where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
			  			      nat_gasto='{$naturalezaGasto}' and spe_int_cuentas.sig_cuenta like '{$cuentasinceros}%'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarDatosDefecto() {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$cadenaSql = "select '' as denominacion,'' as anestimado,'' as anreal,'' as codcuenta,'' as trimestre1, '' as trimestre2, '' as trimestre3, '' as trimestre4, 
		  					 '' as enero, '' as febrero, '' as marzo, '' as abril,'' as mayo, '' as junio,'' as julio,'' as agosto, '' as septiembre, '' as octubre, '' as noviembre, '' as diciembre,
		  					 '' as bimestre1, '' as bimestre2, '' as bimestre3, '' as bimestre4, '' as bimestre5, '' as bimestre6, '' as semestre1, '' as semestre2, '' as montoglobal from sigesp_empresa";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarSaldoCAIFGasto($codemp, $anPresupuesto, $cuenta, $naturalezaGasto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros = uf_spg_cuenta_sin_cero(trim($cuenta));
				
		$cadenaSql = "select (select denominacion from sigesp_plan_unico_re where sig_cuenta='{$this->sig_cuenta}') as denominaciongas, 
		                     (select codcaif from sigesp_sfp_asociacion where sig_cuenta='{$this->sig_cuenta}') as codcaifgas,
		                     COALESCE(sum((spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+spe_int_cuentas.diciembre)),000) as montoglobalgas 
				  		from  spe_int_cuentas  
				  		where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
				  		      nat_gasto='{$naturalezaGasto}' and spe_int_cuentas.sig_cuenta like '{$cuentasinceros}%'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function reporteCAIF($codemp, $anPresupuesto) {
		$la_cuenta[118]=array();
		// ----> 1.  INGRESOS CORRIENTES
		//	$la_cuenta[0]["cuenta"]='300000000'.$ls_ceros;
		//$la_cuenta[0]["detalles"]=Array('302000000','303000000','304000000','305000000');
		
		//$la_cuenta[1]["cuenta"]='305000000'.$ls_ceros;
		$la_cuenta[2]["cuenta"]='305010000'.$ls_ceros;
		$la_cuenta[3]["cuenta"]='305010100'.$ls_ceros;
		$la_cuenta[3]["titulo"]='Del sector privado'.$ls_ceros;
		$la_cuenta[3]["detalles"]=Array('305010101','305010102','305010103');
		$la_cuenta[4]["cuenta"]='305010200'.$ls_ceros;
		$la_cuenta[4]["detalles"]=Array('305010201','305010201','305010201');
		
		$la_cuenta[5]["cuenta"]='305010300'.$ls_ceros;
		$la_cuenta[5]["detalles"]='305010300'.$ls_ceros;
		$la_cuenta[6]["cuenta"]='305010301'.$ls_ceros;
		$la_cuenta[7]["cuenta"]='305010302'.$ls_ceros;
		$la_cuenta[8]["cuenta"]='305010303'.$ls_ceros;
		$la_cuenta[9]["cuenta"]='305010304'.$ls_ceros;
		$la_cuenta[10]["cuenta"]='305010305'.$ls_ceros;
		$la_cuenta[11]["cuenta"]='305010306'.$ls_ceros;
		$la_cuenta[12]["cuenta"]='305010307'.$ls_ceros;
		$la_cuenta[13]["cuenta"]='305010308'.$ls_ceros;
		$la_cuenta[14]["cuenta"]='305010309'.$ls_ceros;
		$la_cuenta[15]["cuenta"]='305010400'.$ls_ceros;
		$la_cuenta[16]["cuenta"]='305010401'.$ls_ceros;
		$la_cuenta[17]["cuenta"]='305010402'.$ls_ceros;
		$la_cuenta[18]["cuenta"]='305010403'.$ls_ceros;
		$la_cuenta[19]["cuenta"]='305010404'.$ls_ceros;
		$la_cuenta[20]["cuenta"]='305010405'.$ls_ceros;
		$la_cuenta[21]["cuenta"]='305010406'.$ls_ceros;
		$la_cuenta[22]["cuenta"]='305010407'.$ls_ceros;
		$la_cuenta[23]["cuenta"]='305010408'.$ls_ceros;
		$la_cuenta[24]["cuenta"]='305010409'.$ls_ceros;
		$la_cuenta[25]["cuenta"]='305010500'.$ls_ceros;
		$la_cuenta[25]["cuenta"]='305010500'.$ls_ceros;
		$la_cuenta[25]["detalles"]=Array('305010501','305010502','305010503');
		$la_cuenta[26]["cuenta"]='305010600'.$ls_ceros;
		$la_cuenta[26]["detalles"]=Array('305010601','305010602','305010603','305010604');
		// ---> b. Ingresos por Actividades Propias
		
		/*
		$la_cuenta[27]["cuenta"]='301030000'.$ls_ceros;
		$la_cuenta[28]["detalles"]=Array('301030100','301030200','301030300','301030400','301030500','301030600','301030700','301030800','301030900','301031000','301031100','301031200','301031300','301031400','301031500','301031600','301031700','301031800','301031900','301032000','301032100','301032200','301032300','301032400','301032500','301032600','301032700','301032800','301032900','301033000','301033100','301033200','301033300','301033400','301033500','301033600','301033700','301033800','301033900','301034000','301034100','301034200','301034300','301034400','301034500','301034600','301034700','301034800','301034900','301039900');
		$la_cuenta[29]["cuenta"]='303000000'.$ls_ceros;
		$la_cuenta[30]["detalles"]=Array('303030000','303990000',);
		*/
		/*$la_cuenta[27]["cuenta"]='301090000'.$ls_ceros;
		$la_cuenta[28]["cuenta"]='301090100'.$ls_ceros;
		$la_cuenta[29]["cuenta"]='301090200'.$ls_ceros;
		$la_cuenta[30]["cuenta"]='301099900'.$ls_ceros;
		$la_cuenta[31]["cuenta"]='408070000'.$ls_ceros; // ---> Menos Descuentos, Bonificaciones y Devoluciones
		$la_cuenta[31]["detalles"]=Array('408070100','408070200','408070300');
       */ 
		// ---> Ventas Netas
		$la_cuenta[27]["cuenta"]='301030000'.$ls_ceros;
		$la_cuenta[28]["cuenta"]='301040000'.$ls_ceros;
		$la_cuenta[29]["cuenta"]='301050000'.$ls_ceros;
		
		
		$la_cuenta[30]["cuenta"]='301090000'.$ls_ceros;
		$la_cuenta[30]["detalles"]=Array('301090100','301090200','301099900');
		
		
		$la_cuenta[31]["cuenta"]='408070000'.$ls_ceros; // ---> Menos Descuentos, Bonificaciones y Devoluciones
		$la_cuenta[31]["detalles"]=Array('408070100','408070200','408070300');
		
		$la_cuenta[32]["cuenta"]='303000000'.$ls_ceros;
		$la_cuenta[32]["detalles"]=Array('303030000','303990000','301000000','301100100','301100501','301100400','301100300','301100300','301100503','301100600','301100601','301100801','301101000','301100802','301100900');
		$la_cuenta[33]["detalles"]=Array('304990000');
		$la_cuenta[33]["detalles"]=Array('301110000','301991100');
        // gastos Ingresos Corrientes
	/*	$la_cuenta[34]["cuenta"]='301040000'.$ls_ceros;
		$la_cuenta[35]["cuenta"]='301050000'.$ls_ceros;
		$la_cuenta[36]["cuenta"]='301100000'.$ls_ceros;
		$la_cuenta[36]["detalles"]=Array('301110100','301110200','301110300','301110400','301110401','301110402','301110403','301110404','301110405','301110406','301110500','301110600','301110700','301110800','301110900','301111000','301111000');
		$la_cuenta[37]["cuenta"]='302030000'.$ls_ceros;
		$la_cuenta[38]["cuenta"]='302040000'.$ls_ceros;
		$la_cuenta[39]["cuenta"]='302050000'.$ls_ceros;*/
		// ---> 2. GASTOS CORRIENTES
		// ---> a. Gastos de Consumo
		$la_cuenta[34]["cuenta"]='401000000'.$ls_ceros;
		$la_cuenta[34]["detalles"]=Array('401010000','401040000','401060000','401080000','401070000','401900000');
		$la_cuenta[35]["cuenta"]='402000000'.$ls_ceros;
		$la_cuenta[36]["cuenta"]='403000000'.$ls_ceros;
		// ---> Variacion de Inventarios (Detallar)
		$la_cuenta[37]["cuenta"]='403180000'.$ls_ceros;
		$la_cuenta[44]["cuenta"]='408010000'.$ls_ceros;
		$la_cuenta[45]["cuenta"]='408060000'.$ls_ceros;
		$la_cuenta[46]["cuenta"]='408020000'.$ls_ceros;
		$la_cuenta[46]["detalles"]=Array('408020100','408020200','408020300');
		// ---> b. Otros Gastos Corrientes
		$la_cuenta[47]["cuenta"]='403010300'.$ls_ceros;
		$la_cuenta[48]["cuenta"]='403030000'.$ls_ceros;
		$la_cuenta[49]["cuenta"]='408060200'.$ls_ceros;
		$la_cuenta[49]["detalles"]=Array('408060200','408060300','408060500');
		$la_cuenta[49]["titulo"]='Otros Gastos Corrientes'.$ls_ceros;
		$la_cuenta[50]["cuenta"]='408050000'.$ls_ceros;
		$la_cuenta[50]["detalles"]=Array('408050100','408050200','408050300');
		$la_cuenta[51]["cuenta"]='408060000ee'.$ls_ceros;
		$la_cuenta[52]["cuenta"]='408080000'.$ls_ceros;
		$la_cuenta[52]["detalles"]=Array('408080102','408080202','408990000');	
		$la_cuenta[53]["cuenta"]='407010000'.$ls_ceros;
		$la_cuenta[53]["detalles"]=Array('407010100','407010101','407010102','407010199','407010200','407010201','407010202','407010300','407010301','407010302','407010303','407010304','407010305','407010306','407010307','407010308','407010309','407010310','407010311','407010312','407010313','407010400','407010401','407010402','407010403','407010404','407010405','407010406','407010407','407010408','407010409');
		$la_cuenta[54]["cuenta"]='407020000'.$ls_ceros;
		$la_cuenta[54]["detalles"]=Array('407020100','407020101','407020102','407020103','407020104','407020200','407020201','407020202','407020203','407020204');
		
		$la_cuenta[55]["cuenta"]='306000000'.$ls_ceros;
		$la_cuenta[56]["detalles"]=Array('ahorro','306010000','306010000','306010200','306010100','306020000','306030000');
		$la_cuenta[57]["cuenta"]='305020000';
		$la_cuenta[57]["detalles"]=Array('305020000','305020100','305020101','305020102','305020103','305020300','305020301','305020302','305020303','305020304','305020305','305020306','305020307','305020308','305020309','305020400','305020401','305020402','305020403','305020404','305020405','305020406','305020407','305020408','305020409','305020500','305020501','305020502','305020503','305020600','305020601','305020602','305020603','305020604');
		$la_cuenta[58]["cuenta"]='308010000'.$ls_ceros;
		$la_cuenta[59]["cuenta"]='308020000'.$ls_ceros;
		$la_cuenta[59]["detalles"]=Array('308020100','308020200','308020300','308020400','308020500','308020600');
		$la_cuenta[60]["cuenta"]='308030000';	
		$la_cuenta[60]["detalles"]=Array('308030100','308039900');
		$la_cuenta[61]["cuenta"]='309010100';
		$la_cuenta[62]["cuenta"]='309020100';
		$la_cuenta[62]["detalles"]=Array('309020100','309020200','309020300','309020400','309020500','309020600','309020700','309020800','309020900');
		$la_cuenta[63]["cuenta"]='309030000';
		$la_cuenta[63]["detalles"]=Array('309030100','309030200','309030300');
		$la_cuenta[64]["cuenta"]='310010100';	
		$la_cuenta[65]["cuenta"]='310020000';
		$la_cuenta[65]["detalles"]=Array('310020100','310020200','310020300','310020400','310020500','310020600','310020700','310020800','310020900');
		$la_cuenta[66]["cuenta"]='310030000';
		$la_cuenta[66]["detalles"]=Array('310030100','310030200','310030300');
		$la_cuenta[67]["cuenta"]='404090000'.$ls_ceros;
		$la_cuenta[68]["cuenta"]='404150000';
		$la_cuenta[69]["cuenta"]='404160000'.$ls_ceros;
		$la_cuenta[70]["cuenta"]='401010000';	
		$la_cuenta[71]["cuenta"]='401040000';
		$la_cuenta[72]["cuenta"]='401060000';
		$la_cuenta[73]["cuenta"]='401080000';
		$la_cuenta[74]["cuenta"]='401070000';
		$la_cuenta[74]["detalles"]=Array('401900000');
		$la_cuenta[75]["cuenta"]='403990000';
		$la_cuenta[76]["cuenta"]='403180000';
		$la_cuenta[77]["cuenta"]='403010300';
		
		$la_cuenta[78]["cuenta"]='407030100';
		$la_cuenta[78]["detalles"]=Array('407030101','407030102','407030103','407030200','407030201','407030202');
		$la_cuenta[79]["cuenta"]='407030300';
		$la_cuenta[80]["cuenta"]=Array('407030301','407030302','407030303','407030304','407030305','407030306','407030307','407030308','407030309');
		$la_cuenta[81]["cuenta"]='407030400';
		$la_cuenta[82]["cuenta"]=Array('407030401','407030402','407030403','407030404','407030405','407030406','407030407','407030408','407030409');
		$la_cuenta[83]["cuenta"]='407040100';
		$la_cuenta[84]["cuenta"]=Array('407040101','407040102','407040103','407040104','407040200','407040201','407040202','407040203','407040204');
		$la_cuenta[85]["cuenta"]='405010000';
		$la_cuenta[86]["cuenta"]='405010100';
		$la_cuenta[86]["cuenta"]='405010200';
		$la_cuenta[86]["detalles"]=Array('405010201','405010202','405010203','405010204','405010205','405010206','405010207');
		
		$la_cuenta[87]["cuenta"]='405010300';
		$la_cuenta[87]["cuenta"]=Array('405010301','405010399');
		$la_cuenta[88]["cuenta"]='405030000';
		$la_cuenta[90]["cuenta"]=Array('405030100','405030200','405030201','405030202','405030203','405030204','405030205','405030206','405030207','405030208','405030209','405030300','405030301','405030302','405030303');
		$la_cuenta[91]["cuenta"]='405040000';
		$la_cuenta[92]["detalles"]=Array('405040100','405040200','405040201','405040200','405040201','405040202','405040203','405040204','405040205','405040206','405040207','405040208','405040209','405040300','405040301','405040302','405040303');
		
		//ingresos financieros
		$la_cuenta[93]["cuenta"]='307000000';
		$la_cuenta[93]["detalles"]=Array('307010000','307010100','307010200','307010300','307020100','307020000','307020100','307020200');
		$la_cuenta[94]["cuenta"]='311000000';
		$la_cuenta[94]["detalles"]=Array('311010000','311010100','311010200','311010300','311020000','311020100','311029900','311030000','311030100','311039900','311040000','311040100','311040200','311049900','311050000','311050100','311059900','311060000','311060300','311060400','311060500','311060600','311070000','311080000','311200000','311990100','311990200');
		$la_cuenta[95]["cuenta"]='312000000';
		$la_cuenta[95]["detalles"]=Array('312010100','312020000','312030100','312030200','312040100','312040200','312050000','312050200','312030300','312030400','312040300','312040400','312060100','312060200','312060300','312100000','312100100','312100200','312070100','312070201','312070202','312070203','312080100','312080101','312080102','312080103','312080104','312080199','312080200','312090100','312099900','312090100','312090200');
		$la_cuenta[96]["cuenta"]='313010000';
		$la_cuenta[96]["detalles"]=Array('313010100','313010200','313020100','313040100','313040200');
		
		//aplicaciones financieras
		$la_cuenta[97]["cuenta"]='405020000';
		$la_cuenta[98]["cuenta"]='405020100';
		$la_cuenta[98]["detalles"]=Array('405020101','405020102','405020103','405020200','405020201','405020202','405020203');
		$la_cuenta[99]["cuenta"]='405050000';
		$la_cuenta[100]["cuenta"]='405050000ee';
		$la_cuenta[100]["detalles"]=Array('405050100','405050200','405050300');
		$la_cuenta[101]["cuenta"]='405060000';
		$la_cuenta[101]["detalles"]=Array('405060100','405060200','405060300','405060301','405060302','405069900');
		$la_cuenta[102]["cuenta"]='405070000';
		$la_cuenta[102]["detalles"]=Array('405070100','405079900');	
		
		
		$la_cuenta[103]["cuenta"]='405070000';
		$la_cuenta[103]["detalles"]=Array('405060100','405060200','405060300','405060301','405060302','405069900');
		$la_cuenta[104]["cuenta"]='405070000';
		$la_cuenta[104]["detalles"]=Array('405070100','405079900');		
		$la_cuenta[105]["cuenta"]='405080000';
		$la_cuenta[105]["detalles"]=Array('405080100','405080200','405089900');
		
		
		$la_cuenta[106]["cuenta"]='405090000';
		$la_cuenta[106]["detalles"]=Array('405090100','405099900','405060300','405060301','405060302','405069900');
		$la_cuenta[107]["cuenta"]='405100000';
		$la_cuenta[107]["detalles"]=Array('405100000','405100300','405100400','405100500','405100600');		
		$la_cuenta[108]["cuenta"]='405110000';
		$la_cuenta[109]["cuenta"]='405120000';
		$la_cuenta[110]["cuenta"]='405200000';
		$la_cuenta[111]["cuenta"]='405210000';
		$la_cuenta[112]["cuenta"]='405990000';
		$la_cuenta[113]["cuenta"]='411000000';
		$la_cuenta[113]["detalles"]=Array('411030000','411010100','411020000','411030100','411030200','411040100','411040200','411050000','411050100','411050200');		
		$la_cuenta[114]["cuenta"]='411030300';
		$la_cuenta[114]["detalles"]=Array('411030400','411040300','411040400','411060000','411060100','411060200','411060300','411100000','411100100','411100200');
		$la_cuenta[115]["cuenta"]='411070100';
		$la_cuenta[115]["detalles"]=Array('411070200','411070201','411070202','411070203');
		$la_cuenta[116]["cuenta"]='411080000';
		$la_cuenta[116]["detalles"]=Array('411080100','411080101','411080102','411080103','411080104','411080199','411080200');
		$la_cuenta[117]["cuenta"]='411090000';
		$la_cuenta[117]["detalles"]=Array('411090100','411099900','411980100','411990100');
		$la_cuenta[118]["cuenta"]='412000000';
		$la_cuenta[118]["detalles"]=Array('412010000','412010100','412010200','412020000','412020100','412030000','412030100','412040000','412040100','412040200');
		$datastore0=array();
	    $id0=0;
		$datastore1=array();
	    $id1=0;
	    $datastore2=array();
	    $id2=0;
	    $datastore3=array();
	    $id3=0;
	    $datastore4=array();
	    $id4=0;
	    $datastore5=array();
	    $id5=0;
	    $datastore6=array();
	    $id6=0;
	    $datastore7=array();
	    $id7=0;
	    $datastore8=array();
	    $id8=0;
		for($i=2;$i<=118;$i++)
		{
			if($i>=2 && $i<=30  && $i!=31)
			{
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
		  		if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{
					$datastore0[$id0]=$this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"]);	
			  		$id0++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{
    					$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));
		  				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore0[$id0]=$this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j]);
	  						$id0++;
						}
					}
  				}
			}

			if($i>=32 && $i<=33)
			{
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
		  		if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{
					$datastore2[$id2]= $this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"]);	
				  	$id2++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore2[$id2]=$this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j]);
	  						$id2++;
						}
					}
  				}
			}		
			

			if($i>=34 && $i<=54)
			{
				if($i==38){
					$i=44;
				}
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
		  		if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  		
					$datastore1[$id1]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"], 'co');
					$id1++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  	
							$datastore1[$id1]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j], 'co');
	  						$id1++;
						}
					}
  				}
			}

			
			if($i==31) 
			{
				$cuentasinceros=uf_spg_cuenta_sin_cero($la_cuenta[$i]["cuenta"]);
				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  						
					$datastore3[$id3]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"], 'co');	
			  		$id3++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						$cuentasinceros=uf_spg_cuenta_sin_cero($la_cuenta[$i]["detalles"][$j]);		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore3[$id3]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j], 'co');
	  						$id3++;
						}
					}
  				}
			}				
			
			if($i>=55 && $i<=66)
			{
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  						
					$datastore4[$id4]=$this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"]);	
			  		$id4++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						if($la_cuenta[$i]["detalles"][$j]=='ahorro')
  						{
  							$datastore4[$id4]=$this->calcularAhorroDesahorro($codemp, $anPresupuesto);
	  						$id4++;
	  						$j++;
  						}
  						$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore4[$id4]=$this->buscarSaldosCAIFPlan($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j]);
	  						$id4++;
						}
					}
  				}
			}		

			
			if($i>=67 && $i<=92)
			{
				if($i==89){
					$i=90;
				}
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  						
					$datastore5[$id5]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"], 'ca');	
			  		$id5++;
			  	}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore5[$id5]=$this->buscarSaldoCAIFGasto($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j], 'ca');
	  						$id5++;
						}
					}
  				}
			}
					
			if($i>=93 && $i<=96)
			{
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  						
					$datastore6[$id6]=$this->buscarSaldoCAIFInversion($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"]);	
			  		$id6++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore6[$id6]=$this->buscarSaldoCAIFInversion($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j]);
	  						$id6++;
						}
					}
  				}
			}		
			
			
			if($i>=97 && $i<=118)
			{
				
				$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["cuenta"]));
				if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
				{		  
					$datastore7[$id7]=$this->buscarSaldoCAIFAplicacionFinanciera($codemp, $anPresupuesto, $la_cuenta[$i]["cuenta"], 'co');	
			  		$id7++;
				}
				if(is_array($la_cuenta[$i]["detalles"]))
  				{
  					for($j=0;$j<count($la_cuenta[$i]["detalles"]);$j++)
  					{	
  						$cuentasinceros=uf_spg_cuenta_sin_cero(trim($la_cuenta[$i]["detalles"][$j]));		
  						if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros))
						{		  						
	  						$datastore7[$id7]=$this->buscarSaldoCAIFAplicacionFinanciera($codemp, $anPresupuesto, $la_cuenta[$i]["detalles"][$j], 'co');
	  						$id7++;
						}
					}
  				}
			}	
			
   		}	 		
   		
		if($id0==0)
		{
			$datastore0[0] = $this->buscarDatosDefecto();
		}
		if($id1==0)
		{
			$datastore1[0] = $this->buscarDatosDefecto();
		}	
		if($id2==0)
		{
			$datastore2[0] = $this->buscarDatosDefecto();
		}
		if($id3==0)
		{
			$datastore3[0] = $this->buscarDatosDefecto();
		}
		if($id4==0)
		{
			$datastore4[0] = $this->buscarDatosDefecto();
		}
		if($id5==0)
		{
			$datastore5[0] = $this->buscarDatosDefecto();
		}
		if($id6==0)
		{
			$datastore6[0] = $this->buscarDatosDefecto();
		}
		
		if($id7==0)
		{
			$datastore7[0] = $this->buscarDatosDefecto();
		}

   		$arrDatos["datos0"]=$datastore0;
  		$arrDatos["datos1"]=$datastore1;
		$arrDatos["datos2"]=$datastore2;
		$arrDatos["datos3"]=$datastore3;
		$arrDatos["datos4"]=$datastore4;
		$arrDatos["datos5"]=$datastore5;
		$arrDatos["datos6"]=$datastore6;
		$arrDatos["datos7"]=$datastore7;
		$arrDatos["datos8"]=$datastore8;
  		return  $arrDatos;
	}
	
	public function buscarSaldoIngresoVariacion($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoVariacion = 0;
		
		$cadenaSql = "select COALESCE(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as saldovariacion
						from sigesp_sfp_cmp 
						inner join spe_int_cuentas on sigesp_sfp_cmp.sig_cuenta=spe_int_cuentas.sig_cuenta and 
								   sigesp_sfp_cmp.codinte=spe_int_cuentas.codinte 
						inner join sfp_dt_cmp_variacion on sigesp_sfp_cmp.codemp=sfp_dt_cmp_variacion.codemp AND sigesp_sfp_cmp.comprobante=sfp_dt_cmp_variacion.comprobante AND
			  				                               sigesp_sfp_cmp.procede=sfp_dt_cmp_variacion.procede 
						where (sfp_dt_cmp_variacion.sig_cuenta like '307%' or sfp_dt_cmp_variacion.sig_cuenta like '311%' 
							   or sfp_dt_cmp_variacion.sig_cuenta like '312%' or sfp_dt_cmp_variacion.sig_cuenta like '313%') 
			                  and sigesp_sfp_cmp.codemp='{$codemp}' AND ano_presupuesto={$annoPresupuesto}";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoVariacion = $dataSet->fields['saldovariacion'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoVariacion;
	}
	
	public function buscarResFinanIngresos($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$totalvariacion        = $this->buscarSaldoIngresoVariacion($codemp, $annoPresupuesto);
		$montoResFinanIngresos = 0;
		
		$cadenaSql = "select (select COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobal 
		 				from spe_plan_ingr  
		 				where codemp='{$codemp}' and ano_presupuesto={$annoPresupuesto} and 
		 				     (spe_plan_ingr.sig_cuenta like '307%' or spe_plan_ingr.sig_cuenta like '311%' or 
		 				     spe_plan_ingr.sig_cuenta like '312%' or spe_plan_ingr.sig_cuenta like '313%'))+({$totalvariacion}) as montoresfinanIng";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoResFinanIngresos = $dataSet->fields['montoresfinanIng'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoResFinanIngresos;
	}
	
	public function buscarSaldoGastoVariacion($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$montoVariacion = 0;
		
		$cadenaSql = "select COALESCE(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as saldovariacion
						from sigesp_sfp_cmp 
							inner join spe_plan_ingr on sigesp_sfp_cmp.sig_cuenta=spe_plan_ingr.sig_cuenta
							inner join sfp_dt_cmp_variacion on sigesp_sfp_cmp.codemp=sfp_dt_cmp_variacion.codemp AND sigesp_sfp_cmp.comprobante=sfp_dt_cmp_variacion.comprobante AND
			  				                                   sigesp_sfp_cmp.procede=sfp_dt_cmp_variacion.procede 
					    where (sfp_dt_cmp_variacion.sig_cuenta like '405%' or sfp_dt_cmp_variacion.sig_cuenta like '411%' 
							   or sfp_dt_cmp_variacion.sig_cuenta like '412%') and spe_plan_ingr.codemp='{$codemp}' and 
							   spe_plan_ingr.ano_presupuesto='{$annoPresupuesto}'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoVariacion = $dataSet->fields['saldovariacion'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoVariacion;
	}
	
	public function buscarResFinanGastos($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$totalvariacion        = $this->buscarSaldoGastoVariacion($codemp, $annoPresupuesto);
		$montoResFinanIngresos = 0;
		
		$cadenaSql = "select (select COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoglobalgas 
		 				from  spe_int_cuentas 
		 				where codemp='{$codemp}' and ano_presupuesto='{$annoPresupuesto}' and 
		 				      (spe_int_cuentas.sig_cuenta like '411%' or spe_int_cuentas.sig_cuenta like '405%' or 
		 				      spe_int_cuentas.sig_cuenta like '412%'))+({$totalvariacion}) as montoresfinanIng";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$montoResFinanIngresos = $dataSet->fields['montoresfinanIng'];
		}
		$dataSet->Close();
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $montoResFinanIngresos;
	}
}