<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_comprobante.php");

class ServicioProgramacionCompra {
	private $servicioComprobante;
	private $daoProgramaArticulo;
	private $daoCuentaGasto;
		
	public function ServicioProgramacionCompra() {
		$this->daoProgramaArticulo = null;
		$this->servicioComprobante = null;
		$this->daoCuentaGasto = null;
	}
	
	public function buscarArticulos($codemp, $codigo, $descripcion ) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "SELECT art.codart, art.denart, art.spg_cuenta, art.ultcosart, COALESCE(car.porcar,0) AS porcar,
		                     art.codigo_unspsc
  						FROM siv_articulo art
							LEFT OUTER JOIN siv_cargosarticulo cart ON art.codemp=cart.codemp AND art.codart=cart.codart
       						LEFT OUTER JOIN sigesp_cargos   car ON art.codemp=car.codemp AND cart.codcar=car.codcar
  						WHERE art.codemp='{$codemp}' AND 
  						      art.codart like '%{$codigo}%' AND 
  						      art.denart like '%{$descripcion}%' 
  						ORDER BY art.codart";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarServicios($codemp, $codigo, $descripcion ) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "SELECT S.codser AS codart, S.denser AS denart, S.preser AS ultcosart, S.spg_cuenta,
							 COALESCE(C.porcar,0) AS porcar, S.codigo_unspsc
  						FROM soc_servicios S
							LEFT OUTER JOIN soc_serviciocargo SC ON S.codemp=SC.codemp AND S.codser=SC.codser 
        					LEFT OUTER JOIN sigesp_cargos C ON S.codemp=C.codemp AND SC.codcar=C.codcar
  						WHERE S.codemp='{$codemp}' AND 
  						      S.codser like '%{$codigo}%' AND 
  						      S.denser like '%{$descripcion}%' 
  						ORDER BY S.codser";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarIPC($codemp, $anPresupuesto, $cuenta) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT enero, febrero, marzo, abril, 
       								 mayo, junio, julio, agosto, septiembre, octubre, noviembre, diciembre 
  								FROM spe_conf_tasas
     							WHERE codemp='{$codemp}' AND ano_presupuesto={$anPresupuesto} AND 
								      cuenta='{$cuenta}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function buscarArticuloProgramado($codemp, $anPresupuesto, $codinte) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT PA.codart, A.denart, sig_cuenta AS spg_cuenta, precio_uni AS ultcosart, 
       								 iva as porcar, tipodist, cantotal, totgeneral as totalgeneral, PA.codunimed, UM.descripcion AS denunimed, codaccion, 
       								 codmoneda, M.descripcion AS denmoneda, codtipoprogramacion, codfuefin, codtipodestino, destino, enero, 
       								 febrero, marzo, abril, mayo, junio, julio, agosto, septiembre, 
       								 octubre, noviembre, diciembre,PA.codigo_unspsc
  								FROM spe_int_arts PA
    								INNER JOIN siv_articulo A ON PA.codart = A.codart
    								INNER JOIN sfp_sncunidadmedida UM ON PA.codunimed = UM.codigo
    								INNER JOIN sfp_sncmoneda M ON PA.codmoneda = M.codigo
     							WHERE PA.codemp='{$codemp}' AND PA.ano_presupuesto={$anPresupuesto} AND 
								      PA.codinte='{$codinte}'
						      UNION
							  SELECT PA.codart, A.denser AS denart, sig_cuenta AS spg_cuenta, precio_uni AS ultcosart, 
       								 iva as porcar, tipodist, cantotal, totgeneral as totalgeneral, PA.codunimed, UM.descripcion AS denunimed, codaccion, 
       								 codmoneda, M.descripcion AS denmoneda, codtipoprogramacion, codfuefin, codtipodestino, destino, enero, 
       								 febrero, marzo, abril, mayo, junio, julio, agosto, septiembre, 
       								 octubre, noviembre, diciembre,PA.codigo_unspsc
  								FROM spe_int_arts PA
    								INNER JOIN soc_servicios A ON PA.codart = A.codser
    								INNER JOIN sfp_sncunidadmedida UM ON PA.codunimed = UM.codigo
    								INNER JOIN sfp_sncmoneda M ON PA.codmoneda = M.codigo
    							WHERE PA.codemp='{$codemp}' AND PA.ano_presupuesto={$anPresupuesto} AND 
								      PA.codinte='{$codinte}'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function buscarMoneda($codmon, $denmon) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codigo AS codmon, descripcion AS denmon
  								FROM sfp_sncmoneda
     							WHERE codigo LIKE '%{$codmon}%' AND descripcion LIKE '%{$denmon}%' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function buscarUnidadMedida($coduni, $denuni) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codigo as codunimed, descripcion as denunimed
  								FROM sfp_sncunidadmedida
     							WHERE codigo LIKE '%{$coduni}%' AND descripcion LIKE '%{$denuni}%' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function buscarMunicipio($estado) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codmunicipio AS coddestino, denmunicipio AS dendestino
  								FROM sfp_sncmunicipio
     							WHERE denestado='{$estado}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function buscarParroquia($estado, $municipio) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codparroquia AS coddestino, denparroquia AS dendestino
  								FROM sfp_sncparroquia
     							WHERE denmunicipio='{$municipio}' AND denestado='{$estado}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function guardarProgramacion($codemp, $anPresupuesto, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoProgramaArticulo = FabricaDao::CrearDAO('N', 'spe_int_arts');
		$this->daoProgramaArticulo->setData($objson);
		$this->daoProgramaArticulo->codemp  = $codemp;
		$this->daoProgramaArticulo->ano_presupuesto = $anPresupuesto;
		$this->daoProgramaArticulo->incluir();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}

		unset($this->daoProgramaArticulo);
		return $procesado;
	}
	
	public function eliminarProgramacion($codemp, $anPresupuesto, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoProgramaArticulo = FabricaDao::CrearDAO('N', 'spe_int_arts');
		$this->daoProgramaArticulo->setData($objson);
		$this->daoProgramaArticulo->codemp  = $codemp;
		$this->daoProgramaArticulo->ano_presupuesto = $anPresupuesto;
		$this->daoProgramaArticulo->eliminar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}

		unset($this->daoProgramaArticulo);
		return $procesado;
	}
	
	public function buscarArticuloSNC($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codigo_unspsc AS codigo, P.descripcion,  cantotal, totgeneral, PA.codunimed, codaccion, 
    								 codmoneda, codtipoprogramacion, codfuefin, codtipodestino, destino, tipodist, enero, 
    								 febrero, marzo, abril, mayo, junio, julio, agosto, septiembre, 
    								 octubre, noviembre, diciembre
  								FROM spe_int_arts PA
  									INNER JOIN sfp_sncproducto P ON PA.codigo_unspsc = P.codigo
     							WHERE PA.codemp='{$codemp}' AND PA.ano_presupuesto={$anPresupuesto}";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	public function generarXmlSNC($valorOrganismo, $valorAnno, $dataArticulos) {
		$objXml = new DOMDocument('1.0', 'ISO-8859-1');
		//Creando el nodo raiz "PROGRAMACION"
		$raizDocumento = $objXml->createElement('PROGRAMACION');
		$objXml->appendChild($raizDocumento);
		
		//Creando los nodos "NOMBREORGANISMO" y "ANO" 
		$organismo     = $objXml->createElement('NOMBREORGANISMO');
		$textOrganismo = $objXml->createTextNode($valorOrganismo);
		$organismo->appendChild($textOrganismo);
		$anno = $objXml->createElement('ANO');
		$textAnno = $objXml->createTextNode($valorAnno);
		$anno->appendChild($textAnno);
		
		//Agregando los nodos "NOMBREORGANISMO" y "ANO" dentro de el nodo raiz "PROGRAMACION" 
		$raizDocumento->appendChild($organismo);
		$raizDocumento->appendChild($anno);
		
		//leer Datos y Crear los nodos "PRODUCTO"
		$numControl = 1;
		while (!$dataArticulos->EOF) {
			//Creando el nodo "PRODUCTO"
			$producto = $objXml->createElement('PRODUCTO');			
			
			//Creando el nodo "CONTROL" - 1er campo del "PRODUCTO"
			$ncontrol    = $objXml->createElement('CONTROL');
			$textControl = $objXml->createTextNode($numControl);
			$ncontrol->appendChild($textControl);
			$producto->appendChild($ncontrol);
			
			//Creando el nodo "ARTICULO" - 2do campo del "PRODUCTO"
			$articulo     = $objXml->createElement('ARTICULO');
			$textArticulo = $objXml->createTextNode($dataArticulos->fields['codigo']);
			$articulo->appendChild($textArticulo);
			$producto->appendChild($articulo);
			
			//Creando el nodo "ACCION"  - 3er campo del "PRODUCTO"
			$accion     = $objXml->createElement('ACCION');
			$textAccion = $objXml->createTextNode($dataArticulos->fields['codaccion']);
			$accion->appendChild($textAccion);
			$producto->appendChild($accion);

			//Creando el nodo "DESCRIPCION" - 4to campo del "PRODUCTO"
			$descripcion     = $objXml->createElement('DESCRIPCION');
			$textDescripcion = $objXml->createTextNode($dataArticulos->fields['descripcion']); 
			$descripcion->appendChild($textDescripcion);
			$producto->appendChild($descripcion);
			
			//Creando el nodo "UNIDAD"  - 5to campo del "PRODUCTO"
			$unidad     = $objXml->createElement('UNIDAD');
			$textUnidad = $objXml->createTextNode($dataArticulos->fields['codunimed']);
			$unidad->appendChild($textUnidad);
			$producto->appendChild($unidad);
			
			//Creando el nodo "MONEDA" - 6to campo del "PRODUCTO"
			$moneda      = $objXml->createElement('MONEDA');
			$textMonenda = $objXml->createTextNode($dataArticulos->fields['codmoneda']);
			$moneda->appendChild($textMonenda);
			$producto->appendChild($moneda);

			//Creando el nodo "CANTIDAD" - 7mo campo del "PRODUCTO"
			$cantidad     = $objXml->createElement('CANTIDAD');
			$textCantidad = $objXml->createTextNode($dataArticulos->fields['cantotal']);
			$cantidad->appendChild($textCantidad);
			$producto->appendChild($cantidad);
			
			//Creando el nodo "MONTO" - 8vo campo del "PRODUCTO"
			$monto     = $objXml->createElement('MONTO');
			$textMonto = $objXml->createTextNode($dataArticulos->fields['totgeneral']);
			$monto->appendChild($textMonto);
			$producto->appendChild($monto);
			
			//Creando el nodo "TIPOPROGRAMACION" - 9no campo del "PRODUCTO"
			$tipoprogramacion     = $objXml->createElement('TIPOPROGRAMACION');
			$textTipoprogramacion = $objXml->createTextNode($dataArticulos->fields['codtipoprogramacion']);
			$tipoprogramacion->appendChild($textTipoprogramacion);
			$producto->appendChild($tipoprogramacion);
			
			//Creando el nodo "FUENTE" - 10mo campo del "PRODUCTO"
			$fuente = $objXml->createElement('FUENTE');
			$textFuente = $objXml->createTextNode($dataArticulos->fields['codfuefin']);
			$fuente->appendChild($textFuente);
			$producto->appendChild($fuente);
			
			//Creando el nodo "MES"  - 11vo campo del "PRODUCTO"
			$mes = $objXml->createElement('MES');
			if ($dataArticulos->fields['tipodist']=='1') {
				$textMes = $objXml->createTextNode('13');
			}
			else {
				$tempTextMes = '';
				if ($dataArticulos->fields['enero']>0) {
					$tempTextMes = '1';
				}
				
				if ($dataArticulos->fields['febrero']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',2';
					}
					else {
						$tempTextMes = '2';
					}
				}
				
				if ($dataArticulos->fields['marzo']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',3';
					}
					else {
						$tempTextMes = '3';
					}
				}
				
				if ($dataArticulos->fields['abril']>0) {
					if ($tempTextMes != '') {
						$tempTextMes = ',4';
					}
					else {
						$tempTextMes = '4';
					}
				}
				
				if ($dataArticulos->fields['mayo']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',5';
					}
					else {
						$tempTextMes = '5';
					}
				}
				
				if ($dataArticulos->fields['junio']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',6';
					}
					else {
						$tempTextMes = '6';
					}
				}
				
				if ($dataArticulos->fields['julio']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',7';
					}
					else {
						$tempTextMes = '7';
					}
				}
				
				if ($dataArticulos->fields['agosto']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',8';
					}
					else {
						$tempTextMes = '8';
					}
				}
				
				if ($dataArticulos->fields['septiembre']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',9';
					}
					else {
						$tempTextMes = '9';
					}
				}
				
				if ($dataArticulos->fields['octubre']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',10';
					}
					else {
						$tempTextMes = '10';
					}
				}
				
				if ($dataArticulos->fields['noviembre']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',11';
					}
					else {
						$tempTextMes = '11';
					}
				}
				
				if ($dataArticulos->fields['diciembre']>0) {
					if ($tempTextMes != '') {
						$tempTextMes .= ',12';
					}
					else {
						$tempTextMes = '12';
					}
				}
				
				$textMes = $objXml->createTextNode($tempTextMes);
			}
			$mes->appendChild($textMes);
			$producto->appendChild($mes);
			
			//Creando el nodo "DESTINOS" - 12vo campo del "PRODUCTO"
			$destinos        = $objXml->createElement('DESTINOS');
			$tipodestino     = $objXml->createElement('TIPO');
			$textTipodestino = $objXml->createTextNode($dataArticulos->fields['codtipodestino']);
			$tipodestino->appendChild($textTipodestino);
			$destinos->appendChild($tipodestino);
			
			$arrDestinos  = explode(',', $dataArticulos->fields['destino']);
			$cantDestinos = count($arrDestinos);
			for ($i = 0; $i < $cantDestinos; $i++) {
				$destino     = $objXml->createElement('DESTINO');
				$textDestino = $objXml->createTextNode($arrDestinos[$i]);
				$destino->appendChild($textDestino);
				$destinos->appendChild($destino);
			}
			$producto->appendChild($destinos);
			
			//Agregando el nodo "PRODUCTO" dentro de el nodo raiz "PROGRAMACION"
			$raizDocumento->appendChild($producto);
			
			$numControl++;
			$dataArticulos->MoveNext();
		}
		
		return $objXml->save('../../base/xml/datos/programacion_compra.xml');
	}
	
	public function obtenerDataFormulacion($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codinte, IA.sig_cuenta, sc_cuenta, sc_cuenta_haber, codcaif, codcaif_haber, SUM(enero*precio_uni) AS enero, SUM(febrero*precio_uni) AS febrero, SUM(marzo*precio_uni) AS marzo, SUM(abril*precio_uni) AS abril, 
       								 SUM(mayo*precio_uni) AS mayo, SUM(junio*precio_uni) AS junio, SUM(julio*precio_uni) AS julio, SUM(agosto*precio_uni) AS agosto, SUM(septiembre*precio_uni) as septiembre, 
       								 SUM(octubre*precio_uni) AS octubre, SUM(noviembre*precio_uni) AS noviembre, SUM(diciembre*precio_uni) AS diciembre, SUM(totgeneral) as total
  								FROM spe_int_arts IA
									INNER JOIN sigesp_sfp_asociacion A ON substr(IA.sig_cuenta,1,9)=A.sig_cuenta 
								WHERE IA.codemp='{$codemp}' AND IA.ano_presupuesto={$anPresupuesto} 	
  								GROUP BY codinte, IA.sig_cuenta, sc_cuenta, sc_cuenta_haber, codcaif, codcaif_haber";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($cadenaSql);
		return $dataSet;
	}
	
	
	public function generarFormulacionGasto($codemp, $anPresupuesto, $dataFormulacion) {
		$procesado = true;
		$this->servicioComprobante = new ServicioComprobante();
		DaoGenerico::iniciarTrans();
		while (!$dataFormulacion->EOF) {
			$this->daoCuentaGasto = FabricaDao::CrearDAO('N', 'spe_int_cuentas');
			$this->daoCuentaGasto->setData(generarJsonFila($dataFormulacion->fields));
			$this->daoCuentaGasto->codemp          = $codemp;
			$this->daoCuentaGasto->ano_presupuesto = $anPresupuesto;
			if($this->daoCuentaGasto->montoanreal==''){
				$this->daoCuentaGasto->montoanreal = 0;
			}
				
			if($this->daoCuentaGasto->montoanant==''){
				$this->daoCuentaGasto->montoanant = 0;
			}
			
			if($this->daoCuentaGasto->incluir()){
				$arrcabecera['codemp'] = $codemp;
	 			$arrcabecera['comprobante'] = $this->servicioComprobante->buscarCodigoComprobante($codemp);
				$arrcabecera['fecha'] = date('Y-m-d');
				$arrcabecera['annoPresupuesto'] = $anPresupuesto;
				$arrcabecera['procede']='SFPCMG';
				$arrcabecera['sig_cuenta']=$dataFormulacion->fields['sig_cuenta'];
				$arrcabecera['descripcion']='Formulacion de presupuesto de gastos';
				$arrcabecera['tipo_comp']= '1';
				$arrcabecera['tipo_destino']='N';
				$arrcabecera['codinte']= $dataFormulacion->fields['codinte'];
				
				if(!$this->servicioComprobante->existeComprobante($arrcabecera['codemp'], $arrcabecera['procede'], $arrcabecera['comprobante'], $arrcabecera['fecha'], $arrcabecera['annoPresupuesto'])){
					$arrdetalle[1]['documento']='0000';
					$arrdetalle[1]['debhab']='D';
					$arrdetalle[1]['sc_cuenta']=$dataFormulacion->fields['sc_cuenta'];
					$arrdetalle[1]['monto']=$dataFormulacion->fields['total'];
					$arrdetalle[2]['documento']='0000';
					$arrdetalle[2]['debhab']='H';
					$arrdetalle[2]['sc_cuenta']=$dataFormulacion->fields['sc_cuenta_haber'];
					$arrdetalle[2]['monto']=$dataFormulacion->fields['total'];
					
					$this->servicioComprobante->guardarComprobante($arrcabecera, $arrdetalle);
				}
				
				//COMPROBANTE CAIF 
				$arrcabeceraCAIF['codemp']          = $codemp;
		 		$arrcabeceraCAIF['comprobante']     = $this->servicioComprobante->buscarCodigoComprobante($codemp);
				$arrcabeceraCAIF['fecha']           = date('Y-m-d');
				$arrcabeceraCAIF['annoPresupuesto'] = $anPresupuesto;
				$arrcabeceraCAIF['procede']         = 'SFPCFG'; //PROCEDE COMPROBANTE CAIF DE GASTOS
				$arrcabeceraCAIF['sig_cuenta']      = $dataFormulacion->fields['sig_cuenta'];
				$arrcabeceraCAIF['descripcion']     = 'Formulacion de presupuesto de gasto CAIF';
				$arrcabeceraCAIF['tipo_comp']       = '1';
				$arrcabeceraCAIF['tipo_destino']    = 'N';
				$arrcabeceraCAIF['codinte']         = $dataFormulacion->fields['codinte'];
				
				if(!$this->servicioComprobante->existeComprobante($arrcabeceraCAIF['codemp'], $arrcabeceraCAIF['procede'], $arrcabeceraCAIF['comprobante'], $arrcabeceraCAIF['fecha'], $arrcabeceraCAIF['annoPresupuesto'])){
					$arrdetalleCAIF[0]['sig_cuenta'] = $dataFormulacion->fields['codcaif'];
					$arrdetalleCAIF[0]['debhab']    = 'D';
					$arrdetalleCAIF[0]['monto']     = $dataFormulacion->fields['total'];
					
					$arrdetalleCAIF[1]['sig_cuenta'] = $dataFormulacion->fields['codcaif_haber'];
					$arrdetalleCAIF[1]['debhab']    = 'H';
					$arrdetalleCAIF[1]['monto']     = $dataFormulacion->fields['total'];
					
					$this->servicioComprobante->guardarComprobanteCAIF($arrcabeceraCAIF, $arrdetalleCAIF);
				}
				
				
			}
			else {
				break;
			}
			
			$dataFormulacion->MoveNext();
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
			    	
		return $procesado;
	}
}