<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_iplancuenta.php");

class ServicioPlanCuenta implements IPlanCuenta {
	private $daoPlanCuenta;
	private $formpre;
	private $formspi;
	
	public function ServicioPlanCuenta() {
		$this->daoPlanCuenta = null;
	}
	
	public function buscarPlanCuenta($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql ="select sigesp_sfp_plancuentas.monto_anreal,sigesp_sfp_plancuentas.estatus,sigesp_sfp_plancuentas.monto_anest,
       					sigesp_sfp_plancuentas.sig_cuenta as codcuenta,sigesp_sfp_plancuentas.denominacion as dencuenta,sigesp_sfp_plancuentas.estatus,
       					coalesce(s1.sc_cuenta,sigesp_sfp_plancuentas.sig_cuenta) as codigodebe,
						coalesce(s1.denominacion,sigesp_sfp_plancuentas.denominacion) as dendebe,
       					coalesce(s2.sc_cuenta,'No Disponible') as codigohaber,
						s2.denominacion as denhaber,
       					coalesce(sigesp_sfp_asociacion.codcaif,'No Disponible') as codcaif ,
       					sigesp_sfp_asociacion.codcaif  as codvardebe,
       					coalesce(s3.desplacaif,caif1.desplacaif)  as denvardebe,
       					sigesp_sfp_asociacion.codcaif_haber as codvarhaber,
       					coalesce(s4.desplacaif,caif1.desplacaif) as denvarhaber
					from sigesp_sfp_plancuentas 
						inner join sigesp_sfp_asociacion on substr(sigesp_sfp_plancuentas.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta 
						left outer join sigesp_plan_unico_caif as caif1 on caif1.codplacaif=sigesp_sfp_asociacion.codcaif
						left outer join sigesp_sfp_plan_unico s1 on s1.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta 
						inner join sigesp_sfp_plan_unico s2 on s2.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta_haber 
						left outer join sigesp_plan_unico_caif s3 on s3.codplacaif=sigesp_sfp_asociacion.codcaif 
						left outer join sigesp_plan_unico_caif s4 on s4.codplacaif=sigesp_sfp_asociacion.codcaif_haber
					where  sigesp_sfp_plancuentas.codemp='{$codemp}' and sigesp_sfp_plancuentas.ano_presupuesto={$anPresupuesto} 
					order by sigesp_sfp_plancuentas.sig_cuenta asc";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function obtenerCantidadDigitosCuenta() {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select sig_cuenta from sigesp_plan_unico_re limit 1"; 		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		$cantidadDigitos = strlen(trim($dataSet->fields["sig_cuenta"]));
		unset($conexionBaseDatos);
		unset($dataSet);
		return $cantidadDigitos;
	}
	
	public function obtenerCuentaPlanGeneral($criterio, $valor) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select sigesp_sfp_asociacion.sig_cuenta as codcuenta,sigesp_plan_unico_re.denominacion
			as dencuenta,sigesp_sfp_asociacion.estatus,
                        coalesce(s1.sc_cuenta,sigesp_sfp_asociacion.sig_cuenta) as codigodebe,
			coalesce(s1.denominacion,sigesp_plan_unico_re.denominacion) as dendebe,
                        coalesce(s2.sc_cuenta,'No Disponible') as codigohaber,
			s2.denominacion as denhaber,
			coalesce(sigesp_sfp_asociacion.codcaif,'No Disponible') as codcaif ,
			coalesce(sigesp_sfp_asociacion.codcaif,'No Disponible')  as codvardebe,
			coalesce(caif1.desplacaif,'No Disponible')  as denvardebe,
			coalesce(sigesp_sfp_asociacion.codcaif_haber,'No Disponible') as codvarhaber ,
			coalesce(caif2.desplacaif,'No Disponible') as denvarhaber 		
			from sigesp_sfp_asociacion inner join
			sigesp_plan_unico_re on sigesp_sfp_asociacion.sig_cuenta=sigesp_plan_unico_re.sig_cuenta
			left outer join sigesp_plan_unico_caif as caif1 on caif1.codplacaif=sigesp_sfp_asociacion.codcaif
			left outer join sigesp_plan_unico_caif as caif2 on caif2.codplacaif=sigesp_sfp_asociacion.codcaif_haber
			left outer join sigesp_sfp_plan_unico s1 on s1.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta 
            left outer join sigesp_sfp_plan_unico s2 on s2.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta_haber   
			where sigesp_sfp_asociacion.estatus='C' and upper(sigesp_plan_unico_re.{$criterio}) like upper('{$valor}%'
			) order by sigesp_plan_unico_re.sig_cuenta asc";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function guardarPlanCuenta($codemp, $anPresupuesto, $arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->buscarFormatoCuenta($codemp);
		foreach ($arrjson->registros as $regCuenta) {
			$codigoCuenta   = $regCuenta->sig_cuenta;
			$longitudCuenta = strlen(trim($codigoCuenta));
			$grupoCuenta = substr($codigoCuenta,0,1);
			if($grupoCuenta=='3') {
				$formatoCuenta = $this->formspi;
			}
			else {
				$formatoCuenta = $this->formpre;
			}
			$arrNiveles = $this->obtenerNiveles($formatoCuenta);
			$longitudFormatoCuenta = strlen(trim(str_replace("-","",$formatoCuenta)));
			
			if($arrNiveles["cantidad"]==4) {
				$auxtotal = $arrNiveles["cantidad"];
			}
			elseif($arrNiveles["cantidad"]==5 && $longitudCuenta=='9') {
				$auxtotal = $arrNiveles["cantidad"]-1;
			}
			elseif($arrNiveles["cantidad"]==5 && $longitudCuenta!='9') {
				$auxtotal = $arrNiveles["cantidad"];
			}
			
			for($i=0;$i<$auxtotal;$i++){
				$acuNiveles = $acuNiveles+strlen($arrNiveles["niveles"][$i]); 
				$acuNivelAnt = $acuNivelAnt+strlen($arrNiveles["niveles"][$i-1]);
				$auxcuenta1 = substr($codigoCuenta,0,$acuNiveles);
				$auxcuentaref = substr($codigoCuenta,0,$acuNivelAnt);
				
				if($this->verificarHijas($auxcuenta1)) {
					$estatus = "S";
				}
				else {
					$estatus = "C";
				}
				//echo $longitudFormatoCuenta."-";
				$cuentaReg = str_pad(trim($auxcuenta1),$longitudFormatoCuenta,"0");
				if($auxcuentaref!="") {
					$cuentaReferencia = str_pad(trim($auxcuentaref),$longitudFormatoCuenta,"0");	
				}
				else {
					$cuentaReferencia="";
				}
				
				if(!$this->existeCuenta($cuentaReg, $codemp, $anPresupuesto)) {
					$denominacion = trim($this->obtenerDenominacion($cuentaReg));
					$this->daoPlanCuenta = FabricaDao::CrearDAO('N', 'sigesp_sfp_plancuentas');
					$this->daoPlanCuenta->codemp           = $codemp;
					$this->daoPlanCuenta->ano_presupuesto  = $anPresupuesto;
					$this->daoPlanCuenta->sig_cuenta       = $cuentaReg;
					$this->daoPlanCuenta->nivel            = $i+1;
					$this->daoPlanCuenta->referencia       = $cuentaReferencia;
					$this->daoPlanCuenta->denominacion     = $denominacion;
					$this->daoPlanCuenta->estatus          = $estatus;
					
					if(!$this->daoPlanCuenta->incluir()) {
						return false;
					}

					unset($this->daoPlanCuenta);
				}
			}
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function eliminarCuenta($codemp, $anpresupuesto, $arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoPlanCuenta = FabricaDao::CrearDAO('N', 'sigesp_sfp_plancuentas');
		$this->daoPlanCuenta->codemp          = $codemp;
		$this->daoPlanCuenta->ano_presupuesto = $anpresupuesto;
		$this->daoPlanCuenta->sig_cuenta      = $arrjson->sig_cuenta;
		$this->daoPlanCuenta->estatus         = $arrjson->estatus;
		
		$this->daoPlanCuenta->eliminar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;;
	}
	
	public function buscarFormatoCuenta($codemp) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select formspi, formpre  
						from sfp_empresa
						where codemp ='{$codemp}'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		if (!$dataSet->EOF) {
			$this->formpre = $dataSet->fields['formpre'];
			$this->formspi = $dataSet->fields['formspi'];
		}
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $formato;
	}
	
	public function obtenerNiveles($formato) {
		$li_count=0;
		$i=0;
		$arr=str_split($formato);
		$arr2=explode("-",$formato);
		$tot=count($arr);
		for($i=0;$i<$tot;$i++) 
		{
			if($arr[$i]=="-")
			{
				$li_count=$li_count+1;
			}
		}
		$arr=array("cantidad"=>$li_count+1,"niveles"=>$arr2);
	    return $arr;	
	}
	
	public function verificarHijas($cuenta) {
		$tieneHijas = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select sig_cuenta 
						from sigesp_plan_unico_re 
						where sig_cuenta like '{$cuenta}%'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		if ($dataSet->RecordCount()>1) {
			$tieneHijas = true;
		}
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $tieneHijas;
	}
	
	public function existeCuenta($cuenta,$codemp,$anPresupuesto) {
		$existe = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select sig_cuenta 
						from sigesp_sfp_plancuentas 
						where sig_cuenta='{$cuenta}' and
						      codemp='{$codemp}' and
						      ano_presupuesto={$anPresupuesto}";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		
		if (!$dataSet->EOF) {
			$existe = true;
		}
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $existe;
	}
	
	public function obtenerDenominacion($cuenta) {
		$existe = false;
		$cuenta = $this->convertirFormatoPlan($cuenta);
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select denominacion
						from sigesp_plan_unico_re 
						where sig_cuenta='".$cuenta."'";		
		$dataSet       = $conexionBaseDatos->Execute ( $cadenaSql );
		$denominacion  = $dataSet->fields['denominacion'];
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $denominacion;
	}
	
	public function convertirFormatoPlan($cuenta) {
		$formatos = $this->obtenerFormatoCuenta();
		$longitudPlan = strlen(trim(str_replace("-","",$formatos->fields['formplan'])));
		$cuentaFormateada = substr(trim($cuenta), 0, $longitudPlan);
		$cuentaFormateada = str_pad(trim($cuentaFormateada),$longitudPlan,"0");
		
		return $cuentaFormateada;
	}
	
	public function buscarCuentasContables(){
		$cadenaSql         = "select sc_cuenta as codigo,denominacion from sigesp_plan_unico";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function obtenerGrupoCuenta($cuenta, $cuentacomp) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select sig_cuenta 
								from sigesp_plan_unico_re 
								where sig_cuenta like '{$cuenta}%' or sig_cuenta ='{$cuentacomp}' 
								order by sig_cuenta";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function obtenerFormatoCuenta() {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select formspi, formplan, formpre from sigesp_empresa";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function obtenerDigitoNiveles() {
		$Rs = $this->obtenerFormatoCuenta();
		$arrPosiciones = explode("-",$Rs->fields["formpre"]);		
		$numPosiciones = count($arrPosiciones);
		$pos1= strlen($arrPosiciones[0]);
		$pos2= $pos1+1;
		$pos3=$pos2+2;
		$pos4=$pos3+2; 
		$anterior=0;
		for($i=1;$i<=$numPosiciones;$i++){
			$arNiveles[$i]=$anterior+strlen($arrPosiciones[$i-1]);
			$anterior=$arNiveles[$i];
		}
		return $arNiveles;
	}
	
	public function verificarCuenta($cuenta, $nivelCuenta) {
		$cuentasincero = uf_spg_cuenta_sin_cero($cuenta);
		$arr = $this->obtenerDigitoNiveles();
		if($this->verificarHijas($cuentasincero)) {
			$cantidadDigitos=strlen($cuentasincero);
		}
		else {
			$cantidadDigitos=strlen(trim($cuenta));
		}
		$arrAnteriores=array();
		foreach($arr as $nivel=>$numerodedigitos){
			if($numerodedigitos==$cantidadDigitos){
				for($i=1;$i<$nivelCuenta;$i++){
					$arrAnteriores[$i]=$i;	
				}
				$niveldelacuenta= $nivel;
				break;
			}
		}
	
		if($niveldelacuenta==$nivelCuenta or array_search($niveldelacuenta,$arrAnteriores)){
			return true;
		}
		else{
			return false;
		}
	}
	
	public function procesarCuenta($codemp,$anPresupuesto,$arrJson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		if ($this->existeCuenta($arrJson->sig_cuenta, $codemp, $anPresupuesto)) {
			$cadenafiltro = "codemp='{$codemp}' AND ano_presupuesto={$anPresupuesto} AND sig_cuenta='{$arrJson->sig_cuenta}'";
			$this->daoPlanCuenta = FabricaDao::CrearDAO('C', 'sigesp_sfp_plancuentas',null,$cadenafiltro);
			$this->daoPlanCuenta->denominacion = $arrJson->denominacion;
			$this->daoPlanCuenta->modificar();
		}
		else {
			//OJO INCLUIR NUEVA CUENTA EN EL PLAN....
			/*$this->DAO = FabricaDao::CrearDAO($tipo, $tabla);
			$this->daoPlanCuenta = FabricaDao::CrearDAO('N', 'sigesp_sfp_plancuentas');
			$this->daoPlanCuenta->codemp           = $codemp;
			$this->daoPlanCuenta->ano_presupuesto  = $anPresupuesto;
			$this->daoPlanCuenta->sig_cuenta       = $cuentaReg;
			$this->daoPlanCuenta->nivel            = $i+1;
			$this->daoPlanCuenta->referencia       = $cuentaReferencia;
			$this->daoPlanCuenta->denominacion     = $denominacion;
			$this->daoPlanCuenta->estatus          = $estatus;*/
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
			    	
		return $procesado;
	}
	
	public function obtenerGrupoPlanCuenta($codemp, $anPresupuesto, $digitoCuenta, $arrexcepcion) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaFiltro = '';
		foreach ($arrexcepcion as $excepcion) {
			$cadenaFiltro =  $cadenaFiltro." and sig_cuenta not like '{$excepcion}%' ";
		}
		$cadenaSql         = "select sig_cuenta 
								from sigesp_sfp_plancuentas 
								where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
								      sig_cuenta like '{$digitoCuenta}%' {$cadenaFiltro}  
								order by sig_cuenta";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		unset($arrexcepcion);
		unset($cadenaSql);
		unset($cadenaFiltro);
		return $dataSet;
	}
	
	
	public function cantidadDigitosNivel($formato, $nivel) {
		$arrNiveles = explode("-",$formato);
		$cantidad = 0;
		
		for ($i = 0; $i <= $nivel-1; $i++) {
			$cantidad = $cantidad + strlen($arrNiveles[$i]);
		}
		
		unset($arrNiveles);
		return $cantidad;
	}
	
	
	public function verificarNivelCuenta($codemp, $cuenta, $nivel, $tipoPresupuesto) {
		$nivelValido    = false;
		$cantidadDigito = 0; 
		$this->buscarFormatoCuenta($codemp);
		$cantidadDigitoTotal = strlen($cuenta);
		
		if ($tipoPresupuesto == 'I') {
			$cantidadDigito = $this->cantidadDigitosNivel($this->formspi, $nivel);
		}
		elseif ($tipoPresupuesto == 'G'){
			$cantidadDigito = $this->cantidadDigitosNivel($this->formpre, $nivel);
		}
		
		$claveValidar   = substr($cuenta, $cantidadDigito, $cantidadDigitoTotal);
		$datoValidador  = str_pad('',$cantidadDigitoTotal-$cantidadDigito,0,0);
		
		if ($claveValidar == $datoValidador) {
			$nivelValido=true;
		}
		
		return $nivelValido;
	}
	
	public function buscarPlanCuentaInstitucion($paramentros) {
		$this->daoPlanCuenta = FabricaDao::CrearDAO('N', 'sigesp_sfp_plancuentas');
		$dataSet  = $this->daoPlanCuenta->buscarCampoRestriccion($paramentros);
		unset($this->daoPlanCuenta);
		return $dataSet;
	}
}
?>