<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_iindicador.php");

class ServicioIndicador implements IIndicador{
	private $daoIndicador;
	
	public function ServicioIndicador() {
		$this->daoIndicador = null;
	}
	
	public function buscarCodigoIndicador($codemp) {
		$this->daoIndicador = FabricaDao::CrearDAO('N', 'sig_indicador');
		$this->daoIndicador->codemp  = $codemp;
		$codigo = $this->daoIndicador->buscarCodigo('cod_ind',true,4);
		
		unset($this->daoIndicador);
		return $codigo;
	}
	
	public function incluirIndicador($codemp, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoIndicador = FabricaDao::CrearDAO('N', 'sig_indicador');
		$this->daoIndicador->setData($objson);
		$this->daoIndicador->codemp  = $codemp;
		$this->daoIndicador->incluir();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function buscarIndicadores($codemp) {
		$this->daoIndicador = FabricaDao::CrearDAO('N', 'sig_indicador');
		$this->daoIndicador->codemp  = $codemp;
		$dataMeta = $this->daoIndicador->leerTodos('cod_ind',1,$codemp);
		
		unset($this->daoIndicador);
		return $dataMeta;
	}
	
	public function modificarIndicador($codemp, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoIndicador = FabricaDao::CrearDAO('N', 'sig_indicador');
		$this->daoIndicador->setData($objson);
		$this->daoIndicador->codemp          = $codemp;
		$this->daoIndicador->modificar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function eliminarIndicador($codemp, $objson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoIndicador = FabricaDao::CrearDAO('N', 'sig_indicador');
		$this->daoIndicador->setData($objson);
		$this->daoIndicador->codemp          = $codemp;
		$this->daoIndicador->eliminar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
}