<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_iformulacioningreso.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_plancuenta.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_comprobante.php");

class ServicioFormulacionIngreso implements IFormulacionIngreso {
	private $daoPlanIngreso;
	private $daoMovimientoComprobante;
	private $servicioPlanCuenta;
	private $cantidadDigitosCuenta;
	private $servicioComprobante;
	
	
	public function ServicioFormulacionIngreso() {
		$this->daoPlanIngreso =  null;
		$this->daoComprobante =  null;
		$this->daoMovimientoComprobante = null;
		$this->servicioComprobante = null;
		$this->servicioPlanCuenta = new ServicioPlanCuenta();
		$this->cantidadDigitosCuenta = $this->servicioPlanCuenta->obtenerCantidadDigitosCuenta();
		
		unset($this->servicioPlanCuenta);
	}
	
	public function buscarCuentaDistribucion($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select distinct cuentaporcobrar,enero,febrero,marzo,abril,mayo,junio,julio,agosto,septiembre,octubre,noviembre,diciembre
			,enerocob,febrerocob,marzocob,abrilcob,mayocob,juniocob,juliocob,agostocob,septiembrecob,octubrecob,noviembrecob,diciembrecob
		  ,spe_plan_ingr.ano_presupuesto,sigesp_sfp_plancuentas.sig_cuenta,sigesp_sfp_plancuentas.denominacion,
			coalesce(sum(spe_int_cuentas_dtrecursos.montoasig),0) as distribuido,
			(spe_plan_ingr.enero+spe_plan_ingr.febrero
			+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio
			+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre
			+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as montoglobal,
			(spe_plan_ingr.enerocob+spe_plan_ingr.febrerocob
			+spe_plan_ingr.marzocob+spe_plan_ingr.abrilcob+spe_plan_ingr.mayocob+spe_plan_ingr.juniocob
			+spe_plan_ingr.juliocob+spe_plan_ingr.agostocob+spe_plan_ingr.septiembrecob
			+spe_plan_ingr.octubrecob+spe_plan_ingr.noviembrecob+spe_plan_ingr.diciembrecob) as montoglobalcob,			
			(spe_plan_ingr.enero+spe_plan_ingr.febrero
			+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio
			+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre
			+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)-coalesce(sum(spe_int_cuentas_dtrecursos.montoasig),0) as disponible
			from spe_plan_ingr 
			inner join sigesp_sfp_plancuentas on spe_plan_ingr.sig_cuenta=sigesp_sfp_plancuentas.sig_cuenta and
                                      spe_plan_ingr.codemp=sigesp_sfp_plancuentas.codemp and
                                      spe_plan_ingr.ano_presupuesto=sigesp_sfp_plancuentas.ano_presupuesto 
			inner join sigesp_plan_unico_re sigesp_plan_unico_re on substr(spe_plan_ingr.sig_cuenta,1,{$this->cantidadDigitosCuenta})=sigesp_plan_unico_re.sig_cuenta
			left outer join spe_int_cuentas_dtrecursos on spe_plan_ingr.sig_cuenta=spe_int_cuentas_dtrecursos
			.sig_cuenta_ing and spe_plan_ingr.ano_presupuesto=spe_int_cuentas_dtrecursos
			.ano_presupuesto and spe_plan_ingr.codemp=spe_int_cuentas_dtrecursos
			.codemp where spe_plan_ingr.codemp='{$codemp}' and spe_plan_ingr.ano_presupuesto={$anPresupuesto}  
			group by  cuentaporcobrar,sigesp_sfp_plancuentas.sig_cuenta,sigesp_sfp_plancuentas.denominacion,spe_plan_ingr.ano_presupuesto,
			spe_plan_ingr.enero,spe_plan_ingr.febrero, spe_plan_ingr.marzo, spe_plan_ingr.abril, spe_plan_ingr
			.mayo, spe_plan_ingr.junio, spe_plan_ingr.julio, spe_plan_ingr.agosto, spe_plan_ingr.septiembre, spe_plan_ingr
			.octubre, spe_plan_ingr.noviembre, spe_plan_ingr.diciembre,enerocob,febrerocob,marzocob,abrilcob,mayocob,juniocob,juliocob,agostocob,septiembrecob,octubrecob,noviembrecob,diciembrecob";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarCuenta($codemp, $anPresupuesto, $campo, $valor) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select sigesp_sfp_plancuentas.monto_anreal,
		                     sigesp_sfp_plancuentas.monto_anest,
		                     sigesp_sfp_plancuentas.sig_cuenta as codigo,
		                     sigesp_sfp_plancuentas.denominacion as denominacion,
		                     sigesp_sfp_plancuentas.estatus,
		                     s1.denominacion as dendebe,
		                     s2.denominacion as denhaber,
		                     s1.sc_cuenta as codigodebe,
		                     s2.sc_cuenta as codigohaber,
							 coalesce(sigesp_sfp_asociacion.codcaif,'No Disponible') as codcaif ,
							 coalesce(sigesp_sfp_asociacion.codcaif,'No Aplica')  as codvardebe,
							 coalesce(s3.desplacaif,'No Aplica')  as denvardebe,
							 coalesce(sigesp_sfp_asociacion.codcaif_haber,'No Aplica') as codvarhaber ,
							 coalesce(s4.desplacaif,'No Aplica') as denvarhaber 		
						from sigesp_sfp_asociacion
							inner join sigesp_sfp_plancuentas on substr(sigesp_sfp_plancuentas.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta
							left outer join sigesp_plan_unico_caif as caif1 on caif1.codplacaif=sigesp_sfp_asociacion.codcaif
							inner join sigesp_sfp_plan_unico s1 on s1.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta 
							inner join sigesp_sfp_plan_unico s2 on s2.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta_haber  
							left outer join sigesp_plan_unico_caif s3 on s3.codplacaif=sigesp_sfp_asociacion.codcaif 
							left outer join sigesp_plan_unico_caif s4 on s4.codplacaif=sigesp_sfp_asociacion.codcaif_haber
						where sigesp_sfp_asociacion.estatus='C' and 
						      sigesp_sfp_plancuentas.sig_cuenta like '3%' and 
						      sigesp_sfp_plancuentas.{$campo} like '{$valor}%' and 
						      sigesp_sfp_plancuentas.codemp='{$codemp}' and 
						      sigesp_sfp_plancuentas.ano_presupuesto={$anPresupuesto}
						order by sigesp_sfp_asociacion.sig_cuenta asc";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function guardarPlanIngreso($codemp, $anPresupuesto, $arrjson) {
		$this->daoPlanIngreso = FabricaDao::CrearDAO('N', 'spe_plan_ingr');
		$this->daoPlanIngreso->setData($arrjson);
		$this->daoPlanIngreso->codemp = $codemp;
		$this->daoPlanIngreso->ano_presupuesto = $anPresupuesto;
		$respuesta = $this->daoPlanIngreso->incluir();
		unset($this->daoPlanIngreso);
		return $respuesta;
	}
	
	public function procesarFormulacionIngreso($codemp, $anPresupuesto, $arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->servicioComprobante = new ServicioComprobante();
		//guardando formulacion ingreso
		foreach ($arrjson->DatosIng as $registroIngreso) {
			$this->guardarPlanIngreso($codemp, $anPresupuesto, $registroIngreso);
		}
		
		//COMPROBANTE CONTABLE
		$arrcabecera['codemp']          = $codemp;
 		$arrcabecera['comprobante']     = $this->servicioComprobante->buscarCodigoComprobante($codemp);
		$arrcabecera['fecha']           = date('Y-m-d');
		$arrcabecera['annoPresupuesto'] = $anPresupuesto;
		$arrcabecera['procede']         = 'SFPCMI';
		$arrcabecera['sig_cuenta']      = $registroIngreso->sig_cuenta;
		$arrcabecera['descripcion']     = 'Formulacion de presupuesto de ingresos';
		$arrcabecera['tipo_comp']       = '1';
		$arrcabecera['tipo_destino']    = 'N';
		$arrcabecera['codinte']         = '-1';
				
		//insertar detalles comprobante contable
		$j=0;
		foreach ($arrjson->movimientos as $detalleContable) {
			$cuenta    = $detalleContable->sc_cuenta;
			$operacion = $detalleContable->operacion;
			$monto     = $detalleContable->monto;
			
			if ($operacion=='Debe') {
				$operacion='D';
			}
			else {
				$operacion='H';
			}
			$arrdetalle[$j]['documento']='0000';
			$arrdetalle[$j]['debhab']=$operacion;
			$arrdetalle[$j]['sc_cuenta']=$cuenta;
			$arrdetalle[$j]['monto']=$monto;
			$j++;			
		}
		
		if(!$this->servicioComprobante->existeComprobante($arrcabecera['codemp'], $arrcabecera['procede'], $arrcabecera['comprobante'], $arrcabecera['fecha'], $arrcabecera['annoPresupuesto'])){
			$this->servicioComprobante->guardarComprobante($arrcabecera, $arrdetalle);
		}
		//FIN COMPROBANTE CONTABLE*/
		
		//COMPROBANTE CAIF 
		$arrcabeceraCAIF['codemp']          = $codemp;
 		$arrcabeceraCAIF['comprobante']     = $this->servicioComprobante->buscarCodigoComprobante($codemp);
		$arrcabeceraCAIF['fecha']           = date('Y-m-d');
		$arrcabeceraCAIF['annoPresupuesto'] = $anPresupuesto;
		$arrcabeceraCAIF['procede']         = 'SFPCFI'; //PROCEDE ASIENTO CAIF DE INGRESOS
		$arrcabeceraCAIF['sig_cuenta']      = $registroIngreso->sig_cuenta;
		$arrcabeceraCAIF['descripcion']     = 'Formulacion de presupuesto de ingresos CAIF';
		$arrcabeceraCAIF['tipo_comp']       = '1';
		$arrcabeceraCAIF['tipo_destino']    = 'N';
		$arrcabeceraCAIF['codinte']         = '-1';
		
		$cuentaCAIF = $this->buscarCuentasCAIF($registroIngreso->sig_cuenta);
		if(!$cuentaCAIF->EOF){
			$arrdetalleCAIF[0]['sig_cuenta'] = $cuentaCAIF->fields['codcaif'];
			$arrdetalleCAIF[0]['debhab']    = 'D';
			$arrdetalleCAIF[0]['monto']     = $monto;
			
			$arrdetalleCAIF[1]['sig_cuenta'] = $cuentaCAIF->fields['codcaif_haber'];
			$arrdetalleCAIF[1]['debhab']    = 'H';
			$arrdetalleCAIF[1]['monto']     = $monto;
		}
		
		//print_r($arrcabeceraCAIF);
		if(!$this->servicioComprobante->existeComprobante($arrcabeceraCAIF['codemp'], $arrcabeceraCAIF['procede'], $arrcabeceraCAIF['comprobante'], $arrcabeceraCAIF['fecha'], $arrcabeceraCAIF['annoPresupuesto'])){
			$this->servicioComprobante->guardarComprobanteCAIF($arrcabeceraCAIF, $arrdetalleCAIF);
		}
		//FIN COMPROBANTE CAIF*/
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		
		return $procesado;
	}
	
	public function buscarCuentasCAIF($cuenta) {
		$cuenta = substr($cuenta, 0, 9);
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codcaif, codcaif_haber
								FROM sigesp_sfp_asociacion
								WHERE sig_cuenta = '{$cuenta}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function obtenerCuentaTrimestre($codemp, $anPresupuesto, $cuenta) {
		$this->servicioPlanCuenta =  new ServicioPlanCuenta();
		$cuentasinceros=uf_spg_cuenta_sin_cero(trim($cuenta));
		if($cuentasinceros==""){
			$cuentasinceros=trim($cuenta);
		}
		$Rs = $this->servicioPlanCuenta->obtenerFormatoCuenta();
		$arrPosiciones = explode("-",$Rs->fields["formpre"]);		
		$numPosiciones = count($arrPosiciones);
		$pos1= strlen($arrPosiciones[0]);
		$pos2= $pos1+1;
		$pos3=$pos2+2;
		$pos4=$pos3+2; 
		$cadenaSql="select (select denominacion from sigesp_plan_unico_re where sig_cuenta = '{$cuenta}') as denominacion, (select substr(sigesp_plan_unico_re.sig_cuenta,1,".strlen($arrPosiciones[0]).") from sigesp_plan_unico_re where sig_cuenta = '{$cuenta}') as ramo,(select substr(sigesp_plan_unico_re.sig_cuenta,".$pos2.",".strlen($arrPosiciones[1]).") from sigesp_plan_unico_re where sig_cuenta = '{$cuenta}') as subramo,(select substr(sigesp_plan_unico_re.sig_cuenta,".$pos3.",".strlen($arrPosiciones[2]).") from sigesp_plan_unico_re where sig_cuenta = '{$cuenta}') as especifica, (select substr(sigesp_plan_unico_re.sig_cuenta,".$pos4.",".strlen($arrPosiciones[3]).") from sigesp_plan_unico_re where sig_cuenta = '{$cuenta}') as subespecifica,
				 sum(sigesp_sfp_plancuentas.monto_anest) as monto_anest,sum(sigesp_sfp_plancuentas.monto_anreal) as monto_anreal, COALESCE(sum(enero),0000) as enero,COALESCE(sum(febrero),000)as febrero,COALESCE(sum(marzo),000) as marzo , COALESCE(sum(abril),000) as abril,COALESCE(sum(mayo),000)as mayo,COALESCE(sum(junio),000) as junio,
				 COALESCE(sum(julio),0000)as julio ,COALESCE(sum(agosto),000) as agosto,COALESCE(sum(septiembre),000) as septiembre, COALESCE(sum(octubre),000) as octubre,COALESCE(sum(noviembre),000) as noviembre,COALESCE(sum(diciembre),000) as diciembre,
				 COALESCE(sum((enero+febrero)),0000) as bimestre1,COALESCE(sum((marzo+abril)),000) as bimestre2,COALESCE(sum((mayo+junio)),000) as bimestre3, COALESCE(sum((julio+agosto)),000) as bimestre4,COALESCE(sum((septiembre+octubre)),000) as bimestre5,COALESCE(sum((noviembre+diciembre)),000) as bimestre6,
				 COALESCE(sum((enero+febrero+marzo)),0000) as trimestre1,COALESCE(sum((abril+mayo+junio)),000) as trimestre2,COALESCE(sum((julio+agosto+septiembre)),000) as trimestre3, COALESCE(sum((octubre+noviembre+diciembre)),000) as trimestre4,
				 COALESCE(sum((enero+febrero+marzo+abril+mayo+junio)),0000) as semestre1, COALESCE(sum((julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as semestre4,
				 COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobalgas 
				 from spe_plan_ingr 
				 inner join sigesp_plan_unico_re on substr(spe_plan_ingr.sig_cuenta,1,9) = sigesp_plan_unico_re.sig_cuenta 
				 inner join sigesp_sfp_plancuentas on sigesp_sfp_plancuentas.codemp=spe_plan_ingr.codemp and  
				                                      sigesp_sfp_plancuentas.ano_presupuesto=spe_plan_ingr.ano_presupuesto 
				                                      and  spe_plan_ingr.sig_cuenta=sigesp_sfp_plancuentas.sig_cuenta
				 where spe_plan_ingr.codemp = '{$codemp}' and 
				 spe_plan_ingr.ano_presupuesto={$anPresupuesto} 
				 and sigesp_plan_unico_re.sig_cuenta like '{$cuentasinceros}%' ";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$Rs = $conexionBaseDatos->Execute ( $cadenaSql );
		if($Rs->RecordCount()==1 && $Rs->fields["montoglobalgas"]=="0") {
			return false;
		}
		elseif($Rs->fields["montoglobalgas"]>0){
			return $Rs;			
		}
	}
	
	public function obtenerSaldoIngresoTotal($codemp, $anPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select COALESCE((select sum(monto_anest) from sigesp_sfp_plancuentas where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and sig_cuenta like '301%' or sig_cuenta like '302%' or sig_cuenta like '303%' or sig_cuenta like '304%' or sig_cuenta like '305%' or sig_cuenta like '312%' or sig_cuenta like '306%' or sig_cuenta like '307%' or sig_cuenta like '311%' or sig_cuenta like '310%' or sig_cuenta like '309%' or sig_cuenta like '312%' or sig_cuenta like '313%' or sig_cuenta like '308%'),0000) as anestimado ,COALESCE((select sum(monto_anreal) from sigesp_sfp_plancuentas where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and sig_cuenta like '301%' or sig_cuenta like '302%' or sig_cuenta like '303%' or sig_cuenta like '304%' or sig_cuenta like '305%' or sig_cuenta like '312%' or sig_cuenta like '306%' or sig_cuenta like '307%' or sig_cuenta like '311%' or sig_cuenta like '310%' or sig_cuenta like '309%' or sig_cuenta like '312%' or sig_cuenta like '313%' or sig_cuenta like '308%'),0000) as anreal,
			 COALESCE(sum(enero),0000) as enero,COALESCE(sum(febrero),000)as febrero,COALESCE(sum(marzo),000) as marzo , COALESCE(sum(abril),000) as abril,COALESCE(sum(mayo),000)as mayo,COALESCE(sum(junio),000) as junio,
			 COALESCE(sum(julio),0000)as julio ,COALESCE(sum(agosto),000) as agosto,COALESCE(sum(septiembre),000) as septiembre, COALESCE(sum(octubre),000) as octubre,COALESCE(sum(noviembre),000) as noviembre,COALESCE(sum(diciembre),000) as diciembre,
			 COALESCE(sum((enero+febrero)),0000) as bimestre1,COALESCE(sum((marzo+abril)),000) as bimestre2,COALESCE(sum((mayo+junio)),000) as bimestre3, COALESCE(sum((julio+agosto)),000) as bimestre4,COALESCE(sum((septiembre+octubre)),000) as bimestre5,COALESCE(sum((noviembre+diciembre)),000) as bimestre6,
			 COALESCE(sum((enero+febrero+marzo)),0000) as trimestre1,COALESCE(sum((abril+mayo+junio)),000) as trimestre2,COALESCE(sum((julio+agosto+septiembre)),000) as trimestre3, COALESCE(sum((octubre+noviembre+diciembre)),000) as trimestre4,
			 COALESCE(sum((enero+febrero+marzo+abril+mayo+junio)),0000) as semestre1, COALESCE(sum((julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as semestre4,			 
			 COALESCE(sum((spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre)),000) as montoglobal 
			 from spe_plan_ingr 
			 where codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
			      (spe_plan_ingr.sig_cuenta like '301%' or spe_plan_ingr.sig_cuenta like '302%' or spe_plan_ingr.sig_cuenta like '303%' or spe_plan_ingr.sig_cuenta like '304%' or spe_plan_ingr.sig_cuenta like '305%' or spe_plan_ingr.sig_cuenta like '312%' or spe_plan_ingr.sig_cuenta like '306%' or spe_plan_ingr.sig_cuenta like '307%' or spe_plan_ingr.sig_cuenta like '311%' or spe_plan_ingr.sig_cuenta like '310%' or spe_plan_ingr.sig_cuenta like '309%' or spe_plan_ingr.sig_cuenta like '312%' or spe_plan_ingr.sig_cuenta like '313%' or spe_plan_ingr.sig_cuenta like '308%')";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function reporteFormulacionIngresos($codemp, $anPresupuesto, $nivelCuenta) {
		$this->servicioPlanCuenta = new ServicioPlanCuenta();
		$la_cuenta[0]["cuenta"]='301000000';
		$la_cuenta[1]["cuenta"]='302000000';
		$la_cuenta[2]["cuenta"]='303000000';
		$la_cuenta[3]["cuenta"]='304000000';
		$la_cuenta[4]["cuenta"]='305000000';
		$la_cuenta[5]["cuenta"]='306000000';
		$la_cuenta[6]["cuenta"]='307000000';
		$la_cuenta[7]["cuenta"]='308000000';
		$la_cuenta[8]["cuenta"]='309000000';
		$la_cuenta[9]["cuenta"]='311000000';
		$la_cuenta[10]["cuenta"]='312000000';
		$la_cuenta[11]["cuenta"]='313000000';

		$datastore1=array();
	    $id1=0;
	    $numcuenta = count($la_cuenta);
		for($i=0;$i<$numcuenta;$i++){
			$cuentasinceros=uf_spg_cuenta_sin_cero($la_cuenta[$i]["cuenta"]);
			$rsGrupo = $this->servicioPlanCuenta->obtenerGrupoCuenta($cuentasinceros, $la_cuenta[$i]["cuenta"]);
			while(!$rsGrupo->EOF){
				//if($this->servicioPlanCuenta->verificarCuenta(trim($rsGrupo->fields['sig_cuenta']), $nivelCuenta)){
					$resp = $this->obtenerCuentaTrimestre($codemp, $anPresupuesto, trim($rsGrupo->fields['sig_cuenta']));
					if($resp!==false){
						$datastore1[$id1]=$resp;	
					  	$id1++;
					}
				//}
				$rsGrupo->MoveNext();
			}
	    }
	  
	    $rsTotal = $this->obtenerSaldoIngresoTotal($codemp, $anPresupuesto);
	    $rsTotal2 = $this->obtenerSaldoIngresoTotal($codemp, $anPresupuesto);
	    $Datos["cuentas"]=$datastore1;
	    $Datos["datosxml"]=$rsTotal;
	    $Datos["datos8"]=$rsTotal2;
	    return $Datos;
	    
	}
	
	public function existeDistribucion($codemp, $cuenta, $anPresupuesto) {
		$existe = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT sig_cuenta_ing 
								FROM spe_int_cuentas_dtrecursos 
								WHERE  codemp='{$codemp}' AND
									   sig_cuenta_ing='{$cuenta}' AND
									   ano_presupuesto='{$anPresupuesto}'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if ($dataSet->_numOfRows > 0) {
			$existe = true;
		}
		unset($conexionBaseDatos);
		unset($dataSet);
		return $existe;
	}
	
	public function eliminarPlanIngreso($codemp, $anPresupuesto, $arrjson) {
		$this->daoPlanIngreso = FabricaDao::CrearDAO('N', 'spe_plan_ingr');
		$this->daoPlanIngreso->setData($arrjson);
		$this->daoPlanIngreso->codemp = $codemp;
		$this->daoPlanIngreso->ano_presupuesto = $anPresupuesto;
		$respuesta = $this->daoPlanIngreso->eliminar();
		unset($this->daoPlanIngreso);
		return $respuesta;
	}
	
	public function procesarEliminacionPlanIngreso($codemp, $anPresupuesto, $arrjson) {
		$respuesta = 0;
		DaoGenerico::iniciarTrans();
		$this->servicioComprobante = new ServicioComprobante();
		
		if(!$this->existeDistribucion($codemp, $arrjson->sig_cuenta, $anPresupuesto)){
			//ELIMINARA COMPROBANTE CONTABLE
			$dataComprobante = $this->servicioComprobante->buscarComprobantexCuenta($codemp, $anPresupuesto, $arrjson->sig_cuenta, 'SFPCMI');
			while (!$dataComprobante->EOF) {
				$comprobante = trim($dataComprobante->fields['comprobante']);
				$procede     = $dataComprobante->fields['procede'];
				$fecha       = $dataComprobante->fields['fecha'];
				if(!$this->servicioComprobante->eliminarComprobante($codemp, $anPresupuesto, $comprobante, $procede, $fecha)){
					return 0;
				}
				$dataComprobante->MoveNext();
			}
			$dataComprobante->Close();
			unset($dataComprobante);
			
			//ELIMINAR COMPROBANTE CAIF
			$dataComprobante = $this->servicioComprobante->buscarComprobantexCuenta($codemp, $anPresupuesto, $arrjson->sig_cuenta, 'SFPCFI');
			while (!$dataComprobante->EOF) {
				$comprobante = trim($dataComprobante->fields['comprobante']);
				$procede     = $dataComprobante->fields['procede'];
				$fecha       = $dataComprobante->fields['fecha'];
				if(!$this->servicioComprobante->eliminarComprobanteCAIF($codemp, $anPresupuesto, $comprobante, $procede, $fecha)){
					return 0;
				}
				$dataComprobante->MoveNext();
			}
			$dataComprobante->Close();
			unset($dataComprobante);
			
			//ELIMINAR REGISTRO EN PLAN DE INGRESO
			if (!$this->eliminarPlanIngreso($codemp, $anPresupuesto, $arrjson)) {
				return 0;
			}
		}
		else{
			return -1;
		}
		
		if(DaoGenerico::completarTrans()){
			$respuesta = 1;
		}
		
		return $respuesta;
	}
	
	public function buscarMontoDistribuido($codemp, $cuenta, $anPresupuesto) {
		$monto = 0;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT SUM(montoasig) AS monto 
								FROM spe_int_cuentas_dtrecursos 
								WHERE  codemp='{$codemp}' AND
									   sig_cuenta_ing='{$cuenta}' AND
									   ano_presupuesto='{$anPresupuesto}'";	
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if (!$dataSet->EOF) {
			$monto = $dataSet->fields['monto'];
		}
		unset($conexionBaseDatos);
		unset($dataSet);
		
		return $monto;
	}
	
	public function modificarPlanIngreso($codemp, $anPresupuesto, $disponible , $arrjson) {
		$strPk = "codemp = '{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND sig_cuenta='{$arrjson->sig_cuenta}'";
		$this->daoPlanIngreso = FabricaDao::CrearDAO('C', 'spe_plan_ingr',null,$strPk);
		$this->daoPlanIngreso->enero      = $arrjson->enero;
		$this->daoPlanIngreso->febrero    = $arrjson->febrero;
		$this->daoPlanIngreso->marzo      = $arrjson->marzo;
		$this->daoPlanIngreso->abril      = $arrjson->abril;
		$this->daoPlanIngreso->mayo       = $arrjson->mayo;
		$this->daoPlanIngreso->junio      = $arrjson->junio;
		$this->daoPlanIngreso->julio      = $arrjson->julio;
		$this->daoPlanIngreso->agosto     = $arrjson->agosto;
		$this->daoPlanIngreso->septiembre = $arrjson->septiembre;
		$this->daoPlanIngreso->octubre    = $arrjson->octubre;
		$this->daoPlanIngreso->noviembre  = $arrjson->noviembre;
		$this->daoPlanIngreso->diciembre  = $arrjson->diciembre;
		$this->daoPlanIngreso->disponible = $disponible;
		$respuesta = $this->daoPlanIngreso->modificar();
		unset($this->daoPlanIngreso);
		return $respuesta;
	}
	
	public function modificarFormulacionIngreso($codemp, $anPresupuesto, $arrjson) {
		$respuesta = 0;
		$montoDist = $this->buscarMontoDistribuido($codemp, $arrjson->sig_cuenta, $anPresupuesto);
		if ($arrjson->monto > $montoDist) {
			DaoGenerico::iniciarTrans();
			$disponible = $arrjson->monto - $montoDist;
			$this->modificarPlanIngreso($codemp, $anPresupuesto, $disponible, $arrjson);
			$this->servicioComprobante = new ServicioComprobante();
			$this->servicioComprobante->modificarComprobante($codemp, $anPresupuesto, $arrjson->sig_cuenta, $arrjson->monto);
			$this->servicioComprobante->modificarComprobanteCAIF($codemp, $anPresupuesto, $arrjson->sig_cuenta, $arrjson->monto);
			if(DaoGenerico::completarTrans()){
				$respuesta = 1;
			}
		}
		else {
			$respuesta = -1;
		}
		
		
		
		return $respuesta;
	}
	
	public function buscarTransferenciaRecibirPublico($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arregloDatos = null;
		$cadenaSql1 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,(spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as montoglobal 
						from sigesp_plan_unico_re 
							inner join spe_plan_ingr on sigesp_plan_unico_re.sig_cuenta=substr(spe_plan_ingr.sig_cuenta,1,9) 
						where spe_plan_ingr.sig_cuenta like '3050103%' and
							  spe_plan_ingr.codemp='{$codemp}' and
							  spe_plan_ingr.ano_presupuesto={$annoPresupuesto}";
		$dataSet1   = $conexionBaseDatos->Execute ( $cadenaSql1 );
		$cadenaSql2 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,(spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as montoglobal 
						from sigesp_plan_unico_re 
							inner join spe_plan_ingr on sigesp_plan_unico_re.sig_cuenta=substr(spe_plan_ingr.sig_cuenta,1,9) 
						where spe_plan_ingr.sig_cuenta like '3050104%' and 
							  spe_plan_ingr.codemp='{$codemp}' and
							  spe_plan_ingr.ano_presupuesto={$annoPresupuesto}";
		$dataSet2   = $conexionBaseDatos->Execute($cadenaSql2);
		$cadenaSql3 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,(spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as montoglobal 
						from sigesp_plan_unico_re 
							inner join spe_plan_ingr on sigesp_plan_unico_re.sig_cuenta=substr(spe_plan_ingr.sig_cuenta,1,9) 
						where spe_plan_ingr.sig_cuenta like '3050203%' and
							  spe_plan_ingr.codemp='{$codemp}' and
							  spe_plan_ingr.ano_presupuesto={$annoPresupuesto}";
		$dataSet3   = $conexionBaseDatos->Execute($cadenaSql3);
		$cadenaSql4 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,(spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as montoglobal 
						from sigesp_plan_unico_re 
						inner join spe_plan_ingr on sigesp_plan_unico_re.sig_cuenta=substr(spe_plan_ingr.sig_cuenta,1,9) 
						where spe_plan_ingr.sig_cuenta like '3050204%' and
						spe_plan_ingr.codemp='{$codemp}' and
						spe_plan_ingr.ano_presupuesto={$annoPresupuesto}";
		$dataSet4   = $conexionBaseDatos->Execute($cadenaSql4);
		$cadenaSql5 = "select sum(spe_plan_ingr.enero+spe_plan_ingr.febrero+spe_plan_ingr.marzo+spe_plan_ingr.abril+spe_plan_ingr.mayo+spe_plan_ingr.junio+spe_plan_ingr.julio+spe_plan_ingr.agosto+spe_plan_ingr.septiembre+spe_plan_ingr.octubre+spe_plan_ingr.noviembre+spe_plan_ingr.diciembre) as suma 
						from spe_plan_ingr 
						where codemp='{$codemp}' and
							  ano_presupuesto={$annoPresupuesto} and 
							  sig_cuenta like '3050103%' or 
							  sig_cuenta like '3050104%' or 
							  sig_cuenta like '3050203%' or 
							  sig_cuenta like '3050204%'";
		$dataSet5   = $conexionBaseDatos->Execute($cadenaSql5);
		$arregloDatos = array($dataSet1,$dataSet2,$dataSet3,$dataSet4,$dataSet5);
		
		unset($conexionBaseDatos);
		return $arregloDatos;
	}
}
?>