<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_iformulaciongasto.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_estructurapresupuestaria.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_configuracionnivel.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_comprobante.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_plancuenta.php");


class ServicioFormulacionGasto implements IFormulacionGasto {
	private $servicioEstructura;
	private $servicioConfiguracionNivel;
	private $servicioComprobante;
	private $servicioPlanCuenta;
	private $daoCuentaGasto;
	private $daoCuentaFuente;
	private $daoMeta;
	private $daoIndicadores;
	
	public function ServicioFormulacionGasto() {
		$this->servicioEstructura = null;
		$this->servicioConfiguracionNivel = null;
		$this->servicioComprobante = null;
		$this->servicioPlanCuenta = null;
		$this->daoCuentaGasto = null;
		$this->daoCuentaFuente = null;
		$this->daoMeta         = null;
		$this->daoIndicadores  = null;
	}
	
	public function buscarEstructuraIntegrada($codemp, $anPresupuesto) {
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$this->servicioEstructura = new ServicioEstructuraPresupuestaria();
		$this->servicioConfiguracionNivel = new ServicioConfiguracionNivel();
		$arrEstructura     = $this->servicioEstructura->obtenerConfiguracionEstructura($codemp, $anPresupuesto);
		$nombreUltimoNivel = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anPresupuesto, 'PR');
		$numeroNiveles     = count($arrEstructura);
		
		switch ($numeroNiveles) {
			case 1:
				$cadenaSql = "SELECT rel.codinte,substr(e1.codestpro1,length(e1.codestpro1)-".$arrEstructura[0]["numcar"]."+1,length(e1.codestpro1)) as codigo,e1.estcla,e1.denestpro1 as Descripcion,'{$nombreUltimoNivel}' as nombrenivelpr
								FROM spe_relacion_es rel
								INNER JOIN sfp_estpro1 e1 ON rel.codemp=e1.codemp AND rel.codestpro1=e1.codestpro1
								WHERE rel.codemp = '{$codemp}' AND rel.ano_presupuesto = {$anPresupuesto}";
				break;
			
			case 2:
				$strcon = $conbd->Concat("substr(e2.codestpro1,length(e2.codestpro1)-".$arrEstructura[0]["numcar"]."+1,length(e2.codestpro1))","'-'","substr(e2.codestpro2,length(e2.codestpro2)-".$arrEstructura[1]["numcar"]."+1,length(e2.codestpro2))");
				$cadenaSql = "SELECT rel.codinte,{$strcon} as codigo,e2.estcla,e2.denestpro2 as Descripcion,'{$nombreUltimoNivel}' as nombrenivelpr
								FROM spe_relacion_es rel
								INNER JOIN sfp_estpro2 e2 ON rel.codemp=e2.codemp AND rel.codestpro1=e2.codestpro1 AND rel.codestpro2=e2.codestpro2
								WHERE rel.codemp = '{$codemp}' AND rel.ano_presupuesto = {$anPresupuesto}";
				break;
			
			case 3:
				$strcon = $conbd->Concat("substr(e3.codestpro1,length(e3.codestpro1)-".$arrEstructura[0]["numcar"]."+1,length(e3.codestpro1))","'-'","substr(e3.codestpro2,length(e3.codestpro2)-".$arrEstructura[1]["numcar"]."+1,length(e3.codestpro2))","'-'","substr(e3.codestpro3,length(e3.codestpro3)-".$arrEstructura[2]["numcar"]."+1,length(e3.codestpro2))");
				$cadenaSql = "SELECT rel.codinte,{$strcon} as codigo,e3.estcla,e3.denestpro3 as Descripcion,'{$nombreUltimoNivel}' as nombrenivelpr
								FROM spe_relacion_es rel
								INNER JOIN sfp_estpro3 e3 ON rel.codemp=e3.codemp AND rel.codestpro1=e3.codestpro1 AND rel.codestpro2=e3.codestpro2
								AND rel.codestpro3=e3.codestpro3
								WHERE rel.codemp = '{$codemp}' AND rel.ano_presupuesto = {$anPresupuesto}";
				break;
		}
		$dataEstructura  = $conbd->Execute ( $cadenaSql );
		
		unset($conbd);
		unset($this->servicioConfiguracionNivel);
		unset($this->servicioEstructura);
		
		return $dataEstructura;
	}
	
	public function buscarMetas($codemp) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select cod_var,sig_variables.denominacion as meta,sig_variables.cod_uni,sig_unidademedidas.denominacion as unidad,
		                             sig_unidademedidas.genero 
		                             from sig_variables 
		                             inner join sig_unidademedidas on sig_variables.cod_uni=sig_unidademedidas.cod_uni 
		                                        and sig_variables.codemp=sig_unidademedidas.codemp 
		                             where sig_variables.codemp='{$codemp}'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarCuentasGasto($codemp,$annoPresupuesto,$criterio,$valor) {
		$cadenaSql = "select sigesp_sfp_plancuentas.monto_anreal,sigesp_sfp_plancuentas.monto_anest,sigesp_sfp_plancuentas.sig_cuenta as codigo,sigesp_sfp_plancuentas.denominacion as denominacion,
		    				 sigesp_sfp_asociacion.estatus,s1.denominacion as dendebe,s2.denominacion as denhaber,s1.sc_cuenta as codigodebe,s2.sc_cuenta as codigohaber,
							 coalesce(sigesp_sfp_asociacion.codcaif,'No Disponible') as codcaif ,
							 coalesce(sigesp_sfp_asociacion.codcaif,'No Aplica')  as codvardebe,
							 coalesce(s3.desplacaif,caif1.desplacaif)  as denvardebe,
							 coalesce(sigesp_sfp_asociacion.codcaif_haber,'No Aplica') as codvarhaber ,
							 coalesce(s4.desplacaif,caif1.desplacaif) as denvarhaber 		
			  				 from sigesp_sfp_asociacion  
			  				 inner join sigesp_plan_unico_re on sigesp_sfp_asociacion.sig_cuenta=substr(sigesp_plan_unico_re.sig_cuenta,1,9)
			  				 inner join sigesp_sfp_plancuentas on substr(sigesp_sfp_plancuentas.sig_cuenta,1,9)=sigesp_sfp_asociacion.sig_cuenta
			 				 left outer join sigesp_plan_unico_caif as caif1 on caif1.codplacaif=sigesp_sfp_asociacion.codcaif
							 left outer join sigesp_sfp_plan_unico s1 on s1.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta 
							 left outer join sigesp_sfp_plan_unico s2 on s2.sc_cuenta=sigesp_sfp_asociacion.sc_cuenta_haber
							 left outer join sigesp_plan_unico_caif s3 on s3.codplacaif=sigesp_sfp_asociacion.codcaif
							 left outer join sigesp_plan_unico_caif s4 on s4.codplacaif=sigesp_sfp_asociacion.codcaif_haber
							 where sigesp_sfp_asociacion.estatus='C'
							 and sigesp_plan_unico_re.sig_cuenta like '4%' and sigesp_plan_unico_re.{$criterio} like '{$valor}%'
							 and sigesp_sfp_plancuentas.codemp='{$codemp}' and sigesp_sfp_plancuentas.ano_presupuesto={$annoPresupuesto}
							 order by sigesp_plan_unico_re.sig_cuenta asc";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function procesarFormulacionGasto($codemp, $anPresupuesto, $objJson) {
		$arrcabecera       = array();
		$arrdetalle        = array();
		$procesado         = true;
		$datosGastos       = $objJson->DatosGas;
		$datosMetas        = $objJson->DatosMetas;
		$datosIndicadores  = $objJson->DatosIndi;
		$this->servicioComprobante = new ServicioComprobante();
		DaoGenerico::iniciarTrans();
		if (!empty($datosGastos)) {
			foreach ($datosGastos as $cuenta) {
				$this->daoCuentaGasto = FabricaDao::CrearDAO('N', 'spe_int_cuentas');
				$this->daoCuentaGasto->setData($cuenta);
				$this->daoCuentaGasto->codemp          = $codemp;
				$this->daoCuentaGasto->ano_presupuesto = $anPresupuesto;
				$this->daoCuentaGasto->codinte         = $objJson->codinte;
				if($this->daoCuentaGasto->montoanreal==''){
					$this->daoCuentaGasto->montoanreal = 0;
				}
				
				if($this->daoCuentaGasto->montoanant==''){
					$this->daoCuentaGasto->montoanant = 0;
				}
				if($this->daoCuentaGasto->incluir()){
					foreach ($cuenta->fuentes as $fuente) {
						$this->daoCuentaFuente = FabricaDao::CrearDAO('N', 'spe_int_cuentas_dtrecursos');
						$this->daoCuentaFuente->setData($fuente);
						$this->daoCuentaFuente->codemp          = $codemp;
						$this->daoCuentaFuente->ano_presupuesto = $anPresupuesto;
						$this->daoCuentaFuente->codinte         = $objJson->codinte;
						$this->daoCuentaFuente->sig_cuenta_gas  = $this->daoCuentaGasto->sig_cuenta;
						if (!$this->daoCuentaFuente->incluir()) {
							echo $this->daoCuentaFuente->ErrorMsg();
							break;
						}
						unset($this->daoCuentaFuente);
					}
				}
				else {
					break;
				}
				unset($this->daoCuentaGasto);
				
				$arrcabecera['codemp'] = $codemp;
	 			$arrcabecera['comprobante'] = $this->servicioComprobante->buscarCodigoComprobante($codemp);
				$arrcabecera['fecha'] = date('Y-m-d');
				$arrcabecera['annoPresupuesto'] = $anPresupuesto;
				$arrcabecera['procede']='SFPCMG';
				$arrcabecera['sig_cuenta']=$cuenta->sig_cuenta;
				$arrcabecera['descripcion']='Formulacion de presupuesto de gastos';
				$arrcabecera['tipo_comp']= '1';
				$arrcabecera['tipo_destino']='N';
				$arrcabecera['codinte']= $objJson->codinte;
				
				if(!$this->servicioComprobante->existeComprobante($arrcabecera['codemp'], $arrcabecera['procede'], $arrcabecera['comprobante'], $arrcabecera['fecha'], $arrcabecera['annoPresupuesto'])){
					$arrdetalle[1]['documento']='0000';
					$arrdetalle[1]['debhab']='D';
					$arrdetalle[1]['sc_cuenta']=$cuenta->CuentaDebe;
					$arrdetalle[1]['monto']=$cuenta->monto;
					$arrdetalle[2]['documento']='0000';
					$arrdetalle[2]['debhab']='H';
					$arrdetalle[2]['sc_cuenta']=$cuenta->CuentaHaber;
					$arrdetalle[2]['monto']=$cuenta->monto;
					
					$this->servicioComprobante->guardarComprobante($arrcabecera, $arrdetalle);
				}
				
				//COMPROBANTE CAIF 
				$arrcabeceraCAIF['codemp']          = $codemp;
		 		$arrcabeceraCAIF['comprobante']     = $this->servicioComprobante->buscarCodigoComprobante($codemp);
				$arrcabeceraCAIF['fecha']           = date('Y-m-d');
				$arrcabeceraCAIF['annoPresupuesto'] = $anPresupuesto;
				$arrcabeceraCAIF['procede']         = 'SFPCFG'; //PROCEDE COMPROBANTE CAIF DE GASTOS
				$arrcabeceraCAIF['sig_cuenta']      = $cuenta->sig_cuenta;
				$arrcabeceraCAIF['descripcion']     = 'Formulacion de presupuesto de gasto CAIF';
				$arrcabeceraCAIF['tipo_comp']       = '1';
				$arrcabeceraCAIF['tipo_destino']    = 'N';
				$arrcabeceraCAIF['codinte']         = $objJson->codinte;
				
				$cuentaCAIF = $this->buscarCuentasCAIF($cuenta->sig_cuenta);
				if(!$cuentaCAIF->EOF){
					$arrdetalleCAIF[0]['sig_cuenta'] = $cuentaCAIF->fields['codcaif'];
					$arrdetalleCAIF[0]['debhab']    = 'D';
					$arrdetalleCAIF[0]['monto']     = $cuenta->monto;
					
					$arrdetalleCAIF[1]['sig_cuenta'] = $cuentaCAIF->fields['codcaif_haber'];
					$arrdetalleCAIF[1]['debhab']    = 'H';
					$arrdetalleCAIF[1]['monto']     = $cuenta->monto;
				}
				
				if(!$this->servicioComprobante->existeComprobante($arrcabeceraCAIF['codemp'], $arrcabeceraCAIF['procede'], $arrcabeceraCAIF['comprobante'], $arrcabeceraCAIF['fecha'], $arrcabeceraCAIF['annoPresupuesto'])){
					$this->servicioComprobante->guardarComprobanteCAIF($arrcabeceraCAIF, $arrdetalleCAIF);
				}
				//FIN COMPROBANTE CAIF
			}	
		}
		
		if (!empty($datosMetas)) {
			foreach ($datosMetas as $meta) {
				$this->daoMeta = FabricaDao::CrearDAO('N','spe_relacion_estvar');
				$this->daoMeta->setData($this->modificarVacios($meta));
				$this->daoMeta->codemp          = $codemp;
				$this->daoMeta->ano_presupuesto = $anPresupuesto;
				$this->daoMeta->codinte         = $objJson->codinte;
				if (!$this->daoMeta->incluir()) {
					return $this->daoMeta->ErrorMsg();
				}
			}
		}
		
		if (!empty($datosIndicadores)){
			foreach ($datosIndicadores as $indicador) {
				$this->daoIndicadores = FabricaDao::CrearDAO('N','spe_relacion_estindi');
				$this->daoIndicadores->setData($this->modificarVacios($indicador));
				$this->daoIndicadores->codemp          = $codemp;
				$this->daoIndicadores->ano_presupuesto = $anPresupuesto;
				$this->daoIndicadores->codinte         = $objJson->codinte;
				if (!$this->daoIndicadores->incluir()) {
					return $this->daoIndicadores->ErrorMsg();
				}
			}
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
			    	
		return $procesado;
	}
	
	public function buscarCuentasCAIF($cuenta) {
		$cuenta = substr($cuenta, 0, 9);
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codcaif, codcaif_haber
								FROM sigesp_sfp_asociacion
								WHERE sig_cuenta = '{$cuenta}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarIndicadores($codemp) {
		$this->daoIndicadores = FabricaDao::CrearDAO('N','sig_indicador');
		$data = $this->daoIndicadores->leerTodos('cod_ind',0,$codemp);
		unset($this->daoIndicadores);
		
		return $data;
	}
	
	public function actualizarDisponibildad($codemp, $annoPresupuesto, $cuenta, $monto) {
		$cadenaSql         = "update spe_plan_ingr set disponible=disponible-{$monto} where sig_cuenta='{$cuenta}' and ano_presupuesto={$annoPresupuesto} and codemp='{$codemp}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$resultado  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $resultado;
	}
	
	public function modificarVacios($meta) {
		foreach ($meta as $campo => $valor) {
			if ($valor == '') {
				$meta->$campo = 0;
			}
		}
		return $meta;
	}
	
	public function buscarMetaIntegracion($codemp, $codint) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select spe_relacion_estvar.*, 
				(spe_relacion_estvar.enero_masc+spe_relacion_estvar.febrero_masc+spe_relacion_estvar.marzo_masc+
				spe_relacion_estvar.abril_masc+spe_relacion_estvar.mayo_masc+spe_relacion_estvar.junio_masc+
				spe_relacion_estvar.julio_masc+spe_relacion_estvar.agosto_masc+spe_relacion_estvar.septiembre_masc+
				spe_relacion_estvar.octubre_masc+spe_relacion_estvar.noviembre_masc+spe_relacion_estvar.diciembre_masc) as totalm,
				COALESCE(COALESCE(spe_relacion_estvar.enero_masc,0.00)+
                COALESCE(spe_relacion_estvar.febrero_masc,0.00)+
                COALESCE(spe_relacion_estvar.marzo_masc,0.00)+
				        COALESCE(spe_relacion_estvar.abril_masc,0.00)+
                COALESCE(spe_relacion_estvar.mayo_masc,0.00)+
                COALESCE(spe_relacion_estvar.junio_masc,0.00)+
				        COALESCE(spe_relacion_estvar.julio_masc,0.00)+
                COALESCE(spe_relacion_estvar.agosto_masc,0.00)+
                COALESCE(spe_relacion_estvar.septiembre_masc,0.00)+
                COALESCE(spe_relacion_estvar.octubre_masc,0.00)+
                COALESCE(spe_relacion_estvar.noviembre_masc,0.00)+
                COALESCE(spe_relacion_estvar.diciembre_masc,0.00)+
                COALESCE(spe_relacion_estvar.enero_fem,0.00)+
                COALESCE(spe_relacion_estvar.febrero_fem,0.00)+
                COALESCE(spe_relacion_estvar.marzo_fem,0.00)+
				        COALESCE(spe_relacion_estvar.abril_fem,0.00)+
                COALESCE(spe_relacion_estvar.mayo_fem,0.00)+
                COALESCE(spe_relacion_estvar.junio_fem,0.00)+
				        COALESCE(spe_relacion_estvar.julio_fem,0.00)+
                COALESCE(spe_relacion_estvar.agosto_fem,0.00)+
                COALESCE(spe_relacion_estvar.septiembre_fem,0.00)+
				        COALESCE(spe_relacion_estvar.octubre_fem,0.00)+
                COALESCE(spe_relacion_estvar.noviembre_fem,0.00)+
                COALESCE(spe_relacion_estvar.diciembre_fem,0.00)) as totalmeta,
				sig_variables.denominacion as meta from spe_relacion_estvar inner join sig_variables on spe_relacion_estvar.cod_var=sig_variables.cod_var and spe_relacion_estvar.codemp=sig_variables.codemp
				inner join spe_relacion_es on spe_relacion_estvar.codinte=spe_relacion_es.codinte and spe_relacion_estvar.codemp=spe_relacion_es.codemp where spe_relacion_estvar.codinte ={$codint} and spe_relacion_estvar.codemp ='{$codemp}'";
		
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarIndicadoresIntegracion($codemp, $codint) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select spe_relacion_estindi.ano_presupuesto, spe_relacion_estindi.codinte, spe_relacion_estindi.cod_ind, spe_relacion_estindi.codemp,
				COALESCE(spe_relacion_estindi.enero+spe_relacion_estindi.febrero+spe_relacion_estindi.marzo+spe_relacion_estindi.abril+spe_relacion_estindi.mayo+spe_relacion_estindi.junio+
				spe_relacion_estindi.julio+spe_relacion_estindi.agosto+spe_relacion_estindi.septiembre+spe_relacion_estindi.octubre+spe_relacion_estindi.noviembre+
				spe_relacion_estindi.diciembre,0.00) as montototal,spe_relacion_estindi.monto,
				spe_relacion_estindi.enero,spe_relacion_estindi.febrero,spe_relacion_estindi.marzo,spe_relacion_estindi.abril,spe_relacion_estindi.mayo,spe_relacion_estindi.junio,spe_relacion_estindi.julio,
				spe_relacion_estindi.agosto,spe_relacion_estindi.septiembre,spe_relacion_estindi.octubre,spe_relacion_estindi.noviembre,spe_relacion_estindi.diciembre, spe_relacion_estindi.formula, sig_indicador.denominacion from spe_relacion_estindi 
		        inner join sig_indicador on spe_relacion_estindi.cod_ind=sig_indicador.cod_ind and spe_relacion_estindi.codemp=sig_indicador.codemp
				inner join spe_relacion_es on spe_relacion_estindi.codinte=spe_relacion_es.codinte and spe_relacion_estindi.codemp=spe_relacion_es.codemp where spe_relacion_estindi.codinte ={$codint} and spe_relacion_estindi.codemp = '{$codemp}'";
		
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;;
	}
	
	public function buscarCuentasIntegracion($codemp, $codint) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select sigesp_sfp_plancuentas.denominacion,sigesp_sfp_plancuentas.monto_anreal,sigesp_sfp_plancuentas.monto_anest,spe_int_cuentas.sig_cuenta as spg_cuenta,spe_int_cuentas.*,
		(spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+spe_int_cuentas
		.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+spe_int_cuentas.diciembre) as montoglobal from spe_int_cuentas  inner join sigesp_sfp_plancuentas 
		on spe_int_cuentas.sig_cuenta=sigesp_sfp_plancuentas.sig_cuenta and spe_int_cuentas.codemp=sigesp_sfp_plancuentas.codemp
 		and spe_int_cuentas.ano_presupuesto=sigesp_sfp_plancuentas.ano_presupuesto where spe_int_cuentas.codinte ={$codint} and spe_int_cuentas.codemp='{$codemp}' order by spe_int_cuentas.sig_cuenta asc";
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;;
	}
	
	public function eliminarFormulacionMeta($codemp, $anPresupuesto,$registro) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoMeta = FabricaDao::CrearDAO('N','spe_relacion_estvar');
		$this->daoMeta->setData($registro);
		$this->daoMeta->codemp          = $codemp;
		$this->daoMeta->ano_presupuesto = $anPresupuesto;
		if (!$this->daoMeta->eliminar()) {
			return $this->daoMeta->ErrorMsg();
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		
		return $procesado;
	}
	
	public function eliminarFormulacionIndicador($codemp, $anPresupuesto,$registro) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoIndicadores = FabricaDao::CrearDAO('N','spe_relacion_estindi');
		$this->daoIndicadores->setData($registro);
		$this->daoIndicadores->codemp          = $codemp;
		$this->daoIndicadores->ano_presupuesto = $anPresupuesto;
		if (!$this->daoIndicadores->eliminar()) {
			return $this->daoIndicadores->ErrorMsg();
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		
		return $procesado;
	}
	
	public function eliminarFormulacionCuenta($codemp,$anPresupuesto,$arrJson) {
		$procesado = true;
		$this->servicioComprobante = new ServicioComprobante();
		DaoGenerico::iniciarTrans();
		foreach ($arrJson as $registro) {
			//REVERSAR DISPONIBILIDAD DE INGRESOS
			$dataCuentaIngreso = $this->buscarCuentaFuente($codemp, $anPresupuesto, $registro->sig_cuenta, $registro->codinte);
			while (!$dataCuentaIngreso->EOF) {
				$cuentaIngreso = $dataCuentaIngreso->fields['sig_cuenta_ing'];
				$monto         = $dataCuentaIngreso->fields['montoasig'];
				
				if(!$this->reversarDisponibilidad($codemp, $anPresupuesto, $cuentaIngreso, $monto)){
					break;
				}
				
				$dataCuentaIngreso->MoveNext();
			}
			$dataCuentaIngreso->Close();
			unset($dataCuentaIngreso);
			
			//ELIMINAR FUENTE DE INGRESO(spe_int_cuentas_dtrecursos) 
			if(!$this->eliminarCuentaFuente($codemp, $anPresupuesto, $registro->sig_cuenta, $registro->codinte)){
				break;
			}
						
			//ELIMINAR CUENTA (spe_int_cuentas)
			$this->daoCuentaGasto = FabricaDao::CrearDAO('N', 'spe_int_cuentas');
			$this->daoCuentaGasto->codemp          = $codemp;
			$this->daoCuentaGasto->ano_presupuesto = $anPresupuesto;
			$this->daoCuentaGasto->codinte         = $registro->codinte;
			$this->daoCuentaGasto->sig_cuenta      = $registro->sig_cuenta;
			$this->daoCuentaGasto->eliminar();
			
			//ELIMINAR COMPROBANTE CONTABLE
			$dataComprobante = $this->servicioComprobante->buscarComprobantexCuenta($codemp, $anPresupuesto, $registro->sig_cuenta, 'SFPCMG');
			while (!$dataComprobante->EOF) {
				$comprobante = trim($dataComprobante->fields['comprobante']);
				$procede     = $dataComprobante->fields['procede'];
				$fecha       = $dataComprobante->fields['fecha'];
				$this->servicioComprobante->eliminarComprobante($codemp, $anPresupuesto, $comprobante, $procede, $fecha);
				$dataComprobante->MoveNext();
			}
			$dataComprobante->Close();
			unset($dataComprobante);
			
			//ELIMINAR COMPROBANTE CAIF
			$dataComprobante = $this->servicioComprobante->buscarComprobantexCuenta($codemp, $anPresupuesto, $registro->sig_cuenta, 'SFPCFG');
			while (!$dataComprobante->EOF) {
				$comprobante = trim($dataComprobante->fields['comprobante']);
				$procede     = $dataComprobante->fields['procede'];
				$fecha       = $dataComprobante->fields['fecha'];
				$this->servicioComprobante->eliminarComprobanteCAIF($codemp, $anPresupuesto, $comprobante, $procede, $fecha);
				$dataComprobante->MoveNext();
			}
			$dataComprobante->Close();
			unset($dataComprobante);
		}
		 
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
			    	
		return $procesado;
	}
	
	public function buscarCuentaFuente($codemp,$anPresupuesto,$cuentagas,$codinte) {
		$cadenaSql         = "SELECT sig_cuenta_ing,montoasig 
								FROM spe_int_cuentas_dtrecursos 
								WHERE codemp='{$codemp}' AND ano_presupuesto={$anPresupuesto} AND 
								      sig_cuenta_gas='{$cuentagas}' AND codinte={$codinte}";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$data  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $data;
	}
	
	public function reversarDisponibilidad($codemp,$anPresupuesto,$cuentaIngreso,$monto) {
		$cadenaSql         = "UPDATE spe_plan_ingr
								SET disponible=disponible+{$monto}
								WHERE codemp='{$codemp}' AND ano_presupuesto={$anPresupuesto} AND 
								      sig_cuenta='{$cuentaIngreso}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$repuesta  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return respuesta;
	}
	
	public function eliminarCuentaFuente($codemp,$anPresupuesto,$cuentagas,$codinte) {
		$cadenaSql         = "DELETE FROM spe_int_cuentas_dtrecursos 
								WHERE codemp='{$codemp}' AND ano_presupuesto={$anPresupuesto} AND 
								      sig_cuenta_gas='{$cuentagas}' AND codinte={$codinte}";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$repuesta  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return respuesta;
	}
	
	public function tieneMovimientoGasto($codemp, $anPresupuesto, $grupoCuenta) {
		$tieneMovimiento = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select * 
						from spe_int_cuentas 
						where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' and ano_presupuesto={$anPresupuesto}";
		$dataSet = $conexionBaseDatos->Execute ( $cadenaSql );
		if($dataSet->_numOfRows > 0){
			$tieneMovimiento = true;
		}
		
		return $tieneMovimiento;
	}
	
	public function obtenerSaldoCuenta($codemp, $anPresupuesto, $cuenta, $frecuencia) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros    = uf_spg_cuenta_sin_cero($cuenta);
		$filtroFrecuencia  = '';
		$estatusCuenta     = 'C';
		
		if($this->tieneMovimientoGasto($codemp, $anPresupuesto, $cuentasinceros)) {
			switch($frecuencia){
				case "Mensual":
					$filtroFrecuencia = 'COALESCE(sum(enero),0000) as enero,COALESCE(sum(febrero),000)as febrero,
					                     COALESCE(sum(marzo),000) as marzo,COALESCE(sum(abril),000) as abril,
					                     COALESCE(sum(mayo),000)as mayo,COALESCE(sum(junio),000) as junio,
					                     COALESCE(sum(julio),0000) as julio,COALESCE(sum(agosto),000) as agosto,
					                     COALESCE(sum(septiembre),000) as septiembre,COALESCE(sum(octubre),000) as octubre,
					                     COALESCE(sum(noviembre),000) as noviembre,COALESCE(sum(diciembre),000) as diciembre,
					                     COALESCE(sum(montoanreal),000) as montoanreal,COALESCE(sum(montoanant),000) as montoanant, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Bimensual":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero)),0000) as bimestre1,
					                     COALESCE(sum((marzo+abril)),000) as bimestre2,
					                     COALESCE(sum((mayo+junio)),000) as bimestre3, 
					                     COALESCE(sum((julio+agosto)),000) as bimestre4,
					                     COALESCE(sum((septiembre+octubre)),000) as bimestre5,
					                     COALESCE(sum((noviembre+diciembre)),000) as bimestre6,
					                     COALESCE(sum(montoanreal),000) as montoanreal,COALESCE(sum(montoanant),000) as montoanant, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Trimestral":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo)),0000) as trimestre1,
					                     COALESCE(sum((abril+mayo+junio)),000) as trimestre2,
					                     COALESCE(sum((julio+agosto+septiembre)),000) as trimestre3, 
					                     COALESCE(sum((octubre+noviembre+diciembre)),000) as trimestre4,
					                     COALESCE(sum(montoanreal),000) as montoanreal,COALESCE(sum(montoanant),000) as montoanant, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';		
					break;
				case "Semestral":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio)),0000) as semestre1, 
					                     COALESCE(sum((julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as semestre2,
					                     COALESCE(sum(montoanreal),000) as montoanreal,COALESCE(sum(montoanant),000) as montoanant, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Anual":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoanual,
										 COALESCE(sum(montoanreal),000) as montoanreal,COALESCE(sum(montoanant),000) as montoanant ';
					break;
			}
			
			if ($this->servicioPlanCuenta->verificarNivelCuenta($codemp, $cuenta, 1,'G')) {
				$estatusCuenta = 'S';
			}
			
			$cadenaSql = "SELECT {$cuenta} AS codcuenta, '{$estatusCuenta}' AS estcuenta,
								 (SELECT denominacion 
									FROM sigesp_sfp_plancuentas 
									WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
									      sig_cuenta='{$cuenta}') as denominaciongas,{$filtroFrecuencia} 
				 	from  spe_int_cuentas 
				 	where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				 	      spe_int_cuentas.sig_cuenta like '{$cuentasinceros}%'";
			$resultSet = $conexionBaseDatos->Execute ($cadenaSql);
			unset($conexionBaseDatos);
		}
		else{
			return false;
		}
		
		return $resultSet;
	}
	
	public function reporteGastosAplicaciones($codemp, $anPresupuesto, $nivelCuenta, $frecuencia) {
		$this->servicioPlanCuenta =  new ServicioPlanCuenta();
		$datastore1 = array();
		$rsGrupo = $this->servicioPlanCuenta->obtenerGrupoPlanCuenta($codemp, $anPresupuesto, '4', array());
		while(!$rsGrupo->EOF){
			$cuenta = trim($rsGrupo->fields['sig_cuenta']);
			if ($this->servicioPlanCuenta->verificarNivelCuenta($codemp, $cuenta, $nivelCuenta,'G')) {
				$dataSaldo = $this->obtenerSaldoCuenta($codemp, $anPresupuesto, $cuenta, $frecuencia);
				if ($dataSaldo!=false) {
					$datastore1[] = $dataSaldo;
				}
			}
			unset($dataSaldo);
			$rsGrupo->MoveNext();
		}
  		
		$datos["cuentas"]=$datastore1;
	    return $datos;
	}
	
	public function obtenerGastosEstructura($codemp, $anpresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arrCondiciones    = $this->condicionesSelectEstructura($codemp, $anpresupuesto);
		$cadenaSql = "select i.codinte{$arrCondiciones['select']}, enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre as monto,
				spe_int_cuentas.sig_cuenta,sigesp_sfp_plancuentas.denominacion 
				from spe_relacion_es as i {$arrCondiciones['from']},spe_int_cuentas,sigesp_sfp_plancuentas 
				where i.codemp='{$codemp}' and 
				i.ano_presupuesto='{$anpresupuesto}' and 
				i.codemp=spe_int_cuentas.codemp and 
				i.ano_presupuesto=spe_int_cuentas.ano_presupuesto and  
				i.codinte=spe_int_cuentas.codinte and 
				spe_int_cuentas.codemp=sigesp_sfp_plancuentas.codemp and 
				spe_int_cuentas.ano_presupuesto=sigesp_sfp_plancuentas.ano_presupuesto and
				spe_int_cuentas.sig_cuenta=sigesp_sfp_plancuentas.sig_cuenta 
				order by spe_int_cuentas.sig_cuenta";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
		
	}
	
	public function condicionesSelectEstructura($codemp, $anpresupuesto) {
		$arrCondicion = array();
		$cadenaSelect = '';
		$cadenaFrom   = '';
		
		$this->servicioConfiguracionNivel = new ServicioConfiguracionNivel();
		$this->servicioEstructura         = new  ServicioEstructuraPresupuestaria();
		$arrnivelesEstructura = $this->servicioEstructura->obtenerConfiguracionEstructura($codemp, $anpresupuesto);
		$conexionBaseDatos    = ConexionBaseDatos::getInstanciaConexion();
		switch (count($arrnivelesEstructura)) {
			case 1:
				$nomultimoEstructura = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anpresupuesto, 'PR');
				$cadenaSelect .=",substr(e1.codestpro1,length(e1.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(e1.codestpro1) ) as codigo,e1.denestpro1 as descripcion,'{$nomultimoEstructura}' as nombrenivelpr ";
				$cadenaFrom.=" INNER JOIN sfp_estpro1 as e1 ON e1.codemp=i.codemp and e1.ano_presupuesto=i.ano_presupuesto and e1.codestpro1=i.codestpro1";
				break;
			case 2:
				$nomultimoEstructura = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anpresupuesto, 'PR');
				$strCodigo     =$conexionBaseDatos->Concat("substr(e1.codestpro1,length(e1.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(e1.codestpro1) )","'-'",
														   "substr(e2.codestpro2,length(e2.codestpro2)-".$arrnivelesEstructura[1]["numcar"]."+1,length(e2.codestpro2) )");
				$cadenaSelect .=",{$strCodigo} as codigo,e2.denestpro2 as Descripcion
								 ,e1.codestpro1,e1.denestpro1,e2.codestpro2,e2.denestpro2,'{$nomultimoEstructura}' as nombrenivelpr ";
				$cadenaFrom.=" INNER JOIN sfp_estpro1 as e1 ON e1.codemp=i.codemp and e1.ano_presupuesto=i.ano_presupuesto and e1.codestpro1=i.codestpro1 
							   INNER JOIN sfp_estpro2 as e2 ON e2.codemp=i.codemp and e2.ano_presupuesto=i.ano_presupuesto and e2.codestpro1=i.codestpro1 and e2.codestpro2=i.codestpro2";
				break;
			case 3:
				$nomultimoEstructura = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anpresupuesto, 'PR');
				$strCodigo     =$conexionBaseDatos->Concat("substr(e1.codestpro1,length(e1.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(e1.codestpro1) )","'-'",
														   "substr(e2.codestpro2,length(e2.codestpro2)-".$arrnivelesEstructura[1]["numcar"]."+1,length(e2.codestpro2) )","'-'",
														   "substr(e3.codestpro3,length(e3.codestpro3)-".$arrnivelesEstructura[2]["numcar"]."+1,length(e3.codestpro3) )");
				$cadenaSelect .=",{$strCodigo} as codigo,e3.denestpro3 as Descripcion
								 ,e1.codestpro1,e1.denestpro1,e2.codestpro2,e2.denestpro2,e3.codestpro3,e3.denestpro3, '{$nomultimoEstructura}' as nombrenivelpr ";
				$cadenaFrom.=" INNER JOIN sfp_estpro1 as e1 ON e1.codemp=i.codemp and e1.ano_presupuesto=i.ano_presupuesto and e1.codestpro1=i.codestpro1 
							   INNER JOIN sfp_estpro2 as e2 ON e2.codemp=i.codemp and e2.ano_presupuesto=i.ano_presupuesto and e2.codestpro1=i.codestpro1 and e2.codestpro2=i.codestpro2
							   INNER JOIN sfp_estpro3 as e3 ON e3.codemp=i.codemp and e3.ano_presupuesto=i.ano_presupuesto and e3.codestpro1=i.codestpro1 and e3.codestpro2=i.codestpro2 and e3.codestpro3=i.codestpro3";
				break;
			case 4:
				$nomultimoEstructura = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anpresupuesto, 'PR');
				$strCodigo     =$conexionBaseDatos->Concat("substr(e1.codestpro1,length(e1.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(e1.codestpro1) )","'-'",
														   "substr(e2.codestpro2,length(e2.codestpro2)-".$arrnivelesEstructura[1]["numcar"]."+1,length(e2.codestpro2) )","'-'",
														   "substr(e3.codestpro3,length(e3.codestpro3)-".$arrnivelesEstructura[2]["numcar"]."+1,length(e3.codestpro3) )","'-'",
														   "substr(e4.codestpro4,length(e4.codestpro4)-".$arrnivelesEstructura[3]["numcar"]."+1,length(e4.codestpro4) )");
				$cadenaSelect .=",{$strCodigo} as codigo,e4.denestpro4 as Descripcion
								 ,e1.codestpro1,e1.denestpro1,e2.codestpro2,e2.denestpro2,e3.codestpro3,e3.denestpro3
								 ,e4.codestpro4,e4.denestpro4,'{$nomultimoEstructura}' as nombrenivelpr ";
				$cadenaFrom.=" INNER JOIN sfp_estpro1 as e1 ON e1.codemp=i.codemp and e1.ano_presupuesto=i.ano_presupuesto and e1.codestpro1=i.codestpro1 
							   INNER JOIN sfp_estpro2 as e2 ON e2.codemp=i.codemp and e2.ano_presupuesto=i.ano_presupuesto and e2.codestpro1=i.codestpro1 and e2.codestpro2=i.codestpro2
							   INNER JOIN sfp_estpro3 as e3 ON e3.codemp=i.codemp and e3.ano_presupuesto=i.ano_presupuesto and e3.codestpro1=i.codestpro1 and e3.codestpro2=i.codestpro2 and e3.codestpro3=i.codestpro3 
							   INNER JOIN sfp_estpro4 as e4 ON e4.codemp=i.codemp and e4.ano_presupuesto=i.ano_presupuesto and e4.codestpro1=i.codestpro1 and e4.codestpro2=i.codestpro2 and e4.codestpro3=i.codestpro3 and e4.codestpro4=i.codestpro4";
				break;
		    case 5:
		    	$nomultimoEstructura = $this->servicioConfiguracionNivel->obtenerNombreUlitmoNivel($codemp, $anpresupuesto, 'PR');
				$strCodigo     =$conexionBaseDatos->Concat("substr(e1.codestpro1,length(e1.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(e1.codestpro1) )","'-'",
														   "substr(e2.codestpro2,length(e2.codestpro2)-".$arrnivelesEstructura[1]["numcar"]."+1,length(e2.codestpro2) )","'-'",
														   "substr(e3.codestpro3,length(e3.codestpro3)-".$arrnivelesEstructura[2]["numcar"]."+1,length(e3.codestpro3) )","'-'",
														   "substr(e4.codestpro4,length(e4.codestpro4)-".$arrnivelesEstructura[3]["numcar"]."+1,length(e4.codestpro4) )","'-'",
														   "substr(e5.codestpro5,length(e5.codestpro5)-".$arrnivelesEstructura[4]["numcar"]."+1,length(e5.codestpro5) )");
				$cadenaSelect .=",{$strCodigo} as codigo,e5.denestpro5 as Descripcion
								 ,e1.codestpro1,e1.denestpro1,e2.codestpro2,e2.denestpro2,e3.codestpro3,e3.denestpro3
								 ,e4.codestpro4,e4.denestpro4,e5.codestpro5,e5.denestpro5,'{$nomultimoEstructura}' as nombrenivelpr ";
				$cadenaFrom.=" INNER JOIN sfp_estpro1 as e1 ON e1.codemp=i.codemp and e1.ano_presupuesto=i.ano_presupuesto and e1.codestpro1=i.codestpro1 
							   INNER JOIN sfp_estpro2 as e2 ON e2.codemp=i.codemp and e2.ano_presupuesto=i.ano_presupuesto and e2.codestpro1=i.codestpro1 and e2.codestpro2=i.codestpro2
							   INNER JOIN sfp_estpro3 as e3 ON e3.codemp=i.codemp and e3.ano_presupuesto=i.ano_presupuesto and e3.codestpro1=i.codestpro1 and e3.codestpro2=i.codestpro2 and e3.codestpro3=i.codestpro3 
							   INNER JOIN sfp_estpro4 as e4 ON e4.codemp=i.codemp and e4.ano_presupuesto=i.ano_presupuesto and e4.codestpro1=i.codestpro1 and e4.codestpro2=i.codestpro2 and e4.codestpro3=i.codestpro3 and e4.codestpro4=i.codestpro4 
							   INNER JOIN sfp_estpro5 as e5 ON e5.codemp=i.codemp and e5.ano_presupuesto=i.ano_presupuesto and e5.codestpro1=i.codestpro1 and e5.codestpro2=i.codestpro2 and e5.codestpro3=i.codestpro3 and e5.codestpro4=i.codestpro4 and e5.codestpro5=i.codestpro5";
				break;
		}
		
		$arrCondicion['select'] = $cadenaSelect;
		$arrCondicion['from'] = $cadenaFrom;
		unset($conexionBaseDatos);
		
		return $arrCondicion;
		
	}
	
	public function resumenCreditoPartida($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = " (select '401' as grupo,'Gastos de Personal' as denominacion,
		                       coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
		                       coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '401%'),00) as montoanant, 
		                       coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '401%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '401%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '402' as grupo,'Materiales, Suministros y Mercancia' as denominacion,
						        coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre,
						        coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '402%'),000) as montoanant,
						        coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '402%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '402%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '403' as grupo,'Servicios no Personales' as denominacion,
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre,
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '403%'),000) as montoanant,
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '403%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '403%' and spe_int_cuentas.codemp='{$codemp}' and 
								  spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '404' as grupo,'Activos Reales' as denominacion,
						 		coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre,
						 		coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '404%'),000) as montoanant,
						 		coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '404%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '404%' and spe_int_cuentas.codemp='{$codemp}' and 
								  spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '405' as grupo,'Activos Financieros' as denominacion, 
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '405%'),000) as montoanant, 
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '405%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '405%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '407' as grupo,'Transferencias y Donaciones' as denominacion, 
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '407%'),000) as montoanant, 
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '407%'),000) as montoanreal
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '407%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '408' as grupo,'Otros Gastos' as denominacion, 
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '408%'),000) as montoanant, 
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '408%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '408%' and spe_int_cuentas.codemp='{$codemp}' and 
								  spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
						union
						(select '411' as grupo,'Disminucion de Pasivos' as denominacion, 
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '411%'),000) as montoanant, 
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '411%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '411%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')
					    union
						(select '498' as grupo,'Rectificacion al Presupuesto' as denominacion, 
								coalesce(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) as Montopre, 
								coalesce((select sum(monto_anest) from sigesp_sfp_plancuentas where sig_cuenta like '498%'),000) as montoanant, 
								coalesce((select sum(monto_anreal) from sigesp_sfp_plancuentas where sig_cuenta like '498%'),000) as montoanreal 
							from spe_int_cuentas 
							where spe_int_cuentas.sig_cuenta like '498%' and spe_int_cuentas.codemp='{$codemp}' and 
							      spe_int_cuentas.ano_presupuesto='{$annoPresupuesto}')";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarTransferenciasGastos($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arregloData = null;
		
		$cadenaSql0 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		              	from sigesp_plan_unico_re 
		              		inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		             	where spe_int_cuentas.sig_cuenta like '4050102%' and 
		             		  spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet0 = $conexionBaseDatos->Execute($cadenaSql0);
		$cadenaSql1 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070103%' and 
		                      spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet1 = $conexionBaseDatos->Execute($cadenaSql1);
		$cadenaSql2 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                 	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070104%' and 
		                	  spe_int_cuentas.codemp='{$codemp}' and  
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet2 = $conexionBaseDatos->Execute($cadenaSql2);
		$cadenaSql3 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070303%' and 
		                	  spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet3 = $conexionBaseDatos->Execute($cadenaSql3);
		$cadenaSql4 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                     (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                     spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                     spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                     spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070304%' and 
		                	  spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet4 = $conexionBaseDatos->Execute($cadenaSql4);
		$cadenaSql5 = "select sum(spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                          spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                          spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                          spe_int_cuentas.diciembre) as suma 
		                from spe_int_cuentas 
		                where sig_cuenta like '4050102%' or sig_cuenta like '4070103%' or sig_cuenta like '4070104%' or 
		                      sig_cuenta like '4070303%' or sig_cuenta like '4070304%' and 
		                      spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet5 = $conexionBaseDatos->Execute($cadenaSql5);
		$arregloData = array($resultSet0,$resultSet1,$resultSet2,$resultSet3,$resultSet4,$resultSet5);
		
		unset($conexionBaseDatos);
		return $arregloData;
	}
	
	public function buscarTransferenciasGastosPrivados($codemp, $annoPresupuesto) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$arregloData = null;
		
		$cadenaSql0 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		              	from sigesp_plan_unico_re 
		              		inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		             	where spe_int_cuentas.sig_cuenta like '4070101%' and 
		             		  spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet0 = $conexionBaseDatos->Execute($cadenaSql0);
		$cadenaSql1 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070102%' and 
		                      spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet1 = $conexionBaseDatos->Execute($cadenaSql1);
		$cadenaSql2 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                 	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070301%' and 
		                	  spe_int_cuentas.codemp='{$codemp}' and  
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet2 = $conexionBaseDatos->Execute($cadenaSql2);
		$cadenaSql3 = "select sigesp_plan_unico_re.sig_cuenta, denominacion,
		                      (spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                      spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                      spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                      spe_int_cuentas.diciembre) as montoglobal 
		                from sigesp_plan_unico_re 
		                	inner join spe_int_cuentas on sigesp_plan_unico_re.sig_cuenta=substr(spe_int_cuentas.sig_cuenta,1,9) 
		                where spe_int_cuentas.sig_cuenta like '4070302%' and 
		                	  spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet3 = $conexionBaseDatos->Execute($cadenaSql3);
		$cadenaSql4 = "select sum(spe_int_cuentas.enero+spe_int_cuentas.febrero+spe_int_cuentas.marzo+spe_int_cuentas.abril+
		                          spe_int_cuentas.mayo+spe_int_cuentas.junio+spe_int_cuentas.julio+spe_int_cuentas.agosto+
		                          spe_int_cuentas.septiembre+spe_int_cuentas.octubre+spe_int_cuentas.noviembre+
		                          spe_int_cuentas.diciembre) as suma 
		                from spe_int_cuentas 
		                where sig_cuenta like '4070101%' or sig_cuenta like '4070102%' or sig_cuenta like '4070301%' or 
		                      sig_cuenta like '4070302%' and 
		                      spe_int_cuentas.codemp='{$codemp}' and 
		             		  spe_int_cuentas.ano_presupuesto={$annoPresupuesto}";
		$resultSet4 = $conexionBaseDatos->Execute($cadenaSql4);
		$arregloData = array($resultSet0,$resultSet1,$resultSet2,$resultSet3,$resultSet4);
		
		unset($conexionBaseDatos);
		return $arregloData;
	}
	
	public function consolidadoProyectoAccionesPartidas($codemp, $anPresupuesto) {
		$this->servicioEstructura = new  ServicioEstructuraPresupuestaria();
		$arrnivelesEstructura     = $this->servicioEstructura->obtenerConfiguracionEstructura($codemp, $anPresupuesto);
		$conexionBaseDatos        = ConexionBaseDatos::getInstanciaConexion();
		
		$cadenaCodestpro1 = "substr(spe_relacion_es.codestpro1,length(spe_relacion_es.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(spe_relacion_es.codestpro1) ) as codestpro1";
		
		$cadenaSql = "SELECT {$cadenaCodestpro1},sfp_estpro1.denestpro1,
		                     spe_int_cuentas.sig_cuenta,
		                     COALESCE(sum(enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre),000) AS montopre 
    					FROM spe_int_cuentas 
							INNER JOIN spe_relacion_es ON spe_int_cuentas.codemp=spe_relacion_es.codemp AND 
                                                          spe_int_cuentas.ano_presupuesto=spe_relacion_es.ano_presupuesto AND 
                                                          spe_int_cuentas.codinte=spe_relacion_es.codinte
							INNER JOIN sfp_estpro1     ON spe_relacion_es.codemp=sfp_estpro1.codemp AND 
                                      					  spe_relacion_es.ano_presupuesto=sfp_estpro1.ano_presupuesto AND
				      									  spe_relacion_es.codestpro1=sfp_estpro1.codestpro1	 	
    					WHERE spe_int_cuentas.codemp='{$codemp}' AND 
    					      spe_int_cuentas.ano_presupuesto={$anPresupuesto}    
    					GROUP BY spe_relacion_es.codestpro1,sfp_estpro1.denestpro1,spe_relacion_es.estcla,spe_int_cuentas.sig_cuenta
    					ORDER BY spe_relacion_es.codestpro1";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function consolidadoProyectoAccionesFuentes($codemp, $anPresupuesto) {
		$this->servicioEstructura = new  ServicioEstructuraPresupuestaria();
		$arrnivelesEstructura     = $this->servicioEstructura->obtenerConfiguracionEstructura($codemp, $anPresupuesto);
		$conexionBaseDatos        = ConexionBaseDatos::getInstanciaConexion();
		
		$cadenaCodestpro1 = "substr(spe_relacion_es.codestpro1,length(spe_relacion_es.codestpro1)-".$arrnivelesEstructura[0]["numcar"]."+1,length(spe_relacion_es.codestpro1) ) as codestpro1";
		
		$cadenaSql = "SELECT {$cadenaCodestpro1},sfp_estpro1.denestpro1,
							 spe_int_cuentas_dtrecursos.sig_cuenta_ing,COALESCE(sum(montoasig),000) AS montopre 
    					FROM spe_int_cuentas_dtrecursos 
							INNER JOIN spe_relacion_es ON spe_int_cuentas_dtrecursos.codemp=spe_relacion_es.codemp AND 
                                      					  spe_int_cuentas_dtrecursos.ano_presupuesto=spe_relacion_es.ano_presupuesto AND 
                                      					  spe_int_cuentas_dtrecursos.codinte=spe_relacion_es.codinte
							INNER JOIN sfp_estpro1     ON spe_relacion_es.codemp=sfp_estpro1.codemp AND 
                                      					  spe_relacion_es.ano_presupuesto=sfp_estpro1.ano_presupuesto AND
				      					                  spe_relacion_es.codestpro1=sfp_estpro1.codestpro1	 	
    					WHERE spe_int_cuentas_dtrecursos.codemp='{$codemp}' AND spe_int_cuentas_dtrecursos.ano_presupuesto={$anPresupuesto}    
    					GROUP BY spe_relacion_es.codestpro1,sfp_estpro1.denestpro1,spe_relacion_es.estcla,spe_int_cuentas_dtrecursos.sig_cuenta_ing
    					ORDER BY spe_relacion_es.codestpro1";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	
}
?>