<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_plancuenta.php");

class ServicioEstadoResultado {
	private $servicioPlanCuenta;
	
	public function ServicioEstadoResultado() {
		$this->servicioPlanCuenta = new ServicioPlanCuenta();
	}
	
	public function tieneMovimiento($codemp, $anPresupuesto, $grupoCuenta) {
		$movimiento = false; 
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select * 
						from spe_plan_ingr 
						where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' 
			  			and ano_presupuesto={$anPresupuesto}";
		$dataSet = $conexionBaseDatos->Execute ( $cadenaSql );
		if($dataSet->_numOfRows > 0){
			$movimiento = true;
		}
		else{
			$cadenaSql = "select sum(monto_anreal) as anreal, sum(monto_anest) as anest 
			     			from sigesp_sfp_plancuentas 
			     			where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' 
			     			and ano_presupuesto={$anPresupuesto}";
			$dataPlan  = $conexionBaseDatos->Execute($cadenaSql);
			if($dataPlan->fields["anreal"]>0 || $dataPlan->fields["anest"]>0){
				$movimiento = true;
			}
		}
		
		return $movimiento;
	}
	
	public function  tieneCxp($codemp, $anPresupuesto, $grupoCuenta){
		$tienecxp = false;	
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select * 
						from spe_plan_ingr 
						where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' 
			 			and ano_presupuesto={$anPresupuesto} 
			 			and (cuentaporcobrar<>'' and cuentaporcobrar is not null)";
		$dataSet = $conexionBaseDatos->Execute($cadenaSql);
		if($dataSet->_numOfRows > 0){
			$tienecxp = true;
		}
		
		return $tienecxp;
	}
	
	public function obtenerSaldo($codemp, $anPresupuesto, $cuenta, $frecuencia) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros    = uf_spg_cuenta_sin_cero($cuenta);
		$filtroFrecuencia  = '';
		
		if($this->tieneMovimiento($codemp, $anPresupuesto, $cuentasinceros)) {
			if(!$this->tieneCxp($codemp, $anPresupuesto,$cuentasinceros)){
				switch($frecuencia){
					case "Mensual":
						$filtroFrecuencia = 'COALESCE(sum(enero),0000) as enero,COALESCE(sum(febrero),000)as febrero,
						                     COALESCE(sum(marzo),000) as marzo,COALESCE(sum(abril),000) as abril,
						                     COALESCE(sum(mayo),000)as mayo,COALESCE(sum(junio),000) as junio,
						                     COALESCE(sum(julio),0000) as julio,COALESCE(sum(agosto),000) as agosto,
						                     COALESCE(sum(septiembre),000) as septiembre,COALESCE(sum(octubre),000) as octubre,
						                     COALESCE(sum(noviembre),000) as noviembre,COALESCE(sum(diciembre),000) as diciembre, 
						                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
						break;
					case "Bimensual":
						$filtroFrecuencia = 'COALESCE(sum((enero+febrero)),0000) as bimestre1,
						                     COALESCE(sum((marzo+abril)),000) as bimestre2,
						                     COALESCE(sum((mayo+junio)),000) as bimestre3, 
						                     COALESCE(sum((julio+agosto)),000) as bimestre4,
						                     COALESCE(sum((septiembre+octubre)),000) as bimestre5,
						                     COALESCE(sum((noviembre+diciembre)),000) as bimestre6, 
						                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
						break;
					case "Trimestral":
						$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo)),0000) as trimestre1,
						                     COALESCE(sum((abril+mayo+junio)),000) as trimestre2,
						                     COALESCE(sum((julio+agosto+septiembre)),000) as trimestre3, 
						                     COALESCE(sum((octubre+noviembre+diciembre)),000) as trimestre4, 
						                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';		
						break;
					case "Semestral":
						$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio)),0000) as semestre1, 
						                     COALESCE(sum((julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as semestre2, 
						                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
						break;
					case "Anual":
						$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoanual ';
						break;
				}
				$cadenaSql="SELECT (SELECT denominacion 
										FROM sigesp_sfp_plancuentas 
										WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
										      sig_cuenta='{$cuenta}')  as denominacion,
				                   COALESCE((SELECT sum(monto_anest) 
				                   				FROM sigesp_sfp_plancuentas 
				                   				WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				                   				sig_cuenta like '{$cuentasinceros}%'),0000) as anestimado,
								   COALESCE((SELECT sum(monto_anreal)  
								   				FROM sigesp_sfp_plancuentas 
								   				WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
								   				sig_cuenta like '{$cuentasinceros}%'),0000) as anreal,
				                   {$cuenta} as codcuenta,{$filtroFrecuencia} 
						 		FROM spe_plan_ingr 
						        WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
						              spe_plan_ingr.sig_cuenta like '{$cuentasinceros}%' and  
						              spe_plan_ingr.sig_cuenta not like '31101%'
						        GROUP BY codcuenta"; 
				$resultSet = $conexionBaseDatos->Execute ( $cadenaSql );
				unset($conexionBaseDatos);
			}
			else{
				switch($frecuencia){
					case "Mensual":
						$filtroFrecuencia = 'COALESCE(sum(enerocob),0000) as enero,COALESCE(sum(febrerocob),000)as febrero,
						                     COALESCE(sum(marzocob),000) as marzo , COALESCE(sum(abrilcob),000) as abril,
						                     COALESCE(sum(mayocob),000)as mayo,COALESCE(sum(juniocob),000) as junio,
							 				 COALESCE(sum(juliocob),0000)as julio ,COALESCE(sum(agostocob),000) as agosto,
							 				 COALESCE(sum(septiembrecob),000) as septiembre, COALESCE(sum(octubrecob),000) as octubre,
							 				 COALESCE(sum(noviembrecob),000) as noviembre,COALESCE(sum(diciembrecob),000) as diciembre ';
						break;
					case "Bimensual":
						$filtroFrecuencia = 'COALESCE(sum((enerocob+febrerocob)),0000) as bimestre1,COALESCE(sum((marzocob+abrilcob)),000) as bimestre2,
						                     COALESCE(sum((mayocob+juniocob)),000) as bimestre3, COALESCE(sum((juliocob+agostocob)),000) as bimestre4,
						                     COALESCE(sum((septiembrecob+octubrecob)),000) as bimestre5,COALESCE(sum((noviembrecob+diciembrecob)),000) as bimestre6 ';
						break;
					case "Trimestral":
						$filtroFrecuencia = 'COALESCE(sum((enerocob+febrerocob+marzocob)),0000) as trimestre1,
						                     COALESCE(sum((abrilcob+mayocob+juniocob)),000) as trimestre2,
						                     COALESCE(sum((juliocob+agostocob+septiembrecob)),000) as trimestre3, 
						                     COALESCE(sum((octubrecob+noviembrecob+diciembrecob)),000) as trimestre4 ';		
						break;
					case "Semestral":
						$filtroFrecuencia = 'COALESCE(sum((enerocob+febrerocob+marzocob+abrilcob+mayocob+juniocob)),0000) as semestre1,
						                     COALESCE(sum((juliocob+agostocob+septiembrecob+octubrecob+noviembrecob+diciembrecob)),000) as semestre2 ';
						break;
					case "Anual":
						$filtroFrecuencia = 'COALESCE(sum((enerocob+febrerocob+marzocob+abrilcob+mayocob+juniocob+juliocob+agostocob+septiembrecob+octubrecob+noviembrecob+diciembrecob)),000) as montoanual ';
						break;
				}
				
				$cadenaSql = "SELECT (SELECT denominacion 
				                      	FROM sigesp_sfp_plancuentas 
				                      	WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				                      	      sig_cuenta='{$cuenta}')  as denominacion,
				             		 COALESCE((SELECT sum(monto_anest) 
				             		 				FROM sigesp_sfp_plancuentas 
				             		 				WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				             		 				      sig_cuenta like '{$cuentasinceros}%'),0000) as anestimado,
				                	 COALESCE((SELECT sum(monto_anreal) 
				                	 				FROM sigesp_sfp_plancuentas 
				                	 				WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				                	 				      sig_cuenta like '{$cuentasinceros}%'),0000) as anrea,
				                     {$cuenta} as codcuenta,{$filtroFrecuencia}
							 	FROM spe_plan_ingr 
						 		WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
						              spe_plan_ingr.sig_cuenta like '{$cuentasinceros}%' and  
						              spe_plan_ingr.sig_cuenta not like '31101%' 
						 		GROUP BY codcuenta"; 
				$resultSet = $conexionBaseDatos->Execute ( $cadenaSql );
				unset($conexionBaseDatos);
			}
		}
		else{
			return false;
		}
		
		return $resultSet;
	}
	
	public function tieneMovimientoGasto($codemp, $anPresupuesto, $grupoCuenta) {
		$tieneMovimiento = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "select * 
						from spe_int_cuentas 
						where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' and ano_presupuesto={$anPresupuesto}";
		$dataSet = $conexionBaseDatos->Execute ( $cadenaSql );
		if($dataSet->_numOfRows > 0){
			$tieneMovimiento = true;
		}
		
		if($tieneMovimiento == false){
			$cadenaSql = "select sum(monto_anreal) as anreal, sum(monto_anest) as anest 
							from sigesp_sfp_plancuentas 
							where sig_cuenta like '{$grupoCuenta}%' and codemp='{$codemp}' and ano_presupuesto={$anPresupuesto}";
			$rs = $conexionBaseDatos->Execute ( $cadenaSql );
			if($rs->fields["anreal"]>0 || $rs->fields["anest"]>0)
			{
				$tieneMovimiento=true;
			}
		}
		return $tieneMovimiento;
	}
	
	public function obtenerSaldoGasto($codemp, $anPresupuesto, $cuenta, $frecuencia) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cuentasinceros    = uf_spg_cuenta_sin_cero($cuenta);
		$filtroFrecuencia  = '';
		
		if($this->tieneMovimientoGasto($codemp, $anPresupuesto, $cuentasinceros)) {
			switch($frecuencia){
				case "Mensual":
					$filtroFrecuencia = 'COALESCE(sum(enero),0000) as enero,COALESCE(sum(febrero),000)as febrero,
					                     COALESCE(sum(marzo),000) as marzo,COALESCE(sum(abril),000) as abril,
					                     COALESCE(sum(mayo),000)as mayo,COALESCE(sum(junio),000) as junio,
					                     COALESCE(sum(julio),0000) as julio,COALESCE(sum(agosto),000) as agosto,
					                     COALESCE(sum(septiembre),000) as septiembre,COALESCE(sum(octubre),000) as octubre,
					                     COALESCE(sum(noviembre),000) as noviembre,COALESCE(sum(diciembre),000) as diciembre, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Bimensual":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero)),0000) as bimestre1,
					                     COALESCE(sum((marzo+abril)),000) as bimestre2,
					                     COALESCE(sum((mayo+junio)),000) as bimestre3, 
					                     COALESCE(sum((julio+agosto)),000) as bimestre4,
					                     COALESCE(sum((septiembre+octubre)),000) as bimestre5,
					                     COALESCE(sum((noviembre+diciembre)),000) as bimestre6, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Trimestral":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo)),0000) as trimestre1,
					                     COALESCE(sum((abril+mayo+junio)),000) as trimestre2,
					                     COALESCE(sum((julio+agosto+septiembre)),000) as trimestre3, 
					                     COALESCE(sum((octubre+noviembre+diciembre)),000) as trimestre4, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';		
					break;
				case "Semestral":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio)),0000) as semestre1, 
					                     COALESCE(sum((julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as semestre2, 
					                     COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montototal ';
					break;
				case "Anual":
					$filtroFrecuencia = 'COALESCE(sum((enero+febrero+marzo+abril+mayo+junio+julio+agosto+septiembre+octubre+noviembre+diciembre)),000) as montoanual ';
					break;
			}
			$cadenaSql = "SELECT (SELECT denominacion 
									FROM sigesp_sfp_plancuentas 
									WHERE codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
									      sig_cuenta='{$cuenta}') as denominaciongas,
						     	 COALESCE((SELECT sum(monto_anest) 
						     	   				FROM sigesp_sfp_plancuentas 
						     	   				WHERE codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
						     	   				      sig_cuenta like '{$cuentasinceros}%'),0000) as anestimadogas,
						     	 COALESCE((SELECT sum(monto_anreal)  
						     	  				FROM sigesp_sfp_plancuentas 
						     	  				WHERE codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and 
						     	  					  sig_cuenta like '{$cuentasinceros}%'),0000) as anrealgas,
			                     {$cuenta} as codcuentagas,{$filtroFrecuencia} 
				 	from  spe_int_cuentas 
				 	where codemp='{$codemp}' and ano_presupuesto={$anPresupuesto} and 
				 	      spe_int_cuentas.sig_cuenta like '{$cuentasinceros}%'";
			$resultSet = $conexionBaseDatos->Execute ($cadenaSql);
			unset($conexionBaseDatos);
		}
		else{
			return false;
		}
		
		return $resultSet;
	}
	
	public function obtenerDatosPorDefecto() {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "select '' as denominacion,'' as anestimado,'' as anreal,'' as codcuenta,'' as trimestre1, '' as trimestre2, '' as trimestre3, '' as trimestre4, 
		 					         '' as enero, '' as febrero, '' as marzo, '' as abril,'' as mayo, '' as junio,'' as julio,'' as agosto, '' as septiembre, '' as octubre, '' as noviembre, '' as diciembre,
		  							 '' as bimestre1, '' as bimestre2, '' as bimestre3, '' as bimestre4, '' as bimestre5, '' as bimestre6, '' as semestre1, '' as semestre2, '' as montoglobal from sigesp_empresa";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function reporteEstadoResultado($codemp, $anPresupuesto, $nivel, $frecuencia) {
		$arrDatos   = array();
		$datastore0 = array();
	    $datastore1 = array();
	    $totaling   = array();
	    $totalgas   = array();
	    $resultado  = array();
	    
	    //BUSCANDO LA CUENTAS DE INGRESO
	    $rsGrupo        = $this->servicioPlanCuenta->obtenerGrupoPlanCuenta($codemp, $anPresupuesto, '3', array('302','311'));
		$cuentaImp      = '';
		while(!$rsGrupo->EOF){
			$cuentaImp = trim($rsGrupo->fields['sig_cuenta']);
			if ($this->servicioPlanCuenta->verificarNivelCuenta($codemp, $cuentaImp, $nivel,'I')) {
				$resp = $this->obtenerSaldo($codemp, $anPresupuesto, $cuentaImp, $frecuencia);
				if($resp!=false){
					$datastore0[]  = $resp;
					$cuentaValidar = str_pad(substr($cuentaImp, 0, 3),strlen($cuentaImp),0,STR_PAD_RIGHT);
					if ($cuentaImp==$cuentaValidar && substr($cuentaImp, 0, 3)!='304') {
						switch($frecuencia){
							case "Mensual":
								$totaling['anestimado'] += $resp->fields['anestimado'];
								$totaling['anreal']     += $resp->fields['anreal'];
								$totaling['enero']   	+= $resp->fields['enero'];
								$totaling['febrero']    += $resp->fields['febrero'];
								$totaling['marzo']   	+= $resp->fields['marzo'];
								$totaling['abril']   	+= $resp->fields['abril'];
								$totaling['mayo']    	+= $resp->fields['mayo'];
								$totaling['junio']   	+= $resp->fields['junio'];
								$totaling['julio']   	+= $resp->fields['julio'];
								$totaling['agosto']  	+= $resp->fields['agosto'];
								$totaling['septiembre'] += $resp->fields['septiembre'];
								$totaling['octubre']    += $resp->fields['octubre'];
								$totaling['noviembre']  += $resp->fields['noviembre'];
								$totaling['diciembre']  += $resp->fields['diciembre'];
								$totaling['total']      += $resp->fields['montototal'];
								break;
							case "Bimensual":
								$totaling['anestimado'] += $resp->fields['anestimado'];
								$totaling['anreal']     += $resp->fields['anreal'];
								$totaling['bimestre1']  += $resp->fields['bimestre1'];
								$totaling['bimestre2'] 	+= $resp->fields['bimestre2'];
								$totaling['bimestre3'] 	+= $resp->fields['bimestre3'];
								$totaling['bimestre4']  += $resp->fields['bimestre4'];
								$totaling['bimestre5']  += $resp->fields['bimestre5'];
								$totaling['bimestre6']  += $resp->fields['bimestre6'];
								$totaling['total']      += $resp->fields['montototal'];
								break;
							case "Trimestral":
								$totaling['anestimado'] += $resp->fields['anestimado'];
								$totaling['anreal']     += $resp->fields['anreal'];
								$totaling['trimestre1'] += $resp->fields['trimestre1'];
								$totaling['trimestre2'] += $resp->fields['trimestre2'];
								$totaling['trimestre3'] += $resp->fields['trimestre3'];
								$totaling['trimestre4'] += $resp->fields['trimestre4'];
								$totaling['total']      += $resp->fields['montototal'];
								break;
							case "Semestral":
								$totaling['anestimado'] += $resp->fields['anestimado'];
								$totaling['anreal']     += $resp->fields['anreal'];
								$totaling['semestre1']  += $resp->fields['semestre1'];
								$totaling['semestre2']  += $resp->fields['semestre2'];
								$totaling['total']      += $resp->fields['montototal'];
								break;
							case "Anual":
								$totaling['anestimado'] += $resp->fields['anestimado'];
								$totaling['anreal']     += $resp->fields['anreal'];
								$totaling['total']      += $resp->fields['montoanual'];
								break;
						}
					}	
				}	
			}
			unset($resp);
			$rsGrupo->MoveNext();
		}
		$rsGrupo->Close();
		unset($rsGrupo);
		
		//BUSCANDO LAS CUENTAS DE GASTO
		$rsGrupo        = $this->servicioPlanCuenta->obtenerGrupoPlanCuenta($codemp, $anPresupuesto, '4', array('404','411'));
		$cuentaImp      = '';
		while(!$rsGrupo->EOF){
			$cuentaImp = trim($rsGrupo->fields['sig_cuenta']);
			if ($this->servicioPlanCuenta->verificarNivelCuenta($codemp, $cuentaImp, $nivel,'G')) {
				$resp = $this->obtenerSaldoGasto($codemp, $anPresupuesto, $cuentaImp, $frecuencia);
				if($resp!=false){		  						
					$datastore1[]=$resp;
					$cuentaValidar = str_pad(substr($cuentaImp, 0, 3),strlen($cuentaImp),0,STR_PAD_RIGHT);
					if ($cuentaImp==$cuentaValidar) {
						switch($frecuencia){
							case "Mensual":
								$totalgas['anestimado'] += $resp->fields['anestimadogas'];
								$totalgas['anreal']     += $resp->fields['anrealgas'];
								$totalgas['enero']   	+= $resp->fields['enero'];
								$totalgas['febrero']    += $resp->fields['febrero'];
								$totalgas['marzo']   	+= $resp->fields['marzo'];
								$totalgas['abril']   	+= $resp->fields['abril'];
								$totalgas['mayo']    	+= $resp->fields['mayo'];
								$totalgas['junio']   	+= $resp->fields['junio'];
								$totalgas['julio']   	+= $resp->fields['julio'];
								$totalgas['agosto']  	+= $resp->fields['agosto'];
								$totalgas['septiembre'] += $resp->fields['septiembre'];
								$totalgas['octubre']    += $resp->fields['octubre'];
								$totalgas['noviembre']  += $resp->fields['noviembre'];
								$totalgas['diciembre']  += $resp->fields['diciembre'];
								$totalgas['total']      += $resp->fields['montototal'];
								break;
							case "Bimensual":
								$totalgas['anestimado'] += $resp->fields['anestimadogas'];
								$totalgas['anreal']     += $resp->fields['anrealgas'];
								$totalgas['bimestre1']  += $resp->fields['bimestre1'];
								$totalgas['bimestre2'] 	+= $resp->fields['bimestre2'];
								$totalgas['bimestre3'] 	+= $resp->fields['bimestre3'];
								$totalgas['bimestre4']  += $resp->fields['bimestre4'];
								$totalgas['bimestre5']  += $resp->fields['bimestre5'];
								$totalgas['bimestre6']  += $resp->fields['bimestre6'];
								$totalgas['total']      += $resp->fields['montototal'];
								break;
							case "Trimestral":
								$totalgas['anestimado'] += $resp->fields['anestimadogas'];
								$totalgas['anreal']     += $resp->fields['anrealgas'];
								$totalgas['trimestre1'] += $resp->fields['trimestre1'];
								$totalgas['trimestre2'] += $resp->fields['trimestre2'];
								$totalgas['trimestre3'] += $resp->fields['trimestre3'];
								$totalgas['trimestre4'] += $resp->fields['trimestre4'];
								$totalgas['total']      += $resp->fields['montototal'];
								break;
							case "Semestral":
								$totalgas['anestimado'] += $resp->fields['anestimadogas'];
								$totalgas['anreal']     += $resp->fields['anrealgas'];
								$totalgas['semestre1']  += $resp->fields['semestre1'];
								$totalgas['semestre2']  += $resp->fields['semestre2'];
								$totalgas['total']      += $resp->fields['montototal'];
								break;
							case "Anual":
								$totalgas['anestimado'] += $resp->fields['anestimadogas'];
								$totalgas['anreal']     += $resp->fields['anrealgas'];
								$totalgas['total']      += $resp->fields['montoanual'];
								break;
						}
					}	
				}
			}
			unset($resp);
			$rsGrupo->MoveNext();
		}
		$rsGrupo->Close();
		unset($rsGrupo);
	    
		//CALCULANDO EL RESULTADO
		switch($frecuencia){
			case "Mensual":
				$resultado['anestimado'] = $totaling['anestimado'] - $totalgas['anestimado'];
				$resultado['anreal'] 	 = $totaling['anreal'] - $totalgas['anreal'];
				$resultado['enero']   	 = $totaling['enero'] - $totalgas['enero'];
				$resultado['febrero'] 	 = $totaling['febrero'] - $totalgas['febrero'];
				$resultado['marzo']   	 = $totaling['marzo'] - $totalgas['marzo'];
				$resultado['abril']   	 = $totaling['abril'] - $totalgas['abril'];
				$resultado['mayo']    	 = $totaling['mayo'] - $totalgas['mayo'];
				$resultado['junio']   	 = $totaling['junio'] - $totalgas['junio'];
				$resultado['julio']   	 = $totaling['julio'] - $totalgas['julio'];
				$resultado['agosto']  	 = $totaling['agosto'] - $totalgas['agosto'];
				$resultado['septiembre'] = $totaling['septiembre'] - $totalgas['septiembre'];
				$resultado['octubre']    = $totaling['octubre'] - $totalgas['octubre'];
				$resultado['noviembre']  = $totaling['noviembre'] - $totalgas['noviembre'];
				$resultado['diciembre']  = $totaling['diciembre'] - $totalgas['diciembre'];
				$resultado['total']      = $totaling['total'] - $totalgas['total'];
				break;
			case "Bimensual":
				$resultado['anestimado'] = $totaling['anestimado'] - $totalgas['anestimado'];
				$resultado['anreal'] 	 = $totaling['anreal'] - $totalgas['anreal'];
				$resultado['bimestre1']  = $totaling['bimestre1'] - $totalgas['bimestre1'];
				$resultado['bimestre2']  = $totaling['bimestre2'] - $totalgas['bimestre2'];
				$resultado['bimestre3']  = $totaling['bimestre3'] - $totalgas['bimestre3'];
				$resultado['bimestre4']  = $totaling['bimestre4'] - $totalgas['bimestre4'];
				$resultado['bimestre5']  = $totaling['bimestre5'] - $totalgas['bimestre5'];
				$resultado['bimestre6']  = $totaling['bimestre6'] - $totalgas['bimestre6'];
				$resultado['total']      = $totaling['total'] - $totalgas['total'];
				break;
			case "Trimestral":
				$resultado['anestimado'] = $totaling['anestimado'] - $totalgas['anestimado'];
				$resultado['anreal'] 	 = $totaling['anreal'] - $totalgas['anreal'];
				$resultado['trimestre1']  = $totaling['trimestre1'] - $totalgas['trimestre1'];
				$resultado['trimestre2']  = $totaling['trimestre2'] - $totalgas['trimestre2'];
				$resultado['trimestre3']  = $totaling['trimestre3'] - $totalgas['trimestre3'];
				$resultado['trimestre4']  = $totaling['trimestre4'] - $totalgas['trimestre4'];
				$resultado['total']       = $totaling['total'] - $totalgas['total'];
				break;
			case "Semestral":
				$resultado['anestimado'] = $totaling['anestimado'] - $totalgas['anestimado'];
				$resultado['anreal'] 	 = $totaling['anreal'] - $totalgas['anreal'];
				$resultado['semestre1']  = $totaling['semestre1'] - $totalgas['semestre1'];
				$resultado['semestre2']  = $totaling['semestre2'] - $totalgas['semestre2'];
				$resultado['total']      = $totaling['total'] - $totalgas['total'];
				break;
			case "Anual":
				$resultado['anestimado'] = $totaling['anestimado'] - $totalgas['anestimado'];
				$resultado['anreal'] 	 = $totaling['anreal'] - $totalgas['anreal'];
				$resultado['total']      = $totaling['total'] - $totalgas['total'];
				break;
		}
		unset($totaling);
		unset($totalgas);
		
		
   		$arrDatos["datos0"]=$datastore0;
		$arrDatos["datos1"]=$datastore1;
		$arrDatos["resultado"]=$resultado;
		return  $arrDatos;
	}
}