<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv."/modelo/servicio/sfp/sigesp_srv_sfp_iempresa.php");

class ServicioEmpresa implements iempresa {
	private $daoEmpresa;
	private $daoEmpresaSigesp;
	private $conexionBaseDatos;
	
	public function ServicioEmpresa() {
		$this->daoEmpresa=null;
		$this->daoEmpresaSigesp=null;
	}
	
	public function guardarEmpresa($codemp, $objson, $arrevento) {
		DaoGenerico::iniciarTrans();
		$resultado="0";
		$this->daoEmpresa = FabricaDao::CrearDAO("N", "sfp_empresa");
		$this->daoEmpresa->setData($objson);
		$this->daoEmpresa->codemp = str_pad($objson->codemp,4,"0",STR_PAD_LEFT);
		$this->daoEmpresa->emprin = $codemp;
		$resultado = $this->daoEmpresa->incluir(true,"codemp",true,4);
		//completando la transaccion retorna 1 si no hay errores
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if(DaoGenerico::completarTrans()) {
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$resultado="1";
			$this->mensaje.='Registro guardado con exito';
		}
		else{
			$servicioEvento->tipoevento=false;
			$servicioEvento->incluirEvento();
			$this->mensaje.='Ocurrio un error al guardar el registro';
		}
		unset($this->daoEmpresa);
		return $resultado;
	}
	
	public function buscarEmpresas() { 
		$this->daoEmpresa = FabricaDao::CrearDAO("N", "sfp_empresa");
		$dataempresa = $this->daoEmpresa->leerTodos('codemp',1,'');
		unset($this->daoEmpresa);
		return $dataempresa;
	}
	
	public function buscarCodigoEmpresa() {
		$this->daoEmpresa = FabricaDao::CrearDAO("N", "sfp_empresa");
		$codigo = $this->daoEmpresa->buscarCodigo("codemp",false,4);
		unset($this->daoEmpresa);
		return $codigo;
	}
	
	public function buscarFormatosCuenta($codemp) {
		$arrformatos = array();
		$this->daoEmpresaSigesp = FabricaDao::CrearDAO("N", "sigesp_empresa");
		$dtoEmpresa = $this->daoEmpresaSigesp->getObjetoDto("codemp='".$codemp."'");
		$arrformatos[0]=$dtoEmpresa->formpre;
		$arrformatos[1]=$dtoEmpresa->formspi;
		unset($this->daoEmpresaSigesp);
		unset($dtoEmpresa);
		return $arrformatos;
	}
	
	public function nuevaEmpresa($codemp) {
		$arrnuevo    = array();
		$arrformatos = array();
		$arrnuevo[0] = $this->buscarCodigoEmpresa();
		$arrformatos = $this->buscarFormatosCuenta($codemp);
		$arrnuevo[1] = $arrformatos[0];
		$arrnuevo[2] = $arrformatos[1];
		
		unset($arrformatos);
		return $arrnuevo;
	}
	
	public function eliminarEmpresa($codemp,$objson,$arrevento) {
		DaoGenerico::iniciarTrans();
		$resultado="0";
		$this->daoEmpresa = FabricaDao::CrearDAO("N", "sfp_empresa");
		$this->daoEmpresa->setData($objson);
		$this->daoEmpresa->codemp = str_pad($objson->codemp,4,"0",STR_PAD_LEFT);
		$this->daoEmpresa->emprin = $codemp;
		$resultado = $this->daoEmpresa->eliminar();
		//completando la transaccion retorna 1 si no hay errores
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if(DaoGenerico::completarTrans()) {
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$resultado="1";
			$this->mensaje.='Registro eliminado con exito';
		}
		else{
			$servicioEvento->tipoevento=false;
			$servicioEvento->incluirEvento();
			$this->mensaje.='Ocurrio un error al eliminar el registro';
		}
		unset($this->daoEmpresa);
		return $resultado;
	}
	
	public function buscarEmpresa($codemp) {
		$cadenasql = "select sigesp_empresa.nomorgads, sfp_empresa.nombre  
    		  		  from sfp_empresa left outer
    		  		  join sigesp_empresa on 
    		  		  sfp_empresa.emprin=sigesp_empresa.codemp where sfp_empresa.codemp='{$codemp}'";
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$data  = $conbd->Execute ( $cadenasql );
		unset($conbd);
		return $data;
	}
	
	public function modificarEmpresa($codemp,$objson,$arrevento) {
		DaoGenerico::iniciarTrans();
		$resultado="0";
		$strPk = "codemp = '{$objson->codemp}'";
		$this->daoEmpresa = FabricaDao::CrearDAO("C", "sfp_empresa", null, $strPk);
		$this->daoEmpresa->setData($objson);
		$this->daoEmpresa->codemp = str_pad($objson->codemp,4,"0",STR_PAD_LEFT);
		$this->daoEmpresa->emprin = $codemp;
		$resultado = $this->daoEmpresa->modificar();
		//completando la transaccion retorna 1 si no hay errores
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if(DaoGenerico::completarTrans()) {
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$resultado="1";
			$this->mensaje.='Registro modificado con Exito';
		}
		else{
			$servicioEvento->tipoevento=false;
			$servicioEvento->incluirEvento();
			$this->mensaje.='Ocurrio un error al guardar el registro';
		}
		unset($this->daoEmpresa);
		return $resultado;
	}
	
	public function buscarDataEmpresa($codemp) {
		$cadenasql = "select * from sfp_empresa where codemp='{$codemp}'";
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$data  = $conbd->Execute ( $cadenasql );
		unset($conbd);
		return $data;
	}
}
?>