<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
class ServicioCuentaIntegrada {
	private $daoCuentaIntegrada;
	
	public function ServicioCuentaIntegrada() {
		$this->daoCuentaIntegrada = null;
	}
	
	public function procesarCuenta($codemp, $arrJson) {
		$respuesta = 0;
		if ($this->existeCuenta($codemp, $arrJson->sig_cuenta)) {
			if($this->modificarCuentaIntegrada($codemp, $arrJson)) {
				$respuesta = 2;
			}
		}
		else {
			if ($this->guardarCuentaIntegrada($codemp, $arrJson)) {
				$respuesta = 1;
			}
		}
		
		return $respuesta;
	}
	
	public function guardarCuentaIntegrada($codemp, $arrJson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoCuentaIntegrada = FabricaDao::CrearDAO('N', 'sigesp_sfp_asociacion');
		$this->daoCuentaIntegrada->setData($arrJson);
		$this->daoCuentaIntegrada->codemp = $codemp;
		$this->daoCuentaIntegrada->incluir();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function modificarCuentaIntegrada($codemp, $arrJson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoCuentaIntegrada = FabricaDao::CrearDAO('N', 'sigesp_sfp_asociacion');
		$this->daoCuentaIntegrada->setData($arrJson);
		$this->daoCuentaIntegrada->codemp = $codemp;
		$this->daoCuentaIntegrada->modificar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function eliminarCuentaIntegrada($codemp, $arrJson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoCuentaIntegrada = FabricaDao::CrearDAO('N', 'sigesp_sfp_asociacion');
		$this->daoCuentaIntegrada->setData($arrJson);
		$this->daoCuentaIntegrada->codemp = $codemp;
		$this->daoCuentaIntegrada->eliminar();
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function existeCuenta($codemp, $cuenta) {
		$existe = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT sig_cuenta 
								FROM sigesp_sfp_asociacion 
								WHERE codemp = '{$codemp}' AND sig_cuenta = '{$cuenta}'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if($dataSet->_numOfRows > 0){
			$existe = true;
		}
		unset($conexionBaseDatos);
		unset($dataSet);
		return $existe;
	}
	
	public function buscarCuentaPresupuestaria($codCuenta,$denCuenta) {
		$cadenaFiltro = "";
		if($codCuenta != ''){
			$cadenaFiltro .= " sig_cuenta like {$codCuenta} ";
		}
		
		if($cadenaFiltro != '') {
			if ($denCuenta != '') {
				$cadenaFiltro .= "AND denominacion like {$denCuenta} ";
			}
		}
		else{
			if ($denCuenta != '') {
				$cadenaFiltro .= " denominacion like {$denCuenta} ";
			}
		}
		
		if($cadenaFiltro!=''){
			$cadenaFiltro = 'WHERE '.$cadenaFiltro;
		}
		
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT sig_cuenta as codigo,denominacion 
								FROM sigesp_plan_unico_re ".$cadenaFiltro." 
								ORDER BY sig_cuenta";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarCuentaContable($codCuenta,$denCuenta) {
		$cadenaFiltro = "";
		if($codCuenta != ''){
			$cadenaFiltro .= " sc_cuenta like {$codCuenta} ";
		}
		
		if($cadenaFiltro != '') {
			if ($denCuenta != '') {
				$cadenaFiltro .= "AND denominacion like {$denCuenta} ";
			}
		}
		else{
			if ($denCuenta != '') {
				$cadenaFiltro .= " denominacion like {$denCuenta} ";
			}
		}
		
		if($cadenaFiltro!=''){
			$cadenaFiltro = 'WHERE '.$cadenaFiltro;
		}
		
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT sc_cuenta as codigo,denominacion 
								FROM sigesp_plan_unico ".$cadenaFiltro." 
								ORDER BY sc_cuenta";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarCuentaCaif($codCuenta,$denCuenta) {
		$cadenaFiltro = "";
		if($codCuenta != ''){
			$cadenaFiltro .= " codplacaif like {$codCuenta} ";
		}
		
		if($cadenaFiltro != '') {
			if ($denCuenta != '') {
				$cadenaFiltro .= "AND desplacaif like {$denCuenta} ";
			}
		}
		else{
			if ($denCuenta != '') {
				$cadenaFiltro .= " desplacaif like {$denCuenta} ";
			}
		}
		
		if($cadenaFiltro!=''){
			$cadenaFiltro = 'WHERE '.$cadenaFiltro;
		}
		
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT codplacaif as codigo, desplacaif as denominacion 
								FROM sigesp_plan_unico_caif ".$cadenaFiltro." 
								ORDER BY codplacaif";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarCuentasIntegradas() {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT *,
								(SELECT denominacion
									FROM sigesp_plan_unico_re pr
									WHERE pr.sig_cuenta = ci.sig_cuenta) AS descuentapre,
								(SELECT denominacion
									FROM sigesp_plan_unico pu
									WHERE pu.sc_cuenta = ci.sc_cuenta) AS descuentacondebe,
								(SELECT denominacion
									FROM sigesp_plan_unico pu
									WHERE pu.sc_cuenta = ci.sc_cuenta_haber) AS descuentaconhaber,
								(SELECT desplacaif
									FROM sigesp_plan_unico_caif ca
									WHERE ca.codplacaif = ci.codcaif) AS descuentacaifd,
								(SELECT desplacaif
									FROM sigesp_plan_unico_caif ca
									WHERE ca.codplacaif = ci.codcaif_haber) AS descuentacaifh
								FROM sigesp_sfp_asociacion ci
								ORDER BY sig_cuenta";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
}
?>