<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_iconfiguracionniveles.php");

class ServicioConfiguracionNivel implements IConfiguracionNivel{
	private $daoNiveles;
	
	function ServicioConfiguracionNivel() {
		$this->daoNiveles = null;
	}
	
	public function buscarNiveles($codemp,$anopresupuesto,$tipo){
		$cadenasql = "select *  
    		  		  from sfp_conf_niveles
    		  		  where codemp='{$codemp}' and ano_presupuesto={$anopresupuesto} AND tipo='{$tipo}'";
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$data  = $conbd->Execute ( $cadenasql );
		unset($conbd);
		return $data;
	}
	
	public function incluirVariosNiveles($codemp,$anpresupuesto,$arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		foreach ($arrjson->datos as $registro) {
			$this->daoNiveles = FabricaDao::CrearDAO("N", "sfp_conf_niveles");
			if($registro->numcar=='undefined'){
				$registro->numcar=0;
			}
			$this->daoNiveles->setData($registro);
			$this->daoNiveles->codemp = $codemp;
			$this->daoNiveles->ano_presupuesto = $anpresupuesto;
			$this->daoNiveles->codnivel = agregarUno($this->daoNiveles->buscarCodigo(codnivel,true,0));
			$resultado = $this->daoNiveles->incluir();
			
			if (!$resultado) {
				break;
			}
			
			unset($this->daoNiveles);    		
    	}
    	
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
    	
    	return $procesado;
	}
	
	public function actualizarVariosNiveles($codemp, $anpresupuesto, $arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		foreach ($arrjson->datos as $registro) {
			$this->daoNiveles = FabricaDao::CrearDAO("N", "sfp_conf_niveles");
			if($registro->numcar=='undefined'){
				$registro->numcar=0;
			}
			$this->daoNiveles->setData($registro);
			$this->daoNiveles->codemp = $codemp;
			$this->daoNiveles->ano_presupuesto = $anpresupuesto;
			$resultado = $this->daoNiveles->modificar();
			
			if (!$resultado) {
				break;
			}
			
			unset($this->daoNiveles);    		
    	}
    	
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
    	
    	return $procesado;
	}
	
	public function eliminarNivel($codemp, $anpresupuesto, $arrjson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		if (!$this->verificarRelaciones($codemp, $anpresupuesto, $arrjson)) {
			$this->daoNiveles = FabricaDao::CrearDAO('N', 'sfp_conf_niveles');
			$this->daoNiveles->setData($arrjson);
			$this->daoNiveles->codemp          = $codemp;
			$this->daoNiveles->ano_presupuesto = $anpresupuesto;
			$this->daoNiveles->eliminar();
		}
		else {
			return false;
		}
		
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function obtenerNombreUlitmoNivel($codemp, $anPresupuesto, $tipo) {
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql="select nombre_pest 
						from sfp_conf_niveles 
			  			where nivel in (select max(nivel) from sfp_conf_niveles where tipo='{$tipo}' and codemp='{$codemp}' and ano_presupuesto={$anPresupuesto}) 
			  			and tipo='{$tipo}'";
		$dataNivele  = $conbd->Execute ( $cadenaSql );
		
		if (!$dataNivele->EOF) {
			$nombrePesta = $dataNivele->fields['nombre_pest'];
		}
		unset($conbd);
		unset($dataNivele);
		return $nombrePesta;
	}
	
	public function verificarRelaciones($codemp, $anpresupuesto, $arrjson) {
		$existe    = false;       
		$cadenaSql = "";
		
		switch ($arrjson->tipo) {
			case 'PL':
				switch ($arrjson->nivel) {
					case '1':
						$cadenaSql = "SELECT codest1 
										FROM spe_estpro1 
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}'
										LIMIT 1";
						break;
					case '2':
						$cadenaSql = "SELECT codest1 
										FROM spe_estpro2
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
					case '3':
						$cadenaSql = "SELECT codest1 
										FROM spe_estpro3
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
					case '4':
						$cadenaSql = "SELECT codest1 
										FROM spe_estpro4
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
					case '5':
						$cadenaSql = "SELECT codest1 
										FROM spe_estpro5
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
				}
				break;
			case 'PR':
				switch ($arrjson->nivel) {
					case '1':
						$cadenaSql = "SELECT codestpro1 
										FROM sfp_estpro1
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
					case '2':
						$cadenaSql = "SELECT codestpro1 
										FROM sfp_estpro2
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' 
										LIMIT 1";
						break;
					case '3':
						$cadenaSql = "SELECT codestpro1 
										FROM sfp_estpro3 
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}'
										LIMIT 1";
						break;
					case '4':
						$cadenaSql = "SELECT codestpro1 
										FROM sfp_estpro4 
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}'
										LIMIT 1";
						break;
					case '5':
						$cadenaSql = "SELECT codestpro1 
										FROM sfp_estpro5 
										WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}'
										LIMIT 1";
						break;
				}
				break;
			case 'EA':
				$cadenaSql = "SELECT coduac 
								FROM sfp_estructura_ad
								WHERE codemp = '{$codemp}' AND ano_presupuesto = '{$anpresupuesto}' AND 
									  nivel = '{$arrjson->nivel}' LIMIT 1";
				break;
			case 'UG':
				switch ($arrjson->nivel) {
					case '1':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub1
										LIMIT 1";
						break;
					case '2':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub2
										LIMIT 1";
						break;
					case '3':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub3
										LIMIT 1";
						break;
					case '4':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub4
										LIMIT 1";
						break;
					case '5':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub5
										LIMIT 1";
						break;
					case '6':
						$cadenaSql = "SELECT codubgeo1 
										FROM sigesp_ub6
										LIMIT 1";
						break;
				}
				break;
				
		}
		
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if ($dataSet->_numOfRows > 0) {
			$existe = true;
		}
		unset($conexionBaseDatos);
		unset($dataSet);
		
		return $existe;
	}
	
	public function obtenerCantidadNiveles($codemp,$anopresupuesto,$tipo) {
		$cantidad  = 0;
		$cadenaSql = "select count(codnivel) as cantidad    
    		  		  from sfp_conf_niveles
    		  		  where codemp='{$codemp}' and ano_presupuesto={$anopresupuesto} AND tipo='{$tipo}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if(!$dataSet->EOF){
			$cantidad = $dataSet->fields['cantidad'];
		}
		
		unset($conexionBaseDatos);
		unset($dataSet);
		
		return $cantidad;
	}
}

?>
