<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_icomprobante.php");

class ServicioComprobante implements IComprobante {
	private $daoComprobante;
	private $daoDetalleComprobante;
	private $daoDetalleCAIF;
	private $daoSaldo;
	
	public function ServicioComprobante() {
		$this->daoComprobante        = null;
		$this->daoDetalleComprobante = null;
		$this->daoDetalleCAIF        = null;
		$this->daoSaldo              = null;
	}
	
	public function buscarCodigoComprobante($codemp) {
		$this->daoComprobante = FabricaDao::CrearDAO('N', 'sigesp_sfp_cmp');
		$this->daoComprobante->codemp  = $codemp;
		$codigo = $this->daoComprobante->buscarCodigo('comprobante',true,15);
		unset($this->daoComprobante);
		return $codigo;
	}
	
	public function existeComprobante($codemp, $procede, $comprobante, $fecha, $annoPresupuesto) {
		$existe = false;
		$cadenaSql = "SELECT comprobante 
						FROM sigesp_sfp_cmp
						WHERE codemp='{$codemp}' AND procede='{$procede}' AND comprobante='{$comprobante}' AND
							  fecha='{$fecha}' AND ano_presupuesto={$annoPresupuesto}";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if ($dataSet->_numOfRows > 0) {
			$existe = true;
		}
		
		unset($conexionBaseDatos);
		return $existe;
	}
	
	public function guardarComprobante($arrcabecera, $arrdetalle) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoComprobante = FabricaDao::CrearDAO('N', 'sigesp_sfp_cmp');
		$this->daoComprobante->codemp          = $arrcabecera['codemp'];
		$this->daoComprobante->procede         = $arrcabecera['procede'];
		$this->daoComprobante->comprobante     = $arrcabecera['comprobante'];
		$this->daoComprobante->fecha           = $arrcabecera['fecha'];
		$this->daoComprobante->ano_presupuesto = $arrcabecera['annoPresupuesto'];
		$this->daoComprobante->sig_cuenta      = $arrcabecera['sig_cuenta'];
		$this->daoComprobante->descripcion     = $arrcabecera['descripcion'];
		$this->daoComprobante->tipo_comp	   = $arrcabecera['tipo_comp'];
		$this->daoComprobante->tipo_destino    = $arrcabecera['tipo_destino'];
		$this->daoComprobante->codinte         = $arrcabecera['codinte'];
		
		if ($this->daoComprobante->incluir()) {
			$j = 1;
			foreach ($arrdetalle as $detalle) {
				$this->daoDetalleComprobante = FabricaDao::CrearDAO('N','scg_dt_sfp_cmp');
				$this->daoDetalleComprobante->codemp          = $arrcabecera['codemp'];
				$this->daoDetalleComprobante->procede         = $arrcabecera['procede'];
				$this->daoDetalleComprobante->ano_presupuesto = $arrcabecera['annoPresupuesto'];
				$this->daoDetalleComprobante->comprobante     = $arrcabecera['comprobante'];
				$this->daoDetalleComprobante->fecha           = $arrcabecera['fecha'];
				$this->daoDetalleComprobante->descripcion     = $arrcabecera['descripcion'];
				$this->daoDetalleComprobante->documento	      = $detalle['documento'];
				$this->daoDetalleComprobante->debhab          = $detalle['debhab'];
				$this->daoDetalleComprobante->sc_cuenta       = $detalle['sc_cuenta'];
				$this->daoDetalleComprobante->monto           = $detalle['monto'];
				$this->daoDetalleComprobante->orden           = $j;
				$j++;
				
				if (!$this->daoDetalleComprobante->incluir()) {
					break;
				}
				else{
					if(!$this->actualizarSaldoCuenta($arrcabecera['codemp'], $arrcabecera['annoPresupuesto'], $detalle['sc_cuenta'], $arrcabecera['fecha'], $detalle['debhab'], $detalle['monto'])){
						break;
					}
				}
								
				unset($this->daoDetalleComprobante);
			}
		}
		else{
			return $this->daoComprobante->ErrorMsg();
		}
		unset($this->daoComprobante);
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function guardarComprobanteCAIF($arrcabecera, $arrdetalle) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		$this->daoComprobante = FabricaDao::CrearDAO('N', 'sigesp_sfp_cmp');
		$this->daoComprobante->codemp          = $arrcabecera['codemp'];
		$this->daoComprobante->procede         = $arrcabecera['procede'];
		$this->daoComprobante->comprobante     = $arrcabecera['comprobante'];
		$this->daoComprobante->fecha           = $arrcabecera['fecha'];
		$this->daoComprobante->ano_presupuesto = $arrcabecera['annoPresupuesto'];
		$this->daoComprobante->sig_cuenta      = $arrcabecera['sig_cuenta'];
		$this->daoComprobante->descripcion     = $arrcabecera['descripcion'];
		$this->daoComprobante->tipo_comp	   = $arrcabecera['tipo_comp'];
		$this->daoComprobante->tipo_destino    = $arrcabecera['tipo_destino'];
		$this->daoComprobante->codinte         = $arrcabecera['codinte'];
		
		if ($this->daoComprobante->incluir()) {
			foreach ($arrdetalle as $detalle) {
				$this->daoDetalleComprobante = FabricaDao::CrearDAO('N','sfp_dt_cmp_variacion');
				$this->daoDetalleComprobante->codemp          = $arrcabecera['codemp'];
				$this->daoDetalleComprobante->procede         = $arrcabecera['procede'];
				$this->daoDetalleComprobante->comprobante     = $arrcabecera['comprobante'];
				$this->daoDetalleComprobante->fecha           = $arrcabecera['fecha'];
				$this->daoDetalleComprobante->ano_presupuesto = $arrcabecera['annoPresupuesto'];
				$this->daoDetalleComprobante->descripcion     = $arrcabecera['descripcion'];
				$this->daoDetalleComprobante->sig_cuenta      = $detalle['sig_cuenta'];
				$this->daoDetalleComprobante->debhab          = $detalle['debhab'];
				$this->daoDetalleComprobante->monto           = $detalle['monto'];
								
				if (!$this->daoDetalleComprobante->incluir()) {
					return $this->daoDetalleComprobante->ErrorMsg();
				}
				else {
					if(!$this->actualizarSaldoCuenta($arrcabecera['codemp'], $arrcabecera['annoPresupuesto'], $detalle['sig_cuenta'], $arrcabecera['fecha'], $detalle['debhab'], $detalle['monto'])){
						break;
					}
				}
				unset($this->daoDetalleComprobante);
			}
		}
		else{
			return $this->daoComprobante->ErrorMsg();
		}
		unset($this->daoComprobante);
				
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
	
	public function eliminarDetalleComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha) {
		$cadenaSql         = "DELETE FROM scg_dt_sfp_cmp
  								WHERE codemp='{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND comprobante='{$comprobante}' AND 
  								      procede='{$procede}' AND fecha='{$fecha}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$respuesta = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $respuesta;
	}
	
	public function eliminarCabeceraComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha) {
		$cadenaSql         = "DELETE FROM sigesp_sfp_cmp
  								WHERE codemp='{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND comprobante='{$comprobante}' AND 
  								      procede='{$procede}' AND fecha='{$fecha}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$respuesta = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $respuesta;
	}
	
	public function eliminarComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha) {
		if($this->eliminarDetalleComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha)!== false){
			if($this->eliminarCabeceraComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha)!==false){
				return true;
			}
			else {
				return false;
			}	
		}
	}
	
	public function eliminarDetalleComprobanteCAIF($codemp, $anPresupuesto ,$comprobante, $procede, $fecha) {
		$cadenaSql         = "DELETE FROM sfp_dt_cmp_variacion
  								WHERE codemp='{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND comprobante='{$comprobante}' AND 
  								      procede='{$procede}' AND fecha='{$fecha}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$respuesta = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $respuesta;
	}
	
	public function eliminarComprobanteCAIF($codemp, $anPresupuesto ,$comprobante, $procede, $fecha) {
		if($this->eliminarDetalleComprobanteCAIF($codemp, $anPresupuesto ,$comprobante, $procede, $fecha)!== false){
			if($this->eliminarCabeceraComprobante($codemp, $anPresupuesto ,$comprobante, $procede, $fecha)!==false){
				return true;
			}
			else {
				return false;
			}	
		}
	}
	
	public function buscarComprobantexCuenta($codemp, $annoPresupuesto, $sig_cuenta, $procede) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "SELECT * 
						FROM sigesp_sfp_cmp
						WHERE codemp='{$codemp}' AND 
						ano_presupuesto={$annoPresupuesto} AND 
						sig_cuenta='{$sig_cuenta}' AND 
						procede= '{$procede}' ";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarDetalles($codemp, $anPresupuesto, $cuenta, $codinte='') {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$filtroCodinte = '';
		if ($codinte!='') {
			$filtroCodinte = " AND sigesp_sfp_cmp.codinte = {$codinte}";
		}
		$cadenaSql = "SELECT scg_dt_sfp_cmp.sc_cuenta as codigo,sigesp_sfp_plan_unico.denominacion,scg_dt_sfp_cmp.debhab as operacion,scg_dt_sfp_cmp.monto
			  			FROM sigesp_sfp_cmp 
			  				 INNER JOIN scg_dt_sfp_cmp ON sigesp_sfp_cmp.codemp=scg_dt_sfp_cmp.codemp AND sigesp_sfp_cmp.comprobante=scg_dt_sfp_cmp.comprobante AND
			  				                              sigesp_sfp_cmp.procede=scg_dt_sfp_cmp.procede AND sigesp_sfp_cmp.fecha=scg_dt_sfp_cmp.fecha
			  				 LEFT OUTER JOIN sigesp_sfp_plan_unico ON scg_dt_sfp_cmp.sc_cuenta=sigesp_sfp_plan_unico.sc_cuenta
			  			WHERE sigesp_sfp_cmp.codemp='{$codemp}' AND 
			  				  sigesp_sfp_cmp.ano_presupuesto={$anPresupuesto} AND
			  				  sigesp_sfp_cmp.sig_cuenta='{$cuenta}' {$filtroCodinte}
			  			ORDER BY scg_dt_sfp_cmp.debhab asc";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarDetallesCAIF($codemp, $anPresupuesto, $cuenta, $codinte='') {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$filtroCodinte = '';
		if ($codinte!='') {
			$filtroCodinte = " AND sigesp_sfp_cmp.codinte = {$codinte}";
		}
		$cadenaSql = "SELECT sfp_dt_cmp_variacion.sig_cuenta as codigo,sigesp_plan_unico_caif.desplacaif as denominacion,sfp_dt_cmp_variacion.monto
			  			FROM sigesp_sfp_cmp 
			  				 INNER JOIN sfp_dt_cmp_variacion ON sigesp_sfp_cmp.codemp=sfp_dt_cmp_variacion.codemp AND sigesp_sfp_cmp.comprobante=sfp_dt_cmp_variacion.comprobante AND
			  				                              sigesp_sfp_cmp.procede=sfp_dt_cmp_variacion.procede 
			  				 LEFT OUTER JOIN sigesp_plan_unico_caif ON sfp_dt_cmp_variacion.sig_cuenta=sigesp_plan_unico_caif.codplacaif
			  			WHERE sigesp_sfp_cmp.codemp='{$codemp}' AND 
			  				  sigesp_sfp_cmp.ano_presupuesto={$anPresupuesto} AND 
			  				  sigesp_sfp_cmp.sig_cuenta='{$cuenta}' {$filtroCodinte}";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function buscarDetalleTodo($codemp, $anPresupuesto, $cuenta) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "SELECT scg_dt_sfp_cmp.*
			  			FROM sigesp_sfp_cmp 
			  				 INNER JOIN scg_dt_sfp_cmp ON sigesp_sfp_cmp.codemp=scg_dt_sfp_cmp.codemp AND sigesp_sfp_cmp.comprobante=scg_dt_sfp_cmp.comprobante AND
			  				                              sigesp_sfp_cmp.procede=scg_dt_sfp_cmp.procede AND sigesp_sfp_cmp.fecha=scg_dt_sfp_cmp.fecha
			  			WHERE sigesp_sfp_cmp.codemp='{$codemp}' and 
			  				  sigesp_sfp_cmp.ano_presupuesto={$anPresupuesto} and 
			  				  sigesp_sfp_cmp.sig_cuenta='{$cuenta}'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function actualizarSaldoCuenta($codemp, $anPresupuesto, $cuenta, $fecha, $operacion, $saldo) {
		$procesado = true;
		$this->daoSaldo = FabricaDao::CrearDAO('N','scg_sfp_saldos');
		$this->daoSaldo->load("codemp='{$codemp}' and ano_presupuesto='{$anPresupuesto}' and sc_cuenta = '{$cuenta}' and fecsal='{$fecha}'");
		if($this->daoSaldo->sc_cuenta != '' && $this->daoSaldo->sc_cuenta != null){
			if($operacion == 'D'){
				$this->daoSaldo->debe_mes = $this->daoSaldo->debe_mes + $saldo;
			}
			else{
				$this->daoSaldo->haber_mes = $this->daoSaldo->haber_mes + $saldo;
			} 
			$this->daoSaldo->modificar();
		}
		else{
			$this->daoSaldo->codemp          = $codemp;
			$this->daoSaldo->ano_presupuesto = $anPresupuesto;
			$this->daoSaldo->sc_cuenta       = $cuenta;
			$this->daoSaldo->fecsal          = $fecha;
			if($operacion == 'D'){
				$this->daoSaldo->debe_mes = $saldo;
			}
			else{
				$this->daoSaldo->haber_mes = $saldo;
			}
			
			if(!$this->daoSaldo->incluir()){
				return $this->daoSaldo->ErrorMsg();
			}
		}
		
		return $procesado;
	}
	
	public function modificarMontoComprobante($codemp, $anPresupuesto, $comprobante, $procede, $fecha, $sc_cuenta, $monto) {
		$modificado = true;
		$strPk = "codemp = '{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND comprobante='{$comprobante}' AND procede='{$procede}'".
				 " AND fecha='{$fecha}' AND sc_cuenta='{$sc_cuenta}'";
		$this->daoDetalleComprobante = FabricaDao::CrearDAO('C','scg_dt_sfp_cmp',null,$strPk);
		$this->daoDetalleComprobante->monto = $monto;
		if(!$this->daoDetalleComprobante->modificar()){
			$modificado = false;
		}
		
		unset($this->daoDetalleComprobante);
		return $modificado;
	}
	
	public function modificarComprobante($codemp, $anPresupuesto, $cuenta, $monto) {
		$dataDetalle = $this->buscarDetalleTodo($codemp, $anPresupuesto, $cuenta);
		while (!$dataDetalle->EOF) {
			if(!$this->modificarMontoComprobante($dataDetalle->fields['codemp'], $dataDetalle->fields['ano_presupuesto'], $dataDetalle->fields['comprobante'], $dataDetalle->fields['procede'], $dataDetalle->fields['fecha'], $dataDetalle->fields['sc_cuenta'], $monto)){
				return false;
			}
			$dataDetalle->MoveNext();
		}
		
		return true;
	}
	
	public function buscarDetalleCAIF($codemp, $anPresupuesto, $cuenta) {
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql = "SELECT sfp_dt_cmp_variacion.*
			  			FROM sigesp_sfp_cmp 
			  				 INNER JOIN sfp_dt_cmp_variacion ON sigesp_sfp_cmp.codemp=sfp_dt_cmp_variacion.codemp AND sigesp_sfp_cmp.comprobante=sfp_dt_cmp_variacion.comprobante AND
			  				                              sigesp_sfp_cmp.procede=sfp_dt_cmp_variacion.procede AND sigesp_sfp_cmp.fecha=sfp_dt_cmp_variacion.fecha
			  			WHERE sigesp_sfp_cmp.codemp='{$codemp}' and 
			  				  sigesp_sfp_cmp.ano_presupuesto={$anPresupuesto} and 
			  				  sigesp_sfp_cmp.sig_cuenta='{$cuenta}'";
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function modificarMontoComprobanteCAIF($codemp, $anPresupuesto, $comprobante, $procede, $fecha, $cuenta, $monto) {
		$modificado = true;
		$strPk = "codemp = '{$codemp}' AND ano_presupuesto='{$anPresupuesto}' AND comprobante='{$comprobante}' AND procede='{$procede}'".
				 " AND fecha='{$fecha}' AND sig_cuenta='{$cuenta}'";
		$this->daoDetalleComprobante = FabricaDao::CrearDAO('C','sfp_dt_cmp_variacion',null,$strPk);
		$this->daoDetalleComprobante->monto = $monto;
		if(!$this->daoDetalleComprobante->modificar()){
			$modificado = false;
		}
		
		unset($this->daoDetalleComprobante);
		return $modificado;
	}
	
	public function modificarComprobanteCAIF($codemp, $anPresupuesto, $cuenta, $monto) {
		$dataDetalle = $this->buscarDetalleCAIF($codemp, $anPresupuesto, $cuenta);
		while (!$dataDetalle->EOF) {
			if(!$this->modificarMontoComprobanteCAIF($dataDetalle->fields['codemp'], $dataDetalle->fields['ano_presupuesto'], $dataDetalle->fields['comprobante'], $dataDetalle->fields['procede'], $dataDetalle->fields['fecha'], $dataDetalle->fields['sig_cuenta'], $monto)){
				return false;
			}
			$dataDetalle->MoveNext();
		}
		
		return true;
	}
	
}