<?php
$dirsrvsfp = "";
$dirsrvsfp = dirname(__FILE__);
$dirsrvsfp = str_replace("\\","/",$dirsrvsfp);
$dirsrvsfp = str_replace("/modelo/servicio/sfp","",$dirsrvsfp);
require_once ($dirsrvsfp."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvsfp."/modelo/servicio/sfp/sigesp_srv_sfp_icargasaldocontable.php");

class ServicioCargaSaladoContable implements ICargaSaldoContable{
	private $daoSaldo;
	
	public function ServicioCargaSaladoContable() {
		$this->daoSaldo = null;
	}
	
	public function buscarDigitosCuentas($codempsig) {
		$arrDigito         = array();
		$cadenaSql         = "SELECT activo, pasivo, resultado, capital FROM sigesp_empresa WHERE codemp='{$codempsig}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		$arrDigito['activo']    = $dataSet->fields["activo"];
		$arrDigito['pasivo']    = $dataSet->fields["pasivo"];
		$arrDigito['resultado'] = $dataSet->fields["resultado"];
		$arrDigito['capital']   = $dataSet->fields["capital"];
		
		unset($conexionBaseDatos);
		unset($dataSet);
		return $arrDigito;
	}
	
	public function buscarSaldosIniciales($codempsig,$codemp,$anpresupuesto) {
		$arrDigito = $this->buscarDigitosCuentas($codempsig);
		$cadenaSql = "SELECT sigesp_plan_unico.sc_cuenta,sigesp_plan_unico.denominacion,coalesce(sum(saldos.monto_anreal),000) as monto_anreal,coalesce(sum(saldos.monto_anest),000) as monto_anest
						FROM sigesp_plan_unico 
						LEFT JOIN  (SELECT codemp, ano_presupuesto, sc_cuenta, monto_anreal, monto_anest
  										FROM sigesp_sfp_saldoscon
  										WHERE codemp='{$codemp}' and ano_presupuesto={$anpresupuesto}) as saldos ON sigesp_plan_unico.sc_cuenta = saldos.sc_cuenta
						WHERE (sigesp_plan_unico.sc_cuenta like '{$arrDigito['activo']}%' or sigesp_plan_unico.sc_cuenta like '{$arrDigito['pasivo']}%' 
								or sigesp_plan_unico.sc_cuenta like '{$arrDigito['resultado']}%' or sigesp_plan_unico.sc_cuenta like '{$arrDigito['capital']}%')
						GROUP BY sigesp_plan_unico.sc_cuenta,sigesp_plan_unico.denominacion
						ORDER BY sigesp_plan_unico.sc_cuenta";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		unset($conexionBaseDatos);
		return $dataSet;
	}
	
	public function existeCuenta($codemp,$anpresupuesto,$codcuenta) {
		$existe = false;
		$cadenaSql = "SELECT * 
						FROM sigesp_sfp_saldoscon 
						WHERE  codemp='{$codemp}' and ano_presupuesto='{$anpresupuesto}' AND sc_cuenta='{$codcuenta}'";
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
				
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if ($dataSet->_numOfRows > 0) {
			$existe = true;
		}
		
		unset($conexionBaseDatos);
		return $existe;
	}
	
	public function procesarSaldos($codemp,$anpresupuesto,$arrJson) {
		$procesado = true;
		DaoGenerico::iniciarTrans();
		
		foreach ($arrJson as $regCuenta) {
			$this->daoSaldo = FabricaDao::CrearDAO('N', 'sigesp_sfp_saldoscon');
			$regCuenta->monto_anreal = formatoNumericoBd($regCuenta->monto_anreal);
			$regCuenta->monto_anest = formatoNumericoBd($regCuenta->monto_anest);
			$this->daoSaldo->setData($regCuenta);
			$this->daoSaldo->codemp          = $codemp;
			$this->daoSaldo->ano_presupuesto = $anpresupuesto;
			if($this->existeCuenta($codemp, $anpresupuesto, $regCuenta->sc_cuenta)){
				$this->daoSaldo->modificar();
			}
			else{
				$this->daoSaldo->incluir();
				/*ojo aqui queda pendiente ajustes de variacion
				 * ver archivo sigesp_spe_cargasaldospr.php
				 * en la linea 118
				 */
			}
		}
		
		if (!DaoGenerico::completarTrans()) {
			$procesado = false;
		}
		    	
		return $procesado;
	}
}

?>