<?php
$dirsrv = dirname(__FILE__);
$dirsrv = str_replace("\\","/",$dirsrv);
$dirsrv = str_replace("/modelo/servicio/sep","",$dirsrv); 
require_once ($dirsrv."/controlador/cfg/sigesp_ctr_cfg_servicio.php");
require_once ($dirsrv."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrv."/modelo/servicio/sep/sigesp_srv_sep_isolicitud.php");
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_comprobantespg.php');

/**
 * @author Neneskha Salas
 * @desc clase que sirve a la pantalla de solicitud de ejecucion presupuestaria, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioSolicitud implements isolicitud {
	public  $mensaje; 
	public  $valido; 
	private $daoSolicitud;
	private $ConexionBaseDatos;
	private $daoRegistroEvento;
	private $daoDetalle;
	private $daoDetalleCargo;
	private $daoDetalleCuenta;
	private $daoDetalleCueCar;
	private $daoDetalleCueGas;
	private $daoCambioEstatusSep;

	
	public function servicioSolicitud() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoRegistroEvento = null;
		$this->daoSolicitud = null;
		$this->daoDetalle = null;
		$this->daoDetalleCargo = null;
		$this->daoDetalleCuenta = null;
		$this->daoDetalleCueCar = null;
		$this->daoDetalleCueGas = null;
		$this->daoCambioEstatusSep = null;
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
	}
    
	public function buscarUnidadEjecutora($codemp, $codusu, $codigo, $denominacion, $origen) {
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		
		if($origen=='1'){
			$cadenConcat_A = $this->conexionBaseDatos->Concat("'{$codemp}'","'SOC'","'{$codusu}'",'UNI.coduniadm');
			$cadenConcat_B = $this->conexionBaseDatos->Concat('codemp','codsis','codusu','codintper');
			$cadenaSeguridad = " AND {$cadenConcat_A} IN (SELECT {$cadenConcat_B} 
			                       									FROM sss_permisos_internos 
			                       									WHERE codusu = '{$codusu}' AND codsis = 'SOC' AND enabled=1)";
			
			$cadenConcat_A2 = $this->conexionBaseDatos->Concat("'{$codemp}'","'SPG'","'{$codusu}'",'DT.codestpro1','DT.codestpro2','DT.codestpro3','DT.codestpro4','DT.codestpro5','DT.estcla');
			$cadenaSeguridad .= " AND {$cadenConcat_A2} IN (SELECT {$cadenConcat_B}
			                       										FROM sss_permisos_internos 
			                       										WHERE codusu = '".$codusu."' AND codsis = 'SPG' AND enabled=1)";
			switch($_SESSION["la_empresa"]["estmodest"]) {
				case "1": // Modalidad por Proyecto
					$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
					$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
					$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
					$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
					$cadenaJoin = 'INNER JOIN spg_ep3 EP USING(codemp,codestpro1,codestpro2,codestpro3,estcla)';
					$denEstructura = 'denestpro3';
					break;
					
				case "2": // Modalidad por Programatica
					$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
					$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
					$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
					$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
					$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
					$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
					$cadenaJoin = 'INNER JOIN spg_ep5 EP USING(codemp,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla)';
					$denEstructura = 'denestpro5';
					break;
			}
			
			$cadenaUnidad = $this->conexionBaseDatos->Concat('UNI.coduniadm',"'-'",'UNI.denuniadm');
			
			$cadenaSQL = "SELECT {$cadenaUnidad} AS coddenunidad, ".
			            "        {$cadenaEstructura} AS estructura, ".
			            "        {$denEstructura} AS denestpro, ".
			            "        UNI.coduniadm,".
			            "        UNI.denuniadm,".
			            "        DT.codestpro1,".
			            "        DT.codestpro2,".
			            "        DT.codestpro3,".
			            "        DT.codestpro4,".
			            "        DT.codestpro5,".
			            "        DT.estcla".
						" FROM spg_unidadadministrativa UNI".
						" INNER JOIN spg_dt_unidadadministrativa DT USING(codemp,coduniadm)". 
						" {$cadenaJoin}".
						" WHERE UNI.codemp='{$codemp}'". 
					   	"	AND UNI.coduniadm <>'----------'". 
					   	"	AND UNI.coduniadm like '%{$codigo}%'". 
					   	"	AND UNI.denuniadm like '%{$denominacion}%' {$cadenaSeguridad} ";
		}
		else if($origen=='2'){
			$cadenaSQL = "SELECT coduniadm, denuniadm ".
						 "FROM spg_unidadadministrativa ".
						 "WHERE codemp='".$codemp."' ".
						 "  AND coduniadm <>'----------' ".
						 "ORDER BY coduniadm ASC";
		}
		
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	}
	
	public function buscarFuenteFinanciamiento($codemp, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla, $origen_catalogo) {
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();

		if($origen_catalogo=='SCB'){
			$cadenaFiltro = '';
			$cadfil = "GROUP BY sigesp_fuentefinanciamiento.codfuefin,sigesp_fuentefinanciamiento.denfuefin";
		}
		else{
			$cadenaFiltro = "AND spg_dt_fuentefinanciamiento.codestpro1 like '%{$codestpro1}%'   ". 
					"		AND spg_dt_fuentefinanciamiento.codestpro2 like '%{$codestpro2}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro3 like '%{$codestpro3}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro4 like '%{$codestpro4}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro5 like '%{$codestpro5}%'   ".
					"		AND spg_dt_fuentefinanciamiento.estcla like '%{$estcla}%'           ";
			$cadfil = '';
		}
		$cadenaSQL = "SELECT sigesp_fuentefinanciamiento.codfuefin,sigesp_fuentefinanciamiento.denfuefin ".
				"	  FROM sigesp_fuentefinanciamiento,spg_dt_fuentefinanciamiento ". 
				"	  WHERE sigesp_fuentefinanciamiento.codemp = '{$codemp}'  ".
				"		AND sigesp_fuentefinanciamiento.codemp=spg_dt_fuentefinanciamiento.codemp  ".
				"		AND sigesp_fuentefinanciamiento.codfuefin=spg_dt_fuentefinanciamiento.codfuefin  ".
				"		{$cadenaFiltro}   ".
				"	    AND spg_dt_fuentefinanciamiento.codfuefin<>'--'  {$cadfil}".
		        "     ORDER BY sigesp_fuentefinanciamiento.codfuefin ASC ";           
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	}
	
	public function buscarTipoSolicitud($codemp) {
    	$estope= "(CASE estope WHEN 'R'         ".
   				"			THEN                ".
                "      		    'Precompromiso' ".
     			"			   WHEN 'O'         ".
   				"			THEN                ".
     			"				'Compromiso'    ".
     			"			   WHEN 'S'         ".
   				"			THEN                ".
     			"				'Sin afectacion'".
   				"			END)";
    	$cadenaEstructura = $this->conexionBaseDatos->Concat('dentipsol',"'-'",$estope);
    	$cadenaCodigo = $this->conexionBaseDatos->Concat('codtipsol','modsep','estope','estayueco');
    	
    	$cadenasql= "SELECT {$cadenaEstructura} AS descripcion, {$cadenaCodigo} AS codtipsol".
					"  FROM sep_tiposolicitud ";
    	return $this->conexionBaseDatos->Execute ( $cadenasql );
    	
    }
    
	public function buscarCodigoSolicitud($codemp) {
		$this->daoSolicitud = FabricaDao::CrearDAO("N", "sep_solicitud");
		$this->daoSolicitud->codemp = $codemp;
		$codigo = $this->daoSolicitud->buscarCodigo("numsol",true,15,array(),'SEP','SEPSPC',$_SESSION['la_logusr']);
		unset($this->daoSolicitud);
		echo $codigo;
		return $codigo;		
	}
	
	public function buscarUltimaSolicitud() {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$cadenaSql="SELECT numsol  ".  
				"	FROM sep_solicitud  ".
				"	ORDER BY numsol DESC LIMIT 1";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		return $data->fields['numsol'];
	}
	
	public function ValidarFecha($codemp) {
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql='';
		
		$numero = $this->buscarUltimaSolicitud();
		$cadenaSql="SELECT fecregsol ".  
				"	FROM sep_solicitud  ".
				"	WHERE codemp='{$codemp}' ". 
				"	  AND numsol='{$numero}'";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSql);
		return $data->fields['fecregsol'];
	}

	public function buscarBienes($codemp, $origenCat, $codart, $denart, $codtipart, $tipobien, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla, $denunimed){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL    = '';
		$cadenaFiltro = '';
		if ($tipobien=='M'){
			$cadenaFiltro = " AND siv_articulo.estact='0'";
	 	}
		elseif($tipobien=='A'){
			$cadenaFiltro = " AND siv_articulo.estact='1'";
		}

		$sqlDigitoGastos  = "SELECT soc_gastos ". 
							"FROM sigesp_empresa ". 
							"WHERE codemp = '{$codemp}'";
		$dataCuentaGasto = $this->conexionBaseDatos->Execute($sqlDigitoGastos);
		$digitoCuentas = $dataCuentaGasto->fields['soc_gastos'];
		if(!empty($digitoCuentas)){
			$arrDigitoCuentas = explode(',',$digitoCuentas);
			if (!empty($arrDigitoCuentas)) {
				$numCuentas = count($arrDigitoCuentas);
				for ($i=0;$i<$numCuentas;$i++) {
					if($i==0){
						$cadenaFiltro .= " AND (siv_articulo.spg_cuenta like '".$arrDigitoCuentas[$i]."%'";
					}
					else{
						$cadenaFiltro .= " OR siv_articulo.spg_cuenta like '".$arrDigitoCuentas[$i]."%'";
					}
					if($i==$numCuentas-1){
						$cadenaFiltro .= ') ' ;
					}						   
				}
				$cadenaSQL = "SELECT TRIM(siv_articulo.codart) as codart,siv_articulo.denart,siv_articulo.ultcosart, ".
							"        siv_articulo.codunimed,TRIM(siv_articulo.spg_cuenta) AS spg_cuenta,  ".
							"		 siv_unidadmedida.denunimed, siv_unidadmedida.unidad as unidad,siv_articulo.estartgen,  ".
				            "        (SELECT COUNT(spg_cuentas.spg_cuenta) ". 
			                "         FROM spg_cuentas ".
				            "         WHERE spg_cuentas.codestpro1 = '{$codestpro1}' ".
				            "   		AND spg_cuentas.codestpro2 = '{$codestpro2}' ".
				            "    		AND spg_cuentas.codestpro3 = '{$codestpro3}'".
				            "    		AND spg_cuentas.codestpro4 = '{$codestpro4}'".
		 	  	            "    		AND spg_cuentas.codestpro5 = '{$codestpro5}'".
				            "    		AND spg_cuentas.estcla = '{$estcla}'".
						    "    		AND siv_articulo.codemp = spg_cuentas.codemp".
				            "    		AND siv_articulo.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta,".
						    "		 (SELECT (spg_cuentas.asignado-(spg_cuentas.comprometido+spg_cuentas.precomprometido)+spg_cuentas.aumento-spg_cuentas.disminucion)".
						  	"  		  FROM spg_cuentas ".
							"  		  WHERE spg_cuentas.codestpro1 = '{$codestpro1}' ".
							"			AND spg_cuentas.codestpro2 = '{$codestpro2}' ".
							"			AND spg_cuentas.codestpro3 = '{$codestpro3}'".
							"			AND spg_cuentas.codestpro4 = '{$codestpro4}'".
							"			AND spg_cuentas.codestpro5 = '{$codestpro5}'".
							"			AND spg_cuentas.estcla = '{$estcla}'".
							"			AND siv_articulo.codemp = spg_cuentas.codemp".
							"			AND spg_cuentas.spg_cuenta = siv_articulo.spg_cuenta) AS disponibilidad,". 
							" 		 (SELECT COUNT(siv_cargosarticulo.codart)".
							"   	  FROM sigesp_cargos, siv_cargosarticulo".
							"  		  WHERE siv_cargosarticulo.codemp = siv_articulo.codemp".
							"	  		AND siv_cargosarticulo.codart = siv_articulo.codart".
							"    		AND sigesp_cargos.codemp = siv_cargosarticulo.codemp".
							"    		AND sigesp_cargos.codcar = siv_cargosarticulo.codcar) AS totalcargos".
							" FROM siv_articulo, siv_unidadmedida".
							" WHERE siv_articulo.codemp='{$codemp}'".
							"  	AND siv_articulo.codart like '%{$codart}%'".
							"   AND siv_articulo.denart like '%{$denart}%'".
							"   AND siv_articulo.codtipart like '%{$codtipart}%'".
							"	AND siv_articulo.codunimed = siv_unidadmedida.codunimed {$cadenaFiltro} ";
			}
		}
		
		if ($cadenaSQL!='') {
			return $this->conexionBaseDatos->Execute($cadenaSQL);
		}
		else{
			return false;
		}
		
	}
	public function buscarServicios($codemp, $origenCat, $codser, $denser, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaFiltro = '';
				
		$cadenaSQL = "SELECT codser, denser, preser, TRIM(spg_cuenta) as spg_cuenta, ".
				"			 (SELECT COUNT(spg_cuentas.spg_cuenta) ".
	            "       	  FROM spg_cuentas ".
		        "    		  WHERE spg_cuentas.codestpro1 = '{$codestpro1}' ".
		        "        		AND spg_cuentas.codestpro2 = '{$codestpro2}'".
		        "        		AND spg_cuentas.codestpro3 = '{$codestpro3}'".
		        "        		AND spg_cuentas.codestpro4 = '{$codestpro4}'".
 	  	        "        		AND spg_cuentas.codestpro5 = '{$codestpro5}'".
		        "        		AND spg_cuentas.estcla = '{$estcla}'".
				"        		AND soc_servicios.codemp = spg_cuentas.codemp".
		        "        		AND soc_servicios.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta,".
				"    		 (SELECT (spg_cuentas.asignado-(spg_cuentas.comprometido+spg_cuentas.precomprometido)+spg_cuentas.aumento-spg_cuentas.disminucion)".
				"  	   		  FROM spg_cuentas".
				"	  		  WHERE spg_cuentas.codestpro1 = '{$codestpro1}'".
				"				AND spg_cuentas.codestpro2 = '{$codestpro2}'".
				"				AND spg_cuentas.codestpro3 = '{$codestpro3}'".
				"				AND spg_cuentas.codestpro4 = '{$codestpro4}'".
				"				AND spg_cuentas.codestpro5 = '{$codestpro5}'".
				"				AND spg_cuentas.estcla = '{$estcla}'".
				"				AND soc_servicios.codemp = spg_cuentas.codemp".
				"				AND spg_cuentas.spg_cuenta = soc_servicios.spg_cuenta) AS disponibilidad".
				"	  FROM soc_servicios".
				"	  WHERE soc_servicios.codemp='{$codemp}'".
				"	   	AND soc_servicios.codser like '%{$codser}%'".
				"	  	AND soc_servicios.denser like '%{$denser}%' {$cadenaFiltro} ";
		
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	
	}
	
	public function buscarConceptos($codemp, $origenCat, $codconsep, $denconsep, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaFiltro = '';
				
		$cadenaSQL = "SELECT codconsep, denconsep, monconsepe, TRIM(spg_cuenta) as spg_cuenta, ".
			"				 (SELECT COUNT(spg_cuentas.spg_cuenta) ".
	        "           	  FROM spg_cuentas ".
		    "         		  WHERE spg_cuentas.codestpro1 = '{$codestpro1}'".
		    "            		AND spg_cuentas.codestpro2 = '{$codestpro2}'".
		    "            		AND spg_cuentas.codestpro3 = '{$codestpro3}'".
		    "            		AND spg_cuentas.codestpro4 = '{$codestpro4}'".
 	  	    "            		AND spg_cuentas.codestpro5 = '{$codestpro5}'".
		    "            		AND spg_cuentas.estcla = '{$estcla}'".
			"	        		AND sep_conceptos.codemp = spg_cuentas.codemp".
		    "            		AND sep_conceptos.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta,".
			"	    		 (SELECT (spg_cuentas.asignado-(spg_cuentas.comprometido+spg_cuentas.precomprometido)+spg_cuentas.aumento-spg_cuentas.disminucion)".
			"	  	   		  FROM spg_cuentas ".
			"		  		  WHERE spg_cuentas.codestpro1 = '{$codestpro1}'".
			"					AND spg_cuentas.codestpro2 = '{$codestpro2}'".
			"					AND spg_cuentas.codestpro3 = '{$codestpro3}'".
			"					AND spg_cuentas.codestpro4 = '{$codestpro4}'".
			"					AND spg_cuentas.codestpro5 = '{$codestpro5}'".
			"					AND spg_cuentas.estcla = '{$estcla}'".
			"					AND sep_conceptos.codemp = spg_cuentas.codemp".
			"					AND spg_cuentas.spg_cuenta = sep_conceptos.spg_cuenta) AS disponibilidad".
			"		  FROM sep_conceptos".
			"		  WHERE sep_conceptos.codemp='{$codemp}'".
			"		   	AND sep_conceptos.codconsep like '%{$codconsep}%'".
			"		  	AND sep_conceptos.denconsep like '%{$denconsep}%' {$cadenaFiltro} ";
		
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	
	}
	public function buscarDetalleUnidades($codemp) {
		$cadenasql="SELECT spg_dt_unidadadministrativa.coduniadm, codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla ".
				"   FROM spg_unidadadministrativa ".
		        "   INNER JOIN spg_dt_unidadadministrativa".
		        "   on spg_dt_unidadadministrativa.coduniadm= spg_unidadadministrativa.coduniadm".
				"   WHERE spg_unidadadministrativa.codemp='".$codemp."' ";
			
	  	return $this->conexionBaseDatos->Execute ( $cadenasql );	
	}
	
	public function buscarTipoBienes() {
		$cadenasql=" SELECT codtipart, dentipart ".
			        "FROM siv_tipoarticulo ".
					"ORDER BY codtipart ASC";
		return $this->conexionBaseDatos->Execute ( $cadenasql );	
	}
	
	/*FUNCIONES ELABORADAS POR LUIS ANIBAL LANG*/	
	public function validarFechaSEP($fecregsol)
	{
		$cadenasql="SELECT SELECT numsol,fecregsol ".
                   "FROM sep_solicitud".
				   "WHERE sep_solicitud.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
			       "ORDER BY sep_solicitud.numsol DESC ";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		if(!$dataSEP->EOF)
		{
			$fecregsolant=$dataSEP->fields['fecregsol'];
			$fecregsol=convertirFechaBd($fecregsol);
			$this->valido=compararFecha($fecregsolant,$fecregsol);
		}
		return $this->valido;
	}
	
	public function cargarCargosArticulos($codart,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla)
	{
		$capiva=$_SESSION["la_empresa"]["capiva"];
		$parcapiva=trim($_SESSION["la_empresa"]["parcapiva"]);
		
		if($capiva=="1")
		{
			$cadenasql= "SELECT TRIM(siv_articulo.codart) AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar, ".
						"		TRIM(siv_articulo.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro, ".
						"		(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
						"		 WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
						"		   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
						"		   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
						"		   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
						"		   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
						"		   AND spg_cuentas.estcla='".$estcla."' ".				
						"		   AND siv_articulo.codemp = spg_cuentas.codemp ".
						"		   AND siv_articulo.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
						" FROM sigesp_cargos, siv_cargosarticulo,siv_articulo ".
						" WHERE siv_articulo.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
						"   AND siv_articulo.codart = '".$codart."' ".
						"   AND siv_articulo.codemp = siv_cargosarticulo.codemp ".
						"   AND siv_articulo.codart = siv_cargosarticulo.codart ".
						"	AND sigesp_cargos.codemp = siv_cargosarticulo.codemp ".
						"   AND sigesp_cargos.codcar = siv_cargosarticulo.codcar ";
			$spg_cuenta=explode(",",$parcapiva);
			$totalcuentas=count($spg_cuenta);
			for($i=0;$i<$totalcuentas;$i++)
			{
				if($li_i==0)
				{
					$cadenasql=$cadenasql."   AND (siv_articulo.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
				else
				{
					$cadenasql=$cadenasql."    OR siv_articulo.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
			
			}
			if($totalcuentas>0)
			{
				$cadenasql=$cadenasql." )";
			}
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
						
		}
		if(($dataSEP->EOF)||($capiva!="1"))
		{
			$cadenasql= "SELECT TRIM(siv_cargosarticulo.codart) AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar, ".
						"		TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro, ".
						"		(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
						"		 WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
						"		   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
						"		   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
						"		   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
						"		   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
						"		   AND spg_cuentas.estcla='".$estcla."' ".				
						"		   AND sigesp_cargos.codemp = spg_cuentas.codemp ".
						"		   AND sigesp_cargos.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
						" FROM sigesp_cargos, siv_cargosarticulo ".
						" WHERE siv_cargosarticulo.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
						"   AND siv_cargosarticulo.codart = '".$codart."' ".
						"	AND sigesp_cargos.codemp = siv_cargosarticulo.codemp ".
						"   AND sigesp_cargos.codcar = siv_cargosarticulo.codcar ";
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
		}
		return $dataSEP;
	}

	public function cargarCargosServicios($codser,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla)
	{
		$capiva=$_SESSION["la_empresa"]["capiva"];
		$parcapiva=trim($_SESSION["la_empresa"]["parcapiva"]);
		$codestpro1= substr($codprouni,0,25);
		$codestpro2= substr($codprouni,25,25);
		$codestpro3= substr($codprouni,50,25);
		$codestpro4= substr($codprouni,75,25);
		$codestpro5= substr($codprouni,100,25);
		if($capiva=="1")
		{
			$cadenasql=	"SELECT soc_servicios.codser AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar,".
						"		TRIM(soc_servicios.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro, ".
						"		(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
						"	     WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
						"		   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
						"		   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
						"		   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
						"		   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
						"		   AND spg_cuentas.estcla='".$estcla."' ".				
						"		   AND soc_servicios.codemp = spg_cuentas.codemp ".
						"		   AND soc_servicios.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
						" FROM sigesp_cargos, soc_serviciocargo,soc_servicios ".
						" WHERE soc_servicios.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
						"   AND soc_servicios.codser = '".$codser."' ".
						"	AND soc_servicios.codemp = soc_serviciocargo.codemp ".
						"   AND soc_servicios.codser = soc_serviciocargo.codser ".
						"	AND sigesp_cargos.codemp = soc_serviciocargo.codemp ".
						"   AND sigesp_cargos.codcar = soc_serviciocargo.codcar ";
			$spg_cuenta=explode(",",$parcapiva);
			$totalcuentas=count($spg_cuenta);
			for($i=0;$i<$totalcuentas;$i++)
			{
				if($li_i==0)
				{
					$cadenasql=$cadenasql."   AND (soc_servicios.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
				else
				{
					$cadenasql=$cadenasql."    OR soc_servicios.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
			
			}
			if($totalcuentas>0)
			{
				$cadenasql=$cadenasql." )";
			}
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
						
		}
		if(($dataSEP->EOF)||($capiva!="1"))
		{
			$cadenasql= "SELECT soc_serviciocargo.codser AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar,".
				"				TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro,". 
				"				(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
				"				 WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
				"				   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
				"				   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
				"				   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
				"				   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
				"				   AND spg_cuentas.estcla='".$estcla."' 			".	
				"				   AND sigesp_cargos.codemp = spg_cuentas.codemp ".
				"   			   AND sigesp_cargos.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
				"		 FROM sigesp_cargos, soc_serviciocargo ".
				"		 WHERE soc_serviciocargo.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
				"		   AND soc_serviciocargo.codser = '".$codser."' ".
				"		   AND sigesp_cargos.codemp = soc_serviciocargo.codemp ".
				"		   AND sigesp_cargos.codcar = soc_serviciocargo.codcar ";
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
		}
		return $dataSEP;
	}

	public function cargarCargosConceptos($codcon,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla)
	{
		$capiva=$_SESSION["la_empresa"]["capiva"];
		$parcapiva=trim($_SESSION["la_empresa"]["parcapiva"]);
		$codestpro1= substr($codprouni,0,25);
		$codestpro2= substr($codprouni,25,25);
		$codestpro3= substr($codprouni,50,25);
		$codestpro4= substr($codprouni,75,25);
		$codestpro5= substr($codprouni,100,25);
		if($capiva=="1")
		{
			$cadenasql= "SELECT sep_conceptos.codconsep AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar,".
						"		TRIM(sep_conceptos.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro, ".
						"		(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
						"		 WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
						"		   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
						"		   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
						"		   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
						"		   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
						"		   AND spg_cuentas.estcla='".$estcla."' ".				
						"		   AND sigesp_cargos.codemp = spg_cuentas.codemp ".
						"		   AND sigesp_cargos.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
						" FROM sigesp_cargos, sep_conceptocargos,sep_conceptos ".
						" WHERE sep_conceptos.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
						"   AND sep_conceptos.codconsep = '".$codcon."' ".
						"   AND sep_conceptos.codconsep = sep_conceptocargos.codconsep ".
						"	AND sigesp_cargos.codemp = sep_conceptocargos.codemp ".
						"   AND sigesp_cargos.codcar = sep_conceptocargos.codcar ";	
			$spg_cuenta=explode(",",$parcapiva);
			$totalcuentas=count($spg_cuenta);
			for($i=0;$i<$totalcuentas;$i++)
			{
				if($li_i==0)
				{
					$cadenasql=$cadenasql."   AND (sep_conceptos.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
				else
				{
					$cadenasql=$cadenasql."    OR sep_conceptos.spg_cuenta like '".$spg_cuenta[$i]."%'";
				}
			
			}
			if($totalcuentas>0)
			{
				$cadenasql=$cadenasql." )";
			}
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
						
		}
		if(($dataSEP->EOF)||($capiva!="1"))
		{
			$cadenasql=	"SELECT sep_conceptocargos.codconsep AS codigo, sigesp_cargos.codcar, sigesp_cargos.dencar,".
						"		TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta, sigesp_cargos.formula, sigesp_cargos.codestpro, ".
						"		(SELECT COUNT(spg_cuenta) FROM spg_cuentas ".
						"		 WHERE spg_cuentas.codestpro1 = '".$codestpro1."' ".
						"		   AND spg_cuentas.codestpro2 = '".$codestpro2."' ".
						"		   AND spg_cuentas.codestpro3 = '".$codestpro3."' ".
						"		   AND spg_cuentas.codestpro4 = '".$codestpro4."' ".
						"		   AND spg_cuentas.codestpro5 = '".$codestpro5."' ".
						"		   AND spg_cuentas.estcla='".$estcla."' ".				
						"		   AND sigesp_cargos.codemp = spg_cuentas.codemp ".
						"		   AND sigesp_cargos.spg_cuenta = spg_cuentas.spg_cuenta) AS existecuenta ".
						" FROM sigesp_cargos, sep_conceptocargos ".
						" WHERE sep_conceptocargos.codemp = '".$_SESSION['la_empresa']['codemp']."' ".
						"   AND sep_conceptocargos.codconsep = '".$codcon."' ".
						"	AND sigesp_cargos.codemp = sep_conceptocargos.codemp ".
						"   AND sigesp_cargos.codcar = sep_conceptocargos.codcar ";
			$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
			if ($dataSEP===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
		}
		return $dataSEP;
	}

	public function cargarArticulos($codemp,$numsol)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql = '';
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(sep_dt_articulos.codestpro1,length(sep_dt_articulos.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_articulos.codestpro2,length(sep_dt_articulos.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_articulos.codestpro3,length(sep_dt_articulos.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(sep_dt_articulos.codestpro1,length(sep_dt_articulos.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_articulos.codestpro2,length(sep_dt_articulos.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_articulos.codestpro3,length(sep_dt_articulos.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(sep_dt_articulos.codestpro4,length(sep_dt_articulos.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(sep_dt_articulos.codestpro5,length(sep_dt_articulos.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenasql = "SELECT sep_dt_articulos.codart, sep_dt_articulos.canart, sep_dt_articulos.unidad, sep_dt_articulos.monpre,  ".
				"			 sep_dt_articulos.monart, sep_dt_articulos.orden, TRIM(sep_dt_articulos.spg_cuenta) AS spg_cuenta,".
				"			 siv_articulo.denart,siv_unidadmedida.unidad AS unimed, sep_dt_articulos.orden,siv_unidadmedida.denunimed,".
				"			 sep_dt_articulos.codestpro1, sep_dt_articulos.codestpro2, sep_dt_articulos.codestpro2,{$cadenaEstructura} AS estructura, ".
				"	         sep_dt_articulos.codestpro3, sep_dt_articulos.codestpro4, sep_dt_articulos.codestpro5,".
				"			 sep_dt_articulos.estcla, siv_unidadmedida.denunimed, sep_dt_articulos.codfuefin,sep_dt_articulos.numsol".
              	"	  FROM sep_dt_articulos, siv_articulo, siv_unidadmedida ".
              	"	  WHERE sep_dt_articulos.codemp = '{$codemp}' ".
				"	    AND sep_dt_articulos.numsol = '{$numsol}'". 
				"	   	AND sep_dt_articulos.codemp = siv_articulo.codemp". 
				"	   	AND sep_dt_articulos.codart = siv_articulo.codart ".
				"		AND siv_articulo.codunimed = siv_unidadmedida.codunimed ".
				"	  ORDER BY sep_dt_articulos.orden ";
		return $this->conexionBaseDatos->Execute($cadenasql);
	}
	
	public function cargarServicios($codemp,$numsol)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql = '';

		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(sep_dt_servicio.codestpro1,length(sep_dt_servicio.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_servicio.codestpro2,length(sep_dt_servicio.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_servicio.codestpro3,length(sep_dt_servicio.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(sep_dt_servicio.codestpro1,length(sep_dt_servicio.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_servicio.codestpro2,length(sep_dt_servicio.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_servicio.codestpro3,length(sep_dt_servicio.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(sep_dt_servicio.codestpro4,length(sep_dt_servicio.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(sep_dt_servicio.codestpro5,length(sep_dt_servicio.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenasql= "SELECT sep_dt_servicio.codser, sep_dt_servicio.canser, sep_dt_servicio.monpre,{$cadenaEstructura} AS estructura, ".
				"			sep_dt_servicio.monser, sep_dt_servicio.orden, TRIM(sep_dt_servicio.spg_cuenta) AS spg_cuenta, ".
				"			soc_servicios.denser,sep_dt_servicio.codestpro1,sep_dt_servicio.codestpro2,".
				"			sep_dt_servicio.codestpro3,sep_dt_servicio.codestpro4, sep_dt_servicio.numsol,".
				"	        sep_dt_servicio.codestpro5,sep_dt_servicio.estcla,sep_dt_servicio.codfuefin". 
               	"	 FROM sep_dt_servicio, soc_servicios ".
                "	 WHERE sep_dt_servicio.codemp = '{$codemp}' ".
				"	   AND sep_dt_servicio.numsol = '{$numsol}' ".
				"	   AND sep_dt_servicio.codemp = soc_servicios.codemp ". 
				"	   AND sep_dt_servicio.codser = soc_servicios.codser ".
				"	 ORDER BY sep_dt_servicio.orden ";

		return $this->conexionBaseDatos->Execute($cadenasql);
	}
	
	public function cargarConceptos($codemp,$numsol)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql = '';

		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(sep_dt_concepto.codestpro1,length(sep_dt_concepto.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_concepto.codestpro2,length(sep_dt_concepto.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_concepto.codestpro3,length(sep_dt_concepto.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(sep_dt_concepto.codestpro1,length(sep_dt_concepto.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sep_dt_concepto.codestpro2,length(sep_dt_concepto.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sep_dt_concepto.codestpro3,length(sep_dt_concepto.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(sep_dt_concepto.codestpro4,length(sep_dt_concepto.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(sep_dt_concepto.codestpro5,length(sep_dt_concepto.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenasql=	"SELECT sep_dt_concepto.codconsep, sep_dt_concepto.cancon, sep_dt_concepto.monpre, {$cadenaEstructura} AS estructura, ".
			"				sep_dt_concepto.moncon, sep_dt_concepto.orden, TRIM(sep_dt_concepto.spg_cuenta) AS spg_cuenta, ".
			"				sep_conceptos.denconsep,sep_dt_concepto.codestpro1,sep_dt_concepto.codestpro2,".
			"				sep_dt_concepto.codestpro3,sep_dt_concepto.codestpro4,sep_dt_concepto.codestpro5,".
			"				sep_dt_concepto.estcla,sep_dt_concepto.codfuefin".
            "   	 FROM sep_dt_concepto, sep_conceptos ".
            "    	 WHERE sep_dt_concepto.codemp = '{$codemp}'". 
			"		   AND sep_dt_concepto.numsol = '{$numsol}'". 
			"		   AND sep_dt_concepto.codconsep = sep_conceptos.codconsep ".
			"		 ORDER BY sep_dt_concepto.orden ";

		return $this->conexionBaseDatos->Execute ( $cadenasql );
		
	}
	
	public function cargarCargos($numsol,$tabla,$campo){
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(".$tabla.".codestpro1,length(".$tabla.".codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(".$tabla.".codestpro2,length(".$tabla.".codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(".$tabla.".codestpro3,length(".$tabla.".codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(".$tabla.".codestpro1,length(".$tabla.".codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(".$tabla.".codestpro2,length(".$tabla.".codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(".$tabla.".codestpro3,length(".$tabla.".codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(".$tabla.".codestpro4,length(".$tabla.".codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(".$tabla.".codestpro5,length(".$tabla.".codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenasql= "SELECT ".$tabla.".".$campo." AS codigo, ".$tabla.".codcar, ".$tabla.".monbasimp, ".$tabla.".monimp, ".
				"       ".$tabla.".monto, ".$tabla.".formula, sigesp_cargos.dencar, TRIM(sigesp_cargos.spg_cuenta) AS spg_cuenta, {$cadenaEstructura} AS estructura, ".
				"       ".$tabla.".codestpro1,".$tabla.".codestpro2,".$tabla.".codestpro3,".$tabla.".codestpro4,".$tabla.".codestpro5,".$tabla.".estcla".
				"    FROM ".$tabla.", sigesp_cargos ".
				"    WHERE ".$tabla.".codemp = '".$_SESSION['la_empresa']['codemp']."' ".
				"      AND ".$tabla.".numsol = '".$numsol."' ".
				"      AND ".$tabla.".codemp = sigesp_cargos.codemp ".
				"      AND ".$tabla.".codcar = sigesp_cargos.codcar ";
		
		$dataSEP = $this->conexionBaseDatos->Execute($cadenasql);
		if ($dataSEP===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $dataSEP;
	}
	
	public function cargarCuentas($codemp,$numsol)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql = '';
		
		switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		
		$cadenasql ="SELECT TRIM(codestpro1) AS codestpro1,TRIM(codestpro2) AS codestpro2,TRIM(codestpro3) AS codestpro3,".
				"			TRIM(codestpro4) AS codestpro4,TRIM(codestpro5) AS codestpro5,TRIM(spg_cuenta) AS spg_cuenta,".
				"			monto AS total,estcla,codfuefin,{$cadenaEstructura} AS estructura".
				"  	 FROM sep_cuentagasto ".
				" 	 WHERE codemp='{$codemp}'". 
				" 	   AND numsol='{$numsol}'".
				"      AND monto NOT IN(SELECT monto FROM sep_solicitudcargos ".
				"   					WHERE codemp='{$codemp}'".
				"   					  AND numsol='{$numsol}')"; 
		
		return $this->conexionBaseDatos->Execute ( $cadenasql );
	}

	public function cargarCuentasCargo($codemp,$numsol)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenasql = '';
		
	    switch($_SESSION["la_empresa"]["estmodest"]) {
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(codestpro1,length(codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(codestpro2,length(codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(codestpro3,length(codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(codestpro4,length(codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(codestpro5,length(codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadenasql=	"SELECT codcar,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,codfuefin,formula,".
				"	 		TRIM(spg_cuenta) AS spg_cuenta, monto AS total,estcla,{$cadenaEstructura} AS estructura ".
				"	 FROM sep_solicitudcargos ".
				"	 WHERE codemp='{$codemp}' ".
				"	   AND numsol='{$numsol}'";

		return $this->conexionBaseDatos->Execute ( $cadenasql );
	}
	
	public function validarOrigen($codtipsol,$tipodestino,$codprov,$numdocori)
	{
		$existe=false;
		$cadenasql= "SELECT estope".
					"  FROM sep_tiposolicitud".
					" WHERE codtipsol='".$codtipsol."'";
		$dataSEP = $this->conexionBaseDatos->Execute( $cadenasql );
		if ($dataSEP===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$dataSEP->EOF)
			{
				$estope=$dataSEP->fields['estope'];
				if($estope=="R")
				{
					$cadenasql= "SELECT numsol".
								"FROM sep_solicitud".
								"WHERE codemp='".$_SESSION['la_empresa']['codemp']."'".
								"  AND numdocori='".$numdocori."'";
					$dataSEP = $this->conexionBaseDatos->Execute( $cadenasql );
					if ($dataSEP===false)
					{
						$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
						$this->valido = false;
					}
					else
					{
						if(!$dataSEP->EOF)
						{
							$existe=true;
						}
					}
				}
				else
				{
					if($tipodestino=="B")
					{
						$criterio= " AND ced_bene='".$as_codprov."'";
					}
					else
					{
						$criterio= " AND cod_pro='".$as_codprov."'";
					}				
					$cadenasql=	"SELECT numsol".
								"FROM sep_solicitud".
								"WHERE codemp='".$_SESSION['la_empresa']['codemp']."'".
								"  AND numdocori='".$numdocori."'".
								$criterio; 				
					$dataSEP = $this->conexionBaseDatos->Execute( $cadenasql );
					if ($dataSEP===false)
					{
						$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
						$this->valido = false;
					}
					else
					{
						if(!$dataSEP->EOF)
						{
							$existe=true;
						}
					}
				}
			}
		}
		return $existe;
	}

	public function buscarNivelUsuario($codusu,$codtipniv){
		$nivel="";
		$cadenasql= "SELECT codasiniv ".
					"FROM sss_niv_usuarios ".
					"WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
					"  AND codusu='".$codusu."' ".
					"  AND codtipniv='".$codtipniv."'";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$nivel=$dataSEP->fields['codasiniv'];
			}
		}
		return $nivel;
	}
	
	public function buscarMontoMaximo($codniv)
	{
		$monto="";
		$cadenasql= "SELECT monnivhas ".
					"FROM sigesp_nivel ".
					"WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
					"  AND codniv='".$codniv."'";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$monto=$dataSEP->fields['monnivhas'];
			}
		}
		return $monto;
	}
	
	public function buscarNivel($codasiniv)
	{
		$codniv="";
		$cadenasql= "SELECT codniv ".
					"FROM sigesp_asig_nivel ".
					"WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
					"  AND codasiniv='".$codasiniv."'";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$codniv=$dataSEP->fields['codniv'];
			}
		}
		return $codniv;
	}

	public function buscarSolicitudes($codemp,$numsol,$codtipsol,$coduniadm,$fechadesd,$fechahas,$tipooperacion,$tipsepbie,
									  $concepto,$destino,$tipo,$codpro,$cedbene,$operacion,$origen_catalogo){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();	
		$cadenaSQL=''; 
		$cadenaFiltro='';
		$filautcan='';
		$campo='';
		$straux='';
		
		switch($_SESSION["la_empresa"]["estmodest"]){
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(sc.codestpro1,length(sc.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sc.codestpro2,length(sc.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sc.codestpro3,length(sc.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(sc.codestpro1,length(sc.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(sc.codestpro2,length(sc.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(sc.codestpro3,length(sc.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(sc.codestpro4,length(sc.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(sc.codestpro5,length(sc.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$cadena = $this->conexionBaseDatos->Concat('nombene',"'-'",'apebene');
		$usuario = $_SESSION["la_logusr"];
		$cadena1 = $this->conexionBaseDatos->Concat("'{$codemp}'","'SEP'","'{$usuario}'",'ua.coduniadm');
		$cadena2 = $this->conexionBaseDatos->Concat('codemp','codsis','codusu','codintper');
		$cadena3 = $this->conexionBaseDatos->Concat("'{$codemp}'","'SPG'","'{$usuario}'",'sc.codestpro1','sc.codestpro2','sc.codestpro3','sc.codestpro4','sc.codestpro5','sc.estcla');
		$cadenaSeguridad= " AND {$cadena1} IN".
						  " (SELECT {$cadena2} ".
						  "  FROM sss_permisos_internos WHERE codusu = '".$_SESSION["la_logusr"]."'".
						  "   AND codsis = 'SEP' AND enabled=1)".
						  " AND {$cadena3} IN".
						  " (SELECT {$cadena2} ".
						  "  FROM sss_permisos_internos WHERE codusu = '".$_SESSION["la_logusr"]."'".
						  "   AND codsis = 'SPG' AND enabled=1)";
		$cadenaCodigo = $this->conexionBaseDatos->Concat('sc.codtipsol','sts.modsep','sts.estope','sts.estayueco');
		$codasiniv=$this->buscarNivelUsuario($_SESSION["la_logusr"],'1');
		if($codasiniv!="")
		{
			$codniv=$this->buscarNivel($codasiniv);
			if($codniv!=""){
				$montomax=$this->buscarMontoMaximo($codniv);
			}
		}
		if($operacion=="COPIAR"){
			$filautcan = " AND sts.estope='R' AND sc.estapro=0";
		}
	    if(!empty($numsol)){
			$cadenaFiltro=$cadenaFiltro."AND sc.numsol like '%{$numsol}%'";
		}
	 	if(!empty($coduniadm)){
			$cadenaFiltro=$cadenaFiltro."AND sc.coduniadm='{$coduniadm}'";
		}
		if(!empty($codtipsol)){
			$cadenaFiltro=$cadenaFiltro."AND sc.codtipsol='{$codtipsol}'";
		}
	    if(!empty($concepto)){
			$cadenaFiltro=$cadenaFiltro."AND sc.consol='{$concepto}'";
		}
		if(!empty($tipsepbie)){
			if($tipsepbie=='M'){
	    		$cadenaFiltro=$cadenaFiltro."AND sc.tipsepbie='0'";
	    	}
	    	else if($tipsepbie=='A'){
	    		$cadenaFiltro=$cadenaFiltro."AND sc.tipsepbie='1'";
	    	}
		}
	    if(!empty($destino)){
	    	if($destino=='P'){
	    		$campo=",prov.nompro as nombre";
	    		$cadenaFiltro=$cadenaFiltro."AND sc.cod_pro like '%{$codpro}%'";
	    	}
	    	else if($destino=='B'){
	    		$campo=",ben.nombene as nombre";
	    		$cadenaFiltro=$cadenaFiltro."AND sc.ced_bene like '%{$cedbene}%'";
	    	}
		}		
		if (!empty($fechadesd) && !empty($fechahas)) {
			$fechadesd = convertirFechaBd($fechadesd);
			$fechahas = convertirFechaBd($fechahas);
			$cadenaFiltro = $cadenaFiltro." AND sc.fecregsol BETWEEN '{$fechadesd}' AND '{$fechahas}'";
		}
		if(!empty($tipo)){
			if($origen_catalogo=='SC'){
				if($tipo=='B'){
		     		$straux = "INNER JOIN sep_dt_articulos dt USING(codemp,numsol) ";
		     		$cadenaFiltro = $cadenaFiltro."AND dt.canart<>0";
		   		}
				else if($tipo=='S'){
		     		$straux = "INNER JOIN sep_dt_servicio dt USING(codemp,numsol) ";
		     		$cadenaFiltro = $cadenaFiltro."AND dt.canser<>0";
		    	}
		    	$cadenaFiltro = $cadenaFiltro."AND (sc.estsol='C' OR sc.estsol='P')";
		    	$cadenaFiltro = $cadenaFiltro."AND dt.estincite='NI' ";
			}
			else{
				$cadenaFiltro = $cadenaFiltro."   AND sts.modsep like '%".$tipo."%' ";
			}
		}
		if(!empty($origen_catalogo)){
			if(trim($origen_catalogo)=='APROBACION'){
				$cadenaFiltro = $cadenaFiltro." AND sc.estsol='E' ";
				$cadenaFiltro = $cadenaFiltro." AND sc.estapro='{$tipooperacion}' {$cadenaSeguridad}";
			}
			if(trim($origen_catalogo)=='ANULACION'){
				switch ($tipooperacion){
					case 0:
						$cadenaFiltro = $cadenaFiltro."   AND (sc.estsol='E' OR sc.estsol='R')";
						break;
					case 1:
						$cadenaFiltro = $cadenaFiltro."   AND sc.estsol='A' ".
						              		  "           AND numsol NOT IN (SELECT comprobante ".
											  "				 FROM sigesp_cmp ".
										 	  "				 WHERE codemp = '{$codemp}' ".
											  "				 AND (procede = 'SEPSPC' OR procede = 'SEPSPA') )";
						break;
				}
			}	
		}
		$cadenaSQL="SELECT sc.numsol, sc.coduniadm, sc.codfuefin, {$cadenaCodigo} AS codtipsol,   ".
					  "	   sc.fecregsol, sc.estsol, sc.consol, sc.monto, sc.tipsepbie,  ".
					  "	   sc.monbasinm,sc.estapro,sc.nombenalt,sc.numdocori,sc.cod_pro, ".
					  "	   sc.codestpro1,sc.codestpro2,sc.codestpro3,sc.ced_bene, sc.tipo_destino, ".
					  "	   (CASE WHEN sc.tipo_destino='B' THEN (SELECT ".$cadena." ".
															"  FROM rpc_beneficiario".
															"  WHERE sc.ced_bene=rpc_beneficiario.ced_bene)".
					  "     WHEN sc.tipo_destino='P' THEN (SELECT nompro".
														" FROM rpc_proveedor".
														" WHERE sc.cod_pro=rpc_proveedor.cod_pro)".
					  "     ELSE 'NINGUNO' END) AS nombre, ua.denuniadm,  ".
					  "    sc.codestpro4,sc.codestpro5,sc.estcla,sc.conanusep, sts.modsep, {$cadenaEstructura} as estructura {$campo} ".
        		"	FROM sep_solicitud sc  ".
				"   INNER JOIN sep_tiposolicitud sts USING(codemp,codtipsol)  ".
				"   INNER JOIN rpc_proveedor prov USING(codemp,cod_pro)   ".
				"   INNER JOIN rpc_beneficiario ben USING(codemp,ced_bene)  ".
				"   INNER JOIN spg_unidadadministrativa ua USING(codemp,coduniadm) ".
				"   {$straux} ".
	    		"   WHERE sc.codemp='{$codemp}'   ".
				"     AND sc.numsol<>'---------------' {$cadenaFiltro} {$filautcan}".
	    		"   GROUP BY sc.numsol,sc.codtipsol,sc.coduniadm,sc.codfuefin, sc.estsol, sc.consol, ".
	    				"    sc.monto, sc.tipsepbie,sc.monbasinm,sc.fecregsol,sts.estope,sts.estayueco, ".
						"    sc.estapro, sc.nombenalt,sc.numdocori,sc.tipo_destino,  ".
						"    sc.codestpro1,sc.codestpro2,sc.codestpro3,sc.codestpro4,sc.codestpro5,sc.estcla,sc.conanusep,  ".
						"    prov.nompro,ben.nombene,sc.ced_bene,sc.cod_pro,sts.modsep, ua.denuniadm " ;
		if(($codniv!="")){
			$cadenaSQL= $cadenaSQL." AND sc.monto <= ".$montomax."";
		}
		switch (strtoupper($_SESSION["ls_gestor"])){
	   		case "MYSQLT":
				$limite="LIMIT 0,500 ";
				$cadenaSQL = $cadenaSQL."ORDER BY sc.numsol ASC {$limite}";
			break;
	   		case "MYSQLI":
				$limite="LIMIT 0,500 ";
				$cadenaSQL = $cadenaSQL."ORDER BY sc.numsol ASC {$limite}";
			break;
			case "POSTGRES": // POSTGRES
				$limite="LIMIT 500";
				$cadenaSQL = $cadenaSQL."ORDER BY sc.numsol ASC {$limite}";
			break;
			case "OCI8PO":
				$limite="AND rownum<=500";
				$cadenaSQL = $cadenaSQL."{$limite} ORDER BY sc.numsol ASC";
	   }
		return $this->conexionBaseDatos->Execute($cadenaSQL);
				
	}
	
	public function SelectConfig($sistema, $seccion, $variable)
	{
       $ls_sql="SELECT value ".
		"       FROM sigesp_config ".
		"       WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
		"         AND codsis='".$sistema."' ".
		"         AND seccion='".$seccion."' ".
		"         AND entry='".$variable."' ";
       $rs_data = $this->conexionBaseDatos->Execute($ls_sql);      
	if ($rs_data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			$li_i=0;
		    if(!$rs_data->EOF)
			{
				$ls_valor=$rs_data->fields['value'];
			}			
			if($li_i==0)
			{
				$lb_valido=$this->insertarConfig($sistema, $seccion, $variable);
				if ($lb_valido)
				{
					$ls_valor=$this->Select_config($sistema, $seccion, $variable);
				}
			}
		}
		return rtrim($ls_valor);	
			       
	}
	public function insertarConfig($sistema, $seccion, $variable)
	{
			$this->daoInsertarFormato = FabricaDao::CrearDAO("N", "sigesp_config");	
			//seteando la data e iniciando transaccion de base de datos
			$this->daoInsertarFormato->setData($objson);
			$this->daoInsertarFormato->codemp=$codemp;
			DaoGenerico::iniciarTrans();
	
			//insertando el registro y escribiendo en el log
			$this->daoInsertarFormato->incluir();
			if($li_row===false)
			{
				$lb_valido=false;
			}
		return $lb_valido;
	}
	
	public function buscarCuentasSpg($codemp,$tipo,$spg_cuenta,$codestpro1ue,$codestpro2ue,$codestpro3ue,$codestpro4ue,$codestpro5ue,$estclaue,$codfuefin)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$criterio='';
		$sql_seguridad='';
		$cadenaSQL = '';
		$orden = 'ASC';
		$campoorden = 'codpro';
	
		$codespro1=str_pad($codestpro1ue,25,"0",0);
		$codespro2=str_pad($codestpro2ue,25,"0",0);
		$codespro3=str_pad($codestpro3ue,25,"0",0);
		$codespro4=str_pad($codestpro4ue,25,"0",0);
		$codespro5=str_pad($codestpro5ue,25,"0",0);
		$estcla=$estclaue;
		$cadena = $this->conexionBaseDatos->Concat('spg_cuentas.codestpro1','spg_cuentas.codestpro2','spg_cuentas.codestpro3','spg_cuentas.codestpro4','spg_cuentas.codestpro5','spg_cuentas.estcla','spg_cuentas.spg_cuenta');
	    $criterio = " AND  ".$cadena." <> ('$codespro1$codespro2$codespro3$codespro4$codespro5$estcla$spg_cuenta')";
		if($_SESSION["la_empresa"]["estmodest"]==1)
		{
			$codest1 = "SUBSTR(spg_cuentas.codestpro1,length(spg_cuentas.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
			$codest2 = "SUBSTR(spg_cuentas.codestpro2,length(spg_cuentas.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
			$codest3 = "SUBSTR(spg_cuentas.codestpro3,length(spg_cuentas.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
			$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
		}	
		else{
			$codest1 = "SUBSTR(spg_cuentas.codestpro1,length(spg_cuentas.codestpro1)-{$_SESSION["la_empresa"]["loncodestpro1"]})";
			$codest2 = "SUBSTR(spg_cuentas.codestpro2,length(spg_cuentas.codestpro2)-{$_SESSION["la_empresa"]["loncodestpro2"]})";
			$codest3 = "SUBSTR(spg_cuentas.codestpro3,length(spg_cuentas.codestpro3)-{$_SESSION["la_empresa"]["loncodestpro3"]})";
			$codest4 = "SUBSTR(spg_cuentas.codestpro4,length(spg_cuentas.codestpro4)-{$_SESSION["la_empresa"]["loncodestpro4"]})";
			$codest5 = "SUBSTR(spg_cuentas.codestpro5,length(spg_cuentas.codestpro5)-{$_SESSION["la_empresa"]["loncodestpro5"]})";
			$cadenaEstructura = $this->conexionBaseDatos->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
		}

	    //------------------------Con respecto a la seguridad------------------------------------------------
		$sesion = "'{$_SESSION['la_logusr']}'";
		$cadena1 = $this->conexionBaseDatos->Concat("'{$codemp}'","'SPG'",$sesion,'spg_cuentas.codestpro1','spg_cuentas.codestpro2','spg_cuentas.codestpro3','spg_cuentas.codestpro4','spg_cuentas.codestpro5','spg_cuentas.estcla');
		$cadena2 = $this->conexionBaseDatos->Concat('codemp','codsis','codusu','codintper');
		$sql_seguridad = " AND {$cadena1} IN ".
					"	   (SELECT {$cadena2}     ".
					"		FROM sss_permisos_internos     ".
					"		WHERE codusu = '{$_SESSION['la_logusr']}'   ".         
					"		  AND codsis = 'SPG'  AND enabled=1)";
		//-------------------------------------------------------------------------------------------------- 
		if($campoorden=='codpro')
		{
			$campoorden= "codestpro1,codestpro2,codestpro3,codestpro4,codestpro5";
		}
		
		$cadenaSQL="SELECT TRIM(spg_cuentas.spg_cuenta) AS spg_cuenta , spg_cuentas.denominacion, spg_cuentas.codestpro1,spg_cuentas.codestpro2, spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5,spg_cuentas.status,spg_cuentas.estcla, ".
				"          (asignado-(comprometido+precomprometido)+aumento-disminucion) as disponible, {$cadenaEstructura} AS estructura ".
			    " 	FROM spg_cuentas, spg_cuenta_fuentefinanciamiento ".
				" 	WHERE spg_cuentas.codemp = '{$codemp}'  ".
				"	  AND spg_cuentas.spg_cuenta like '%{$spg_cuenta}%' ".
				"     AND status ='C' {$criterio} {$sql_seguridad}".
				"     AND spg_cuenta_fuentefinanciamiento.codfuefin='".$codfuefin."'".
				"     AND spg_cuentas.codemp = spg_cuenta_fuentefinanciamiento.codemp".
				"     AND spg_cuentas.codestpro1 = spg_cuenta_fuentefinanciamiento.codestpro1".
				"     AND spg_cuentas.codestpro2 = spg_cuenta_fuentefinanciamiento.codestpro2".
				"     AND spg_cuentas.codestpro3 = spg_cuenta_fuentefinanciamiento.codestpro3".
				"     AND spg_cuentas.codestpro4 = spg_cuenta_fuentefinanciamiento.codestpro4".
				"     AND spg_cuentas.codestpro5 = spg_cuenta_fuentefinanciamiento.codestpro5".
				"     AND spg_cuentas.estcla = spg_cuenta_fuentefinanciamiento.estcla".
				"     AND spg_cuentas.spg_cuenta = spg_cuenta_fuentefinanciamiento.spg_cuenta".					
				"  	ORDER BY {$campoorden} {$orden} ";
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	}
	
	//funciones elaboradas por maryoly caceres
	function select_cuentacontable($codemp,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$cuenta,$estcla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "SELECT sc_cuenta ".
				"  	  FROM spg_cuentas ".
				" 	  WHERE codemp='{$codemp}' ".
				"   	AND codestpro1='{$codestpro1}' ".
				"   	AND codestpro2='{$codestpro2}' ".
				"  		AND codestpro3='{$codestpro3}' ".
				"   	AND codestpro4='{$codestpro4}' ".
				"   	AND codestpro5='{$codestpro5}' ".
				"   	AND estcla= '{$estcla}'".
				"	   	AND spg_cuenta='{$cuenta}'";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;	
		}
		return $data->fields['sc_cuenta'];
	}
	
	function validarCuentas($codemp,$numsol,$operacion)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$estsol='E';
		$cadenaSQL='';
		$cadenaSQL="SELECT codestpro1, codestpro2, codestpro3, codestpro4, codestpro5,estcla, TRIM(spg_cuenta) AS spg_cuenta, monto, ".
				"	    (SELECT (asignado-(comprometido+precomprometido)+aumento-disminucion) ".
				"		 FROM spg_cuentas ".
				"		 WHERE spg_cuentas.codemp = sep_cuentagasto.codemp ".
				"		   AND spg_cuentas.codestpro1 = sep_cuentagasto.codestpro1 ".
				"		   AND spg_cuentas.codestpro2 = sep_cuentagasto.codestpro2 ".
				"		   AND spg_cuentas.codestpro3 = sep_cuentagasto.codestpro3 ".
				"		   AND spg_cuentas.codestpro4 = sep_cuentagasto.codestpro4 ".
				"		   AND spg_cuentas.codestpro5 = sep_cuentagasto.codestpro5 ".
				"          AND spg_cuentas.estcla=sep_cuentagasto.estcla".
				"		   AND spg_cuentas.spg_cuenta = sep_cuentagasto.spg_cuenta) AS disponibilidad, ".		
				"		(SELECT COUNT(codemp) ".
				"		 FROM spg_cuentas ".
				"		 WHERE spg_cuentas.codemp = sep_cuentagasto.codemp ".
				"		   AND spg_cuentas.codestpro1 = sep_cuentagasto.codestpro1 ".
				"		   AND spg_cuentas.codestpro2 = sep_cuentagasto.codestpro2 ".
				"		   AND spg_cuentas.codestpro3 = sep_cuentagasto.codestpro3 ".
				"		   AND spg_cuentas.codestpro4 = sep_cuentagasto.codestpro4 ".
				"		   AND spg_cuentas.codestpro5 = sep_cuentagasto.codestpro5 ".
				"          AND spg_cuentas.estcla=sep_cuentagasto.estcla".
				"		   AND spg_cuentas.spg_cuenta = sep_cuentagasto.spg_cuenta) AS existe ".		
				"FROM sep_cuentagasto  ".
				"WHERE codemp='".$codemp."' ".
				"  AND numsol='".$numsol."'";
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
    	if($data===false){		
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;		
		}
		else
		{
			$continuar=true;
			$_SESSION['fechacomprobante'] = '1900-01-01';
			while((!$data->EOF) && ($continuar))
			{
				$monto=$data->fields["monto"];
				$existe=$data->fields["existe"];
				$this->servicioComprobante = new ServicioComprobanteSPG();
				$arrdetallespg['codemp']     = $_SESSION['la_empresa']['codemp'];
				$arrdetallespg['codestpro1'] = $data->fields['codestpro1'];
				$arrdetallespg['codestpro2'] = $data->fields['codestpro2'];
				$arrdetallespg['codestpro3'] = $data->fields['codestpro3'];
				$arrdetallespg['codestpro4'] = $data->fields['codestpro4'];
				$arrdetallespg['codestpro5'] = $data->fields['codestpro5'];
				$arrdetallespg['estcla']     = $data->fields['estcla'];
				$arrdetallespg['spg_cuenta'] = $data->fields['spg_cuenta'];
				$this->servicioComprobante->setDaoDetalleSpg($arrdetallespg);
				$this->servicioComprobante->saldoSelect('ACTUAL');
				$disponibilidad =  (($this->servicioComprobante->asignado + $this->servicioComprobante->aumento) - ( $this->servicioComprobante->disminucion + $this->servicioComprobante->comprometido + $this->servicioComprobante->precomprometido));
				if($existe>0)
				{
					$monto=number_format($monto,2,".","");
					$disponibilidad=number_format($disponibilidad,2,".","");
					if($monto>$disponibilidad)
					{
						$monto=number_format($monto,2,",",".");
						$disponibilidad=number_format($disponibilidad,2,",",".");
						if($operacion!='S')
						{
							$this->mensaje .= '  ->No hay Disponibilidad en la cuenta'.$arrdetallespg['spg_cuenta'].' Disponible=['.$disponibilidad.'] Cuenta=['.$monto.']';
							$continuar= false;
							$estsol="R";
						}				
					}
				}
				else
				{
					$continuar = false;
					$estsol="R";
					$this->mensaje .= '  ->La Cuenta '.$arrdetallespg['spg_cuenta']." No Existe en la Estructura ".formatoprogramatica($arrdetallespg['codestpro1'].$arrdetallespg['codestpro2'].$arrdetallespg['codestpro3'].$arrdetallespg['codestpro4'].$arrdetallespg['codestpro5']).'::'.$arrdetallespg['estcla'];
				}
				unset($this->servicioComprobante);
				$data->MoveNext();
			}
			$str = "codemp='{$codemp}'";
			$str .= " AND numsol='{$numsol}'";
			$this->daoCambioEstatusSep = FabricaDao::CrearDAO('C','sep_solicitud',null,$str);
			$this->daoCambioEstatusSep->estsol=$estsol;
			if($this->daoCambioEstatusSep->modificar()==0)
			{
				break;
			}
			return $estsol; 					
		}
	}
	
	public function guardarSolicitud($codemp,$objson,$arrevento)
	{
		$resultado = '';//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detalleSep;
		$arrDetalleCargo = $objson->DetalleCargo;
		$numero = count($arrDetalleCargo);
		$arrDetalleCuenta = $objson->DetalleCuenta;
		$arrDetalleCueCar = $objson->DetalleCuentaCargos;
		$numcuecar = count($arrDetalleCueCar);
		
		//obteniendo las instacias de los dao's
		$this->daoSolicitud = FabricaDao::CrearDAO("N","sep_solicitud");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoSolicitud->setData($objson);
		$this->daoSolicitud->codemp = $codemp;
		$this->daoSolicitud->codtipsol = substr($objson->codtipsol,0,2);
		$this->daoSolicitud->fecregsol = convertirFechaBd($objson->fecregsol);
		$this->daoSolicitud->feccieinv = '1900-01-01';
		DaoGenerico::iniciarTrans();
		$operacion = substr($objson->codtipsol,4,1);
		
		$resultado = $this->daoSolicitud->incluir(true,"numsol",true,15);
		$arrcadres = explode(",",$resultado);
		//insertando el registro y escribiendo en el log
		if($arrcadres[0]==1||$arrcadres[0]==-1){
			foreach($arrDetalleCuenta as $detallecuenta)
			{
				$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","sep_cuentagasto");
				$this->daoDetalleCuenta->setData($detallecuenta);
				$this->daoDetalleCuenta->codemp = $codemp;
				$this->daoDetalleCuenta->monto = formatoNumericoBd($detallecuenta->monto,1);
				if(!$this->daoDetalleCuenta->incluir()){
					break;
				}
			}
			foreach($arrDetalleCueCar as $detallecuenta)
			{
				$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","sep_cuentagasto");
				$this->daoDetalleCuenta->setData($detallecuenta);
				$this->daoDetalleCuenta->codemp = $codemp;
				$this->daoDetalleCuenta->monto = formatoNumericoBd($detallecuenta->monto,1);
				if(!$this->daoDetalleCuenta->incluir()){
					break;
				}
			}
		
			if($numcuecar>0){
				foreach($arrDetalleCueCar as $detallecuecar){
					$sccuenta = '';
					$this->daoDetalleCueCar = FabricaDao::CrearDAO("N","sep_solicitudcargos");
					$this->daoDetalleCueCar->setData($detallecuecar);
					$this->daoDetalleCueCar->codemp = $codemp;
					$this->daoDetalleCueCar->monobjret = formatoNumericoBd($detallecuecar->monobjret,1);
					$this->daoDetalleCueCar->monret = formatoNumericoBd($detallecuecar->monret,1);
					$this->daoDetalleCueCar->monto = formatoNumericoBd($detallecuecar->monto,1);
					$sccuenta = $this->select_cuentacontable($codemp,$detallecuecar->codestpro1,$detallecuecar->codestpro2,$detallecuecar->codestpro3,
												 		     $detallecuecar->codestpro4,$detallecuecar->codestpro5,$detallecuecar->spg_cuenta,
												             $detallecuecar->estcla);
					$this->daoDetalleCueCar->sc_cuenta = $sccuenta;
					if(!$this->daoDetalleCueCar->incluir()){
						break;
					}
				}
			}
			
			$tipo = substr($objson->codtipsol,2,1);
			if($tipo=='B'){
				foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_articulos");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1); 
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->monart = formatoNumericoBd($detalle->monart,1);
					$this->daoDetalle->estincite = 'NI';
					$this->daoDetalle->canartorg = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
				if($numero>0){
					foreach ($arrDetalleCargo as $detallecargo){
						$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dta_cargos");
						$this->daoDetalleCargo->setData($detallecargo);
						$this->daoDetalleCargo->codemp = $codemp;
						$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
						$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
						$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
						if(!$this->daoDetalleCargo->incluir()){
							break;
						}
					}
				}
	        }
	        if($tipo=='S'){
	        	foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_servicio");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->monser = formatoNumericoBd($detalle->monser,1);
					$this->daoDetalle->estincite = 'NI';
					$this->daoDetalle->canserorg = 0;
					$this->daoDetalle->orden = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
	        	if($numero>0){
					foreach ($arrDetalleCargo as $detallecargo){
						$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dts_cargos");
						$this->daoDetalleCargo->setData($detallecargo);
						$this->daoDetalleCargo->codemp = $codemp;
						$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
						$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
						$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
						if(!$this->daoDetalleCargo->incluir()){
							break;
						}
					}
				}
	        }
	        if($tipo=='O'){
	        	foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_concepto");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->cancon = formatoNumericoBd($detalle->cancon,1);
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->moncon = formatoNumericoBd($detalle->moncon,1);
					$this->daoDetalle->orden = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
	        	if($numero>0){
					foreach ($arrDetalleCargo as $detallecargo){
						$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dtc_cargos");
						$this->daoDetalleCargo->setData($detallecargo);
						$this->daoDetalleCargo->codemp = $codemp;
						$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
						$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
						$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
						if(!$this->daoDetalleCargo->incluir()){
							break;
						}
					}
				}
	        }
	        
	        $estatus = $this->validarCuentas($codemp,$objson->numsol,$operacion);
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans()) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				if($arrcadres[0]==1){
					if($estatus=='R'){
						$servicioEvento->desevetra = 'Registro guardado en estatus registrado';	
					}
					return "|1"."|".$estatus;
				}
				else{
						return "|".$arrcadres[0]."|".$arrcadres[1]."|".estatus;
				} 		
			}
			else{
				$arrevento ['desevetra'] = $this->daoSolicitud->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				return "|0";
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoSolicitud);
			unset($this->daoDetalleCuenta);
			unset($this->daoDetalle);
			unset($this->daoDetalleCargo);
			unset($this->daoDetalleCueCar);
			unset($this->daoDetalleCueGas);
			unset($this->daoRegistroEvento);
		}
		else{
			return "|0";
		}
		
	}
	
	function eliminar($codemp,$numsol,$tabla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "DELETE FROM {$tabla} ".
				" 	  WHERE codemp='{$codemp}' ".
		        "       AND numsol='{$numsol}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		else
		{
			return true;
		}
	}
	
	public function modificarSolicitud($codemp,$objson,$arrevento){
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detalleSep;
		$arrDetalleCargo = $objson->DetalleCargo;
		$numero = count($arrDetalleCargo);
		$arrDetalleCuenta = $objson->DetalleCuenta;
		$arrDetalleCueCar = $objson->DetalleCuentaCargos;
		$numcuecar = count($arrDetalleCueCar);
		$this->conexionBaseDatos->debug=true;
		

		//obteniendo las instacias de los dao's
		$this->daoSolicitud = FabricaDao::CrearDAO("N","sep_solicitud");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoSolicitud->setData($objson);
		$this->daoSolicitud->codemp=$codemp;
		$this->daoSolicitud->codtipsol = substr($objson->codtipsol,0,2);
		$this->daoSolicitud->fecregsol = convertirFechaBd($objson->fecregsol);
		$this->daoSolicitud->feccieinv = '1900-01-01';
		$operacion = substr($objson->codtipsol,4,1);

		DaoGenerico::iniciarTrans();
		
		$this->daoSolicitud->modificar();
		//insertando el registro y escribiendo en el log
		
		$eliminocue = $this->eliminar($codemp,$objson->numsol,'sep_cuentagasto');
		if($eliminocue)
		{
			foreach($arrDetalleCuenta as $detallecuenta)
			{
				$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","sep_cuentagasto");
				$this->daoDetalleCuenta->setData($detallecuenta);
				$this->daoDetalleCuenta->codemp = $codemp;
				$this->daoDetalleCuenta->monto = formatoNumericoBd($detallecuenta->monto,1);
				if(!$this->daoDetalleCuenta->incluir()){
					break;
				}
			}
			foreach($arrDetalleCueCar as $detallecuenta)
			{
				$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","sep_cuentagasto");
				$this->daoDetalleCuenta->setData($detallecuenta);
				$this->daoDetalleCuenta->codemp = $codemp;
				$this->daoDetalleCuenta->monto = formatoNumericoBd($detallecuenta->monto,1);
				if(!$this->daoDetalleCuenta->incluir()){
					break;
				}
			}
		}
		
		if($numcuecar>0){
			$eliminocuecre = $this->eliminar($codemp,$objson->numsol,'sep_solicitudcargos');
			if($eliminocuecre){
				foreach($arrDetalleCueCar as $detallecuecar){
					$sccuenta = '';
					$this->daoDetalleCueCar = FabricaDao::CrearDAO("N","sep_solicitudcargos");
					$this->daoDetalleCueCar->setData($detallecuecar);
					$this->daoDetalleCueCar->codemp = $codemp;
					$this->daoDetalleCueCar->monobjret = formatoNumericoBd($detallecuecar->monobjret,1);
					$this->daoDetalleCueCar->monret = formatoNumericoBd($detallecuecar->monret,1);
					$this->daoDetalleCueCar->monto = formatoNumericoBd($detallecuecar->monto,1);
					$sccuenta = $this->select_cuentacontable($codemp,$detallecuecar->codestpro1,$detallecuecar->codestpro2,$detallecuecar->codestpro3,
												             $detallecuecar->codestpro4,$detallecuecar->codestpro5,$detallecuecar->spg_cuenta,
												             $detallecuecar->estcla);
					$this->daoDetalleCueCar->sc_cuenta = $sccuenta;
					if(!$this->daoDetalleCueCar->incluir()){
						break;
					}
				}
			}
		}
		
		$tipo = substr($objson->codtipsol,2,1);
		if($tipo=='B'){
			$eliminobiecar = $this->eliminar($codemp,$objson->numsol,'sep_dta_cargos');
			$eliminobie = $this->eliminar($codemp,$objson->numsol,'sep_dt_articulos');
			if($eliminobie){
				foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_articulos");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1);
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->monart = formatoNumericoBd($detalle->monart,1);
					$this->daoDetalle->estincite = 'NI';
					$this->daoDetalle->canartorg = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
			}
			if($numero>0){
				foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dta_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->incluir()){
						break;
					}
				}
			}
        }
        else if($tipo=='S'){
        	$eliminosercar = $this->eliminar($codemp,$objson->numsol,'sep_dts_cargos');
        	$eliminoser = $this->eliminar($codemp,$objson->numsol,'sep_dt_servicio');
        	if($eliminoser){
        		foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_servicio");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->monser = formatoNumericoBd($detalle->monser,1);
					$this->daoDetalle->estincite = 'NI';
					$this->daoDetalle->canserorg = 0;
					$this->daoDetalle->orden = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}	
        	}
        	if($numero>0){
        		foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dts_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->incluir()){
						break;
					}
				}	
			}
        }
        else if($tipo=='O'){
        	$eliminoconcar = $this->eliminar($codemp,$objson->numsol,'sep_dtc_cargos');
        	$eliminocon = $this->eliminar($codemp,$objson->numsol,'sep_dt_concepto');
        	if($eliminocon){
	    	   	foreach ($arrDetalle as $detalle){
					$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_concepto");
					$this->daoDetalle->setData($detalle);
					$this->daoDetalle->codemp = $codemp;
					$this->daoDetalle->cancon = formatoNumericoBd($detalle->cancon,1);
					$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
					$this->daoDetalle->moncon = formatoNumericoBd($detalle->moncon,1);
					$this->daoDetalle->orden = 0;
					if(!$this->daoDetalle->incluir()){
						break;
					}
				}
        	}
        	if($numero>0){
        		foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dtc_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->incluir()){
						break;
					}
				}
			}
        }
		$estatus ="";
        $estatus = $this->validarCuentas($codemp,$objson->numsol,$operacion);

		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 
			$resultado = "|1";		
			if($estatus=='R')
			{
				$resultado .= "|".$estatus;
			}
		}
		else{
			$arrevento ['desevetra'] = $this->daoSolicitud->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$resultado = "|0";		
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoSolicitud);
		unset($this->daoDetalleCuenta);
		unset($this->daoDetalle);
		unset($this->daoDetalleCargo);
		unset($this->daoDetalleCueCar);
		unset($this->daoDetalleCueGas);
		unset($this->daoRegistroEvento);
    	return $resultado;
	}
	
	public function eliminarSolicitud($codemp,$objson,$arrevento){
		$resultado = 0;//variable que indica el resultado de la operacion
		$arrDetalle = $objson->detalleSep;
		$arrDetalleCargo = $objson->DetalleCargo;
		$numero = count($arrDetalleCargo);
		$arrDetalleCuenta = $objson->DetalleCuenta;
		$arrDetalleCueCar = $objson->DetalleCuentaCargos;
		$numcuecar = count($arrDetalleCueCar);
		

		//obteniendo las instacias de los dao's
		$this->daoSolicitud = FabricaDao::CrearDAO("N","sep_solicitud");

		//seteando la data e iniciando transaccion de base de datos
		$this->daoSolicitud->setData($objson);
		$this->daoSolicitud->codemp=$codemp;
		$this->daoSolicitud->codtipsol = substr($objson->codtipsol,0,2);
		$this->daoSolicitud->fecregsol = convertirFechaBd($objson->fecregsol);
		$this->daoSolicitud->feccieinv = '1900-01-01';
		DaoGenerico::iniciarTrans();
		
		foreach($arrDetalleCuenta as $detallecuenta){
			$this->daoDetalleCuenta = FabricaDao::CrearDAO("N","sep_cuentagasto");
			$this->daoDetalleCuenta->setData($detallecuenta);
			$this->daoDetalleCuenta->codemp = $codemp;
			$this->daoDetalleCuenta->monto = formatoNumericoBd($detallecuenta->monto,1);
			if(!$this->daoDetalleCuenta->eliminar()){
				break;
			}
		}
		
		if($numcuecar>0){
			foreach($arrDetalleCueCar as $detallecuecar){
				$sccuenta = '';
				$this->daoDetalleCueCar = FabricaDao::CrearDAO("N","sep_solicitudcargos");
				$this->daoDetalleCueCar->setData($detallecuecar);
				$this->daoDetalleCueCar->codemp = $codemp;
				$this->daoDetalleCueCar->monobjret = formatoNumericoBd($detallecuecar->monobjret,1);
				$this->daoDetalleCueCar->monret = formatoNumericoBd($detallecuecar->monret,1);
				$this->daoDetalleCueCar->monto = formatoNumericoBd($detallecuecar->monto,1);
				$sccuenta = $this->select_cuentacontable($codemp,$detallecuecar->codestpro1,$detallecuecar->codestpro2,$detallecuecar->codestpro3,
											 			 $detallecuecar->codestpro4,$detallecuecar->codestpro5,$detallecuecar->spg_cuenta,
											 			 $detallecuecar->estcla);
				$this->daoDetalleCueCar->sc_cuenta = $sccuenta;
				if(!$this->daoDetalleCueCar->eliminar()){
					break;
				}
			}
		}
		
		$tipo = substr($objson->codtipsol,2,1);
		if($tipo=='B'){
			if($numero>0){
				foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dta_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->eliminar()){
						break;
					}
				}
			}
       		foreach ($arrDetalle as $detalle){
				$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_articulos");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				$this->daoDetalle->canart = formatoNumericoBd($detalle->canart,1);
				$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
				$this->daoDetalle->monart = formatoNumericoBd($detalle->monart,1);
				$this->daoDetalle->estincite = 'NI';
				$this->daoDetalle->canartorg = 0;
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
        }
        else if($tipo=='S'){
        	if($numero>0){
				foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dts_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->eliminar()){
						break;
					}
				}
			}
        	foreach ($arrDetalle as $detalle){
				$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_servicio");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				$this->daoDetalle->canser = formatoNumericoBd($detalle->canser,1);
				$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
				$this->daoDetalle->monser = formatoNumericoBd($detalle->monser,1);
				$this->daoDetalle->estincite = 'NI';
				$this->daoDetalle->canserorg = 0;
				$this->daoDetalle->orden = 0;
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
        }
        else if($tipo=='O'){
        	if($numero>0){
				foreach ($arrDetalleCargo as $detallecargo){
					$this->daoDetalleCargo = FabricaDao::CrearDAO("N","sep_dtc_cargos");
					$this->daoDetalleCargo->setData($detallecargo);
					$this->daoDetalleCargo->codemp = $codemp;
					$this->daoDetalleCargo->monbasimp = formatoNumericoBd($detallecargo->monbasimp,1);
					$this->daoDetalleCargo->monimp = formatoNumericoBd($detallecargo->monimp,1);
					$this->daoDetalleCargo->monto = formatoNumericoBd($detallecargo->monto,1);
					if(!$this->daoDetalleCargo->eliminar()){
						break;
					}
				}
			}
        	foreach ($arrDetalle as $detalle){
				$this->daoDetalle = FabricaDao::CrearDAO("N","sep_dt_concepto");
				$this->daoDetalle->setData($detalle);
				$this->daoDetalle->codemp = $codemp;
				$this->daoDetalle->cancon = formatoNumericoBd($detalle->cancon,1);
				$this->daoDetalle->monpre = formatoNumericoBd($detalle->monpre,1);
				$this->daoDetalle->moncon = formatoNumericoBd($detalle->moncon,1);
				$this->daoDetalle->orden = 0;
				if(!$this->daoDetalle->eliminar()){
					break;
				}
			}
        }
        
        $this->daoSolicitud->eliminar();
		//insertando el registro y escribiendo en el log
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		//completando la transaccion retorna 1 si no hay errores
		if(DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else{
			$arrevento ['desevetra'] = $this->daoSolicitud->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		 
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoSolicitud);
		unset($this->daoDetalleCuenta);
		unset($this->daoDetalle);
		unset($this->daoDetalleCargo);
		unset($this->daoDetalleCueCar);
		unset($this->daoDetalleCueGas);
		unset($this->daoRegistroEvento);
    	return $resultado;
	}
	
	
}	
?>