<?php
/**
 * @author Neneskha Salas
 * @desc Interfaz del servicio de solicitudes, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface isolicitud {
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todas los servicios asociados a la unidad ejecutora
	 * @param string $codemp - codigo de empresa
	 * @param string $codusu - codigo de la unidad
	 * @param string $codigo - codigo
	 * @return string $denominacion - denominacion de la unidad
	 */ 
	public function buscarFuenteFinanciamiento($codemp, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla, $origen_catalogo);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todos los tipos de solicitud
	 * @param string $codemp - codigo de empresa
	 * @return resultset $data - arreglo con la informacion solicitada
	 */
	public function buscarTipoSolicitud($codemp);
		
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca el proximo codigo de la solicitud
	 * @param string $codemp - codigo de empresa
	 * @return string $numsol - numero de la proxima solicitud
	 */
	public function buscarCodigoSolicitud($codemp);
	
//	/**
//	 * @author Neneskha Salas
//	 * @desc Metodo que busca todas las solicitudes presupuestarias
//	 * @param resultset $data - arreglo con la informacion de todas las solicitudes
//	 */
//	public function buscarSolicitudes();
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca la ultima solicitud registrada
	 * @param string $numsol - numero de la ultima solictud registrada
	 */
	public function buscarUltimaSolicitud();
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todos los tipos de solicitud
	 * @param string $codemp - codigo de empresa
	 * @return resultset $data - arreglo con la informacion solicitada
	 */
	public function ValidarFecha($codemp);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todas los conceptos asociados a la unidad ejecutora
	 * @param string $codemp - codigo de empresa
	 * @param string $origenCat - oridgen del catalogo
	 * @param string $codconsep - codigo del concepto
	 * @param string $denconsep - denominacion del concepto
	 * @param string $codestpro1 - codigo de la estructura 1
	 * @param string $codestpro2 - codigo de la estructura 2
	 * @param string $codestpro3 - codigo de la estructura 3
	 * @param string $codestpro4 - codigo de la estructura 4 
	 * @param string $codestpro5 - codigo de la estructura 5
	 * @param string $estcla -  estatus
	 * @return $data - arreglo con la informacion de los conceptos
	 */
	public function buscarConceptos($codemp, $origenCat, $codconsep, $denconsep, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todas los bienes asociados a la unidad ejecutora
	 * @param string $codemp - codigo de empresa
	 * @param string $codart - codigo del articulo
	 * @param string $denart - denominacion del articulo
	 * @param string $codtipart - codigo del tipo de articulo
	 * @param string $codestpro1 - codigo de la estructura 1
	 * @param string $codestpro2 - codigo de la estructura 2
	 * @param string $codestpro3 - codigo de la estructura 3
	 * @param string $codestpro4 - codigo de la estructura 4 
	 * @param string $codestpro5 - codigo de la estructura 5
	 * @param string $estcla -  estatus
	 * @param string $denunimed -denominacion unidad de medida
	 */
	public function buscarBienes($codemp, $origenCat, $codart, $denart, $codtipart, $tipobien, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla, $denunimed);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todas los servicios asociados a la unidad ejecutora
	 * @param string $codemp - codigo de empresa
	 * @param string $codser - codigo del servicio
	 * @param string $denser - denominacion del servicio
	 * @param string $codtipart - codigo del tipo de articulo
	 * @param string $codestpro1 - codigo de la estructura 1
	 * @param string $codestpro2 - codigo de la estructura 2
	 * @param string $codestpro3 - codigo de la estructura 3
	 * @param string $codestpro4 - codigo de la estructura 4 
	 * @param string $codestpro5 - codigo de la estructura 5
	 * @param string $estcla -  estatus
	 */
	public function buscarServicios($codemp, $origenCat, $codser, $denser, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca el detalle de la unidad administrativa
	 * @param string $codemp - codigo de empresa
	 * @return resultset $data - arreglo con la informacion solicitada
	 */
	public function buscarDetalleUnidades($codemp);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todas las unidades ejecutoras existentes
	 * @param string $codemp - codigo de empresa
	 * @param string $codusu - codigo del usuario
	 * @param string $codigo - codigo de la unidad
	 * @param string $denominacion - denominacion de la unidad
	 * @return resultset $data - arreglo con la informacion de las unidades ejecutoras
	 */
	public function buscarUnidadEjecutora($codemp,$codusu,$codigo,$denominacion,$origen);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca los tipos de bienes de la solicitud
	 * @return resultset $data - arreglo con la informacion de los tipos de bienes
	 */
	public function buscarTipoBienes() ;
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los articulos de una sep
	 * @param string $numsol - Numero de solicitud
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarArticulos($codemp,$numsol);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los cargos relacionados a los articulos
	 * @param string $codart - Codigo de articulo
	 * @param string $codprouni - Estructura presupuestaria de la unidad ejecutora
	 * @param string $estcla - Estatus de clasificacion
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCargosArticulos($codart,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro4,$estcla);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los servicios de una sep
	 * @param string $numsol - Numero de solicitud
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarServicios($codemp,$numsol);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los cargos relacionados a los servicios
	 * @param string $codser - Codigo de articulo
	 * @param string $codprouni - Estructura presupuestaria de la unidad ejecutora
	 * @param string $estcla - Estatus de clasificacion
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCargosServicios($codser,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los conceptos de una sep
	 * @param string $numsol - Numero de solicitud
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarConceptos($codemp,$numsol);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los cargos relacionados a los conceptos
	 * @param string $codcon - Codigo de concepto
	 * @param string $codprouni - Estructura presupuestaria de la unidad ejecutora
	 * @param string $estcla - Estatus de clasificacion
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCargosConceptos($codcon,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$estcla);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca las cuentas  de una sep
	 * @param string $numsol - Numero de solicitud
	 * @param string $tabla - Tabla relacionada
	 * @param string $campo - Campo relacionado
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCuentas($codemp,$numsol);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca las cuentas relacionadas a los cargos de una sep
	 * @param string $numsol - Numero de solicitud
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCuentasCargo($codemp,$numsol);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca las solicitudes segun filtros
	 * @param $codemp - codigo de la empresa
	 * @param string $numsol - Numero de solicitud
	 * @param string $codtipsol - codigo del tipo de solictud
	 * @param string $concepto - concepto de la solicitud
	 * @param string $destino - tipo de destino (proveedor-beneficiario)
	 * @param string $fechadesd - rango de fecha desde
	 * @param string $fechahas - rango de fecha hasta
	 * @param string $coduniadm - codigo de la unidad administrativa
	 * @param string $tipo - si es bienes, servicios o conceptos
	 * @param string $codpro - codigo del proveedor
	 * @param string $cedbene - cedula del beneficiario
	 * @return resultset $data - arreglo con la informacion de las solicitudes
	 */ 
	public function buscarSolicitudes($codemp,$numsol,$codtipsol,$coduniadm,$fechadesd,$fechahas,$tipooperacion,$tipsepbie,
									  $concepto,$destino,$tipo,$codpro,$cedbene,$operacion,$origen_catalogo);
		
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca las cuentas presupuestarias segun filtros
	 * @param $codemp - codigo de la empresa
	 * @param string $tipo - si es bienes, servicios o conceptos
	 * @param string $spg_cuenta - cuenta presupuestaria
	 * @param string $codestpro1ue - nivel 1 
	 * @param string $codestpro1ue - nivel 2 
	 * @param string $codestpro1ue - nivel 3 
	 * @param string $codestpro1ue - nivel 4 
	 * @param string $codestpro1ue - nivel 5 
	 * @param string $estclaue - estatus de clasificacion 
	 * @return resultset $data - arreglo con la informacion de las cuentas presupuestarias
	 */
	public function buscarCuentasSpg($codemp,$tipo,$spg_cuenta,$codestpro1ue,$codestpro2ue,$codestpro3ue,$codestpro4ue,$codestpro5ue,$estclaue,$codfuefin);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que valida el origen del documento
	 * @param string $codtipsol - Codigo de tipo de solicitud
	 * @param string $tipodestino - Indica si es proveedor/beneficiario
	 * @param string $codprov - codigo de proveedor/beneficiario
	 * @param string $numdocori - numero de documento.
	 * @return boolean $valido - Si el registro existe
	 */	
	public function validarOrigen($codtipsol,$tipodestino,$codprov,$numdocori);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que guarda la solicitud 
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param Array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarSolicitud($codemp,$objson,$arrevento);
	
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que modifica la solicitud 
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param Array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarSolicitud($codemp,$objson,$arrevento);
											
	/**
	 *@author Ing. Maryoly Caceres
	 * @desc Metodo que elimina la solicitud 
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson
	 * @param Array $arrevento
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarSolicitud($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca los cargos de una sep
	 * @param string $numsol - Numero de solicitud
	 * @param string $tabla - Tabla relacionada
	 * @param string $campo - Campo relacionado
	 * @return resultset $data - arreglo con la informacion solicitada
	 */	
	public function cargarCargos($numsol,$tabla,$campo);	
	
/*FUNCIONES ELABORADAS POR LUIS ANIBAL LANG*/

//	/**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que verifica la existencia de una solicitud
//	 * @param string $numsol - Codigo de concepto
//	 * @return boolean $valido - Si la solicitud existe o no
//	 */	
//	public function buscarSolicitud($numsol);
	
//	 /**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que verifica la existencia de una solicitud
//	 * @param string $codestpro1 - Estructura presupuestaria nivel 1
//	 * @param string $codestpro2 - Estructura presupuestaria nivel 2
//	 * @param string $codestpro3 - Estructura presupuestaria nivel 3
//	 * @param string $codestpro4 - Estructura presupuestaria nivel 4
//	 * @param string $codestpro5 - Estructura presupuestaria nivel 5
//	 * @param string $spg_cuenta - Cuenta presupuestaria
//	 * @param string $estcla - Estatus de clasificacion
//	 * @return varchar $sc_cuenta - Cuenta contable asociada
//	 */	
//	public function buscarCuentaContable($codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$spg_cuenta,$estcla);
	
//	/**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que busca el estatus de cambio de imputacion
//	 * @return smallint $estmodpartsep - Estatus de camnio de imputacion
//	 */	
//	public  function validarCambioImputacion();
	
//	/**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que valida si una sep ha sido despachada
//	 * @param string $numsol - Numero de solicitud
//	 * @return boolean $valido - Si el registro existe en despacho
//	 */	
//	public function validarDespacho($numsol);
	
//	 /**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que verifica si existe la cuenta presupuestaria asociada a una unidad
//	 * @param string $coduniadm - Codigo de unidad ejecutora
//	 * @param string $spg_cuenta - cuenta presupuestaria
//	 * @return boolean $valido - Si el registro existe o no
//	 */	
//	public function buscarCuentaUnidad($coduniadm,$spg_cuenta);
	
//	 /**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que verifica que la solicitud a eliminar sera la ultima
//	 * @param string $numsol - Numero de solicitud
//	 * @return boolean $valido - Si el registro existe o no
//	 */	
//	public function validarSolicitudEliminar($numsol);
	
//	 /**
//	 * @author Ing. Luis Anibal Lang
//	 * @desc Metodo que busca la estructura central por defecto definida en el sistema
//	 * @param string $coduniadm - Codigo de unidad ejecutora
//	 * @param string $codestpro1 - Estructura presupuestaria nivel 1
//	 * @param string $codestpro2 - Estructura presupuestaria nivel 2
//	 * @param string $codestpro3 - Estructura presupuestaria nivel 3
//	 * @param string $codestpro4 - Estructura presupuestaria nivel 4
//	 * @param string $codestpro5 - Estructura presupuestaria nivel 5
//	 * @param string $estcla - Estatus de clasificacion
//	 * @return boolean $valido - Si el registro existe o no
//	 */	
//	public function cargarEstructuraCentral($coduniadm,$codestpro1,$codestpro2,$codestpro3,$codestpro4,$codestpro5,$escla);

}