<?php
/**
 * @author 
 * @desc Interfaz del servicio de aprobacion de solicitudes presupuestarias, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface iaprobacion
{		
	public function validarAprobacion($numsol,$estapro);

	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc Valida que la solicitud este en Emitida
	 * @param string $numsol - numero de solicitud
	 * @return boolean $existe - Si esta emitida o no
	 */	
	public function validarSolicitud($numsol);

	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc Modifica el estatus de aprobacion de la solicitud
	 * @param string $numsol - numero de solicitud
	 * @param string $estsol - estatus de la solicitud
	 * @param string $fecaprsep - fecha de aprobacion de la solicitud
	 * @param array $arrevento - arreglo de evento
	 * @return boolean $valido - Si se ejecuto correctamente o no
	 */	
	public function modificarSolicitud($numsol,$estsol,$fecaprsep,$arrevento);
}