<?php
/**
 * @author 
 * @desc Interfaz del servicio de anulacion de solicitudes presupuetarias, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface ianulacion {

	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc Valida que la solicitud este en Emitida
	 * @param string $numsol - numero de solicitud
	 * @param string $filtro - criterio de busqueda
	 * @return boolean $existe - Si esta emitida o no
	 */	
	public function validarEstatusSolicitud($numsol,$filtro);

	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc Valida que la solicitud este en Emitida
	 * @param string $numsol - numero de solicitud
	 * @param string $estatus - indica si hay disponibilidad.
	 * @return boolean $existe - Si esta emitida o no
	 */	
	public function validarCuentas($numsol);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Modifica la Solicitud
	 * @param string $numsol - numero de solicitud
	 * @param string $estsol - estatus de la solicitud.
	 * @param string $fecanusep - fecha de anulacion de la solicitud.
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return boolean $valido - Si modifico con exito o no
	 */	
	public function modificarSolicitud($numsol,$estsol,$fecanusep,$arrevento);

}