<?php
$dirsrv = dirname(__FILE__);
$dirsrv = str_replace("\\","/",$dirsrv);
$dirsrv = str_replace("/modelo/servicio/sep","",$dirsrv); 
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrv."/modelo/servicio/sep/sigesp_srv_sep_iaprobacion.php");
require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_comprobantespg.php');

/**
 * @author 
 * @desc clase que sirve a la pantalla de aprobacion de solicitudes presupuestarias, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioAprobacion implements iaprobacion {
	private $daoSolicitud;
	private $conexionBaseDatos;
	
	public function servicioAprobacion()
	{
		$this->daoSolicitud = null;
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
	}
	 
	public function validarAprobacion($numsol,$estapro){
		$existe=false;
		$cadenasql="SELECT numsol ".
				"   FROM sep_solicitud ".
				"   WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
				"     AND numsol='".$numsol."' ".
				"     AND estapro=".$estapro."";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$existe=true;
			}
		}
		return $existe;
	}

	public function validarSolicitud($numsol)
	{
		$existe=false;
		$cadenasql="SELECT numsol ".
				"   FROM sep_solicitud ".
				"   WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
				"     AND numsol='".$numsol."' ".
				"     AND estsol='E'";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$existe=true;
			}
		}
		return $existe;
	}

	public function modificarSolicitud($numsol,$estsol,$fecaprsep,$arrevento){
		if(validarFechaMes($fecaprsep)){
			if($this->validarCuentas($numsol)){
				$usuario=$_SESSION["la_logusr"];
				if($estsol==0){
					$fecaprsep="1900-01-01";
					$usuario="";
				}
				DaoGenerico::iniciarTrans();  		
				// OBTENGO LA SOLICITUD A APROBAR
				$criterio="codemp = '".$_SESSION['la_empresa']['codemp']."' AND numsol='".$numsol."' AND estsol='E'";
				$this->daoSolicitud = FabricaDao::CrearDAO('C','sep_solicitud','',$criterio);
				// VERIFICO QUE LA SOLICITUD EXISTA
				if($this->daoSolicitud->numsol==''){
					$this->mensaje .= 'ERROR -> No existe la solicitud N°'.$numsol.'';
					$this->valido = false;			
				}	
				else{
					$this->daoSolicitud->estapro=$estsol;
					$this->daoSolicitud->fecaprsep=$fecaprsep;
					$this->daoSolicitud->codaprusu=$usuario;
					$this->valido = $this->daoSolicitud->modificar();
					if(!$this->valido){
						$this->mensaje .= $this->daoSolicitud->ErrorMsg;
					}				
				}	
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->tipoevento=$this->valido; 
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				if($estsol==1){
					$desevetra ="Aprobo la Solicitud de Ejecucion <b>".$numsol."</b>.";
				}
				else{
					$desevetra ="Reverso la Aprobacion de la Solicitud de Ejecucion <b>".$numsol."</b>.";
				}
				$servicioEvento->desevetra=$desevetra;			
				if (DaoGenerico::completarTrans($this->valido)){
					$servicioEvento->incluirEvento();
				}
				else{
					$servicioEvento->desevetra=$this->mensaje;
					$servicioEvento->incluirEvento();
				}
				unset($servicioEvento);
			}
			return $this->valido;
		}
		else{
			$this->mensaje .= 'ERROR -> El Mes no esta abierto';
		}
	}  

	public function validarCuentas($numsol){
		$this->valido=true;
		$cadenasql="SELECT sep_cuentagasto.codestpro1, sep_cuentagasto.codestpro2, sep_cuentagasto.codestpro3,".
				" 	       sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5, sep_cuentagasto.estcla, ".
				"	       sep_cuentagasto.spg_cuenta, sep_cuentagasto.monto,sep_solicitud.fecregsol,sep_solicitud.codtipsol,".
				"		   (SELECT COUNT(codemp) ".
				"		    FROM spg_cuentas ".
				"		    WHERE spg_cuentas.codemp = sep_cuentagasto.codemp ".
				"		      AND spg_cuentas.codestpro1 = sep_cuentagasto.codestpro1 ".
				"		      AND spg_cuentas.codestpro2 = sep_cuentagasto.codestpro2 ".
				"		      AND spg_cuentas.codestpro3 = sep_cuentagasto.codestpro3 ".
				"		      AND spg_cuentas.codestpro4 = sep_cuentagasto.codestpro4 ".
				"		      AND spg_cuentas.codestpro5 = sep_cuentagasto.codestpro5 ".
				"		      AND spg_cuentas.estcla = sep_cuentagasto.estcla ".
				"		      AND spg_cuentas.spg_cuenta = sep_cuentagasto.spg_cuenta) AS existe ".		
				"   FROM sep_cuentagasto ".
				"   INNER JOIN sep_solicitud  ".
				"   ON sep_cuentagasto.codemp='".$_SESSION['la_empresa']['codemp']."' ".
				"   	AND sep_cuentagasto.numsol='".$numsol."'".
				"   	AND sep_cuentagasto.codemp=sep_solicitud.codemp".
				"   	AND sep_cuentagasto.numsol=sep_solicitud.numsol";
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			$estaprsep=$_SESSION["la_empresa"]["estaprsep"];
			while((!$dataSEP->EOF)&&($this->valido)){				
				$existe=$dataSEP->fields["existe"];
				$codestpro1=substr($dataSEP->fields["codestpro1"],(25-$_SESSION["la_empresa"]["loncodestpro1"]),$_SESSION["la_empresa"]["loncodestpro1"]);
				$codestpro2=substr($dataSEP->fields["codestpro2"],(25-$_SESSION["la_empresa"]["loncodestpro2"]),$_SESSION["la_empresa"]["loncodestpro2"]);
				$codestpro3=substr($dataSEP->fields["codestpro3"],(25-$_SESSION["la_empresa"]["loncodestpro3"]),$_SESSION["la_empresa"]["loncodestpro3"]);
				$codestpro4=substr($dataSEP->fields["codestpro4"],(25-$_SESSION["la_empresa"]["loncodestpro4"]),$_SESSION["la_empresa"]["loncodestpro4"]);
				$codestpro5=substr($dataSEP->fields["codestpro5"],(25-$_SESSION["la_empresa"]["loncodestpro5"]),$_SESSION["la_empresa"]["loncodestpro5"]);
				if($existe){
					$this->servicioComprobante = new ServicioComprobanteSPG();
					$arrdetallespg['codemp']     = $_SESSION['la_empresa']['codemp'];
					$arrdetallespg['codestpro1'] = $dataSEP->fields['codestpro1'];
					$arrdetallespg['codestpro2'] = $dataSEP->fields['codestpro2'];
					$arrdetallespg['codestpro3'] = $dataSEP->fields['codestpro3'];
					$arrdetallespg['codestpro4'] = $dataSEP->fields['codestpro4'];
					$arrdetallespg['codestpro5'] = $dataSEP->fields['codestpro5'];
					$arrdetallespg['estcla']     = $dataSEP->fields['estcla'];
					$arrdetallespg['spg_cuenta'] = $dataSEP->fields['spg_cuenta'];
					$this->servicioComprobante->setDaoDetalleSpg($arrdetallespg);
					$this->servicioComprobante->saldoSelect('ACTUAL');
					$disponibilidad =  (($this->servicioComprobante->asignado + $this->servicioComprobante->aumento) - 
									   ( $this->servicioComprobante->disminucion + $this->servicioComprobante->comprometido + 
									   $this->servicioComprobante->precomprometido));
					if(round($dataSEP->fields['monto'],2) > round($disponibilidad,2)){
						$auxmonto=number_format($dataSEP->fields["monto"],2,",",".");
						$auxdisponibilidad=number_format($disponibilidad,2,",",".");
						$this->mensaje .= 'No hay Disponibilidad en la cuenta '.$codestpro1.$codestpro2.$codestpro3.$codestpro4.
										   $codestpro5.'-'.$dataSEP->fields['estcla'].'-'.$dataSEP->fields['spg_cuenta'].
										   ' Disponible=['.$auxdisponibilidad.'] Cuenta=['.$auxmonto.']';
						if($estaprsep!='1'){
							$this->valido=false;
						}
					}
					elseif (round($dataSEP->fields['monto'],2) == round($li_disponibilidad,2)){
						$this->mensaje .= 'El saldo de la cuenta '.$codestpro1.$codestpro2.$codestpro3.$codestpro4.
											$codestpro5.'-'.$dataSEP->fields['estcla'].'-'.$dataSEP->fields['spg_cuenta'].' quedara en 0';
					}
				}
				else{
					$this->mensaje .= ' La cuenta '.$dataSEP->fields['spg_cuenta'].' No Existe en la Estructura '.$codestpro1.
										$codestpro2.$codestpro3.$codestpro4.$codestpro5.'-'.$dataSEP->fields['estcla'];
				}
				$dataSEP->MoveNext();
			}
		}
		return $this->valido;
	}
}
?>