<?php
$dirsrv = "";
$dirsrv = dirname(__FILE__);
$dirsrv = str_replace("\\","/",$dirsrv);
$dirsrv = str_replace("/modelo/servicio/sep","",$dirsrv); 
require_once ($dirsrv."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrv."/base/librerias/php/general/sigesp_lib_funciones.php");
require_once ($dirsrv."/modelo/servicio/sep/sigesp_srv_sep_ianulacion.php");
require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_comprobantespg.php');

/**
 * @author 
 * @desc clase que sirve a la pantalla de Anulacion de Solicitudes presupuetarias, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioAnulacion implements ianulacion
{
	private $daoSolicitud;
	private $conexionBaseDatos;
	
	public function servicioAnulacion()
	{
		$this->daoSolicitud = null;
		$this->conexionBaseDatos  = ConexionBaseDatos::getInstanciaConexion();
	}

	public function validarEstatusSolicitud($numsol,$filtro)
	{
		$existe=false;
		$cadenasql="SELECT numsol ".
				"   FROM sep_solicitud ".
				"   WHERE codemp='".$_SESSION['la_empresa']['codemp']."' ".
				"     AND numsol='".$numsol."' ".$filtro;
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if ($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if(!$dataSEP->EOF){
				$existe=true;
			}
		}
		return $existe;
	}
	
	function uf_calcular_disponible_por_rango($codemp,$as_codestpro1,$as_codestpro2,$as_codestpro3,
											  $as_codestpro4,$as_codestpro5,$as_spg_cuenta,$as_operacion){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
	    $lb_valido=true;
		$ldec_monto=0;
		$arreglo=array();
		$ld_fecha = convertirFechaBd($_SESSION["fechacomprobante"]);
		$ld_inicio = convertirFechaBd($_SESSION["la_empresa"]["periodo"]);	
		$ls_sql="SELECT COALESCE(SUM(monto),0) As monto ".
                "FROM spg_dt_cmp, spg_operaciones  ".
                "WHERE codemp='".$codemp."' ".
                "  AND spg_operaciones.".$as_operacion."=1 ".
				"  AND spg_dt_cmp.spg_cuenta = '".$as_spg_cuenta."' ".
				"  AND fecha >='".$ld_inicio."' AND fecha <='".$ld_fecha."' ".
				"  AND spg_dt_cmp.codestpro1='".$as_codestpro1."' ".
				"  AND spg_dt_cmp.codestpro2='".$as_codestpro2."' ".
			    "  AND spg_dt_cmp.codestpro3='".$as_codestpro3."' ".
				"  AND spg_dt_cmp.codestpro4='".$as_codestpro4."' ".
				"  AND spg_dt_cmp.codestpro5='".$as_codestpro5."' ".
				"  AND spg_dt_cmp.operacion=spg_operaciones.operacion ";
		$data = $this->conexionBaseDatos->Execute($ls_sql);
		if($data===false){   // error interno sql
           $this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
		   $this->valido = false;
		   $lb_valido = false;
		}
	    else{	
			if($rs_data->fields['monto']!=''){
				$ldec_monto = $rs_data->fields['monto'];
			}
	    }
	    $arreglo[0]["valido"]=$lb_valido;
	    $arreglo[0]["monto"] = $ldec_monto;
		return $arreglo;
	}
	function  uf_spg_saldo_select($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,
								  $ls_codestpro4,$ls_codestpro5,$ls_estcla,$ls_spg_cuenta){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$lb_valido = true;
		$arrDetalle = array();
		$ls_sql="SELECT status ".
				"FROM spg_cuentas ".
				"WHERE codemp='".$codemp."' ".
				"  AND codestpro1 = '".$ls_codestpro1."' ".
				"  AND codestpro2 = '".$ls_codestpro2."' ".
				"  AND codestpro3 = '".$ls_codestpro3."' ".
				"  AND codestpro4 = '".$ls_codestpro4."' ".
				"  AND codestpro5 = '".$ls_codestpro5."' ".
				"  AND spg_cuenta = '".$ls_spg_cuenta."'";
	    $rs_data = $this->conexionBaseDatos->Execute($ls_sql);
		if($rs_data->fields['status']==''){	
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			$lb_valido = false;
		}
		else{
			$estatus = $rs_data->fields['status'];	
			if($estatus == "C"){
				if($lb_valido){
					$ls_operacion="asignar";
					$adec_asignado=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_asignado = $arrDisponible[0]["monto"];												       
				}
				if($lb_valido){
					$ls_operacion="aumento";
					$adec_aumento=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	   	   $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_aumento = $arrDisponible[0]["monto"];
				}
				if($lb_valido){
					$ls_operacion="disminucion";
					$adec_disminucion=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_disminucion = $arrDisponible[0]["monto"];
				}
				if($lb_valido){
					$ls_operacion="precomprometer";
					$adec_precomprometido=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_precomprometido = $arrDisponible[0]["monto"];
				}
				if($lb_valido){
					$ls_operacion="comprometer";
					$adec_comprometido=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_comprometido = $arrDisponible[0]["monto"];
				}
				if($lb_valido){
					$ls_operacion="causar";
					$adec_causado=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_causado = $arrDisponible[0]["monto"];
				}
				if($lb_valido){
					$ls_operacion="pagar";
					$adec_pagado=0;
					$arrDisponible=$this->uf_calcular_disponible_por_rango($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
																	       $ls_spg_cuenta,$ls_operacion);
					$lb_valido = $arrDisponible[0]["valido"];
					$adec_pagado = $arrDisponible[0]["monto"];
				}
				unset($this->rs_data);
			}
			if($estatus == "S"){
				$ls_sql="SELECT status,asignado,aumento,disminucion,precomprometido,comprometido,causado,pagado ".
						"FROM spg_cuentas ".
						"WHERE codemp='".$codemp."' ".
						"  AND codestpro1 = '".$ls_codestpro1."' ".
						"  AND codestpro2 = '".$ls_codestpro2."' ".
						"  AND codestpro3 = '".$ls_codestpro3."' ".
						"  AND codestpro4 = '".$ls_codestpro4."' ".
						"  AND codestpro5 = '".$ls_codestpro5."' ".
						"  AND spg_cuenta = '".$ls_spg_cuenta."'";
				$data = $this->conexionBaseDatos->Execute($ls_sql);
				if($data===false){
					$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
					$lb_valido = false;
				}
				else{
					$arreglo = object_to_array($data);
					$total = count($arreglo);
					for($i=0; $i<$total; $i++){
						$arrDetalle[$i]["status"]=$arreglo[i]["status"];
						$arrDetalle[$i]["asignado"]=$arreglo[i]["asignado"];
						$arrDetalle[$i]["aumento"]=$arreglo[i]["aumento"];
						$arrDetalle[$i]["disminucion"]=$arreglo[i]["disminucion"];
						$arrDetalle[$i]["precomprometido"]=$arreglo[i]["precomprometido"];
						$arrDetalle[$i]["comprometido"]=$arreglo[i]["comprometido"];
						$arrDetalle[$i]["causado"]=$arreglo[i]["causado"];
						$arrDetalle[$i]["pagado"]=$arreglo[i]["pagado"];
					}
				}
			}
		}
		$arrDetalle[0]["valido"] = $lb_valido; 
		return $arrDetalle;
	}
	
	public function validarCuentas($numsol)
	{
		$this->valido=true;
		$arreglo = array();
		$arreglo[0]["existe"] = false;
		$disponibilidad=false;
		$cadenasql="SELECT sep_cuentagasto.codestpro1, sep_cuentagasto.codestpro2, sep_cuentagasto.codestpro3,".
				" 	       sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5, sep_cuentagasto.estcla, ".
				"	       sep_cuentagasto.spg_cuenta, sep_cuentagasto.monto,sep_solicitud.fecregsol,sep_solicitud.codtipsol,".
				"	       (SELECT (asignado-(comprometido+precomprometido)+aumento-disminucion) ".
				"		    FROM spg_cuentas ".
				"		    WHERE spg_cuentas.codemp = sep_cuentagasto.codemp ".
				"		  	  AND spg_cuentas.codestpro1 = sep_cuentagasto.codestpro1 ".
				"		  	  AND spg_cuentas.codestpro2 = sep_cuentagasto.codestpro2 ".
				"		      AND spg_cuentas.codestpro3 = sep_cuentagasto.codestpro3 ".
				"		  	  AND spg_cuentas.codestpro4 = sep_cuentagasto.codestpro4 ".
				"		      AND spg_cuentas.codestpro5 = sep_cuentagasto.codestpro5 ".
				"             AND spg_cuentas.estcla=sep_cuentagasto.estcla".
				"		      AND spg_cuentas.spg_cuenta = sep_cuentagasto.spg_cuenta) AS disponibilidad, ".
				"		   (SELECT COUNT(codemp) ".
				"		    FROM spg_cuentas ".
				"		    WHERE spg_cuentas.codemp = sep_cuentagasto.codemp ".
				"		      AND spg_cuentas.codestpro1 = sep_cuentagasto.codestpro1 ".
				"		      AND spg_cuentas.codestpro2 = sep_cuentagasto.codestpro2 ".
				"		      AND spg_cuentas.codestpro3 = sep_cuentagasto.codestpro3 ".
				"		      AND spg_cuentas.codestpro4 = sep_cuentagasto.codestpro4 ".
				"		      AND spg_cuentas.codestpro5 = sep_cuentagasto.codestpro5 ".
				"		      AND spg_cuentas.estcla = sep_cuentagasto.estcla ".
				"		      AND spg_cuentas.spg_cuenta = sep_cuentagasto.spg_cuenta) AS existe ".		
				"   FROM sep_cuentagasto ".
				"   INNER JOIN sep_solicitud  ".
				"   ON sep_cuentagasto.codemp='".$_SESSION['la_empresa']['codemp']."' ".
				"     AND sep_cuentagasto.numsol='".$numsol."'".
				"     AND sep_cuentagasto.codemp=sep_solicitud.codemp".
				"     AND sep_cuentagasto.numsol=sep_solicitud.numsol"; 
		$dataSEP = $this->conexionBaseDatos->Execute ( $cadenasql );
		if($dataSEP===false){
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			$arreglo = object_to_array($dataSEP);
			$total = count($arreglo);
			$i=0;
			$existe=true;
			while(($i<$total) || ($existe)){
				$ls_codestpro1=$arreglo[$i]["codestpro1"];
				$ls_codestpro2=$arreglo[$i]["codestpro2"];
				$ls_codestpro3=$arreglo[$i]["codestpro3"];
				$ls_codestpro4=$arreglo[$i]["codestpro4"];
				$ls_codestpro5=$arreglo[$i]["codestpro5"];
				$ls_estcla=$arreglo[$i]["estcla"];
				$ls_spg_cuenta=$arreglo[$i]["spg_cuenta"];
				$li_monto=$arreglo[$i]["monto"];
				$li_existe=$arreglo[$i]["existe"];
				if($li_existe!=0){
					$arreglo[0]["existe"] = true;
				}
				$arrDetalle = $this->uf_spg_saldo_select($codemp,$ls_codestpro1,$ls_codestpro2,$ls_codestpro3,
													     $ls_codestpro4,$ls_codestpro5,$ls_estcla,$ls_spg_cuenta);
			    if($arrDetalle[0]["valido"]){
			    	$status=$arrDetalle[0]["status"];
					$adec_asignado=$arrDetalle[0]["asignado"];
					$adec_aumento=$arrDetalle[0]["aumento"];
					$adec_disminucion=$arrDetalle[0]["disminucion"];
					$adec_precomprometido=$arrDetalle[0]["precomprometido"];
					$adec_comprometido=$arrDetalle[0]["comprometido"];
					$adec_causado=$arrDetalle[0]["causado"];
					$adec_pagado=$arrDetalle[0]["pagado"];
			    }		
				$li_disponibilidad=($adec_asignado-($adec_comprometido+$adec_precomprometido)+$adec_aumento-$adec_disminucion);
				if($li_existe>0){
					$li_monto=number_format($li_monto,2,",",".");
					$li_disponibilidad=number_format($li_disponibilidad,2,",",".");
					if($li_monto>$li_disponibilidad){
						$li_monto=number_format($li_monto,2,",",".");
						$li_disponibilidad=number_format($li_disponibilidad,2,",",".");
						if($as_operacion!='S'){
							$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
							$this->valido = false;
						}				
					}
				}
				else{
					$existe = false;
					$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				}
				if($existe){
					$arreglo[$i]["disponible"] = true;
					$existe = false;
				}
				else{
					$arreglo[$i]["disponible"] = false;
				}
				$i++;
			}
		}
		return $arreglo;
	}
	
	public function modificarSolicitud($numsol,$estsol,$fecanusep,$arrevento){
		
		$this->valido=validarFechaMes($fecanusep);
		$entro = false;
		if($this->valido){
			$arreglo = $this->validarCuentas($numsol);
			if($arreglo[0]["existe"]){
				$usuario=$_SESSION["la_logusr"];
				if($estsol==0){
					$fecanusep="1900-01-01";
					$usuario="";
				}
				DaoGenerico::iniciarTrans();  		
				// OBTENGO LA SOLICITUD A ANULAR
				$criterio="codemp = '".$_SESSION['la_empresa']['codemp']."' AND numsol='".$numsol."' ";
				$this->daoSolicitud = FabricaDao::CrearDAO('C','sep_solicitud','',$criterio);
				// VERIFICO QUE LA SOLICITUD EXISTA
				if($this->daoSolicitud->numsol==''){
					$this->mensaje .= 'ERROR -> No existe la solicitud N°'.$numsol.'';
					$this->valido = false;			
				}	
				else{
					if($estsol==0){
						$this->daoSolicitud->estapro=$estsol;
						$this->daoSolicitud->estsol='A';
						$this->daoSolicitud->fecanusep=$fecanusep;
						$this->daoSolicitud->codaprusu=$usuario;
						$this->valido = $this->daoSolicitud->modificar();
						if(!$this->valido){
							$this->mensaje .= $this->daoSolicitud->ErrorMsg;
						}
					}
					else{
						$total = count($arreglo);
						for($k=0;$k<$total;$k++){
							if(!$arreglo[$k]["disponible"]){
								$entro = true;
								$this->daoSolicitud->estsol='R';
							}	
						}
						if(!$entro){
							$this->daoSolicitud->estsol='E';
						}
						$this->valido = $this->daoSolicitud->modificar();
						if(!$this->valido){
							$this->mensaje .= $this->daoSolicitud->ErrorMsg;
						}
					}
									
				}	
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->tipoevento=$this->valido; 
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				if($estsol==1)
				{
					$desevetra =utf8_encode("Reverso la Anulacion de la Solicitud de Ejecucion <b>".$numsol."</b>.");
				}
				else
				{
					$desevetra =utf8_encode("Anulo la Solicitud de Ejecucion <b>".$numsol."</b>.");
				}
				$servicioEvento->desevetra=$desevetra;			
				if (DaoGenerico::completarTrans($this->valido)) 
				{
					$servicioEvento->incluirEvento();
				}
				else
				{
					$servicioEvento->desevetra=$this->mensaje;
					$servicioEvento->incluirEvento();
				}
				unset($servicioEvento);
			}
			return $this->valido;
		}
		else
		{
			$this->mensaje .= 'ERROR -> El Mes no esta abierto';
		}

	}  
	

	
}
		
	
?>