<?php
/**
 * @author Ing. Maryoly Caceres
 * @desc Interfaz del servicio cierre de ejercicio scf
 */
interface ICierreSCF
{

	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que guardar el comprobante contable de cierre
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarCierreEjercicio($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Maryoly Caceres
	 * @desc Metodo que elimina el comprobante contable de cierre
	 * @param string $codemp - codigo de empresa
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarCierreEjercicio($codemp,$objson,$arrevento);
	
}