<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/scf/sigesp_srv_scf_icierre.php");
require_once ($dirsrv."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrv."/modelo/servicio/mis/sigesp_srv_mis_comprobante.php");

class ServicioCierreSCF implements ICierreSCF {

	public  $mensaje; 
	public  $valido; 
	private $conexionBaseDatos; 
	private $daoCierre;
	
	public function ServicioCierreSCF() {
		$this->mensaje = '';
		$this->valido = true;
		$this->daoCierre = null;
		$this->conexionbd  = ConexionBaseDatos::getInstanciaConexion();
	}
	
	//Este método verifica si existe o no la cuenta contable y ademas retorna la denominacion 
	//y estatus de la cuenta
	public function existeCuenta($codemp,$sc_cuenta)
	{
		$this->valido=true;
		$arreglo=array();
		$cadenasql="SELECT sc_cuenta, status, denominacion ".
				"   FROM scg_cuentas ".
				"   WHERE codemp='".$codemp."' ".
				"     AND trim(sc_cuenta)='".trim($sc_cuenta)."' ";
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->existeCuenta ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				 $arreglo['sc_cuenta']=$resultado->fields["sc_cuenta"];
				 $arreglo['denominacion']=$resultado->fields["denominacion"];
				 $arreglo['status']=$resultado->fields['status'];
			}
			else
			{
				$this->mensaje .= " ERROR-> La cuenta Contable ".$sc_cuenta." no existe";
				$this->valido = false;
			}
		}		
		return $arreglo;
	}
	
	//Funcion que retorna el saldo de una cuenta
	function buscarSaldo($cuenta,$fecha)
	{
		$total_debe=0;
		$total_haber=0;
		$saldo=0; 
		$fecha_ini_cierre=$_SESSION['la_empresa']["periodo"];
		$fecha_ini_cierre=convertirFechaBd($fecha_ini_cierre);
		$anno_anterior = intval(substr($fecha_ini_cierre,0,4)-1);
		$fecha_fin_cierre= convertirFechaBd($fecha);
		$anno_actual   = substr($fecha_fin_cierre,0,4);
		$mes_cierre =substr($fecha_fin_cierre,5,2);
		$fecha_ini_cierre  = ultimoDiaMes($mes_cierre,$anno_anterior);
		$fecha_ini_cierre= convertirFechaBd($fecha_ini_cierre);
		// consula sql para movimientos del debe
		$cadenasql="SELECT SUM( monto ) As ntotal ".
			    "   FROM scg_dt_cmp".
			    "   WHERE codemp='".$_SESSION['la_empresa']["codemp"]."' ".
				"     AND sc_cuenta='".$cuenta."' ".
				"     AND fecha >='".$fecha_ini_cierre."' ".
				"     AND fecha <='".$fecha_fin_cierre."' ".
				"     AND debhab='D'";
		$data = $this->conexionbd->Execute($cadenasql);
		if($data===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->buscarSaldo ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$data->EOF)
			{
				if($data->fields["ntotal"]!=0){
					$total_debe=$data->fields["ntotal"];
				}
			}
		}
		unset($data);		
		// consula sql para movimientos del haber
		$cadenasql="SELECT SUM( monto ) As ntotal ".
			    "   FROM scg_dt_cmp ".
			    "   WHERE codemp='".$_SESSION['la_empresa']["codemp"]."' ".
				"     AND sc_cuenta='".$cuenta."' ".
				"     AND fecha >='".$fecha_ini_cierre."' ".
				"     AND fecha <='".$fecha_fin_cierre."' ".
				"     AND debhab='H'";
		$data = $this->conexionbd->Execute($cadenasql);
		if($data===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->buscarSaldo ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$data->EOF)
			{
				if($data->fields["ntotal"]!=0){
					$total_haber=$data->fields["ntotal"];
				}
			}
	    }
		$saldo=$total_debe - $total_haber;
		return $saldo;
	}
	
	//Funcion que retorna el saldo de una cuenta
	function buscarCuenta($cuenta,$fecha,$tipo_cierre)
	{
		$saldo=0;
		$cadenasql="SELECT sc_cuenta ".
				"   FROM scg_cuentas ".
				"   WHERE status = 'C' ".
				"     AND sc_cuenta LIKE '".trim($cuenta)."%'";
		$resultado = $this->conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->buscarCuenta ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if(!$resultado->EOF)
			{
				while(!$resultado->EOF)
				{
					$saldocuenta=0;
					$cuenta=$resultado->fields["sc_cuenta"];
					$saldocuenta=$this->buscarSaldo($cuenta,$fecha);
					$saldo=$saldo+$saldocuenta;
					$resultado->MoveNext();
				}
			}
		}
		return $saldo;
	} 
	
	//Funcion que busca las cuentas de gasto o de ingreso dependiendo de el tc
	function buscarCuentasGastoIngresoCosto($codemp,$tc)
	{
		$cadenasql="SELECT sc_cuenta ".
				"   FROM scg_cuentas ".
				"   WHERE codemp='".$codemp."' ".
				"     AND sc_cuenta LIKE '".$tc."' ".
				"     AND status='C'".
				"   ORDER BY sc_cuenta";
		$data = $this->conexionbd->Execute($cadenasql);
		if($data===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->buscarCuentasGastoIngresoCosto ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	} 
	
	//Método que busca los detalles contables mensual
	function buscarDetallesMensual($codemp,$procede,$arrcabecera,$tipo_cierre)
	{
		$arreglo=array();
		$i=1;
		$saldofinanciera=0;
		$saldofiscal=0;
		$cfinanciera=trim($_SESSION["la_empresa"]["c_financiera"]);
		$cfiscal=trim($_SESSION["la_empresa"]["c_fiscal"]);
		$saldofinanciera=$this->buscarCuenta($cfinanciera,$arrcabecera['fecha'],$tipo_cierre);
		$saldofiscal=$this->buscarCuenta($cfiscal,$arrcabecera['fecha'],$tipo_cierre);
		if($this->valido)
		{
			if($saldofinanciera!=0)
			{
				if(abs($saldofinanciera) != abs($saldofiscal))
				{
				 $this->mensaje.=" Los saldos de la Situaci&#243;n Financiera: ".number_format($saldofinanciera,2,',','.')." y Fiscal: ".number_format($saldofiscal,2,',','.')." no coinciden para realizar asiento de ajuste, verifique por favor ";
				 $this->valido=false;
				}
				if($this->valido)
				{
					$descripcion="AJUSTES DEL RESULTADO DEL TESORO AL ".$arrcabecera['fecha'];
					$debhab="D";
					if($saldofinanciera>=0)
					{
						$debhab="H";
					}
					$arreglo[$i]['codemp']=$arrcabecera['codemp'];
					$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
					$arreglo[$i]['procede']=$arrcabecera['procede'];
					$arreglo[$i]['codban']=$arrcabecera['codban'];
					$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
					$arreglo[$i]['fecha']=$arrcabecera['fecha'];
					$arreglo[$i]['descripcion']=$descripcion;
					$arreglo[$i]['orden']=$i;
					$arreglo[$i]['sc_cuenta']=$cfinanciera;
					$arreglo[$i]['procede_doc']=$procede;
					$arreglo[$i]['documento']=$arrcabecera['comprobante'];
					$arreglo[$i]['debhab']=$debhab;
					$arreglo[$i]['monto']=abs($saldofinanciera);
					$i++;
					$debhab="D";
					if($saldofiscal>=0)
					{
						$debhab="H";
					}
					$arreglo[$i]['codemp']=$arrcabecera['codemp'];
					$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
					$arreglo[$i]['procede']=$arrcabecera['procede'];
					$arreglo[$i]['codban']=$arrcabecera['codban'];
					$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
					$arreglo[$i]['fecha']=$arrcabecera['fecha'];
					$arreglo[$i]['descripcion']=$descripcion;
					$arreglo[$i]['orden']=$i;
					$arreglo[$i]['sc_cuenta']=$cfiscal;
					$arreglo[$i]['procede_doc']=$procede;
					$arreglo[$i]['documento']=$arrcabecera['comprobante'];
					$arreglo[$i]['debhab']=$debhab;
					$arreglo[$i]['monto']=abs($saldofiscal);
					$i++;
				}
			}
		}
		$saldoresultado=0;
		$saldoactivo=0;
		$saldopasivo=0;
		$cactivo=trim($_SESSION["la_empresa"]["activo_t"]);
		$cpasivo=trim($_SESSION["la_empresa"]["pasivo_t"]);
		$saldoactivo=$this->buscarCuenta($cactivo,$arrcabecera['fecha'],$tipo_cierre);
		$saldopasivo=$this->buscarCuenta($cpasivo,$arrcabecera['fecha'],$tipo_cierre);
		$saldoresultado=$saldoactivo+$saldopasivo;
		if($this->valido)
		{
			if($saldoresultado==0)
			{
				$this->mensaje.=" No hay informaci&#243;n para este mes. " ;
				$this->valido=false;
			}
			if($this->valido)
			{
				$descripcion="SITUACI&#243;n DEL TESORO AL ".$arrcabecera['fecha'];
				$debhab="H";
				if($saldoresultado>=0)
				{
					$debhab="D";
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cfiscal;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']=$arrcabecera['comprobante'];
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($saldoresultado);
				$i++;
				$debhab="D";
				if($saldoresultado>=0)
				{
					$debhab="H";
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cfinanciera;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']=$arrcabecera['comprobante'];
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($saldoresultado);
				$i++;
			}
		}
		return $arreglo;
	}
	
	//Método que busca los detalles contables anual
	function buscarDetallesAnual($codemp,$procede,$arrcabecera,$tipo_cierre)
	{
		$arreglo=array();
		$i=1;
		$saldo=0;
		$saldo_gasto=0;
		$saldo_ingreso=0;
		$year=intval(substr($_SESSION['la_empresa']["periodo"],0,4));
		$cresultado=trim($_SESSION["la_empresa"]["c_resultad"]);
		$cresultadoanterior=trim($_SESSION["la_empresa"]["c_resultan"]);
		$saldo=$this->buscarCuenta($cresultado,$arrcabecera['fecha'],$tipo_cierre);
		if($this->valido)
		{
			// CREAMOS TRASLADO DE RESULTADOS
			if($saldo!=0)
			{
				$descripcion="TRASLADO DE RESULTADOS";
				$documento="1";
				$debhab="D";
				if($saldo>0)
				{
					$debhab="H";
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cresultado;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']=fillComprobante($documento);
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($saldo);
				$i++;
				$descripcion="TRASLADO DE RESULTADOS ANTERIORES";
				$debhab="H";
				if($saldo>0)
				{
					$debhab="D";
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cresultadoanterior;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']=fillComprobante($documento);
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($saldo);
				$i++;
			}
		}
		if($this->valido)
		{
			// CIERRE DE LAS CUENTAS DE GASTOS
			$tc=trim($_SESSION['la_empresa']["gasto_f"])."%";
			$ctaejeprecie=trim($_SESSION["la_empresa"]["ctaejeprecie"]);
			$cuentaGasto=$this->buscarCuentasGastoIngresoCosto($codemp,$tc);
			$descripcion="CIERRE DEL GASTO EJERCICIO AÑO ".$year;
			if($this->valido && !$cuentaGasto->EOF)
			{
				while(!$cuentaGasto->EOF)
				{
					$saldo=0;	
					$cuenta = $cuentaGasto->fields['sc_cuenta'];
					$saldo=$this->buscarCuenta($cuenta,$fecha,$tipo_cierre);
					if($this->valido && saldo!=0)
					{
						$saldo_gasto = ($saldo_gasto + $saldo);
						$monto_actual = abs($saldo);
						if ($saldo!=0)
						{ 
							$debhab="D";
							if($saldo>0)
							{
								$debhab="H";
							}	
							$arreglo[$i]['codemp']=$arrcabecera['codemp'];
							$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
							$arreglo[$i]['procede']=$arrcabecera['procede'];
							$arreglo[$i]['codban']=$arrcabecera['codban'];
							$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
							$arreglo[$i]['fecha']=$arrcabecera['fecha'];
							$arreglo[$i]['descripcion']=$descripcion;
							$arreglo[$i]['orden']=$i;
							$arreglo[$i]['sc_cuenta']=$cuenta;
							$arreglo[$i]['procede_doc']=$procede;
							$arreglo[$i]['documento']='000000000000002';
							$arreglo[$i]['debhab']=$debhab;
							$arreglo[$i]['monto']=$monto_actual;
							$i++;
						}
					}
					$cuentaGasto->MoveNext();
				}
				if($this->valido)
				{
					if($saldo_gasto!=0)
					{
						$debhab="H";
						if($saldo_gasto>0)
						{
							$debhab="D";
						}
						$arreglo[$i]['codemp']=$arrcabecera['codemp'];
						$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
						$arreglo[$i]['procede']=$arrcabecera['procede'];
						$arreglo[$i]['codban']=$arrcabecera['codban'];
						$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
						$arreglo[$i]['fecha']=$arrcabecera['fecha'];
						$arreglo[$i]['descripcion']=$descripcion;
						$arreglo[$i]['orden']=$i;
						$arreglo[$i]['sc_cuenta']=$ctaejeprecie;
						$arreglo[$i]['procede_doc']=$procede;
						$arreglo[$i]['documento']='000000000000002';
						$arreglo[$i]['debhab']=$debhab;
						$arreglo[$i]['monto']=abs($saldo_gasto);
						$i++;
					}
				}
			}
		}
		if($this->valido)
		{
			// CIERRE DE LAS CUENTAS DE INGRESO
			$tc=trim($_SESSION['la_empresa']["ingreso_f"])."%";
			$cuentaIngreso=$this->buscarCuentasGastoIngresoCosto($codemp,$tc);
			$descripcion="CIERRE DEL INGRESO EJERCICIO AÑO ".$year;
			if(!$cuentaIngreso->EOF)
			{
				while(!$cuentaIngreso->EOF) 
				{   
					$cuenta=$cuentaIngreso->fields["sc_cuenta"];
					$saldo=0;	
					$saldo=$this->buscarCuenta($cuenta,$fecha,$tipo_cierre);
					if($this->valido && $saldo!=0)
					{
						$saldo_ingreso = ($saldo_ingreso + $saldo);  
						$monto_actual = abs($saldo);
						$debhab="D";
						if($saldo>0)
						{
							$debhab="H";
						}
						$arreglo[$i]['codemp']=$arrcabecera['codemp'];
						$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
						$arreglo[$i]['procede']=$arrcabecera['procede'];
						$arreglo[$i]['codban']=$arrcabecera['codban'];
						$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
						$arreglo[$i]['fecha']=$arrcabecera['fecha'];
						$arreglo[$i]['descripcion']=$descripcion;
						$arreglo[$i]['orden']=$i;
						$arreglo[$i]['sc_cuenta']=$cuenta;
						$arreglo[$i]['procede_doc']=$procede;
						$arreglo[$i]['documento']='000000000000003';
						$arreglo[$i]['debhab']=$debhab;
						$arreglo[$i]['monto']=$monto_actual;
						$i++;
					}
					$cuentaIngreso->MoveNext();			
				} //fin del while
				if($this->valido)
				{
					if($saldo_ingreso!=0)
					{
						$debhab="H";
						if($saldo_ingreso>0)
						{
							$debhab="D";
						}
						$arreglo[$i]['codemp']=$arrcabecera['codemp'];
						$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
						$arreglo[$i]['procede']=$arrcabecera['procede'];
						$arreglo[$i]['codban']=$arrcabecera['codban'];
						$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
						$arreglo[$i]['fecha']=$arrcabecera['fecha'];
						$arreglo[$i]['descripcion']=$descripcion;
						$arreglo[$i]['orden']=$i;
						$arreglo[$i]['sc_cuenta']=$ctaejeprecie;
						$arreglo[$i]['procede_doc']=$procede;
						$arreglo[$i]['documento']='000000000000002';
						$arreglo[$i]['debhab']=$debhab;
						$arreglo[$i]['monto']=abs($saldo_ingreso);
						$i++;
					}
				}
			}
		}
		if($this->valido)
		{
			$resultado = 0;
		 	$resultado = abs($saldo_ingreso) - abs($saldo_gasto);
			if($resultado!=0)
			{
				$formcont=$_SESSION["la_empresa"]["formcont"];
				$cuenta=str_pad($formcont,15,"0",RIGHT);
				$descripcion="DEFICIT AL CIERRE AÑO ".$year;
				$debhab="H";
				if($resultado>0)
				{
					$debhab="D";
					$descripcion="SUPERAVIT AL CIERRE AÑO ".$year;
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cuenta;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']='000000000000004';
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($resultado);
				$i++;
				if($debhab=="D")
				{
					$debhab = "H";
				}
				else if($debhab=="H")
				{
				  	$debhab = "D";
				}
				$arreglo[$i]['codemp']=$arrcabecera['codemp'];
				$arreglo[$i]['comprobante']=$arrcabecera['comprobante'];
				$arreglo[$i]['procede']=$arrcabecera['procede'];
				$arreglo[$i]['codban']=$arrcabecera['codban'];
				$arreglo[$i]['ctaban']=$arrcabecera['ctaban'];
				$arreglo[$i]['fecha']=$arrcabecera['fecha'];
				$arreglo[$i]['descripcion']=$descripcion;
				$arreglo[$i]['orden']=$i;
				$arreglo[$i]['sc_cuenta']=$cresultado;
				$arreglo[$i]['procede_doc']=$procede;
				$arreglo[$i]['documento']='000000000000004';
				$arreglo[$i]['debhab']=$debhab;
				$arreglo[$i]['monto']=abs($resultado);
				$i++;
			}
		}
		return $arreglo;
	}
	
	//Este metodo llena un arreglo con los detalles contables del comprobante
	function buscarDetalles($codemp,$procede,$arrcabecera,$tipo_cierre)
	{
		$arrDetalleContables=array();
		switch ($tipo_cierre){
			case "M":
				$arrDetalleContables=$this->buscarDetallesMensual($codemp,$procede,$arrcabecera,$tipo_cierre);
			break;
			case "A":
				$arrDetalleContables=$this->buscarDetallesAnual($codemp,$procede,$arrcabecera,$tipo_cierre);
			break;
		}
		return $arrDetalleContables;
	}

	//Este método obtiene el tipo de Destino, el proveedor y beneficiario del comprobante
	function verificarComprobante($codemp,$procedencia,$comprobante,$fecha,$codban,$ctaban)
	{
		$existe=false;
		$arreglo=array();
		$newfec=convertirFechaBd($fecha);
		$cadenasql="SELECT tipo_destino, ced_bene, cod_pro ".
				"   FROM sigesp_cmp ".
				"   WHERE codemp='".$codemp."' ".
				"     AND procede='".$procedencia."' ".
				"     AND comprobante='".$comprobante."'".
				"     AND fecha='".$newfec."'".
			    "     AND codban='".$codban."'".
			    "     AND ctaban='".$ctaban."'";
		$data = $this->conexionbd->Execute($cadenasql);
		if($data===false)
		{
			$this->mensaje .= ' CLASE->SCF MÉTODO->verificarComprobante ERROR->'.$this->conexionbd->ErrorMsg();
			$this->valido = false;
		}
		else  
		{ 
			if(!$data->EOF) 
			{ 
				$existe=true;
				$arreglo['tipo_destino']=$data->fields["tipo_destino"];
				$arreglo['ced_bene']=$data->fields["ced_bene"];
				$arreglo['cod_pro']=$data->fields["cod_pro"];
			} 
		}
		$arreglo['existe']=$existe;
		return $arreglo;
	} 

	public function guardarCierreEjercicio($codemp,$objson,$arrevento)
	{
      	$year=0;  
		$comprobante="";
		$descripcion="";
		$fecha="";
		$arrcabecera=array();
		$arrdetallescg=array();
		$year=intval(substr($_SESSION['la_empresa']["periodo"],0,4));
		$ctaresultadod=$_SESSION['la_empresa']["c_resultad"];
		$ctaresultadon=$_SESSION['la_empresa']["c_resultan"];
		DaoGenerico::iniciarTrans();
		if($objson->tipo_cierre=='A'){
			if($_SESSION['la_empresa']['estciespg']==0){
				$this->mensaje.=' No puede Ejecutar el Cierre Contable. Debe Procesar el Cierre Presupuestario de Gasto. Contacte al Administrador del Sistema !!!';
				$this->valido=false;
			}
			if($this->valido){
				if($_SESSION['la_empresa']['estciespi']==0){
					$this->mensaje.=' No puede Ejecutar el Cierre Contable. Debe Procesar el Cierre Presupuestario de Ingreso. Contacte al Administrador del Sistema !!!';
					$this->valido=false;
				}
			}
			if($this->valido){
				// VERIFICAMOS QUE EL COMPROBANTE DE CIERRE MENSUAL DE DICIEMBRE EXISTA
				$mesant = "12";
				$comprobante_ant="CIERREMES".$mesant.$year;
				$fecha_ant=ultimoDiaMes($mesant,$year);
				$arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante_ant,$fecha_ant,$objson->codban,$objson->ctaban);
				if(!$arreglo['existe']){
					$this->mensaje.=" El Comprobante de Cierre Mensual para el mes de ".obtenerNombreMes($mesant)." no existe, debe cerrar dicho mes antes de proceder al cierre anual, verifique por favor ";
		  			$this->valido=false;
				}
				unset($arreglo);
				if($this->valido){
					$comprobante=fillComprobante("CIERRE-".$year);
					$fecha=ultimoDiaMes("12",$year);
					$descripcion="CIERRE DEL EJERCICIO";
					// VERIFICAMOS QUE EL COMPROBANTE NO EXISTA 
					$arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante,$fecha,$objson->codban,$objson->ctaban);
					if($arreglo['existe']){
						$this->mensaje.=" El Comprobante de Cierre del Ejercicio ".$year." ya existe, no lo puede volver a procesar ";
			  			$this->valido=false;
					}
				}
				if($this->valido){
					// VERIFICAMOS QUE ESTÉN DEFINIDAS LAS CUENTAS DE RESULTADOS Y RESULTADOS ANTERIOR
					if(($ctaresultadod==null)||(trim($ctaresultadod)==""))
					{
						$this->mensaje.="No se definio la cuenta de resultado !!!";
						$this->valido=false;
					}		
					if(($ctaresultadon==null)||(trim($ctaresultadon)==""))
					{
						$this->mensaje.="No se definio la cuenta de resultado anterior !!!";
						$this->valido=false;
					}
				}
				// VERIFICAMOS QUE ESTÉN DEFINIDAS LAS CUENTAS DE GASTOS E INGRESOS
				if($this->valido)
				{
					$cgasto=trim($_SESSION['la_empresa']["gasto_f"]);
					$cingreso=trim($_SESSION["la_empresa"]["ingreso_f"]);
					if(($cgasto=="")||($cingreso==""))
					{
						$this->mensaje.="No se han definido las Cuentas de Gasto e Ingreso.";
						$this->valido=false;
					}
				}
				// VERIFICAMOS QUE ESTÉ DEFINIDA LA CUENTA DE EJECUCIoN DEL PRESUPUESTO
				if($this->valido)
				{
					$ctaejeprecie=trim($_SESSION["la_empresa"]["ctaejeprecie"]);
					if($ctaejeprecie=="")
					{
						$this->mensaje.="No se ha definido la cuenta de Ejecuci&#243;n del Presupuesto, verifique por favor";
						$this->valido=false;
					}
				}
			}
		}
		if($objson->tipo_cierre=='M'){
			$comprobante="CIERREMES".$objson->mes.$year;
			$fecha=ultimoDiaMes($objson->mes,$year);
			$descripcion="CIERRE MENSUAL AL ".$fecha;
			if($objson->mes!="01")
			{
				 $mesant = intval($objson->mes)-1;
				 $mesant = str_pad($mesant,2,"0",STR_PAD_LEFT);
				 $comprobante_ant="CIERREMES".$mesant.$year;
				 $fecha_ant=ultimoDiaMes($mesant,$year);
				 $arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante_ant,$fecha_ant,$objson->codban,$objson->ctaban);
				 if(!$arreglo['existe'])
				 {
				 	$this->mensaje.=" El Comprobante de Cierre para el mes de ".obtenerNombreMes($mesant)." no existe, debe cerrar dicho mes antes de cerrar ".obtenerNombreMes($objson->mes).", verifique por favor ";
					$this->valido=false;
				 }
			}
			// VERIFICAMOS QUE EL COMPROBANTE NO EXISTA
			unset($arreglo);
			$arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante,$fecha,$objson->codban,$objson->ctaban);
			if($arreglo['existe']){
				$this->mensaje.=" El Comprobante de Cierre para el mes ".obtenerNombreMes($objson->mes)." ya existe, no lo puede volver a procesar ";
	  			$this->valido=false;
			}
			// VERIFICAMOS QUE ESTÉN DEFINIDAS LAS CUENTAS DE FINANCIERA Y FISCAL
			if($this->valido)
			{
				$cfinanciera=trim($_SESSION["la_empresa"]["c_financiera"]);
				$cfiscal=trim($_SESSION["la_empresa"]["c_fiscal"]);
				if($cfinanciera=="" || $cfiscal=="")
				{
					$this->mensaje.=" No se han definido las Cuentas Financiera y Fiscal de la Situaci&#243;n del Tesoro. ";
					$this->valido=false;
				}
			}
			// VERIFICAMOS QUE ESTÉN DEFINIDAS LAS CUENTAS DE ACTIVO Y PASIVO DE TESORO
			if($this->valido)
			{
				$cactivo=trim($_SESSION["la_empresa"]["activo_t"]);
				$cpasivo=trim($_SESSION["la_empresa"]["pasivo_t"]);
				$saldoactivo=0;
				$saldopasivo=0;
				if(($cactivo=="")||($cpasivo==""))
				{
					$this->mensaje.=" No se han definido las Cuentas de Activo y Pasivo. ";
					$this->valido=false;
				}
			}
		}
		if($this->valido)
		{
			$fecha=convertirFechaBd($fecha);
			if($this->valido){
				//CREANDO LA CABECERA DEL COMPROBANTE
				$arrcabecera['codemp'] = $codemp;
				$arrcabecera['procede'] = $objson->procede;
				$arrcabecera['comprobante'] = fillComprobante($comprobante);
				$arrcabecera['codban'] = $objson->codban;
				$arrcabecera['ctaban'] = $objson->ctaban;
				$arrcabecera['fecha'] = $fecha;
				$arrcabecera['descripcion'] = $descripcion;
				$arrcabecera['tipo_comp'] = 1;
				$arrcabecera['tipo_destino'] = $objson->tipo_destino;
				$arrcabecera['cod_pro'] = $objson->cod_pro;
				$arrcabecera['ced_bene'] = $objson->ced_bene;
				$arrcabecera['numpolcon'] = 0;
				$arrcabecera['esttrfcmp'] = 0;
				$arrcabecera['estrenfon'] = 0;
				$arrcabecera['codfuefin'] = $objson->confuefin;
				$arrcabecera['codusu'] = $_SESSION['la_logusr'];
				$arrdetallescg=$this->buscarDetalles($codemp,$objson->procede,$arrcabecera,$objson->tipo_cierre);
				if($this->valido){
					$total=count($arrdetallescg);
					$monto=0;
					for($i=1;$i<=$total;$i++)
					{
						if($arrdetallescg[$i]['debhab']=='D'){
							$monto_scg=$arrdetallescg[$i]['monto'];
							$monto=$monto+$monto_scg;
						}
					}
					$arrcabecera['total'] = number_format($monto,2,'.','');
					$serviciocomprobante = new ServicioComprobante();
					$this->valido = $serviciocomprobante->guardarComprobante($arrcabecera,null,$arrdetallescg,null,$arrevento);
					$this->mensaje .= $serviciocomprobante->mensaje;
					unset($serviciocomprobante);
				}
				if($this->valido && $objson->tipo_cierre='A'){
					$criterio=" codemp = '".$codemp."' ";
					$this->daoCierre = FabricaDao::CrearDAO('C','sigesp_empresa','',$criterio);
					$this->daoCierre->estciescg='1';
					$this->valido = $this->daoCierre->modificar();
					if(!$this->valido)
					{
						$this->mensaje .= $this->daoCierre->ErrorMsg;
					}
				}	
	
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
		
				//completando la transaccion retorna 1 si no hay errores
				if(DaoGenerico::completarTrans($this->valido)) {
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
					$this->mensaje.=' -> Registro guardado con exito'; 		
				}
				else{
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
					$this->valido=false;
				}
				 
				//liberando variables y retornando el resultado de la operacion
				unset($this->daoRegistroEvento);
			}
		}
		return $this->valido;
	}
	
	public function eliminarCierreEjercicio($codemp,$objson,$arrevento)
	{
		$i=0;
		$monto=0;
		$arrcabecera = array();
		$arregloSCG = array();
		$year=intval(substr($_SESSION['la_empresa']["periodo"],0,4));
		$fecha = convertirFechaBd($objson->fecha);
		DaoGenerico::iniciarTrans();
		
		if($objson->mes!="12" && $objson->mes!="--")
		{
			 $mesdes = intval($objson->mes)+1;
			 $mesdes = str_pad($mesdes,2,"0",STR_PAD_LEFT);
			 $comprobante_ant="CIERREMES".$mesdes.$year;
			 $fecha_des=ultimoDiaMes($mesdes,$year);
			 $arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante_ant,$fecha_des,$objson->codban,$objson->ctaban);
			 if($arreglo['existe'])
			 {
			 	$this->mensaje.=" El Comprobante de Cierre para el mes de ".obtenerNombreMes($mesdes)." existe, debe ser eliminado antes de eliminar el Comprobante de Cierre para el mes de ".obtenerNombreMes($objson->mes).", verifique por favor ";
				$this->valido=false;
			 }
		}
		if($objson->mes=="12")
		{
			$comprobante=fillComprobante("CIERRE-".$year);
			$fecha=ultimoDiaMes("12",$year);
			$descripcion="CIERRE DEL EJERCICIO";
			$arreglo=$this->verificarComprobante($codemp,$objson->procede,$comprobante,$fecha,$objson->codban,$objson->ctaban);
			 if($arreglo['existe'])
			 {
			 	$this->mensaje.=" El Comprobante de Cierre Anual ".$comprobante." existe, debe ser eliminado antes de eliminar el Comprobante de Cierre para el mes de ".obtenerNombreMes($objson->mes).", verifique por favor ";
				$this->valido=false;
			 }
		}
		if($this->valido){
			$arrcabecera['codemp'] = $codemp;
			$arrcabecera['procede'] = $objson->procede;
			$arrcabecera['comprobante'] = $objson->comprobante;
			$arrcabecera['codban'] = $objson->codban;
			$arrcabecera['ctaban'] = $objson->ctaban;
			$arrcabecera['fecha'] = $objson->fecha;
			$arrcabecera['descripcion'] = $objson->descripcion;
			$arrcabecera['tipo_comp'] = 1;
			$arrcabecera['tipo_destino'] = $objson->tipo_destino;
			$arrcabecera['cod_pro'] = $objson->cod_pro;
			$arrcabecera['ced_bene'] = $objson->ced_bene;
			$arrcabecera['numpolcon'] = 0;
			$arrcabecera['esttrfcmp'] = 0;
			$arrcabecera['estrenfon'] = 0;
			$arrcabecera['codfuefin'] = $objson->confuefin;
			$arrcabecera['codusu'] = $_SESSION['la_logusr'];
			$arrcabecera['total'] = number_format(0,2,'.','');
			$serviciocomprobante = new ServicioComprobante();
			$this->valido = $serviciocomprobante->eliminarComprobante($arrcabecera,$arrevento);
			$this->mensaje .= $serviciocomprobante->mensaje;
			unset($serviciocomprobante);
			if($this->valido && $objson->tipo_cierre=='A')
			{
				$criterio=" codemp='".$codemp."' ";
				$this->daoCierre = FabricaDao::CrearDAO('C','sigesp_empresa','',$criterio);
				$this->daoCierre->estciescg='0';
				$this->valido = $this->daoCierre->modificar();
				if(!$this->valido)
				{
					$this->mensaje .= $this->daoCierre->ErrorMsg;
				}
			}
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				$this->mensaje.=' -> Registro eliminado exitosamente'; 		
			}
			else{
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}
}
?>