<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_iprocesar_no_contabilizables.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioDocumento implements iprocesar_no_contabilizables 
{
	private $daoDocumentos;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioDocumento() 
	{
		$this->daoDocumentos = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
	}
		
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function cargarDatos($codemp, $as_accion, $as_numdoc, $ad_fecmov, $as_codope, $as_codban, $as_ctaban)
	{
		$ls_sqlaux = "";
  	  	$lb_valido  = true;
	  
		if ($as_codope=='-')
		{
		   $as_codope='';
		}
		if (!empty($ad_fecmov))
		{
		   $ld_fecmov = convertirFechaBd($ad_fecmov);
		   $ls_sqlaux = " AND scb_movbco.fecmov = '".$ld_fecmov."'";
		}
		if ($as_accion=='P')
		{
		   $ls_estmov = 'L';
		}
		elseif($as_accion=='R')
		{
		   $ls_estmov = 'P';
		}

		$cadenasql = " 	SELECT	scb_movbco.codemp, scb_movbco.numdoc, scb_movbco.codban, scb_banco.nomban, scb_movbco.ctaban, ".
				     " 			scb_ctabanco.dencta, scb_movbco.codope, scb_movbco.fecmov, scb_movbco.nomproben, ".
				     " 			scb_movbco.tipo_destino, scb_movbco.cod_pro, scb_movbco.ced_bene, scb_movbco.conmov, scb_movbco.monto ".
				     " 	FROM scb_movbco, scb_banco, scb_ctabanco ".
				     " 	WHERE scb_movbco.codemp = '".$codemp."' ".
				     " 	AND scb_movbco.numdoc like '%".$as_numdoc."%' ".
				     " 	AND scb_movbco.codban like '%".$as_codban."%' ".
				     " 	AND scb_movbco.ctaban like '%".$as_ctaban."%' ".
				     " 	AND scb_movbco.codope like '%".$as_codope."%' ".
				     " 	AND scb_movbco.estmov = '".$ls_estmov."' ". 
				     " 	AND scb_movbco.estbpd = 'D' ".
				     " 	AND scb_movbco.procede='SCBBCH' $ls_sqlaux ".
				     " 	AND scb_movbco.codemp=scb_banco.codemp ".
				     " 	AND scb_movbco.codban=scb_banco.codban ".
				     " 	AND scb_movbco.codemp=scb_ctabanco.codemp ".
				     " 	AND scb_movbco.codban=scb_ctabanco.codban ".
				     " 	AND scb_movbco.ctaban=scb_ctabanco.ctaban ".
				     " 	AND scb_ctabanco.codemp=scb_banco.codemp ".
				     " 	AND scb_ctabanco.codban=scb_banco.codban ".
				     " 	ORDER BY scb_movbco.numdoc ASC";
		//	echo $cadenasql;
		//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		return $resultado;		
	}
		
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function guardarDatos($as_accion, $as_numdoc, $as_codban, $as_ctaban, $as_codope)
	{
		$resultado = 0;
		$ls_nuest = '';
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"];
	    $ls_codusu   = $_SESSION["la_logusr"];
		
		//Creacion del Dao con la tabla y campos a insertar.
		$this->daoProcesar=FabricaDao::CrearDAO("C","scb_movbco");
		$this->daoProcesar->codemp       = $ls_codemp;
		$this->daoProcesar->codusu       = $ls_codusu;
		$this->daoProcesar->numdoc		 = $as_numdoc;
		$this->daoProcesar->codban		 = $as_codban;
		$this->daoProcesar->ctaban		 = $as_ctaban;
		$this->daoProcesar->codope    	 = $as_codope;
		if ($as_accion == 'P')
		{
			$ls_nueest = 'P';
			$ls_estmov = 'L';
			$this->daoProcesar->estmov  = 'L';
		}
		elseif ($as_accion == 'R')
		{
			$ls_nueest = 'L';
			$ls_estmov = 'P';
			$this->daoProcesar->estmov = 'P';
		}
		//print($ls_estmov);
		//break;
		 //Iniciar transaccion
		 DaoGenerico::iniciarTrans();
		
		//Insertamos la programacion de pago
	    $resultado = $this->duplicar_movimiento_bancario($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov, $ls_nueest);
	    if ($resultado)
	    {
			$resultado = $this->duplicar_fuente_financiamiento($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov, $ls_nueest);
	    }
	    if ($resultado)
	    {
			$this->delete_all_movimientos($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov);
	    }

		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if (DaoGenerico::completarTrans()) 
		{
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}  
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProcesar);	
		return $resultado;	
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function duplicar_movimiento_bancario($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov, $ls_nueest)
	{
	  $cadenasql = " INSERT INTO scb_movbco (codemp, codusu, codban, ctaban, numdoc, codope, fecmov, conmov, codconmov, cod_pro, ".
	  			   " ced_bene, nomproben, monto, monobjret, monret, chevau, estmov, estmovint, estcobing, esttra, estbpd, estcon, ".
				   " feccon, estreglib, tipo_destino, fecha, procede, codfuefin) ".
				   "		(SELECT codemp, codusu, codban, ctaban, numdoc, codope, fecmov, conmov, codconmov, cod_pro, ".
				   "		 ced_bene, nomproben, monto, monobjret, monret, chevau,'".$ls_nueest."', estmovint, estcobing, ".
				   "		 esttra, estbpd, estcon, feccon, estreglib, tipo_destino, fecha, procede, codfuefin ".
				   "		 FROM scb_movbco ".
				   "		 WHERE codemp='".$ls_codemp."' ".
				   "		 AND numdoc='".$as_numdoc."' ".
				   "		 AND codban='".$as_codban."' ".
				   "		 AND ctaban='".$as_ctaban."' ".
				   "		 AND codope='".$as_codope."' ".
				   "		 AND estmov='".$ls_estmov."')";  
	  //echo ($cadenasql);
	  //break;								 
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute ( $cadenasql );
	  if ($resultado===false)
	  {
	  		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	  }
	  return $resultado;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function duplicar_fuente_financiamiento($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov, $ls_nueest)
	{
	  $cadenasql = " INSERT INTO scb_movbco_fuefinanciamiento (codemp, codban, ctaban, numdoc, codope, estmov, codfuefin) ".
				   " 		(SELECT codemp, codban, ctaban, numdoc, codope, '".$ls_nueest."', codfuefin ".
				   "	 	FROM scb_movbco_fuefinanciamiento ".
				   "	 	WHERE codemp='".$ls_codemp."' ".
				   "	 	AND numdoc='".$as_numdoc."' ".
				   "	 	AND codban='".$as_codban."' ".
				   "	 	AND ctaban='".$as_ctaban."' ".
				   "	 	AND codope='".$as_codope."' ".
				   "	 	AND estmov='".$ls_estmov."')";
	  //echo ($cadenasql);
	  //break;								 
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute ( $cadenasql );
	  if ($resultado===false)
	  {
		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	  }
	  return $resultado;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function delete_all_movimientos($ls_codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $ls_estmov)
	{
	  $cadenasql = " DELETE FROM scb_movbco_fuefinanciamiento ".
				   " WHERE codemp='".$ls_codemp."' ".
				   " AND numdoc='".$as_numdoc."' ".
				   " AND codban='".$as_codban."' ".
				   " AND ctaban='".$as_ctaban."' ".
				   " AND codope='".$as_codope."' ".
				   " AND estmov='".$ls_estmov."'";
	  //echo ($cadenasql);
	  //break;								 
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute ( $cadenasql );
	  if ($resultado===false)
	  {
		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	  }
	  else
	  {
	  	$cadenasql = " DELETE FROM scb_movbco ".
				  	 " WHERE codemp='".$ls_codemp."' ".
				  	 " AND numdoc='".$as_numdoc."' ".
				  	 " AND codban='".$as_codban."' ".
				  	 " AND ctaban='".$as_ctaban."' ".
				  	 " AND codope='".$as_codope."' ".
				  	 " AND estmov='".$ls_estmov."'";
	  	//echo ($cadenasql);								 
	  	$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  	$resultado = $conexionbd->Execute ( $cadenasql );
	  	if ($resultado===false)
	  	{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
	  }
	  return $resultado;
	}
	
}
?>