<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_formula.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_iorden_pago_directo_cp.php");
require_once ($dirsrvscb.'/modelo/servicio/scb/sigesp_srv_scb_movimientos_scb.php');
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioOrdenPago implements iorden_pago_directo_cp 
{
	private $daoOrdenPago;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioOrdenPago() 
	{
		$this->daoOrdenPago = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
	//	$this->conexionBaseDatos->debug=true;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarUnidadesAdministradoras($codemp)
	{		
		$ls_straux = "";
		$ls_coduniadm = "";
		$ls_denuniadm = "";
		
		$cadenasql = " 	SELECT coduac, denuac, tipuac, resuac ".
					 "  FROM spg_ministerio_ua ".
					 "  WHERE codemp='".$codemp."' ".
			     	 "	AND coduac like '%".$ls_coduniadm."%' ". 
			 	 	 " 	AND denuac like '%".$ls_denuniadm."%'" ;
		//echo $cadenasql;
		//break;			 
					 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		return $resultado;
	}	
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarProyectos($codemp, $loncodestpro1, $as_coduac, $as_tipuac)
	{
	  	$arrProyectos = array();
		$ls_sqlaux = "";
		$ls_denestcla = "";
		 
		if ($as_tipuac == 'C')
		{
			$ls_sqlaux = "AND spg_ministerio_ua.coduac='".$as_coduac."'";
		}
		
		$cadenasql = "	SELECT 	spg_ep1.codestpro1 as codestpro1, spg_ep1.denestpro1 as denestpro1, spg_ep1.estcla, ".
					 "			spg_ministerio_ua.coduac as coduniadm, spg_ministerio_ua.denuac as denuniadm ".
			    	 "	FROM spg_ep1, spg_ministerio_ua ".
			   		 "	WHERE spg_ep1.codemp='".$codemp."' ". 
				 	 "	AND spg_ep1.codestpro1 like '%".$ls_codestpro1."%' ".
				  	 "	AND spg_ep1.denestpro1 like '%".$ls_denestpro1."%' ".
					 "	".$ls_sqlaux." ".
				 	 "	AND spg_ep1.codemp=spg_ministerio_ua.codemp ".
				 	 "	AND spg_ep1.codestpro1<>'-------------------------' ".
			   		 "	ORDER BY spg_ep1.codestpro1 ASC";   
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			$j=0;
			while((!$resultado->EOF))
			{
	//	V1	//	$ls_codestpro1 = trim(substr($row["codestpro1"],-$li_loncodestpro1));
				$ls_codestpro1 = trim(substr($resultado->fields["codestpro1"], - $loncodestpro1));
				$ls_denestpro1 = $resultado->fields["denestpro1"];
				$ls_estcla = $resultado->fields["estcla"];
			   	$ls_coduniadm = $resultado->fields["coduniadm"];
			   	$ls_denuniadm = $resultado->fields["denuniadm"];
				$ls_uniadm = $ls_coduniadm.'-'.$ls_denuniadm;
								
				$arrProyectos[$j]['codestpro1'] = $ls_codestpro1;
				$arrProyectos[$j]['denestpro1'] = $ls_denestpro1;
				$arrProyectos[$j]['estcla'] = $ls_estcla;
		//		$arrProyectos[$j]['coduniadm'] = $ls_coduniadm;
		//		$arrProyectos[$j]['denuniadm'] = $ls_denuniadm;
				$arrProyectos[$j]['uniadm'] = $ls_uniadm;
		//		print($arrProyectos[$j]);
		//		break;
				$j++;
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $arrProyectos;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarBancosOrigen($codemp, $as_codban, $as_denban)
	{
	  	$arrBancos = array();
		 		
	 	$cadenasql = "	SELECT scb_banco.codban, scb_banco.nomban, scb_ctabanco.ctaban, scb_ctabanco.dencta, scb_ctabanco.sc_cuenta ". 
			      	 "	FROM scb_banco, scb_ctabanco ".
			   	  	 "	WHERE scb_banco.codemp='".$codemp."' ". 
			     	 "	AND scb_banco.esttesnac=1 ".
			 	 	 "	AND scb_banco.codban like '%".$as_codban."%' ". 
			     	 "	AND scb_banco.nomban like '%".$as_denban."%' ".
				 	 "	AND scb_banco.codemp=scb_ctabanco.codemp ".
				 	 "	AND scb_banco.codban=scb_ctabanco.codban ".
		  	   	 	 "	ORDER BY scb_banco.codban ASC";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			$j=0;
			while((!$resultado->EOF))
			{
				$ls_codban = $resultado->fields["codban"];
				$ls_nomban = $resultado->fields["nomban"];
				$ls_scgcta = trim($resultado->fields["sc_cuenta"]);
			   	$ls_codctaban = $resultado->fields["ctaban"];
			   	$ls_denctaban = $resultado->fields["dencta"];
								
				$arrBancos[$j]['codban'] = $ls_codban;
				$arrBancos[$j]['nomban'] = $ls_nomban;
				$arrBancos[$j]['sc_cuenta'] = $ls_scgcta;
				$arrBancos[$j]['ctaban'] = $ls_codctaban;
				$arrBancos[$j]['dencta'] = $ls_denctaban;
				$j++;
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $arrBancos;
	}
	
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarCompromisos($codemp, $as_modalidad, $as_extserext, $as_numdoc, $as_fecmov, $as_coduac, $as_denuac, $as_tipuac,
									  $as_proyecto, $as_nombproy, $as_codbanori, $as_denbamori, $as_ctaban, $as_dencta, $as_prov_bene, 
									  $as_codproben, $as_nomproben, $as_codbanco, $as_nombanco, $as_codcuenta, $as_dencuenta,
									  $as_sc_cuenta, $as_codope, $as_codafe, $as_conordpag, $as_nocont, $as_codmov, $as_monto,
									  $as_monobjret, $as_monret, $as_tipdocres, $as_numdocres, $as_fecordpag, $as_tipregres,
									  $as_codfuefin, $as_denfuefin, $as_codorigen, $as_formapago, $as_mediopago, $as_numcontrol,
									  $as_codban, $as_nomban, $as_nomcob, $as_rifcob, $as_ctacob, $as_procede, $as_codtipdoc)
	{
		$arrResultadoGrid = array();
		$datos = array();
		$arreglo = array();
		
		$as_fecmov = convertirFechaBd($as_fecmov);
		
		if($as_prov_bene == 'P')	
		{
		  $ls_codpro = $as_codproben;
		  $ls_cedbene = '----------';
		}
		else
		{
		  $ls_codpro = '----------';
		  $ls_cedbene = $as_codproben;
		}
		
		$arreglo = $this->uf_load_comprobantes_positivos($as_prov_bene, $ls_codpro, $ls_cedbene, $as_fecmov);
		$valido = $arreglo[0];
		$mensaje = $arreglo[1];
		$total = $arreglo[2];
		$datos = $arreglo[3];
	//	print_r($datos);
	//	break;
		if($valido)
		{
			if($total > 0)
			{
				for ($i=0;$i<=$total;$i++)
				{
					$ls_procedetemp = $datos[$i]['procedencia'];
					$ls_comprobantetemp = $datos[$i]['comprobante'];
					$ld_total = $datos[$i]['total'];
					$ls_descripcion = $datos[$i]['descripcion'];
					$ls_fechatemp = $datos[$i]['fecha']; 
															
					$ajustes = $this->uf_load_monto_ajustes($ls_comprobantetemp, $ls_procedetemp, $as_prov_bene, $ls_codpro, $ls_cedbene);//Buscamos montos ajustados, en caso de que los tenga, devolvemos la sumatoria.
					if(empty($ajustes))
					{
						$ld_monto_ajuste = 0;
					}
					else
					{
						$ld_monto_ajuste = $ajustes;
					}
					
					$causado = $this->uf_load_monto_causados($ls_comprobantetemp, $ls_procedetemp, $as_prov_bene, $ls_codpro, $ls_cedbene);//Buscamos montos causados, en caso de que los tenga, devolvemos la sumatoria. 
					if(empty($causado))
					{
						$ld_monto_causado = 0;
					}
					else
					{
						$ld_monto_causado = $causado;   
					}
							
					$anulados = $this->uf_load_monto_anulados($ls_comprobantetemp, $ls_procedetemp, $as_prov_bene, $ls_codpro, $ls_cedbene);//Buscamos montos anulados, en caso de que los tenga, devolvemos la sumatoria.
					if(empty($anulados))
					{
						$ld_monto_anulado = 0;
					}
					else
					{
						$ld_monto_anulado = $anulados;
					}
								
					$recepcion = $this->uf_load_monto_recepciones($ls_comprobantetemp, $ls_procedetemp);//Buscamos montos presupuestarios asociados a la recepcion de documento, en caso de que los tenga, devolvemos la sumatoria.
					if(empty($recepcion))
					{
						$ld_monto_recepcion = 0;
					}
					else
					{	
						$ld_monto_recepcion = $recepcion;
					}
									
					$ldec_monto_op = $this->uf_load_monto_ordenespago_directa($ls_comprobantetemp, $ls_procedetemp);
					$otroscreditos = $this->uf_load_monto_cargos($ls_comprobantetemp, $ls_procedetemp);
					if(empty($otroscreditos))
					{
						$ld_monto_otroscreditos = 0;
					}
					else
					{
						$ld_monto_otroscreditos = $otroscreditos;
					}
									   	
					$ld_disponible = ($ld_total + $ld_monto_ajuste) - $ld_monto_causado + $ld_monto_anulado - $ld_monto_recepcion - $ld_monto_otroscreditos - $ldec_monto_op;
				//	print $ld_disponible;
				//	break;
					if($ld_disponible > 0)
					{
						$ld_monto_solpago = 0;
						$ld_acum_solpago = 0;
						$ld_acum_solpago = $this->uf_load_acumulado_solicitudes($ls_comprobantetemp, $as_codtipdoc, $ls_codpro, $ls_cedbene);//Buscamos el acumulado en Solicitudes de Pago para la Recepcion de Documento.
						
						if(!empty($ld_acum_solpago))
						{
							$ld_monto_solpago = $ld_acum_solpago;
						}
						
						if($ld_total == $ld_monto_solpago)//Verificar que no existan solicitudes de pago con el monto igual a la RD.
						{
							$valido = false;
						}
						else
						{
							$valido = true;
						}
											
						if ($valido)
						{
							$arrResultadoGrid[$i]['procedencia'] = $ls_procedetemp;
							$arrResultadoGrid[$i]['comprobante'] = $ls_comprobantetemp;
							$arrResultadoGrid[$i]['total'] = number_format($ld_disponible,2,",",".");
							$arrResultadoGrid[$i]['descripcion'] = $ls_descripcion;
							$arrResultadoGrid[$i]['fecha'] = $ls_fechatemp;
						}
						
					}
				}
			}
			else
			{
				$mensaje .= 'No existen compromisos asociados a este Proveedor/Beneficiario !!!';
				$valido = false;
			}
		}	
		return $arrResultadoGrid;
	}
			
		
	public function uf_load_comprobantes_positivos($ls_prov_bene, $as_codpro, $as_cedbene, $ls_fecmov)
	{
		$arrComprobantes = array();
		$arrResultado = array();
		$ls_codcompromete = "CS";
		
		$ls_fecmov = convertirFechaBd($ls_fecmov);
		
		$cadenasql = "	SELECT DISTINCT sigesp_cmp.procede as procedencia, sigesp_cmp.comprobante as comprobante, ".
		 			 "					sigesp_cmp.fecha as fecha, sigesp_cmp.descripcion as descripcion, sigesp_cmp.total as total ".
				 	 "	FROM	sigesp_cmp, spg_dt_cmp ".
				 	 "	WHERE (sigesp_cmp.procede = spg_dt_cmp.procede 
					 	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante 
						AND sigesp_cmp.fecha = spg_dt_cmp.fecha) ". 
					 "	AND sigesp_cmp.tipo_destino = '".$ls_prov_bene."' ".
				 	 " 	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".
				 	 " 	AND	sigesp_cmp.ced_bene = '".$as_cedbene."' ".         
					 "	AND spg_dt_cmp.operacion = '".$ls_codcompromete."' ".
				 	 "	AND	sigesp_cmp.fecha <= '".$ls_fecmov."' ".      
					 "	AND spg_dt_cmp.monto > 0 ".            
				 	 " 	ORDER BY sigesp_cmp.comprobante ASC";
	//	echo $cadenasql;
	//	break;			 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$ls_procedetemp = $resultado->fields["procedencia"];
				$ls_comprobantetemp = $resultado->fields["comprobante"];
				$ld_total = $resultado->fields["total"];
			   	$ls_descripcion = $resultado->fields["descripcion"];
			   	$ls_fechatemp = $resultado->fields["fecha"];
								
				$arrComprobantes[$j]['procedencia'] = $ls_procedetemp;
				$arrComprobantes[$j]['comprobante'] = $ls_comprobantetemp;
				$arrComprobantes[$j]['total'] = $ld_total;
				$arrComprobantes[$j]['descripcion'] = $ls_descripcion;
				$arrComprobantes[$j]['fecha'] = $ls_fechatemp;
				$j++;
				$resultado->MoveNext();
			}
			unset($conexionbd);
			unset($resultado);
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $mensaje;
		$arrResultado[2] = $j;
		$arrResultado[3] = $arrComprobantes;
		return $arrResultado;
	}
	
	public function uf_load_monto_ajustes($as_comprobante, $as_procedencia, $ls_prov_bene, $as_codpro, $as_cedbene)
	{
		$arrMontos = array();
		$ls_codcompromete = "CS";
		$monto = 0;
		
		$cadenasql = "	SELECT SUM(spg_dt_cmp.monto) AS Monto ".
					 " 	FROM spg_dt_cmp, sigesp_cmp ".
					 " 	WHERE sigesp_cmp.procede=spg_dt_cmp.procede ".                
					 "	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ".       
					 "	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ".                    
					 "	AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ".
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".    
					 "	AND spg_dt_cmp.operacion = '".$ls_codcompromete."' ".
					 "	AND sigesp_cmp.tipo_destino = '".$ls_prov_bene."' ".
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".          
					 "	AND sigesp_cmp.ced_bene = '".$as_cedbene."' ".        
					 "	AND (spg_dt_cmp.monto < 0)";
		//print $ls_sql."<br>";		
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}	
		
	public function uf_load_monto_causados($as_comprobante, $as_procedencia, $ls_prov_bene, $as_codpro, $as_cedbene)
	{
		$arrMontos = array();
		$ls_operacion1 = 'CG';
		$ls_operacion2 = 'CP';
		$monto = 0;
		
		$cadenasql = "	SELECT  SUM(spg_dt_cmp.monto) AS Monto ".
					 "	FROM    spg_dt_cmp, sigesp_cmp ".
					 "	WHERE   sigesp_cmp.Procede = spg_dt_cmp.Procede ".             
					 "	AND sigesp_cmp.Comprobante = spg_dt_cmp.Comprobante ".       
					 "	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ".                 
					 "	AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ".
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".
					 "	AND spg_dt_cmp.operacion = '".$ls_operacion1."' OR spg_dt_cmp.operacion='".$ls_operacion2."' ".  
					 "	AND sigesp_cmp.tipo_destino = '".$ls_prov_bene."' ".
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".        
					 "	AND sigesp_cmp.ced_bene = '".$as_cedbene."' ";
					 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
	
	public function uf_load_monto_anulados($as_comprobante, $as_procedencia, $ls_prov_bene, $as_codpro, $as_cedbene) 
	{
		$arrMontos = array();
		$ls_operacion1='CG';
		$ls_operacion2='CP';
		$gestor=$_SESSION["ls_gestor"];
		   
		if ($gestor=="MYSQL")
		{
			$ls_str_1 = "CONCAT(spg_dt_cmp.codestpro1,spg_dt_cmp.codestpro2,spg_dt_cmp.codestpro3,spg_dt_cmp.codestpro4,spg_dt_cmp.codestpro5, ".
						  "        spg_dt_cmp.spg_cuenta,spg_dt_cmp.procede,spg_dt_cmp.comprobante) ";
			$ls_str_2 = "CONCAT(spg_dt_cmp.codestpro1,spg_dt_cmp.codestpro2,spg_dt_cmp.codestpro3,spg_dt_cmp.codestpro4,spg_dt_cmp.codestpro5,spg_dt_cmp.spg_cuenta,".
						  "spg_dt_cmp.procede_doc,spg_dt_cmp.documento) ";
		}
		else
		{
			$ls_str_1=" spg_dt_cmp.codestpro1||spg_dt_cmp.codestpro2||spg_dt_cmp.codestpro3||spg_dt_cmp.codestpro4||spg_dt_cmp.codestpro5||spg_dt_cmp.spg_cuenta||spg_dt_cmp.procede||spg_dt_cmp.comprobante ";
			$ls_str_2=" spg_dt_cmp.codestpro1||spg_dt_cmp.codestpro2||spg_dt_cmp.codestpro3||spg_dt_cmp.codestpro4||spg_dt_cmp.codestpro5||spg_dt_cmp.spg_cuenta||spg_dt_cmp.procede_doc||spg_dt_cmp.documento ";		  
		}
		
		$cadenasql = "	SELECT 	SUM(spg_dt_cmp.monto) AS Monto ".
				   	 "	FROM 	sigesp_cmp, spg_dt_cmp ".
				   	 "	WHERE 	sigesp_cmp.tipo_destino = '".$ls_prov_bene."' ". 
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".         
					 "	AND	sigesp_cmp.ced_bene = '".$as_cedbene."' ".         
					 "	AND sigesp_cmp.procede = spg_dt_cmp.procede ".
				   	 "  AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ".        
					 "	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ".
				   	 "  AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ".  
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".
				   	 "  AND (spg_dt_cmp.operacion = '".$ls_operacion1."' OR spg_dt_cmp.operacion = '".$ls_operacion2."') ".
				   	 "  AND	".$ls_str_1." IN (SELECT ".$ls_str_2." ".
				   	 "	        			FROM  sigesp_cmp, spg_dt_cmp ".
				   	 "            			WHERE sigesp_cmp.tipo_destino = '".$ls_prov_bene."' ". 
					 "						AND sigesp_cmp.cod_pro = '".$as_codpro."' ".
				   	 "                  	AND sigesp_cmp.ced_bene = '".$as_cedbene."' ".
				   	 "                  	AND sigesp_cmp.procede = spg_dt_cmp.procede ".
				   	 "                  	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ".
				   	 "                  	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ".
				   	 "                  	AND(spg_dt_cmp.operacion = '".$ls_operacion1."' OR spg_dt_cmp.operacion = '".$ls_operacion2."')) ";
					 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
	
	public function uf_load_monto_recepciones($as_comprobante, $as_procedencia)
	{
		$arrMontos = array();
		$ls_estatus='R';
		
		$cadenasql = "	SELECT SUM(cxp_rd_spg.monto) AS Monto ".
					 "	FROM   cxp_rd_spg, cxp_rd ".
					 "	WHERE  cxp_rd.cod_pro = cxp_rd_spg.cod_pro ".              
					 "	AND cxp_rd.ced_bene = cxp_rd_spg.ced_bene ".
					 "  AND cxp_rd.codtipdoc = cxp_rd_spg.codtipdoc ".           
					 "	AND cxp_rd.numrecdoc = cxp_rd_spg.numrecdoc ".
					 "  AND cxp_rd_spg.procede_doc = '".$as_procedencia."' ". 
					 "	AND cxp_rd_spg.numdoccom = '".$as_comprobante."' ".
					 "	AND cxp_rd.estprodoc = '".$ls_estatus."'";
				
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
	
	public function uf_load_monto_ordenespago_directa($as_comprobante, $as_procedencia)
	{
		$arrMontos = array();
		$monto = 0;
		
		$cadenasql = "	SELECT SUM(scb_movbco_spgop.monto) as Monto ".
				 	 "	FROM scb_movbco_spgop, scb_movbco ".
				 	 "	WHERE scb_movbco_spgop.codemp = scb_movbco.codemp ".
					 "	AND scb_movbco_spgop.numdoc = scb_movbco.numdoc ".
					 "	AND scb_movbco_spgop.codope = scb_movbco.codope ".
					 "	AND scb_movbco_spgop.codban = scb_movbco.codban ".
					 "	AND scb_movbco_spgop.ctaban = scb_movbco.ctaban ".
				 	 "	AND	scb_movbco_spgop.procede_doc = '".$as_procedencia."' ".
					 "	AND scb_movbco_spgop.documento = '".$as_comprobante."' ";
		
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
	
	public function uf_load_monto_cargos($as_comprobante, $as_procedencia)
	{
		$arrMontos = array();
		$ls_estatus='R';	//Recibido...
		$monto=0;
		
		$cadenasql = "	SELECT SUM(cxp_rd_cargos.MonRet) AS Monto ".
				  	 "	FROM cxp_rd_cargos, cxp_rd ".
				  	 "	WHERE (cxp_rd.numrecdoc = cxp_rd_cargos.numrecdoc ". 
					 "	AND cxp_rd.codtipdoc = cxp_rd_cargos.codtipdoc ".
				  	 "  AND cxp_rd.cod_pro = cxp_rd_cargos.cod_pro ".     
					 "	AND cxp_rd.ced_bene = cxp_rd_cargos.ced_bene) ".
				  	 "  AND (cxp_rd_cargos.procede_doc = '".$as_procedencia."' ".
					 "	AND cxp_rd_cargos.numdoccom = '".$as_comprobante."') ".
				  	 "  AND (cxp_rd.estprodoc = '".$ls_estatus."') ";
				
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Monto"];
				$arrMontos[$j]['Monto'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
	
	public function uf_load_acumulado_solicitudes($as_numrecdoc, $ls_codtipdoc, $as_codpro, $as_cedbene)
	{
		$arrMontos = array();
	  	$monto = 0;
		
	  	$cadenasql = "	SELECT SUM(cxp_dt_solicitudes.monto) AS Solicitado ".
			  		 " 	FROM cxp_rd, cxp_dt_solicitudes ".
			  		 " 	WHERE cxp_rd.numrecdoc = '".$as_numrecdoc."' ".
					 "	AND cxp_rd.codtipdoc = '".$ls_codtipdoc."' ".
			  		 " 	AND cxp_rd.cod_pro = '".$as_codpro."' ".     
					 "  AND cxp_rd.ced_bene = '".$as_cedbene."' ".
			  		 " 	AND cxp_rd.numrecdoc = cxp_dt_solicitudes.numrecdoc ".      
					 " 	AND cxp_rd.codtipdoc = cxp_dt_solicitudes.codtipdoc";
					  
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$monto = $resultado->fields["Solicitado"];
				$arrMontos[$j]['Solicitado'] = $monto;
				$j++;
				$resultado->MoveNext();
			}
		}
		return $monto;
	}
		
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function aceptarCompromisos($codemp, $ls_comprobante, $ls_procede, $ls_feccomp, $ls_prov_bene, $ls_codproben, $ls_fecmov,
									   $ls_codtipdoc, $ls_numdoc, $ls_sc_cuenta)
	{
		$arrResultado = array();
		$datos = array();
		$arreglo = array();
		$resultado = array();
		$ajuste = array(); 
		$causado = array(); $anulado = array(); $montord = array(); $rdcargos = array(); $cargos = array();
		$ld_montopro = 0;
	 	$ld_suma = 0;
	 	$ls_monto = 0; $ld_ajuste = 0; $ld_causado = 0; $ld_anulado = 0; $ld_montord = 0; $ld_rdcargos = 0; $ld_cargos = 0;
	 	$ld_montodebe = 0;
		
		if($ls_prov_bene == 'P')	
		{
		  $ls_codpro = $ls_codproben;
		  $ls_cedbene = '----------';
		}
		else
		{
		  $ls_codpro = '----------';
		  $ls_cedbene = $ls_codproben;
		}
		$ls_feccomp = convertirFechaBd($ls_feccomp);
		
		$arreglo = $this->uf_load_dtcomprobante($ls_comprobante, $ls_procede, $ls_feccomp);
		$valido = $arreglo[0];
		$mensaje = $arreglo[1];
		$total = $arreglo[2];
		$datos = $arreglo[3];
		
		$i = 0;
		while(($i < $total))
		{
			$ls_codestpro1 = $datos[$i]['codestpro1'];
			$ls_codestpro2 = $datos[$i]['codestpro2'];
			$ls_codestpro3 = $datos[$i]['codestpro3'];
			$ls_codestpro4 = $datos[$i]['codestpro4'];
			$ls_codestpro5 = $datos[$i]['codestpro5'];
			
			$ls_programatica = $ls_codestpro1."-".$ls_codestpro2."-".$ls_codestpro3."-".$ls_codestpro4."-".$ls_codestpro5;	
			
			$ls_spgcuenta = $datos[$i]['spg_cuenta'];
		//	$ls_monto = $ls_monto + $datos[$i]['monto'];
			$ls_monto = $datos[$i]['monto'];
			$ls_estcla = $datos[$i]['estcla']; 
			
			$ld_montopro = ($ld_montopro + $ls_monto);
			$ld_montocmp = number_format($ls_monto,2,",",".");
			
			$ajuste = $this->uf_rddc_ajustes($codemp, $ls_procede, $ls_comprobante, $ls_prov_bene, $ls_codpro, $ls_cedbene,
											 $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, $ls_codestpro5,
											 $ls_spgcuenta, $ls_estcla);
			$valido = $ajuste[0];
			$monto_ajuste = $ajuste[1]; 									
			if(empty($monto_ajuste))
			{
				$ld_ajuste = 0;
			}
			else
			{
				$ld_ajuste = $ld_ajuste + $monto_ajuste; 
			}
			
			if($valido)
			{
				$causado = $this->uf_rddc_causados($codemp, $ls_procede, $ls_comprobante, $ls_prov_bene, $ls_codpro, $ls_cedbene, 
				 								   $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, 
												   $ls_codestpro5, $ls_spgcuenta, $ls_estcla);
			}   
			$valido = $causado[0];
			$monto_causado = $causado[1]; 									
			if(empty($monto_causado))
			{
				$ld_causado = 0;
			}
			else
			{
				$ld_causado = $ld_causado + $monto_causado;
			}
			
			if($valido)
			{
				$anulado = $this->uf_rddc_anulados($codemp, $ls_procede, $ls_comprobante, $ls_prov_bene, $ls_codpro, $ls_cedbene,
				 								   $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, 
												   $ls_codestpro5, $ls_spgcuenta, $ls_estcla);   	    
			}
			$valido = $anulado[0];
			$monto_anulado = $anulado[1]; 									
			if(empty($monto_anulado))
			{
				$ld_anulado = 0;
			}
			else
			{
				$ld_anulado = $ld_anulado + $monto_anulado;
			}
			
			if($valido)
			{
				$montord = $this->uf_rddc_recdoc($codemp, $ls_procede, $ls_comprobante, $ls_codestpro1, $ls_codestpro2, 
												 $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spgcuenta, $ls_estcla);
			}
			$valido = $montord[0];
			$monto_montord = $montord[1]; 									
			if(empty($monto_montord))
			{
				$ld_montord = 0;
			}
			else
			{
				$ld_montord = $ld_montord + $monto_montord;
			}
			
			if($valido)
			{
				$rdcargos = $this->uf_rddc_recdoc_cargos($codemp, $ls_procede, $ls_comprobante, $ls_codestpro1, $ls_codestpro2, 
				 										 $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spgcuenta, 
														 $ls_estcla);   	    
			}
			$valido = $rdcargos[0];
			$monto_rdcargos = $rdcargos[1]; 									
			if(empty($monto_rdcargos))
			{
				 $ld_rdcargos = 0;
			}
			else
			{
				 $ld_rdcargos = $ld_rdcargos + $monto_rdcargos;
			}
			
			if($valido)
			{
				$ls_fechahasta = $ls_fecmov;
				$ls_cargos = 0;
				$cargos = $this->uf_rd_ajusta_spg($codemp, $ls_prov_bene, $ls_codpro, $ls_cedbene, $ls_fechahasta, $ls_codtipdoc,
												  $ls_procede, $ls_comprobante, $ls_feccomp, $ls_cargos);
			}
			$valido = $cargos[0];
			$totalret = $cargos[1];
			$montosret = $cargos[2];
			$monto_cargos = 0;
			for($j=0;$j<$totalret;$j++)
			{
				$monto_cargos = $monto_cargos + $montosret[$j]['monret'];
			}
			if(empty($monto_cargos))
			{
				$ld_cargos = 0;	
			}
			else
			{
				$ld_cargos = $ld_cargos + $monto_cargos;	
			}
			
			if($valido)
			{
				$lb_valido = true;
			}
			$i++;
		}
		
		if ($lb_valido)
		{
			$ld_disponible = ($ld_montopro + $ld_ajuste) - $ld_causado + $ld_anulado - $ld_montord - $ld_rdcargos - $ld_cargos;
			$ld_disponible = number_format($ld_disponible,2,',','.');
			$ld_montopro = number_format($ld_montopro,2,',','.');
			$arrResultado[0] = $ld_disponible;
			$arrResultado[1] = $ld_montopro;
			return $arrResultado;
		}
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function llenarGridCompromisos($codemp, $as_comprobante, $as_procede, $as_feccomp, $as_prov_bene, $as_codproben, 
										  $as_fecmov, $as_codtipdoc, $as_numdoc, $as_sc_cuenta, $as_codafe)
	{
		$arrDetaPres = array();
		$arreglo = array();
	 	$ld_suma = 0;
	 	$ld_monto = 0;
		$disponible = 0;
		$as_feccomp = convertirFechaBd($as_feccomp);
		$as_fecmov = convertirFechaBd($as_fecmov);
				
		$arreglo = $this->aceptarCompromisos($codemp, $as_comprobante, $as_procede, $as_feccomp, $as_prov_bene, $as_codproben, 
											 $as_fecmov, $as_codtipdoc, $as_numdoc, $as_sc_cuenta);
											 
	//	print_r($arreglo);
	//	break;
		$disponible = $arreglo[0];
		$montopro = $arreglo[1];								 
		
		if($disponible > 0)
		{
			if($as_procede == 'SOCCOC')
			{
				$rs_resultado = $this->uf_load_dt_orden_compra($codemp, $as_comprobante, 'B');
				if(empty($rs_resultado))
				{
					$valido = false;	
				}
				else
				{
					$valido = true;
				}		
			}
			else
			{
				if($as_procede == 'SEPSPC')
				{
					$rs_resultado = $this->uf_load_dtotros_sep($codemp, $as_comprobante);
					if(empty($rs_resultado))
					{
						$valido = false;	
					}
					else
					{
						$valido = true;
					}		
				}
				elseif($as_procede == 'SOCCOS')
				{	
					$rs_resultado = $this->uf_load_dt_orden_compra($codemp, $as_comprobante, 'S');
					if(empty($rs_resultado))
					{
						$valido = false;	
					}
					else
					{
						$valido = true;
					}		
				}
			}
			if($valido)
			{
				$ld_suma = doubleval($ld_suma);
				$k = 0;
			
				while((!$rs_resultado->EOF))
				{
					$ld_monto = $rs_resultado->fields["monto"];
					$ld_monto = number_format($ld_monto,2,',','.');
					$ld_suma = number_format(0,2,',','.');;
					$ld_suma = $ld_suma + $ld_monto;
					$ls_spgcuenta = $rs_resultado->fields["spg_cuenta"];
					
					if(($as_procede == 'SOCCOC') || ($as_procede == 'SOCCOS'))
					{
						$ls_comprobante = $rs_resultado->fields["numordcom"];
						$ls_descripcion = $rs_resultado->fields["obscom"];
					}
					elseif($as_procede == 'SEPSPC')
					{
						$ls_comprobante = $rs_resultado->fields["numsol"];
						$ls_descripcion = $rs_resultado->fields["consol"];
					}
					
					$ls_estcla = $rs_resultado->fields["estcla"]; 
					$ls_codestpro1 = $rs_resultado->fields["codestpro1"]; 
					$ls_codestpro2 = $rs_resultado->fields["codestpro2"]; 
					$ls_codestpro3 = $rs_resultado->fields["codestpro3"]; 
					$ls_codestpro4 = $rs_resultado->fields["codestpro4"]; 
					$ls_codestpro5 = $rs_resultado->fields["codestpro5"]; 
					$ls_programatica = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;	
					$ldec_baseimp = $rs_resultado->fields["baseimp"];	
					$ls_codcar = $rs_resultado->fields["codcar"];
					$ls_cargo = '';
				//	$lb_valido = false;
					
					$arrDetaPres[$k]['codcar'] = $ls_codcar;
					$arrDetaPres[$k]['estcla'] = $ls_estcla ;
					$arrDetaPres[$k]['monto'] = $ld_monto;
					$arrDetaPres[$k]['baseimp'] = $ldec_baseimp;
					$arrDetaPres[$k]['estadistico'] = $ls_spgcuenta ;
					$arrDetaPres[$k]['compromisopre'] = $ls_comprobante;
					$arrDetaPres[$k]['programatica'] = $ls_programatica;
					$arrDetaPres[$k]['procede'] = $as_procede;
					$arrDetaPres[$k]['operacion'] = $as_codafe;
					$arrDetaPres[$k]['descripcion'] = $ls_descripcion;
					$arrDetaPres[$k]['suma'] = $ld_suma;
					$arrDetaPres[$k]['codestpro1'] = $ls_codestpro1;
					$arrDetaPres[$k]['codestpro2'] = $ls_codestpro2;
					$arrDetaPres[$k]['codestpro3'] = $ls_codestpro3;
					$arrDetaPres[$k]['codestpro4'] = $ls_codestpro4;
					$arrDetaPres[$k]['codestpro5'] = $ls_codestpro5;
					$arrDetaPres[$k]['estcla'] = $ls_estcla;
					$k++;
					$rs_resultado->MoveNext();
				}
			}
			return $arrDetaPres;
		}
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function llenarGridContables($codemp, $as_comprobante, $as_procede, $as_feccomp, $as_prov_bene, $as_codproben, $as_fecmov,
									   $as_codtipdoc, $as_numdoc, $as_sc_cuenta)
	{
		$arrResultado = array();
		$arrDetaCont = array();
		$arreglo = array();
		$ld_montopro = 0;
	 	$ld_monto = 0; $ld_ajuste = 0; $ld_causado = 0; $ld_anulado = 0; $ld_montord = 0; $ld_rdcargos = 0; $ld_cargos = 0;
	 	$ld_montodebe = 0;
		$disponible = 0;
		$as_feccomp = convertirFechaBd($as_feccomp);
		$as_fecmov = convertirFechaBd($as_fecmov);
				
		$arreglo = $this->aceptarCompromisos($codemp, $as_comprobante, $as_procede, $as_feccomp, $as_prov_bene, $as_codproben, 
											 $as_fecmov, $as_codtipdoc, $as_numdoc, $as_sc_cuenta);
											 
	//	print_r($arreglo);
	//	break;
		$disponible = $arreglo[0];
		$montopro = $arreglo[1];
											
		if ($disponible > 0)
		{
			if ($as_procede == 'SOCCOC')
			{
				$rs_resultado = $this->uf_load_dt_orden_compra($codemp, $as_comprobante, 'B');
				if (empty($rs_resultado))
				{
					$valido = false;	
				}
				else
				{
					$valido = true;
				}		
			}
			else
			{
				if($as_procede == 'SEPSPC')
				{
					$rs_resultado = $this->uf_load_dtotros_sep($codemp, $as_comprobante);
					if (empty($rs_resultado))
					{
						$valido = false;	
					}
					else
					{
						$valido = true;
					}		
				}
				elseif($as_procede == 'SOCCOS')
				{
					$rs_resultado = $this->uf_load_dt_orden_compra($codemp, $as_comprobante, 'S');
					if (empty($rs_resultado))
					{
						$valido = false;	
					}
					else
					{
						$valido = true;
					}		
				}
			}
			if($valido)
			{
				$k = 0;
				while((!$rs_resultado->EOF))
				{
					$ld_monto = $rs_resultado->fields["monto"];
					$ld_monto = doubleval($ld_monto);
					$ld_monto = number_format($ld_monto,2,',','.');
					$ld_montodebe = ($ld_montodebe + $ld_monto);
					$ld_montodebe = number_format($ld_montodebe,2,',','.');
					$ls_scgcuenta = $rs_resultado->fields["sc_cuenta"];
					$ls_deduccion = number_format(0,2,',','.');;
					$ls_operacion = 'D'; 
					
					if(($as_procede == 'SOCCOC') || ($as_procede == 'SOCCOS'))
					{
						$ls_comprobante = $rs_resultado->fields["numordcom"];
						$ls_descripcion = $rs_resultado->fields["obscom"];
					}
					elseif($as_procede == 'SEPSPC')
					{
						$ls_comprobante = $rs_resultado->fields["numsol"];
						$ls_descripcion = $rs_resultado->fields["consol"];
					}
					
					$arrDetaCont[$k]['compromisocon'] = $ls_comprobante;
					$arrDetaCont[$k]['sc_cuenta'] = $ls_scgcuenta ;
					$arrDetaCont[$k]['operacion'] = $ls_operacion;
					$arrDetaCont[$k]['monto'] = $ld_monto;
					$arrDetaCont[$k]['deduccion'] = $ls_deduccion;
					$arrDetaCont[$k]['procede'] = $as_procede;
					$arrDetaCont[$k]['descripcion'] = $ls_descripcion;
					$rs_resultado->MoveNext();
					$k++;
				}
				$ls_mov_document = $as_numdoc;
				$ls_cuenta_scg = $as_sc_cuenta;
				$ls_operacion = 'H';
				$arrDetaCont[$k]['compromisocon'] = $ls_mov_document;
				$arrDetaCont[$k]['sc_cuenta'] = $ls_cuenta_scg;
				$arrDetaCont[$k]['operacion'] = $ls_operacion;
				$arrDetaCont[$k]['monto'] = $montopro;
				$arrDetaCont[$k]['montodebe'] = $ld_montodebe;
			//	$arrDetaCont[$k]['montohaber'] = $montopro;
				$arrDetaCont[$k]['deduccion'] = $ls_deduccion;
				$arrDetaCont[$k]['procede'] = $as_procede;
				$arrDetaCont[$k]['descripcion'] = $ls_descripcion;
			}
			$arrResultado[0] = $arrDetaCont;
			$arrResultado[1] = $montopro;
			$arrResultado[2] = $montopro;
			return $arrResultado;
		//	return $arrDetaCont;
		}
	}
									   
	public function uf_load_dtcomprobante($ls_comprobante, $ls_procedencia, $ls_fecha)
	{
		$arrComprobantes = array();
		$arrResultado = array();
		$ls_operacion = 'CS';
		$ls_fecha = convertirFechaBd($ls_fecha);			
		
		$cadenasql = "	SELECT procede, comprobante, fecha, codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, ". 
					 "	spg_cuenta, SUM(monto) AS monto, estcla ". 
					 "	FROM spg_dt_cmp ".
				   	 "	WHERE procede = '".$ls_procedencia."' ". 
					 "	AND comprobante = '".$ls_comprobante."' ".
					 "	AND fecha = '".$ls_fecha."' ".
					 "	AND operacion = '".$ls_operacion."' ".
				     "	GROUP BY procede, comprobante, fecha, codestpro1, codestpro2, codestpro3, codestpro4, codestpro5, estcla, 
					 	procede_doc, codemp, spg_cuenta";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$j=0;
			$valido = true;
			while((!$resultado->EOF))
			{
				$ls_codestpro1 = $resultado->fields["codestpro1"];
				$ls_codestpro2 = $resultado->fields["codestpro2"];
				$ls_codestpro3 = $resultado->fields["codestpro3"];
			   	$ls_codestpro4 = $resultado->fields["codestpro4"];
			   	$ls_codestpro5 = $resultado->fields["codestpro5"];
				$ls_spgcuenta = $resultado->fields["spg_cuenta"];
				$ls_monto = $resultado->fields["monto"]; 
				$ls_estcla = $resultado->fields["estcla"];
								
				$arrComprobantes[$j]['codestpro1'] = $ls_codestpro1;
				$arrComprobantes[$j]['codestpro2'] = $ls_codestpro2;
				$arrComprobantes[$j]['codestpro3'] = $ls_codestpro3;
				$arrComprobantes[$j]['codestpro4'] = $ls_codestpro4;
				$arrComprobantes[$j]['codestpro5'] = $ls_codestpro5;
				$arrComprobantes[$j]['spg_cuenta'] = $ls_spgcuenta;
				$arrComprobantes[$j]['monto'] = $ls_monto;
				$arrComprobantes[$j]['estcla'] = $ls_estcla;
				$j++;
				$resultado->MoveNext();
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $mensaje;
		$arrResultado[2] = $j;
		$arrResultado[3] = $arrComprobantes;
		unset($conexionbd);
		return $arrResultado;
	}
	
	public function uf_rddc_ajustes($codemp, $as_procedencia, $as_comprobante, $as_prov_bene, $as_codpro, $as_cedbene, 
									$as_codestpro1, $as_codestpro2, $as_codestpro3, $as_codestpro4, $as_codestpro5, $as_spgcuenta, 
									$as_estcla)
	{
		$arrResultado = array();
		$arrMontos = array();
		$ls_operacion = 'CS';
		$monto = 0;
		 
		$cadenasql = "	SELECT SUM(spg_dt_cmp.monto) AS Monto ".
			 	  	 " 	FROM sigesp_cmp, spg_dt_cmp ".
				 	 "	WHERE sigesp_cmp.codemp = '".$codemp."' ".
					 "	AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ".
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".
					 "	AND spg_dt_cmp.operacion = '".$ls_operacion."' ".
					 " 	AND sigesp_cmp.tipo_destino = '".$as_prov_bene."' ".
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".
					 " 	AND sigesp_cmp.ced_bene = '".$as_cedbene."' ".
					 " 	AND spg_dt_cmp.codestpro1 = '".$as_codestpro1."' ".
					 " 	AND spg_dt_cmp.codestpro2 = '".$as_codestpro2."' ".
					 " 	AND spg_dt_cmp.codestpro3 = '".$as_codestpro3."' ".
					 " 	AND spg_dt_cmp.codestpro4 = '".$as_codestpro4."' ".
					 " 	AND spg_dt_cmp.codestpro5 = '".$as_codestpro5."' ".
					 " 	AND spg_dt_cmp.spg_cuenta = '".$as_spgcuenta."' ".
					 " 	AND spg_dt_cmp.estcla = '".$as_estcla."' ".
					 " 	AND spg_dt_cmp.monto < 0 ".	 
					 " 	AND sigesp_cmp.codemp = spg_dt_cmp.codemp ". 
					 " 	AND sigesp_cmp.procede=spg_dt_cmp.procede ". 
					 " 	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ". 
					 " 	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$valido = true;
			if($resultado->fields['Monto'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["Monto"];
					$arrMontos[$j]['Monto'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $monto;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	}
	
	public function uf_rddc_causados($codemp, $as_procedencia, $as_comprobante, $as_prov_bene, $as_codpro, $as_cedbene, 
									 $as_codestpro1, $as_codestpro2, $as_codestpro3, $as_codestpro4, $as_codestpro5, $as_spgcuenta,
									 $as_estcla)
	{
		$arrResultado = array();
		$arrMontos = array();
		$ls_operacion1 = 'CP';	
		$ls_operacion2 = 'CG';
		$monto = 0;
		
		$cadenasql = "	SELECT SUM(spg_dt_cmp.monto) AS Monto ".
				   	 "	FROM spg_dt_cmp, sigesp_cmp ".
				   	 "	WHERE sigesp_cmp.codemp = '".$codemp."' ".
					 "	AND sigesp_cmp.tipo_destino = '".$as_prov_bene."' ". 
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".
					 "	AND sigesp_cmp.ced_bene = '".$as_cedbene."'	".		    
					 "	AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ".  
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".
					 "	AND (spg_dt_cmp.operacion = '".$ls_operacion1."' OR spg_dt_cmp.operacion = '".$ls_operacion2."') ".
					 "	AND spg_dt_cmp.codestpro1 = '".$as_codestpro1."' ".
					 "	AND spg_dt_cmp.codestpro2 = '".$as_codestpro2."' ".
					 "	AND spg_dt_cmp.codestpro3 = '".$as_codestpro3."' ".
					 "	AND spg_dt_cmp.codestpro4 = '".$as_codestpro4."' ".
					 "	AND spg_dt_cmp.codestpro5 = '".$as_codestpro5."' ".
					 "	AND spg_dt_cmp.spg_cuenta = '".$as_spgcuenta."' ".
					 "	AND spg_dt_cmp.estcla = '".$as_estcla."' ".
					 "	AND sigesp_cmp.codemp = spg_dt_cmp.codemp ".
					 "	AND sigesp_cmp.procede = spg_dt_cmp.procede ".
					 "	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ".
					 "	AND sigesp_cmp.fecha = spg_dt_cmp.fecha";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$valido = true;
			if($resultado->fields['Monto'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["Monto"];
					$arrMontos[$j]['Monto'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $monto;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	}
	
	public function uf_rddc_anulados($codemp, $as_procedencia, $as_comprobante, $as_prov_bene, $as_codpro, $as_cedbene, 
							  $as_codestpro1, $as_codestpro2, $as_codestpro3, $as_codestpro4, $as_codestpro5, $as_spgcuenta,
							  $as_estcla)
	{
		$arrResultado = array();
		$arrMontos = array();
		$ls_operacion1 = 'CP';	
		$ls_operacion2 = 'CG';
		$monto = 0;
		
		$cadenasql = "	SELECT sum(spg_dt_cmp.monto) AS Monto ".
				   	 "	FROM sigesp_cmp, spg_dt_cmp ".
				  	 "	WHERE sigesp_cmp.codemp = '".$codemp."' ".
					 "	AND spg_dt_cmp.procede_doc = '".$as_procedencia."' ". 
					 "	AND spg_dt_cmp.documento = '".$as_comprobante."' ".
					 "	AND (spg_dt_cmp.operacion = '".$ls_operacion1."' OR spg_dt_cmp.operacion = '".$ls_operacion2."') ". 
					 "	AND spg_dt_cmp.codestpro1 = '".$as_codestpro1."' ".
					 "	AND spg_dt_cmp.codestpro2 = '".$as_codestpro2."' ".  
					 "	AND spg_dt_cmp.codestpro3 = '".$as_codestpro3."' ".
					 "	AND spg_dt_cmp.codestpro4 = '".$as_codestpro4."' ".  
					 "	AND spg_dt_cmp.codestpro5 = '".$as_codestpro5."' ".
					 "	AND spg_dt_cmp.spg_cuenta = '".$as_spgcuenta."' ".
					 "	AND spg_dt_cmp.estcla = '".$as_estcla."' ".
					 "	AND sigesp_cmp.tipo_destino = '".$as_prov_bene."' ".
					 "	AND sigesp_cmp.cod_pro = '".$as_codpro."' ".
					 "	AND sigesp_cmp.ced_bene = '".$as_cedbene."' ".
					 "	AND sigesp_cmp.procede=spg_dt_cmp.procede ".			
					 "	AND sigesp_cmp.procede = spg_dt_cmp.procede ".
					 "	AND sigesp_cmp.comprobante = spg_dt_cmp.comprobante ".
					 "	AND sigesp_cmp.fecha = spg_dt_cmp.fecha ";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$valido = true;
			if($resultado->fields['Monto'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["Monto"];
					$arrMontos[$j]['Monto'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $monto;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	}
	
	public function uf_rddc_recdoc($codemp, $as_procedencia, $as_comprobante, $as_codestpro1, $as_codestpro2, $as_codestpro3, 
								   $as_codestpro4, $as_codestpro5, $as_spgcuenta, $as_estcla)
	{
		$arrResultado = array();
		$arrMontos = array();
		$ls_estatus = 'R';
		$monto = 0;
		$ls_codestpro = $as_codestpro1.$as_codestpro2.$as_codestpro3.$as_codestpro4.$as_codestpro5;
		
		$cadenasql = "	SELECT sum(cxp_rd_spg.monto) AS Monto ".
				     "	FROM cxp_rd, cxp_rd_spg ".
				     "	WHERE cxp_rd.codemp = '".$codemp."' ".
					 "	AND cxp_rd_spg.procede_doc = '".$as_procedencia."' ".
					 "	AND cxp_rd_spg.numrecdoc = '".$as_comprobante."' ".
					 "	AND cxp_rd_spg.codestpro = '".$ls_codestpro."' ".
					 "	AND cxp_rd_spg.spg_cuenta = '".$as_spgcuenta."' ".
					 "	AND cxp_rd_spg.estcla = '".$as_estcla."' ".
					 "	AND cxp_rd.estprodoc = '".$ls_estatus."' ".
					 "	AND cxp_rd.codemp = cxp_rd_spg.codemp ".
					 "	AND cxp_rd.cod_pro = cxp_rd_spg.cod_pro ".
					 "	AND cxp_rd.ced_bene = cxp_rd_spg.ced_bene ".
					 "	AND cxp_rd.codtipdoc = cxp_rd_spg.codtipdoc ".
					 "	AND cxp_rd.numrecdoc = cxp_rd_spg.numrecdoc ";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$valido = true;
			if($resultado->fields['Monto'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["Monto"];
					$arrMontos[$j]['Monto'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $monto;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	}
	
	public function uf_rddc_recdoc_cargos($codemp, $as_procedencia, $as_numrecdoc, $as_codestpro1, $as_codestpro2, 
										  $as_codestpro3, $as_codestpro4, $as_codestpro5, $as_spgcuenta, $as_estcla)
	{
		$arrResultado = array();
		$arrMontos = array();
		$ls_estatus = 'R';
		$monto = 0;
		
		$cadenasql = "	SELECT sum(cxp_rd_cargos.monret) AS Monto ".
				     "	FROM cxp_rd_cargos, cxp_rd ".
				     "	WHERE cxp_rd.codemp = '".$codemp."' ".
					 "	AND cxp_rd_cargos.procede_doc = '".$as_procedencia."' ".
					 "	AND cxp_rd_cargos.numrecdoc = '".$as_numrecdoc."' ".
					 "	AND cxp_rd_cargos.codestpro1 = '".$as_codestpro1."' ".
					 "	AND cxp_rd_cargos.codestpro2 = '".$as_codestpro2."' ".
					 "	AND cxp_rd_cargos.codestpro3 = '".$as_codestpro3."' ".
					 "	AND cxp_rd_cargos.codestpro4 = '".$as_codestpro4."' ".
					 "	AND cxp_rd_cargos.codestpro5 = '".$as_codestpro5."' ".
					 "	AND cxp_rd_cargos.estcla = '".$as_estcla."' ".
					 "	AND cxp_rd_cargos.spg_cuenta = '".$as_spgcuenta."' ".
					 "	AND cxp_rd.estprodoc = '".$ls_estatus."' ".
					 "	AND cxp_rd.codemp = cxp_rd_cargos.codemp ".
					 "	AND cxp_rd.numrecdoc = cxp_rd_cargos.numrecdoc ".
					 "	AND cxp_rd.codtipdoc = cxp_rd_cargos.codtipdoc ".
					 "	AND cxp_rd.cod_pro = cxp_rd_cargos.cod_pro ".
					 "	AND cxp_rd.ced_bene = cxp_rd_cargos.ced_bene ";
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			$valido = false;
		}
		else
		{
			$valido = true;
			if($resultado->fields['Monto'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["Monto"];
					$arrMontos[$j]['Monto'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $monto;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	}
	
	public function uf_rd_ajusta_spg($codemp, $as_tipo, $as_codpro, $as_cedbene, $as_fechahasta, $as_codtipdoc, $as_procede, 
									 $as_comprobante, $as_feccomp, $as_cargos)
	{
		$arrResultadoAux = array();
		$arrResultadoAux = $this->uf_rd_ajusta_spg_down_cargos($codemp, $as_procede, $as_comprobante, $as_codpro);
		return $arrResultadoAux;
	}
	
	public function uf_rd_ajusta_spg_down_cargos($codemp, $as_procedencia, $as_numdoc, $as_codpro)
	{
		$arrResultado = array();
		$arrMontos = array();
		switch ($as_procedencia)
		{
	   		case 'SOCCOC':
				$cadenasql = "	SELECT soc_solicitudcargos.* ".
							 "	FROM soc_solicitudcargos, soc_ordencompra, sigesp_cargos ".
							 "  WHERE soc_solicitudcargos.codemp='".$codemp."' ".
						 	 "	AND soc_ordencompra.numordcom='".$as_numdoc."' ".
						 	 "	AND soc_ordencompra.cod_pro='".$as_codpro."' ".
						 	 "	AND soc_ordencompra.estcondat='B' ".
						  	 "	AND soc_solicitudcargos.codemp=soc_ordencompra.codemp ".
						 	 "	AND soc_solicitudcargos.numordcom=soc_ordencompra.numordcom ".
							 "	AND soc_solicitudcargos.estcondat=soc_ordencompra.estcondat ".						 	 
							 "	AND soc_solicitudcargos.codemp=sigesp_cargos.codemp	".				 
						 	 "	AND soc_solicitudcargos.codcar=sigesp_cargos.codcar ";
			break;
			 
	   		case 'SEPSPC':
				$cadenasql = "	SELECT sep_solicitudcargos.* ".
					  		 "  FROM sep_solicitudcargos, sep_solicitud, sigesp_cargos ".
					  		 "  WHERE sep_solicitud.codemp='".$as_codemp."' ". 
						   	 "	AND sep_solicitudcargos.numsol='".$as_numdoc."' ".
						     "	AND sep_solicitud.cod_pro='".$as_codpro."' ".
						     "	AND sep_solicitudcargos.codemp=sep_solicitud.codemp ".
						     " 	AND sep_solicitudcargos.numsol=sep_solicitud.numsol ".
						     "	AND sep_solicitudcargos.codemp=sigesp_cargos.codemp ".
						     "	AND sep_solicitudcargos.codcar=sigesp_cargos.codcar ";
			break; 
			
			case 'SOCCOS':
				$cadenasql = "	SELECT soc_solicitudcargos.* ".
							 "  FROM soc_solicitudcargos, soc_ordencompra, sigesp_cargos ".
							 "  WHERE soc_ordencompra.codemp='".$as_codemp."' ".
						 	 "	AND soc_ordencompra.numordcom='".$as_numdoc."' ".
						 	 "	AND soc_ordencompra.cod_pro='".$as_codpro."' ". 
						  	 "	AND soc_ordencompra.estcondat='S' ".
						 	 "	AND soc_solicitudcargos.codemp=soc_ordencompra.codemp ".
						 	 "	AND soc_solicitudcargos.numordcom=soc_ordencompra.numordcom ".
							 "	AND soc_solicitudcargos.estcondat=soc_ordencompra.estcondat ".						 	 
						 	 "	AND soc_solicitudcargos.codemp=sigesp_cargos.codemp ".
						 	 "	AND soc_solicitudcargos.codcar=sigesp_cargos.codcar ";
			break;
		}
	//	echo $cadenasql;
	//	break;
	   	$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	   	$resultado = $conexionbd->Execute ( $cadenasql );
	   	if ($resultado===false)
	   	{
	   		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	   		$valido = false;
	   	}
		else
		{
			$valido = true;
			if($resultado->fields['monret'] != '')
			{
				$j=0;
				while((!$resultado->EOF))
				{
					$monto = $resultado->fields["monret"];
					$arrMontos[$j]['monret'] = $monto;
					$j++;
					$resultado->MoveNext();
				}
			}
		}
		$arrResultado[0] = $valido;
		$arrResultado[1] = $j;
		$arrResultado[2] = $arrMontos;
		return $arrResultado;
	 }
	
	public function uf_load_dt_orden_compra($codemp, $as_numordcom, $as_estcondat)
	{
		$ls_gestor = $_SESSION["ls_gestor"];
	   	switch ($ls_gestor)
		{
			case 'MYSQLT':
				$ls_cadena = " CONCAT(soc_solicitudcargos.codestpro1,soc_solicitudcargos.codestpro2,soc_solicitudcargos.codestpro3,soc_solicitudcargos.codestpro4,soc_solicitudcargos.codestpro5)= ".
							 " CONCAT(soc_cuentagasto.codestpro1,soc_cuentagasto.codestpro2,soc_cuentagasto.codestpro3,soc_cuentagasto.codestpro4,soc_cuentagasto.codestpro5) ";
				$ls_where =	" AND CONCAT(soc_cuentagasto.codestpro1,soc_cuentagasto.codestpro2,soc_cuentagasto.codestpro3,soc_cuentagasto.codestpro4,soc_cuentagasto.codestpro5)= ".
							" CONCAT(spg_cuentas.codestpro1,spg_cuentas.codestpro2,spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5) ";
			break;

			case 'MYSQLI':
				$ls_cadena = " CONCAT(soc_solicitudcargos.codestpro1,soc_solicitudcargos.codestpro2,soc_solicitudcargos.codestpro3,soc_solicitudcargos.codestpro4,soc_solicitudcargos.codestpro5)= ".
							 " CONCAT(soc_cuentagasto.codestpro1,soc_cuentagasto.codestpro2,soc_cuentagasto.codestpro3,soc_cuentagasto.codestpro4,soc_cuentagasto.codestpro5) ";
				$ls_where =	" AND CONCAT(soc_cuentagasto.codestpro1,soc_cuentagasto.codestpro2,soc_cuentagasto.codestpro3,soc_cuentagasto.codestpro4,soc_cuentagasto.codestpro5)= ".
							" CONCAT(spg_cuentas.codestpro1,spg_cuentas.codestpro2,spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5) ";
			break;

			case 'ORACLE':
				$ls_cadena = " soc_solicitudcargos.codestpro1||soc_solicitudcargos.codestpro2||soc_solicitudcargos.codestpro3||soc_solicitudcargos.codestpro4||soc_solicitudcargos.codestpro5= ".
							 " soc_cuentagasto.codestpro1||soc_cuentagasto.codestpro2||soc_cuentagasto.codestpro3||soc_cuentagasto.codestpro4||soc_cuentagasto.codestpro5";
				$ls_where = " AND soc_cuentagasto.codestpro1||soc_cuentagasto.codestpro2||soc_cuentagasto.codestpro3||soc_cuentagasto.codestpro4||soc_cuentagasto.codestpro5= ".
							"     spg_cuentas.codestpro1||spg_cuentas.codestpro2||spg_cuentas.codestpro3||spg_cuentas.codestpro4||spg_cuentas.codestpro5";
			break;
			
			case 'POSTGRES':
				$ls_cadena = " (soc_solicitudcargos.codestpro1||soc_solicitudcargos.codestpro2||soc_solicitudcargos.codestpro3||soc_solicitudcargos.codestpro4||soc_solicitudcargos.codestpro5)= ".
							 " (soc_cuentagasto.codestpro1||soc_cuentagasto.codestpro2||soc_cuentagasto.codestpro3||soc_cuentagasto.codestpro4||soc_cuentagasto.codestpro5) ";
				$ls_where = " AND (soc_cuentagasto.codestpro1||soc_cuentagasto.codestpro2||soc_cuentagasto.codestpro3||soc_cuentagasto.codestpro4||soc_cuentagasto.codestpro5)= ".
							" (spg_cuentas.codestpro1||spg_cuentas.codestpro2||spg_cuentas.codestpro3||spg_cuentas.codestpro4||spg_cuentas.codestpro5)";
			break;
					
			case 'ANYWHERE':
				$ls_cadena = " CONCAT(soc_solicitudcargos.codestpro1+soc_solicitudcargos.codestpro2+soc_solicitudcargos.codestpro3+soc_solicitudcargos.codestpro4+soc_solicitudcargos.codestpro5) = ".
							 " CONCAT(soc_cuentagasto.codestpro1+soc_cuentagasto.codestpro2+soc_cuentagasto.codestpro3+soc_cuentagasto.codestpro4+soc_cuentagasto.codestpro5) ";
				$ls_where = " CONCAT(soc_cuentagasto.codestpro1+soc_cuentagasto.codestpro2+soc_cuentagasto.codestpro3+soc_cuentagasto.codestpro4+soc_cuentagasto.codestpro5)= ".
							" CONCAT(spg_cuentas.codestpro1+spg_cuentas.codestpro2+spg_cuentas.codestpro3+spg_cuentas.codestpro4+spg_cuentas.codestpro5)  ";
			break;
	    }
		
	  	if(($as_estcondat == "B") || ($as_estcondat == "-") || ($as_estcondat == ""))
	  	{
			$cadenasql = "	SELECT 	soc_cuentagasto.numordcom, soc_cuentagasto.codestpro1, soc_cuentagasto.codestpro2, ".
						 "			soc_cuentagasto.codestpro3, soc_cuentagasto.codestpro4, soc_cuentagasto.codestpro5, ". 
						 "			soc_cuentagasto.spg_cuenta, soc_cuentagasto.estcla, ".
						 "  COALESCE(soc_solicitudcargos.monobjret,0) as baseimp, ".
						 "	COALESCE(soc_solicitudcargos.monret, soc_cuentagasto.monto) as monto, ".
						 "			spg_cuentas.sc_cuenta, soc_solicitudcargos.codcar, soc_ordencompra.obscom ".
						 "	FROM spg_cuentas,soc_ordencompra,soc_cuentagasto ".
						 "	LEFT OUTER JOIN soc_solicitudcargos ".
						 "	ON (soc_solicitudcargos.numordcom=soc_cuentagasto.numordcom ". 
						 "	AND ".$ls_cadena." ".
						 "	AND soc_solicitudcargos.spg_cuenta=soc_cuentagasto.spg_cuenta ". 
						 "	AND soc_solicitudcargos.estcla=soc_cuentagasto.estcla) ".
						 "	WHERE  soc_cuentagasto.numordcom='".$as_numordcom."' ". 
						 "	AND soc_cuentagasto.codemp='".$codemp."' ".
						 "	AND (soc_cuentagasto.estcondat='B' OR soc_cuentagasto.estcondat='-' OR soc_cuentagasto.estcondat='') ". 
						 "	AND soc_cuentagasto.spg_cuenta=spg_cuentas.spg_cuenta ". 
						 "	AND soc_cuentagasto.estcla=spg_cuentas.estcla ".$ls_where." ".
						 "	AND soc_cuentagasto.codemp=soc_ordencompra.codemp ".
						 "	AND soc_cuentagasto.numordcom=soc_ordencompra.numordcom ".
						 "	AND soc_cuentagasto.estcondat=soc_ordencompra.estcondat ".
						 "	ORDER BY soc_cuentagasto.numordcom";
		//	echo $cadenasql;
		//	break;
	  	}			  
	  	
		if($as_estcondat == "S") 
	  	{
			$cadenasql = "	SELECT 	soc_cuentagasto.numordcom, soc_cuentagasto.codestpro1, soc_cuentagasto.codestpro2, ".
						 "			soc_cuentagasto.codestpro3, soc_cuentagasto.codestpro4, soc_cuentagasto.codestpro5, ".
						 "			soc_cuentagasto.spg_cuenta, soc_cuentagasto.estcla, ".
						 "  COALESCE(soc_solicitudcargos.monobjret,0) as baseimp, ".
						 "	COALESCE(soc_solicitudcargos.monret,soc_cuentagasto.monto) as monto, ".
						 "			spg_cuentas.sc_cuenta, soc_solicitudcargos.codcar, soc_ordencompra.obscom ".
						 "	FROM spg_cuentas,soc_ordencompra,soc_cuentagasto ".
						 "	LEFT OUTER JOIN soc_solicitudcargos ".
						 "	ON (soc_solicitudcargos.numordcom=soc_cuentagasto.numordcom ". 
						 "	AND ".$ls_cadena." ". 
						 "	AND soc_solicitudcargos.spg_cuenta=soc_cuentagasto.spg_cuenta ". 
						 "	AND soc_solicitudcargos.estcla=soc_cuentagasto.estcla) ".
						 "	WHERE  soc_cuentagasto.numordcom='".$as_numordcom."' ".
						 "	AND soc_cuentagasto.codemp='".$codemp."' ". 
						 "	AND (soc_cuentagasto.estcondat='S') ". 
						 "	AND soc_cuentagasto.spg_cuenta=spg_cuentas.spg_cuenta ".
						 "	AND soc_cuentagasto.estcla=spg_cuentas.estcla ".$ls_where." ".
						 "	AND soc_cuentagasto.codemp=soc_ordencompra.codemp ".
						 "	AND soc_cuentagasto.numordcom=soc_ordencompra.numordcom ".
						 "	AND soc_cuentagasto.estcondat=soc_ordencompra.estcondat ".
						 "	ORDER BY numordcom";
		//	echo $cadenasql;
		//	break;
	  	}	  
	
	   	$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	   	$resultado = $conexionbd->Execute ( $cadenasql );
	   	if ($resultado===false)
	   	{
	   		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	   		$valido = false;
	   	}
		return $resultado;
	}
	
	public function uf_load_dtotros_sep($codemp, $as_numsol)
	{
		$ls_gestor = $_SESSION["ls_gestor"];
	   	switch ($ls_gestor)
	   	{
			case 'MYSQLT':
				$ls_cadena = "	CONCAT(sep_solicitudcargos.codestpro1,sep_solicitudcargos.codestpro2,sep_solicitudcargos.codestpro3,sep_solicitudcargos.codestpro4,sep_solicitudcargos.codestpro5)= ".
						     "	CONCAT(sep_cuentagasto.codestpro1,sep_cuentagasto.codestpro2,sep_cuentagasto.codestpro3,sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5)";
			  	$ls_sqlaux = "	CONCAT(sep_cuentagasto.codestpro1,sep_cuentagasto.codestpro2,sep_cuentagasto.codestpro3,sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5)= ".
							 "	CONCAT(spg_cuentas.codestpro1,spg_cuentas.codestpro2,spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5)";
			break;

			case 'MYSQLI':
				$ls_cadena = "	CONCAT(sep_solicitudcargos.codestpro1,sep_solicitudcargos.codestpro2,sep_solicitudcargos.codestpro3,sep_solicitudcargos.codestpro4,sep_solicitudcargos.codestpro5)= ".
						     "	CONCAT(sep_cuentagasto.codestpro1,sep_cuentagasto.codestpro2,sep_cuentagasto.codestpro3,sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5)";
			  	$ls_sqlaux = "	CONCAT(sep_cuentagasto.codestpro1,sep_cuentagasto.codestpro2,sep_cuentagasto.codestpro3,sep_cuentagasto.codestpro4,sep_cuentagasto.codestpro5)= ".
							 "	CONCAT(spg_cuentas.codestpro1,spg_cuentas.codestpro2,spg_cuentas.codestpro3,spg_cuentas.codestpro4,spg_cuentas.codestpro5)";
			break;
			
		   	case 'ORACLE':
				$ls_cadena = " 	sep_solicitudcargos.codestpro1||sep_solicitudcargos.codestpro2||sep_solicitudcargos.codestpro3||sep_solicitudcargos.codestpro4||sep_solicitudcargos.codestpro5= ".
						     " 	sep_cuentagasto.codestpro1||sep_cuentagasto.codestpro2||sep_cuentagasto.codestpro3||sep_cuentagasto.codestpro4||sep_cuentagasto.codestpro5";
			  	$ls_sqlaux = " 	sep_cuentagasto.codestpro1||sep_cuentagasto.codestpro2||sep_cuentagasto.codestpro3||sep_cuentagasto.codestpro4||sep_cuentagasto.codestpro5= ".
							 "	spg_cuentas.codestpro1||spg_cuentas.codestpro2||spg_cuentas.codestpro3||spg_cuentas.codestpro4||spg_cuentas.codestpro5";
			break;
			
		   	case 'POSTGRES':
				$ls_cadena = "	sep_solicitudcargos.codestpro1||sep_solicitudcargos.codestpro2||sep_solicitudcargos.codestpro3||sep_solicitudcargos.codestpro4||sep_solicitudcargos.codestpro5= ".
						     " 	sep_cuentagasto.codestpro1||sep_cuentagasto.codestpro2||sep_cuentagasto.codestpro3||sep_cuentagasto.codestpro4||sep_cuentagasto.codestpro5";
			  	$ls_sqlaux = " 	sep_cuentagasto.codestpro1||sep_cuentagasto.codestpro2||sep_cuentagasto.codestpro3||sep_cuentagasto.codestpro4||sep_cuentagasto.codestpro5= ".
							 "	spg_cuentas.codestpro1||spg_cuentas.codestpro2||spg_cuentas.codestpro3||spg_cuentas.codestpro4||spg_cuentas.codestpro5";
			break;
				    
		   	case 'ANYWHERE':
				$ls_cadena = "	sep_solicitudcargos.codestpro1+sep_solicitudcargos.codestpro2+sep_solicitudcargos.codestpro3+sep_solicitudcargos.codestpro4+sep_solicitudcargos.codestpro5= ".
						     " 	sep_cuentagasto.codestpro1+sep_cuentagasto.codestpro2+sep_cuentagasto.codestpro3+sep_cuentagasto.codestpro4+sep_cuentagasto.codestpro5";
			  	$ls_sqlaux = " 	sep_cuentagasto.codestpro1+sep_cuentagasto.codestpro2+sep_cuentagasto.codestpro3+sep_cuentagasto.codestpro4+sep_cuentagasto.codestpro5= ".
							 "	spg_cuentas.codestpro1+spg_cuentas.codestpro2+spg_cuentas.codestpro3+spg_cuentas.codestpro4+spg_cuentas.codestpro5";
			  break;
		}
	   	
		$cadenasql = "	SELECT 	sep_cuentagasto.numsol, sep_cuentagasto.codestpro1, sep_cuentagasto.codestpro2, ".
					 "			sep_cuentagasto.codestpro3, sep_cuentagasto.codestpro4, sep_cuentagasto.codestpro5, ".
					 "			sep_cuentagasto.spg_cuenta, sep_cuentagasto.estcla, ".
					 "	COALESCE(sep_solicitudcargos.monobjret,0) as baseimp , ".
					 "	COALESCE(sep_solicitudcargos.monret,sep_cuentagasto.monto) as monto, ".
					 "			spg_cuentas.sc_cuenta, sep_solicitudcargos.codcar, sep_solicitud.consol ".
					 "	FROM spg_cuentas, sep_solicitud, sep_cuentagasto ".
					 "	LEFT OUTER JOIN sep_solicitudcargos ".
					 " 	ON (sep_solicitudcargos.numsol=sep_cuentagasto.numsol ".
					 "	AND $ls_cadena ".
					 "	AND sep_solicitudcargos.spg_cuenta=sep_cuentagasto.spg_cuenta ".
					 "	AND sep_solicitudcargos.estcla=sep_cuentagasto.estcla) ".
				   	 "	WHERE sep_cuentagasto.codemp='".$codemp."' ".
					 "	AND sep_cuentagasto.numsol='".$as_numsol."' ".
					 "	AND sep_cuentagasto.spg_cuenta=spg_cuentas.spg_cuenta ". 
					 "	AND sep_cuentagasto.estcla=spg_cuentas.estcla ".
					 "	AND $ls_sqlaux ".
					 "	AND sep_cuentagasto.codemp=sep_solicitud.codemp ".
					 "	AND sep_cuentagasto.numsol=sep_solicitud.numsol ".
				   	 "	ORDER BY sep_cuentagasto.numsol";
	   	
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	   	$resultado = $conexionbd->Execute ( $cadenasql );
	   	if ($resultado===false)
	   	{
	   		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	   		$valido = false;
	   	}
		return $resultado;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarOrdPagDirCP($codemp, $as_documento, $as_fecdesde, $as_fechasta, $as_codope, $as_tipo, $as_provben, 
									  $as_estmov, $as_opener, $as_cartaorden)
	{
		if((($as_fecdesde!="")&&($as_fecdesde!="01/01/1900"))&&(($as_fechasta!="")&&($as_fechasta!="01/01/1900")))
		{
			$as_fecdesde = convertirFechaBd($as_fecdesde);
			$as_fechasta = convertirFechaBd($as_fechasta);
			
			$cadenafiltro = $cadenafiltro." AND scb_movbco.fecmov>='".$as_fecdesde."' AND scb_movbco.fecmov<='".$as_fechasta."'";
		}
		
		if($as_codope!="N")
		{
			$cadenafiltro = $cadenafiltro." AND scb_movbco.codope ='".$as_codope."'";
		}

		if(($as_tipo=="P")&&($as_provben!=""))
		{
			$cadenafiltro = $cadenafiltro." AND scb_movbco.cod_pro like '".$as_provben."'";
		}
		elseif(($as_tipo=="B")&&($as_provben!=""))
		{
			$cadenafiltro = $cadenafiltro." AND scb_movbco.ced_bene like'".$as_provben."'";
		}
		
		if($as_estmov!="-")
		{
			$cadenafiltro = $cadenafiltro." AND scb_movbco.estmov='".$as_estmov."'";
		}
		
		$cadenafiltro = $cadenafiltro." ORDER BY scb_movbco.fecmov ASC, scb_movbco.numdoc ASC";
		
		$cadenasql = "	SELECT 	scb_movbco.*, ".
					 "			(SELECT MAX(codfuefin) ".
					 "			FROM scb_movbco_fuefinanciamiento ".
					 "			WHERE codemp = scb_movbco.codemp ".
					 "			AND codban = scb_movbco.codban ".
					 "			AND ctaban = scb_movbco.ctaban ".
					 "			AND numdoc = scb_movbco.numdoc ".
					 "			AND codope = scb_movbco.codope ".
					 "			AND estmov = scb_movbco.estmov) AS fuentefinanciamiento, ".
					 "			(SELECT nomban ".
					 "			FROM scb_banco ".
					 "			WHERE codemp = scb_movbco.codemp ".
					 "			AND codban = scb_movbco.codban) AS nomban, ".
					 "			(SELECT dencta ".
					 "			FROM scb_ctabanco ".
					 "			WHERE codemp = scb_movbco.codemp ".
					 "			AND codban = scb_movbco.codban ".
					 "			AND ctaban = scb_movbco.ctaban) AS dencta, ".
					 "			scb_dt_op.nombenaut, scb_dt_op.rifbenaut, scb_dt_op.codbanaut, scb_dt_op.ctabanaut, ".
					 "			scb_dt_op.nombanaut, sigesp_fuentefinanciamiento.denfuefin, spg_ministerio_ua.denuac, ".
					 "			spg_ep1.denestpro1, scb_ctabanco.sc_cuenta, rpc_proveedor.codban as bancopro, ". 
					 "			rpc_proveedor.ctaban as cuentapro, rpc_beneficiario.codban as bancoben, ".
					 "			rpc_beneficiario.ctaban as cuentaben ".
					 "	FROM scb_movbco ".
					 "	LEFT JOIN scb_dt_op ".
					 "	ON scb_movbco.codemp = scb_dt_op.codemp ".
					 "	AND scb_movbco.codban = scb_dt_op.codban ".
					 "	AND scb_movbco.ctaban = scb_dt_op.ctaban ".
					 " 	AND scb_movbco.numdoc = scb_dt_op.numdoc ".
					 "	AND scb_movbco.codope = scb_dt_op.codope ".
					 "	LEFT JOIN sigesp_fuentefinanciamiento ".
					 "	ON scb_movbco.codemp = sigesp_fuentefinanciamiento.codemp ".
					 "	AND scb_movbco.codfuefin = sigesp_fuentefinanciamiento.codfuefin ".
					 "	LEFT JOIN spg_ministerio_ua ".
					 "	ON scb_movbco.codemp = spg_ministerio_ua.codemp ".
					 "	AND scb_movbco.coduniadmsig = spg_ministerio_ua.coduac ". 	
 					 "	LEFT JOIN spg_ep1 ".
					 "	ON scb_movbco.codemp = spg_ep1.codemp ".
				 	 "	AND scb_movbco.codestprosig = SUBSTR(spg_ep1.codestpro1,26-{$_SESSION["la_empresa"]["loncodestpro1"]},{$_SESSION["la_empresa"]["loncodestpro1"]}) ".
					 "	LEFT JOIN scb_ctabanco ".
					 "	ON scb_movbco.codemp = scb_ctabanco.codemp ".
					 "	AND scb_movbco.codban = scb_ctabanco.codban ".
					 "	AND scb_movbco.ctaban = scb_ctabanco.ctaban ".
					 "	LEFT JOIN rpc_proveedor ".
					 "	ON scb_movbco.codemp = rpc_proveedor.codemp ".
					 "	AND scb_movbco.cod_pro = rpc_proveedor.cod_pro ".  	
					 " 	LEFT JOIN rpc_beneficiario ".
					 "	ON scb_movbco.codemp = rpc_beneficiario.codemp ".
					 "	AND scb_movbco.cod_pro = rpc_beneficiario.ced_bene ". 
					 " 	WHERE scb_movbco.codemp='".$codemp."' ".
					 "	AND scb_movbco.numdoc like '%".$as_documento."%' ".
					 "	".$cadenafiltro." ";						 
	//	echo $cadenasql;
	//	break;
		
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= ' CLASE-> Orden Pago Directo CP - MÉTODO-> buscarOrdPagDirCP - ERROR-> '.$conexionbd->ErrorMsg();
		}
	    return $resultado;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	 public function guardarOrdenPagoDCP($codemp, $codusu, $as_modalidad, $as_estserext, $as_numdoc, $as_fecmov, $as_coduac, $as_codestprosig,
	 									 $as_codbanori, $as_ctaban, $as_provbene, $as_codproben, $as_nomproben, $as_codbanco,
										 $as_nombanco, $as_codcuenta, $as_dencuenta, $as_sccuenta, $as_codope, $as_codafe, 
										 $as_conordpag, $as_estmov, $as_conmov, $as_monto, $as_monobjret, $as_monret, $as_tipdocres, 
										 $as_numdocres, $as_fecordpag, $as_tipregres, $as_codfuefin, $as_codorigen, $as_formapago, 
										 $as_mediopago, $as_numcontrol, $as_codban, $as_nomban, $as_nomcob, $as_rifcob, $as_ctacob,
										 $as_procede, $as_codtipdoc, $arrContable, $arrPresupuestario, $arrevento)
	{
		$arrCabeceraScb = array();
		$arrDetalleScg = array();
		$arrDetalleSpg = array();
		$arrDetalleSpi = array();
		$resultado = 0;
		$li_cont = 0;
		$li_cont_dtscg = 0;
		$li_cont_dtspg = 0;
		$ls_numconint = "";
		$ls_modalidad = $_SESSION["la_empresa"]["estmodest"];
		
		if($as_provbene=='P')
		{
			$ls_codpro = $as_codproben;
			$ls_cedbene = "----------";
		}
		else
		{
			$ls_codpro = "----------";
			$ls_cedbene = $codproben;
		}
		
		$ls_monto = str_replace(".","",$as_monto);
		$ls_monto = str_replace(",",".",$as_monto);
		$ls_monobjret = str_replace(".","",$as_monobjret);
		$ls_monobjret = str_replace(",",".",$as_monobjret);
		$ls_monret = str_replace(".","",$as_monret);
		$ls_monret = str_replace(",",".",$as_monret);
		$li_totalretenido = $monret;
		$as_fecmov = convertirFechaBd($as_fecmov);
		$as_fecordpag = convertirFechaBd($as_fecordpag);
		if(strlen(as_nomproben)>100)
		{
			$as_nomproben = substr($as_nomproben,0,100);
		}
		
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		$servicioEvento = new ServicioEvento();
		//Creacion del Arreglo de Cabecera
		$arrCabeceraScb["codemp"]	 = $codemp;
		$arrCabeceraScb["codusu"]	 = $codusu;
		$arrCabeceraScb["codban"]	 = $as_codbanori;
		$arrCabeceraScb["ctaban"]	 = $as_ctaban;
		$arrCabeceraScb["numdoc"]	 = $as_numdoc;
		$arrCabeceraScb["codope"]	 = $as_codope;
		$arrCabeceraScb["fecmov"]	 = $as_fecmov;
		$arrCabeceraScb["conmov"]	 = $as_conmov;
		$arrCabeceraScb["codconmov"] = '---';
		$arrCabeceraScb["cod_pro"]	 = $ls_codpro;
		$arrCabeceraScb["ced_bene"]	 = $ls_cedbene;
		$arrCabeceraScb["nomproben"] = $as_nomproben;
		$arrCabeceraScb["monto"]	 = formatoNumericoBd($as_monto,1);
		$arrCabeceraScb["monobjret"] = formatoNumericoBd($as_monobjret,1);
		$arrCabeceraScb["monret"]	 = formatoNumericoBd($as_monret,1);
		$arrCabeceraScb["estmov"]	 = $as_estmov;
		$arrCabeceraScb["estmovint"] = 0;
		$arrCabeceraScb["estcobing"] = 0;
		$arrCabeceraScb["estbpd"]	 = 'M';
		$arrCabeceraScb["procede"]	 = $as_procede;
		$arrCabeceraScb["tipo_destino"]	 = $as_provbene;
		$arrCabeceraScb["numordpagmin"]	 = '-';
		$arrCabeceraScb["codfuefin"] = $as_codfuefin;
		$arrCabeceraScb["codtipfon"] = '----';
		$arrCabeceraScb["estmovcob"] = 0;
		$arrCabeceraScb["coduniadmsig"] = $as_coduac;
		$arrCabeceraScb["codbansig"]	= $as_codbanori;
		$arrCabeceraScb["fecordpagsig"]	= $as_fecordpag;
		$arrCabeceraScb["tipdocressig"] = $as_tipdocres;
		$arrCabeceraScb["numdocressig"]	= $as_numdocres;
		$arrCabeceraScb["estmodordpag"] = $as_modalidad;
		$arrCabeceraScb["forpagsig"]	= $as_formapago;
		$arrCabeceraScb["medpagsig"]	= $as_mediopago;
		$arrCabeceraScb["codestprosig"]	= $as_codestprosig;
		$arrCabeceraScb["nrocontrolop"]	= $as_numcontrol;
		$arrCabeceraScb["estserext"]	= $as_estserext;
		//Creacion del Arreglo de Cabecera
	//	print_r($arrCabeceraScb);
	//	break;
		
		if(count($arrContable)!=0)
		{
			foreach($arrContable as $detallescg)
			{
				$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]  = $detallescg->scg_cuenta;
				$arrDetalleScg["procede_doc"][$li_cont_dtscg] = $detallescg->procede_doc;
				$arrDetalleScg["desmov"][$li_cont_dtscg]	  = $detallescg->desmov;
				$arrDetalleScg["documento"][$li_cont_dtscg]	  = $detallescg->documento;
				$arrDetalleScg["debhab"][$li_cont_dtscg]	  = $detallescg->debhab;
				$arrDetalleScg["monto"][$li_cont_dtscg]	 	  = formatoNumericoBd($detallescg->monto,1);
				$arrDetalleScg["monobjret"][$li_cont_dtscg]	  = formatoNumericoBd($detallescg->monto,1);
				$arrDetalleScg["codded"][$li_cont_dtscg]	  = formatoNumericoBd($detallescg->codded,1);
				$li_cont_dtscg++;
			}
		}
		
		if(count($arrPresupuestario)!=0)
		{
			foreach($arrPresupuestario as $detallespg)
			{
				switch($ls_modalidad)
				{
					case "1": // Modalidad por Proyecto
						$codest1 = str_pad($detallespg->codestpro1,25,0,0);
						$codest2 = str_pad($detallespg->codestpro2,25,0,0);
						$codest3 = str_pad($detallespg->codestpro3,25,0,0);
						$cadena = $codest1.$codest2.$codest3;
					break;
						
					case "2": // Modalidad por Programatica
						$codest1 = str_pad($detallespg->codestpro1,25,0,0);
						$codest2 = str_pad($detallespg->codestpro2,25,0,0);
						$codest3 = str_pad($detallespg->codestpro3,25,0,0);
						$codest4 = str_pad($detallespg->codestpro4,25,0,0);
						$codest5 = str_pad($detallespg->codestpro5,25,0,0);
						$cadena = $codest1.$codest2.$codest3.$codest4.$codest5;
					break;
				} 
				$arrDetalleSpg["codestpro"][$li_cont_dtspg]	  = $cadena;
				$arrDetalleSpg["spgcuenta"][$li_cont_dtspg]   = $detallespg->spgcuenta;
				$arrDetalleSpg["desmov"][$li_cont_dtspg]	  = $detallespg->desmov;
				$arrDetalleSpg["documento"][$li_cont_dtspg]	  = $detallespg->documento;
				$arrDetalleSpg["procede_doc"][$li_cont_dtspg] = $detallespg->procede_doc;
				$arrDetalleSpg["monto"][$li_cont_dtspg]	 	  = formatoNumericoBd($detallespg->monto,1);
				$arrDetalleSpg["operacion"][$li_cont_dtspg]	  = $detallespg->operacion;
				$arrDetalleSpg["estcla"][$li_cont_dtspg]	  = $detallespg->estcla;
				$arrDetalleSpg["codfuefin"][$li_cont_dtspg]	  = $detallespg->codfuefin;
				$li_cont_dtspg++;
			}
		}
		
		$servicioBancario = new ServicioMovimientoScb();
		$this->valido = $servicioBancario->GuardarAutomatico($arrCabeceraScb,$arrDetalleScg,$arrDetalleSpg,$arrDetalleSpi,$arrevento);
		$this->mensaje.= $servicioBancario->mensaje;
		
		if($this->valido)
		{
			$this->valido = $this->uf_insert_dt_ordenpago($codemp, $as_numdoc, $as_codope, $as_codbanori, $as_ctaban, $ls_codpro,
														  $ls_cedbene, $as_provbene, $as_codbanco, $as_nombanco, $as_codcuenta,
														  $as_codban, $as_nomban, $as_ctacob, $as_rifcob, $as_nomcob);
		}
		if (DaoGenerico::completarTrans($this->valido)) 
		{
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$this->valido=true; 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->mensaje;
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$this->valido=false;
		} 
		return $this->valido;	 
	}
	
	public function uf_insert_dt_ordenpago($ls_codemp, $ls_numdoc, $ls_codope, $ls_codbanori, $ls_ctaban, $ls_codpro, $ls_cedbene,
										   $ls_provbene, $ls_codbanco, $ls_nombanco, $ls_codcuenta, $ls_codban, $ls_nomban, 
										   $ls_ctacob, $ls_rifcob, $ls_nomcob)
	{
		$cadenasql = "	INSERT INTO scb_dt_op(codemp, codban, ctaban, numdoc, codope, cod_pro, ced_bene, tipo_destino, estmov, ".
					 "						  nombenaut, rifbenaut, codbanaut, ctabanaut, nombanaut, codbanbene, nombanbene, ".
					 "						  ctabanbene) ".
				 	 "	VALUES ('".$ls_codemp."','".$ls_codbanori."','".$ls_ctaban."','".$ls_numdoc."','".$ls_codope."', ".
					 "			'".$ls_codpro."','".$ls_cedbene."','".$ls_provbene."','N','".$ls_nomcob."','".$ls_rifcob."', ".
					 "			'".$ls_codban."','".$ls_ctacob."','".$ls_nomban."','".$ls_codbanco."','".$ls_nombanco."', ".
					 "			'".$ls_codcuenta."')";
	//	echo $cadenasql;
	//	break;			 
					 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= ' CLASE-> Orden Pago Directo CP - MÉTODO-> uf_insert_dt_ordenpago - ERROR-> '.$conexionbd->ErrorMsg();
		}
		else
		{
			$mensaje .= ' CLASE-> Orden Pago Directo CP - MÉTODO-> uf_insert_dt_ordenpago - El movimiento fue registrado ';
			return true;
		}
	}
	
	public function eliminarOrdenPagoDCP($codemp, $as_estbpd, $as_procede, $as_numdoc, $as_codban, $as_ctaban, $as_codope,
										$as_estmov, $as_fecmov, $arrevento)
	{
		if($this->validaFechaPeriodo(convertirFechaBd($as_fecmov), $codemp))
		{
			DaoGenerico::iniciarTrans();
			//obteniendo las instacias de los dao's
			$this->daoOrdenPago = FabricaDao::CrearDAO("N","scb_movbco");
			//seteando la data e iniciando transaccion de base de datos
		//	$this->daoOrdenPago->setData($objson);	//
			$this->daoOrdenPago->codemp = $codemp;
			$this->daoOrdenPago->numdoc = $as_numdoc;
			$this->daoOrdenPago->codban = $as_codban;
			$this->daoOrdenPago->ctaban = $as_ctaban;
			$this->daoOrdenPago->codope = $as_codope;
			$this->daoOrdenPago->estmov = $as_estmov;
			$this->daoOrdenPago->fecmov = convertirFechaBd($as_fecmov);
			
			if($this->eliminar($codemp,'scb_movbco_scg', $as_numdoc, $as_codban, $as_ctaban, $as_codope, $as_estmov))
			{
				if($this->eliminar($codemp,'scb_movbco_spg', $as_numdoc, $as_codban, $as_ctaban, $as_codope, $as_estmov))
				{
					if($this->eliminar($codemp,'scb_movbco_fuefinanciamiento', $as_numdoc, $as_codban, $as_ctaban, $as_codope, $as_estmov))
					{
						if($this->eliminar($codemp,'scb_dt_op', $as_numdoc, $as_codban, $as_ctaban, $as_codope, $as_estmov))
						{
							$this->valido=$this->daoOrdenPago->eliminar();
						}
						else
						{
							$this->mensaje .= ' Ocurrio un error al eliminar el detalle de la orden de pago';
							$this->valido = false;
						}
					}
					else
					{
						$this->mensaje .= ' Ocurrio un error al eliminar el detalle de la fuente de financiamento';
						$this->valido = false;
					}
				}
				else
				{
					$this->mensaje .= ' Ocurrio un error al eliminar los detalles presupuestarios';
					$this->valido = false;
				}
			}
			else
			{
				$this->mensaje .= ' Ocurrio un error al eliminar los detalles contables';
				$this->valido = false;
			}
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
		
			if(DaoGenerico::completarTrans($this->valido)) 
			{
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();	 		
			}
			else
			{
				$arrevento ['desevetra'] = $this->mensaje;
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
		}
		else
		{
			$this->mensaje .= ' Verifique que el periodo y el mes de la empresa estén abiertos '.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
	public function validaFechaPeriodo($as_fecha, $as_codemp)
	{
	    $li_ano    = 0 ; $li_mes=0;$li_ano_periodo=0;$li_mes_periodo=0;
	    $ls_fecha  = ""; $ls_periodo_final=""; 
	    $lb_valido = true;
   	    //$as_fecha=$this->uf_convert_date_to_db($as_fecha);
	    $li_ano = intval(substr($as_fecha,0,4));
	    $li_mes = intval(substr($as_fecha,5,2));
	    $li_ano_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],0,4));
	    $li_mes_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],5,2));
	    $ld_periodo_final = "31/12/".$li_ano_periodo;
		if ($li_ano == $li_ano_periodo)
		{
			if($li_mes >= $li_mes_periodo)
			{
			   if($this->uf_valida_fecha_mes( $as_codemp, $as_fecha ))
			   {
			 	  $lb_valido = true;
			   }
			   else	 
			   {
				  $lb_valido = false;
			 	  //$this->is_msg_error = "Mes no esta Abierto";
				  return false;
			   }
			} 			
			else {  $lb_valido = false;	}
		}
		else 
		{ 
			$lb_valido = false;	
		}
		return $lb_valido;	
	} // end function()
	
	public function uf_valida_fecha_mes($as_codemp, $as_fecha)
 	{ 
		 $li_mes=0;$li_M01=0;$li_M02=0;$li_M03=0;$li_M04=0;$li_M05=0;
		 $li_M06=0;$li_M07=0;$li_M08=0;$li_M09=0;$li_M10=0;$li_M11=0;$li_M12=0;
		 $lb_abierto_mes=false;
		 $lb_valido=false;
		 $ls_cadena="";
		 $li_mes = intval(substr($as_fecha,5,2));
		 $cadenasql=" SELECT m01,m02,m03,m04,m05,m06,m07,m08,m09,m10,m11,m12 ". 
		 			" FROM sigesp_empresa WHERE codemp = '".$as_codemp."' ";
		 $conexionbd = ConexionBaseDatos::getInstanciaConexion();
		 $resultado = $conexionbd->Execute ( $cadenasql );
		 if ($resultado===false)
		 {
	 		 $mensaje .= '  ->'.$conexionbd->ErrorMsg();
		 }
		 else
		 {
			$lb_valido=true;
			while((!$resultado->EOF))
			{
				$li_M01=$resultado->fields["m01"];
				$li_M02=$resultado->fields["m02"];
				$li_M03=$resultado->fields["m03"];
				$li_M04=$resultado->fields["m04"];
				$li_M05=$resultado->fields["m05"];
				$li_M06=$resultado->fields["m06"];
				$li_M07=$resultado->fields["m07"];
				$li_M08=$resultado->fields["m08"];
				$li_M09=$resultado->fields["m09"];
				$li_M10=$resultado->fields["m10"];
				$li_M11=$resultado->fields["m11"];
				$li_M12=$resultado->fields["m12"];
				$resultado->MoveNext();
			}
		 } 
		 if ($lb_valido)
		 {
			switch ($li_mes)
			{
				case 1:
					if($li_M01==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 2:
					if($li_M02==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 3:
					if($li_M03==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 4:
					if($li_M04==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 5:
					if($li_M05==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 6:
					if($li_M06==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 7:
					if($li_M07==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 8:
					if($li_M08==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 9:
					if($li_M09==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 10:
					if($li_M10==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 11:
					if($li_M11==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 12:
					if($li_M12==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				default:
			}
		 }	
		 if (!$lb_abierto_mes)
		 {
		   	 //$this->is_msg_error = "El Mes ".$li_mes." no esta abierto.";
			 $lb_valido = false;
		 }
		 unset($conexionbd);
		 unset($resultado);
		 return $lb_valido;
    } // end fuction
	
	public function eliminar($codemp, $tabla, $numdoc, $codban, $ctaban, $codope, $estmov)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$this->valido = true;
		
		$SQL = "SELECT codemp FROM {$tabla}  ".
			   "WHERE codemp='".$codemp."' ".
		       "  AND numdoc ='".$numdoc."'   ".
			   "  AND codban='".$codban."'   ".
			   "  AND ctaban='".$ctaban."'  ".
			   "  AND codope='".$codope."'   ".
			   "  AND estmov='".$estmov."'  ";
		$data = $this->conexionBaseDatos->Execute($SQL);
		if($data === false)
		{
			$this->mensaje .= ' CLASE->Orden Pago Directo CP - MÉTODO->eliminar - ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if($data->fields['codemp']!='')
			{
				$cadenaSQL = "DELETE FROM {$tabla}  ".
					" 	  WHERE codemp='".$codemp."' ".
					"       AND numdoc ='".$numdoc."'   ".
					"       AND codban='".$codban."'   ".
					"       AND ctaban='".$ctaban."'  ".
					"       AND codope='".$codope."'   ".
					"       AND estmov='".$estmov."'  ";
				$datos = $this->conexionBaseDatos->Execute($cadenaSQL);
				if($datos === false)
				{
					$this->mensaje .= '  CLASE->Orden Pago Directo CP - MÉTODO->eliminar - ERROR->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}
			}
		}
		return $this->valido;
	}
}
?>