<?php
$dirsrvrpc = "";
$dirsrvrpc = dirname(__FILE__);
$dirsrvrpc = str_replace("\\","/",$dirsrvrpc);
$dirsrvrpc = str_replace("/modelo/servicio/scb","",$dirsrvrpc); 
require_once ($dirsrvrpc."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvrpc."/modelo/servicio/scb/sigesp_srv_scb_imovbco.php");
require_once ($dirsrvrpc."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrvrpc.'/modelo/servicio/scb/sigesp_srv_scb_movimientos_scb.php');


/**
 * @author Ing. Carlos Zambrano
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioMovimientoBanco implements imovbco {
	private $daoBanco;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioMovimientoBanco() {
		$this->daoBanco = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
	//	$this->conexionBaseDatos->debug=true;
	}
	
	public function buscarCodigoOrganizacion($codemp) {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_tipo_organizacion");
		$this->daoProveedor->codemp = $codemp;
		$dataEmp = $this->daoProveedor->leerTodos('codtipoorg',1,$codemp);
		
		unset($this->daoProveedor);
		return $dataEmp;
	}
	
	public function buscarCodigoProveedor($codemp) {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedor");
		$this->daoProveedor->codemp = $codemp;
		$codigo = $this->daoProveedor->buscarCodigo("cod_pro",true,10);
		unset($this->daoProveedor);
		return $codigo;
	}
	
	public function buscarBancos($codemp) {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "scb_banco");
		$this->daoProveedor->codemp = $codemp;
		$dataBan = $this->daoProveedor->leerTodos('codban',1,$codemp);
		
		unset($this->daoProveedor);
		return $dataBan;
	}

	public function buscarMonedas($codemp) {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "sigesp_moneda");
		$this->daoProveedor->codemp = $codemp;
		$dataMon = $this->daoProveedor->leerTodos('codmon',1,$codemp);
		
		unset($this->daoProveedor);
		return $dataMon;
	}
	
	public function buscarProveedor($codemp,$ls_codpro,$ls_nompro,$ls_dirpro,$ls_rifpro) {
		$cadenasql = "SELECT a.*, b.denominacion, (SELECT denominacion FROM scg_cuentas WHERE a.sc_ctaant=scg_cuentas.sc_cuenta) AS denominacion_2, ".
					 " (SELECT denbansig FROM sigesp_banco_sigecof WHERE a.codbansig=sigesp_banco_sigecof.codbansig) AS denbansig, ".
					 " (SELECT COUNT(codsujret) FROM scb_cmp_ret WHERE (a.ageviapro='1' OR a.aerolipro='1') ".
					 " AND a.cod_pro=scb_cmp_ret.codsujret AND a.rifpro=scb_cmp_ret.rif) AS comprobante ".
					 " FROM rpc_proveedor a ".
					 " LEFT JOIN scg_cuentas b ON (a.sc_cuenta=b.sc_cuenta ) ".
					 " LEFT JOIN sigesp_pais c ON (a.codpai=c.codpai)" .
					 " LEFT JOIN sigesp_estados d ON (a.codest=d.codest and c.codpai=d.codpai) ".
					 " LEFT JOIN sigesp_municipio e ON (a.codmun=e.codmun and d.codest=e.codest and c.codpai=e.codpai) ".
					 " LEFT JOIN sigesp_parroquia f ON (a.codpar=f.codpar and e.codmun=f.codmun and d.codest=f.codest and c.codpai=f.codpai) ".
					 " WHERE a.cod_pro like '%$ls_codpro%' ".
					 " AND a.nompro like '%$ls_nompro%' ".
					 " AND a.dirpro like '%$ls_dirpro%' ".
					 " AND a.rifpro like '%$ls_rifpro%' ".
					 " AND a.cod_pro<>'----------' ".
					 " ORDER BY a.cod_pro ASC;";
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$dataprov = $conbd->Execute ( $cadenasql );
		unset($this->conbd);
		return $dataprov;
	
	}
	
	public function buscarBancoSigecof() {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "sigesp_banco_sigecof");
		$databansig = $this->daoProveedor->leerTodos();
		unset($this->daoProveedor);
		return $databansig;
	}
	
	public function buscarDocumentosProv($cod_pro) {
		$cadenasql=" SELECT coddoc, dendoc ".
				" FROM rpc_documentos ".
				" WHERE coddoc<>'---' ".
				" AND coddoc NOT IN (SELECT coddoc ".
								"	FROM rpc_docxprov ".
								"	WHERE rpc_docxprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
								"	AND rpc_docxprov.cod_pro = '".$cod_pro."' ".
								"	AND rpc_docxprov.coddoc = rpc_documentos.coddoc) ".
				" ORDER BY coddoc ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarCalificProv($cod_pro) {
		$cadenasql=" SELECT codclas, denclas ".
				" FROM rpc_clasificacion ".
				" WHERE codclas<>'---' ".
				" AND codclas NOT IN (SELECT codclas ".
								"	FROM rpc_clasifxprov ".
								"	WHERE rpc_clasifxprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
								"	AND rpc_clasifxprov.cod_pro = '".$cod_pro."' ".
								"	AND rpc_clasifxprov.codclas = rpc_clasificacion.codclas) ".
				" ORDER BY codclas ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarNivelClasif() {
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_niveles");
		$dataclapro = $this->daoProveedor->leerTodos();
		unset($this->daoProveedor);
		return $dataclapro;
	}
	
	public function buscarTipoFondo($codemp,$codtipfon,$dentipfon) {
		$cadenasql = "SELECT codtipfon, dentipfon ".
	              " FROM scb_tipofondo ".
		          " WHERE codemp = '".$codemp."' ".
			      " AND codtipfon <>'----' ".
				  " AND codtipfon like '%".$codtipfon."%' ".
				  " AND UPPER(dentipfon) like '%".strtoupper($dentipfon)."%' ".
			      " ORDER BY codtipfon";

		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$datatipfon = $conbd->Execute ( $cadenasql );
		unset($this->conbd);
		return $datatipfon;
	}
	
	public function buscarCtaConAnt($codemp,$sc_cta,$d_deno) {
		$cadenasql = "SELECT trim(sc_cuenta) as sc_ctaant, denominacion as denominacion_2 ".
					 "FROM scg_cuentas ".
					 "WHERE codemp='{$codemp}' ".
					 "AND sc_cuenta like '{$sc_cta}%' ".
					 "AND denominacion like '%{$d_deno}%' ".
					 "AND status='C'".
					 "ORDER BY sc_cuenta";
		$conbd = ConexionBaseDatos::getInstanciaConexion();
		$datactaconant = $conbd->Execute ( $cadenasql );
		unset($conbd);
		return $datactaconant;
	}

	public function buscarPais() {
		$this->daoPais = FabricaDao::CrearDAO("N", "sigesp_pais");
		$dataPais = $this->daoPais->leerTodos();
		unset($this->daoProveedor);
		return $dataPais;
	}
	
	public function buscarEstado($restriccion) {
		$this->daoEstado = FabricaDao::CrearDAO("N", "sigesp_estados");
		$dataEstado = $this->daoEstado->buscarCampoRestriccion($restriccion);
		unset($this->daoProveedor);
		return $dataEstado;
	}
	
	public function buscarMunicipio($restriccion) {
		$this->daoMunicipio = FabricaDao::CrearDAO("N", "sigesp_municipio");
		$dataMunicipio = $this->daoMunicipio->buscarCampoRestriccion($restriccion);
		unset($this->daoProveedor);
		return $dataMunicipio;
	}
	
	public function buscarParroquia($restriccion) {
		$this->daoParroquia = FabricaDao::CrearDAO("N", "sigesp_parroquia");
		$dataParroquia = $this->daoParroquia->buscarCampoRestriccion($restriccion);
		unset($this->daoProveedor);
		return $dataParroquia;
	}
	
	public function guardarProveedor($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedor");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//insertando el registro y escribiendo en el log
		$this->daoProveedor->incluir();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 	
		}
		else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();	
		}
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		unset($this->daoRegistroEvento);
		unset($this->daoRegistroFalla);
		return $resultado;
	}
	
	public function modificarProveedor($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedor");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//modificando el registro y escribiendo en el log
		$respuesta = $this->daoProveedor->modificar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 	
		}
		else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		unset($this->daoRegistroEvento);
		return $resultado;
	}
	
	public function eliminarProveedor($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedor");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		$this->daoProveedor->eliminar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 	
		}
		else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		unset($this->daoRegistroEvento);
		return $resultado;
	}

	public function existeProveedor($codemp, $codpro)
	{
		$existe = false;
		$conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSql         = "SELECT cod_pro ".
  							 "	FROM rpc_proveedor ".
  							 " WHERE codemp ='{$codemp}' ".
							 "   AND cod_pro LIKE '%{$codpro}%'";		
		$dataSet  = $conexionBaseDatos->Execute ( $cadenaSql );
		if ($dataSet===false)
		{
			$this->mensaje .= "  ->".$conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else
		{
			if ($dataSet->_numOfRows > 0) {
				$existe = true;
			}
		}
		return $existe;
	}
	
	public function buscarProveedores($codpro,$nompro,$dirpro)
	{
		$criterio="";
		if($codpro!="")
		{
			$criterio .= " AND cod_pro like '%".$codpro."%'";
		}
		if($nompro!="")
		{
			$criterio .= " AND nompro = '".$nompro."'";
		}
		if($nompro!="")
		{
			$criterio .= " AND dirpro = '".$dirpro."'";
		}
		$cadenasql="SELECT cod_pro,nompro,sc_cuenta,rifpro FROM rpc_proveedor  ".
                " WHERE codemp = '".$_SESSION['la_empresa']['codemp']."' ".
				"   AND cod_pro <> '----------' ".
				"   AND estprov = 0 ".
				$criterio;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$dataSOC = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $dataSOC;
	}
	
	public function guardarProveedorSocios($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedorsocios");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//insertando el registro y escribiendo en el log
		$this->daoProveedor->incluir();
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function buscarSocios($codpro)
	{
		$cadenasql=" SELECT * ".
					" FROM rpc_proveedorsocios ".
					" WHERE cod_pro='".$codpro."' ".
					" ORDER BY cedsocio ASC" ;

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function eliminarProveedorSocios($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedorsocios");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		$this->daoProveedor->eliminar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
		$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		unset($this->daoRegistroEvento);
		return $resultado;
	}
	
	public function modificarProveedorSocios($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_proveedorsocios");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//modificando el registro y escribiendo en el log
		$respuesta = $this->daoProveedor->modificar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
		$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function guardarProveedorDocumentos($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_docxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//insertando el registro y escribiendo en el log
		$this->daoProveedor->incluir();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function buscarProveedorDoc($cod_pro)
	{
		
		$cadenasql=" SELECT rpc_docxprov.coddoc as coddoc, rpc_documentos.dendoc as dendoc, ".
				" rpc_docxprov.fecrecdoc as fecrecdoc, rpc_docxprov.fecvendoc, ".
				" rpc_docxprov.estdoc as estdoc, rpc_docxprov.estorig as estorig ".
				" FROM rpc_documentos, rpc_docxprov  ".		
				" WHERE rpc_documentos.codemp=rpc_docxprov.codemp ".
				" AND rpc_documentos.coddoc=rpc_docxprov.coddoc ".
				" AND rpc_documentos.codemp='".$_SESSION['la_empresa']['codemp']."' ".
				" AND cod_pro='".$cod_pro."' ";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function eliminarProveedorDocumentos($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_docxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		$this->daoProveedor->eliminar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
		$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}

	public function modificarProveedorDocumentos($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_docxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//modificando el registro y escribiendo en el log
		$respuesta = $this->daoProveedor->modificar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
		$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function guardarProveedorCalificacion($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_clasifxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//insertando el registro y escribiendo en el log
		$this->daoProveedor->incluir();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function modificarProveedorCalificacion($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_clasifxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//modificando el registro y escribiendo en el log
		$respuesta = $this->daoProveedor->modificar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
				$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoBeneficiario->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function buscarProveedorCla($cod_pro)
	{
		$cadenasql=" SELECT rpc_clasifxprov.codclas, rpc_clasificacion.denclas, ".
                 " rpc_clasifxprov.status, rpc_clasifxprov.nivstatus, rpc_niveles.codniv, ".
				 " rpc_niveles.desniv, rpc_niveles.monmincon, rpc_niveles.monmaxcon, ".
				 " rpc_clasifxprov.monfincon ".
            	 " FROM rpc_clasificacion, rpc_clasifxprov, rpc_niveles ".
		  	 	 " WHERE rpc_clasificacion.codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
			 	 " AND cod_pro= '".$cod_pro."' ".
		     	 " AND rpc_clasificacion.codemp=rpc_clasifxprov.codemp ".
		     	 " AND rpc_clasificacion.codclas=rpc_clasifxprov.codclas ".
			 	 " AND rpc_clasifxprov.codemp=rpc_niveles.codemp ".
			 	 " AND rpc_clasifxprov.codniv=rpc_niveles.codniv";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function eliminarProveedorCalif($codemp,$objson,$arrevento) {
		$resultado = 0;//variable que indica el resultado de la operacion
		
		//obteniendo las instacias de los dao's
		$this->daoProveedor = FabricaDao::CrearDAO("N", "rpc_clasifxprov");
		
		//seteando la data e iniciando transaccion de base de datos
		$this->daoProveedor->setData($objson);
		$this->daoProveedor->codemp=$codemp;
		DaoGenerico::iniciarTrans();
		
		//modificando el registro y escribiendo en el log
		$this->daoProveedor->eliminar();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		//completando la transaccion retorna 1 si no hay errores
		if (DaoGenerico::completarTrans()) {
		$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }
		
		//liberando variables y retornando el resultado de la operacion
		unset($this->daoProveedor);
		return $resultado;
	}
	
	public function buscarProveedorEspecialidades($cod_pro)
	{
		$cadenasql="SELECT rpc_espexprov.codesp, rpc_especialidad.denesp  ".
				" FROM rpc_especialidad, rpc_espexprov ".
				" WHERE rpc_espexprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
				" AND rpc_especialidad.codesp<>'---'   ".
				" AND rpc_espexprov.cod_pro = '".$cod_pro."' ".
				" AND rpc_espexprov.codesp = rpc_especialidad.codesp ".
				" ORDER BY rpc_espexprov.codesp ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarProveedorEspecialidadesDisp($cod_pro)
	{
		$cadenasql=" SELECT codesp, denesp ".
				" FROM rpc_especialidad ".
				" WHERE codesp<>'---' ".
				" AND codesp NOT IN (SELECT codesp ".
								"	FROM rpc_espexprov ".
								"	WHERE rpc_espexprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
								"	AND rpc_espexprov.cod_pro = '".$cod_pro."' ".
								"	AND rpc_espexprov.codesp = rpc_especialidad.codesp) ".
				" ORDER BY codesp ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function eliminarEspxproveedor($cod_pro)
	{
		$cadenasql=" DELETE ".
				   " FROM rpc_espexprov ".
				   " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				   " AND cod_pro='".$cod_pro."'";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function guardarProveedorEspecialidades($codemp, $arrjson, $cod_pro, $arrEvento){
		$resultado = '0';
		DaoGenerico::iniciarTrans();
		$this->eliminarEspxproveedor($cod_pro);
		$espcInsertar = $arrjson->arrEspIncluir;
		$numFueInc = count($espcInsertar);
		for ($i = 0; $i < $numFueInc; $i++) {
			$this->daoProveedor = FabricaDao::CrearDAO('N','rpc_espexprov');
			$this->daoProveedor->setData($espcInsertar[$i]);
			$this->daoProveedor->codemp = $codemp;
			$this->daoProveedor->cod_pro = $cod_pro;
			if(!$this->daoProveedor->incluir(false,'',false,0,true)){
				break;
			}
			else {
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
			}
			unset($this->daoProveedor);
		}
		
		if (DaoGenerico::completarTrans()) {
			$resultado = '1';
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}

		return $resultado;
	}

	public function buscarProveedorDeducciones($cod_pro)
	{
		$cadenasql="SELECT rpc_deduxprov.codded, sigesp_deducciones.dended  ".
				" FROM sigesp_deducciones, rpc_deduxprov ".
				" WHERE rpc_deduxprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
				" AND sigesp_deducciones.codded<>'-----'   ".
				" AND rpc_deduxprov.cod_pro = '".$cod_pro."' ".
				" AND rpc_deduxprov.codded = sigesp_deducciones.codded ".
				" ORDER BY rpc_deduxprov.codded ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}

	public function buscarProveedorDeduccionesDisp($cod_pro)
	{
		$cadenasql=" SELECT codded, dended ".
				" FROM sigesp_deducciones ".
				" WHERE codded<>'---' ".
				" AND codded NOT IN (SELECT codded ".
								"	FROM rpc_deduxprov ".
								"	WHERE rpc_deduxprov.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
								"	AND rpc_deduxprov.cod_pro = '".$cod_pro."' ".
								"	AND rpc_deduxprov.codded = sigesp_deducciones.codded) ".
				" ORDER BY codded ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function eliminarDedxproveedor($cod_pro)
	{
		$cadenasql=" DELETE ".
				   " FROM rpc_deduxprov ".
				   " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				   " AND cod_pro='".$cod_pro."'";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function guardarProveedorDeducciones($codemp, $arrjson, $cod_pro, $arrEvento){
		$resultado = '0';
		DaoGenerico::iniciarTrans();
		$this->eliminarDedxproveedor($cod_pro);
		$dedInsertar = $arrjson->arrDedIncluir;
		$numFueInc = count($dedInsertar);
		for ($i = 0; $i < $numFueInc; $i++) {
			$this->daoProveedor = FabricaDao::CrearDAO('N','rpc_deduxprov');
			$this->daoProveedor->setData($dedInsertar[$i]);
			$this->daoProveedor->codemp = $codemp;
			$this->daoProveedor->cod_pro = $cod_pro;
			if(!$this->daoProveedor->incluir(false,'',false,0,true)){
				break;
			}
			else {
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
			}
			unset($this->daoProveedor);
		}
		
		if (DaoGenerico::completarTrans()) {
			$resultado = '1';
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		 else{
			$arrevento ['desevetra'] = $this->daoProveedor->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		 }

		return $resultado;
	}
	
	public function buscarDenomEstado($codpai)
	{
		$cadenasql=" SELECT codest, desest ".
				" FROM sigesp_estados ".
				" WHERE codpai='".$codpai."' ".
				" ORDER BY codest ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarDenomMunicipio($codpai,$codest)
	{
		$cadenasql=" SELECT codmun, denmun ".
				" FROM sigesp_municipio ".
				" WHERE codpai='".$codpai."' ".
				" AND codest='".$codest."' ".
				" ORDER BY codmun ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarDenomParroquia($codpai,$codest,$codmun)
	{
		$cadenasql=" SELECT codpar, denpar ".
				" FROM sigesp_parroquia ".
				" WHERE codpai='".$codpai."' ".
				" AND codest='".$codest."' ".
				" AND codmun='".$codmun."' ".
				" ORDER BY codpar ASC"; 

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;
	}
	
	public function buscarAfectaciones($tipoope,$reservado,$seleccionado)
	{
		$arrDenominacion = array();
		if(($tipoope=='ND') || ($tipoope=='CH')){
			$ls_sql="SELECT operacion,denominacion,asignar,aumento,disminucion,precomprometer, ".
			        "       comprometer,causar,pagar,reservado  ".
			        "FROM spg_operaciones  ".
					"WHERE reservado = $reservado ORDER BY operacion";
			$conexionbd = ConexionBaseDatos::getInstanciaConexion();
			$resultado = $conexionbd->Execute($ls_sql);
			if($resultado==false){
				$this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarAfectaciones ERROR->'.$conexionbd->ErrorMsg();
				$this->valido = false;
			}
			else{
				$i=0;
				while(!$resultado->EOF){
					if((trim($resultado->fields['operacion'])=='CCP') || (trim($resultado->fields['operacion'])=='PG'))
					{
						 $arrDenominacion[$i]['denominacion']=$resultado->fields['denominacion'];
						 $arrDenominacion[$i]['operacion']=$resultado->fields['operacion'];
						 $i++;
					}
					$resultado->MoveNext();
				}
			}
		}
		elseif(($tipoope=='NC') || ($tipoope=='DP')){
			$ls_sql="SELECT operacion,denominacion,previsto,aumento,disminucion,devengado, ".
					"       cobrado,cobrado_ant,reservado  ".
			        "FROM spi_operaciones  ".
 				    "WHERE reservado = $reservado ORDER BY operacion";
			$conexionbd = ConexionBaseDatos::getInstanciaConexion();
			$resultado = $conexionbd->Execute($ls_sql);
			if($resultado==false){
				$this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarAfectaciones ERROR->'.$conexionbd->ErrorMsg();
				$this->valido = false;
			}
			else{
				$i=0;
				while(!$resultado->EOF){
					if((trim($resultado->fields['operacion'])=='COB') || (trim($resultado->fields['operacion'])=='DC'))
					{
						 $arrDenominacion[$i]['denominacion']=$resultado->fields['denominacion'];
						 $arrDenominacion[$i]['operacion']=$resultado->fields['operacion'];
						 $i++;
					}
					$resultado->MoveNext();
				}
			}
		}	
		
		return $arrDenominacion;
	}
	
	//Metodos desarrollados por Maryoly
	public function buscarCtasCont($codemp,$cuenta,$denominacion)
	{
		$cadenasql = " 	SELECT 	trim(sc_cuenta) as sc_cuenta, max(denominacion) as denominacion, ". 
					 " 			max(status) as status ".
					 " 	FROM scg_cuentas ".
					 " 	WHERE codemp='".$codemp."' ".
					 "    AND sc_cuenta like '".$cuenta."%'  ".
					 "    AND denominacion like '%".$denominacion."%'  ".
					 "    AND status='C' ".
				 	 " 	GROUP BY sc_cuenta  ".
				 	 " 	ORDER BY sc_cuenta ASC";
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute($cadenasql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarCtasCont ERROR->'.$conexionbd->ErrorMsg();
			$this->valido = false;
		}
		return $resultado;
	}
	
	public function buscarCtasIng($ls_codemp,$li_estpreing,$ls_codestpro1,$ls_codestpro2,
								  $ls_codestpro3,$ls_codestpro4,$ls_codestpro5,$ls_estcla,
								  $li_estmodest,$ls_spicta,$ls_denspicta,$ls_scgcta)
	{
	
	 $ls_sqlaux = $ls_straux = "";
	 if($li_estpreing==1)
	   {
		  $ls_straux = ", spi_cuentas_estructuras, spg_ep5";
		  $ls_codestpro1 = str_pad($ls_codestpro1,25,0,0);
		  $ls_codestpro2 = str_pad($ls_codestpro2,25,0,0);
		  $ls_codestpro3 = str_pad($ls_codestpro3,25,0,0);	
		  if ($li_estmodest==2)
			 {  
			   $ls_codestpro4 = str_pad($ls_codestpro4,25,0,0);
			   $ls_codestpro5 = str_pad($ls_codestpro5,25,0,0);
			 }		
		  elseif($li_estmodest==1)
		     {
			   $ls_codestpro4 = $ls_codestpro5 = str_pad("",25,0,0);
			 }
		  $ls_sqlaux = " AND spi_cuentas_estructuras.codestpro1 = '".$ls_codestpro1."'  ".
				      "  AND spi_cuentas_estructuras.codestpro2 = '".$ls_codestpro2."'  ".
					  "	 AND spi_cuentas_estructuras.codestpro3 = '".$ls_codestpro3."'  ".
					  "	 AND spi_cuentas_estructuras.codestpro4 = '".$ls_codestpro4."'  ".
					  "	 AND spi_cuentas_estructuras.codestpro5 = '".$ls_codestpro5."'  ".
					  "	 AND spi_cuentas_estructuras.estcla = '".$ls_estcla."' ".
					  "	 AND spi_cuentas.codemp=spi_cuentas_estructuras.codemp  ".
					  "  AND spi_cuentas.spi_cuenta=spi_cuentas_estructuras.spi_cuenta  ".
					  "	 AND TRIM(spi_cuentas.codemp)=TRIM(spi_cuentas_estructuras.codemp) ".
					  "	 AND spi_cuentas_estructuras.codemp = spg_ep5.codemp  ".
					  "  AND spi_cuentas_estructuras.codestpro1 = spg_ep5.codestpro1  ".
					  "  AND spi_cuentas_estructuras.codestpro2 = spg_ep5.codestpro2  ".
					  "  AND spi_cuentas_estructuras.codestpro3 = spg_ep5.codestpro3  ".
					  "  AND spi_cuentas_estructuras.codestpro4 = spg_ep5.codestpro4   ".
					  "  AND spi_cuentas_estructuras.codestpro5 = spg_ep5.codestpro5   ".
					  "  AND spi_cuentas_estructuras.estcla = spg_ep5.estcla";
		}
	 $ls_sql ="SELECT DISTINCT TRIM(spi_cuentas.spi_cuenta) as spi_cuenta, ".
	          "       spi_cuentas.denominacion,spi_cuentas.status,  ".
			  "	      (spi_cuentas.previsto+spi_cuentas.aumento-spi_cuentas.disminucion) as disponible,  ".
	          "       TRIM(spi_cuentas.sc_cuenta) as sc_cuenta  ".
			  "FROM spi_cuentas $ls_straux  ". 
		   	  "WHERE spi_cuentas.codemp = '".$ls_codemp."'  ".
			  "	 AND spi_cuentas.spi_cuenta like '".$ls_spicta."%'  ".
			  "  AND UPPER(spi_cuentas.denominacion) like '%".strtoupper($ls_denspicta)."%'  ".
			  "  AND spi_cuentas.sc_cuenta like '".$ls_scgcta."%' $ls_sqlaux  ".
			  "  AND spi_cuentas.status='C' ".
			  "ORDER BY spi_cuenta ASC"; //print $ls_sql;

	 $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	 $resultado = $conexionbd->Execute($ls_sql);
	 if($resultado===false)
		{
			$this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarCtasIng ERROR->'.$conexionbd->ErrorMsg();
			$this->valido = false;
		}
	return $resultado;
	}

	public function buscarCtasGas($codemp,$li_estmodest,$ls_spgcta,$ls_denctaspg,$ls_scgcta,$ls_codestpro1,
	                              $ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,$ls_estcla){
		$ls_sqlaux = "";
	 	if($li_estmodest==2)
	    {
		  	$ls_sqlaux = " AND codestpro4='".$ls_codestpro4."' AND codestpro5='".$ls_codestpro5."'";
	    }
	
	 	$ls_sql = "SELECT codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla,  ".
	              "       TRIM(spg_cuenta) as spg_cuenta,denominacion,TRIM(sc_cuenta) as sc_cuenta,status  ".
	              "FROM spg_cuentas   ".																                
			      "WHERE codemp = '".$codemp."'  ".
			      "  AND spg_cuenta like '".$ls_spgcta."%'  ".
			      "  AND denominacion like '%".$ls_denctaspg."%'  ".
			      "  AND sc_cuenta like '".$ls_scgcta."%'  ".
			      "  AND codestpro1='".$ls_codestpro1."'   ".
			      "  AND codestpro2='".$ls_codestpro2."'   ".
			      "  AND codestpro3='".$ls_codestpro3."' $ls_sqlaux  ".
				  "  AND estcla='".$ls_estcla."'   ".
			      "ORDER BY spg_cuenta";
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute($ls_sql);
	  if($resultado===false)
	  {
		  $this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarCtasGas ERROR->'.$conexionbd->ErrorMsg();
		  $this->valido = false;
	  }
	  return $resultado;
	}
	
	public function buscarMovBco($codemp,$documento,$fecdesde,$fechasta,$codope,$tipo,$provben,$estmov,
	                             $opener,$cartaorden)
	{
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$cadenaFiltro='';
		if((!empty($fecdesde)) && (!empty($fechasta)))
		{
			$fecdesde=convertirFechaBd($fecdesde);
			$fechasta=convertirFechaBd($fechasta);
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.fecmov>='".$fecdesde."' AND scb_movbco.fecmov<='".$fechasta."'";
		}
		if(!empty($documento)){
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.numdoc like '%".$documento."%' "; 
		}
		if(!empty($codope))
		{
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.codope ='".$codope."'";
		}
		if(($tipo=="P")&&($provben!=""))
		{
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.cod_pro like '".$provben."'";
		}
		if(($tipo=="B")&&($provben!=""))
		{
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.ced_bene like'".$provben."'";
		}
		if(!empty($estmov))
		{
			$cadenaFiltro=$cadenaFiltro." AND scb_movbco.estmov='".$estmov."'";
		}
		$ls_sql = "SELECT scb_movbco.codemp,scb_movbco.codban,scb_movbco.ctaban,scb_movbco.numdoc,scb_movbco.numordpagmin, ".
 		          "       scb_movbco.codope,scb_movbco.estmov,scb_movbco.cod_pro,scb_movbco.ced_bene, ".
				  "	      scb_movbco.tipo_destino,scb_movbco.codconmov,scb_movbco.fecmov,scb_movbco.conmov, ".
				  "       scb_movbco.nomproben,scb_movbco.monto,scb_movbco.estcon,scb_movbco.estcobing, ".
				  "	      scb_movbco.chevau,scb_movbco.estimpche,scb_movbco.monobjret,scb_movbco.monret, ".
				  " 	  scb_movbco.procede,scb_movbco.estmovint,scb_movbco.numcarord,scb_banco.nomban, scb_movbco.estmodordpag, ".
				  "	      scb_ctabanco.dencta,scb_ctabanco.sc_cuenta,scb_cheques.numchequera,scb_movbco.codtipfon,scb_movbco.estmovcob, ".
		          "       scb_movbco.numconint,scb_movbco.tranoreglib,scb_movbco.conanu, ".
				  "	      (SELECT MAX(codfuefin) ".
				  "	       FROM scb_movbco_fuefinanciamiento ".
				  "	       WHERE codemp = scb_movbco.codemp ".
				  "		     AND codban = scb_movbco.codban ".
				  "		     AND ctaban = scb_movbco.ctaban ".
				  "		     AND numdoc = scb_movbco.numdoc ".
				  "		     AND codope = scb_movbco.codope ".
				  "		     AND estmov = scb_movbco.estmov) AS codfuefin, ".
		          "       (SELECT scb_tipofondo.dentipfon  ".
				  "	       FROM scb_tipofondo   ".
				  "	       WHERE scb_tipofondo.codemp=scb_movbco.codemp  ". 
				  "		     AND scb_tipofondo.codtipfon=scb_movbco.codtipfon) as dentipfon ".
				  "FROM scb_movbco  ". 
				  "LEFT JOIN scb_cheques  ".
				  "    ON scb_movbco.codemp=scb_cheques.codemp  ".
				  "   AND scb_movbco.codban=scb_cheques.codban  ".
				  "   AND scb_movbco.ctaban=scb_cheques.ctaban  ".
				  "   AND scb_movbco.numdoc=scb_cheques.numche, scb_banco, scb_ctabanco ".
				  "WHERE scb_movbco.codemp='".$codemp."'  {$cadenaFiltro}  ".
				  "	 AND scb_movbco.codope<>'OP'  ".
				  "	 AND scb_movbco.codemp=scb_banco.codemp ".
				  "	 AND scb_movbco.codban=scb_banco.codban ".
				  "	 AND scb_movbco.codemp=scb_ctabanco.codemp ".
				  "	 AND scb_movbco.codban=scb_ctabanco.codban ".
				  "	 AND scb_movbco.ctaban=scb_ctabanco.ctaban  ".
		          "ORDER BY scb_movbco.fecmov ASC,scb_movbco.numdoc ASC";
		
//		if($opener=='sigesp_scb_p_pago_directo.php')
//		{
//			$ls_sql=$ls_sql." AND scb_movbco.estbpd='D'";
//		}
//		if ($cartaorden!="%%") {
//			$ls_sql=$ls_sql." AND scb_movbco.numcarord like '".$cartaorden."'";;
//		}
		$resultado = $conexionbd->Execute($ls_sql);
	    if($resultado===false)
	    {
		    $this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->buscarMovBco ERROR->'.$conexionbd->ErrorMsg();
		    $this->valido = false;
	    }
	    return $resultado;
	}
	
	public function cargar_detscg($codemp,$numdoc,$codban,$ctaban,$codope,$estmov)
	{
		$sql = "SELECT codban,ctaban,codope,estmov,scg_cuenta,codded,debhab,documento,  ".
		       "       desmov,procede_doc,monto,monobjret  ".
			   "FROM scb_movbco_scg  ".
			   "WHERE codemp='".$codemp."'  ".
			   "  AND numdoc ='".$numdoc."'   ".
			   "  AND codban='".$codban."'   ".
			   "  AND ctaban='".$ctaban."'  ".
			   "  AND codope='".$codope."'   ".
			   "  AND estmov='".$estmov."'	".
			   "ORDER BY debhab,numdoc ASC"; //print $ls_sql;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	    $resultado = $conexionbd->Execute($sql);
		if($resultado===false)
	    {
		    $this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->cargar_detscg ERROR->'.$conexionbd->ErrorMsg();
		    $this->valido = false;
	    }
	    return $resultado;
	}
	
	public function cargar_detspg($codemp,$numdoc,$codban,$ctaban,$codope,$estmov)
	{
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$ls_modalidad=$_SESSION["la_empresa"]["estmodest"];
		switch($ls_modalidad)
		{
			case "1": // Modalidad por Proyecto
				$codest1 = "SUBSTR(SUBSTR(codestpro,1,25),25-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(SUBSTR(codestpro,26,25),25-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(SUBSTR(codestpro,51,25),25-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$cadenaEstructura = $conexionbd->Concat($codest1,"'-'",$codest2,"'-'",$codest3);
				break;
				
			case "2": // Modalidad por Programatica
				$codest1 = "SUBSTR(SUBSTR(codestpro,1,25),25-{$_SESSION["la_empresa"]["loncodestpro1"]})";
				$codest2 = "SUBSTR(SUBSTR(codestpro,26,25),25-{$_SESSION["la_empresa"]["loncodestpro2"]})";
				$codest3 = "SUBSTR(SUBSTR(codestpro,51,25),25-{$_SESSION["la_empresa"]["loncodestpro3"]})";
				$codest4 = "SUBSTR(SUBSTR(codestpro,76,25),25-{$_SESSION["la_empresa"]["loncodestpro4"]})";
				$codest5 = "SUBSTR(SUBSTR(codestpro,101,25),25-{$_SESSION["la_empresa"]["loncodestpro5"]})";
				$cadenaEstructura = $conexionbd->Concat($codest1,"'-'",$codest2,"'-'",$codest3,"'-'",$codest4,"'-'",$codest5);
				break;
		}
		$sql = "SELECT {$cadenaEstructura} AS estructura,SUBSTR(codestpro,1,25) as codestpro1, ".
			   "       SUBSTR(codestpro,26,25) as codestpro2, SUBSTR(codestpro,51,25) as codestpro3, ".
			   "       SUBSTR(codestpro,76,25) as codestpro4, SUBSTR(codestpro,101,25) as codestpro5, ".
			   "       estcla,codban,ctaban,estmov,operacion,codestpro,  ".
		       "       spg_cuenta,documento,desmov,procede_doc,monto  ".
			   "FROM scb_movbco_spg  ".
			   "WHERE codemp='".$codemp."'  ".
			   "  AND numdoc ='".$numdoc."'   ".
			   "  AND codban='".$codban."'   ".
			   "  AND ctaban='".$ctaban."'  ".
			   "  AND codope='".$codope."'   ".
			   "  AND estmov='".$estmov."'	".
			   "ORDER BY numdoc ASC"; //print $ls_sql;
	    $resultado = $conexionbd->Execute($sql);
		if($resultado===false)
	    {
		    $this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->cargar_detspg ERROR->'.$conexionbd->ErrorMsg();
		    $this->valido = false;
	    }
	    return $resultado;
	}
	
	public function cargar_detspi($codemp,$numdoc,$codban,$ctaban,$codope,$estmov)
	{
		$sql = "SELECT codban,ctaban,estmov,operacion,TRIM(spi_cuenta) as spi_cuenta,documento,  ".
		       "       desmov,procede_doc,monto,codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla ".
			   "FROM scb_movbco_spi  ".
			   "WHERE codemp='".$codemp."'  ".
			   "  AND numdoc ='".$numdoc."'   ".
			   "  AND codban='".$codban."'   ".
			   "  AND ctaban='".$ctaban."'  ".
			   "  AND codope='".$codope."'   ".
			   "  AND estmov='".$estmov."'	".
			   "ORDER BY numdoc ASC"; //print $ls_sql;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
	    $resultado = $conexionbd->Execute($sql);
		if($resultado===false)
	    {
		    $this->mensaje .= ' CLASE->Movimiento Banco MÉTODO->cargar_detspi ERROR->'.$conexionbd->ErrorMsg();
		    $this->valido = false;
	    }
	    return $resultado;
	}
	
	public function guardar_movbco($codemp,$objson,$arrevento)
	{
		$arrCabeceraScb=array();
		$arrDetalleScg=array();
		$arrDetalleSpg=array();
		$arrDetalleSpi=array();
		$arrDetScg = $objson->detallesScg;
		$arrDetSpg = $objson->detallesSpg;
		$arrDetSpi = $objson->detallesSpi;
		$li_cont_dtscg = 0;
		$li_cont_dtspg = 0;
		$li_cont_dtspi = 0;
		$ls_nomproben = $objson->nomproben;
		$ls_chevau = $objson->chevau;
		$ls_numconint = "";
		$ls_modalidad=$_SESSION["la_empresa"]["estmodest"];
		if($objson->tipo_destino=='P')
		{
			$ls_codpro=$objson->cod_pro;
			$ls_cedbene="----------";
		}
		else
		{
			$ls_codpro="----------";
			$ls_cedbene=$objson->ced_bene;
		}
		$ls_procede='SCBMOV';
		if($objson->codope=="DP" || $objson->codope=="ND" || $objson->codope=="NC"){
			$ls_numconint = $objson->numconint;
		}
		if($objsoncodope=="DP")
		{
			$ls_procede='SCBBDP';
		}
		if($objsoncodope=="DP"){
			$ls_procede='SCBBCH';
		}
		if(($objson->codope=="CH")&&($objson->chevau!=""))
		{
		     $ls_chevau= str_pad($ls_chevau,25,"0",STR_PAD_LEFT);
		}
		if (strlen($objson->nomproben)>100)
		{
			$ls_nomproben=substr($ls_nomproben,0,100);
		}
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		$servicioEvento = new ServicioEvento();
		$arrCabeceraScb["codemp"]	 = $codemp;
		$arrCabeceraScb["codban"]	 = $objson->codban;
		$arrCabeceraScb["ctaban"]	 = $objson->ctaban;
		$arrCabeceraScb["numdoc"]	 = $objson->numdoc;
		$arrCabeceraScb["codope"]	 = $objson->codope;
		$arrCabeceraScb["fecmov"]	 = convertirFechaBd($objson->fecmov);
		$arrCabeceraScb["conmov"]	 = $objson->conmov;
		$arrCabeceraScb["codconmov"] = $objson->codtipcon;
		$arrCabeceraScb["cod_pro"]	 = $ls_codpro;
		$arrCabeceraScb["ced_bene"]	 = $ls_cedbene;
		$arrCabeceraScb["nomproben"] = $ls_nomproben;
		$arrCabeceraScb["monto"]	 = $objson->monto;
		$arrCabeceraScb["monobjret"] = $objson->monobjret;
		$arrCabeceraScb["monret"]	 = $objson->monret;
		$arrCabeceraScb["chevau"]	 = $ls_chevau;
		$arrCabeceraScb["estmov"]	 = $objson->estmov;
		$arrCabeceraScb["estmovint"] = $objson->estmovint;
		$arrCabeceraScb["estcobing"] = 1;
		$arrCabeceraScb["estbpd"]	 = $objson->estbpd;
		$arrCabeceraScb["procede"]	 = $ls_procede;
		$arrCabeceraScb["estreglib"] = "";
		$arrCabeceraScb["tipo_destino"]	 = $objson->tipo_destino;
		$arrCabeceraScb["numordpagmin"]	 = $objson->numordpagmin;
		$arrCabeceraScb["codfuefin"] = $objson->hidcodfuefin;
		$arrCabeceraScb["codtipfon"] = $objson->codtipfon;
		$arrCabeceraScb["estmovcob"] = $objson->estmovcob;
		$arrCabeceraScb["numconint"] = $ls_numconint;
		$arrCabeceraScb["tranoreglib"] = $objson->tranoreglib;
		$arrCabeceraScb["numchequera"] = "";
		$arrCabeceraScb["codbansig"] = "";
		
		if(count($arrDetScg)!=0){
			foreach($arrDetScg as $detallescg){
				$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]  = $detallescg->scg_cuenta;
				$arrDetalleScg["procede_doc"][$li_cont_dtscg] = $detallescg->procede_doc;
				$arrDetalleScg["desmov"][$li_cont_dtscg]	  = $detallescg->desmov;
				$arrDetalleScg["documento"][$li_cont_dtscg]	  = $detallescg->documento;
				$arrDetalleScg["debhab"][$li_cont_dtscg]	  = $detallescg->debhab;
				$arrDetalleScg["monto"][$li_cont_dtscg]	 	  = formatoNumericoBd($detallescg->monto,1);
				$arrDetalleScg["monobjret"][$li_cont_dtscg]	  = formatoNumericoBd($detallescg->monto,1);
				$arrDetalleScg["codded"][$li_cont_dtscg]	  = $detallescg->codded;
				$li_cont_dtscg++;
			}
		}
		
		if(count($arrDetSpg)!=0){
			foreach($arrDetSpg as $detallespg){
				switch($ls_modalidad)
				{
					case "1": // Modalidad por Proyecto
						$codest1 = str_pad($detallespg->codestpro1,25,0,0);
						$codest2 = str_pad($detallespg->codestpro2,25,0,0);
						$codest3 = str_pad($detallespg->codestpro3,25,0,0);
						$codest4 = '0000000000000000000000000';
						$codest5 = '0000000000000000000000000';
						$cadena = $codest1.$codest2.$codest3.$codest4.$codest5;
						break;
						
					case "2": // Modalidad por Programatica
						$codest1 = str_pad($detallespg->codestpro1,25,0,0);
						$codest2 = str_pad($detallespg->codestpro2,25,0,0);
						$codest3 = str_pad($detallespg->codestpro3,25,0,0);
						$codest4 = str_pad($detallespg->codestpro4,25,0,0);
						$codest5 = str_pad($detallespg->codestpro5,25,0,0);
						$cadena = $codest1.$codest2.$codest3.$codest4.$codest5;
						break;
				} 
				$arrDetalleSpg["codestpro"][$li_cont_dtspg]	  = $cadena;
				$arrDetalleSpg["spgcuenta"][$li_cont_dtspg]   = $detallespg->spgcuenta;
				$arrDetalleSpg["desmov"][$li_cont_dtspg]	  = $detallespg->desmov;
				$arrDetalleSpg["documento"][$li_cont_dtspg]	  = $detallespg->documento;
				$arrDetalleSpg["procede_doc"][$li_cont_dtspg] = $detallespg->procede_doc;
				$arrDetalleSpg["monto"][$li_cont_dtspg]	 	  = formatoNumericoBd($detallespg->monto,1);
				$arrDetalleSpg["operacion"][$li_cont_dtspg]	  = $detallespg->operacion;
				$arrDetalleSpg["estcla"][$li_cont_dtspg]	  = $detallespg->estcla;
				$arrDetalleSpg["codfuefin"][$li_cont_dtspg]	  = $detallespg->codfuefin;
				$li_cont_dtspg++;
			}
		}
		
		if($arrDetSpi!=0){
			foreach($arrDetSpi as $detallespi){
				$arrDetalleSpi["codestpro1"][$li_cont_dtspi]  = $detallespi->codestpro1;
				$arrDetalleSpi["codestpro2"][$li_cont_dtspi]  = $detallespi->codestpro2;
				$arrDetalleSpi["codestpro3"][$li_cont_dtspi]  = $detallespi->codestpro3;
				$arrDetalleSpi["codestpro4"][$li_cont_dtspi]  = $detallespi->codestpro4;
				$arrDetalleSpi["codestpro5"][$li_cont_dtspi]  = $detallespi->codestpro5;
				$arrDetalleSpi["spicuenta"][$li_cont_dtspi]	  = $detallespi->spicuenta;
				$arrDetalleSpi["documento"][$li_cont_dtspi]	  = $detallespi->documento;
				$arrDetalleSpi["desmov"][$li_cont_dtspi]	  = $detallespi->desmov;
				$arrDetalleSpi["procede_doc"][$li_cont_dtspi] = $detallespi->procede_doc;
				$arrDetalleSpi["monto"][$li_cont_dtspi]	 	  = formatoNumericoBd($detallespi->monto,1);
				$arrDetalleSpi["operacion"][$li_cont_dtspi]	  = $detallespi->operacion;
				$arrDetalleSpi["estcla"][$li_cont_dtspi]	  = $detallespi->estcla;
				$arrDetalleSpi["codfuefin"][$li_cont_dtspi]	  = $detallespi->codfuefin;
				$li_cont_dtspi++;
			}
		}
		if(!$objson->actualizar){
			$servicioBancario = new ServicioMovimientoScb();
			$this->valido = $servicioBancario->GuardarAutomatico($arrCabeceraScb,$arrDetalleScg,$arrDetalleSpg,$arrDetalleSpi,$arrevento);
			$this->mensaje.= $servicioBancario->mensaje;
		}
		if($objson->actualizar){
			$this->valido=$this->eliminarMovBco($codemp,$objson,$arrevento);
			if($this->valido){
				$servicioBancario = new ServicioMovimientoScb();
				$this->valido = $servicioBancario->GuardarAutomatico($arrCabeceraScb,$arrDetalleScg,$arrDetalleSpg,$arrDetalleSpi,$arrevento);
				$this->mensaje.= $servicioBancario->mensaje;
			}
		}
		if (DaoGenerico::completarTrans($this->valido)) 
		{
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$this->valido=true; 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->mensaje;
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$this->valido=false;
		} 
		return $this->valido;	 
	}
	
	function eliminar($codemp,$tabla,$numdoc,$codban,$ctaban,$codope,$estmov)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		$this->valido = true;
		
		$SQL = "SELECT codemp FROM {$tabla}  ".
			   "WHERE codemp='".$codemp."' ".
		       "  AND numdoc ='".$numdoc."'   ".
			   "  AND codban='".$codban."'   ".
			   "  AND ctaban='".$ctaban."'  ".
			   "  AND codope='".$codope."'   ".
			   "  AND estmov='".$estmov."'  ";
		$data = $this->conexionBaseDatos->Execute($SQL);
		if($data === false){
			$this->mensaje .= '  CLASE->Movimiento Banco MÉTODO->eliminar ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		else{
			if($data->fields['codemp']!=''){
				$cadenaSQL = "DELETE FROM {$tabla}  ".
					" 	  WHERE codemp='".$codemp."' ".
					"       AND numdoc ='".$numdoc."'   ".
					"       AND codban='".$codban."'   ".
					"       AND ctaban='".$ctaban."'  ".
					"       AND codope='".$codope."'   ".
					"       AND estmov='".$estmov."'  ";
				$datos = $this->conexionBaseDatos->Execute($cadenaSQL);
				if($datos === false){
					$this->mensaje .= '  CLASE->Movimiento Banco MÉTODO->eliminar ERROR->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}
			}
		}
		return $this->valido;
	}
	
	public function validaFechaPeriodo($as_fecha,$as_codemp)
	{
	    $li_ano    = 0 ; $li_mes=0;$li_ano_periodo=0;$li_mes_periodo=0;
	    $ls_fecha  = ""; $ls_periodo_final=""; 
	    $lb_valido = true;
   	    //$as_fecha=$this->uf_convert_date_to_db($as_fecha);
	    $li_ano = intval(substr($as_fecha,0,4));
	    $li_mes = intval(substr($as_fecha,5,2));
	    $li_ano_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],0,4));
	    $li_mes_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],5,2));
	    $ld_periodo_final = "31/12/".$li_ano_periodo;
		if ($li_ano == $li_ano_periodo)
		{
			if($li_mes >= $li_mes_periodo)
			{
			   if($this->uf_valida_fecha_mes( $as_codemp, $as_fecha ))
			   {
			 	  $lb_valido = true;
			   }
			   else	 
			   {
				  $lb_valido = false;
			 	  //$this->is_msg_error = "Mes no esta Abierto";
				  return false;
			   }
			} 			
			else {  $lb_valido = false;	}
		}
		else 
		{ 
			$lb_valido = false;	
		}
		return $lb_valido;	
	} // end function()
	
	public function uf_valida_fecha_mes($as_codemp,$as_fecha)
 	{ 
		 $li_mes=0;$li_M01=0;$li_M02=0;$li_M03=0;$li_M04=0;$li_M05=0;
		 $li_M06=0;$li_M07=0;$li_M08=0;$li_M09=0;$li_M10=0;$li_M11=0;$li_M12=0;
		 $lb_abierto_mes=false;
		 $lb_valido=false;
		 $ls_cadena="";
		 $li_mes = intval(substr($as_fecha,5,2));
		 $cadenasql=" SELECT m01,m02,m03,m04,m05,m06,m07,m08,m09,m10,m11,m12 ". 
		 			" FROM sigesp_empresa WHERE codemp = '".$as_codemp."' ";
		 $conexionbd = ConexionBaseDatos::getInstanciaConexion();
		 $resultado = $conexionbd->Execute ( $cadenasql );
		 if ($resultado===false)
		 {
	 		 $mensaje .= '  ->'.$conexionbd->ErrorMsg();
		 }
		 else
		 {
			$lb_valido=true;
			while((!$resultado->EOF))
			{
				$li_M01=$resultado->fields["m01"];
				$li_M02=$resultado->fields["m02"];
				$li_M03=$resultado->fields["m03"];
				$li_M04=$resultado->fields["m04"];
				$li_M05=$resultado->fields["m05"];
				$li_M06=$resultado->fields["m06"];
				$li_M07=$resultado->fields["m07"];
				$li_M08=$resultado->fields["m08"];
				$li_M09=$resultado->fields["m09"];
				$li_M10=$resultado->fields["m10"];
				$li_M11=$resultado->fields["m11"];
				$li_M12=$resultado->fields["m12"];
				$resultado->MoveNext();
			}
		 } 
		 if ($lb_valido)
		 {
			switch ($li_mes)
			{
				case 1:
					if($li_M01==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 2:
					if($li_M02==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 3:
					if($li_M03==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 4:
					if($li_M04==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 5:
					if($li_M05==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 6:
					if($li_M06==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 7:
					if($li_M07==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 8:
					if($li_M08==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 9:
					if($li_M09==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 10:
					if($li_M10==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 11:
					if($li_M11==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 12:
					if($li_M12==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				default:
			}
		 }	
		 if (!$lb_abierto_mes)
		 {
		   	 //$this->is_msg_error = "El Mes ".$li_mes." no esta abierto.";
			 $lb_valido = false;
		 }
		 unset($conexionbd);
		 unset($resultado);
		 return $lb_valido;
    } // end fuction
	
	public function eliminarMovBco($codemp,$objson,$arrevento)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		if($this->validaFechaPeriodo(convertirFechaBd($objson->fecmov), $codemp)){
			DaoGenerico::iniciarTrans();
			//obteniendo las instacias de los dao's
			$this->daoBanco = FabricaDao::CrearDAO("N","scb_movbco");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoBanco->setData($objson);
			$this->daoBanco->codemp=$codemp;
			if($this->eliminar($codemp,'scb_movbco_scg',$objson->numdoc,$objson->codban,$objson->ctaban,$objson->codope,$objson->estmov)){
				if($this->eliminar($codemp,'scb_movbco_spg',$objson->numdoc,$objson->codban,$objson->ctaban,$objson->codope,$objson->estmov)){
					if($this->eliminar($codemp,'scb_movbco_spi',$objson->numdoc,$objson->codban,$objson->ctaban,$objson->codope,$objson->estmov)){
						if($this->eliminar($codemp,'scb_movbco_fuefinanciamiento',$objson->numdoc,$objson->codban,$objson->ctaban,$objson->codope,$objson->estmov)){
							$this->valido=$this->daoBanco->eliminar();
						}
					}
					else{
						$this->mensaje .= ' Ocurrio un error al eliminar los detalles de ingreso';
						$this->valido = false;
					}
				}
				else{
					$this->mensaje .= ' Ocurrio un error al eliminar los detalles presupuestarios';
					$this->valido = false;
				}
			}
			else{
				$this->mensaje .= ' Ocurrio un error al eliminar los detalles contables';
				$this->valido = false;
			}
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
		
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();	 		
			}
			else{
				$arrevento ['desevetra'] = $this->mensaje;
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
		}
		else{
			$this->mensaje .= '  Verifique que el periodo y el mes de la empresa estén abiertos '.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}
	
		public function buscarFuenteFinanciamiento($codemp, $codestpro1, $codestpro2, $codestpro3, $codestpro4, $codestpro5, $estcla, $origen_catalogo) {
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();

		$cadenaFiltro = "AND spg_dt_fuentefinanciamiento.codestpro1 like '%{$codestpro1}%'   ". 
					"		AND spg_dt_fuentefinanciamiento.codestpro2 like '%{$codestpro2}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro3 like '%{$codestpro3}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro4 like '%{$codestpro4}%'   ".
					"		AND spg_dt_fuentefinanciamiento.codestpro5 like '%{$codestpro5}%'   ".
					"		AND spg_dt_fuentefinanciamiento.estcla like '%{$estcla}%'           ";
		$cadfil = '';
			
		$cadenaSQL = "SELECT sigesp_fuentefinanciamiento.codfuefin,sigesp_fuentefinanciamiento.denfuefin ".
				"	  FROM sigesp_fuentefinanciamiento,spg_dt_fuentefinanciamiento ". 
				"	  WHERE sigesp_fuentefinanciamiento.codemp = '{$codemp}'  ".
				"		AND sigesp_fuentefinanciamiento.codemp=spg_dt_fuentefinanciamiento.codemp  ".
				"		AND sigesp_fuentefinanciamiento.codfuefin=spg_dt_fuentefinanciamiento.codfuefin  ".
				"		{$cadenaFiltro}   ".
				"	    AND spg_dt_fuentefinanciamiento.codfuefin<>'--'  {$cadfil}".
		        "     ORDER BY sigesp_fuentefinanciamiento.codfuefin ASC ";           
		return $this->conexionBaseDatos->Execute($cadenaSQL);
	}

	
//	public function completarNumordpagmin($numordpagmin)
//	{
//		$numero = 0;
//		$numero = str_pad($numordpagmin,15,0,0);
//		return $numero;
//	}
}
?>