<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_imodcmpret.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");

require_once($dirsrvscb."/shared/class_folder/class_datastore.php");

/**
 * @author Ing. Gerardo Cordero
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioEdiComRet implements imodcmpret 
{
	private $daoDocumentos;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	private $daoComprobante;
	private $conexionBaseDatos;
	private $daoCambioEstatus;
	private $daoDetalle; 
	public  $mensaje; 
	public  $valido; 
	
	public function servicioDocumento() 
	{
		$this->daoDocumentos = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->daoComprobante = null;
		$this->mensaje = '';
		$this->valido = true;
		$this->daoDetalle = null;
		$this->daoCambioEstatus = null;    
	}
	
	public function buscar_comprobante($as_mes,$as_agno,$as_tipproben,$as_probendesde,$as_probenhasta,$ld_fecdes,$ld_fechas,$ls_numsol,$ls_tipo)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		switch($ls_tipo)
		{
			case "I":
				$codret="0000000001";
			break;
			case "M":
				$codret="0000000003";
			break;
			case "1":
				$codret="0000000005";
			break;
		}
		if(!empty($ld_fecdes))
		{
			$ld_fecdes = convertirFechaBd($ld_fecdes);
			$ls_criterio=$ls_criterio."		AND scb_cmp_ret.fecrep >= '".$ld_fecdes."'";
		}
		if(!empty($ld_fechas))
		{
			$ld_fechas = convertirFechaBd($ld_fechas);
			$ls_criterio=$ls_criterio."		AND scb_cmp_ret.fecrep <= '".$ld_fechas."'";
		}
		if(!empty($ls_codprobendes))
		{
			$ls_criterio=$ls_criterio."		AND scb_cmp_ret.codsujret >= '".$as_probendesde."'";
		}
		if(!empty($ls_codprobenhas))
		{
			$ls_criterio=$ls_criterio."		AND scb_cmp_ret.codsujret <= '".$as_probenhasta."'";
		}
		$ls_periodofiscal = $as_agno.$as_mes;
		$ls_where="";
		if(!empty($ls_numsol))
		{
			$ls_where=" AND scb_dt_cmp_ret.numsop='".$ls_numsol."'";
		}				
		$ls_sql="SELECT DISTINCT scb_cmp_ret.numcom, scb_cmp_ret.fecrep, scb_cmp_ret.perfiscal,scb_cmp_ret.codsujret,".
				"       scb_cmp_ret.nomsujret, scb_cmp_ret.dirsujret, scb_cmp_ret.rif,scb_dt_cmp_ret.codret,scb_cmp_ret.estcmpret ".
				"FROM scb_cmp_ret, scb_dt_cmp_ret ".
				"WHERE scb_cmp_ret.codemp = '".$_SESSION["la_empresa"]["codemp"]."' ".
				"  AND scb_cmp_ret.codret = '".$codret."' ".
				"  AND scb_cmp_ret.perfiscal = '".$ls_periodofiscal."' ".
				$ls_where.
				"	AND scb_cmp_ret.codemp = scb_dt_cmp_ret.codemp  ".
				"   AND scb_cmp_ret.codret = scb_dt_cmp_ret.codret ".
				"   AND scb_cmp_ret.numcom = scb_dt_cmp_ret.numcom ".
				$ls_criterio.
				" ORDER BY scb_cmp_ret.numcom ";
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
	    if ($resultado===false)
	    {
			$this->mensaje .= '  CLASE->Editar Comprobate MTODO->buscar_comprobante ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
		return $resultado;
		
	}
	
	public function buscar_solicitudpago($tipo_destino,$cod_proben,$fecdes,$fechas,$numsol,$consol,$tipo)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		if($tipo=='NCND')
		{
			$ls_aux=" AND (estprosol='C' OR estprosol='S')";			
		}
		else
		{
			$ls_aux="";
		}
		$ls_criterioproveedor="";
		if(!empty($tipo_destino)){
			switch ($tipo_destino)
			{
				case "P":
					$ls_codpro=$cod_proben;
					$ls_cedben="----------";
					$ls_criterioproveedor="   AND cod_pro = '".$ls_codpro."'".
										  "   AND ced_bene = '".$ls_cedben."'";
				break;
	
				case "B":
					$ls_codpro="----------";
					$ls_cedben=$cod_proben;
					$ls_criterioproveedor="   AND cod_pro = '".$ls_codpro."'".
										  "   AND ced_bene = '".$ls_cedben."'";
				break;
				
				default:
					$ls_codpro="";
					$ls_cedben="";
					$ls_criterioproveedor="   AND cod_pro LIKE '%".$ls_codpro."%'".
										  "   AND ced_bene LIKE '%".$ls_cedben."%'";
				break;
			}
		}
		if(!empty($numsol)){
			$ls_criterioproveedor = $ls_criterioproveedor." AND numsol LIKE '%".$numsol."%' ";
		}
		if(!empty($consol)){
			$ls_criterioproveedor = $ls_criterioproveedor." AND consol LIKE '%".$consol."%'";
		}
		if(!empty($fecdes) && !empty($fechas)){
			$ls_criterioproveedor = $ls_criterioproveedor."   AND fecemisol >= '".$fecdes."' ".
				                                          "   AND fecemisol <= '".$fechas."' ";
		}
		$ls_cadena = $this->conexionBaseDatos->Concat('rpc_beneficiario.nombene',"' '",'rpc_beneficiario.apebene');
		$ls_sql="SELECT cxp_solicitudes.numsol, cxp_solicitudes.cod_pro, cxp_solicitudes.ced_bene, cxp_solicitudes.codfuefin,".
				"       cxp_solicitudes.tipproben, cxp_solicitudes.fecemisol, cxp_solicitudes.consol, cxp_solicitudes.estprosol,".
				"       cxp_solicitudes.monsol, cxp_solicitudes.obssol, cxp_solicitudes.estaprosol, cxp_solicitudes.numordpagmin,".
				"       cxp_solicitudes.codtipfon,cxp_solicitudes.repcajchi,cxp_solicitudes.conanusol,cxp_solicitudes.nombenaltcre,".
				"       (CASE tipproben WHEN 'P' THEN (SELECT rpc_proveedor.nompro ".
				"                                      FROM rpc_proveedor ".
				"                                      WHERE rpc_proveedor.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_proveedor.cod_pro=cxp_solicitudes.cod_pro) ".
				"                       WHEN 'B' THEN (SELECT ".$ls_cadena." ".
				"                                      FROM rpc_beneficiario ".
				"                                      WHERE rpc_beneficiario.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_beneficiario.ced_bene=cxp_solicitudes.ced_bene) ". 
				"                       ELSE 'NINGUNO' END ) AS nombre, ".
				"       (CASE tipproben WHEN 'P' THEN (SELECT rpc_proveedor.sc_cuenta ".
				"                                      FROM rpc_proveedor ".
				"                                      WHERE rpc_proveedor.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_proveedor.cod_pro=cxp_solicitudes.cod_pro) ".
				"                       WHEN 'B' THEN (SELECT rpc_beneficiario.sc_cuenta ".
				"                                      FROM rpc_beneficiario ".
				"                                      WHERE rpc_beneficiario.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_beneficiario.ced_bene=cxp_solicitudes.ced_bene) ". 
				"                       ELSE 'NINGUNO' END ) AS sc_cuenta, ".
				"       (CASE tipproben WHEN 'P' THEN (SELECT scg_cuentas.denominacion ".
				"                                      FROM rpc_proveedor, scg_cuentas ".
				"                                      WHERE rpc_proveedor.codemp = scg_cuentas.codemp ".
				"										 AND rpc_proveedor.sc_cuenta = scg_cuentas.sc_cuenta ".
				"										 AND rpc_proveedor.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_proveedor.cod_pro=cxp_solicitudes.cod_pro) ".
				"                       WHEN 'B' THEN (SELECT scg_cuentas.denominacion ".
				"                                      FROM rpc_beneficiario, scg_cuentas ".
				"                                      WHERE rpc_beneficiario.codemp = scg_cuentas.codemp ".
				"										 AND rpc_beneficiario.sc_cuenta = scg_cuentas.sc_cuenta ".
				"										 AND rpc_beneficiario.codemp=cxp_solicitudes.codemp ".
				"                                        AND rpc_beneficiario.ced_bene=cxp_solicitudes.ced_bene) ". 
				"                       ELSE 'NINGUNO' END ) AS denscg, ".
				"       (CASE tipproben WHEN 'P' THEN (SELECT rpc_proveedor.rifpro  ". 
				"									   FROM rpc_proveedor   ".
				"									   WHERE rpc_proveedor.codemp=cxp_solicitudes.codemp ".
				"										 AND rpc_proveedor.cod_pro=cxp_solicitudes.cod_pro) ". 
				"						WHEN 'B' THEN (SELECT rpc_beneficiario.rifben ".
				"									   FROM rpc_beneficiario ".
				"									   WHERE rpc_beneficiario.codemp=cxp_solicitudes.codemp  ". 
				"									     AND rpc_beneficiario.ced_bene=cxp_solicitudes.ced_bene)  ". 
				"						  ELSE 'NINGUNO' END ) AS rifproben,".
				"       (SELECT denfuefin".
				"		 FROM sigesp_fuentefinanciamiento".
				"        WHERE sigesp_fuentefinanciamiento.codemp=cxp_solicitudes.codemp".
				"          AND sigesp_fuentefinanciamiento.codfuefin=cxp_solicitudes.codfuefin) AS denfuefin".
				"  FROM cxp_solicitudes ".	
				"  WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				$ls_criterioproveedor.
				$ls_aux.
				" ORDER BY cxp_solicitudes.numsol ASC";
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
	    if ($resultado===false)
	    {
			$this->mensaje .= '  CLASE->Editar Comprobate MTODO->buscar_solicitudpago ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }	
		return $resultado;
	}
	
	public function buscar_detcmpret($as_numcom,$as_codret)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$codret = "";
		switch($as_codret)
		{
			case "I":
				$codret="0000000001";
			break;
			case "M":
				$codret="0000000003";
			break;
			case "1":
				$codret="0000000005";
			break;
		}
		$ls_sql="SELECT numope,numfac,numcon,fecfac,totcmp_sin_iva,totcmp_con_iva, ".
				"       basimp,porimp,totimp,iva_ret,numdoc,codret,numsop,numnd, ".
				"       numnc,tiptrans ".
				"FROM scb_dt_cmp_ret  ".	
				"WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'  ".
				"  AND numcom= '".$as_numcom."' AND codret='".$codret."'";
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if ($resultado===false)
	    {
			$this->mensaje .= ' CLASE->Editar Comprobate MTODO->buscar_detcmpret ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }	
		return $resultado;
	} 

	function buscarUltimoCmp($codret)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$codigo = '';
		$cadenasql = " SELECT SUBSTR(numcom,7,9) as numcom ".
					 " FROM scb_cmp_ret ".
					 " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
					 "   AND codret='{$codret}' ".
					 " ORDER BY numcom DESC LIMIT 1";
		
		$resultado = $this->conexionBaseDatos->Execute($cadenasql);
		if($resultado->fields['numcom']=='')
	    {
			$this->mensaje .= ' CLASE->Editar Comprobate MTODO->buscarUltimoCmp ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
	    else{
	    	$codigo = $resultado->fields['numcom'];
	    }
		return $codigo;
	}
	
	function uf_delete_dt_cmpret($as_numcom,$as_codret)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$ls_sql="DELETE FROM scb_dt_cmp_ret  ".
				"WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				"  AND numcom='".$as_numcom."'".
				"  AND codret='".$as_codret."'";
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
	    {
			$this->mensaje .= ' CLASE->Editar Comprobate MTODO->uf_delete_dt_cmpret ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
		return $this->valido;
	}// end function uf_insert_recepciones
	
	public function actualizar_estcmp($as_numrecdoc,$as_codded)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido = true;
		if($as_codded=="0000000001"){
			$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE iva='1') ";
		}
		else if($as_codded=="0000000003")
		{
			$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE estretmun='1') ";
		}
		else if($as_codded=="0000000005")
		{
		 	$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE estretmil='1') ";
		}
		$ls_sql=" UPDATE cxp_rd_deducciones  ".
				" SET estcmp='0' ".
		        " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'  ".
				"   AND numrecdoc='".$as_numrecdoc."' ". 
				"   AND ".$cadena;
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
	    {
			$this->mensaje .= '  Error al actualizar el estatus del comprobante de cxp_rd_deducciones->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
	    return $this->valido;
	}
	
	public function eliminarComprobante($codemp,$objson,$arrevento)
	{
		$this->valido = true;
		$arrDet = $objson->detallesCmp;
		$codret = "";
		switch($objson->tiporet)
		{
			case "I":
				$codret="0000000001";
			break;
			case "M":
				$codret="0000000003";
			break;
			case "1":
				$codret="0000000005";
			break;
		}
		$codigo = $this->buscarUltimoCmp($codret);
		if($this->valido){
			$numero = $objson->numcom;
			$numcom = substr($numero,6,8);
			if(trim($codigo)==trim($numcom)){
				foreach($arrDet as $detalle){
					$this->valido = $this->uf_delete_dt_cmpret($numero,$codret);
					if($this->valido){
						$this->valido = $this->actualizar_estcmp($detalle->numfac,$codret);
					}
				}
				if($this->valido){
					$this->daoComprobante = FabricaDao::CrearDAO("N","scb_cmp_ret");
					//seteando la data e iniciando transaccion de base de datos
					$this->daoComprobante->codemp=$codemp;
					$this->daoComprobante->setData($objson);
					$this->daoComprobante->codret = $codret;
					DaoGenerico::iniciarTrans();
					if(!$this->daoComprobante->eliminar()){
						$this->mensaje .= ' Ocurrio un error al eliminar el comprobante->'.$this->conexionBaseDatos->ErrorMsg();
						$this->valido = false;
					}
					else{
						$this->mensaje .= ' ha sido eliminado con  &eacute;xito ->'.$this->conexionBaseDatos->ErrorMsg();
						$this->valido = true;
					}
				}
			}
			else{
				$strPK = " codemp='{$codemp}' AND codret='{$codret}' AND numcom='{$numero}' ";
		 		$this->daoComprobante = FabricaDao::CrearDAO('C','scb_cmp_ret',null,$strPK);
		 		$this->daoComprobante->estcmpret='0';
		 		DaoGenerico::iniciarTrans();
				if(!$this->daoComprobante->modificar()){
					$this->mensaje .= ' Ocurrio un error al modificar el estatus del comprobante->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}
				else{
					$this->mensaje .= ' ha sido guardado con  &eacute;xito en estatus Anulado ->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = true;
				}
			}
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
			
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento(); 		
			}
			else{
				$arrevento ['desevetra'] = $this->daoComprobante->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
		}
		return $this->valido;
	}
}
?>