<?php
$dirsrvrpc = "";
$dirsrvrpc = dirname(__FILE__);
$dirsrvrpc = str_replace("\\","/",$dirsrvrpc);
$dirsrvrpc = str_replace("/modelo/servicio/scb","",$dirsrvrpc); 
require_once ($dirsrvrpc."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvrpc."/modelo/servicio/scb/sigesp_srv_scb_ilistadoubicaciondocumentos.php");
require_once ($dirsrvrpc."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioDocumento implements ilistadoubicaciondocumentos {
	private $daoDocumento;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioDocumento() {
		$this->daoDocumento = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
	}
			
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarDatos($codemp, $as_tipoproben, $as_codproben, $as_fecdes, $as_fechas, $as_estcondoc, $as_estsol)
	{
	  $arrDatos=array();
	  $ls_cadaux = "";
	  $ls_filtroA="";
	  $ls_filtroB="";
	  
	  if ($as_fecdes!='' && $as_fechas!='') {
	  	  $as_fecdes = convertirFechaBd($as_fecdes);
	      $as_fechas = convertirFechaBd($as_fechas);
		 }
		 
	  if($as_tipoproben == 'P')
	  {
		 $ls_filtroA = " AND tipproben = 'P' AND cxp_solicitudes.cod_pro = '".$as_codproben."'";
		 $ls_filtroB = " AND tipo_destino = 'P' AND scb_movbco.cod_pro = '".$as_codproben."'";
	  }
	  else if($as_tipoproben == 'B')
	  	  {
		  	 $ls_filtroA = " AND tipproben = 'B' AND cxp_solicitudes.ced_bene = '".$as_codproben."' ";
		     $ls_filtroB = " AND tipo_destino = 'B' AND scb_movbco.ced_bene = '".$as_codproben."' ";
		  }
	  else if($as_tipoproben == 'N')
		  {
			 $ls_filtroA = " AND cxp_solicitudes.cod_pro = '".$as_codproben."' AND cxp_solicitudes.ced_bene = '".$as_codproben."' ";
			 $ls_filtroB = " AND scb_movbco.cod_pro = '".$as_codproben."' AND scb_movbco.ced_bene = '".$as_codproben." '";
		  }
		  
	  if ($as_estcondoc != 'T') 
	  {
		 $ls_filtroB = " AND scb_movbco.estcondoc='".$as_estcondoc."'";
	  }
	  
	  if ($as_estsol==0)
	  {
		$cadenasql = " 	SELECT scb_movbco.numdoc as numero, scb_movbco.fecmov as fecha, ".
					 " 	CASE scb_movbco.codope WHEN 'CH' THEN 'CH' ELSE 'CO' END as tipodoc, ".
					 " 		(scb_movbco.monto - scb_movbco.monret) as monto, scb_movbco.estcondoc as estado, ".
					 " 		 scb_movbco.fecenvfir, scb_movbco.fecenvcaj, ".			 
					 " (CASE WHEN tipo_destino='B' ".
					 "		 THEN 	(SELECT rpc_beneficiario.ced_bene||' - '||rpc_beneficiario.nombene||' '||rpc_beneficiario.apebene ".
					 "       		FROM rpc_beneficiario ".
					 "       		WHERE scb_movbco.ced_bene = rpc_beneficiario.ced_bene ".
					 "       		GROUP BY rpc_beneficiario.ced_bene,  rpc_beneficiario.nombene, rpc_beneficiario.apebene) ".
		             "       WHEN tipo_destino='P' ".
					 "		 THEN 	(SELECT rpc_proveedor.cod_pro||' - '||rpc_proveedor.nompro ".
					 "       	FROM rpc_proveedor ".
					 "       	WHERE scb_movbco.cod_pro = rpc_proveedor.cod_pro ".
					 "       	GROUP BY rpc_proveedor.cod_pro, rpc_proveedor.nompro) ". 
					 "       ELSE 'NINGUNO' END) as nombre ".
					 " 	FROM scb_movbco ".
					 " 	WHERE scb_movbco.codemp = '".$codemp."' ". 
					 " 	AND(scb_movbco.procede = 'SCBBCH' OR scb_movbco.procede = 'SCBCOR') ".
					 " 	AND scb_movbco.estmov <> 'A' ".
					 " 	AND scb_movbco.estmov <> 'O' ".
					 " 	AND ((scb_movbco.codope = 'CH' OR scb_movbco.codope = 'ND') AND (scb_movbco.codope <> 'DP' AND scb_movbco.codope <> 'OP')) ".
					 " 	AND scb_movbco.fecmov BETWEEN '".$as_fecdes."' AND '".$as_fechas."' ".
					 " 	".$ls_filtroB." ".
					 " 	ORDER BY tipodoc DESC";
	  }
	  else
	  {
		$cadenasql = " 	SELECT 	cxp_solicitudes.numsol as numero, cxp_solicitudes.fecemisol as fecha, 'SP' as tipodoc, ".
					 " 			cxp_solicitudes.monsol as monto, coalesce(scb_prog_pago.estmov, 'X') as estado, ". 
					 " 			'1900-01-01' as fecenvfir, '1900-01-01' as fecenvcaj, ".
					 " 	(CASE WHEN tipproben='B' ".
					 "		  THEN	(SELECT rpc_beneficiario.ced_bene||' - '||rpc_beneficiario.nombene||' '||rpc_beneficiario.apebene ".
					 "        		FROM rpc_beneficiario ".
					 "              WHERE cxp_solicitudes.ced_bene = rpc_beneficiario.ced_bene ".
					 "              GROUP BY rpc_beneficiario.ced_bene, rpc_beneficiario.nombene, rpc_beneficiario.apebene) ".
		             "       WHEN 	tipproben='P' ". 
					 "		 THEN 	(SELECT rpc_proveedor.cod_pro||' - '||rpc_proveedor.nompro ".
					 "             	FROM rpc_proveedor ".
					 "             	WHERE cxp_solicitudes.cod_pro = rpc_proveedor.cod_pro ".
					 "             	GROUP BY rpc_proveedor.cod_pro, rpc_proveedor.nompro) ". 
					 " 		 ELSE 	'NINGUNO' END) as nombre ". 
					 " 	FROM cxp_solicitudes ".
					 " 	LEFT JOIN scb_prog_pago ".
					 " 	ON cxp_solicitudes.numsol = scb_prog_pago.numsol ".
					 " 	WHERE cxp_solicitudes.fecemisol BETWEEN '".$as_fecdes."' AND '".$as_fechas."' ".
					 " 	".$ls_filtroA." ". 
					 " 	UNION ".
					 " 	SELECT scb_movbco.numdoc as numero, scb_movbco.fecmov as fecha, ".
					 " 	CASE scb_movbco.codope WHEN 'CH' THEN 'CH' ELSE 'CO' END as tipodoc, ".
					 " 		(scb_movbco.monto - scb_movbco.monret) as monto, scb_movbco.estcondoc as estado, ".
					 " 		scb_movbco.fecenvfir, scb_movbco.fecenvcaj, ".
					 " (CASE WHEN 	tipo_destino = 'B' ". 
					 "		 THEN 	(SELECT rpc_beneficiario.ced_bene||' - '||rpc_beneficiario.nombene||' '||rpc_beneficiario.apebene ".
					 "           	FROM rpc_beneficiario ".
					 "              WHERE scb_movbco.ced_bene = rpc_beneficiario.ced_bene ".
					 "              GROUP BY rpc_beneficiario.ced_bene, rpc_beneficiario.nombene, rpc_beneficiario.apebene) ".
		             "       WHEN 	tipo_destino = 'P' ". 
					 "		 THEN 	(SELECT rpc_proveedor.cod_pro||' - '||rpc_proveedor.nompro ".
					 "            	FROM rpc_proveedor ".
					 "              WHERE scb_movbco.cod_pro = rpc_proveedor.cod_pro ".
					 "              GROUP BY rpc_proveedor.cod_pro, rpc_proveedor.nompro) ". 
					 "       ELSE 	'NINGUNO' END) as nombre ".
					 " 	FROM scb_movbco ".
					 " 	WHERE scb_movbco.codemp = '".$codemp."' ". 
					 " 	AND(scb_movbco.procede = 'SCBBCH' OR scb_movbco.procede = 'SCBCOR') ". 
					 " 	AND scb_movbco.estmov <> 'A' ". 
					 " 	AND scb_movbco.estmov <> 'O' ".
					 " 	AND ((scb_movbco.codope = 'CH' OR scb_movbco.codope = 'ND') AND (scb_movbco.codope <> 'DP' AND scb_movbco.codope <> 'OP')) ". 
					 " 	AND scb_movbco.fecmov BETWEEN '".$as_fecdes."' AND '".$as_fechas."' ".
					 " 	".$ls_filtroB." ".
					 " 	ORDER BY tipodoc DESC";	  
		}
		//echo $cadenasql;
		//break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			$j=0;
			while((!$resultado->EOF))
			{
				$ls_numero = $resultado->fields["numero"];
				$ls_fecha = $resultado->fields["fecha"];
				$ls_nombre = $resultado->fields["nombre"];
				$ls_tipodoc = $resultado->fields["tipodoc"];
				$ls_monto = $resultado->fields["monto"];
				$ls_estatus = $resultado->fields["estado"];
				$ls_detest  = "";
	  			$ls_fecenv  = "N/A";
				
				if ($ls_tipodoc!='SP') 
				{
					switch ($ls_estatus) 
					{
						case 'S':
							$ls_detest = 'Emitido';
							$arrDatos[$j]['numero'] = $ls_numero;
							$arrDatos[$j]['fecha'] = $ls_fecha;
							$arrDatos[$j]['nombre'] = $ls_nombre;
							$arrDatos[$j]['tipodoc'] = $ls_tipodoc;
							$arrDatos[$j]['monto'] = number_format($ls_monto,2,",",".");
							$arrDatos[$j]['estado'] = $ls_estatus;
							$arrDatos[$j]['fecenv'] = $ls_fecenv;
							$j++;
						break;
						
						case 'F':
							$ls_detest = 'Enviado a la Firma';
							$ls_fecenv = convertirFechaBd($resultado->fields['fecenvfir']);
							$arrDatos[$j]['numero'] = $ls_numero;
							$arrDatos[$j]['fecha'] = $ls_fecha;
							$arrDatos[$j]['nombre'] = $ls_nombre;
							$arrDatos[$j]['tipodoc'] = $ls_tipodoc;
							$arrDatos[$j]['monto'] = $ls_monto;
							$arrDatos[$j]['estado'] = $ls_estatus;
							$arrDatos[$j]['fecenv'] = $ls_fecenv;
							$j++;
						break;
					
						case 'C':
							$ls_detest = 'Enviado a Caja';
							$ls_fecenv = convertirFechaBd($resultado->fields['fecenvcaj']);
							$arrDatos[$j]['numero'] = $ls_numero;
							$arrDatos[$j]['fecha'] = $ls_fecha;
							$arrDatos[$j]['nombre'] = $ls_nombre;
							$arrDatos[$j]['tipodoc'] = $ls_tipodoc;
							$arrDatos[$j]['monto'] = $ls_monto;
							$arrDatos[$j]['estado'] = $ls_estatus;
							$arrDatos[$j]['fecenv'] = $ls_fecenv;
							$j++;
						break;
							
						case 'E':
							$ls_detest = 'Entregado';
							$ls_fecenv = convertirFechaBd($resultado->fields['fecenvcaj']);
							$arrDatos[$j]['numero'] = $ls_numero;
							$arrDatos[$j]['fecha'] = $ls_fecha;
							$arrDatos[$j]['nombre'] = $ls_nombre;
							$arrDatos[$j]['tipodoc'] = $ls_tipodoc;
							$arrDatos[$j]['monto'] = $ls_monto;
							$arrDatos[$j]['estado'] = $ls_estatus;
							$arrDatos[$j]['fecenv'] = $ls_fecenv;
							$j++;
						break;
					}
				}
				else
				{
					if($ls_estatus=='X')
					{
							$ls_detest = 'Por programar pago';
							$arrDatos[$j]['numero'] = $ls_numero;
							$arrDatos[$j]['fecha'] = $ls_fecha;
							$arrDatos[$j]['nombre'] = $ls_nombre;
							$arrDatos[$j]['tipodoc'] = $ls_tipodoc;
							$arrDatos[$j]['monto'] = $ls_monto;
							$arrDatos[$j]['estado'] = $ls_estatus;
							$arrDatos[$j]['fecenv'] = $ls_fecenv;
						$j++;
					}
				}
			$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $arrDatos;
	}
				
}
?>