<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio parametro clasificacion, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface imodcmpret 
{
			
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Funcion que se encarga de buscar los comprobantes de retencion existentes 
	 * @param string $as_mes - mes actual
	 * @param string $as_agno - año actual
	 * @param string $as_probendesde - rango desde de proveedor o beneficiario
	 * @param string $as_probenhasta - rango hasta de  proveedor o beneficiario
	 * @param string $as_tipproben - tipo (proveedor->P) o (beneficiario->B)
	 * @param string $ls_numsol - numero de recepcion del documento
	 * @param string $ld_fecdes - rango de fecha desde del comprobante
	 * @param string $ld_fechas - rango de fecha hasta del comprobante 
	 * @param string $ls_tipo - tipo del comprobante (IVA-Municipal-1x1000)
	 * @return Resulset Adodb con los datos de los comprobantes de retencion existentes. 
	 */
	public function buscar_comprobante($as_mes,$as_agno,$as_tipproben,$as_probendesde,$as_probenhasta,$ld_fecdes,$ld_fechas,$ls_numsol,$ls_tipo);

	/**
	 * @author 
	 * @desc Funcion que busca las solicitudes de pago existentes 
	 * @param string $tipo_destino - tipo-> si de proveedor o beneficiario
	 * @param string $cod_proben - codigo del proveedor o beneficiario
	 * @param string $fecdes - rango de fecha desde de la solicitud 
	 * @param string $fechas - rango de fecha hasta de la solicitud
	 * @param string $numsol - numero de la solicitud
	 * @param string $consol - concepto de la solicitud
	 * @param string $tipo - tipo (REPDES-NCND)
	 * @return Resulset Adodb con los datos de las solicitudes de pago existentes. 
	 */
	public function buscar_solicitudpago($tipo_destino,$cod_proben,$fecdes,$fechas,$numsol,$consol,$tipo);

	/**
	 * @author 
	 * @desc Funcion que se encarga de buscar los detalles de un comprobantes de retencion  
	 * @param string $as_numcom - numero del comprobante de retencion
	 * @param string $as_codret - tipo del comprobante (IVA-Municipal-1x1000)
	 * @return Resulset Adodb con los datos de los detalles del comprobantes de retencion. 
	 */
	public function buscar_detcmpret($as_numcom,$as_codret);
	
	/**
	 * @author 
	 * @desc Funcion que se encarga de eliminar el comprobante de retencion en caso de ser el ultimo registro, sino cambio su estatus->Anulado 
	 * @param string $codemp - codigo de la empresa
	 * @param Json $objson
	 * @param array $arrevento
	 * @return Resulset Adodb $valido - numero que indica si el proceso fue efectivo, y $mensaje - mensaje a imprimir. 
	 */
	public function eliminarComprobante($codemp,$objson,$arrevento);
}