<?php
/**
 * @author Ingeniero Domingo Calicchio
 * @desc Interfaz del servicio de conciliacion bancaria, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface IConciliacion {
	
	/**
	 * @author Ingeniero Domingo Calicchio
	 * @desc Metodo que busca los movimiento de banco pendientes por conciliar
	 * @param string $codemp - codigo de empresa
	 * @param string $codban - codigo banco
	 * @param string $ctaban - cuenta banco
	 * @param string $fechadesde - fecha desde
	 * @param string $fechahasta - fecha hasta
	 * @param string $filtro - cadena que indica el tipo de operacion que deben tener los registros
	 * @return array arreglo con los datos de los movimientos a conciliar
	 */
	public function buscarMovimientoConciliar($codemp, $codban, $ctaban, $fechadesde, $fechahasta, $filtro);
	
	/**
	 * @author Ingeniero Domingo Calicchio
	 * @desc Metodo para obtener los datos de la conciliacion si esta existe
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $periodo - periodo de la conciliacion
	 * @return array $arrConciliacion - arreglo con los datos de la conciliacion 
	 */
	public function buscarConciliacion($codemp, $codbanco, $ctabanco, $periodo);

	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca los bancos
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $desbanco - descripcion banco
	 * @return resulset con los datos de los bancos
	 */
	public function buscarBanco($codemp, $codbanco, $desbanco);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca las cuentas bancarias requeridas
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $codusu - codigo de usuario
	 * @return resulset con los datos de las cuentas bancarias
	 */
	public function buscarCuentaBanco($codemp, $codbanco, $codusu);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para obtener el saldo de una cuenta bancaria
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @return string saldo de la cuenta
	 */
	public function obtenerSaldoCuentaBanco($codemp, $codbanco, $ctabanco);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para obtener el saldo segun libro de una cuenta bancaria
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $fecha - fecha de los movimientos
	 * @return string saldo segun libro de la cuenta
	 */
	public function obtenerSaldoSegunLibro($codemp, $codbanco, $ctabanco, $fecha);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para obtener el saldo de las transacciones no registradas en libro
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $fechadesde - fecha desde
	 * @param string $fechahasta - fecha hasta
	 * @return string saldo de las transacciones no registradas en libro
	 */
	public function obtenerTransNoRegLibro($codemp, $codbanco, $ctabanco, $fechadesde, $fechahasta);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para obtener el saldo de los errores en banco
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $periodo - periodo de la conciliacion
	 * @return string saldo de los errores en banco 
	 */
	public function obtenerErrorBanco($codemp, $codbanco, $ctabanco, $periodo);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para obtener el saldo de los errores en libro
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $fechadesde - fecha desde
	 * @param string $fechahasta - fecha hasta
	 * @return string saldo de los errores en libro
	 */
	public function obtenerErrorLibro($codemp, $codbanco, $ctabanco, $fechadesde, $fechahasta);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para procesar la conciliacion bancaria 
	 * @param string $codemp - codigo de empresa
	 * @param json   $arrJson - arreglo json con los datos a procesar de la conciliacion
	 * @param array  $arrEvento - arreglo con los datos para el log de transacciones
	 * @return boolean $resultado - retorna verdadero si la conciliacion fue procesada con exito.
	 */
	public function procesarConciliacion($codemp, $arrJson, $arrEvento);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo para cambiar el estatus de la conciliacion de cerrada a abierta
	 * @param string $codemp - codigo de empresa
	 * @param string $codbanco - codigo banco
	 * @param string $ctabanco - codigo de la cuenta bancaria
	 * @param string $periodo - periodo de la conciliacion
	 * @return string $abrirConciliacion -toma los valores 0 o 1 si cambia o no el estatus de la conciliacion. 
	 */
	public function abrirConciliacion($codemp, $codbanco, $ctabanco, $periodo);
	
}